/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Access Atomix's distributed map.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface AtomixMapEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Atomix Map component.
     */
    public interface AtomixMapEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedAtomixMapEndpointConsumerBuilder advanced() {
            return (AdvancedAtomixMapEndpointConsumerBuilder) this;
        }
        /**
         * The Atomix instance to use.
         * 
         * The option is a: &lt;code&gt;io.atomix.Atomix&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param atomix the value to set
         * @return the dsl builder
         */
        default AtomixMapEndpointConsumerBuilder atomix(io.atomix.Atomix atomix) {
            doSetProperty("atomix", atomix);
            return this;
        }
        /**
         * The Atomix instance to use.
         * 
         * The option will be converted to a
         * &lt;code&gt;io.atomix.Atomix&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param atomix the value to set
         * @return the dsl builder
         */
        default AtomixMapEndpointConsumerBuilder atomix(String atomix) {
            doSetProperty("atomix", atomix);
            return this;
        }
        /**
         * The Atomix configuration uri.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param configurationUri the value to set
         * @return the dsl builder
         */
        default AtomixMapEndpointConsumerBuilder configurationUri(
                String configurationUri) {
            doSetProperty("configurationUri", configurationUri);
            return this;
        }
        /**
         * The default action.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.atomix.client.map.AtomixMap.Action&lt;/code&gt; type.
         * 
         * Default: PUT
         * Group: common
         * 
         * @param defaultAction the value to set
         * @return the dsl builder
         */
        default AtomixMapEndpointConsumerBuilder defaultAction(
                org.apache.camel.component.atomix.client.map.AtomixMap.Action defaultAction) {
            doSetProperty("defaultAction", defaultAction);
            return this;
        }
        /**
         * The default action.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.atomix.client.map.AtomixMap.Action&lt;/code&gt; type.
         * 
         * Default: PUT
         * Group: common
         * 
         * @param defaultAction the value to set
         * @return the dsl builder
         */
        default AtomixMapEndpointConsumerBuilder defaultAction(
                String defaultAction) {
            doSetProperty("defaultAction", defaultAction);
            return this;
        }
        /**
         * The key to use if none is set in the header or to listen for events
         * for a specific key.
         * 
         * The option is a: &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param key the value to set
         * @return the dsl builder
         */
        default AtomixMapEndpointConsumerBuilder key(Object key) {
            doSetProperty("key", key);
            return this;
        }
        /**
         * The key to use if none is set in the header or to listen for events
         * for a specific key.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param key the value to set
         * @return the dsl builder
         */
        default AtomixMapEndpointConsumerBuilder key(String key) {
            doSetProperty("key", key);
            return this;
        }
        /**
         * The address of the nodes composing the cluster.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param nodes the value to set
         * @return the dsl builder
         */
        default AtomixMapEndpointConsumerBuilder nodes(String nodes) {
            doSetProperty("nodes", nodes);
            return this;
        }
        /**
         * The header that wil carry the result.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param resultHeader the value to set
         * @return the dsl builder
         */
        default AtomixMapEndpointConsumerBuilder resultHeader(
                String resultHeader) {
            doSetProperty("resultHeader", resultHeader);
            return this;
        }
        /**
         * The class name (fqn) of the Atomix transport.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: io.atomix.catalyst.transport.netty.NettyTransport
         * Group: common
         * 
         * @param transportClassName the value to set
         * @return the dsl builder
         */
        default AtomixMapEndpointConsumerBuilder transportClassName(
                String transportClassName) {
            doSetProperty("transportClassName", transportClassName);
            return this;
        }
        /**
         * The resource ttl.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param ttl the value to set
         * @return the dsl builder
         */
        default AtomixMapEndpointConsumerBuilder ttl(long ttl) {
            doSetProperty("ttl", ttl);
            return this;
        }
        /**
         * The resource ttl.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param ttl the value to set
         * @return the dsl builder
         */
        default AtomixMapEndpointConsumerBuilder ttl(String ttl) {
            doSetProperty("ttl", ttl);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AtomixMapEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AtomixMapEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Atomix Map component.
     */
    public interface AdvancedAtomixMapEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AtomixMapEndpointConsumerBuilder basic() {
            return (AtomixMapEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMapEndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMapEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMapEndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMapEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * The cluster wide default resource configuration.
         * 
         * The option is a: &lt;code&gt;java.util.Properties&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param defaultResourceConfig the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMapEndpointConsumerBuilder defaultResourceConfig(
                Properties defaultResourceConfig) {
            doSetProperty("defaultResourceConfig", defaultResourceConfig);
            return this;
        }
        /**
         * The cluster wide default resource configuration.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Properties&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param defaultResourceConfig the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMapEndpointConsumerBuilder defaultResourceConfig(
                String defaultResourceConfig) {
            doSetProperty("defaultResourceConfig", defaultResourceConfig);
            return this;
        }
        /**
         * The local default resource options.
         * 
         * The option is a: &lt;code&gt;java.util.Properties&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param defaultResourceOptions the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMapEndpointConsumerBuilder defaultResourceOptions(
                Properties defaultResourceOptions) {
            doSetProperty("defaultResourceOptions", defaultResourceOptions);
            return this;
        }
        /**
         * The local default resource options.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Properties&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param defaultResourceOptions the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMapEndpointConsumerBuilder defaultResourceOptions(
                String defaultResourceOptions) {
            doSetProperty("defaultResourceOptions", defaultResourceOptions);
            return this;
        }
        /**
         * Sets if the local member should join groups as PersistentMember or
         * not. If set to ephemeral the local member will receive an auto
         * generated ID thus the local one is ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param ephemeral the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMapEndpointConsumerBuilder ephemeral(
                boolean ephemeral) {
            doSetProperty("ephemeral", ephemeral);
            return this;
        }
        /**
         * Sets if the local member should join groups as PersistentMember or
         * not. If set to ephemeral the local member will receive an auto
         * generated ID thus the local one is ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param ephemeral the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMapEndpointConsumerBuilder ephemeral(
                String ephemeral) {
            doSetProperty("ephemeral", ephemeral);
            return this;
        }
        /**
         * The read consistency level.
         * 
         * The option is a:
         * &lt;code&gt;io.atomix.resource.ReadConsistency&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param readConsistency the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMapEndpointConsumerBuilder readConsistency(
                io.atomix.resource.ReadConsistency readConsistency) {
            doSetProperty("readConsistency", readConsistency);
            return this;
        }
        /**
         * The read consistency level.
         * 
         * The option will be converted to a
         * &lt;code&gt;io.atomix.resource.ReadConsistency&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param readConsistency the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMapEndpointConsumerBuilder readConsistency(
                String readConsistency) {
            doSetProperty("readConsistency", readConsistency);
            return this;
        }
        /**
         * Cluster wide resources configuration.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.util.Properties&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param resourceConfigs the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMapEndpointConsumerBuilder resourceConfigs(
                Map<java.lang.String, java.util.Properties> resourceConfigs) {
            doSetProperty("resourceConfigs", resourceConfigs);
            return this;
        }
        /**
         * Cluster wide resources configuration.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.util.Properties&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param resourceConfigs the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMapEndpointConsumerBuilder resourceConfigs(
                String resourceConfigs) {
            doSetProperty("resourceConfigs", resourceConfigs);
            return this;
        }
        /**
         * Local resources configurations.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.util.Properties&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param resourceOptions the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMapEndpointConsumerBuilder resourceOptions(
                Map<java.lang.String, java.util.Properties> resourceOptions) {
            doSetProperty("resourceOptions", resourceOptions);
            return this;
        }
        /**
         * Local resources configurations.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.util.Properties&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param resourceOptions the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMapEndpointConsumerBuilder resourceOptions(
                String resourceOptions) {
            doSetProperty("resourceOptions", resourceOptions);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Atomix Map component.
     */
    public interface AtomixMapEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedAtomixMapEndpointProducerBuilder advanced() {
            return (AdvancedAtomixMapEndpointProducerBuilder) this;
        }
        /**
         * The Atomix instance to use.
         * 
         * The option is a: &lt;code&gt;io.atomix.Atomix&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param atomix the value to set
         * @return the dsl builder
         */
        default AtomixMapEndpointProducerBuilder atomix(io.atomix.Atomix atomix) {
            doSetProperty("atomix", atomix);
            return this;
        }
        /**
         * The Atomix instance to use.
         * 
         * The option will be converted to a
         * &lt;code&gt;io.atomix.Atomix&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param atomix the value to set
         * @return the dsl builder
         */
        default AtomixMapEndpointProducerBuilder atomix(String atomix) {
            doSetProperty("atomix", atomix);
            return this;
        }
        /**
         * The Atomix configuration uri.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param configurationUri the value to set
         * @return the dsl builder
         */
        default AtomixMapEndpointProducerBuilder configurationUri(
                String configurationUri) {
            doSetProperty("configurationUri", configurationUri);
            return this;
        }
        /**
         * The default action.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.atomix.client.map.AtomixMap.Action&lt;/code&gt; type.
         * 
         * Default: PUT
         * Group: common
         * 
         * @param defaultAction the value to set
         * @return the dsl builder
         */
        default AtomixMapEndpointProducerBuilder defaultAction(
                org.apache.camel.component.atomix.client.map.AtomixMap.Action defaultAction) {
            doSetProperty("defaultAction", defaultAction);
            return this;
        }
        /**
         * The default action.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.atomix.client.map.AtomixMap.Action&lt;/code&gt; type.
         * 
         * Default: PUT
         * Group: common
         * 
         * @param defaultAction the value to set
         * @return the dsl builder
         */
        default AtomixMapEndpointProducerBuilder defaultAction(
                String defaultAction) {
            doSetProperty("defaultAction", defaultAction);
            return this;
        }
        /**
         * The key to use if none is set in the header or to listen for events
         * for a specific key.
         * 
         * The option is a: &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param key the value to set
         * @return the dsl builder
         */
        default AtomixMapEndpointProducerBuilder key(Object key) {
            doSetProperty("key", key);
            return this;
        }
        /**
         * The key to use if none is set in the header or to listen for events
         * for a specific key.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param key the value to set
         * @return the dsl builder
         */
        default AtomixMapEndpointProducerBuilder key(String key) {
            doSetProperty("key", key);
            return this;
        }
        /**
         * The address of the nodes composing the cluster.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param nodes the value to set
         * @return the dsl builder
         */
        default AtomixMapEndpointProducerBuilder nodes(String nodes) {
            doSetProperty("nodes", nodes);
            return this;
        }
        /**
         * The header that wil carry the result.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param resultHeader the value to set
         * @return the dsl builder
         */
        default AtomixMapEndpointProducerBuilder resultHeader(
                String resultHeader) {
            doSetProperty("resultHeader", resultHeader);
            return this;
        }
        /**
         * The class name (fqn) of the Atomix transport.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: io.atomix.catalyst.transport.netty.NettyTransport
         * Group: common
         * 
         * @param transportClassName the value to set
         * @return the dsl builder
         */
        default AtomixMapEndpointProducerBuilder transportClassName(
                String transportClassName) {
            doSetProperty("transportClassName", transportClassName);
            return this;
        }
        /**
         * The resource ttl.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param ttl the value to set
         * @return the dsl builder
         */
        default AtomixMapEndpointProducerBuilder ttl(long ttl) {
            doSetProperty("ttl", ttl);
            return this;
        }
        /**
         * The resource ttl.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param ttl the value to set
         * @return the dsl builder
         */
        default AtomixMapEndpointProducerBuilder ttl(String ttl) {
            doSetProperty("ttl", ttl);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AtomixMapEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AtomixMapEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Atomix Map component.
     */
    public interface AdvancedAtomixMapEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AtomixMapEndpointProducerBuilder basic() {
            return (AtomixMapEndpointProducerBuilder) this;
        }
        /**
         * The cluster wide default resource configuration.
         * 
         * The option is a: &lt;code&gt;java.util.Properties&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param defaultResourceConfig the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMapEndpointProducerBuilder defaultResourceConfig(
                Properties defaultResourceConfig) {
            doSetProperty("defaultResourceConfig", defaultResourceConfig);
            return this;
        }
        /**
         * The cluster wide default resource configuration.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Properties&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param defaultResourceConfig the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMapEndpointProducerBuilder defaultResourceConfig(
                String defaultResourceConfig) {
            doSetProperty("defaultResourceConfig", defaultResourceConfig);
            return this;
        }
        /**
         * The local default resource options.
         * 
         * The option is a: &lt;code&gt;java.util.Properties&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param defaultResourceOptions the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMapEndpointProducerBuilder defaultResourceOptions(
                Properties defaultResourceOptions) {
            doSetProperty("defaultResourceOptions", defaultResourceOptions);
            return this;
        }
        /**
         * The local default resource options.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Properties&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param defaultResourceOptions the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMapEndpointProducerBuilder defaultResourceOptions(
                String defaultResourceOptions) {
            doSetProperty("defaultResourceOptions", defaultResourceOptions);
            return this;
        }
        /**
         * Sets if the local member should join groups as PersistentMember or
         * not. If set to ephemeral the local member will receive an auto
         * generated ID thus the local one is ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param ephemeral the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMapEndpointProducerBuilder ephemeral(
                boolean ephemeral) {
            doSetProperty("ephemeral", ephemeral);
            return this;
        }
        /**
         * Sets if the local member should join groups as PersistentMember or
         * not. If set to ephemeral the local member will receive an auto
         * generated ID thus the local one is ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param ephemeral the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMapEndpointProducerBuilder ephemeral(
                String ephemeral) {
            doSetProperty("ephemeral", ephemeral);
            return this;
        }
        /**
         * The read consistency level.
         * 
         * The option is a:
         * &lt;code&gt;io.atomix.resource.ReadConsistency&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param readConsistency the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMapEndpointProducerBuilder readConsistency(
                io.atomix.resource.ReadConsistency readConsistency) {
            doSetProperty("readConsistency", readConsistency);
            return this;
        }
        /**
         * The read consistency level.
         * 
         * The option will be converted to a
         * &lt;code&gt;io.atomix.resource.ReadConsistency&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param readConsistency the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMapEndpointProducerBuilder readConsistency(
                String readConsistency) {
            doSetProperty("readConsistency", readConsistency);
            return this;
        }
        /**
         * Cluster wide resources configuration.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.util.Properties&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param resourceConfigs the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMapEndpointProducerBuilder resourceConfigs(
                Map<java.lang.String, java.util.Properties> resourceConfigs) {
            doSetProperty("resourceConfigs", resourceConfigs);
            return this;
        }
        /**
         * Cluster wide resources configuration.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.util.Properties&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param resourceConfigs the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMapEndpointProducerBuilder resourceConfigs(
                String resourceConfigs) {
            doSetProperty("resourceConfigs", resourceConfigs);
            return this;
        }
        /**
         * Local resources configurations.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.util.Properties&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param resourceOptions the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMapEndpointProducerBuilder resourceOptions(
                Map<java.lang.String, java.util.Properties> resourceOptions) {
            doSetProperty("resourceOptions", resourceOptions);
            return this;
        }
        /**
         * Local resources configurations.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.util.Properties&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param resourceOptions the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMapEndpointProducerBuilder resourceOptions(
                String resourceOptions) {
            doSetProperty("resourceOptions", resourceOptions);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Atomix Map component.
     */
    public interface AtomixMapEndpointBuilder
            extends
                AtomixMapEndpointConsumerBuilder,
                AtomixMapEndpointProducerBuilder {
        default AdvancedAtomixMapEndpointBuilder advanced() {
            return (AdvancedAtomixMapEndpointBuilder) this;
        }
        /**
         * The Atomix instance to use.
         * 
         * The option is a: &lt;code&gt;io.atomix.Atomix&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param atomix the value to set
         * @return the dsl builder
         */
        default AtomixMapEndpointBuilder atomix(io.atomix.Atomix atomix) {
            doSetProperty("atomix", atomix);
            return this;
        }
        /**
         * The Atomix instance to use.
         * 
         * The option will be converted to a
         * &lt;code&gt;io.atomix.Atomix&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param atomix the value to set
         * @return the dsl builder
         */
        default AtomixMapEndpointBuilder atomix(String atomix) {
            doSetProperty("atomix", atomix);
            return this;
        }
        /**
         * The Atomix configuration uri.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param configurationUri the value to set
         * @return the dsl builder
         */
        default AtomixMapEndpointBuilder configurationUri(
                String configurationUri) {
            doSetProperty("configurationUri", configurationUri);
            return this;
        }
        /**
         * The default action.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.atomix.client.map.AtomixMap.Action&lt;/code&gt; type.
         * 
         * Default: PUT
         * Group: common
         * 
         * @param defaultAction the value to set
         * @return the dsl builder
         */
        default AtomixMapEndpointBuilder defaultAction(
                org.apache.camel.component.atomix.client.map.AtomixMap.Action defaultAction) {
            doSetProperty("defaultAction", defaultAction);
            return this;
        }
        /**
         * The default action.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.atomix.client.map.AtomixMap.Action&lt;/code&gt; type.
         * 
         * Default: PUT
         * Group: common
         * 
         * @param defaultAction the value to set
         * @return the dsl builder
         */
        default AtomixMapEndpointBuilder defaultAction(String defaultAction) {
            doSetProperty("defaultAction", defaultAction);
            return this;
        }
        /**
         * The key to use if none is set in the header or to listen for events
         * for a specific key.
         * 
         * The option is a: &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param key the value to set
         * @return the dsl builder
         */
        default AtomixMapEndpointBuilder key(Object key) {
            doSetProperty("key", key);
            return this;
        }
        /**
         * The key to use if none is set in the header or to listen for events
         * for a specific key.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param key the value to set
         * @return the dsl builder
         */
        default AtomixMapEndpointBuilder key(String key) {
            doSetProperty("key", key);
            return this;
        }
        /**
         * The address of the nodes composing the cluster.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param nodes the value to set
         * @return the dsl builder
         */
        default AtomixMapEndpointBuilder nodes(String nodes) {
            doSetProperty("nodes", nodes);
            return this;
        }
        /**
         * The header that wil carry the result.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param resultHeader the value to set
         * @return the dsl builder
         */
        default AtomixMapEndpointBuilder resultHeader(String resultHeader) {
            doSetProperty("resultHeader", resultHeader);
            return this;
        }
        /**
         * The class name (fqn) of the Atomix transport.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: io.atomix.catalyst.transport.netty.NettyTransport
         * Group: common
         * 
         * @param transportClassName the value to set
         * @return the dsl builder
         */
        default AtomixMapEndpointBuilder transportClassName(
                String transportClassName) {
            doSetProperty("transportClassName", transportClassName);
            return this;
        }
        /**
         * The resource ttl.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param ttl the value to set
         * @return the dsl builder
         */
        default AtomixMapEndpointBuilder ttl(long ttl) {
            doSetProperty("ttl", ttl);
            return this;
        }
        /**
         * The resource ttl.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param ttl the value to set
         * @return the dsl builder
         */
        default AtomixMapEndpointBuilder ttl(String ttl) {
            doSetProperty("ttl", ttl);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Atomix Map component.
     */
    public interface AdvancedAtomixMapEndpointBuilder
            extends
                AdvancedAtomixMapEndpointConsumerBuilder,
                AdvancedAtomixMapEndpointProducerBuilder {
        default AtomixMapEndpointBuilder basic() {
            return (AtomixMapEndpointBuilder) this;
        }
        /**
         * The cluster wide default resource configuration.
         * 
         * The option is a: &lt;code&gt;java.util.Properties&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param defaultResourceConfig the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMapEndpointBuilder defaultResourceConfig(
                Properties defaultResourceConfig) {
            doSetProperty("defaultResourceConfig", defaultResourceConfig);
            return this;
        }
        /**
         * The cluster wide default resource configuration.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Properties&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param defaultResourceConfig the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMapEndpointBuilder defaultResourceConfig(
                String defaultResourceConfig) {
            doSetProperty("defaultResourceConfig", defaultResourceConfig);
            return this;
        }
        /**
         * The local default resource options.
         * 
         * The option is a: &lt;code&gt;java.util.Properties&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param defaultResourceOptions the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMapEndpointBuilder defaultResourceOptions(
                Properties defaultResourceOptions) {
            doSetProperty("defaultResourceOptions", defaultResourceOptions);
            return this;
        }
        /**
         * The local default resource options.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Properties&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param defaultResourceOptions the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMapEndpointBuilder defaultResourceOptions(
                String defaultResourceOptions) {
            doSetProperty("defaultResourceOptions", defaultResourceOptions);
            return this;
        }
        /**
         * Sets if the local member should join groups as PersistentMember or
         * not. If set to ephemeral the local member will receive an auto
         * generated ID thus the local one is ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param ephemeral the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMapEndpointBuilder ephemeral(boolean ephemeral) {
            doSetProperty("ephemeral", ephemeral);
            return this;
        }
        /**
         * Sets if the local member should join groups as PersistentMember or
         * not. If set to ephemeral the local member will receive an auto
         * generated ID thus the local one is ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param ephemeral the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMapEndpointBuilder ephemeral(String ephemeral) {
            doSetProperty("ephemeral", ephemeral);
            return this;
        }
        /**
         * The read consistency level.
         * 
         * The option is a:
         * &lt;code&gt;io.atomix.resource.ReadConsistency&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param readConsistency the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMapEndpointBuilder readConsistency(
                io.atomix.resource.ReadConsistency readConsistency) {
            doSetProperty("readConsistency", readConsistency);
            return this;
        }
        /**
         * The read consistency level.
         * 
         * The option will be converted to a
         * &lt;code&gt;io.atomix.resource.ReadConsistency&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param readConsistency the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMapEndpointBuilder readConsistency(
                String readConsistency) {
            doSetProperty("readConsistency", readConsistency);
            return this;
        }
        /**
         * Cluster wide resources configuration.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.util.Properties&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param resourceConfigs the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMapEndpointBuilder resourceConfigs(
                Map<java.lang.String, java.util.Properties> resourceConfigs) {
            doSetProperty("resourceConfigs", resourceConfigs);
            return this;
        }
        /**
         * Cluster wide resources configuration.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.util.Properties&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param resourceConfigs the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMapEndpointBuilder resourceConfigs(
                String resourceConfigs) {
            doSetProperty("resourceConfigs", resourceConfigs);
            return this;
        }
        /**
         * Local resources configurations.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.util.Properties&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param resourceOptions the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMapEndpointBuilder resourceOptions(
                Map<java.lang.String, java.util.Properties> resourceOptions) {
            doSetProperty("resourceOptions", resourceOptions);
            return this;
        }
        /**
         * Local resources configurations.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.util.Properties&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param resourceOptions the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMapEndpointBuilder resourceOptions(
                String resourceOptions) {
            doSetProperty("resourceOptions", resourceOptions);
            return this;
        }
    }

    public interface AtomixMapBuilders {
        /**
         * Atomix Map (camel-atomix)
         * Access Atomix's distributed map.
         * 
         * Category: clustering
         * Since: 2.20
         * Maven coordinates: org.apache.camel:camel-atomix
         * 
         * Syntax: <code>atomix-map:resourceName</code>
         * 
         * Path parameter: resourceName (required)
         * The distributed resource name
         * 
         * @param path resourceName
         * @return the dsl builder
         */
        @Deprecated
        default AtomixMapEndpointBuilder atomixMap(String path) {
            return AtomixMapEndpointBuilderFactory.endpointBuilder("atomix-map", path);
        }
        /**
         * Atomix Map (camel-atomix)
         * Access Atomix's distributed map.
         * 
         * Category: clustering
         * Since: 2.20
         * Maven coordinates: org.apache.camel:camel-atomix
         * 
         * Syntax: <code>atomix-map:resourceName</code>
         * 
         * Path parameter: resourceName (required)
         * The distributed resource name
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path resourceName
         * @return the dsl builder
         */
        @Deprecated
        default AtomixMapEndpointBuilder atomixMap(
                String componentName,
                String path) {
            return AtomixMapEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    @Deprecated
    static AtomixMapEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class AtomixMapEndpointBuilderImpl extends AbstractEndpointBuilder implements AtomixMapEndpointBuilder, AdvancedAtomixMapEndpointBuilder {
            public AtomixMapEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new AtomixMapEndpointBuilderImpl(path);
    }
}