/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.Map;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Exchange information in the healthcare domain using the FHIR (Fast Healthcare
 * Interoperability Resources) standard.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface FhirEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the FHIR component.
     */
    public interface FhirEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedFhirEndpointConsumerBuilder advanced() {
            return (AdvancedFhirEndpointConsumerBuilder) this;
        }
        /**
         * Encoding to use for all request.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param encoding the value to set
         * @return the dsl builder
         */
        default FhirEndpointConsumerBuilder encoding(String encoding) {
            doSetProperty("encoding", encoding);
            return this;
        }
        /**
         * The FHIR Version to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: R4
         * Group: common
         * 
         * @param fhirVersion the value to set
         * @return the dsl builder
         */
        default FhirEndpointConsumerBuilder fhirVersion(String fhirVersion) {
            doSetProperty("fhirVersion", fhirVersion);
            return this;
        }
        /**
         * Sets the name of a parameter to be passed in the exchange In Body.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param inBody the value to set
         * @return the dsl builder
         */
        default FhirEndpointConsumerBuilder inBody(String inBody) {
            doSetProperty("inBody", inBody);
            return this;
        }
        /**
         * Will log every requests and responses.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param log the value to set
         * @return the dsl builder
         */
        default FhirEndpointConsumerBuilder log(boolean log) {
            doSetProperty("log", log);
            return this;
        }
        /**
         * Will log every requests and responses.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param log the value to set
         * @return the dsl builder
         */
        default FhirEndpointConsumerBuilder log(String log) {
            doSetProperty("log", log);
            return this;
        }
        /**
         * Pretty print all request.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param prettyPrint the value to set
         * @return the dsl builder
         */
        default FhirEndpointConsumerBuilder prettyPrint(boolean prettyPrint) {
            doSetProperty("prettyPrint", prettyPrint);
            return this;
        }
        /**
         * Pretty print all request.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param prettyPrint the value to set
         * @return the dsl builder
         */
        default FhirEndpointConsumerBuilder prettyPrint(String prettyPrint) {
            doSetProperty("prettyPrint", prettyPrint);
            return this;
        }
        /**
         * The FHIR server base URL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param serverUrl the value to set
         * @return the dsl builder
         */
        default FhirEndpointConsumerBuilder serverUrl(String serverUrl) {
            doSetProperty("serverUrl", serverUrl);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default FhirEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default FhirEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default FhirEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                boolean sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default FhirEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                String sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * The proxy host.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyHost the value to set
         * @return the dsl builder
         */
        default FhirEndpointConsumerBuilder proxyHost(String proxyHost) {
            doSetProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * The proxy password.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyPassword the value to set
         * @return the dsl builder
         */
        default FhirEndpointConsumerBuilder proxyPassword(String proxyPassword) {
            doSetProperty("proxyPassword", proxyPassword);
            return this;
        }
        /**
         * The proxy port.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default FhirEndpointConsumerBuilder proxyPort(Integer proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * The proxy port.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default FhirEndpointConsumerBuilder proxyPort(String proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * The proxy username.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyUser the value to set
         * @return the dsl builder
         */
        default FhirEndpointConsumerBuilder proxyUser(String proxyUser) {
            doSetProperty("proxyUser", proxyUser);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default FhirEndpointConsumerBuilder backoffErrorThreshold(
                int backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default FhirEndpointConsumerBuilder backoffErrorThreshold(
                String backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default FhirEndpointConsumerBuilder backoffIdleThreshold(
                int backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default FhirEndpointConsumerBuilder backoffIdleThreshold(
                String backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default FhirEndpointConsumerBuilder backoffMultiplier(
                int backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default FhirEndpointConsumerBuilder backoffMultiplier(
                String backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: scheduler
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default FhirEndpointConsumerBuilder delay(long delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: scheduler
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default FhirEndpointConsumerBuilder delay(String delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default FhirEndpointConsumerBuilder greedy(boolean greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default FhirEndpointConsumerBuilder greedy(String greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default FhirEndpointConsumerBuilder initialDelay(long initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default FhirEndpointConsumerBuilder initialDelay(String initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default FhirEndpointConsumerBuilder repeatCount(long repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default FhirEndpointConsumerBuilder repeatCount(String repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default FhirEndpointConsumerBuilder runLoggingLevel(
                org.apache.camel.LoggingLevel runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default FhirEndpointConsumerBuilder runLoggingLevel(
                String runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option is a:
         * &lt;code&gt;java.util.concurrent.ScheduledExecutorService&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default FhirEndpointConsumerBuilder scheduledExecutorService(
                ScheduledExecutorService scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.concurrent.ScheduledExecutorService&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default FhirEndpointConsumerBuilder scheduledExecutorService(
                String scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option is a: &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default FhirEndpointConsumerBuilder scheduler(Object scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default FhirEndpointConsumerBuilder scheduler(String scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default FhirEndpointConsumerBuilder schedulerProperties(
                String key,
                Object value) {
            doSetMultiValueProperty("schedulerProperties", "scheduler." + key, value);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param values the values
         * @return the dsl builder
         */
        default FhirEndpointConsumerBuilder schedulerProperties(Map values) {
            doSetMultiValueProperties("schedulerProperties", "scheduler.", values);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default FhirEndpointConsumerBuilder startScheduler(
                boolean startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default FhirEndpointConsumerBuilder startScheduler(String startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option is a:
         * &lt;code&gt;java.util.concurrent.TimeUnit&lt;/code&gt; type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default FhirEndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.concurrent.TimeUnit&lt;/code&gt; type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default FhirEndpointConsumerBuilder timeUnit(String timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default FhirEndpointConsumerBuilder useFixedDelay(boolean useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default FhirEndpointConsumerBuilder useFixedDelay(String useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * OAuth access token.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param accessToken the value to set
         * @return the dsl builder
         */
        default FhirEndpointConsumerBuilder accessToken(String accessToken) {
            doSetProperty("accessToken", accessToken);
            return this;
        }
        /**
         * Username to use for basic authentication.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default FhirEndpointConsumerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Username to use for basic authentication.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default FhirEndpointConsumerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the FHIR component.
     */
    public interface AdvancedFhirEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default FhirEndpointConsumerBuilder basic() {
            return (FhirEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.PollingConsumerPollStrategy&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointConsumerBuilder pollStrategy(
                org.apache.camel.spi.PollingConsumerPollStrategy pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.PollingConsumerPollStrategy&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointConsumerBuilder pollStrategy(
                String pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * To use the custom client.
         * 
         * The option is a:
         * &lt;code&gt;ca.uhn.fhir.rest.client.api.IGenericClient&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param client the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointConsumerBuilder client(
                ca.uhn.fhir.rest.client.api.IGenericClient client) {
            doSetProperty("client", client);
            return this;
        }
        /**
         * To use the custom client.
         * 
         * The option will be converted to a
         * &lt;code&gt;ca.uhn.fhir.rest.client.api.IGenericClient&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param client the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointConsumerBuilder client(String client) {
            doSetProperty("client", client);
            return this;
        }
        /**
         * To use the custom client factory.
         * 
         * The option is a:
         * &lt;code&gt;ca.uhn.fhir.rest.client.api.IRestfulClientFactory&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param clientFactory the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointConsumerBuilder clientFactory(
                ca.uhn.fhir.rest.client.api.IRestfulClientFactory clientFactory) {
            doSetProperty("clientFactory", clientFactory);
            return this;
        }
        /**
         * To use the custom client factory.
         * 
         * The option will be converted to a
         * &lt;code&gt;ca.uhn.fhir.rest.client.api.IRestfulClientFactory&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param clientFactory the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointConsumerBuilder clientFactory(
                String clientFactory) {
            doSetProperty("clientFactory", clientFactory);
            return this;
        }
        /**
         * Compresses outgoing (POST/PUT) contents to the GZIP format.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param compress the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointConsumerBuilder compress(boolean compress) {
            doSetProperty("compress", compress);
            return this;
        }
        /**
         * Compresses outgoing (POST/PUT) contents to the GZIP format.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param compress the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointConsumerBuilder compress(String compress) {
            doSetProperty("compress", compress);
            return this;
        }
        /**
         * How long to try and establish the initial TCP connection (in ms).
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: advanced
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointConsumerBuilder connectionTimeout(
                Integer connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * How long to try and establish the initial TCP connection (in ms).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: advanced
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointConsumerBuilder connectionTimeout(
                String connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * When this option is set, model classes will not be scanned for
         * children until the child list for the given type is actually
         * accessed.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param deferModelScanning the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointConsumerBuilder deferModelScanning(
                boolean deferModelScanning) {
            doSetProperty("deferModelScanning", deferModelScanning);
            return this;
        }
        /**
         * When this option is set, model classes will not be scanned for
         * children until the child list for the given type is actually
         * accessed.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param deferModelScanning the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointConsumerBuilder deferModelScanning(
                String deferModelScanning) {
            doSetProperty("deferModelScanning", deferModelScanning);
            return this;
        }
        /**
         * FhirContext is an expensive object to create. To avoid creating
         * multiple instances, it can be set directly.
         * 
         * The option is a:
         * &lt;code&gt;ca.uhn.fhir.context.FhirContext&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param fhirContext the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointConsumerBuilder fhirContext(
                ca.uhn.fhir.context.FhirContext fhirContext) {
            doSetProperty("fhirContext", fhirContext);
            return this;
        }
        /**
         * FhirContext is an expensive object to create. To avoid creating
         * multiple instances, it can be set directly.
         * 
         * The option will be converted to a
         * &lt;code&gt;ca.uhn.fhir.context.FhirContext&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param fhirContext the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointConsumerBuilder fhirContext(
                String fhirContext) {
            doSetProperty("fhirContext", fhirContext);
            return this;
        }
        /**
         * Force conformance check.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param forceConformanceCheck the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointConsumerBuilder forceConformanceCheck(
                boolean forceConformanceCheck) {
            doSetProperty("forceConformanceCheck", forceConformanceCheck);
            return this;
        }
        /**
         * Force conformance check.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param forceConformanceCheck the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointConsumerBuilder forceConformanceCheck(
                String forceConformanceCheck) {
            doSetProperty("forceConformanceCheck", forceConformanceCheck);
            return this;
        }
        /**
         * HTTP session cookie to add to every request.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param sessionCookie the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointConsumerBuilder sessionCookie(
                String sessionCookie) {
            doSetProperty("sessionCookie", sessionCookie);
            return this;
        }
        /**
         * How long to block for individual read/write operations (in ms).
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: advanced
         * 
         * @param socketTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointConsumerBuilder socketTimeout(
                Integer socketTimeout) {
            doSetProperty("socketTimeout", socketTimeout);
            return this;
        }
        /**
         * How long to block for individual read/write operations (in ms).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: advanced
         * 
         * @param socketTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointConsumerBuilder socketTimeout(
                String socketTimeout) {
            doSetProperty("socketTimeout", socketTimeout);
            return this;
        }
        /**
         * Request that the server modify the response using the _summary param.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param summary the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointConsumerBuilder summary(String summary) {
            doSetProperty("summary", summary);
            return this;
        }
        /**
         * When should Camel validate the FHIR Server's conformance statement.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: ONCE
         * Group: advanced
         * 
         * @param validationMode the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointConsumerBuilder validationMode(
                String validationMode) {
            doSetProperty("validationMode", validationMode);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the FHIR component.
     */
    public interface FhirEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedFhirEndpointProducerBuilder advanced() {
            return (AdvancedFhirEndpointProducerBuilder) this;
        }
        /**
         * Encoding to use for all request.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param encoding the value to set
         * @return the dsl builder
         */
        default FhirEndpointProducerBuilder encoding(String encoding) {
            doSetProperty("encoding", encoding);
            return this;
        }
        /**
         * The FHIR Version to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: R4
         * Group: common
         * 
         * @param fhirVersion the value to set
         * @return the dsl builder
         */
        default FhirEndpointProducerBuilder fhirVersion(String fhirVersion) {
            doSetProperty("fhirVersion", fhirVersion);
            return this;
        }
        /**
         * Sets the name of a parameter to be passed in the exchange In Body.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param inBody the value to set
         * @return the dsl builder
         */
        default FhirEndpointProducerBuilder inBody(String inBody) {
            doSetProperty("inBody", inBody);
            return this;
        }
        /**
         * Will log every requests and responses.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param log the value to set
         * @return the dsl builder
         */
        default FhirEndpointProducerBuilder log(boolean log) {
            doSetProperty("log", log);
            return this;
        }
        /**
         * Will log every requests and responses.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param log the value to set
         * @return the dsl builder
         */
        default FhirEndpointProducerBuilder log(String log) {
            doSetProperty("log", log);
            return this;
        }
        /**
         * Pretty print all request.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param prettyPrint the value to set
         * @return the dsl builder
         */
        default FhirEndpointProducerBuilder prettyPrint(boolean prettyPrint) {
            doSetProperty("prettyPrint", prettyPrint);
            return this;
        }
        /**
         * Pretty print all request.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param prettyPrint the value to set
         * @return the dsl builder
         */
        default FhirEndpointProducerBuilder prettyPrint(String prettyPrint) {
            doSetProperty("prettyPrint", prettyPrint);
            return this;
        }
        /**
         * The FHIR server base URL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param serverUrl the value to set
         * @return the dsl builder
         */
        default FhirEndpointProducerBuilder serverUrl(String serverUrl) {
            doSetProperty("serverUrl", serverUrl);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default FhirEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default FhirEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * The proxy host.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyHost the value to set
         * @return the dsl builder
         */
        default FhirEndpointProducerBuilder proxyHost(String proxyHost) {
            doSetProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * The proxy password.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyPassword the value to set
         * @return the dsl builder
         */
        default FhirEndpointProducerBuilder proxyPassword(String proxyPassword) {
            doSetProperty("proxyPassword", proxyPassword);
            return this;
        }
        /**
         * The proxy port.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default FhirEndpointProducerBuilder proxyPort(Integer proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * The proxy port.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default FhirEndpointProducerBuilder proxyPort(String proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * The proxy username.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyUser the value to set
         * @return the dsl builder
         */
        default FhirEndpointProducerBuilder proxyUser(String proxyUser) {
            doSetProperty("proxyUser", proxyUser);
            return this;
        }
        /**
         * OAuth access token.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param accessToken the value to set
         * @return the dsl builder
         */
        default FhirEndpointProducerBuilder accessToken(String accessToken) {
            doSetProperty("accessToken", accessToken);
            return this;
        }
        /**
         * Username to use for basic authentication.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default FhirEndpointProducerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Username to use for basic authentication.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default FhirEndpointProducerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the FHIR component.
     */
    public interface AdvancedFhirEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default FhirEndpointProducerBuilder basic() {
            return (FhirEndpointProducerBuilder) this;
        }
        /**
         * To use the custom client.
         * 
         * The option is a:
         * &lt;code&gt;ca.uhn.fhir.rest.client.api.IGenericClient&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param client the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointProducerBuilder client(
                ca.uhn.fhir.rest.client.api.IGenericClient client) {
            doSetProperty("client", client);
            return this;
        }
        /**
         * To use the custom client.
         * 
         * The option will be converted to a
         * &lt;code&gt;ca.uhn.fhir.rest.client.api.IGenericClient&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param client the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointProducerBuilder client(String client) {
            doSetProperty("client", client);
            return this;
        }
        /**
         * To use the custom client factory.
         * 
         * The option is a:
         * &lt;code&gt;ca.uhn.fhir.rest.client.api.IRestfulClientFactory&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param clientFactory the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointProducerBuilder clientFactory(
                ca.uhn.fhir.rest.client.api.IRestfulClientFactory clientFactory) {
            doSetProperty("clientFactory", clientFactory);
            return this;
        }
        /**
         * To use the custom client factory.
         * 
         * The option will be converted to a
         * &lt;code&gt;ca.uhn.fhir.rest.client.api.IRestfulClientFactory&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param clientFactory the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointProducerBuilder clientFactory(
                String clientFactory) {
            doSetProperty("clientFactory", clientFactory);
            return this;
        }
        /**
         * Compresses outgoing (POST/PUT) contents to the GZIP format.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param compress the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointProducerBuilder compress(boolean compress) {
            doSetProperty("compress", compress);
            return this;
        }
        /**
         * Compresses outgoing (POST/PUT) contents to the GZIP format.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param compress the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointProducerBuilder compress(String compress) {
            doSetProperty("compress", compress);
            return this;
        }
        /**
         * How long to try and establish the initial TCP connection (in ms).
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: advanced
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointProducerBuilder connectionTimeout(
                Integer connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * How long to try and establish the initial TCP connection (in ms).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: advanced
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointProducerBuilder connectionTimeout(
                String connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * When this option is set, model classes will not be scanned for
         * children until the child list for the given type is actually
         * accessed.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param deferModelScanning the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointProducerBuilder deferModelScanning(
                boolean deferModelScanning) {
            doSetProperty("deferModelScanning", deferModelScanning);
            return this;
        }
        /**
         * When this option is set, model classes will not be scanned for
         * children until the child list for the given type is actually
         * accessed.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param deferModelScanning the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointProducerBuilder deferModelScanning(
                String deferModelScanning) {
            doSetProperty("deferModelScanning", deferModelScanning);
            return this;
        }
        /**
         * FhirContext is an expensive object to create. To avoid creating
         * multiple instances, it can be set directly.
         * 
         * The option is a:
         * &lt;code&gt;ca.uhn.fhir.context.FhirContext&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param fhirContext the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointProducerBuilder fhirContext(
                ca.uhn.fhir.context.FhirContext fhirContext) {
            doSetProperty("fhirContext", fhirContext);
            return this;
        }
        /**
         * FhirContext is an expensive object to create. To avoid creating
         * multiple instances, it can be set directly.
         * 
         * The option will be converted to a
         * &lt;code&gt;ca.uhn.fhir.context.FhirContext&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param fhirContext the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointProducerBuilder fhirContext(
                String fhirContext) {
            doSetProperty("fhirContext", fhirContext);
            return this;
        }
        /**
         * Force conformance check.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param forceConformanceCheck the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointProducerBuilder forceConformanceCheck(
                boolean forceConformanceCheck) {
            doSetProperty("forceConformanceCheck", forceConformanceCheck);
            return this;
        }
        /**
         * Force conformance check.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param forceConformanceCheck the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointProducerBuilder forceConformanceCheck(
                String forceConformanceCheck) {
            doSetProperty("forceConformanceCheck", forceConformanceCheck);
            return this;
        }
        /**
         * HTTP session cookie to add to every request.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param sessionCookie the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointProducerBuilder sessionCookie(
                String sessionCookie) {
            doSetProperty("sessionCookie", sessionCookie);
            return this;
        }
        /**
         * How long to block for individual read/write operations (in ms).
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: advanced
         * 
         * @param socketTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointProducerBuilder socketTimeout(
                Integer socketTimeout) {
            doSetProperty("socketTimeout", socketTimeout);
            return this;
        }
        /**
         * How long to block for individual read/write operations (in ms).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: advanced
         * 
         * @param socketTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointProducerBuilder socketTimeout(
                String socketTimeout) {
            doSetProperty("socketTimeout", socketTimeout);
            return this;
        }
        /**
         * Request that the server modify the response using the _summary param.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param summary the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointProducerBuilder summary(String summary) {
            doSetProperty("summary", summary);
            return this;
        }
        /**
         * When should Camel validate the FHIR Server's conformance statement.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: ONCE
         * Group: advanced
         * 
         * @param validationMode the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointProducerBuilder validationMode(
                String validationMode) {
            doSetProperty("validationMode", validationMode);
            return this;
        }
    }

    /**
     * Builder for endpoint for the FHIR component.
     */
    public interface FhirEndpointBuilder
            extends
                FhirEndpointConsumerBuilder,
                FhirEndpointProducerBuilder {
        default AdvancedFhirEndpointBuilder advanced() {
            return (AdvancedFhirEndpointBuilder) this;
        }
        /**
         * Encoding to use for all request.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param encoding the value to set
         * @return the dsl builder
         */
        default FhirEndpointBuilder encoding(String encoding) {
            doSetProperty("encoding", encoding);
            return this;
        }
        /**
         * The FHIR Version to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: R4
         * Group: common
         * 
         * @param fhirVersion the value to set
         * @return the dsl builder
         */
        default FhirEndpointBuilder fhirVersion(String fhirVersion) {
            doSetProperty("fhirVersion", fhirVersion);
            return this;
        }
        /**
         * Sets the name of a parameter to be passed in the exchange In Body.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param inBody the value to set
         * @return the dsl builder
         */
        default FhirEndpointBuilder inBody(String inBody) {
            doSetProperty("inBody", inBody);
            return this;
        }
        /**
         * Will log every requests and responses.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param log the value to set
         * @return the dsl builder
         */
        default FhirEndpointBuilder log(boolean log) {
            doSetProperty("log", log);
            return this;
        }
        /**
         * Will log every requests and responses.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param log the value to set
         * @return the dsl builder
         */
        default FhirEndpointBuilder log(String log) {
            doSetProperty("log", log);
            return this;
        }
        /**
         * Pretty print all request.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param prettyPrint the value to set
         * @return the dsl builder
         */
        default FhirEndpointBuilder prettyPrint(boolean prettyPrint) {
            doSetProperty("prettyPrint", prettyPrint);
            return this;
        }
        /**
         * Pretty print all request.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param prettyPrint the value to set
         * @return the dsl builder
         */
        default FhirEndpointBuilder prettyPrint(String prettyPrint) {
            doSetProperty("prettyPrint", prettyPrint);
            return this;
        }
        /**
         * The FHIR server base URL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param serverUrl the value to set
         * @return the dsl builder
         */
        default FhirEndpointBuilder serverUrl(String serverUrl) {
            doSetProperty("serverUrl", serverUrl);
            return this;
        }
        /**
         * The proxy host.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyHost the value to set
         * @return the dsl builder
         */
        default FhirEndpointBuilder proxyHost(String proxyHost) {
            doSetProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * The proxy password.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyPassword the value to set
         * @return the dsl builder
         */
        default FhirEndpointBuilder proxyPassword(String proxyPassword) {
            doSetProperty("proxyPassword", proxyPassword);
            return this;
        }
        /**
         * The proxy port.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default FhirEndpointBuilder proxyPort(Integer proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * The proxy port.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default FhirEndpointBuilder proxyPort(String proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * The proxy username.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyUser the value to set
         * @return the dsl builder
         */
        default FhirEndpointBuilder proxyUser(String proxyUser) {
            doSetProperty("proxyUser", proxyUser);
            return this;
        }
        /**
         * OAuth access token.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param accessToken the value to set
         * @return the dsl builder
         */
        default FhirEndpointBuilder accessToken(String accessToken) {
            doSetProperty("accessToken", accessToken);
            return this;
        }
        /**
         * Username to use for basic authentication.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default FhirEndpointBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Username to use for basic authentication.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default FhirEndpointBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the FHIR component.
     */
    public interface AdvancedFhirEndpointBuilder
            extends
                AdvancedFhirEndpointConsumerBuilder,
                AdvancedFhirEndpointProducerBuilder {
        default FhirEndpointBuilder basic() {
            return (FhirEndpointBuilder) this;
        }
        /**
         * To use the custom client.
         * 
         * The option is a:
         * &lt;code&gt;ca.uhn.fhir.rest.client.api.IGenericClient&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param client the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointBuilder client(
                ca.uhn.fhir.rest.client.api.IGenericClient client) {
            doSetProperty("client", client);
            return this;
        }
        /**
         * To use the custom client.
         * 
         * The option will be converted to a
         * &lt;code&gt;ca.uhn.fhir.rest.client.api.IGenericClient&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param client the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointBuilder client(String client) {
            doSetProperty("client", client);
            return this;
        }
        /**
         * To use the custom client factory.
         * 
         * The option is a:
         * &lt;code&gt;ca.uhn.fhir.rest.client.api.IRestfulClientFactory&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param clientFactory the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointBuilder clientFactory(
                ca.uhn.fhir.rest.client.api.IRestfulClientFactory clientFactory) {
            doSetProperty("clientFactory", clientFactory);
            return this;
        }
        /**
         * To use the custom client factory.
         * 
         * The option will be converted to a
         * &lt;code&gt;ca.uhn.fhir.rest.client.api.IRestfulClientFactory&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param clientFactory the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointBuilder clientFactory(String clientFactory) {
            doSetProperty("clientFactory", clientFactory);
            return this;
        }
        /**
         * Compresses outgoing (POST/PUT) contents to the GZIP format.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param compress the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointBuilder compress(boolean compress) {
            doSetProperty("compress", compress);
            return this;
        }
        /**
         * Compresses outgoing (POST/PUT) contents to the GZIP format.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param compress the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointBuilder compress(String compress) {
            doSetProperty("compress", compress);
            return this;
        }
        /**
         * How long to try and establish the initial TCP connection (in ms).
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: advanced
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointBuilder connectionTimeout(
                Integer connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * How long to try and establish the initial TCP connection (in ms).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: advanced
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointBuilder connectionTimeout(
                String connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * When this option is set, model classes will not be scanned for
         * children until the child list for the given type is actually
         * accessed.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param deferModelScanning the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointBuilder deferModelScanning(
                boolean deferModelScanning) {
            doSetProperty("deferModelScanning", deferModelScanning);
            return this;
        }
        /**
         * When this option is set, model classes will not be scanned for
         * children until the child list for the given type is actually
         * accessed.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param deferModelScanning the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointBuilder deferModelScanning(
                String deferModelScanning) {
            doSetProperty("deferModelScanning", deferModelScanning);
            return this;
        }
        /**
         * FhirContext is an expensive object to create. To avoid creating
         * multiple instances, it can be set directly.
         * 
         * The option is a:
         * &lt;code&gt;ca.uhn.fhir.context.FhirContext&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param fhirContext the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointBuilder fhirContext(
                ca.uhn.fhir.context.FhirContext fhirContext) {
            doSetProperty("fhirContext", fhirContext);
            return this;
        }
        /**
         * FhirContext is an expensive object to create. To avoid creating
         * multiple instances, it can be set directly.
         * 
         * The option will be converted to a
         * &lt;code&gt;ca.uhn.fhir.context.FhirContext&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param fhirContext the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointBuilder fhirContext(String fhirContext) {
            doSetProperty("fhirContext", fhirContext);
            return this;
        }
        /**
         * Force conformance check.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param forceConformanceCheck the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointBuilder forceConformanceCheck(
                boolean forceConformanceCheck) {
            doSetProperty("forceConformanceCheck", forceConformanceCheck);
            return this;
        }
        /**
         * Force conformance check.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param forceConformanceCheck the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointBuilder forceConformanceCheck(
                String forceConformanceCheck) {
            doSetProperty("forceConformanceCheck", forceConformanceCheck);
            return this;
        }
        /**
         * HTTP session cookie to add to every request.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param sessionCookie the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointBuilder sessionCookie(String sessionCookie) {
            doSetProperty("sessionCookie", sessionCookie);
            return this;
        }
        /**
         * How long to block for individual read/write operations (in ms).
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: advanced
         * 
         * @param socketTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointBuilder socketTimeout(Integer socketTimeout) {
            doSetProperty("socketTimeout", socketTimeout);
            return this;
        }
        /**
         * How long to block for individual read/write operations (in ms).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: advanced
         * 
         * @param socketTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointBuilder socketTimeout(String socketTimeout) {
            doSetProperty("socketTimeout", socketTimeout);
            return this;
        }
        /**
         * Request that the server modify the response using the _summary param.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param summary the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointBuilder summary(String summary) {
            doSetProperty("summary", summary);
            return this;
        }
        /**
         * When should Camel validate the FHIR Server's conformance statement.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: ONCE
         * Group: advanced
         * 
         * @param validationMode the value to set
         * @return the dsl builder
         */
        default AdvancedFhirEndpointBuilder validationMode(String validationMode) {
            doSetProperty("validationMode", validationMode);
            return this;
        }
    }

    public interface FhirBuilders {
        /**
         * FHIR (camel-fhir)
         * Exchange information in the healthcare domain using the FHIR (Fast
         * Healthcare Interoperability Resources) standard.
         * 
         * Category: api
         * Since: 2.23
         * Maven coordinates: org.apache.camel:camel-fhir
         * 
         * Syntax: <code>fhir:apiName/methodName</code>
         * 
         * Path parameter: apiName (required)
         * What kind of operation to perform
         * There are 13 enums and the value can be one of: CAPABILITIES, CREATE,
         * DELETE, HISTORY, LOAD_PAGE, META, OPERATION, PATCH, READ, SEARCH,
         * TRANSACTION, UPDATE, VALIDATE
         * 
         * Path parameter: methodName (required)
         * What sub operation to use for the selected operation
         * 
         * @param path apiName/methodName
         * @return the dsl builder
         */
        default FhirEndpointBuilder fhir(String path) {
            return FhirEndpointBuilderFactory.endpointBuilder("fhir", path);
        }
        /**
         * FHIR (camel-fhir)
         * Exchange information in the healthcare domain using the FHIR (Fast
         * Healthcare Interoperability Resources) standard.
         * 
         * Category: api
         * Since: 2.23
         * Maven coordinates: org.apache.camel:camel-fhir
         * 
         * Syntax: <code>fhir:apiName/methodName</code>
         * 
         * Path parameter: apiName (required)
         * What kind of operation to perform
         * There are 13 enums and the value can be one of: CAPABILITIES, CREATE,
         * DELETE, HISTORY, LOAD_PAGE, META, OPERATION, PATCH, READ, SEARCH,
         * TRANSACTION, UPDATE, VALIDATE
         * 
         * Path parameter: methodName (required)
         * What sub operation to use for the selected operation
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path apiName/methodName
         * @return the dsl builder
         */
        default FhirEndpointBuilder fhir(String componentName, String path) {
            return FhirEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    static FhirEndpointBuilder endpointBuilder(String componentName, String path) {
        class FhirEndpointBuilderImpl extends AbstractEndpointBuilder implements FhirEndpointBuilder, AdvancedFhirEndpointBuilder {
            public FhirEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new FhirEndpointBuilderImpl(path);
    }
}