/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Expose gRPC endpoints and access external gRPC endpoints.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface GrpcEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the gRPC component.
     */
    public interface GrpcEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedGrpcEndpointConsumerBuilder advanced() {
            return (AdvancedGrpcEndpointConsumerBuilder) this;
        }
        /**
         * Setting the autoDiscoverClientInterceptors mechanism, if true, the
         * component will look for a ClientInterceptor instance in the registry
         * automatically otherwise it will skip that checking.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoDiscoverClientInterceptors the value to set
         * @return the dsl builder
         */
        default GrpcEndpointConsumerBuilder autoDiscoverClientInterceptors(
                boolean autoDiscoverClientInterceptors) {
            doSetProperty("autoDiscoverClientInterceptors", autoDiscoverClientInterceptors);
            return this;
        }
        /**
         * Setting the autoDiscoverClientInterceptors mechanism, if true, the
         * component will look for a ClientInterceptor instance in the registry
         * automatically otherwise it will skip that checking.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoDiscoverClientInterceptors the value to set
         * @return the dsl builder
         */
        default GrpcEndpointConsumerBuilder autoDiscoverClientInterceptors(
                String autoDiscoverClientInterceptors) {
            doSetProperty("autoDiscoverClientInterceptors", autoDiscoverClientInterceptors);
            return this;
        }
        /**
         * The HTTP/2 flow control window size (MiB).
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1048576
         * Group: common
         * 
         * @param flowControlWindow the value to set
         * @return the dsl builder
         */
        default GrpcEndpointConsumerBuilder flowControlWindow(
                int flowControlWindow) {
            doSetProperty("flowControlWindow", flowControlWindow);
            return this;
        }
        /**
         * The HTTP/2 flow control window size (MiB).
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1048576
         * Group: common
         * 
         * @param flowControlWindow the value to set
         * @return the dsl builder
         */
        default GrpcEndpointConsumerBuilder flowControlWindow(
                String flowControlWindow) {
            doSetProperty("flowControlWindow", flowControlWindow);
            return this;
        }
        /**
         * The maximum message size allowed to be received/sent (MiB).
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 4194304
         * Group: common
         * 
         * @param maxMessageSize the value to set
         * @return the dsl builder
         */
        default GrpcEndpointConsumerBuilder maxMessageSize(int maxMessageSize) {
            doSetProperty("maxMessageSize", maxMessageSize);
            return this;
        }
        /**
         * The maximum message size allowed to be received/sent (MiB).
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 4194304
         * Group: common
         * 
         * @param maxMessageSize the value to set
         * @return the dsl builder
         */
        default GrpcEndpointConsumerBuilder maxMessageSize(String maxMessageSize) {
            doSetProperty("maxMessageSize", maxMessageSize);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default GrpcEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default GrpcEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * This option specifies the top-level strategy for processing service
         * requests and responses in streaming mode. If an aggregation strategy
         * is selected, all requests will be accumulated in the list, then
         * transferred to the flow, and the accumulated responses will be sent
         * to the sender. If a propagation strategy is selected, request is sent
         * to the stream, and the response will be immediately sent back to the
         * sender.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.grpc.GrpcConsumerStrategy&lt;/code&gt; type.
         * 
         * Default: PROPAGATION
         * Group: consumer
         * 
         * @param consumerStrategy the value to set
         * @return the dsl builder
         */
        default GrpcEndpointConsumerBuilder consumerStrategy(
                org.apache.camel.component.grpc.GrpcConsumerStrategy consumerStrategy) {
            doSetProperty("consumerStrategy", consumerStrategy);
            return this;
        }
        /**
         * This option specifies the top-level strategy for processing service
         * requests and responses in streaming mode. If an aggregation strategy
         * is selected, all requests will be accumulated in the list, then
         * transferred to the flow, and the accumulated responses will be sent
         * to the sender. If a propagation strategy is selected, request is sent
         * to the stream, and the response will be immediately sent back to the
         * sender.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.grpc.GrpcConsumerStrategy&lt;/code&gt; type.
         * 
         * Default: PROPAGATION
         * Group: consumer
         * 
         * @param consumerStrategy the value to set
         * @return the dsl builder
         */
        default GrpcEndpointConsumerBuilder consumerStrategy(
                String consumerStrategy) {
            doSetProperty("consumerStrategy", consumerStrategy);
            return this;
        }
        /**
         * Determines if onCompleted events should be pushed to the Camel route.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param forwardOnCompleted the value to set
         * @return the dsl builder
         */
        default GrpcEndpointConsumerBuilder forwardOnCompleted(
                boolean forwardOnCompleted) {
            doSetProperty("forwardOnCompleted", forwardOnCompleted);
            return this;
        }
        /**
         * Determines if onCompleted events should be pushed to the Camel route.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param forwardOnCompleted the value to set
         * @return the dsl builder
         */
        default GrpcEndpointConsumerBuilder forwardOnCompleted(
                String forwardOnCompleted) {
            doSetProperty("forwardOnCompleted", forwardOnCompleted);
            return this;
        }
        /**
         * Determines if onError events should be pushed to the Camel route.
         * Exceptions will be set as message body.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param forwardOnError the value to set
         * @return the dsl builder
         */
        default GrpcEndpointConsumerBuilder forwardOnError(
                boolean forwardOnError) {
            doSetProperty("forwardOnError", forwardOnError);
            return this;
        }
        /**
         * Determines if onError events should be pushed to the Camel route.
         * Exceptions will be set as message body.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param forwardOnError the value to set
         * @return the dsl builder
         */
        default GrpcEndpointConsumerBuilder forwardOnError(String forwardOnError) {
            doSetProperty("forwardOnError", forwardOnError);
            return this;
        }
        /**
         * The maximum number of concurrent calls permitted for each incoming
         * server connection.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 2147483647
         * Group: consumer
         * 
         * @param maxConcurrentCallsPerConnection the value to set
         * @return the dsl builder
         */
        default GrpcEndpointConsumerBuilder maxConcurrentCallsPerConnection(
                int maxConcurrentCallsPerConnection) {
            doSetProperty("maxConcurrentCallsPerConnection", maxConcurrentCallsPerConnection);
            return this;
        }
        /**
         * The maximum number of concurrent calls permitted for each incoming
         * server connection.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 2147483647
         * Group: consumer
         * 
         * @param maxConcurrentCallsPerConnection the value to set
         * @return the dsl builder
         */
        default GrpcEndpointConsumerBuilder maxConcurrentCallsPerConnection(
                String maxConcurrentCallsPerConnection) {
            doSetProperty("maxConcurrentCallsPerConnection", maxConcurrentCallsPerConnection);
            return this;
        }
        /**
         * Lets the route to take control over stream observer. If this value is
         * set to true, then the response observer of gRPC call will be set with
         * the name GrpcConstants.GRPC_RESPONSE_OBSERVER in the Exchange object.
         * Please note that the stream observer's onNext(), onError(),
         * onCompleted() methods should be called in the route.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param routeControlledStreamObserver the value to set
         * @return the dsl builder
         */
        default GrpcEndpointConsumerBuilder routeControlledStreamObserver(
                boolean routeControlledStreamObserver) {
            doSetProperty("routeControlledStreamObserver", routeControlledStreamObserver);
            return this;
        }
        /**
         * Lets the route to take control over stream observer. If this value is
         * set to true, then the response observer of gRPC call will be set with
         * the name GrpcConstants.GRPC_RESPONSE_OBSERVER in the Exchange object.
         * Please note that the stream observer's onNext(), onError(),
         * onCompleted() methods should be called in the route.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param routeControlledStreamObserver the value to set
         * @return the dsl builder
         */
        default GrpcEndpointConsumerBuilder routeControlledStreamObserver(
                String routeControlledStreamObserver) {
            doSetProperty("routeControlledStreamObserver", routeControlledStreamObserver);
            return this;
        }
        /**
         * Authentication method type in advance to the SSL/TLS negotiation.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.grpc.GrpcAuthType&lt;/code&gt;
         * type.
         * 
         * Default: NONE
         * Group: security
         * 
         * @param authenticationType the value to set
         * @return the dsl builder
         */
        default GrpcEndpointConsumerBuilder authenticationType(
                org.apache.camel.component.grpc.GrpcAuthType authenticationType) {
            doSetProperty("authenticationType", authenticationType);
            return this;
        }
        /**
         * Authentication method type in advance to the SSL/TLS negotiation.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.grpc.GrpcAuthType&lt;/code&gt;
         * type.
         * 
         * Default: NONE
         * Group: security
         * 
         * @param authenticationType the value to set
         * @return the dsl builder
         */
        default GrpcEndpointConsumerBuilder authenticationType(
                String authenticationType) {
            doSetProperty("authenticationType", authenticationType);
            return this;
        }
        /**
         * JSON Web Token sign algorithm.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.grpc.auth.jwt.JwtAlgorithm&lt;/code&gt; type.
         * 
         * Default: HMAC256
         * Group: security
         * 
         * @param jwtAlgorithm the value to set
         * @return the dsl builder
         */
        default GrpcEndpointConsumerBuilder jwtAlgorithm(
                org.apache.camel.component.grpc.auth.jwt.JwtAlgorithm jwtAlgorithm) {
            doSetProperty("jwtAlgorithm", jwtAlgorithm);
            return this;
        }
        /**
         * JSON Web Token sign algorithm.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.grpc.auth.jwt.JwtAlgorithm&lt;/code&gt; type.
         * 
         * Default: HMAC256
         * Group: security
         * 
         * @param jwtAlgorithm the value to set
         * @return the dsl builder
         */
        default GrpcEndpointConsumerBuilder jwtAlgorithm(String jwtAlgorithm) {
            doSetProperty("jwtAlgorithm", jwtAlgorithm);
            return this;
        }
        /**
         * JSON Web Token issuer.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param jwtIssuer the value to set
         * @return the dsl builder
         */
        default GrpcEndpointConsumerBuilder jwtIssuer(String jwtIssuer) {
            doSetProperty("jwtIssuer", jwtIssuer);
            return this;
        }
        /**
         * JSON Web Token secret.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param jwtSecret the value to set
         * @return the dsl builder
         */
        default GrpcEndpointConsumerBuilder jwtSecret(String jwtSecret) {
            doSetProperty("jwtSecret", jwtSecret);
            return this;
        }
        /**
         * JSON Web Token subject.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param jwtSubject the value to set
         * @return the dsl builder
         */
        default GrpcEndpointConsumerBuilder jwtSubject(String jwtSubject) {
            doSetProperty("jwtSubject", jwtSubject);
            return this;
        }
        /**
         * The X.509 certificate chain file resource in PEM format link.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param keyCertChainResource the value to set
         * @return the dsl builder
         */
        default GrpcEndpointConsumerBuilder keyCertChainResource(
                String keyCertChainResource) {
            doSetProperty("keyCertChainResource", keyCertChainResource);
            return this;
        }
        /**
         * The PKCS#8 private key file password.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param keyPassword the value to set
         * @return the dsl builder
         */
        default GrpcEndpointConsumerBuilder keyPassword(String keyPassword) {
            doSetProperty("keyPassword", keyPassword);
            return this;
        }
        /**
         * The PKCS#8 private key file resource in PEM format link.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param keyResource the value to set
         * @return the dsl builder
         */
        default GrpcEndpointConsumerBuilder keyResource(String keyResource) {
            doSetProperty("keyResource", keyResource);
            return this;
        }
        /**
         * Identifies the security negotiation type used for HTTP/2
         * communication.
         * 
         * The option is a:
         * &lt;code&gt;io.grpc.netty.NegotiationType&lt;/code&gt; type.
         * 
         * Default: PLAINTEXT
         * Group: security
         * 
         * @param negotiationType the value to set
         * @return the dsl builder
         */
        default GrpcEndpointConsumerBuilder negotiationType(
                io.grpc.netty.NegotiationType negotiationType) {
            doSetProperty("negotiationType", negotiationType);
            return this;
        }
        /**
         * Identifies the security negotiation type used for HTTP/2
         * communication.
         * 
         * The option will be converted to a
         * &lt;code&gt;io.grpc.netty.NegotiationType&lt;/code&gt; type.
         * 
         * Default: PLAINTEXT
         * Group: security
         * 
         * @param negotiationType the value to set
         * @return the dsl builder
         */
        default GrpcEndpointConsumerBuilder negotiationType(
                String negotiationType) {
            doSetProperty("negotiationType", negotiationType);
            return this;
        }
        /**
         * Service Account key file in JSON format resource link supported by
         * the Google Cloud SDK.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param serviceAccountResource the value to set
         * @return the dsl builder
         */
        default GrpcEndpointConsumerBuilder serviceAccountResource(
                String serviceAccountResource) {
            doSetProperty("serviceAccountResource", serviceAccountResource);
            return this;
        }
        /**
         * The trusted certificates collection file resource in PEM format for
         * verifying the remote endpoint's certificate.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param trustCertCollectionResource the value to set
         * @return the dsl builder
         */
        default GrpcEndpointConsumerBuilder trustCertCollectionResource(
                String trustCertCollectionResource) {
            doSetProperty("trustCertCollectionResource", trustCertCollectionResource);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the gRPC component.
     */
    public interface AdvancedGrpcEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default GrpcEndpointConsumerBuilder basic() {
            return (GrpcEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedGrpcEndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedGrpcEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedGrpcEndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedGrpcEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedGrpcEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedGrpcEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the gRPC component.
     */
    public interface GrpcEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedGrpcEndpointProducerBuilder advanced() {
            return (AdvancedGrpcEndpointProducerBuilder) this;
        }
        /**
         * Setting the autoDiscoverClientInterceptors mechanism, if true, the
         * component will look for a ClientInterceptor instance in the registry
         * automatically otherwise it will skip that checking.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoDiscoverClientInterceptors the value to set
         * @return the dsl builder
         */
        default GrpcEndpointProducerBuilder autoDiscoverClientInterceptors(
                boolean autoDiscoverClientInterceptors) {
            doSetProperty("autoDiscoverClientInterceptors", autoDiscoverClientInterceptors);
            return this;
        }
        /**
         * Setting the autoDiscoverClientInterceptors mechanism, if true, the
         * component will look for a ClientInterceptor instance in the registry
         * automatically otherwise it will skip that checking.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoDiscoverClientInterceptors the value to set
         * @return the dsl builder
         */
        default GrpcEndpointProducerBuilder autoDiscoverClientInterceptors(
                String autoDiscoverClientInterceptors) {
            doSetProperty("autoDiscoverClientInterceptors", autoDiscoverClientInterceptors);
            return this;
        }
        /**
         * The HTTP/2 flow control window size (MiB).
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1048576
         * Group: common
         * 
         * @param flowControlWindow the value to set
         * @return the dsl builder
         */
        default GrpcEndpointProducerBuilder flowControlWindow(
                int flowControlWindow) {
            doSetProperty("flowControlWindow", flowControlWindow);
            return this;
        }
        /**
         * The HTTP/2 flow control window size (MiB).
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1048576
         * Group: common
         * 
         * @param flowControlWindow the value to set
         * @return the dsl builder
         */
        default GrpcEndpointProducerBuilder flowControlWindow(
                String flowControlWindow) {
            doSetProperty("flowControlWindow", flowControlWindow);
            return this;
        }
        /**
         * The maximum message size allowed to be received/sent (MiB).
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 4194304
         * Group: common
         * 
         * @param maxMessageSize the value to set
         * @return the dsl builder
         */
        default GrpcEndpointProducerBuilder maxMessageSize(int maxMessageSize) {
            doSetProperty("maxMessageSize", maxMessageSize);
            return this;
        }
        /**
         * The maximum message size allowed to be received/sent (MiB).
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 4194304
         * Group: common
         * 
         * @param maxMessageSize the value to set
         * @return the dsl builder
         */
        default GrpcEndpointProducerBuilder maxMessageSize(String maxMessageSize) {
            doSetProperty("maxMessageSize", maxMessageSize);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default GrpcEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default GrpcEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * gRPC method name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param method the value to set
         * @return the dsl builder
         */
        default GrpcEndpointProducerBuilder method(String method) {
            doSetProperty("method", method);
            return this;
        }
        /**
         * The mode used to communicate with a remote gRPC server. In SIMPLE
         * mode a single exchange is translated into a remote procedure call. In
         * STREAMING mode all exchanges will be sent within the same request
         * (input and output of the recipient gRPC service must be of type
         * 'stream').
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.grpc.GrpcProducerStrategy&lt;/code&gt; type.
         * 
         * Default: SIMPLE
         * Group: producer
         * 
         * @param producerStrategy the value to set
         * @return the dsl builder
         */
        default GrpcEndpointProducerBuilder producerStrategy(
                org.apache.camel.component.grpc.GrpcProducerStrategy producerStrategy) {
            doSetProperty("producerStrategy", producerStrategy);
            return this;
        }
        /**
         * The mode used to communicate with a remote gRPC server. In SIMPLE
         * mode a single exchange is translated into a remote procedure call. In
         * STREAMING mode all exchanges will be sent within the same request
         * (input and output of the recipient gRPC service must be of type
         * 'stream').
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.grpc.GrpcProducerStrategy&lt;/code&gt; type.
         * 
         * Default: SIMPLE
         * Group: producer
         * 
         * @param producerStrategy the value to set
         * @return the dsl builder
         */
        default GrpcEndpointProducerBuilder producerStrategy(
                String producerStrategy) {
            doSetProperty("producerStrategy", producerStrategy);
            return this;
        }
        /**
         * When using STREAMING client mode, it indicates the endpoint where
         * responses should be forwarded.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param streamRepliesTo the value to set
         * @return the dsl builder
         */
        default GrpcEndpointProducerBuilder streamRepliesTo(
                String streamRepliesTo) {
            doSetProperty("streamRepliesTo", streamRepliesTo);
            return this;
        }
        /**
         * The user agent header passed to the server.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param userAgent the value to set
         * @return the dsl builder
         */
        default GrpcEndpointProducerBuilder userAgent(String userAgent) {
            doSetProperty("userAgent", userAgent);
            return this;
        }
        /**
         * Authentication method type in advance to the SSL/TLS negotiation.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.grpc.GrpcAuthType&lt;/code&gt;
         * type.
         * 
         * Default: NONE
         * Group: security
         * 
         * @param authenticationType the value to set
         * @return the dsl builder
         */
        default GrpcEndpointProducerBuilder authenticationType(
                org.apache.camel.component.grpc.GrpcAuthType authenticationType) {
            doSetProperty("authenticationType", authenticationType);
            return this;
        }
        /**
         * Authentication method type in advance to the SSL/TLS negotiation.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.grpc.GrpcAuthType&lt;/code&gt;
         * type.
         * 
         * Default: NONE
         * Group: security
         * 
         * @param authenticationType the value to set
         * @return the dsl builder
         */
        default GrpcEndpointProducerBuilder authenticationType(
                String authenticationType) {
            doSetProperty("authenticationType", authenticationType);
            return this;
        }
        /**
         * JSON Web Token sign algorithm.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.grpc.auth.jwt.JwtAlgorithm&lt;/code&gt; type.
         * 
         * Default: HMAC256
         * Group: security
         * 
         * @param jwtAlgorithm the value to set
         * @return the dsl builder
         */
        default GrpcEndpointProducerBuilder jwtAlgorithm(
                org.apache.camel.component.grpc.auth.jwt.JwtAlgorithm jwtAlgorithm) {
            doSetProperty("jwtAlgorithm", jwtAlgorithm);
            return this;
        }
        /**
         * JSON Web Token sign algorithm.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.grpc.auth.jwt.JwtAlgorithm&lt;/code&gt; type.
         * 
         * Default: HMAC256
         * Group: security
         * 
         * @param jwtAlgorithm the value to set
         * @return the dsl builder
         */
        default GrpcEndpointProducerBuilder jwtAlgorithm(String jwtAlgorithm) {
            doSetProperty("jwtAlgorithm", jwtAlgorithm);
            return this;
        }
        /**
         * JSON Web Token issuer.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param jwtIssuer the value to set
         * @return the dsl builder
         */
        default GrpcEndpointProducerBuilder jwtIssuer(String jwtIssuer) {
            doSetProperty("jwtIssuer", jwtIssuer);
            return this;
        }
        /**
         * JSON Web Token secret.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param jwtSecret the value to set
         * @return the dsl builder
         */
        default GrpcEndpointProducerBuilder jwtSecret(String jwtSecret) {
            doSetProperty("jwtSecret", jwtSecret);
            return this;
        }
        /**
         * JSON Web Token subject.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param jwtSubject the value to set
         * @return the dsl builder
         */
        default GrpcEndpointProducerBuilder jwtSubject(String jwtSubject) {
            doSetProperty("jwtSubject", jwtSubject);
            return this;
        }
        /**
         * The X.509 certificate chain file resource in PEM format link.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param keyCertChainResource the value to set
         * @return the dsl builder
         */
        default GrpcEndpointProducerBuilder keyCertChainResource(
                String keyCertChainResource) {
            doSetProperty("keyCertChainResource", keyCertChainResource);
            return this;
        }
        /**
         * The PKCS#8 private key file password.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param keyPassword the value to set
         * @return the dsl builder
         */
        default GrpcEndpointProducerBuilder keyPassword(String keyPassword) {
            doSetProperty("keyPassword", keyPassword);
            return this;
        }
        /**
         * The PKCS#8 private key file resource in PEM format link.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param keyResource the value to set
         * @return the dsl builder
         */
        default GrpcEndpointProducerBuilder keyResource(String keyResource) {
            doSetProperty("keyResource", keyResource);
            return this;
        }
        /**
         * Identifies the security negotiation type used for HTTP/2
         * communication.
         * 
         * The option is a:
         * &lt;code&gt;io.grpc.netty.NegotiationType&lt;/code&gt; type.
         * 
         * Default: PLAINTEXT
         * Group: security
         * 
         * @param negotiationType the value to set
         * @return the dsl builder
         */
        default GrpcEndpointProducerBuilder negotiationType(
                io.grpc.netty.NegotiationType negotiationType) {
            doSetProperty("negotiationType", negotiationType);
            return this;
        }
        /**
         * Identifies the security negotiation type used for HTTP/2
         * communication.
         * 
         * The option will be converted to a
         * &lt;code&gt;io.grpc.netty.NegotiationType&lt;/code&gt; type.
         * 
         * Default: PLAINTEXT
         * Group: security
         * 
         * @param negotiationType the value to set
         * @return the dsl builder
         */
        default GrpcEndpointProducerBuilder negotiationType(
                String negotiationType) {
            doSetProperty("negotiationType", negotiationType);
            return this;
        }
        /**
         * Service Account key file in JSON format resource link supported by
         * the Google Cloud SDK.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param serviceAccountResource the value to set
         * @return the dsl builder
         */
        default GrpcEndpointProducerBuilder serviceAccountResource(
                String serviceAccountResource) {
            doSetProperty("serviceAccountResource", serviceAccountResource);
            return this;
        }
        /**
         * The trusted certificates collection file resource in PEM format for
         * verifying the remote endpoint's certificate.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param trustCertCollectionResource the value to set
         * @return the dsl builder
         */
        default GrpcEndpointProducerBuilder trustCertCollectionResource(
                String trustCertCollectionResource) {
            doSetProperty("trustCertCollectionResource", trustCertCollectionResource);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the gRPC component.
     */
    public interface AdvancedGrpcEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default GrpcEndpointProducerBuilder basic() {
            return (GrpcEndpointProducerBuilder) this;
        }
        /**
         * Sets whether synchronous processing should be strictly used.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedGrpcEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedGrpcEndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the gRPC component.
     */
    public interface GrpcEndpointBuilder
            extends
                GrpcEndpointConsumerBuilder,
                GrpcEndpointProducerBuilder {
        default AdvancedGrpcEndpointBuilder advanced() {
            return (AdvancedGrpcEndpointBuilder) this;
        }
        /**
         * Setting the autoDiscoverClientInterceptors mechanism, if true, the
         * component will look for a ClientInterceptor instance in the registry
         * automatically otherwise it will skip that checking.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoDiscoverClientInterceptors the value to set
         * @return the dsl builder
         */
        default GrpcEndpointBuilder autoDiscoverClientInterceptors(
                boolean autoDiscoverClientInterceptors) {
            doSetProperty("autoDiscoverClientInterceptors", autoDiscoverClientInterceptors);
            return this;
        }
        /**
         * Setting the autoDiscoverClientInterceptors mechanism, if true, the
         * component will look for a ClientInterceptor instance in the registry
         * automatically otherwise it will skip that checking.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoDiscoverClientInterceptors the value to set
         * @return the dsl builder
         */
        default GrpcEndpointBuilder autoDiscoverClientInterceptors(
                String autoDiscoverClientInterceptors) {
            doSetProperty("autoDiscoverClientInterceptors", autoDiscoverClientInterceptors);
            return this;
        }
        /**
         * The HTTP/2 flow control window size (MiB).
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1048576
         * Group: common
         * 
         * @param flowControlWindow the value to set
         * @return the dsl builder
         */
        default GrpcEndpointBuilder flowControlWindow(int flowControlWindow) {
            doSetProperty("flowControlWindow", flowControlWindow);
            return this;
        }
        /**
         * The HTTP/2 flow control window size (MiB).
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1048576
         * Group: common
         * 
         * @param flowControlWindow the value to set
         * @return the dsl builder
         */
        default GrpcEndpointBuilder flowControlWindow(String flowControlWindow) {
            doSetProperty("flowControlWindow", flowControlWindow);
            return this;
        }
        /**
         * The maximum message size allowed to be received/sent (MiB).
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 4194304
         * Group: common
         * 
         * @param maxMessageSize the value to set
         * @return the dsl builder
         */
        default GrpcEndpointBuilder maxMessageSize(int maxMessageSize) {
            doSetProperty("maxMessageSize", maxMessageSize);
            return this;
        }
        /**
         * The maximum message size allowed to be received/sent (MiB).
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 4194304
         * Group: common
         * 
         * @param maxMessageSize the value to set
         * @return the dsl builder
         */
        default GrpcEndpointBuilder maxMessageSize(String maxMessageSize) {
            doSetProperty("maxMessageSize", maxMessageSize);
            return this;
        }
        /**
         * Authentication method type in advance to the SSL/TLS negotiation.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.grpc.GrpcAuthType&lt;/code&gt;
         * type.
         * 
         * Default: NONE
         * Group: security
         * 
         * @param authenticationType the value to set
         * @return the dsl builder
         */
        default GrpcEndpointBuilder authenticationType(
                org.apache.camel.component.grpc.GrpcAuthType authenticationType) {
            doSetProperty("authenticationType", authenticationType);
            return this;
        }
        /**
         * Authentication method type in advance to the SSL/TLS negotiation.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.grpc.GrpcAuthType&lt;/code&gt;
         * type.
         * 
         * Default: NONE
         * Group: security
         * 
         * @param authenticationType the value to set
         * @return the dsl builder
         */
        default GrpcEndpointBuilder authenticationType(String authenticationType) {
            doSetProperty("authenticationType", authenticationType);
            return this;
        }
        /**
         * JSON Web Token sign algorithm.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.grpc.auth.jwt.JwtAlgorithm&lt;/code&gt; type.
         * 
         * Default: HMAC256
         * Group: security
         * 
         * @param jwtAlgorithm the value to set
         * @return the dsl builder
         */
        default GrpcEndpointBuilder jwtAlgorithm(
                org.apache.camel.component.grpc.auth.jwt.JwtAlgorithm jwtAlgorithm) {
            doSetProperty("jwtAlgorithm", jwtAlgorithm);
            return this;
        }
        /**
         * JSON Web Token sign algorithm.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.grpc.auth.jwt.JwtAlgorithm&lt;/code&gt; type.
         * 
         * Default: HMAC256
         * Group: security
         * 
         * @param jwtAlgorithm the value to set
         * @return the dsl builder
         */
        default GrpcEndpointBuilder jwtAlgorithm(String jwtAlgorithm) {
            doSetProperty("jwtAlgorithm", jwtAlgorithm);
            return this;
        }
        /**
         * JSON Web Token issuer.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param jwtIssuer the value to set
         * @return the dsl builder
         */
        default GrpcEndpointBuilder jwtIssuer(String jwtIssuer) {
            doSetProperty("jwtIssuer", jwtIssuer);
            return this;
        }
        /**
         * JSON Web Token secret.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param jwtSecret the value to set
         * @return the dsl builder
         */
        default GrpcEndpointBuilder jwtSecret(String jwtSecret) {
            doSetProperty("jwtSecret", jwtSecret);
            return this;
        }
        /**
         * JSON Web Token subject.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param jwtSubject the value to set
         * @return the dsl builder
         */
        default GrpcEndpointBuilder jwtSubject(String jwtSubject) {
            doSetProperty("jwtSubject", jwtSubject);
            return this;
        }
        /**
         * The X.509 certificate chain file resource in PEM format link.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param keyCertChainResource the value to set
         * @return the dsl builder
         */
        default GrpcEndpointBuilder keyCertChainResource(
                String keyCertChainResource) {
            doSetProperty("keyCertChainResource", keyCertChainResource);
            return this;
        }
        /**
         * The PKCS#8 private key file password.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param keyPassword the value to set
         * @return the dsl builder
         */
        default GrpcEndpointBuilder keyPassword(String keyPassword) {
            doSetProperty("keyPassword", keyPassword);
            return this;
        }
        /**
         * The PKCS#8 private key file resource in PEM format link.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param keyResource the value to set
         * @return the dsl builder
         */
        default GrpcEndpointBuilder keyResource(String keyResource) {
            doSetProperty("keyResource", keyResource);
            return this;
        }
        /**
         * Identifies the security negotiation type used for HTTP/2
         * communication.
         * 
         * The option is a:
         * &lt;code&gt;io.grpc.netty.NegotiationType&lt;/code&gt; type.
         * 
         * Default: PLAINTEXT
         * Group: security
         * 
         * @param negotiationType the value to set
         * @return the dsl builder
         */
        default GrpcEndpointBuilder negotiationType(
                io.grpc.netty.NegotiationType negotiationType) {
            doSetProperty("negotiationType", negotiationType);
            return this;
        }
        /**
         * Identifies the security negotiation type used for HTTP/2
         * communication.
         * 
         * The option will be converted to a
         * &lt;code&gt;io.grpc.netty.NegotiationType&lt;/code&gt; type.
         * 
         * Default: PLAINTEXT
         * Group: security
         * 
         * @param negotiationType the value to set
         * @return the dsl builder
         */
        default GrpcEndpointBuilder negotiationType(String negotiationType) {
            doSetProperty("negotiationType", negotiationType);
            return this;
        }
        /**
         * Service Account key file in JSON format resource link supported by
         * the Google Cloud SDK.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param serviceAccountResource the value to set
         * @return the dsl builder
         */
        default GrpcEndpointBuilder serviceAccountResource(
                String serviceAccountResource) {
            doSetProperty("serviceAccountResource", serviceAccountResource);
            return this;
        }
        /**
         * The trusted certificates collection file resource in PEM format for
         * verifying the remote endpoint's certificate.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param trustCertCollectionResource the value to set
         * @return the dsl builder
         */
        default GrpcEndpointBuilder trustCertCollectionResource(
                String trustCertCollectionResource) {
            doSetProperty("trustCertCollectionResource", trustCertCollectionResource);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the gRPC component.
     */
    public interface AdvancedGrpcEndpointBuilder
            extends
                AdvancedGrpcEndpointConsumerBuilder,
                AdvancedGrpcEndpointProducerBuilder {
        default GrpcEndpointBuilder basic() {
            return (GrpcEndpointBuilder) this;
        }
        /**
         * Sets whether synchronous processing should be strictly used.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedGrpcEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedGrpcEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    public interface GrpcBuilders {
        /**
         * gRPC (camel-grpc)
         * Expose gRPC endpoints and access external gRPC endpoints.
         * 
         * Category: rpc
         * Since: 2.19
         * Maven coordinates: org.apache.camel:camel-grpc
         * 
         * Syntax: <code>grpc:host:port/service</code>
         * 
         * Path parameter: host (required)
         * The gRPC server host name. This is localhost or 0.0.0.0 when being a
         * consumer or remote server host name when using producer.
         * 
         * Path parameter: port (required)
         * The gRPC local or remote server port
         * 
         * Path parameter: service (required)
         * Fully qualified service name from the protocol buffer descriptor file
         * (package dot service definition name)
         * 
         * @param path host:port/service
         * @return the dsl builder
         */
        default GrpcEndpointBuilder grpc(String path) {
            return GrpcEndpointBuilderFactory.endpointBuilder("grpc", path);
        }
        /**
         * gRPC (camel-grpc)
         * Expose gRPC endpoints and access external gRPC endpoints.
         * 
         * Category: rpc
         * Since: 2.19
         * Maven coordinates: org.apache.camel:camel-grpc
         * 
         * Syntax: <code>grpc:host:port/service</code>
         * 
         * Path parameter: host (required)
         * The gRPC server host name. This is localhost or 0.0.0.0 when being a
         * consumer or remote server host name when using producer.
         * 
         * Path parameter: port (required)
         * The gRPC local or remote server port
         * 
         * Path parameter: service (required)
         * Fully qualified service name from the protocol buffer descriptor file
         * (package dot service definition name)
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path host:port/service
         * @return the dsl builder
         */
        default GrpcEndpointBuilder grpc(String componentName, String path) {
            return GrpcEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    static GrpcEndpointBuilder endpointBuilder(String componentName, String path) {
        class GrpcEndpointBuilderImpl extends AbstractEndpointBuilder implements GrpcEndpointBuilder, AdvancedGrpcEndpointBuilder {
            public GrpcEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new GrpcEndpointBuilderImpl(path);
    }
}