/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Interact with jBPM workflow engine over REST.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface JBPMEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the JBPM component.
     */
    public interface JBPMEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedJBPMEndpointConsumerBuilder advanced() {
            return (AdvancedJBPMEndpointConsumerBuilder) this;
        }
        /**
         * attachId to use when retrieving attachments.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param attachmentId the value to set
         * @return the dsl builder
         */
        default JBPMEndpointConsumerBuilder attachmentId(Long attachmentId) {
            doSetProperty("attachmentId", attachmentId);
            return this;
        }
        /**
         * attachId to use when retrieving attachments.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param attachmentId the value to set
         * @return the dsl builder
         */
        default JBPMEndpointConsumerBuilder attachmentId(String attachmentId) {
            doSetProperty("attachmentId", attachmentId);
            return this;
        }
        /**
         * contentId to use when retrieving attachments.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param contentId the value to set
         * @return the dsl builder
         */
        default JBPMEndpointConsumerBuilder contentId(Long contentId) {
            doSetProperty("contentId", contentId);
            return this;
        }
        /**
         * contentId to use when retrieving attachments.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param contentId the value to set
         * @return the dsl builder
         */
        default JBPMEndpointConsumerBuilder contentId(String contentId) {
            doSetProperty("contentId", contentId);
            return this;
        }
        /**
         * The id of the deployment.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Required: true
         * Group: common
         * 
         * @param deploymentId the value to set
         * @return the dsl builder
         */
        default JBPMEndpointConsumerBuilder deploymentId(String deploymentId) {
            doSetProperty("deploymentId", deploymentId);
            return this;
        }
        /**
         * Sets if event produced by emitter should be sent as single items or
         * complete collection.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param emitterSendItems the value to set
         * @return the dsl builder
         */
        default JBPMEndpointConsumerBuilder emitterSendItems(
                Boolean emitterSendItems) {
            doSetProperty("emitterSendItems", emitterSendItems);
            return this;
        }
        /**
         * Sets if event produced by emitter should be sent as single items or
         * complete collection.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param emitterSendItems the value to set
         * @return the dsl builder
         */
        default JBPMEndpointConsumerBuilder emitterSendItems(
                String emitterSendItems) {
            doSetProperty("emitterSendItems", emitterSendItems);
            return this;
        }
        /**
         * the data associated with this event when signalEvent operation is
         * performed.
         * 
         * The option is a: &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param event the value to set
         * @return the dsl builder
         */
        default JBPMEndpointConsumerBuilder event(Object event) {
            doSetProperty("event", event);
            return this;
        }
        /**
         * the data associated with this event when signalEvent operation is
         * performed.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param event the value to set
         * @return the dsl builder
         */
        default JBPMEndpointConsumerBuilder event(String event) {
            doSetProperty("event", event);
            return this;
        }
        /**
         * the type of event to use when signalEvent operation is performed.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param eventType the value to set
         * @return the dsl builder
         */
        default JBPMEndpointConsumerBuilder eventType(String eventType) {
            doSetProperty("eventType", eventType);
            return this;
        }
        /**
         * identifier the global identifier.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param identifier the value to set
         * @return the dsl builder
         */
        default JBPMEndpointConsumerBuilder identifier(String identifier) {
            doSetProperty("identifier", identifier);
            return this;
        }
        /**
         * the maximum number of rules that should be fired.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param maxNumber the value to set
         * @return the dsl builder
         */
        default JBPMEndpointConsumerBuilder maxNumber(Integer maxNumber) {
            doSetProperty("maxNumber", maxNumber);
            return this;
        }
        /**
         * the maximum number of rules that should be fired.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param maxNumber the value to set
         * @return the dsl builder
         */
        default JBPMEndpointConsumerBuilder maxNumber(String maxNumber) {
            doSetProperty("maxNumber", maxNumber);
            return this;
        }
        /**
         * The page to use when retrieving user tasks.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param page the value to set
         * @return the dsl builder
         */
        default JBPMEndpointConsumerBuilder page(Integer page) {
            doSetProperty("page", page);
            return this;
        }
        /**
         * The page to use when retrieving user tasks.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param page the value to set
         * @return the dsl builder
         */
        default JBPMEndpointConsumerBuilder page(String page) {
            doSetProperty("page", page);
            return this;
        }
        /**
         * The page size to use when retrieving user tasks.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param pageSize the value to set
         * @return the dsl builder
         */
        default JBPMEndpointConsumerBuilder pageSize(Integer pageSize) {
            doSetProperty("pageSize", pageSize);
            return this;
        }
        /**
         * The page size to use when retrieving user tasks.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param pageSize the value to set
         * @return the dsl builder
         */
        default JBPMEndpointConsumerBuilder pageSize(String pageSize) {
            doSetProperty("pageSize", pageSize);
            return this;
        }
        /**
         * the id of the process that should be acted upon.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param processId the value to set
         * @return the dsl builder
         */
        default JBPMEndpointConsumerBuilder processId(String processId) {
            doSetProperty("processId", processId);
            return this;
        }
        /**
         * the id of the process instance.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param processInstanceId the value to set
         * @return the dsl builder
         */
        default JBPMEndpointConsumerBuilder processInstanceId(
                Long processInstanceId) {
            doSetProperty("processInstanceId", processInstanceId);
            return this;
        }
        /**
         * the id of the process instance.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param processInstanceId the value to set
         * @return the dsl builder
         */
        default JBPMEndpointConsumerBuilder processInstanceId(
                String processInstanceId) {
            doSetProperty("processInstanceId", processInstanceId);
            return this;
        }
        /**
         * The targetUserId used when delegating a task.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param targetUserId the value to set
         * @return the dsl builder
         */
        default JBPMEndpointConsumerBuilder targetUserId(String targetUserId) {
            doSetProperty("targetUserId", targetUserId);
            return this;
        }
        /**
         * The task instance to use with task operations.
         * 
         * The option is a: &lt;code&gt;org.kie.api.task.model.Task&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param task the value to set
         * @return the dsl builder
         */
        default JBPMEndpointConsumerBuilder task(
                org.kie.api.task.model.Task task) {
            doSetProperty("task", task);
            return this;
        }
        /**
         * The task instance to use with task operations.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.kie.api.task.model.Task&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param task the value to set
         * @return the dsl builder
         */
        default JBPMEndpointConsumerBuilder task(String task) {
            doSetProperty("task", task);
            return this;
        }
        /**
         * the id of the task.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param taskId the value to set
         * @return the dsl builder
         */
        default JBPMEndpointConsumerBuilder taskId(Long taskId) {
            doSetProperty("taskId", taskId);
            return this;
        }
        /**
         * the id of the task.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param taskId the value to set
         * @return the dsl builder
         */
        default JBPMEndpointConsumerBuilder taskId(String taskId) {
            doSetProperty("taskId", taskId);
            return this;
        }
        /**
         * A timeout value.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default JBPMEndpointConsumerBuilder timeout(Integer timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * A timeout value.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default JBPMEndpointConsumerBuilder timeout(String timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * userId to use with task operations.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param userId the value to set
         * @return the dsl builder
         */
        default JBPMEndpointConsumerBuilder userId(String userId) {
            doSetProperty("userId", userId);
            return this;
        }
        /**
         * the value to assign to the global identifier.
         * 
         * The option is a: &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param value the value to set
         * @return the dsl builder
         */
        default JBPMEndpointConsumerBuilder value(Object value) {
            doSetProperty("value", value);
            return this;
        }
        /**
         * the value to assign to the global identifier.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param value the value to set
         * @return the dsl builder
         */
        default JBPMEndpointConsumerBuilder value(String value) {
            doSetProperty("value", value);
            return this;
        }
        /**
         * the id of the work item.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param workItemId the value to set
         * @return the dsl builder
         */
        default JBPMEndpointConsumerBuilder workItemId(Long workItemId) {
            doSetProperty("workItemId", workItemId);
            return this;
        }
        /**
         * the id of the work item.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param workItemId the value to set
         * @return the dsl builder
         */
        default JBPMEndpointConsumerBuilder workItemId(String workItemId) {
            doSetProperty("workItemId", workItemId);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default JBPMEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default JBPMEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * The list of status to use when filtering tasks.
         * 
         * The option is a:
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: filter
         * 
         * @param statuses the value to set
         * @return the dsl builder
         */
        default JBPMEndpointConsumerBuilder statuses(
                List<java.lang.String> statuses) {
            doSetProperty("statuses", statuses);
            return this;
        }
        /**
         * The list of status to use when filtering tasks.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: filter
         * 
         * @param statuses the value to set
         * @return the dsl builder
         */
        default JBPMEndpointConsumerBuilder statuses(String statuses) {
            doSetProperty("statuses", statuses);
            return this;
        }
        /**
         * Password for authentication.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default JBPMEndpointConsumerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Username for authentication.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param userName the value to set
         * @return the dsl builder
         */
        default JBPMEndpointConsumerBuilder userName(String userName) {
            doSetProperty("userName", userName);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the JBPM component.
     */
    public interface AdvancedJBPMEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default JBPMEndpointConsumerBuilder basic() {
            return (JBPMEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedJBPMEndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedJBPMEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedJBPMEndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedJBPMEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedJBPMEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedJBPMEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * The potentialOwners when nominateTask operation is performed.
         * 
         * The option is a:
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param entities the value to set
         * @return the dsl builder
         */
        default AdvancedJBPMEndpointConsumerBuilder entities(
                List<java.lang.String> entities) {
            doSetProperty("entities", entities);
            return this;
        }
        /**
         * The potentialOwners when nominateTask operation is performed.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param entities the value to set
         * @return the dsl builder
         */
        default AdvancedJBPMEndpointConsumerBuilder entities(String entities) {
            doSetProperty("entities", entities);
            return this;
        }
        /**
         * To load additional classes when working with XML.
         * 
         * The option is a: &lt;code&gt;java.lang.Class[]&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param extraJaxbClasses the value to set
         * @return the dsl builder
         */
        default AdvancedJBPMEndpointConsumerBuilder extraJaxbClasses(
                Class[] extraJaxbClasses) {
            doSetProperty("extraJaxbClasses", extraJaxbClasses);
            return this;
        }
        /**
         * To load additional classes when working with XML.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Class[]&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param extraJaxbClasses the value to set
         * @return the dsl builder
         */
        default AdvancedJBPMEndpointConsumerBuilder extraJaxbClasses(
                String extraJaxbClasses) {
            doSetProperty("extraJaxbClasses", extraJaxbClasses);
            return this;
        }
        /**
         * the variables that should be set for various operations.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param parameters the value to set
         * @return the dsl builder
         */
        default AdvancedJBPMEndpointConsumerBuilder parameters(
                Map<java.lang.String, java.lang.Object> parameters) {
            doSetProperty("parameters", parameters);
            return this;
        }
        /**
         * the variables that should be set for various operations.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param parameters the value to set
         * @return the dsl builder
         */
        default AdvancedJBPMEndpointConsumerBuilder parameters(String parameters) {
            doSetProperty("parameters", parameters);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the JBPM component.
     */
    public interface JBPMEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedJBPMEndpointProducerBuilder advanced() {
            return (AdvancedJBPMEndpointProducerBuilder) this;
        }
        /**
         * attachId to use when retrieving attachments.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param attachmentId the value to set
         * @return the dsl builder
         */
        default JBPMEndpointProducerBuilder attachmentId(Long attachmentId) {
            doSetProperty("attachmentId", attachmentId);
            return this;
        }
        /**
         * attachId to use when retrieving attachments.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param attachmentId the value to set
         * @return the dsl builder
         */
        default JBPMEndpointProducerBuilder attachmentId(String attachmentId) {
            doSetProperty("attachmentId", attachmentId);
            return this;
        }
        /**
         * contentId to use when retrieving attachments.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param contentId the value to set
         * @return the dsl builder
         */
        default JBPMEndpointProducerBuilder contentId(Long contentId) {
            doSetProperty("contentId", contentId);
            return this;
        }
        /**
         * contentId to use when retrieving attachments.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param contentId the value to set
         * @return the dsl builder
         */
        default JBPMEndpointProducerBuilder contentId(String contentId) {
            doSetProperty("contentId", contentId);
            return this;
        }
        /**
         * The id of the deployment.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Required: true
         * Group: common
         * 
         * @param deploymentId the value to set
         * @return the dsl builder
         */
        default JBPMEndpointProducerBuilder deploymentId(String deploymentId) {
            doSetProperty("deploymentId", deploymentId);
            return this;
        }
        /**
         * Sets if event produced by emitter should be sent as single items or
         * complete collection.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param emitterSendItems the value to set
         * @return the dsl builder
         */
        default JBPMEndpointProducerBuilder emitterSendItems(
                Boolean emitterSendItems) {
            doSetProperty("emitterSendItems", emitterSendItems);
            return this;
        }
        /**
         * Sets if event produced by emitter should be sent as single items or
         * complete collection.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param emitterSendItems the value to set
         * @return the dsl builder
         */
        default JBPMEndpointProducerBuilder emitterSendItems(
                String emitterSendItems) {
            doSetProperty("emitterSendItems", emitterSendItems);
            return this;
        }
        /**
         * the data associated with this event when signalEvent operation is
         * performed.
         * 
         * The option is a: &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param event the value to set
         * @return the dsl builder
         */
        default JBPMEndpointProducerBuilder event(Object event) {
            doSetProperty("event", event);
            return this;
        }
        /**
         * the data associated with this event when signalEvent operation is
         * performed.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param event the value to set
         * @return the dsl builder
         */
        default JBPMEndpointProducerBuilder event(String event) {
            doSetProperty("event", event);
            return this;
        }
        /**
         * the type of event to use when signalEvent operation is performed.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param eventType the value to set
         * @return the dsl builder
         */
        default JBPMEndpointProducerBuilder eventType(String eventType) {
            doSetProperty("eventType", eventType);
            return this;
        }
        /**
         * identifier the global identifier.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param identifier the value to set
         * @return the dsl builder
         */
        default JBPMEndpointProducerBuilder identifier(String identifier) {
            doSetProperty("identifier", identifier);
            return this;
        }
        /**
         * the maximum number of rules that should be fired.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param maxNumber the value to set
         * @return the dsl builder
         */
        default JBPMEndpointProducerBuilder maxNumber(Integer maxNumber) {
            doSetProperty("maxNumber", maxNumber);
            return this;
        }
        /**
         * the maximum number of rules that should be fired.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param maxNumber the value to set
         * @return the dsl builder
         */
        default JBPMEndpointProducerBuilder maxNumber(String maxNumber) {
            doSetProperty("maxNumber", maxNumber);
            return this;
        }
        /**
         * The page to use when retrieving user tasks.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param page the value to set
         * @return the dsl builder
         */
        default JBPMEndpointProducerBuilder page(Integer page) {
            doSetProperty("page", page);
            return this;
        }
        /**
         * The page to use when retrieving user tasks.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param page the value to set
         * @return the dsl builder
         */
        default JBPMEndpointProducerBuilder page(String page) {
            doSetProperty("page", page);
            return this;
        }
        /**
         * The page size to use when retrieving user tasks.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param pageSize the value to set
         * @return the dsl builder
         */
        default JBPMEndpointProducerBuilder pageSize(Integer pageSize) {
            doSetProperty("pageSize", pageSize);
            return this;
        }
        /**
         * The page size to use when retrieving user tasks.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param pageSize the value to set
         * @return the dsl builder
         */
        default JBPMEndpointProducerBuilder pageSize(String pageSize) {
            doSetProperty("pageSize", pageSize);
            return this;
        }
        /**
         * the id of the process that should be acted upon.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param processId the value to set
         * @return the dsl builder
         */
        default JBPMEndpointProducerBuilder processId(String processId) {
            doSetProperty("processId", processId);
            return this;
        }
        /**
         * the id of the process instance.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param processInstanceId the value to set
         * @return the dsl builder
         */
        default JBPMEndpointProducerBuilder processInstanceId(
                Long processInstanceId) {
            doSetProperty("processInstanceId", processInstanceId);
            return this;
        }
        /**
         * the id of the process instance.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param processInstanceId the value to set
         * @return the dsl builder
         */
        default JBPMEndpointProducerBuilder processInstanceId(
                String processInstanceId) {
            doSetProperty("processInstanceId", processInstanceId);
            return this;
        }
        /**
         * The targetUserId used when delegating a task.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param targetUserId the value to set
         * @return the dsl builder
         */
        default JBPMEndpointProducerBuilder targetUserId(String targetUserId) {
            doSetProperty("targetUserId", targetUserId);
            return this;
        }
        /**
         * The task instance to use with task operations.
         * 
         * The option is a: &lt;code&gt;org.kie.api.task.model.Task&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param task the value to set
         * @return the dsl builder
         */
        default JBPMEndpointProducerBuilder task(
                org.kie.api.task.model.Task task) {
            doSetProperty("task", task);
            return this;
        }
        /**
         * The task instance to use with task operations.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.kie.api.task.model.Task&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param task the value to set
         * @return the dsl builder
         */
        default JBPMEndpointProducerBuilder task(String task) {
            doSetProperty("task", task);
            return this;
        }
        /**
         * the id of the task.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param taskId the value to set
         * @return the dsl builder
         */
        default JBPMEndpointProducerBuilder taskId(Long taskId) {
            doSetProperty("taskId", taskId);
            return this;
        }
        /**
         * the id of the task.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param taskId the value to set
         * @return the dsl builder
         */
        default JBPMEndpointProducerBuilder taskId(String taskId) {
            doSetProperty("taskId", taskId);
            return this;
        }
        /**
         * A timeout value.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default JBPMEndpointProducerBuilder timeout(Integer timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * A timeout value.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default JBPMEndpointProducerBuilder timeout(String timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * userId to use with task operations.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param userId the value to set
         * @return the dsl builder
         */
        default JBPMEndpointProducerBuilder userId(String userId) {
            doSetProperty("userId", userId);
            return this;
        }
        /**
         * the value to assign to the global identifier.
         * 
         * The option is a: &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param value the value to set
         * @return the dsl builder
         */
        default JBPMEndpointProducerBuilder value(Object value) {
            doSetProperty("value", value);
            return this;
        }
        /**
         * the value to assign to the global identifier.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param value the value to set
         * @return the dsl builder
         */
        default JBPMEndpointProducerBuilder value(String value) {
            doSetProperty("value", value);
            return this;
        }
        /**
         * the id of the work item.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param workItemId the value to set
         * @return the dsl builder
         */
        default JBPMEndpointProducerBuilder workItemId(Long workItemId) {
            doSetProperty("workItemId", workItemId);
            return this;
        }
        /**
         * the id of the work item.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param workItemId the value to set
         * @return the dsl builder
         */
        default JBPMEndpointProducerBuilder workItemId(String workItemId) {
            doSetProperty("workItemId", workItemId);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default JBPMEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default JBPMEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * The operation to perform.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: startProcess
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default JBPMEndpointProducerBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * The list of status to use when filtering tasks.
         * 
         * The option is a:
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: filter
         * 
         * @param statuses the value to set
         * @return the dsl builder
         */
        default JBPMEndpointProducerBuilder statuses(
                List<java.lang.String> statuses) {
            doSetProperty("statuses", statuses);
            return this;
        }
        /**
         * The list of status to use when filtering tasks.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: filter
         * 
         * @param statuses the value to set
         * @return the dsl builder
         */
        default JBPMEndpointProducerBuilder statuses(String statuses) {
            doSetProperty("statuses", statuses);
            return this;
        }
        /**
         * Password for authentication.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default JBPMEndpointProducerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Username for authentication.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param userName the value to set
         * @return the dsl builder
         */
        default JBPMEndpointProducerBuilder userName(String userName) {
            doSetProperty("userName", userName);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the JBPM component.
     */
    public interface AdvancedJBPMEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default JBPMEndpointProducerBuilder basic() {
            return (JBPMEndpointProducerBuilder) this;
        }
        /**
         * The potentialOwners when nominateTask operation is performed.
         * 
         * The option is a:
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param entities the value to set
         * @return the dsl builder
         */
        default AdvancedJBPMEndpointProducerBuilder entities(
                List<java.lang.String> entities) {
            doSetProperty("entities", entities);
            return this;
        }
        /**
         * The potentialOwners when nominateTask operation is performed.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param entities the value to set
         * @return the dsl builder
         */
        default AdvancedJBPMEndpointProducerBuilder entities(String entities) {
            doSetProperty("entities", entities);
            return this;
        }
        /**
         * To load additional classes when working with XML.
         * 
         * The option is a: &lt;code&gt;java.lang.Class[]&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param extraJaxbClasses the value to set
         * @return the dsl builder
         */
        default AdvancedJBPMEndpointProducerBuilder extraJaxbClasses(
                Class[] extraJaxbClasses) {
            doSetProperty("extraJaxbClasses", extraJaxbClasses);
            return this;
        }
        /**
         * To load additional classes when working with XML.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Class[]&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param extraJaxbClasses the value to set
         * @return the dsl builder
         */
        default AdvancedJBPMEndpointProducerBuilder extraJaxbClasses(
                String extraJaxbClasses) {
            doSetProperty("extraJaxbClasses", extraJaxbClasses);
            return this;
        }
        /**
         * the variables that should be set for various operations.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param parameters the value to set
         * @return the dsl builder
         */
        default AdvancedJBPMEndpointProducerBuilder parameters(
                Map<java.lang.String, java.lang.Object> parameters) {
            doSetProperty("parameters", parameters);
            return this;
        }
        /**
         * the variables that should be set for various operations.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param parameters the value to set
         * @return the dsl builder
         */
        default AdvancedJBPMEndpointProducerBuilder parameters(String parameters) {
            doSetProperty("parameters", parameters);
            return this;
        }
    }

    /**
     * Builder for endpoint for the JBPM component.
     */
    public interface JBPMEndpointBuilder
            extends
                JBPMEndpointConsumerBuilder,
                JBPMEndpointProducerBuilder {
        default AdvancedJBPMEndpointBuilder advanced() {
            return (AdvancedJBPMEndpointBuilder) this;
        }
        /**
         * attachId to use when retrieving attachments.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param attachmentId the value to set
         * @return the dsl builder
         */
        default JBPMEndpointBuilder attachmentId(Long attachmentId) {
            doSetProperty("attachmentId", attachmentId);
            return this;
        }
        /**
         * attachId to use when retrieving attachments.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param attachmentId the value to set
         * @return the dsl builder
         */
        default JBPMEndpointBuilder attachmentId(String attachmentId) {
            doSetProperty("attachmentId", attachmentId);
            return this;
        }
        /**
         * contentId to use when retrieving attachments.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param contentId the value to set
         * @return the dsl builder
         */
        default JBPMEndpointBuilder contentId(Long contentId) {
            doSetProperty("contentId", contentId);
            return this;
        }
        /**
         * contentId to use when retrieving attachments.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param contentId the value to set
         * @return the dsl builder
         */
        default JBPMEndpointBuilder contentId(String contentId) {
            doSetProperty("contentId", contentId);
            return this;
        }
        /**
         * The id of the deployment.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Required: true
         * Group: common
         * 
         * @param deploymentId the value to set
         * @return the dsl builder
         */
        default JBPMEndpointBuilder deploymentId(String deploymentId) {
            doSetProperty("deploymentId", deploymentId);
            return this;
        }
        /**
         * Sets if event produced by emitter should be sent as single items or
         * complete collection.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param emitterSendItems the value to set
         * @return the dsl builder
         */
        default JBPMEndpointBuilder emitterSendItems(Boolean emitterSendItems) {
            doSetProperty("emitterSendItems", emitterSendItems);
            return this;
        }
        /**
         * Sets if event produced by emitter should be sent as single items or
         * complete collection.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param emitterSendItems the value to set
         * @return the dsl builder
         */
        default JBPMEndpointBuilder emitterSendItems(String emitterSendItems) {
            doSetProperty("emitterSendItems", emitterSendItems);
            return this;
        }
        /**
         * the data associated with this event when signalEvent operation is
         * performed.
         * 
         * The option is a: &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param event the value to set
         * @return the dsl builder
         */
        default JBPMEndpointBuilder event(Object event) {
            doSetProperty("event", event);
            return this;
        }
        /**
         * the data associated with this event when signalEvent operation is
         * performed.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param event the value to set
         * @return the dsl builder
         */
        default JBPMEndpointBuilder event(String event) {
            doSetProperty("event", event);
            return this;
        }
        /**
         * the type of event to use when signalEvent operation is performed.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param eventType the value to set
         * @return the dsl builder
         */
        default JBPMEndpointBuilder eventType(String eventType) {
            doSetProperty("eventType", eventType);
            return this;
        }
        /**
         * identifier the global identifier.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param identifier the value to set
         * @return the dsl builder
         */
        default JBPMEndpointBuilder identifier(String identifier) {
            doSetProperty("identifier", identifier);
            return this;
        }
        /**
         * the maximum number of rules that should be fired.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param maxNumber the value to set
         * @return the dsl builder
         */
        default JBPMEndpointBuilder maxNumber(Integer maxNumber) {
            doSetProperty("maxNumber", maxNumber);
            return this;
        }
        /**
         * the maximum number of rules that should be fired.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param maxNumber the value to set
         * @return the dsl builder
         */
        default JBPMEndpointBuilder maxNumber(String maxNumber) {
            doSetProperty("maxNumber", maxNumber);
            return this;
        }
        /**
         * The page to use when retrieving user tasks.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param page the value to set
         * @return the dsl builder
         */
        default JBPMEndpointBuilder page(Integer page) {
            doSetProperty("page", page);
            return this;
        }
        /**
         * The page to use when retrieving user tasks.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param page the value to set
         * @return the dsl builder
         */
        default JBPMEndpointBuilder page(String page) {
            doSetProperty("page", page);
            return this;
        }
        /**
         * The page size to use when retrieving user tasks.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param pageSize the value to set
         * @return the dsl builder
         */
        default JBPMEndpointBuilder pageSize(Integer pageSize) {
            doSetProperty("pageSize", pageSize);
            return this;
        }
        /**
         * The page size to use when retrieving user tasks.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param pageSize the value to set
         * @return the dsl builder
         */
        default JBPMEndpointBuilder pageSize(String pageSize) {
            doSetProperty("pageSize", pageSize);
            return this;
        }
        /**
         * the id of the process that should be acted upon.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param processId the value to set
         * @return the dsl builder
         */
        default JBPMEndpointBuilder processId(String processId) {
            doSetProperty("processId", processId);
            return this;
        }
        /**
         * the id of the process instance.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param processInstanceId the value to set
         * @return the dsl builder
         */
        default JBPMEndpointBuilder processInstanceId(Long processInstanceId) {
            doSetProperty("processInstanceId", processInstanceId);
            return this;
        }
        /**
         * the id of the process instance.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param processInstanceId the value to set
         * @return the dsl builder
         */
        default JBPMEndpointBuilder processInstanceId(String processInstanceId) {
            doSetProperty("processInstanceId", processInstanceId);
            return this;
        }
        /**
         * The targetUserId used when delegating a task.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param targetUserId the value to set
         * @return the dsl builder
         */
        default JBPMEndpointBuilder targetUserId(String targetUserId) {
            doSetProperty("targetUserId", targetUserId);
            return this;
        }
        /**
         * The task instance to use with task operations.
         * 
         * The option is a: &lt;code&gt;org.kie.api.task.model.Task&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param task the value to set
         * @return the dsl builder
         */
        default JBPMEndpointBuilder task(org.kie.api.task.model.Task task) {
            doSetProperty("task", task);
            return this;
        }
        /**
         * The task instance to use with task operations.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.kie.api.task.model.Task&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param task the value to set
         * @return the dsl builder
         */
        default JBPMEndpointBuilder task(String task) {
            doSetProperty("task", task);
            return this;
        }
        /**
         * the id of the task.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param taskId the value to set
         * @return the dsl builder
         */
        default JBPMEndpointBuilder taskId(Long taskId) {
            doSetProperty("taskId", taskId);
            return this;
        }
        /**
         * the id of the task.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param taskId the value to set
         * @return the dsl builder
         */
        default JBPMEndpointBuilder taskId(String taskId) {
            doSetProperty("taskId", taskId);
            return this;
        }
        /**
         * A timeout value.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default JBPMEndpointBuilder timeout(Integer timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * A timeout value.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default JBPMEndpointBuilder timeout(String timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * userId to use with task operations.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param userId the value to set
         * @return the dsl builder
         */
        default JBPMEndpointBuilder userId(String userId) {
            doSetProperty("userId", userId);
            return this;
        }
        /**
         * the value to assign to the global identifier.
         * 
         * The option is a: &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param value the value to set
         * @return the dsl builder
         */
        default JBPMEndpointBuilder value(Object value) {
            doSetProperty("value", value);
            return this;
        }
        /**
         * the value to assign to the global identifier.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param value the value to set
         * @return the dsl builder
         */
        default JBPMEndpointBuilder value(String value) {
            doSetProperty("value", value);
            return this;
        }
        /**
         * the id of the work item.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param workItemId the value to set
         * @return the dsl builder
         */
        default JBPMEndpointBuilder workItemId(Long workItemId) {
            doSetProperty("workItemId", workItemId);
            return this;
        }
        /**
         * the id of the work item.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param workItemId the value to set
         * @return the dsl builder
         */
        default JBPMEndpointBuilder workItemId(String workItemId) {
            doSetProperty("workItemId", workItemId);
            return this;
        }
        /**
         * The list of status to use when filtering tasks.
         * 
         * The option is a:
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: filter
         * 
         * @param statuses the value to set
         * @return the dsl builder
         */
        default JBPMEndpointBuilder statuses(List<java.lang.String> statuses) {
            doSetProperty("statuses", statuses);
            return this;
        }
        /**
         * The list of status to use when filtering tasks.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: filter
         * 
         * @param statuses the value to set
         * @return the dsl builder
         */
        default JBPMEndpointBuilder statuses(String statuses) {
            doSetProperty("statuses", statuses);
            return this;
        }
        /**
         * Password for authentication.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default JBPMEndpointBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Username for authentication.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param userName the value to set
         * @return the dsl builder
         */
        default JBPMEndpointBuilder userName(String userName) {
            doSetProperty("userName", userName);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the JBPM component.
     */
    public interface AdvancedJBPMEndpointBuilder
            extends
                AdvancedJBPMEndpointConsumerBuilder,
                AdvancedJBPMEndpointProducerBuilder {
        default JBPMEndpointBuilder basic() {
            return (JBPMEndpointBuilder) this;
        }
        /**
         * The potentialOwners when nominateTask operation is performed.
         * 
         * The option is a:
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param entities the value to set
         * @return the dsl builder
         */
        default AdvancedJBPMEndpointBuilder entities(
                List<java.lang.String> entities) {
            doSetProperty("entities", entities);
            return this;
        }
        /**
         * The potentialOwners when nominateTask operation is performed.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param entities the value to set
         * @return the dsl builder
         */
        default AdvancedJBPMEndpointBuilder entities(String entities) {
            doSetProperty("entities", entities);
            return this;
        }
        /**
         * To load additional classes when working with XML.
         * 
         * The option is a: &lt;code&gt;java.lang.Class[]&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param extraJaxbClasses the value to set
         * @return the dsl builder
         */
        default AdvancedJBPMEndpointBuilder extraJaxbClasses(
                Class[] extraJaxbClasses) {
            doSetProperty("extraJaxbClasses", extraJaxbClasses);
            return this;
        }
        /**
         * To load additional classes when working with XML.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Class[]&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param extraJaxbClasses the value to set
         * @return the dsl builder
         */
        default AdvancedJBPMEndpointBuilder extraJaxbClasses(
                String extraJaxbClasses) {
            doSetProperty("extraJaxbClasses", extraJaxbClasses);
            return this;
        }
        /**
         * the variables that should be set for various operations.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param parameters the value to set
         * @return the dsl builder
         */
        default AdvancedJBPMEndpointBuilder parameters(
                Map<java.lang.String, java.lang.Object> parameters) {
            doSetProperty("parameters", parameters);
            return this;
        }
        /**
         * the variables that should be set for various operations.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param parameters the value to set
         * @return the dsl builder
         */
        default AdvancedJBPMEndpointBuilder parameters(String parameters) {
            doSetProperty("parameters", parameters);
            return this;
        }
    }

    public interface JBPMBuilders {
        /**
         * JBPM (camel-jbpm)
         * Interact with jBPM workflow engine over REST.
         * 
         * Category: api,workflow
         * Since: 2.6
         * Maven coordinates: org.apache.camel:camel-jbpm
         * 
         * Syntax: <code>jbpm:connectionURL</code>
         * 
         * Path parameter: connectionURL (required)
         * The URL to the jBPM server.
         * 
         * Path parameter: eventListenerType
         * Sets the event listener type to attach to
         * 
         * @param path connectionURL
         * @return the dsl builder
         */
        default JBPMEndpointBuilder jbpm(String path) {
            return JBPMEndpointBuilderFactory.endpointBuilder("jbpm", path);
        }
        /**
         * JBPM (camel-jbpm)
         * Interact with jBPM workflow engine over REST.
         * 
         * Category: api,workflow
         * Since: 2.6
         * Maven coordinates: org.apache.camel:camel-jbpm
         * 
         * Syntax: <code>jbpm:connectionURL</code>
         * 
         * Path parameter: connectionURL (required)
         * The URL to the jBPM server.
         * 
         * Path parameter: eventListenerType
         * Sets the event listener type to attach to
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path connectionURL
         * @return the dsl builder
         */
        default JBPMEndpointBuilder jbpm(String componentName, String path) {
            return JBPMEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    static JBPMEndpointBuilder endpointBuilder(String componentName, String path) {
        class JBPMEndpointBuilderImpl extends AbstractEndpointBuilder implements JBPMEndpointBuilder, AdvancedJBPMEndpointBuilder {
            public JBPMEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new JBPMEndpointBuilderImpl(path);
    }
}