/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.Map;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Interact with ServiceNow via its REST API.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface ServiceNowEndpointBuilderFactory {


    /**
     * Builder for endpoint for the ServiceNow component.
     */
    public interface ServiceNowEndpointBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedServiceNowEndpointBuilder advanced() {
            return (AdvancedServiceNowEndpointBuilder) this;
        }
        /**
         * Set this parameter to true to return only scorecards where the
         * indicator Display field is selected. Set this parameter to all to
         * return scorecards with any Display field value. This parameter is
         * true by default.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param display the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder display(String display) {
            doSetProperty("display", display);
            return this;
        }
        /**
         * Return the display value (true), actual value (false), or both (all)
         * for reference fields (default: false).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param displayValue the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder displayValue(String displayValue) {
            doSetProperty("displayValue", displayValue);
            return this;
        }
        /**
         * True to exclude Table API links for reference fields (default:
         * false).
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param excludeReferenceLink the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder excludeReferenceLink(
                Boolean excludeReferenceLink) {
            doSetProperty("excludeReferenceLink", excludeReferenceLink);
            return this;
        }
        /**
         * True to exclude Table API links for reference fields (default:
         * false).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param excludeReferenceLink the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder excludeReferenceLink(
                String excludeReferenceLink) {
            doSetProperty("excludeReferenceLink", excludeReferenceLink);
            return this;
        }
        /**
         * Set this parameter to true to return only scorecards that are
         * favorites of the querying user.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param favorites the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder favorites(Boolean favorites) {
            doSetProperty("favorites", favorites);
            return this;
        }
        /**
         * Set this parameter to true to return only scorecards that are
         * favorites of the querying user.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param favorites the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder favorites(String favorites) {
            doSetProperty("favorites", favorites);
            return this;
        }
        /**
         * Set this parameter to true to always return all available aggregates
         * for an indicator, including when an aggregate has already been
         * applied. If a value is not specified, this parameter defaults to
         * false and returns no aggregates.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param includeAggregates the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder includeAggregates(
                Boolean includeAggregates) {
            doSetProperty("includeAggregates", includeAggregates);
            return this;
        }
        /**
         * Set this parameter to true to always return all available aggregates
         * for an indicator, including when an aggregate has already been
         * applied. If a value is not specified, this parameter defaults to
         * false and returns no aggregates.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param includeAggregates the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder includeAggregates(
                String includeAggregates) {
            doSetProperty("includeAggregates", includeAggregates);
            return this;
        }
        /**
         * Set this parameter to true to return all available aggregates for an
         * indicator when no aggregate has been applied. If a value is not
         * specified, this parameter defaults to false and returns no
         * aggregates.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param includeAvailableAggregates the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder includeAvailableAggregates(
                Boolean includeAvailableAggregates) {
            doSetProperty("includeAvailableAggregates", includeAvailableAggregates);
            return this;
        }
        /**
         * Set this parameter to true to return all available aggregates for an
         * indicator when no aggregate has been applied. If a value is not
         * specified, this parameter defaults to false and returns no
         * aggregates.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param includeAvailableAggregates the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder includeAvailableAggregates(
                String includeAvailableAggregates) {
            doSetProperty("includeAvailableAggregates", includeAvailableAggregates);
            return this;
        }
        /**
         * Set this parameter to true to return all available breakdowns for an
         * indicator. If a value is not specified, this parameter defaults to
         * false and returns no breakdowns.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param includeAvailableBreakdowns the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder includeAvailableBreakdowns(
                Boolean includeAvailableBreakdowns) {
            doSetProperty("includeAvailableBreakdowns", includeAvailableBreakdowns);
            return this;
        }
        /**
         * Set this parameter to true to return all available breakdowns for an
         * indicator. If a value is not specified, this parameter defaults to
         * false and returns no breakdowns.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param includeAvailableBreakdowns the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder includeAvailableBreakdowns(
                String includeAvailableBreakdowns) {
            doSetProperty("includeAvailableBreakdowns", includeAvailableBreakdowns);
            return this;
        }
        /**
         * Set this parameter to true to return all notes associated with the
         * score. The note element contains the note text as well as the author
         * and timestamp when the note was added.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param includeScoreNotes the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder includeScoreNotes(
                Boolean includeScoreNotes) {
            doSetProperty("includeScoreNotes", includeScoreNotes);
            return this;
        }
        /**
         * Set this parameter to true to return all notes associated with the
         * score. The note element contains the note text as well as the author
         * and timestamp when the note was added.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param includeScoreNotes the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder includeScoreNotes(
                String includeScoreNotes) {
            doSetProperty("includeScoreNotes", includeScoreNotes);
            return this;
        }
        /**
         * Set this parameter to true to return all scores for a scorecard. If a
         * value is not specified, this parameter defaults to false and returns
         * only the most recent score value.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param includeScores the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder includeScores(Boolean includeScores) {
            doSetProperty("includeScores", includeScores);
            return this;
        }
        /**
         * Set this parameter to true to return all scores for a scorecard. If a
         * value is not specified, this parameter defaults to false and returns
         * only the most recent score value.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param includeScores the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder includeScores(String includeScores) {
            doSetProperty("includeScores", includeScores);
            return this;
        }
        /**
         * True to set raw value of input fields (default: false).
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param inputDisplayValue the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder inputDisplayValue(
                Boolean inputDisplayValue) {
            doSetProperty("inputDisplayValue", inputDisplayValue);
            return this;
        }
        /**
         * True to set raw value of input fields (default: false).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param inputDisplayValue the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder inputDisplayValue(
                String inputDisplayValue) {
            doSetProperty("inputDisplayValue", inputDisplayValue);
            return this;
        }
        /**
         * Set this parameter to true to return only scorecards for key
         * indicators.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param key the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder key(Boolean key) {
            doSetProperty("key", key);
            return this;
        }
        /**
         * Set this parameter to true to return only scorecards for key
         * indicators.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param key the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder key(String key) {
            doSetProperty("key", key);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Defines both request and response models.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Class&amp;lt;java.lang.Object&amp;gt;&amp;gt;&lt;/code&gt;
         * type.
         * The option is multivalued, and you can use the models(String, Object)
         * method to add a value (call the method multiple times to set more
         * values).
         * 
         * Group: producer
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder models(String key, Object value) {
            doSetMultiValueProperty("models", "model." + key, value);
            return this;
        }
        /**
         * Defines both request and response models.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Class&amp;lt;java.lang.Object&amp;gt;&amp;gt;&lt;/code&gt;
         * type.
         * The option is multivalued, and you can use the models(String, Object)
         * method to add a value (call the method multiple times to set more
         * values).
         * 
         * Group: producer
         * 
         * @param values the values
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder models(Map values) {
            doSetMultiValueProperties("models", "model.", values);
            return this;
        }
        /**
         * Enter the maximum number of scorecards each query can return. By
         * default this value is 10, and the maximum is 100.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 10
         * Group: producer
         * 
         * @param perPage the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder perPage(Integer perPage) {
            doSetProperty("perPage", perPage);
            return this;
        }
        /**
         * Enter the maximum number of scorecards each query can return. By
         * default this value is 10, and the maximum is 100.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 10
         * Group: producer
         * 
         * @param perPage the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder perPage(String perPage) {
            doSetProperty("perPage", perPage);
            return this;
        }
        /**
         * The ServiceNow release to target, default to Helsinki See
         * https://docs.servicenow.com.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.servicenow.ServiceNowRelease&lt;/code&gt; type.
         * 
         * Default: HELSINKI
         * Group: producer
         * 
         * @param release the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder release(
                org.apache.camel.component.servicenow.ServiceNowRelease release) {
            doSetProperty("release", release);
            return this;
        }
        /**
         * The ServiceNow release to target, default to Helsinki See
         * https://docs.servicenow.com.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.servicenow.ServiceNowRelease&lt;/code&gt; type.
         * 
         * Default: HELSINKI
         * Group: producer
         * 
         * @param release the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder release(String release) {
            doSetProperty("release", release);
            return this;
        }
        /**
         * Defines the request model.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Class&amp;lt;java.lang.Object&amp;gt;&amp;gt;&lt;/code&gt;
         * type.
         * The option is multivalued, and you can use the requestModels(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: producer
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder requestModels(String key, Object value) {
            doSetMultiValueProperty("requestModels", "request-model." + key, value);
            return this;
        }
        /**
         * Defines the request model.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Class&amp;lt;java.lang.Object&amp;gt;&amp;gt;&lt;/code&gt;
         * type.
         * The option is multivalued, and you can use the requestModels(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: producer
         * 
         * @param values the values
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder requestModels(Map values) {
            doSetMultiValueProperties("requestModels", "request-model.", values);
            return this;
        }
        /**
         * The default resource, can be overridden by header
         * CamelServiceNowResource.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param resource the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder resource(String resource) {
            doSetProperty("resource", resource);
            return this;
        }
        /**
         * Defines the response model.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Class&amp;lt;java.lang.Object&amp;gt;&amp;gt;&lt;/code&gt;
         * type.
         * The option is multivalued, and you can use the responseModels(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: producer
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder responseModels(
                String key,
                Object value) {
            doSetMultiValueProperty("responseModels", "response-model." + key, value);
            return this;
        }
        /**
         * Defines the response model.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Class&amp;lt;java.lang.Object&amp;gt;&amp;gt;&lt;/code&gt;
         * type.
         * The option is multivalued, and you can use the responseModels(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: producer
         * 
         * @param values the values
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder responseModels(Map values) {
            doSetMultiValueProperties("responseModels", "response-model.", values);
            return this;
        }
        /**
         * Specify the value to use when sorting results. By default, queries
         * sort records by value.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param sortBy the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder sortBy(String sortBy) {
            doSetProperty("sortBy", sortBy);
            return this;
        }
        /**
         * Specify the sort direction, ascending or descending. By default,
         * queries sort records in descending order. Use sysparm_sortdir=asc to
         * sort in ascending order.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param sortDir the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder sortDir(String sortDir) {
            doSetProperty("sortDir", sortDir);
            return this;
        }
        /**
         * True to suppress auto generation of system fields (default: false).
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param suppressAutoSysField the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder suppressAutoSysField(
                Boolean suppressAutoSysField) {
            doSetProperty("suppressAutoSysField", suppressAutoSysField);
            return this;
        }
        /**
         * True to suppress auto generation of system fields (default: false).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param suppressAutoSysField the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder suppressAutoSysField(
                String suppressAutoSysField) {
            doSetProperty("suppressAutoSysField", suppressAutoSysField);
            return this;
        }
        /**
         * Set this value to true to remove the Link header from the response.
         * The Link header allows you to request additional pages of data when
         * the number of records matching your query exceeds the query limit.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param suppressPaginationHeader the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder suppressPaginationHeader(
                Boolean suppressPaginationHeader) {
            doSetProperty("suppressPaginationHeader", suppressPaginationHeader);
            return this;
        }
        /**
         * Set this value to true to remove the Link header from the response.
         * The Link header allows you to request additional pages of data when
         * the number of records matching your query exceeds the query limit.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param suppressPaginationHeader the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder suppressPaginationHeader(
                String suppressPaginationHeader) {
            doSetProperty("suppressPaginationHeader", suppressPaginationHeader);
            return this;
        }
        /**
         * The default table, can be overridden by header CamelServiceNowTable.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param table the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder table(String table) {
            doSetProperty("table", table);
            return this;
        }
        /**
         * Set this parameter to true to return only scorecards that have a
         * target.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param target the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder target(Boolean target) {
            doSetProperty("target", target);
            return this;
        }
        /**
         * Set this parameter to true to return only scorecards that have a
         * target.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param target the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder target(String target) {
            doSetProperty("target", target);
            return this;
        }
        /**
         * Gets only those categories whose parent is a catalog.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param topLevelOnly the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder topLevelOnly(Boolean topLevelOnly) {
            doSetProperty("topLevelOnly", topLevelOnly);
            return this;
        }
        /**
         * Gets only those categories whose parent is a catalog.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param topLevelOnly the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder topLevelOnly(String topLevelOnly) {
            doSetProperty("topLevelOnly", topLevelOnly);
            return this;
        }
        /**
         * The proxy host name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyHost the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder proxyHost(String proxyHost) {
            doSetProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * The proxy port number.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder proxyPort(Integer proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * The proxy port number.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder proxyPort(String proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * The ServiceNow REST API url.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param apiUrl the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder apiUrl(String apiUrl) {
            doSetProperty("apiUrl", apiUrl);
            return this;
        }
        /**
         * OAuth2 ClientID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param oauthClientId the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder oauthClientId(String oauthClientId) {
            doSetProperty("oauthClientId", oauthClientId);
            return this;
        }
        /**
         * OAuth2 ClientSecret.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param oauthClientSecret the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder oauthClientSecret(
                String oauthClientSecret) {
            doSetProperty("oauthClientSecret", oauthClientSecret);
            return this;
        }
        /**
         * OAuth token Url.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param oauthTokenUrl the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder oauthTokenUrl(String oauthTokenUrl) {
            doSetProperty("oauthTokenUrl", oauthTokenUrl);
            return this;
        }
        /**
         * ServiceNow account password, MUST be provided.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Required: true
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Password for proxy authentication.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param proxyPassword the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder proxyPassword(String proxyPassword) {
            doSetProperty("proxyPassword", proxyPassword);
            return this;
        }
        /**
         * Username for proxy authentication.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param proxyUserName the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder proxyUserName(String proxyUserName) {
            doSetProperty("proxyUserName", proxyUserName);
            return this;
        }
        /**
         * To configure security using SSLContextParameters. See
         * http://camel.apache.org/camel-configuration-utilities.html.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder sslContextParameters(
                org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters. See
         * http://camel.apache.org/camel-configuration-utilities.html.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * ServiceNow user account name, MUST be provided.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Required: true
         * Group: security
         * 
         * @param userName the value to set
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder userName(String userName) {
            doSetProperty("userName", userName);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the ServiceNow component.
     */
    public interface AdvancedServiceNowEndpointBuilder
            extends
                EndpointProducerBuilder {
        default ServiceNowEndpointBuilder basic() {
            return (ServiceNowEndpointBuilder) this;
        }
        /**
         * The ServiceNow REST API version, default latest.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param apiVersion the value to set
         * @return the dsl builder
         */
        default AdvancedServiceNowEndpointBuilder apiVersion(String apiVersion) {
            doSetProperty("apiVersion", apiVersion);
            return this;
        }
        /**
         * The date format used for Json serialization/deserialization.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: yyyy-MM-dd
         * Group: advanced
         * 
         * @param dateFormat the value to set
         * @return the dsl builder
         */
        default AdvancedServiceNowEndpointBuilder dateFormat(String dateFormat) {
            doSetProperty("dateFormat", dateFormat);
            return this;
        }
        /**
         * The date-time format used for Json serialization/deserialization.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: yyyy-MM-dd HH:mm:ss
         * Group: advanced
         * 
         * @param dateTimeFormat the value to set
         * @return the dsl builder
         */
        default AdvancedServiceNowEndpointBuilder dateTimeFormat(
                String dateTimeFormat) {
            doSetProperty("dateTimeFormat", dateTimeFormat);
            return this;
        }
        /**
         * To configure http-client.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.cxf.transports.http.configuration.HTTPClientPolicy&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param httpClientPolicy the value to set
         * @return the dsl builder
         */
        default AdvancedServiceNowEndpointBuilder httpClientPolicy(
                org.apache.cxf.transports.http.configuration.HTTPClientPolicy httpClientPolicy) {
            doSetProperty("httpClientPolicy", httpClientPolicy);
            return this;
        }
        /**
         * To configure http-client.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.cxf.transports.http.configuration.HTTPClientPolicy&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param httpClientPolicy the value to set
         * @return the dsl builder
         */
        default AdvancedServiceNowEndpointBuilder httpClientPolicy(
                String httpClientPolicy) {
            doSetProperty("httpClientPolicy", httpClientPolicy);
            return this;
        }
        /**
         * Sets Jackson's ObjectMapper to use for request/reply.
         * 
         * The option is a:
         * &lt;code&gt;com.fasterxml.jackson.databind.ObjectMapper&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param mapper the value to set
         * @return the dsl builder
         */
        default AdvancedServiceNowEndpointBuilder mapper(
                com.fasterxml.jackson.databind.ObjectMapper mapper) {
            doSetProperty("mapper", mapper);
            return this;
        }
        /**
         * Sets Jackson's ObjectMapper to use for request/reply.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.fasterxml.jackson.databind.ObjectMapper&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param mapper the value to set
         * @return the dsl builder
         */
        default AdvancedServiceNowEndpointBuilder mapper(String mapper) {
            doSetProperty("mapper", mapper);
            return this;
        }
        /**
         * To configure proxy authentication.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.cxf.configuration.security.ProxyAuthorizationPolicy&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param proxyAuthorizationPolicy the value to set
         * @return the dsl builder
         */
        default AdvancedServiceNowEndpointBuilder proxyAuthorizationPolicy(
                org.apache.cxf.configuration.security.ProxyAuthorizationPolicy proxyAuthorizationPolicy) {
            doSetProperty("proxyAuthorizationPolicy", proxyAuthorizationPolicy);
            return this;
        }
        /**
         * To configure proxy authentication.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.cxf.configuration.security.ProxyAuthorizationPolicy&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param proxyAuthorizationPolicy the value to set
         * @return the dsl builder
         */
        default AdvancedServiceNowEndpointBuilder proxyAuthorizationPolicy(
                String proxyAuthorizationPolicy) {
            doSetProperty("proxyAuthorizationPolicy", proxyAuthorizationPolicy);
            return this;
        }
        /**
         * Set this parameter to true to retrieve the target record when using
         * import set api. The import set result is then replaced by the target
         * record.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param retrieveTargetRecordOnImport the value to set
         * @return the dsl builder
         */
        default AdvancedServiceNowEndpointBuilder retrieveTargetRecordOnImport(
                Boolean retrieveTargetRecordOnImport) {
            doSetProperty("retrieveTargetRecordOnImport", retrieveTargetRecordOnImport);
            return this;
        }
        /**
         * Set this parameter to true to retrieve the target record when using
         * import set api. The import set result is then replaced by the target
         * record.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param retrieveTargetRecordOnImport the value to set
         * @return the dsl builder
         */
        default AdvancedServiceNowEndpointBuilder retrieveTargetRecordOnImport(
                String retrieveTargetRecordOnImport) {
            doSetProperty("retrieveTargetRecordOnImport", retrieveTargetRecordOnImport);
            return this;
        }
        /**
         * The time format used for Json serialization/deserialization.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: HH:mm:ss
         * Group: advanced
         * 
         * @param timeFormat the value to set
         * @return the dsl builder
         */
        default AdvancedServiceNowEndpointBuilder timeFormat(String timeFormat) {
            doSetProperty("timeFormat", timeFormat);
            return this;
        }
    }

    public interface ServiceNowBuilders {
        /**
         * ServiceNow (camel-servicenow)
         * Interact with ServiceNow via its REST API.
         * 
         * Category: api,cloud,management
         * Since: 2.18
         * Maven coordinates: org.apache.camel:camel-servicenow
         * 
         * Syntax: <code>servicenow:instanceName</code>
         * 
         * Path parameter: instanceName (required)
         * The ServiceNow instance name
         * 
         * @param path instanceName
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder servicenow(String path) {
            return ServiceNowEndpointBuilderFactory.endpointBuilder("servicenow", path);
        }
        /**
         * ServiceNow (camel-servicenow)
         * Interact with ServiceNow via its REST API.
         * 
         * Category: api,cloud,management
         * Since: 2.18
         * Maven coordinates: org.apache.camel:camel-servicenow
         * 
         * Syntax: <code>servicenow:instanceName</code>
         * 
         * Path parameter: instanceName (required)
         * The ServiceNow instance name
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path instanceName
         * @return the dsl builder
         */
        default ServiceNowEndpointBuilder servicenow(
                String componentName,
                String path) {
            return ServiceNowEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    static ServiceNowEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class ServiceNowEndpointBuilderImpl extends AbstractEndpointBuilder implements ServiceNowEndpointBuilder, AdvancedServiceNowEndpointBuilder {
            public ServiceNowEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new ServiceNowEndpointBuilderImpl(path);
    }
}