/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.Map;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Query and/or transform XML payloads using XQuery and Saxon.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface XQueryEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the XQuery component.
     */
    public interface XQueryEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedXQueryEndpointConsumerBuilder advanced() {
            return (AdvancedXQueryEndpointConsumerBuilder) this;
        }
        /**
         * Whether to allow using StAX mode.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param allowStAX the value to set
         * @return the dsl builder
         */
        default XQueryEndpointConsumerBuilder allowStAX(boolean allowStAX) {
            doSetProperty("allowStAX", allowStAX);
            return this;
        }
        /**
         * Whether to allow using StAX mode.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param allowStAX the value to set
         * @return the dsl builder
         */
        default XQueryEndpointConsumerBuilder allowStAX(String allowStAX) {
            doSetProperty("allowStAX", allowStAX);
            return this;
        }
        /**
         * To use a Camel Message header as the input source instead of Message
         * body.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param headerName the value to set
         * @return the dsl builder
         */
        default XQueryEndpointConsumerBuilder headerName(String headerName) {
            doSetProperty("headerName", headerName);
            return this;
        }
        /**
         * Allows to control which namespace prefixes to use for a set of
         * namespace mappings.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param namespacePrefixes the value to set
         * @return the dsl builder
         */
        default XQueryEndpointConsumerBuilder namespacePrefixes(
                Map<java.lang.String, java.lang.String> namespacePrefixes) {
            doSetProperty("namespacePrefixes", namespacePrefixes);
            return this;
        }
        /**
         * Allows to control which namespace prefixes to use for a set of
         * namespace mappings.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param namespacePrefixes the value to set
         * @return the dsl builder
         */
        default XQueryEndpointConsumerBuilder namespacePrefixes(
                String namespacePrefixes) {
            doSetProperty("namespacePrefixes", namespacePrefixes);
            return this;
        }
        /**
         * What output result to use.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.xquery.ResultFormat&lt;/code&gt; type.
         * 
         * Default: DOM
         * Group: common
         * 
         * @param resultsFormat the value to set
         * @return the dsl builder
         */
        default XQueryEndpointConsumerBuilder resultsFormat(
                org.apache.camel.component.xquery.ResultFormat resultsFormat) {
            doSetProperty("resultsFormat", resultsFormat);
            return this;
        }
        /**
         * What output result to use.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.xquery.ResultFormat&lt;/code&gt; type.
         * 
         * Default: DOM
         * Group: common
         * 
         * @param resultsFormat the value to set
         * @return the dsl builder
         */
        default XQueryEndpointConsumerBuilder resultsFormat(String resultsFormat) {
            doSetProperty("resultsFormat", resultsFormat);
            return this;
        }
        /**
         * What output result to use defined as a class.
         * 
         * The option is a:
         * &lt;code&gt;java.lang.Class&amp;lt;java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param resultType the value to set
         * @return the dsl builder
         */
        default XQueryEndpointConsumerBuilder resultType(
                Class<java.lang.Object> resultType) {
            doSetProperty("resultType", resultType);
            return this;
        }
        /**
         * What output result to use defined as a class.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Class&amp;lt;java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param resultType the value to set
         * @return the dsl builder
         */
        default XQueryEndpointConsumerBuilder resultType(String resultType) {
            doSetProperty("resultType", resultType);
            return this;
        }
        /**
         * Whether to strip all whitespaces.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param stripsAllWhiteSpace the value to set
         * @return the dsl builder
         */
        default XQueryEndpointConsumerBuilder stripsAllWhiteSpace(
                boolean stripsAllWhiteSpace) {
            doSetProperty("stripsAllWhiteSpace", stripsAllWhiteSpace);
            return this;
        }
        /**
         * Whether to strip all whitespaces.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param stripsAllWhiteSpace the value to set
         * @return the dsl builder
         */
        default XQueryEndpointConsumerBuilder stripsAllWhiteSpace(
                String stripsAllWhiteSpace) {
            doSetProperty("stripsAllWhiteSpace", stripsAllWhiteSpace);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default XQueryEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default XQueryEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default XQueryEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                boolean sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default XQueryEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                String sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default XQueryEndpointConsumerBuilder backoffErrorThreshold(
                int backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default XQueryEndpointConsumerBuilder backoffErrorThreshold(
                String backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default XQueryEndpointConsumerBuilder backoffIdleThreshold(
                int backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default XQueryEndpointConsumerBuilder backoffIdleThreshold(
                String backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default XQueryEndpointConsumerBuilder backoffMultiplier(
                int backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default XQueryEndpointConsumerBuilder backoffMultiplier(
                String backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: scheduler
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default XQueryEndpointConsumerBuilder delay(long delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: scheduler
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default XQueryEndpointConsumerBuilder delay(String delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default XQueryEndpointConsumerBuilder greedy(boolean greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default XQueryEndpointConsumerBuilder greedy(String greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default XQueryEndpointConsumerBuilder initialDelay(long initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default XQueryEndpointConsumerBuilder initialDelay(String initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default XQueryEndpointConsumerBuilder repeatCount(long repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default XQueryEndpointConsumerBuilder repeatCount(String repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default XQueryEndpointConsumerBuilder runLoggingLevel(
                org.apache.camel.LoggingLevel runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default XQueryEndpointConsumerBuilder runLoggingLevel(
                String runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option is a:
         * &lt;code&gt;java.util.concurrent.ScheduledExecutorService&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default XQueryEndpointConsumerBuilder scheduledExecutorService(
                ScheduledExecutorService scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.concurrent.ScheduledExecutorService&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default XQueryEndpointConsumerBuilder scheduledExecutorService(
                String scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option is a: &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default XQueryEndpointConsumerBuilder scheduler(Object scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default XQueryEndpointConsumerBuilder scheduler(String scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default XQueryEndpointConsumerBuilder schedulerProperties(
                String key,
                Object value) {
            doSetMultiValueProperty("schedulerProperties", "scheduler." + key, value);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param values the values
         * @return the dsl builder
         */
        default XQueryEndpointConsumerBuilder schedulerProperties(Map values) {
            doSetMultiValueProperties("schedulerProperties", "scheduler.", values);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default XQueryEndpointConsumerBuilder startScheduler(
                boolean startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default XQueryEndpointConsumerBuilder startScheduler(
                String startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option is a:
         * &lt;code&gt;java.util.concurrent.TimeUnit&lt;/code&gt; type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default XQueryEndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.concurrent.TimeUnit&lt;/code&gt; type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default XQueryEndpointConsumerBuilder timeUnit(String timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default XQueryEndpointConsumerBuilder useFixedDelay(
                boolean useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default XQueryEndpointConsumerBuilder useFixedDelay(String useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the XQuery component.
     */
    public interface AdvancedXQueryEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default XQueryEndpointConsumerBuilder basic() {
            return (XQueryEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedXQueryEndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedXQueryEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedXQueryEndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedXQueryEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.PollingConsumerPollStrategy&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedXQueryEndpointConsumerBuilder pollStrategy(
                org.apache.camel.spi.PollingConsumerPollStrategy pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.PollingConsumerPollStrategy&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedXQueryEndpointConsumerBuilder pollStrategy(
                String pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * To use a custom Saxon configuration.
         * 
         * The option is a: &lt;code&gt;net.sf.saxon.Configuration&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default AdvancedXQueryEndpointConsumerBuilder configuration(
                net.sf.saxon.Configuration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
        /**
         * To use a custom Saxon configuration.
         * 
         * The option will be converted to a
         * &lt;code&gt;net.sf.saxon.Configuration&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default AdvancedXQueryEndpointConsumerBuilder configuration(
                String configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
        /**
         * To set custom Saxon configuration properties.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param configurationProperties the value to set
         * @return the dsl builder
         */
        default AdvancedXQueryEndpointConsumerBuilder configurationProperties(
                Map<java.lang.String, java.lang.Object> configurationProperties) {
            doSetProperty("configurationProperties", configurationProperties);
            return this;
        }
        /**
         * To set custom Saxon configuration properties.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param configurationProperties the value to set
         * @return the dsl builder
         */
        default AdvancedXQueryEndpointConsumerBuilder configurationProperties(
                String configurationProperties) {
            doSetProperty("configurationProperties", configurationProperties);
            return this;
        }
        /**
         * To use the custom ModuleURIResolver.
         * 
         * The option is a:
         * &lt;code&gt;net.sf.saxon.lib.ModuleURIResolver&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param moduleURIResolver the value to set
         * @return the dsl builder
         */
        default AdvancedXQueryEndpointConsumerBuilder moduleURIResolver(
                net.sf.saxon.lib.ModuleURIResolver moduleURIResolver) {
            doSetProperty("moduleURIResolver", moduleURIResolver);
            return this;
        }
        /**
         * To use the custom ModuleURIResolver.
         * 
         * The option will be converted to a
         * &lt;code&gt;net.sf.saxon.lib.ModuleURIResolver&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param moduleURIResolver the value to set
         * @return the dsl builder
         */
        default AdvancedXQueryEndpointConsumerBuilder moduleURIResolver(
                String moduleURIResolver) {
            doSetProperty("moduleURIResolver", moduleURIResolver);
            return this;
        }
        /**
         * Additional parameters.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param parameters the value to set
         * @return the dsl builder
         */
        default AdvancedXQueryEndpointConsumerBuilder parameters(
                Map<java.lang.String, java.lang.Object> parameters) {
            doSetProperty("parameters", parameters);
            return this;
        }
        /**
         * Additional parameters.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param parameters the value to set
         * @return the dsl builder
         */
        default AdvancedXQueryEndpointConsumerBuilder parameters(
                String parameters) {
            doSetProperty("parameters", parameters);
            return this;
        }
        /**
         * Properties to configure the serialization parameters.
         * 
         * The option is a: &lt;code&gt;java.util.Properties&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param properties the value to set
         * @return the dsl builder
         */
        default AdvancedXQueryEndpointConsumerBuilder properties(
                Properties properties) {
            doSetProperty("properties", properties);
            return this;
        }
        /**
         * Properties to configure the serialization parameters.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Properties&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param properties the value to set
         * @return the dsl builder
         */
        default AdvancedXQueryEndpointConsumerBuilder properties(
                String properties) {
            doSetProperty("properties", properties);
            return this;
        }
        /**
         * To use a custom Saxon StaticQueryContext.
         * 
         * The option is a:
         * &lt;code&gt;net.sf.saxon.query.StaticQueryContext&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param staticQueryContext the value to set
         * @return the dsl builder
         */
        default AdvancedXQueryEndpointConsumerBuilder staticQueryContext(
                net.sf.saxon.query.StaticQueryContext staticQueryContext) {
            doSetProperty("staticQueryContext", staticQueryContext);
            return this;
        }
        /**
         * To use a custom Saxon StaticQueryContext.
         * 
         * The option will be converted to a
         * &lt;code&gt;net.sf.saxon.query.StaticQueryContext&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param staticQueryContext the value to set
         * @return the dsl builder
         */
        default AdvancedXQueryEndpointConsumerBuilder staticQueryContext(
                String staticQueryContext) {
            doSetProperty("staticQueryContext", staticQueryContext);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the XQuery component.
     */
    public interface XQueryEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedXQueryEndpointProducerBuilder advanced() {
            return (AdvancedXQueryEndpointProducerBuilder) this;
        }
        /**
         * Whether to allow using StAX mode.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param allowStAX the value to set
         * @return the dsl builder
         */
        default XQueryEndpointProducerBuilder allowStAX(boolean allowStAX) {
            doSetProperty("allowStAX", allowStAX);
            return this;
        }
        /**
         * Whether to allow using StAX mode.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param allowStAX the value to set
         * @return the dsl builder
         */
        default XQueryEndpointProducerBuilder allowStAX(String allowStAX) {
            doSetProperty("allowStAX", allowStAX);
            return this;
        }
        /**
         * To use a Camel Message header as the input source instead of Message
         * body.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param headerName the value to set
         * @return the dsl builder
         */
        default XQueryEndpointProducerBuilder headerName(String headerName) {
            doSetProperty("headerName", headerName);
            return this;
        }
        /**
         * Allows to control which namespace prefixes to use for a set of
         * namespace mappings.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param namespacePrefixes the value to set
         * @return the dsl builder
         */
        default XQueryEndpointProducerBuilder namespacePrefixes(
                Map<java.lang.String, java.lang.String> namespacePrefixes) {
            doSetProperty("namespacePrefixes", namespacePrefixes);
            return this;
        }
        /**
         * Allows to control which namespace prefixes to use for a set of
         * namespace mappings.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param namespacePrefixes the value to set
         * @return the dsl builder
         */
        default XQueryEndpointProducerBuilder namespacePrefixes(
                String namespacePrefixes) {
            doSetProperty("namespacePrefixes", namespacePrefixes);
            return this;
        }
        /**
         * What output result to use.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.xquery.ResultFormat&lt;/code&gt; type.
         * 
         * Default: DOM
         * Group: common
         * 
         * @param resultsFormat the value to set
         * @return the dsl builder
         */
        default XQueryEndpointProducerBuilder resultsFormat(
                org.apache.camel.component.xquery.ResultFormat resultsFormat) {
            doSetProperty("resultsFormat", resultsFormat);
            return this;
        }
        /**
         * What output result to use.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.xquery.ResultFormat&lt;/code&gt; type.
         * 
         * Default: DOM
         * Group: common
         * 
         * @param resultsFormat the value to set
         * @return the dsl builder
         */
        default XQueryEndpointProducerBuilder resultsFormat(String resultsFormat) {
            doSetProperty("resultsFormat", resultsFormat);
            return this;
        }
        /**
         * What output result to use defined as a class.
         * 
         * The option is a:
         * &lt;code&gt;java.lang.Class&amp;lt;java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param resultType the value to set
         * @return the dsl builder
         */
        default XQueryEndpointProducerBuilder resultType(
                Class<java.lang.Object> resultType) {
            doSetProperty("resultType", resultType);
            return this;
        }
        /**
         * What output result to use defined as a class.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Class&amp;lt;java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param resultType the value to set
         * @return the dsl builder
         */
        default XQueryEndpointProducerBuilder resultType(String resultType) {
            doSetProperty("resultType", resultType);
            return this;
        }
        /**
         * Whether to strip all whitespaces.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param stripsAllWhiteSpace the value to set
         * @return the dsl builder
         */
        default XQueryEndpointProducerBuilder stripsAllWhiteSpace(
                boolean stripsAllWhiteSpace) {
            doSetProperty("stripsAllWhiteSpace", stripsAllWhiteSpace);
            return this;
        }
        /**
         * Whether to strip all whitespaces.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param stripsAllWhiteSpace the value to set
         * @return the dsl builder
         */
        default XQueryEndpointProducerBuilder stripsAllWhiteSpace(
                String stripsAllWhiteSpace) {
            doSetProperty("stripsAllWhiteSpace", stripsAllWhiteSpace);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default XQueryEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default XQueryEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the XQuery component.
     */
    public interface AdvancedXQueryEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default XQueryEndpointProducerBuilder basic() {
            return (XQueryEndpointProducerBuilder) this;
        }
        /**
         * To use a custom Saxon configuration.
         * 
         * The option is a: &lt;code&gt;net.sf.saxon.Configuration&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default AdvancedXQueryEndpointProducerBuilder configuration(
                net.sf.saxon.Configuration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
        /**
         * To use a custom Saxon configuration.
         * 
         * The option will be converted to a
         * &lt;code&gt;net.sf.saxon.Configuration&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default AdvancedXQueryEndpointProducerBuilder configuration(
                String configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
        /**
         * To set custom Saxon configuration properties.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param configurationProperties the value to set
         * @return the dsl builder
         */
        default AdvancedXQueryEndpointProducerBuilder configurationProperties(
                Map<java.lang.String, java.lang.Object> configurationProperties) {
            doSetProperty("configurationProperties", configurationProperties);
            return this;
        }
        /**
         * To set custom Saxon configuration properties.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param configurationProperties the value to set
         * @return the dsl builder
         */
        default AdvancedXQueryEndpointProducerBuilder configurationProperties(
                String configurationProperties) {
            doSetProperty("configurationProperties", configurationProperties);
            return this;
        }
        /**
         * To use the custom ModuleURIResolver.
         * 
         * The option is a:
         * &lt;code&gt;net.sf.saxon.lib.ModuleURIResolver&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param moduleURIResolver the value to set
         * @return the dsl builder
         */
        default AdvancedXQueryEndpointProducerBuilder moduleURIResolver(
                net.sf.saxon.lib.ModuleURIResolver moduleURIResolver) {
            doSetProperty("moduleURIResolver", moduleURIResolver);
            return this;
        }
        /**
         * To use the custom ModuleURIResolver.
         * 
         * The option will be converted to a
         * &lt;code&gt;net.sf.saxon.lib.ModuleURIResolver&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param moduleURIResolver the value to set
         * @return the dsl builder
         */
        default AdvancedXQueryEndpointProducerBuilder moduleURIResolver(
                String moduleURIResolver) {
            doSetProperty("moduleURIResolver", moduleURIResolver);
            return this;
        }
        /**
         * Additional parameters.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param parameters the value to set
         * @return the dsl builder
         */
        default AdvancedXQueryEndpointProducerBuilder parameters(
                Map<java.lang.String, java.lang.Object> parameters) {
            doSetProperty("parameters", parameters);
            return this;
        }
        /**
         * Additional parameters.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param parameters the value to set
         * @return the dsl builder
         */
        default AdvancedXQueryEndpointProducerBuilder parameters(
                String parameters) {
            doSetProperty("parameters", parameters);
            return this;
        }
        /**
         * Properties to configure the serialization parameters.
         * 
         * The option is a: &lt;code&gt;java.util.Properties&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param properties the value to set
         * @return the dsl builder
         */
        default AdvancedXQueryEndpointProducerBuilder properties(
                Properties properties) {
            doSetProperty("properties", properties);
            return this;
        }
        /**
         * Properties to configure the serialization parameters.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Properties&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param properties the value to set
         * @return the dsl builder
         */
        default AdvancedXQueryEndpointProducerBuilder properties(
                String properties) {
            doSetProperty("properties", properties);
            return this;
        }
        /**
         * To use a custom Saxon StaticQueryContext.
         * 
         * The option is a:
         * &lt;code&gt;net.sf.saxon.query.StaticQueryContext&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param staticQueryContext the value to set
         * @return the dsl builder
         */
        default AdvancedXQueryEndpointProducerBuilder staticQueryContext(
                net.sf.saxon.query.StaticQueryContext staticQueryContext) {
            doSetProperty("staticQueryContext", staticQueryContext);
            return this;
        }
        /**
         * To use a custom Saxon StaticQueryContext.
         * 
         * The option will be converted to a
         * &lt;code&gt;net.sf.saxon.query.StaticQueryContext&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param staticQueryContext the value to set
         * @return the dsl builder
         */
        default AdvancedXQueryEndpointProducerBuilder staticQueryContext(
                String staticQueryContext) {
            doSetProperty("staticQueryContext", staticQueryContext);
            return this;
        }
    }

    /**
     * Builder for endpoint for the XQuery component.
     */
    public interface XQueryEndpointBuilder
            extends
                XQueryEndpointConsumerBuilder,
                XQueryEndpointProducerBuilder {
        default AdvancedXQueryEndpointBuilder advanced() {
            return (AdvancedXQueryEndpointBuilder) this;
        }
        /**
         * Whether to allow using StAX mode.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param allowStAX the value to set
         * @return the dsl builder
         */
        default XQueryEndpointBuilder allowStAX(boolean allowStAX) {
            doSetProperty("allowStAX", allowStAX);
            return this;
        }
        /**
         * Whether to allow using StAX mode.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param allowStAX the value to set
         * @return the dsl builder
         */
        default XQueryEndpointBuilder allowStAX(String allowStAX) {
            doSetProperty("allowStAX", allowStAX);
            return this;
        }
        /**
         * To use a Camel Message header as the input source instead of Message
         * body.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param headerName the value to set
         * @return the dsl builder
         */
        default XQueryEndpointBuilder headerName(String headerName) {
            doSetProperty("headerName", headerName);
            return this;
        }
        /**
         * Allows to control which namespace prefixes to use for a set of
         * namespace mappings.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param namespacePrefixes the value to set
         * @return the dsl builder
         */
        default XQueryEndpointBuilder namespacePrefixes(
                Map<java.lang.String, java.lang.String> namespacePrefixes) {
            doSetProperty("namespacePrefixes", namespacePrefixes);
            return this;
        }
        /**
         * Allows to control which namespace prefixes to use for a set of
         * namespace mappings.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param namespacePrefixes the value to set
         * @return the dsl builder
         */
        default XQueryEndpointBuilder namespacePrefixes(String namespacePrefixes) {
            doSetProperty("namespacePrefixes", namespacePrefixes);
            return this;
        }
        /**
         * What output result to use.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.xquery.ResultFormat&lt;/code&gt; type.
         * 
         * Default: DOM
         * Group: common
         * 
         * @param resultsFormat the value to set
         * @return the dsl builder
         */
        default XQueryEndpointBuilder resultsFormat(
                org.apache.camel.component.xquery.ResultFormat resultsFormat) {
            doSetProperty("resultsFormat", resultsFormat);
            return this;
        }
        /**
         * What output result to use.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.xquery.ResultFormat&lt;/code&gt; type.
         * 
         * Default: DOM
         * Group: common
         * 
         * @param resultsFormat the value to set
         * @return the dsl builder
         */
        default XQueryEndpointBuilder resultsFormat(String resultsFormat) {
            doSetProperty("resultsFormat", resultsFormat);
            return this;
        }
        /**
         * What output result to use defined as a class.
         * 
         * The option is a:
         * &lt;code&gt;java.lang.Class&amp;lt;java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param resultType the value to set
         * @return the dsl builder
         */
        default XQueryEndpointBuilder resultType(
                Class<java.lang.Object> resultType) {
            doSetProperty("resultType", resultType);
            return this;
        }
        /**
         * What output result to use defined as a class.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Class&amp;lt;java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param resultType the value to set
         * @return the dsl builder
         */
        default XQueryEndpointBuilder resultType(String resultType) {
            doSetProperty("resultType", resultType);
            return this;
        }
        /**
         * Whether to strip all whitespaces.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param stripsAllWhiteSpace the value to set
         * @return the dsl builder
         */
        default XQueryEndpointBuilder stripsAllWhiteSpace(
                boolean stripsAllWhiteSpace) {
            doSetProperty("stripsAllWhiteSpace", stripsAllWhiteSpace);
            return this;
        }
        /**
         * Whether to strip all whitespaces.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param stripsAllWhiteSpace the value to set
         * @return the dsl builder
         */
        default XQueryEndpointBuilder stripsAllWhiteSpace(
                String stripsAllWhiteSpace) {
            doSetProperty("stripsAllWhiteSpace", stripsAllWhiteSpace);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the XQuery component.
     */
    public interface AdvancedXQueryEndpointBuilder
            extends
                AdvancedXQueryEndpointConsumerBuilder,
                AdvancedXQueryEndpointProducerBuilder {
        default XQueryEndpointBuilder basic() {
            return (XQueryEndpointBuilder) this;
        }
        /**
         * To use a custom Saxon configuration.
         * 
         * The option is a: &lt;code&gt;net.sf.saxon.Configuration&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default AdvancedXQueryEndpointBuilder configuration(
                net.sf.saxon.Configuration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
        /**
         * To use a custom Saxon configuration.
         * 
         * The option will be converted to a
         * &lt;code&gt;net.sf.saxon.Configuration&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default AdvancedXQueryEndpointBuilder configuration(String configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
        /**
         * To set custom Saxon configuration properties.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param configurationProperties the value to set
         * @return the dsl builder
         */
        default AdvancedXQueryEndpointBuilder configurationProperties(
                Map<java.lang.String, java.lang.Object> configurationProperties) {
            doSetProperty("configurationProperties", configurationProperties);
            return this;
        }
        /**
         * To set custom Saxon configuration properties.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param configurationProperties the value to set
         * @return the dsl builder
         */
        default AdvancedXQueryEndpointBuilder configurationProperties(
                String configurationProperties) {
            doSetProperty("configurationProperties", configurationProperties);
            return this;
        }
        /**
         * To use the custom ModuleURIResolver.
         * 
         * The option is a:
         * &lt;code&gt;net.sf.saxon.lib.ModuleURIResolver&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param moduleURIResolver the value to set
         * @return the dsl builder
         */
        default AdvancedXQueryEndpointBuilder moduleURIResolver(
                net.sf.saxon.lib.ModuleURIResolver moduleURIResolver) {
            doSetProperty("moduleURIResolver", moduleURIResolver);
            return this;
        }
        /**
         * To use the custom ModuleURIResolver.
         * 
         * The option will be converted to a
         * &lt;code&gt;net.sf.saxon.lib.ModuleURIResolver&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param moduleURIResolver the value to set
         * @return the dsl builder
         */
        default AdvancedXQueryEndpointBuilder moduleURIResolver(
                String moduleURIResolver) {
            doSetProperty("moduleURIResolver", moduleURIResolver);
            return this;
        }
        /**
         * Additional parameters.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param parameters the value to set
         * @return the dsl builder
         */
        default AdvancedXQueryEndpointBuilder parameters(
                Map<java.lang.String, java.lang.Object> parameters) {
            doSetProperty("parameters", parameters);
            return this;
        }
        /**
         * Additional parameters.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param parameters the value to set
         * @return the dsl builder
         */
        default AdvancedXQueryEndpointBuilder parameters(String parameters) {
            doSetProperty("parameters", parameters);
            return this;
        }
        /**
         * Properties to configure the serialization parameters.
         * 
         * The option is a: &lt;code&gt;java.util.Properties&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param properties the value to set
         * @return the dsl builder
         */
        default AdvancedXQueryEndpointBuilder properties(Properties properties) {
            doSetProperty("properties", properties);
            return this;
        }
        /**
         * Properties to configure the serialization parameters.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Properties&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param properties the value to set
         * @return the dsl builder
         */
        default AdvancedXQueryEndpointBuilder properties(String properties) {
            doSetProperty("properties", properties);
            return this;
        }
        /**
         * To use a custom Saxon StaticQueryContext.
         * 
         * The option is a:
         * &lt;code&gt;net.sf.saxon.query.StaticQueryContext&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param staticQueryContext the value to set
         * @return the dsl builder
         */
        default AdvancedXQueryEndpointBuilder staticQueryContext(
                net.sf.saxon.query.StaticQueryContext staticQueryContext) {
            doSetProperty("staticQueryContext", staticQueryContext);
            return this;
        }
        /**
         * To use a custom Saxon StaticQueryContext.
         * 
         * The option will be converted to a
         * &lt;code&gt;net.sf.saxon.query.StaticQueryContext&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param staticQueryContext the value to set
         * @return the dsl builder
         */
        default AdvancedXQueryEndpointBuilder staticQueryContext(
                String staticQueryContext) {
            doSetProperty("staticQueryContext", staticQueryContext);
            return this;
        }
    }

    public interface XQueryBuilders {
        /**
         * XQuery (camel-saxon)
         * Query and/or transform XML payloads using XQuery and Saxon.
         * 
         * Category: transformation
         * Since: 1.0
         * Maven coordinates: org.apache.camel:camel-saxon
         * 
         * Syntax: <code>xquery:resourceUri</code>
         * 
         * Path parameter: resourceUri (required)
         * The name of the template to load from classpath or file system
         * 
         * @param path resourceUri
         * @return the dsl builder
         */
        default XQueryEndpointBuilder xquery(String path) {
            return XQueryEndpointBuilderFactory.endpointBuilder("xquery", path);
        }
        /**
         * XQuery (camel-saxon)
         * Query and/or transform XML payloads using XQuery and Saxon.
         * 
         * Category: transformation
         * Since: 1.0
         * Maven coordinates: org.apache.camel:camel-saxon
         * 
         * Syntax: <code>xquery:resourceUri</code>
         * 
         * Path parameter: resourceUri (required)
         * The name of the template to load from classpath or file system
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path resourceUri
         * @return the dsl builder
         */
        default XQueryEndpointBuilder xquery(String componentName, String path) {
            return XQueryEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    static XQueryEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class XQueryEndpointBuilderImpl extends AbstractEndpointBuilder implements XQueryEndpointBuilder, AdvancedXQueryEndpointBuilder {
            public XQueryEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new XQueryEndpointBuilderImpl(path);
    }
}