/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Manage Docker containers.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface DockerEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Docker component.
     */
    public interface DockerEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedDockerEndpointConsumerBuilder advanced() {
            return (AdvancedDockerEndpointConsumerBuilder) this;
        }
        /**
         * Email address associated with the user.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param email the value to set
         * @return the dsl builder
         */
        default DockerEndpointConsumerBuilder email(String email) {
            doSetProperty("email", email);
            return this;
        }
        /**
         * Docker host.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Required: true
         * Default: localhost
         * Group: common
         * 
         * @param host the value to set
         * @return the dsl builder
         */
        default DockerEndpointConsumerBuilder host(String host) {
            doSetProperty("host", host);
            return this;
        }
        /**
         * Docker port.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 2375
         * Group: common
         * 
         * @param port the value to set
         * @return the dsl builder
         */
        default DockerEndpointConsumerBuilder port(Integer port) {
            doSetProperty("port", port);
            return this;
        }
        /**
         * Docker port.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 2375
         * Group: common
         * 
         * @param port the value to set
         * @return the dsl builder
         */
        default DockerEndpointConsumerBuilder port(String port) {
            doSetProperty("port", port);
            return this;
        }
        /**
         * Request timeout for response (in seconds).
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param requestTimeout the value to set
         * @return the dsl builder
         */
        default DockerEndpointConsumerBuilder requestTimeout(
                Integer requestTimeout) {
            doSetProperty("requestTimeout", requestTimeout);
            return this;
        }
        /**
         * Request timeout for response (in seconds).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param requestTimeout the value to set
         * @return the dsl builder
         */
        default DockerEndpointConsumerBuilder requestTimeout(
                String requestTimeout) {
            doSetProperty("requestTimeout", requestTimeout);
            return this;
        }
        /**
         * Location containing the SSL certificate chain.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param certPath the value to set
         * @return the dsl builder
         */
        default DockerEndpointConsumerBuilder certPath(String certPath) {
            doSetProperty("certPath", certPath);
            return this;
        }
        /**
         * Password to authenticate with.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default DockerEndpointConsumerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Use HTTPS communication.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param secure the value to set
         * @return the dsl builder
         */
        default DockerEndpointConsumerBuilder secure(boolean secure) {
            doSetProperty("secure", secure);
            return this;
        }
        /**
         * Use HTTPS communication.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: security
         * 
         * @param secure the value to set
         * @return the dsl builder
         */
        default DockerEndpointConsumerBuilder secure(String secure) {
            doSetProperty("secure", secure);
            return this;
        }
        /**
         * Check TLS.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param tlsVerify the value to set
         * @return the dsl builder
         */
        default DockerEndpointConsumerBuilder tlsVerify(boolean tlsVerify) {
            doSetProperty("tlsVerify", tlsVerify);
            return this;
        }
        /**
         * Check TLS.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: security
         * 
         * @param tlsVerify the value to set
         * @return the dsl builder
         */
        default DockerEndpointConsumerBuilder tlsVerify(String tlsVerify) {
            doSetProperty("tlsVerify", tlsVerify);
            return this;
        }
        /**
         * User name to authenticate with.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default DockerEndpointConsumerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Docker component.
     */
    public interface AdvancedDockerEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default DockerEndpointConsumerBuilder basic() {
            return (DockerEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * The fully qualified class name of the DockerCmdExecFactory
         * implementation to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: com.github.dockerjava.netty.NettyDockerCmdExecFactory
         * Group: advanced
         * 
         * @param cmdExecFactory the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointConsumerBuilder cmdExecFactory(
                String cmdExecFactory) {
            doSetProperty("cmdExecFactory", cmdExecFactory);
            return this;
        }
        /**
         * Whether to follow redirect filter.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param followRedirectFilter the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointConsumerBuilder followRedirectFilter(
                boolean followRedirectFilter) {
            doSetProperty("followRedirectFilter", followRedirectFilter);
            return this;
        }
        /**
         * Whether to follow redirect filter.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param followRedirectFilter the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointConsumerBuilder followRedirectFilter(
                String followRedirectFilter) {
            doSetProperty("followRedirectFilter", followRedirectFilter);
            return this;
        }
        /**
         * Whether to use logging filter.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param loggingFilter the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointConsumerBuilder loggingFilter(
                boolean loggingFilter) {
            doSetProperty("loggingFilter", loggingFilter);
            return this;
        }
        /**
         * Whether to use logging filter.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param loggingFilter the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointConsumerBuilder loggingFilter(
                String loggingFilter) {
            doSetProperty("loggingFilter", loggingFilter);
            return this;
        }
        /**
         * Maximum route connections.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: advanced
         * 
         * @param maxPerRouteConnections the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointConsumerBuilder maxPerRouteConnections(
                Integer maxPerRouteConnections) {
            doSetProperty("maxPerRouteConnections", maxPerRouteConnections);
            return this;
        }
        /**
         * Maximum route connections.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: advanced
         * 
         * @param maxPerRouteConnections the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointConsumerBuilder maxPerRouteConnections(
                String maxPerRouteConnections) {
            doSetProperty("maxPerRouteConnections", maxPerRouteConnections);
            return this;
        }
        /**
         * Maximum total connections.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: advanced
         * 
         * @param maxTotalConnections the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointConsumerBuilder maxTotalConnections(
                Integer maxTotalConnections) {
            doSetProperty("maxTotalConnections", maxTotalConnections);
            return this;
        }
        /**
         * Maximum total connections.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: advanced
         * 
         * @param maxTotalConnections the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointConsumerBuilder maxTotalConnections(
                String maxTotalConnections) {
            doSetProperty("maxTotalConnections", maxTotalConnections);
            return this;
        }
        /**
         * Additional configuration parameters as key/value pairs.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param parameters the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointConsumerBuilder parameters(
                Map<java.lang.String, java.lang.Object> parameters) {
            doSetProperty("parameters", parameters);
            return this;
        }
        /**
         * Additional configuration parameters as key/value pairs.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param parameters the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointConsumerBuilder parameters(
                String parameters) {
            doSetProperty("parameters", parameters);
            return this;
        }
        /**
         * Server address for docker registry.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: https://index.docker.io/v1/
         * Group: advanced
         * 
         * @param serverAddress the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointConsumerBuilder serverAddress(
                String serverAddress) {
            doSetProperty("serverAddress", serverAddress);
            return this;
        }
        /**
         * Socket connection mode.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param socket the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointConsumerBuilder socket(boolean socket) {
            doSetProperty("socket", socket);
            return this;
        }
        /**
         * Socket connection mode.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param socket the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointConsumerBuilder socket(String socket) {
            doSetProperty("socket", socket);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Docker component.
     */
    public interface DockerEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedDockerEndpointProducerBuilder advanced() {
            return (AdvancedDockerEndpointProducerBuilder) this;
        }
        /**
         * Email address associated with the user.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param email the value to set
         * @return the dsl builder
         */
        default DockerEndpointProducerBuilder email(String email) {
            doSetProperty("email", email);
            return this;
        }
        /**
         * Docker host.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Required: true
         * Default: localhost
         * Group: common
         * 
         * @param host the value to set
         * @return the dsl builder
         */
        default DockerEndpointProducerBuilder host(String host) {
            doSetProperty("host", host);
            return this;
        }
        /**
         * Docker port.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 2375
         * Group: common
         * 
         * @param port the value to set
         * @return the dsl builder
         */
        default DockerEndpointProducerBuilder port(Integer port) {
            doSetProperty("port", port);
            return this;
        }
        /**
         * Docker port.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 2375
         * Group: common
         * 
         * @param port the value to set
         * @return the dsl builder
         */
        default DockerEndpointProducerBuilder port(String port) {
            doSetProperty("port", port);
            return this;
        }
        /**
         * Request timeout for response (in seconds).
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param requestTimeout the value to set
         * @return the dsl builder
         */
        default DockerEndpointProducerBuilder requestTimeout(
                Integer requestTimeout) {
            doSetProperty("requestTimeout", requestTimeout);
            return this;
        }
        /**
         * Request timeout for response (in seconds).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param requestTimeout the value to set
         * @return the dsl builder
         */
        default DockerEndpointProducerBuilder requestTimeout(
                String requestTimeout) {
            doSetProperty("requestTimeout", requestTimeout);
            return this;
        }
        /**
         * Location containing the SSL certificate chain.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param certPath the value to set
         * @return the dsl builder
         */
        default DockerEndpointProducerBuilder certPath(String certPath) {
            doSetProperty("certPath", certPath);
            return this;
        }
        /**
         * Password to authenticate with.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default DockerEndpointProducerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Use HTTPS communication.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param secure the value to set
         * @return the dsl builder
         */
        default DockerEndpointProducerBuilder secure(boolean secure) {
            doSetProperty("secure", secure);
            return this;
        }
        /**
         * Use HTTPS communication.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: security
         * 
         * @param secure the value to set
         * @return the dsl builder
         */
        default DockerEndpointProducerBuilder secure(String secure) {
            doSetProperty("secure", secure);
            return this;
        }
        /**
         * Check TLS.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param tlsVerify the value to set
         * @return the dsl builder
         */
        default DockerEndpointProducerBuilder tlsVerify(boolean tlsVerify) {
            doSetProperty("tlsVerify", tlsVerify);
            return this;
        }
        /**
         * Check TLS.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: security
         * 
         * @param tlsVerify the value to set
         * @return the dsl builder
         */
        default DockerEndpointProducerBuilder tlsVerify(String tlsVerify) {
            doSetProperty("tlsVerify", tlsVerify);
            return this;
        }
        /**
         * User name to authenticate with.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default DockerEndpointProducerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Docker component.
     */
    public interface AdvancedDockerEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default DockerEndpointProducerBuilder basic() {
            return (DockerEndpointProducerBuilder) this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * The fully qualified class name of the DockerCmdExecFactory
         * implementation to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: com.github.dockerjava.netty.NettyDockerCmdExecFactory
         * Group: advanced
         * 
         * @param cmdExecFactory the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointProducerBuilder cmdExecFactory(
                String cmdExecFactory) {
            doSetProperty("cmdExecFactory", cmdExecFactory);
            return this;
        }
        /**
         * Whether to follow redirect filter.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param followRedirectFilter the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointProducerBuilder followRedirectFilter(
                boolean followRedirectFilter) {
            doSetProperty("followRedirectFilter", followRedirectFilter);
            return this;
        }
        /**
         * Whether to follow redirect filter.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param followRedirectFilter the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointProducerBuilder followRedirectFilter(
                String followRedirectFilter) {
            doSetProperty("followRedirectFilter", followRedirectFilter);
            return this;
        }
        /**
         * Whether to use logging filter.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param loggingFilter the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointProducerBuilder loggingFilter(
                boolean loggingFilter) {
            doSetProperty("loggingFilter", loggingFilter);
            return this;
        }
        /**
         * Whether to use logging filter.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param loggingFilter the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointProducerBuilder loggingFilter(
                String loggingFilter) {
            doSetProperty("loggingFilter", loggingFilter);
            return this;
        }
        /**
         * Maximum route connections.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: advanced
         * 
         * @param maxPerRouteConnections the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointProducerBuilder maxPerRouteConnections(
                Integer maxPerRouteConnections) {
            doSetProperty("maxPerRouteConnections", maxPerRouteConnections);
            return this;
        }
        /**
         * Maximum route connections.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: advanced
         * 
         * @param maxPerRouteConnections the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointProducerBuilder maxPerRouteConnections(
                String maxPerRouteConnections) {
            doSetProperty("maxPerRouteConnections", maxPerRouteConnections);
            return this;
        }
        /**
         * Maximum total connections.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: advanced
         * 
         * @param maxTotalConnections the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointProducerBuilder maxTotalConnections(
                Integer maxTotalConnections) {
            doSetProperty("maxTotalConnections", maxTotalConnections);
            return this;
        }
        /**
         * Maximum total connections.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: advanced
         * 
         * @param maxTotalConnections the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointProducerBuilder maxTotalConnections(
                String maxTotalConnections) {
            doSetProperty("maxTotalConnections", maxTotalConnections);
            return this;
        }
        /**
         * Additional configuration parameters as key/value pairs.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param parameters the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointProducerBuilder parameters(
                Map<java.lang.String, java.lang.Object> parameters) {
            doSetProperty("parameters", parameters);
            return this;
        }
        /**
         * Additional configuration parameters as key/value pairs.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param parameters the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointProducerBuilder parameters(
                String parameters) {
            doSetProperty("parameters", parameters);
            return this;
        }
        /**
         * Server address for docker registry.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: https://index.docker.io/v1/
         * Group: advanced
         * 
         * @param serverAddress the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointProducerBuilder serverAddress(
                String serverAddress) {
            doSetProperty("serverAddress", serverAddress);
            return this;
        }
        /**
         * Socket connection mode.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param socket the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointProducerBuilder socket(boolean socket) {
            doSetProperty("socket", socket);
            return this;
        }
        /**
         * Socket connection mode.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param socket the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointProducerBuilder socket(String socket) {
            doSetProperty("socket", socket);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Docker component.
     */
    public interface DockerEndpointBuilder
            extends
                DockerEndpointConsumerBuilder,
                DockerEndpointProducerBuilder {
        default AdvancedDockerEndpointBuilder advanced() {
            return (AdvancedDockerEndpointBuilder) this;
        }
        /**
         * Email address associated with the user.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param email the value to set
         * @return the dsl builder
         */
        default DockerEndpointBuilder email(String email) {
            doSetProperty("email", email);
            return this;
        }
        /**
         * Docker host.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Required: true
         * Default: localhost
         * Group: common
         * 
         * @param host the value to set
         * @return the dsl builder
         */
        default DockerEndpointBuilder host(String host) {
            doSetProperty("host", host);
            return this;
        }
        /**
         * Docker port.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 2375
         * Group: common
         * 
         * @param port the value to set
         * @return the dsl builder
         */
        default DockerEndpointBuilder port(Integer port) {
            doSetProperty("port", port);
            return this;
        }
        /**
         * Docker port.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 2375
         * Group: common
         * 
         * @param port the value to set
         * @return the dsl builder
         */
        default DockerEndpointBuilder port(String port) {
            doSetProperty("port", port);
            return this;
        }
        /**
         * Request timeout for response (in seconds).
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param requestTimeout the value to set
         * @return the dsl builder
         */
        default DockerEndpointBuilder requestTimeout(Integer requestTimeout) {
            doSetProperty("requestTimeout", requestTimeout);
            return this;
        }
        /**
         * Request timeout for response (in seconds).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param requestTimeout the value to set
         * @return the dsl builder
         */
        default DockerEndpointBuilder requestTimeout(String requestTimeout) {
            doSetProperty("requestTimeout", requestTimeout);
            return this;
        }
        /**
         * Location containing the SSL certificate chain.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param certPath the value to set
         * @return the dsl builder
         */
        default DockerEndpointBuilder certPath(String certPath) {
            doSetProperty("certPath", certPath);
            return this;
        }
        /**
         * Password to authenticate with.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default DockerEndpointBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Use HTTPS communication.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param secure the value to set
         * @return the dsl builder
         */
        default DockerEndpointBuilder secure(boolean secure) {
            doSetProperty("secure", secure);
            return this;
        }
        /**
         * Use HTTPS communication.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: security
         * 
         * @param secure the value to set
         * @return the dsl builder
         */
        default DockerEndpointBuilder secure(String secure) {
            doSetProperty("secure", secure);
            return this;
        }
        /**
         * Check TLS.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param tlsVerify the value to set
         * @return the dsl builder
         */
        default DockerEndpointBuilder tlsVerify(boolean tlsVerify) {
            doSetProperty("tlsVerify", tlsVerify);
            return this;
        }
        /**
         * Check TLS.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: security
         * 
         * @param tlsVerify the value to set
         * @return the dsl builder
         */
        default DockerEndpointBuilder tlsVerify(String tlsVerify) {
            doSetProperty("tlsVerify", tlsVerify);
            return this;
        }
        /**
         * User name to authenticate with.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default DockerEndpointBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Docker component.
     */
    public interface AdvancedDockerEndpointBuilder
            extends
                AdvancedDockerEndpointConsumerBuilder,
                AdvancedDockerEndpointProducerBuilder {
        default DockerEndpointBuilder basic() {
            return (DockerEndpointBuilder) this;
        }
        /**
         * The fully qualified class name of the DockerCmdExecFactory
         * implementation to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: com.github.dockerjava.netty.NettyDockerCmdExecFactory
         * Group: advanced
         * 
         * @param cmdExecFactory the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointBuilder cmdExecFactory(
                String cmdExecFactory) {
            doSetProperty("cmdExecFactory", cmdExecFactory);
            return this;
        }
        /**
         * Whether to follow redirect filter.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param followRedirectFilter the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointBuilder followRedirectFilter(
                boolean followRedirectFilter) {
            doSetProperty("followRedirectFilter", followRedirectFilter);
            return this;
        }
        /**
         * Whether to follow redirect filter.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param followRedirectFilter the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointBuilder followRedirectFilter(
                String followRedirectFilter) {
            doSetProperty("followRedirectFilter", followRedirectFilter);
            return this;
        }
        /**
         * Whether to use logging filter.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param loggingFilter the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointBuilder loggingFilter(
                boolean loggingFilter) {
            doSetProperty("loggingFilter", loggingFilter);
            return this;
        }
        /**
         * Whether to use logging filter.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param loggingFilter the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointBuilder loggingFilter(String loggingFilter) {
            doSetProperty("loggingFilter", loggingFilter);
            return this;
        }
        /**
         * Maximum route connections.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: advanced
         * 
         * @param maxPerRouteConnections the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointBuilder maxPerRouteConnections(
                Integer maxPerRouteConnections) {
            doSetProperty("maxPerRouteConnections", maxPerRouteConnections);
            return this;
        }
        /**
         * Maximum route connections.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: advanced
         * 
         * @param maxPerRouteConnections the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointBuilder maxPerRouteConnections(
                String maxPerRouteConnections) {
            doSetProperty("maxPerRouteConnections", maxPerRouteConnections);
            return this;
        }
        /**
         * Maximum total connections.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: advanced
         * 
         * @param maxTotalConnections the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointBuilder maxTotalConnections(
                Integer maxTotalConnections) {
            doSetProperty("maxTotalConnections", maxTotalConnections);
            return this;
        }
        /**
         * Maximum total connections.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: advanced
         * 
         * @param maxTotalConnections the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointBuilder maxTotalConnections(
                String maxTotalConnections) {
            doSetProperty("maxTotalConnections", maxTotalConnections);
            return this;
        }
        /**
         * Additional configuration parameters as key/value pairs.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param parameters the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointBuilder parameters(
                Map<java.lang.String, java.lang.Object> parameters) {
            doSetProperty("parameters", parameters);
            return this;
        }
        /**
         * Additional configuration parameters as key/value pairs.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param parameters the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointBuilder parameters(String parameters) {
            doSetProperty("parameters", parameters);
            return this;
        }
        /**
         * Server address for docker registry.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: https://index.docker.io/v1/
         * Group: advanced
         * 
         * @param serverAddress the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointBuilder serverAddress(String serverAddress) {
            doSetProperty("serverAddress", serverAddress);
            return this;
        }
        /**
         * Socket connection mode.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param socket the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointBuilder socket(boolean socket) {
            doSetProperty("socket", socket);
            return this;
        }
        /**
         * Socket connection mode.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param socket the value to set
         * @return the dsl builder
         */
        default AdvancedDockerEndpointBuilder socket(String socket) {
            doSetProperty("socket", socket);
            return this;
        }
    }

    public interface DockerBuilders {
        /**
         * Docker (camel-docker)
         * Manage Docker containers.
         * 
         * Category: cloud,container,paas
         * Since: 2.15
         * Maven coordinates: org.apache.camel:camel-docker
         * 
         * @return the dsl builder for the headers' name.
         */
        default DockerHeaderNameBuilder docker() {
            return DockerHeaderNameBuilder.INSTANCE;
        }
        /**
         * Docker (camel-docker)
         * Manage Docker containers.
         * 
         * Category: cloud,container,paas
         * Since: 2.15
         * Maven coordinates: org.apache.camel:camel-docker
         * 
         * Syntax: <code>docker:operation</code>
         * 
         * Path parameter: operation (required)
         * Which operation to use
         * There are 37 enums and the value can be one of: events, stats, auth,
         * info, ping, version, imagebuild, imagecreate, imageinspect,
         * imagelist, imagepull, imagepush, imageremove, imagesearch, imagetag,
         * containerattach, containercommit, containercopyfile, containercreate,
         * containerdiff, inspectcontainer, containerkill, containerlist,
         * containerlog, containerpause, containerrestart, containerremove,
         * containerstart, containerstop, containertop, containerunpause,
         * containerwait, execcreate, execstart, networkconnect, networkcreate,
         * networkremove
         * 
         * @param path operation
         * @return the dsl builder
         */
        default DockerEndpointBuilder docker(String path) {
            return DockerEndpointBuilderFactory.endpointBuilder("docker", path);
        }
        /**
         * Docker (camel-docker)
         * Manage Docker containers.
         * 
         * Category: cloud,container,paas
         * Since: 2.15
         * Maven coordinates: org.apache.camel:camel-docker
         * 
         * Syntax: <code>docker:operation</code>
         * 
         * Path parameter: operation (required)
         * Which operation to use
         * There are 37 enums and the value can be one of: events, stats, auth,
         * info, ping, version, imagebuild, imagecreate, imageinspect,
         * imagelist, imagepull, imagepush, imageremove, imagesearch, imagetag,
         * containerattach, containercommit, containercopyfile, containercreate,
         * containerdiff, inspectcontainer, containerkill, containerlist,
         * containerlog, containerpause, containerrestart, containerremove,
         * containerstart, containerstop, containertop, containerunpause,
         * containerwait, execcreate, execstart, networkconnect, networkcreate,
         * networkremove
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path operation
         * @return the dsl builder
         */
        default DockerEndpointBuilder docker(String componentName, String path) {
            return DockerEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    /**
     * The builder of headers' name for the Docker component.
     */
    public static class DockerHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final DockerHeaderNameBuilder INSTANCE = new DockerHeaderNameBuilder();

        /**
         * The request timeout for response (in seconds).
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerRequestTimeout}.
         */
        public String dockerRequestTimeout() {
            return "DockerRequestTimeout";
        }

        /**
         * The location containing the SSL certificate chain.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerCertPath}.
         */
        public String dockerCertPath() {
            return "DockerCertPath";
        }

        /**
         * The docker host.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerHost}.
         */
        public String dockerHost() {
            return "DockerHost";
        }

        /**
         * The docker port.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerPort}.
         */
        public String dockerPort() {
            return "DockerPort";
        }

        /**
         * The maximum route connections.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerMaxPerRouteConnections}.
         */
        public String dockerMaxPerRouteConnections() {
            return "DockerMaxPerRouteConnections";
        }

        /**
         * The maximum total connections.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerMaxTotalConnections}.
         */
        public String dockerMaxTotalConnections() {
            return "DockerMaxTotalConnections";
        }

        /**
         * Use HTTPS communication.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Default: false
         * Group: common
         * 
         * @return the name of the header {@code DockerSecure}.
         */
        public String dockerSecure() {
            return "DockerSecure";
        }

        /**
         * Check TLS.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Default: false
         * Group: common
         * 
         * @return the name of the header {@code DockerTlsVerify}.
         */
        public String dockerTlsVerify() {
            return "DockerTlsVerify";
        }

        /**
         * Socket connection mode.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Default: true
         * Group: common
         * 
         * @return the name of the header {@code DockerSocketEnabled}.
         */
        public String dockerSocketEnabled() {
            return "DockerSocketEnabled";
        }

        /**
         * The fully qualified class name of the DockerCmdExecFactory
         * implementation to use.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerCmdExecFactory}.
         */
        public String dockerCmdExecFactory() {
            return "DockerCmdExecFactory";
        }

        /**
         * With label filter.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerFilter}.
         */
        public String dockerFilter() {
            return "DockerFilter";
        }

        /**
         * With show all flag.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerShowAll}.
         */
        public String dockerShowAll() {
            return "DockerShowAll";
        }

        /**
         * The id of the container.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerContainerId}.
         */
        public String dockerContainerId() {
            return "DockerContainerId";
        }

        /**
         * The Image ID.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerImageId}.
         */
        public String dockerImageId() {
            return "DockerImageId";
        }

        /**
         * The email address associated with the user.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerEmail}.
         */
        public String dockerEmail() {
            return "DockerEmail";
        }

        /**
         * The password to authenticate with.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerPassword}.
         */
        public String dockerPassword() {
            return "DockerPassword";
        }

        /**
         * The server address for docker registry.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerServerAddress}.
         */
        public String dockerServerAddress() {
            return "DockerServerAddress";
        }

        /**
         * The user name to authenticate with.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerUsername}.
         */
        public String dockerUsername() {
            return "DockerUsername";
        }

        /**
         * The registry.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerRegistry}.
         */
        public String dockerRegistry() {
            return "DockerRegistry";
        }

        /**
         * The repository.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerRepository}.
         */
        public String dockerRepository() {
            return "DockerRepository";
        }

        /**
         * The tag.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerTag}.
         */
        public String dockerTag() {
            return "DockerTag";
        }

        /**
         * The image name.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerName}.
         */
        public String dockerName() {
            return "DockerName";
        }

        /**
         * The term to search.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerTerm}.
         */
        public String dockerTerm() {
            return "DockerTerm";
        }

        /**
         * With force flag.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerForce}.
         */
        public String dockerForce() {
            return "DockerForce";
        }

        /**
         * With no prune flag.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerNoPrune}.
         */
        public String dockerNoPrune() {
            return "DockerNoPrune";
        }

        /**
         * The initial range.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerInitialRange}.
         */
        public String dockerInitialRange() {
            return "DockerInitialRange";
        }

        /**
         * With before.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerBefore}.
         */
        public String dockerBefore() {
            return "DockerBefore";
        }

        /**
         * With limit.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerLimit}.
         */
        public String dockerLimit() {
            return "DockerLimit";
        }

        /**
         * With show size flag.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerShowSize}.
         */
        public String dockerShowSize() {
            return "DockerShowSize";
        }

        /**
         * With since.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerSince}.
         */
        public String dockerSince() {
            return "DockerSince";
        }

        /**
         * With remove volumes flag.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerRemoveVolumes}.
         */
        public String dockerRemoveVolumes() {
            return "DockerRemoveVolumes";
        }

        /**
         * With follow stream flag.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerFollowStream}.
         */
        public String dockerFollowStream() {
            return "DockerFollowStream";
        }

        /**
         * With logs flag.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerLogs}.
         */
        public String dockerLogs() {
            return "DockerLogs";
        }

        /**
         * With stdErr flag.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerStdErr}.
         */
        public String dockerStdErr() {
            return "DockerStdErr";
        }

        /**
         * With stdOut flag.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerStdOut}.
         */
        public String dockerStdOut() {
            return "DockerStdOut";
        }

        /**
         * With timestamps flag.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerTimestamps}.
         */
        public String dockerTimestamps() {
            return "DockerTimestamps";
        }

        /**
         * With Tail.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerTail}.
         */
        public String dockerTail() {
            return "DockerTail";
        }

        /**
         * With tail all flag.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerTailAll}.
         */
        public String dockerTailAll() {
            return "DockerTailAll";
        }

        /**
         * The host path.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerHostPath}.
         */
        public String dockerHostPath() {
            return "DockerHostPath";
        }

        /**
         * The resource.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerResource}.
         */
        public String dockerResource() {
            return "DockerResource";
        }

        /**
         * With container id for diff container request.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerContainerIdDiff}.
         */
        public String dockerContainerIdDiff() {
            return "DockerContainerIdDiff";
        }

        /**
         * With timeout.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerTimeout}.
         */
        public String dockerTimeout() {
            return "DockerTimeout";
        }

        /**
         * With signal.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerSignal}.
         */
        public String dockerSignal() {
            return "DockerSignal";
        }

        /**
         * With ps args.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerPsArgs}.
         */
        public String dockerPsArgs() {
            return "DockerPsArgs";
        }

        /**
         * With no cache flag.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerNoCache}.
         */
        public String dockerNoCache() {
            return "DockerNoCache";
        }

        /**
         * With quiet flag.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerQuiet}.
         */
        public String dockerQuiet() {
            return "DockerQuiet";
        }

        /**
         * With remove flag.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerRemove}.
         */
        public String dockerRemove() {
            return "DockerRemove";
        }

        /**
         * With attach StdErr flag.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerAttachStdErr}.
         */
        public String dockerAttachStdErr() {
            return "DockerAttachStdErr";
        }

        /**
         * With attach StdIn flag.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerAttachStdIn}.
         */
        public String dockerAttachStdIn() {
            return "DockerAttachStdIn";
        }

        /**
         * With attach StdOut flag.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerAttachStdOut}.
         */
        public String dockerAttachStdOut() {
            return "DockerAttachStdOut";
        }

        /**
         * The author.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerAuthor}.
         */
        public String dockerAuthor() {
            return "DockerAuthor";
        }

        /**
         * With cmd.
         * 
         * The option is a: {@code String or String[]} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerCmd}.
         */
        public String dockerCmd() {
            return "DockerCmd";
        }

        /**
         * With disable network flag.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerDisableNetwork}.
         */
        public String dockerDisableNetwork() {
            return "DockerDisableNetwork";
        }

        /**
         * With env.
         * 
         * The option is a: {@code String or String[]} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerEnv}.
         */
        public String dockerEnv() {
            return "DockerEnv";
        }

        /**
         * The exposed ports.
         * 
         * The option is a: {@code ExposedPorts or ExposedPorts[]} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerExposedPorts}.
         */
        public String dockerExposedPorts() {
            return "DockerExposedPorts";
        }

        /**
         * The hostname.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerHostname}.
         */
        public String dockerHostname() {
            return "DockerHostname";
        }

        /**
         * The message.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerMessage}.
         */
        public String dockerMessage() {
            return "DockerMessage";
        }

        /**
         * With memory.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerMemory}.
         */
        public String dockerMemory() {
            return "DockerMemory";
        }

        /**
         * With memory swap.
         * 
         * The option is a: {@code Long or Integer} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerMemorySwap}.
         */
        public String dockerMemorySwap() {
            return "DockerMemorySwap";
        }

        /**
         * With open StdIn flag.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerOpenStdIn}.
         */
        public String dockerOpenStdIn() {
            return "DockerOpenStdIn";
        }

        /**
         * With pause flag.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerPause}.
         */
        public String dockerPause() {
            return "DockerPause";
        }

        /**
         * With port specs.
         * 
         * The option is a: {@code String or String[]} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerPortSpecs}.
         */
        public String dockerPortSpecs() {
            return "DockerPortSpecs";
        }

        /**
         * With StdIn in once flag.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerStdInOnce}.
         */
        public String dockerStdInOnce() {
            return "DockerStdInOnce";
        }

        /**
         * With TTY flag.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerTty}.
         */
        public String dockerTty() {
            return "DockerTty";
        }

        /**
         * With user.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerUser}.
         */
        public String dockerUser() {
            return "DockerUser";
        }

        /**
         * With volumes.
         * 
         * The option is a: {@code Volume or Volume[]} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerVolumes}.
         */
        public String dockerVolumes() {
            return "DockerVolumes";
        }

        /**
         * With working directory.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerWorkingDir}.
         */
        public String dockerWorkingDir() {
            return "DockerWorkingDir";
        }

        /**
         * With CPU shares.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerCpuShares}.
         */
        public String dockerCpuShares() {
            return "DockerCpuShares";
        }

        /**
         * With dns.
         * 
         * The option is a: {@code String or String[]} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerDns}.
         */
        public String dockerDns() {
            return "DockerDns";
        }

        /**
         * With entrypoint.
         * 
         * The option is a: {@code String or String[]} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerEntryPoint}.
         */
        public String dockerEntryPoint() {
            return "DockerEntryPoint";
        }

        /**
         * With host config.
         * 
         * The option is a: {@code com.github.dockerjava.api.model.HostConfig}
         * type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerHostConfig}.
         */
        public String dockerHostConfig() {
            return "DockerHostConfig";
        }

        /**
         * The docker image.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerImage}.
         */
        public String dockerImage() {
            return "DockerImage";
        }

        /**
         * With memory limit.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerMemoryLimit}.
         */
        public String dockerMemoryLimit() {
            return "DockerMemoryLimit";
        }

        /**
         * With StdIn in open flag.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerStdInOpen}.
         */
        public String dockerStdInOpen() {
            return "DockerStdInOpen";
        }

        /**
         * With volumes from.
         * 
         * The option is a: {@code VolumesFrom or VolumesFrom[]} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerVolumesFrom}.
         */
        public String dockerVolumesFrom() {
            return "DockerVolumesFrom";
        }

        /**
         * With domain name.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerDomainName}.
         */
        public String dockerDomainName() {
            return "DockerDomainName";
        }

        /**
         * With cap add.
         * 
         * The option is a: {@code Capability or Capability[]} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerCapAdd}.
         */
        public String dockerCapAdd() {
            return "DockerCapAdd";
        }

        /**
         * With cap drop.
         * 
         * The option is a: {@code Capability or Capability[]} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerCapDrop}.
         */
        public String dockerCapDrop() {
            return "DockerCapDrop";
        }

        /**
         * The network name.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerNetwork}.
         */
        public String dockerNetwork() {
            return "DockerNetwork";
        }

        /**
         * With detach flag.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerDetach}.
         */
        public String dockerDetach() {
            return "DockerDetach";
        }

        /**
         * The Exec ID.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DockerExecId}.
         */
        public String dockerExecId() {
            return "DockerExecId";
        }
    }
    static DockerEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class DockerEndpointBuilderImpl extends AbstractEndpointBuilder implements DockerEndpointBuilder, AdvancedDockerEndpointBuilder {
            public DockerEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new DockerEndpointBuilderImpl(path);
    }
}