/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Send and receive messages from/to Apache Pulsar messaging system.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface PulsarEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Pulsar component.
     */
    public interface PulsarEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedPulsarEndpointConsumerBuilder advanced() {
            return (AdvancedPulsarEndpointConsumerBuilder) this;
        }
        /**
         * The Authentication FQCN to be used while creating the client from
         * URI.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param authenticationClass the value to set
         * @return the dsl builder
         */
        default PulsarEndpointConsumerBuilder authenticationClass(
                String authenticationClass) {
            doSetProperty("authenticationClass", authenticationClass);
            return this;
        }
        /**
         * The Authentication Parameters to be used while creating the client
         * from URI.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param authenticationParams the value to set
         * @return the dsl builder
         */
        default PulsarEndpointConsumerBuilder authenticationParams(
                String authenticationParams) {
            doSetProperty("authenticationParams", authenticationParams);
            return this;
        }
        /**
         * The Pulsar Service URL to point while creating the client from URI.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param serviceUrl the value to set
         * @return the dsl builder
         */
        default PulsarEndpointConsumerBuilder serviceUrl(String serviceUrl) {
            doSetProperty("serviceUrl", serviceUrl);
            return this;
        }
        /**
         * Group the consumer acknowledgments for the specified time in
         * milliseconds - defaults to 100.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: consumer
         * 
         * @param ackGroupTimeMillis the value to set
         * @return the dsl builder
         */
        default PulsarEndpointConsumerBuilder ackGroupTimeMillis(
                long ackGroupTimeMillis) {
            doSetProperty("ackGroupTimeMillis", ackGroupTimeMillis);
            return this;
        }
        /**
         * Group the consumer acknowledgments for the specified time in
         * milliseconds - defaults to 100.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: consumer
         * 
         * @param ackGroupTimeMillis the value to set
         * @return the dsl builder
         */
        default PulsarEndpointConsumerBuilder ackGroupTimeMillis(
                String ackGroupTimeMillis) {
            doSetProperty("ackGroupTimeMillis", ackGroupTimeMillis);
            return this;
        }
        /**
         * Timeout for unacknowledged messages in milliseconds - defaults to
         * 10000.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: consumer
         * 
         * @param ackTimeoutMillis the value to set
         * @return the dsl builder
         */
        default PulsarEndpointConsumerBuilder ackTimeoutMillis(
                long ackTimeoutMillis) {
            doSetProperty("ackTimeoutMillis", ackTimeoutMillis);
            return this;
        }
        /**
         * Timeout for unacknowledged messages in milliseconds - defaults to
         * 10000.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: consumer
         * 
         * @param ackTimeoutMillis the value to set
         * @return the dsl builder
         */
        default PulsarEndpointConsumerBuilder ackTimeoutMillis(
                String ackTimeoutMillis) {
            doSetProperty("ackTimeoutMillis", ackTimeoutMillis);
            return this;
        }
        /**
         * Whether to allow manual message acknowledgements. If this option is
         * enabled, then messages are not acknowledged automatically after
         * successful route completion. Instead, an instance of
         * PulsarMessageReceipt is stored as a header on the
         * org.apache.camel.Exchange. Messages can then be acknowledged using
         * PulsarMessageReceipt at any time before the ackTimeout occurs.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param allowManualAcknowledgement the value to set
         * @return the dsl builder
         */
        default PulsarEndpointConsumerBuilder allowManualAcknowledgement(
                boolean allowManualAcknowledgement) {
            doSetProperty("allowManualAcknowledgement", allowManualAcknowledgement);
            return this;
        }
        /**
         * Whether to allow manual message acknowledgements. If this option is
         * enabled, then messages are not acknowledged automatically after
         * successful route completion. Instead, an instance of
         * PulsarMessageReceipt is stored as a header on the
         * org.apache.camel.Exchange. Messages can then be acknowledged using
         * PulsarMessageReceipt at any time before the ackTimeout occurs.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param allowManualAcknowledgement the value to set
         * @return the dsl builder
         */
        default PulsarEndpointConsumerBuilder allowManualAcknowledgement(
                String allowManualAcknowledgement) {
            doSetProperty("allowManualAcknowledgement", allowManualAcknowledgement);
            return this;
        }
        /**
         * Name of the consumer when subscription is EXCLUSIVE.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: sole-consumer
         * Group: consumer
         * 
         * @param consumerName the value to set
         * @return the dsl builder
         */
        default PulsarEndpointConsumerBuilder consumerName(String consumerName) {
            doSetProperty("consumerName", consumerName);
            return this;
        }
        /**
         * Prefix to add to consumer names when a SHARED or FAILOVER
         * subscription is used.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: cons
         * Group: consumer
         * 
         * @param consumerNamePrefix the value to set
         * @return the dsl builder
         */
        default PulsarEndpointConsumerBuilder consumerNamePrefix(
                String consumerNamePrefix) {
            doSetProperty("consumerNamePrefix", consumerNamePrefix);
            return this;
        }
        /**
         * Size of the consumer queue - defaults to 10.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10
         * Group: consumer
         * 
         * @param consumerQueueSize the value to set
         * @return the dsl builder
         */
        default PulsarEndpointConsumerBuilder consumerQueueSize(
                int consumerQueueSize) {
            doSetProperty("consumerQueueSize", consumerQueueSize);
            return this;
        }
        /**
         * Size of the consumer queue - defaults to 10.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10
         * Group: consumer
         * 
         * @param consumerQueueSize the value to set
         * @return the dsl builder
         */
        default PulsarEndpointConsumerBuilder consumerQueueSize(
                String consumerQueueSize) {
            doSetProperty("consumerQueueSize", consumerQueueSize);
            return this;
        }
        /**
         * Name of the topic where the messages which fail maxRedeliverCount
         * times will be sent. Note: if not set, default topic name will be
         * topicName-subscriptionName-DLQ.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param deadLetterTopic the value to set
         * @return the dsl builder
         */
        default PulsarEndpointConsumerBuilder deadLetterTopic(
                String deadLetterTopic) {
            doSetProperty("deadLetterTopic", deadLetterTopic);
            return this;
        }
        /**
         * Maximum number of times that a message will be redelivered before
         * being sent to the dead letter queue. If this value is not set, no
         * Dead Letter Policy will be created.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param maxRedeliverCount the value to set
         * @return the dsl builder
         */
        default PulsarEndpointConsumerBuilder maxRedeliverCount(
                Integer maxRedeliverCount) {
            doSetProperty("maxRedeliverCount", maxRedeliverCount);
            return this;
        }
        /**
         * Maximum number of times that a message will be redelivered before
         * being sent to the dead letter queue. If this value is not set, no
         * Dead Letter Policy will be created.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param maxRedeliverCount the value to set
         * @return the dsl builder
         */
        default PulsarEndpointConsumerBuilder maxRedeliverCount(
                String maxRedeliverCount) {
            doSetProperty("maxRedeliverCount", maxRedeliverCount);
            return this;
        }
        /**
         * Whether to use the messageListener interface, or to receive messages
         * using a separate thread pool.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param messageListener the value to set
         * @return the dsl builder
         */
        default PulsarEndpointConsumerBuilder messageListener(
                boolean messageListener) {
            doSetProperty("messageListener", messageListener);
            return this;
        }
        /**
         * Whether to use the messageListener interface, or to receive messages
         * using a separate thread pool.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param messageListener the value to set
         * @return the dsl builder
         */
        default PulsarEndpointConsumerBuilder messageListener(
                String messageListener) {
            doSetProperty("messageListener", messageListener);
            return this;
        }
        /**
         * Set the negative acknowledgement delay.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 60000000
         * Group: consumer
         * 
         * @param negativeAckRedeliveryDelayMicros the value to set
         * @return the dsl builder
         */
        default PulsarEndpointConsumerBuilder negativeAckRedeliveryDelayMicros(
                long negativeAckRedeliveryDelayMicros) {
            doSetProperty("negativeAckRedeliveryDelayMicros", negativeAckRedeliveryDelayMicros);
            return this;
        }
        /**
         * Set the negative acknowledgement delay.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 60000000
         * Group: consumer
         * 
         * @param negativeAckRedeliveryDelayMicros the value to set
         * @return the dsl builder
         */
        default PulsarEndpointConsumerBuilder negativeAckRedeliveryDelayMicros(
                String negativeAckRedeliveryDelayMicros) {
            doSetProperty("negativeAckRedeliveryDelayMicros", negativeAckRedeliveryDelayMicros);
            return this;
        }
        /**
         * Number of consumers - defaults to 1.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: consumer
         * 
         * @param numberOfConsumers the value to set
         * @return the dsl builder
         */
        default PulsarEndpointConsumerBuilder numberOfConsumers(
                int numberOfConsumers) {
            doSetProperty("numberOfConsumers", numberOfConsumers);
            return this;
        }
        /**
         * Number of consumers - defaults to 1.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: consumer
         * 
         * @param numberOfConsumers the value to set
         * @return the dsl builder
         */
        default PulsarEndpointConsumerBuilder numberOfConsumers(
                String numberOfConsumers) {
            doSetProperty("numberOfConsumers", numberOfConsumers);
            return this;
        }
        /**
         * Number of threads to receive and handle messages when using a
         * separate thread pool.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: consumer
         * 
         * @param numberOfConsumerThreads the value to set
         * @return the dsl builder
         */
        default PulsarEndpointConsumerBuilder numberOfConsumerThreads(
                int numberOfConsumerThreads) {
            doSetProperty("numberOfConsumerThreads", numberOfConsumerThreads);
            return this;
        }
        /**
         * Number of threads to receive and handle messages when using a
         * separate thread pool.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: consumer
         * 
         * @param numberOfConsumerThreads the value to set
         * @return the dsl builder
         */
        default PulsarEndpointConsumerBuilder numberOfConsumerThreads(
                String numberOfConsumerThreads) {
            doSetProperty("numberOfConsumerThreads", numberOfConsumerThreads);
            return this;
        }
        /**
         * Enable compacted topic reading.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param readCompacted the value to set
         * @return the dsl builder
         */
        default PulsarEndpointConsumerBuilder readCompacted(
                boolean readCompacted) {
            doSetProperty("readCompacted", readCompacted);
            return this;
        }
        /**
         * Enable compacted topic reading.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param readCompacted the value to set
         * @return the dsl builder
         */
        default PulsarEndpointConsumerBuilder readCompacted(String readCompacted) {
            doSetProperty("readCompacted", readCompacted);
            return this;
        }
        /**
         * Control the initial position in the topic of a newly created
         * subscription. Default is latest message.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.pulsar.utils.consumers.SubscriptionInitialPosition&lt;/code&gt; type.
         * 
         * Default: LATEST
         * Group: consumer
         * 
         * @param subscriptionInitialPosition the value to set
         * @return the dsl builder
         */
        default PulsarEndpointConsumerBuilder subscriptionInitialPosition(
                org.apache.camel.component.pulsar.utils.consumers.SubscriptionInitialPosition subscriptionInitialPosition) {
            doSetProperty("subscriptionInitialPosition", subscriptionInitialPosition);
            return this;
        }
        /**
         * Control the initial position in the topic of a newly created
         * subscription. Default is latest message.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.pulsar.utils.consumers.SubscriptionInitialPosition&lt;/code&gt; type.
         * 
         * Default: LATEST
         * Group: consumer
         * 
         * @param subscriptionInitialPosition the value to set
         * @return the dsl builder
         */
        default PulsarEndpointConsumerBuilder subscriptionInitialPosition(
                String subscriptionInitialPosition) {
            doSetProperty("subscriptionInitialPosition", subscriptionInitialPosition);
            return this;
        }
        /**
         * Name of the subscription to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: subs
         * Group: consumer
         * 
         * @param subscriptionName the value to set
         * @return the dsl builder
         */
        default PulsarEndpointConsumerBuilder subscriptionName(
                String subscriptionName) {
            doSetProperty("subscriptionName", subscriptionName);
            return this;
        }
        /**
         * Determines to which topics this consumer should be subscribed to -
         * Persistent, Non-Persistent, or both. Only used with pattern
         * subscriptions.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.pulsar.client.api.RegexSubscriptionMode&lt;/code&gt; type.
         * 
         * Default: PersistentOnly
         * Group: consumer
         * 
         * @param subscriptionTopicsMode the value to set
         * @return the dsl builder
         */
        default PulsarEndpointConsumerBuilder subscriptionTopicsMode(
                org.apache.pulsar.client.api.RegexSubscriptionMode subscriptionTopicsMode) {
            doSetProperty("subscriptionTopicsMode", subscriptionTopicsMode);
            return this;
        }
        /**
         * Determines to which topics this consumer should be subscribed to -
         * Persistent, Non-Persistent, or both. Only used with pattern
         * subscriptions.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.pulsar.client.api.RegexSubscriptionMode&lt;/code&gt; type.
         * 
         * Default: PersistentOnly
         * Group: consumer
         * 
         * @param subscriptionTopicsMode the value to set
         * @return the dsl builder
         */
        default PulsarEndpointConsumerBuilder subscriptionTopicsMode(
                String subscriptionTopicsMode) {
            doSetProperty("subscriptionTopicsMode", subscriptionTopicsMode);
            return this;
        }
        /**
         * Type of the subscription EXCLUSIVESHAREDFAILOVERKEY_SHARED, defaults
         * to EXCLUSIVE.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.pulsar.utils.consumers.SubscriptionType&lt;/code&gt; type.
         * 
         * Default: EXCLUSIVE
         * Group: consumer
         * 
         * @param subscriptionType the value to set
         * @return the dsl builder
         */
        default PulsarEndpointConsumerBuilder subscriptionType(
                org.apache.camel.component.pulsar.utils.consumers.SubscriptionType subscriptionType) {
            doSetProperty("subscriptionType", subscriptionType);
            return this;
        }
        /**
         * Type of the subscription EXCLUSIVESHAREDFAILOVERKEY_SHARED, defaults
         * to EXCLUSIVE.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.pulsar.utils.consumers.SubscriptionType&lt;/code&gt; type.
         * 
         * Default: EXCLUSIVE
         * Group: consumer
         * 
         * @param subscriptionType the value to set
         * @return the dsl builder
         */
        default PulsarEndpointConsumerBuilder subscriptionType(
                String subscriptionType) {
            doSetProperty("subscriptionType", subscriptionType);
            return this;
        }
        /**
         * Whether the topic is a pattern (regular expression) that allows the
         * consumer to subscribe to all matching topics in the namespace.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param topicsPattern the value to set
         * @return the dsl builder
         */
        default PulsarEndpointConsumerBuilder topicsPattern(
                boolean topicsPattern) {
            doSetProperty("topicsPattern", topicsPattern);
            return this;
        }
        /**
         * Whether the topic is a pattern (regular expression) that allows the
         * consumer to subscribe to all matching topics in the namespace.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param topicsPattern the value to set
         * @return the dsl builder
         */
        default PulsarEndpointConsumerBuilder topicsPattern(String topicsPattern) {
            doSetProperty("topicsPattern", topicsPattern);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Pulsar component.
     */
    public interface AdvancedPulsarEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default PulsarEndpointConsumerBuilder basic() {
            return (PulsarEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedPulsarEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedPulsarEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedPulsarEndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedPulsarEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedPulsarEndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedPulsarEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Pulsar component.
     */
    public interface PulsarEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedPulsarEndpointProducerBuilder advanced() {
            return (AdvancedPulsarEndpointProducerBuilder) this;
        }
        /**
         * The Authentication FQCN to be used while creating the client from
         * URI.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param authenticationClass the value to set
         * @return the dsl builder
         */
        default PulsarEndpointProducerBuilder authenticationClass(
                String authenticationClass) {
            doSetProperty("authenticationClass", authenticationClass);
            return this;
        }
        /**
         * The Authentication Parameters to be used while creating the client
         * from URI.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param authenticationParams the value to set
         * @return the dsl builder
         */
        default PulsarEndpointProducerBuilder authenticationParams(
                String authenticationParams) {
            doSetProperty("authenticationParams", authenticationParams);
            return this;
        }
        /**
         * The Pulsar Service URL to point while creating the client from URI.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param serviceUrl the value to set
         * @return the dsl builder
         */
        default PulsarEndpointProducerBuilder serviceUrl(String serviceUrl) {
            doSetProperty("serviceUrl", serviceUrl);
            return this;
        }
        /**
         * Control batching method used by the producer.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.pulsar.client.api.BatcherBuilder&lt;/code&gt;
         * type.
         * 
         * Default: DEFAULT
         * Group: producer
         * 
         * @param batcherBuilder the value to set
         * @return the dsl builder
         */
        default PulsarEndpointProducerBuilder batcherBuilder(
                org.apache.pulsar.client.api.BatcherBuilder batcherBuilder) {
            doSetProperty("batcherBuilder", batcherBuilder);
            return this;
        }
        /**
         * Control batching method used by the producer.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.pulsar.client.api.BatcherBuilder&lt;/code&gt;
         * type.
         * 
         * Default: DEFAULT
         * Group: producer
         * 
         * @param batcherBuilder the value to set
         * @return the dsl builder
         */
        default PulsarEndpointProducerBuilder batcherBuilder(
                String batcherBuilder) {
            doSetProperty("batcherBuilder", batcherBuilder);
            return this;
        }
        /**
         * Control whether automatic batching of messages is enabled for the
         * producer.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param batchingEnabled the value to set
         * @return the dsl builder
         */
        default PulsarEndpointProducerBuilder batchingEnabled(
                boolean batchingEnabled) {
            doSetProperty("batchingEnabled", batchingEnabled);
            return this;
        }
        /**
         * Control whether automatic batching of messages is enabled for the
         * producer.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param batchingEnabled the value to set
         * @return the dsl builder
         */
        default PulsarEndpointProducerBuilder batchingEnabled(
                String batchingEnabled) {
            doSetProperty("batchingEnabled", batchingEnabled);
            return this;
        }
        /**
         * The maximum size to batch messages.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: producer
         * 
         * @param batchingMaxMessages the value to set
         * @return the dsl builder
         */
        default PulsarEndpointProducerBuilder batchingMaxMessages(
                int batchingMaxMessages) {
            doSetProperty("batchingMaxMessages", batchingMaxMessages);
            return this;
        }
        /**
         * The maximum size to batch messages.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: producer
         * 
         * @param batchingMaxMessages the value to set
         * @return the dsl builder
         */
        default PulsarEndpointProducerBuilder batchingMaxMessages(
                String batchingMaxMessages) {
            doSetProperty("batchingMaxMessages", batchingMaxMessages);
            return this;
        }
        /**
         * The maximum time period within which the messages sent will be
         * batched if batchingEnabled is true.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: producer
         * 
         * @param batchingMaxPublishDelayMicros the value to set
         * @return the dsl builder
         */
        default PulsarEndpointProducerBuilder batchingMaxPublishDelayMicros(
                long batchingMaxPublishDelayMicros) {
            doSetProperty("batchingMaxPublishDelayMicros", batchingMaxPublishDelayMicros);
            return this;
        }
        /**
         * The maximum time period within which the messages sent will be
         * batched if batchingEnabled is true.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: producer
         * 
         * @param batchingMaxPublishDelayMicros the value to set
         * @return the dsl builder
         */
        default PulsarEndpointProducerBuilder batchingMaxPublishDelayMicros(
                String batchingMaxPublishDelayMicros) {
            doSetProperty("batchingMaxPublishDelayMicros", batchingMaxPublishDelayMicros);
            return this;
        }
        /**
         * Whether to block the producing thread if pending messages queue is
         * full or to throw a ProducerQueueIsFullError.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param blockIfQueueFull the value to set
         * @return the dsl builder
         */
        default PulsarEndpointProducerBuilder blockIfQueueFull(
                boolean blockIfQueueFull) {
            doSetProperty("blockIfQueueFull", blockIfQueueFull);
            return this;
        }
        /**
         * Whether to block the producing thread if pending messages queue is
         * full or to throw a ProducerQueueIsFullError.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param blockIfQueueFull the value to set
         * @return the dsl builder
         */
        default PulsarEndpointProducerBuilder blockIfQueueFull(
                String blockIfQueueFull) {
            doSetProperty("blockIfQueueFull", blockIfQueueFull);
            return this;
        }
        /**
         * Compression type to use.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.pulsar.client.api.CompressionType&lt;/code&gt;
         * type.
         * 
         * Default: NONE
         * Group: producer
         * 
         * @param compressionType the value to set
         * @return the dsl builder
         */
        default PulsarEndpointProducerBuilder compressionType(
                org.apache.pulsar.client.api.CompressionType compressionType) {
            doSetProperty("compressionType", compressionType);
            return this;
        }
        /**
         * Compression type to use.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.pulsar.client.api.CompressionType&lt;/code&gt;
         * type.
         * 
         * Default: NONE
         * Group: producer
         * 
         * @param compressionType the value to set
         * @return the dsl builder
         */
        default PulsarEndpointProducerBuilder compressionType(
                String compressionType) {
            doSetProperty("compressionType", compressionType);
            return this;
        }
        /**
         * The first message published will have a sequence Id of
         * initialSequenceId 1.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: producer
         * 
         * @param initialSequenceId the value to set
         * @return the dsl builder
         */
        default PulsarEndpointProducerBuilder initialSequenceId(
                long initialSequenceId) {
            doSetProperty("initialSequenceId", initialSequenceId);
            return this;
        }
        /**
         * The first message published will have a sequence Id of
         * initialSequenceId 1.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: producer
         * 
         * @param initialSequenceId the value to set
         * @return the dsl builder
         */
        default PulsarEndpointProducerBuilder initialSequenceId(
                String initialSequenceId) {
            doSetProperty("initialSequenceId", initialSequenceId);
            return this;
        }
        /**
         * Size of the pending massages queue. When the queue is full, by
         * default, any further sends will fail unless blockIfQueueFull=true.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: producer
         * 
         * @param maxPendingMessages the value to set
         * @return the dsl builder
         */
        default PulsarEndpointProducerBuilder maxPendingMessages(
                int maxPendingMessages) {
            doSetProperty("maxPendingMessages", maxPendingMessages);
            return this;
        }
        /**
         * Size of the pending massages queue. When the queue is full, by
         * default, any further sends will fail unless blockIfQueueFull=true.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: producer
         * 
         * @param maxPendingMessages the value to set
         * @return the dsl builder
         */
        default PulsarEndpointProducerBuilder maxPendingMessages(
                String maxPendingMessages) {
            doSetProperty("maxPendingMessages", maxPendingMessages);
            return this;
        }
        /**
         * The maximum number of pending messages for partitioned topics. The
         * maxPendingMessages value will be reduced if (number of partitions
         * maxPendingMessages) exceeds this value. Partitioned topics have a
         * pending message queue for each partition.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 50000
         * Group: producer
         * 
         * @param maxPendingMessagesAcrossPartitions the value to set
         * @return the dsl builder
         */
        default PulsarEndpointProducerBuilder maxPendingMessagesAcrossPartitions(
                int maxPendingMessagesAcrossPartitions) {
            doSetProperty("maxPendingMessagesAcrossPartitions", maxPendingMessagesAcrossPartitions);
            return this;
        }
        /**
         * The maximum number of pending messages for partitioned topics. The
         * maxPendingMessages value will be reduced if (number of partitions
         * maxPendingMessages) exceeds this value. Partitioned topics have a
         * pending message queue for each partition.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 50000
         * Group: producer
         * 
         * @param maxPendingMessagesAcrossPartitions the value to set
         * @return the dsl builder
         */
        default PulsarEndpointProducerBuilder maxPendingMessagesAcrossPartitions(
                String maxPendingMessagesAcrossPartitions) {
            doSetProperty("maxPendingMessagesAcrossPartitions", maxPendingMessagesAcrossPartitions);
            return this;
        }
        /**
         * Custom Message Router to use.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.pulsar.client.api.MessageRouter&lt;/code&gt;
         * type.
         * 
         * Group: producer
         * 
         * @param messageRouter the value to set
         * @return the dsl builder
         */
        default PulsarEndpointProducerBuilder messageRouter(
                org.apache.pulsar.client.api.MessageRouter messageRouter) {
            doSetProperty("messageRouter", messageRouter);
            return this;
        }
        /**
         * Custom Message Router to use.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.pulsar.client.api.MessageRouter&lt;/code&gt;
         * type.
         * 
         * Group: producer
         * 
         * @param messageRouter the value to set
         * @return the dsl builder
         */
        default PulsarEndpointProducerBuilder messageRouter(String messageRouter) {
            doSetProperty("messageRouter", messageRouter);
            return this;
        }
        /**
         * Message Routing Mode to use.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.pulsar.client.api.MessageRoutingMode&lt;/code&gt; type.
         * 
         * Default: RoundRobinPartition
         * Group: producer
         * 
         * @param messageRoutingMode the value to set
         * @return the dsl builder
         */
        default PulsarEndpointProducerBuilder messageRoutingMode(
                org.apache.pulsar.client.api.MessageRoutingMode messageRoutingMode) {
            doSetProperty("messageRoutingMode", messageRoutingMode);
            return this;
        }
        /**
         * Message Routing Mode to use.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.pulsar.client.api.MessageRoutingMode&lt;/code&gt; type.
         * 
         * Default: RoundRobinPartition
         * Group: producer
         * 
         * @param messageRoutingMode the value to set
         * @return the dsl builder
         */
        default PulsarEndpointProducerBuilder messageRoutingMode(
                String messageRoutingMode) {
            doSetProperty("messageRoutingMode", messageRoutingMode);
            return this;
        }
        /**
         * Name of the producer. If unset, lets Pulsar select a unique
         * identifier.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param producerName the value to set
         * @return the dsl builder
         */
        default PulsarEndpointProducerBuilder producerName(String producerName) {
            doSetProperty("producerName", producerName);
            return this;
        }
        /**
         * Send timeout in milliseconds.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: producer
         * 
         * @param sendTimeoutMs the value to set
         * @return the dsl builder
         */
        default PulsarEndpointProducerBuilder sendTimeoutMs(int sendTimeoutMs) {
            doSetProperty("sendTimeoutMs", sendTimeoutMs);
            return this;
        }
        /**
         * Send timeout in milliseconds.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: producer
         * 
         * @param sendTimeoutMs the value to set
         * @return the dsl builder
         */
        default PulsarEndpointProducerBuilder sendTimeoutMs(String sendTimeoutMs) {
            doSetProperty("sendTimeoutMs", sendTimeoutMs);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Pulsar component.
     */
    public interface AdvancedPulsarEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default PulsarEndpointProducerBuilder basic() {
            return (PulsarEndpointProducerBuilder) this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedPulsarEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedPulsarEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Pulsar component.
     */
    public interface PulsarEndpointBuilder
            extends
                PulsarEndpointConsumerBuilder,
                PulsarEndpointProducerBuilder {
        default AdvancedPulsarEndpointBuilder advanced() {
            return (AdvancedPulsarEndpointBuilder) this;
        }
        /**
         * The Authentication FQCN to be used while creating the client from
         * URI.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param authenticationClass the value to set
         * @return the dsl builder
         */
        default PulsarEndpointBuilder authenticationClass(
                String authenticationClass) {
            doSetProperty("authenticationClass", authenticationClass);
            return this;
        }
        /**
         * The Authentication Parameters to be used while creating the client
         * from URI.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param authenticationParams the value to set
         * @return the dsl builder
         */
        default PulsarEndpointBuilder authenticationParams(
                String authenticationParams) {
            doSetProperty("authenticationParams", authenticationParams);
            return this;
        }
        /**
         * The Pulsar Service URL to point while creating the client from URI.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param serviceUrl the value to set
         * @return the dsl builder
         */
        default PulsarEndpointBuilder serviceUrl(String serviceUrl) {
            doSetProperty("serviceUrl", serviceUrl);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Pulsar component.
     */
    public interface AdvancedPulsarEndpointBuilder
            extends
                AdvancedPulsarEndpointConsumerBuilder,
                AdvancedPulsarEndpointProducerBuilder {
        default PulsarEndpointBuilder basic() {
            return (PulsarEndpointBuilder) this;
        }
    }

    public interface PulsarBuilders {
        /**
         * Pulsar (camel-pulsar)
         * Send and receive messages from/to Apache Pulsar messaging system.
         * 
         * Category: messaging
         * Since: 2.24
         * Maven coordinates: org.apache.camel:camel-pulsar
         * 
         * @return the dsl builder for the headers' name.
         */
        default PulsarHeaderNameBuilder pulsar() {
            return PulsarHeaderNameBuilder.INSTANCE;
        }
        /**
         * Pulsar (camel-pulsar)
         * Send and receive messages from/to Apache Pulsar messaging system.
         * 
         * Category: messaging
         * Since: 2.24
         * Maven coordinates: org.apache.camel:camel-pulsar
         * 
         * Syntax: <code>pulsar:persistence://tenant/namespace/topic</code>
         * 
         * Path parameter: persistence (required)
         * Whether the topic is persistent or non-persistent
         * There are 2 enums and the value can be one of: persistent,
         * non-persistent
         * 
         * Path parameter: tenant (required)
         * The tenant
         * 
         * Path parameter: namespace (required)
         * The namespace
         * 
         * Path parameter: topic (required)
         * The topic
         * 
         * @param path persistence://tenant/namespace/topic
         * @return the dsl builder
         */
        default PulsarEndpointBuilder pulsar(String path) {
            return PulsarEndpointBuilderFactory.endpointBuilder("pulsar", path);
        }
        /**
         * Pulsar (camel-pulsar)
         * Send and receive messages from/to Apache Pulsar messaging system.
         * 
         * Category: messaging
         * Since: 2.24
         * Maven coordinates: org.apache.camel:camel-pulsar
         * 
         * Syntax: <code>pulsar:persistence://tenant/namespace/topic</code>
         * 
         * Path parameter: persistence (required)
         * Whether the topic is persistent or non-persistent
         * There are 2 enums and the value can be one of: persistent,
         * non-persistent
         * 
         * Path parameter: tenant (required)
         * The tenant
         * 
         * Path parameter: namespace (required)
         * The namespace
         * 
         * Path parameter: topic (required)
         * The topic
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path persistence://tenant/namespace/topic
         * @return the dsl builder
         */
        default PulsarEndpointBuilder pulsar(String componentName, String path) {
            return PulsarEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    /**
     * The builder of headers' name for the Pulsar component.
     */
    public static class PulsarHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final PulsarHeaderNameBuilder INSTANCE = new PulsarHeaderNameBuilder();

        /**
         * The properties attached to the message.
         * 
         * The option is a: {@code Map<String, String>} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code properties}.
         */
        public String properties() {
            return "properties";
        }

        /**
         * The producer name who produced the message.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code producer_name}.
         */
        public String producerName() {
            return "producer_name";
        }

        /**
         * The sequence id associated with the message.
         * 
         * The option is a: {@code long} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code sequence_id}.
         */
        public String sequenceId() {
            return "sequence_id";
        }

        /**
         * The publish time of the message.
         * 
         * The option is a: {@code long} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code publish_time}.
         */
        public String publishTime() {
            return "publish_time";
        }

        /**
         * The unique message ID associated with the message.
         * 
         * The option is a: {@code org.apache.pulsar.client.api.MessageId} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code message_id}.
         */
        public String messageId() {
            return "message_id";
        }

        /**
         * The event time associated with the message.
         * 
         * The option is a: {@code long} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code event_time}.
         */
        public String eventTime() {
            return "event_time";
        }

        /**
         * The key of the message.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code key}.
         */
        public String key() {
            return "key";
        }

        /**
         * The bytes in key.
         * 
         * The option is a: {@code byte[]} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code key_bytes}.
         */
        public String keyBytes() {
            return "key_bytes";
        }

        /**
         * The topic the message was published to.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code topic_name}.
         */
        public String topicName() {
            return "topic_name";
        }

        /**
         * The message receipt.
         * 
         * The option is a: {@code
         * org.apache.camel.component.pulsar.PulsarMessageReceipt} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code message_receipt}.
         */
        public String messageReceipt() {
            return "message_receipt";
        }

        /**
         * The key of the message for routing policy.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code PulsarProducerMessageKey}.
         */
        public String pulsarProducerMessageKey() {
            return "PulsarProducerMessageKey";
        }

        /**
         * The properties of the message to add.
         * 
         * The option is a: {@code Map<String, String>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * PulsarProducerMessageProperties}.
         */
        public String pulsarProducerMessageProperties() {
            return "PulsarProducerMessageProperties";
        }

        /**
         * The event time of the message message.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * PulsarProducerMessageEventTime}.
         */
        public String pulsarProducerMessageEventTime() {
            return "PulsarProducerMessageEventTime";
        }

        /**
         * The message redelivery count, redelivery count maintain in pulsar
         * broker.
         * 
         * The option is a: {@code int} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code PulsarRedeliveryCount}.
         */
        public String pulsarRedeliveryCount() {
            return "PulsarRedeliveryCount";
        }
    }
    static PulsarEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class PulsarEndpointBuilderImpl extends AbstractEndpointBuilder implements PulsarEndpointBuilder, AdvancedPulsarEndpointBuilder {
            public PulsarEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new PulsarEndpointBuilderImpl(path);
    }
}