/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Send and receive events to/from Azure Event Hubs using AMQP protocol.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface EventHubsEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Azure Event Hubs component.
     */
    public interface EventHubsEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedEventHubsEndpointConsumerBuilder advanced() {
            return (AdvancedEventHubsEndpointConsumerBuilder) this;
        }
        /**
         * Sets the retry policy for EventHubAsyncClient. If not specified, the
         * default retry options are used.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.core.amqp.AmqpRetryOptions&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param amqpRetryOptions the value to set
         * @return the dsl builder
         */
        default EventHubsEndpointConsumerBuilder amqpRetryOptions(
                com.azure.core.amqp.AmqpRetryOptions amqpRetryOptions) {
            doSetProperty("amqpRetryOptions", amqpRetryOptions);
            return this;
        }
        /**
         * Sets the retry policy for EventHubAsyncClient. If not specified, the
         * default retry options are used.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.core.amqp.AmqpRetryOptions&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param amqpRetryOptions the value to set
         * @return the dsl builder
         */
        default EventHubsEndpointConsumerBuilder amqpRetryOptions(
                String amqpRetryOptions) {
            doSetProperty("amqpRetryOptions", amqpRetryOptions);
            return this;
        }
        /**
         * Sets the transport type by which all the communication with Azure
         * Event Hubs occurs. Default value is AmqpTransportType#AMQP.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.core.amqp.AmqpTransportType&lt;/code&gt; type.
         * 
         * Default: AMQP
         * Group: common
         * 
         * @param amqpTransportType the value to set
         * @return the dsl builder
         */
        default EventHubsEndpointConsumerBuilder amqpTransportType(
                com.azure.core.amqp.AmqpTransportType amqpTransportType) {
            doSetProperty("amqpTransportType", amqpTransportType);
            return this;
        }
        /**
         * Sets the transport type by which all the communication with Azure
         * Event Hubs occurs. Default value is AmqpTransportType#AMQP.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.core.amqp.AmqpTransportType&lt;/code&gt; type.
         * 
         * Default: AMQP
         * Group: common
         * 
         * @param amqpTransportType the value to set
         * @return the dsl builder
         */
        default EventHubsEndpointConsumerBuilder amqpTransportType(
                String amqpTransportType) {
            doSetProperty("amqpTransportType", amqpTransportType);
            return this;
        }
        /**
         * In case you chose the default BlobCheckpointStore, this sets access
         * key for the associated azure account name to be used for
         * authentication with azure blob services.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param blobAccessKey the value to set
         * @return the dsl builder
         */
        default EventHubsEndpointConsumerBuilder blobAccessKey(
                String blobAccessKey) {
            doSetProperty("blobAccessKey", blobAccessKey);
            return this;
        }
        /**
         * In case you chose the default BlobCheckpointStore, this sets Azure
         * account name to be used for authentication with azure blob services.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param blobAccountName the value to set
         * @return the dsl builder
         */
        default EventHubsEndpointConsumerBuilder blobAccountName(
                String blobAccountName) {
            doSetProperty("blobAccountName", blobAccountName);
            return this;
        }
        /**
         * In case you chose the default BlobCheckpointStore, this sets the blob
         * container that shall be used by the BlobCheckpointStore to store the
         * checkpoint offsets.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param blobContainerName the value to set
         * @return the dsl builder
         */
        default EventHubsEndpointConsumerBuilder blobContainerName(
                String blobContainerName) {
            doSetProperty("blobContainerName", blobContainerName);
            return this;
        }
        /**
         * In case you chose the default BlobCheckpointStore,
         * StorageSharedKeyCredential can be injected to create the azure
         * client, this holds the important authentication information.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.storage.common.StorageSharedKeyCredential&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param blobStorageSharedKeyCredential the value to set
         * @return the dsl builder
         */
        default EventHubsEndpointConsumerBuilder blobStorageSharedKeyCredential(
                com.azure.storage.common.StorageSharedKeyCredential blobStorageSharedKeyCredential) {
            doSetProperty("blobStorageSharedKeyCredential", blobStorageSharedKeyCredential);
            return this;
        }
        /**
         * In case you chose the default BlobCheckpointStore,
         * StorageSharedKeyCredential can be injected to create the azure
         * client, this holds the important authentication information.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.storage.common.StorageSharedKeyCredential&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param blobStorageSharedKeyCredential the value to set
         * @return the dsl builder
         */
        default EventHubsEndpointConsumerBuilder blobStorageSharedKeyCredential(
                String blobStorageSharedKeyCredential) {
            doSetProperty("blobStorageSharedKeyCredential", blobStorageSharedKeyCredential);
            return this;
        }
        /**
         * Sets the CheckpointStore the EventProcessorClient will use for
         * storing partition ownership and checkpoint information. Users can,
         * optionally, provide their own implementation of CheckpointStore which
         * will store ownership and checkpoint information. By default it set to
         * use
         * com.azure.messaging.eventhubs.checkpointstore.blob.BlobCheckpointStore which stores all checkpoint offsets into Azure Blob Storage.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.messaging.eventhubs.CheckpointStore&lt;/code&gt; type.
         * 
         * Default: BlobCheckpointStore
         * Group: consumer
         * 
         * @param checkpointStore the value to set
         * @return the dsl builder
         */
        default EventHubsEndpointConsumerBuilder checkpointStore(
                com.azure.messaging.eventhubs.CheckpointStore checkpointStore) {
            doSetProperty("checkpointStore", checkpointStore);
            return this;
        }
        /**
         * Sets the CheckpointStore the EventProcessorClient will use for
         * storing partition ownership and checkpoint information. Users can,
         * optionally, provide their own implementation of CheckpointStore which
         * will store ownership and checkpoint information. By default it set to
         * use
         * com.azure.messaging.eventhubs.checkpointstore.blob.BlobCheckpointStore which stores all checkpoint offsets into Azure Blob Storage.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.messaging.eventhubs.CheckpointStore&lt;/code&gt; type.
         * 
         * Default: BlobCheckpointStore
         * Group: consumer
         * 
         * @param checkpointStore the value to set
         * @return the dsl builder
         */
        default EventHubsEndpointConsumerBuilder checkpointStore(
                String checkpointStore) {
            doSetProperty("checkpointStore", checkpointStore);
            return this;
        }
        /**
         * Sets the name of the consumer group this consumer is associated with.
         * Events are read in the context of this group. The name of the
         * consumer group that is created by default is {code $Default}.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: $Default
         * Group: consumer
         * 
         * @param consumerGroupName the value to set
         * @return the dsl builder
         */
        default EventHubsEndpointConsumerBuilder consumerGroupName(
                String consumerGroupName) {
            doSetProperty("consumerGroupName", consumerGroupName);
            return this;
        }
        /**
         * Sets the map containing the event position to use for each partition
         * if a checkpoint for the partition does not exist in CheckpointStore.
         * This map is keyed off of the partition id. If there is no checkpoint
         * in CheckpointStore and there is no entry in this map, the processing
         * of the partition will start from {link EventPosition#latest() latest}
         * position.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * com.azure.messaging.eventhubs.models.EventPosition&amp;gt;&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param eventPosition the value to set
         * @return the dsl builder
         */
        default EventHubsEndpointConsumerBuilder eventPosition(
                Map<java.lang.String, com.azure.messaging.eventhubs.models.EventPosition> eventPosition) {
            doSetProperty("eventPosition", eventPosition);
            return this;
        }
        /**
         * Sets the map containing the event position to use for each partition
         * if a checkpoint for the partition does not exist in CheckpointStore.
         * This map is keyed off of the partition id. If there is no checkpoint
         * in CheckpointStore and there is no entry in this map, the processing
         * of the partition will start from {link EventPosition#latest() latest}
         * position.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * com.azure.messaging.eventhubs.models.EventPosition&amp;gt;&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param eventPosition the value to set
         * @return the dsl builder
         */
        default EventHubsEndpointConsumerBuilder eventPosition(
                String eventPosition) {
            doSetProperty("eventPosition", eventPosition);
            return this;
        }
        /**
         * Sets the count used by the receiver to control the number of events
         * the Event Hub consumer will actively receive and queue locally
         * without regard to whether a receive operation is currently active.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: consumer
         * 
         * @param prefetchCount the value to set
         * @return the dsl builder
         */
        default EventHubsEndpointConsumerBuilder prefetchCount(int prefetchCount) {
            doSetProperty("prefetchCount", prefetchCount);
            return this;
        }
        /**
         * Sets the count used by the receiver to control the number of events
         * the Event Hub consumer will actively receive and queue locally
         * without regard to whether a receive operation is currently active.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: consumer
         * 
         * @param prefetchCount the value to set
         * @return the dsl builder
         */
        default EventHubsEndpointConsumerBuilder prefetchCount(
                String prefetchCount) {
            doSetProperty("prefetchCount", prefetchCount);
            return this;
        }
        /**
         * Instead of supplying namespace, sharedAccessKey, sharedAccessName ...
         * etc, you can just supply the connection string for your eventHub. The
         * connection string for EventHubs already include all the necessary
         * information to connection to your EventHub. To learn on how to
         * generate the connection string, take a look at this documentation:
         * https://docs.microsoft.com/en-us/azure/event-hubs/event-hubs-get-connection-string.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param connectionString the value to set
         * @return the dsl builder
         */
        default EventHubsEndpointConsumerBuilder connectionString(
                String connectionString) {
            doSetProperty("connectionString", connectionString);
            return this;
        }
        /**
         * The generated value for the SharedAccessName.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sharedAccessKey the value to set
         * @return the dsl builder
         */
        default EventHubsEndpointConsumerBuilder sharedAccessKey(
                String sharedAccessKey) {
            doSetProperty("sharedAccessKey", sharedAccessKey);
            return this;
        }
        /**
         * The name you chose for your EventHubs SAS keys.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sharedAccessName the value to set
         * @return the dsl builder
         */
        default EventHubsEndpointConsumerBuilder sharedAccessName(
                String sharedAccessName) {
            doSetProperty("sharedAccessName", sharedAccessName);
            return this;
        }
        /**
         * Still another way of authentication (beside supplying namespace,
         * sharedAccessKey, sharedAccessName or connection string) is through
         * Azure-AD authentication using an implementation instance of
         * TokenCredential.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.core.credential.TokenCredential&lt;/code&gt;
         * type.
         * 
         * Group: security
         * 
         * @param tokenCredential the value to set
         * @return the dsl builder
         */
        default EventHubsEndpointConsumerBuilder tokenCredential(
                com.azure.core.credential.TokenCredential tokenCredential) {
            doSetProperty("tokenCredential", tokenCredential);
            return this;
        }
        /**
         * Still another way of authentication (beside supplying namespace,
         * sharedAccessKey, sharedAccessName or connection string) is through
         * Azure-AD authentication using an implementation instance of
         * TokenCredential.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.core.credential.TokenCredential&lt;/code&gt;
         * type.
         * 
         * Group: security
         * 
         * @param tokenCredential the value to set
         * @return the dsl builder
         */
        default EventHubsEndpointConsumerBuilder tokenCredential(
                String tokenCredential) {
            doSetProperty("tokenCredential", tokenCredential);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Azure Event Hubs
     * component.
     */
    public interface AdvancedEventHubsEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default EventHubsEndpointConsumerBuilder basic() {
            return (EventHubsEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedEventHubsEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedEventHubsEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedEventHubsEndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedEventHubsEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedEventHubsEndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedEventHubsEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Azure Event Hubs component.
     */
    public interface EventHubsEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedEventHubsEndpointProducerBuilder advanced() {
            return (AdvancedEventHubsEndpointProducerBuilder) this;
        }
        /**
         * Sets the retry policy for EventHubAsyncClient. If not specified, the
         * default retry options are used.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.core.amqp.AmqpRetryOptions&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param amqpRetryOptions the value to set
         * @return the dsl builder
         */
        default EventHubsEndpointProducerBuilder amqpRetryOptions(
                com.azure.core.amqp.AmqpRetryOptions amqpRetryOptions) {
            doSetProperty("amqpRetryOptions", amqpRetryOptions);
            return this;
        }
        /**
         * Sets the retry policy for EventHubAsyncClient. If not specified, the
         * default retry options are used.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.core.amqp.AmqpRetryOptions&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param amqpRetryOptions the value to set
         * @return the dsl builder
         */
        default EventHubsEndpointProducerBuilder amqpRetryOptions(
                String amqpRetryOptions) {
            doSetProperty("amqpRetryOptions", amqpRetryOptions);
            return this;
        }
        /**
         * Sets the transport type by which all the communication with Azure
         * Event Hubs occurs. Default value is AmqpTransportType#AMQP.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.core.amqp.AmqpTransportType&lt;/code&gt; type.
         * 
         * Default: AMQP
         * Group: common
         * 
         * @param amqpTransportType the value to set
         * @return the dsl builder
         */
        default EventHubsEndpointProducerBuilder amqpTransportType(
                com.azure.core.amqp.AmqpTransportType amqpTransportType) {
            doSetProperty("amqpTransportType", amqpTransportType);
            return this;
        }
        /**
         * Sets the transport type by which all the communication with Azure
         * Event Hubs occurs. Default value is AmqpTransportType#AMQP.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.core.amqp.AmqpTransportType&lt;/code&gt; type.
         * 
         * Default: AMQP
         * Group: common
         * 
         * @param amqpTransportType the value to set
         * @return the dsl builder
         */
        default EventHubsEndpointProducerBuilder amqpTransportType(
                String amqpTransportType) {
            doSetProperty("amqpTransportType", amqpTransportType);
            return this;
        }
        /**
         * Sets the identifier of the Event Hub partition that the events will
         * be sent to. If the identifier is not specified, the Event Hubs
         * service will be responsible for routing events that are sent to an
         * available partition.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param partitionId the value to set
         * @return the dsl builder
         */
        default EventHubsEndpointProducerBuilder partitionId(String partitionId) {
            doSetProperty("partitionId", partitionId);
            return this;
        }
        /**
         * Sets a hashing key to be provided for the batch of events, which
         * instructs the Event Hubs service to map this key to a specific
         * partition. The selection of a partition is stable for a given
         * partition hashing key. Should any other batches of events be sent
         * using the same exact partition hashing key, the Event Hubs service
         * will route them all to the same partition. This should be specified
         * only when there is a need to group events by partition, but there is
         * flexibility into which partition they are routed. If ensuring that a
         * batch of events is sent only to a specific partition, it is
         * recommended that the {link #setPartitionId(String) identifier of the
         * position be specified directly} when sending the batch.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param partitionKey the value to set
         * @return the dsl builder
         */
        default EventHubsEndpointProducerBuilder partitionKey(
                String partitionKey) {
            doSetProperty("partitionKey", partitionKey);
            return this;
        }
        /**
         * Sets the EventHubProducerAsyncClient.An asynchronous producer
         * responsible for transmitting EventData to a specific Event Hub,
         * grouped together in batches. Depending on the options specified when
         * creating an {linkEventDataBatch}, the events may be automatically
         * routed to an available partition or specific to a partition. Use by
         * this component to produce the data in camel producer.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.messaging.eventhubs.EventHubProducerAsyncClient&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param producerAsyncClient the value to set
         * @return the dsl builder
         */
        default EventHubsEndpointProducerBuilder producerAsyncClient(
                com.azure.messaging.eventhubs.EventHubProducerAsyncClient producerAsyncClient) {
            doSetProperty("producerAsyncClient", producerAsyncClient);
            return this;
        }
        /**
         * Sets the EventHubProducerAsyncClient.An asynchronous producer
         * responsible for transmitting EventData to a specific Event Hub,
         * grouped together in batches. Depending on the options specified when
         * creating an {linkEventDataBatch}, the events may be automatically
         * routed to an available partition or specific to a partition. Use by
         * this component to produce the data in camel producer.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.messaging.eventhubs.EventHubProducerAsyncClient&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param producerAsyncClient the value to set
         * @return the dsl builder
         */
        default EventHubsEndpointProducerBuilder producerAsyncClient(
                String producerAsyncClient) {
            doSetProperty("producerAsyncClient", producerAsyncClient);
            return this;
        }
        /**
         * Instead of supplying namespace, sharedAccessKey, sharedAccessName ...
         * etc, you can just supply the connection string for your eventHub. The
         * connection string for EventHubs already include all the necessary
         * information to connection to your EventHub. To learn on how to
         * generate the connection string, take a look at this documentation:
         * https://docs.microsoft.com/en-us/azure/event-hubs/event-hubs-get-connection-string.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param connectionString the value to set
         * @return the dsl builder
         */
        default EventHubsEndpointProducerBuilder connectionString(
                String connectionString) {
            doSetProperty("connectionString", connectionString);
            return this;
        }
        /**
         * The generated value for the SharedAccessName.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sharedAccessKey the value to set
         * @return the dsl builder
         */
        default EventHubsEndpointProducerBuilder sharedAccessKey(
                String sharedAccessKey) {
            doSetProperty("sharedAccessKey", sharedAccessKey);
            return this;
        }
        /**
         * The name you chose for your EventHubs SAS keys.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sharedAccessName the value to set
         * @return the dsl builder
         */
        default EventHubsEndpointProducerBuilder sharedAccessName(
                String sharedAccessName) {
            doSetProperty("sharedAccessName", sharedAccessName);
            return this;
        }
        /**
         * Still another way of authentication (beside supplying namespace,
         * sharedAccessKey, sharedAccessName or connection string) is through
         * Azure-AD authentication using an implementation instance of
         * TokenCredential.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.core.credential.TokenCredential&lt;/code&gt;
         * type.
         * 
         * Group: security
         * 
         * @param tokenCredential the value to set
         * @return the dsl builder
         */
        default EventHubsEndpointProducerBuilder tokenCredential(
                com.azure.core.credential.TokenCredential tokenCredential) {
            doSetProperty("tokenCredential", tokenCredential);
            return this;
        }
        /**
         * Still another way of authentication (beside supplying namespace,
         * sharedAccessKey, sharedAccessName or connection string) is through
         * Azure-AD authentication using an implementation instance of
         * TokenCredential.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.core.credential.TokenCredential&lt;/code&gt;
         * type.
         * 
         * Group: security
         * 
         * @param tokenCredential the value to set
         * @return the dsl builder
         */
        default EventHubsEndpointProducerBuilder tokenCredential(
                String tokenCredential) {
            doSetProperty("tokenCredential", tokenCredential);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Azure Event Hubs
     * component.
     */
    public interface AdvancedEventHubsEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default EventHubsEndpointProducerBuilder basic() {
            return (EventHubsEndpointProducerBuilder) this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedEventHubsEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedEventHubsEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Azure Event Hubs component.
     */
    public interface EventHubsEndpointBuilder
            extends
                EventHubsEndpointConsumerBuilder,
                EventHubsEndpointProducerBuilder {
        default AdvancedEventHubsEndpointBuilder advanced() {
            return (AdvancedEventHubsEndpointBuilder) this;
        }
        /**
         * Sets the retry policy for EventHubAsyncClient. If not specified, the
         * default retry options are used.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.core.amqp.AmqpRetryOptions&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param amqpRetryOptions the value to set
         * @return the dsl builder
         */
        default EventHubsEndpointBuilder amqpRetryOptions(
                com.azure.core.amqp.AmqpRetryOptions amqpRetryOptions) {
            doSetProperty("amqpRetryOptions", amqpRetryOptions);
            return this;
        }
        /**
         * Sets the retry policy for EventHubAsyncClient. If not specified, the
         * default retry options are used.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.core.amqp.AmqpRetryOptions&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param amqpRetryOptions the value to set
         * @return the dsl builder
         */
        default EventHubsEndpointBuilder amqpRetryOptions(
                String amqpRetryOptions) {
            doSetProperty("amqpRetryOptions", amqpRetryOptions);
            return this;
        }
        /**
         * Sets the transport type by which all the communication with Azure
         * Event Hubs occurs. Default value is AmqpTransportType#AMQP.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.core.amqp.AmqpTransportType&lt;/code&gt; type.
         * 
         * Default: AMQP
         * Group: common
         * 
         * @param amqpTransportType the value to set
         * @return the dsl builder
         */
        default EventHubsEndpointBuilder amqpTransportType(
                com.azure.core.amqp.AmqpTransportType amqpTransportType) {
            doSetProperty("amqpTransportType", amqpTransportType);
            return this;
        }
        /**
         * Sets the transport type by which all the communication with Azure
         * Event Hubs occurs. Default value is AmqpTransportType#AMQP.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.core.amqp.AmqpTransportType&lt;/code&gt; type.
         * 
         * Default: AMQP
         * Group: common
         * 
         * @param amqpTransportType the value to set
         * @return the dsl builder
         */
        default EventHubsEndpointBuilder amqpTransportType(
                String amqpTransportType) {
            doSetProperty("amqpTransportType", amqpTransportType);
            return this;
        }
        /**
         * Instead of supplying namespace, sharedAccessKey, sharedAccessName ...
         * etc, you can just supply the connection string for your eventHub. The
         * connection string for EventHubs already include all the necessary
         * information to connection to your EventHub. To learn on how to
         * generate the connection string, take a look at this documentation:
         * https://docs.microsoft.com/en-us/azure/event-hubs/event-hubs-get-connection-string.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param connectionString the value to set
         * @return the dsl builder
         */
        default EventHubsEndpointBuilder connectionString(
                String connectionString) {
            doSetProperty("connectionString", connectionString);
            return this;
        }
        /**
         * The generated value for the SharedAccessName.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sharedAccessKey the value to set
         * @return the dsl builder
         */
        default EventHubsEndpointBuilder sharedAccessKey(String sharedAccessKey) {
            doSetProperty("sharedAccessKey", sharedAccessKey);
            return this;
        }
        /**
         * The name you chose for your EventHubs SAS keys.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sharedAccessName the value to set
         * @return the dsl builder
         */
        default EventHubsEndpointBuilder sharedAccessName(
                String sharedAccessName) {
            doSetProperty("sharedAccessName", sharedAccessName);
            return this;
        }
        /**
         * Still another way of authentication (beside supplying namespace,
         * sharedAccessKey, sharedAccessName or connection string) is through
         * Azure-AD authentication using an implementation instance of
         * TokenCredential.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.core.credential.TokenCredential&lt;/code&gt;
         * type.
         * 
         * Group: security
         * 
         * @param tokenCredential the value to set
         * @return the dsl builder
         */
        default EventHubsEndpointBuilder tokenCredential(
                com.azure.core.credential.TokenCredential tokenCredential) {
            doSetProperty("tokenCredential", tokenCredential);
            return this;
        }
        /**
         * Still another way of authentication (beside supplying namespace,
         * sharedAccessKey, sharedAccessName or connection string) is through
         * Azure-AD authentication using an implementation instance of
         * TokenCredential.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.core.credential.TokenCredential&lt;/code&gt;
         * type.
         * 
         * Group: security
         * 
         * @param tokenCredential the value to set
         * @return the dsl builder
         */
        default EventHubsEndpointBuilder tokenCredential(String tokenCredential) {
            doSetProperty("tokenCredential", tokenCredential);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Azure Event Hubs component.
     */
    public interface AdvancedEventHubsEndpointBuilder
            extends
                AdvancedEventHubsEndpointConsumerBuilder,
                AdvancedEventHubsEndpointProducerBuilder {
        default EventHubsEndpointBuilder basic() {
            return (EventHubsEndpointBuilder) this;
        }
    }

    public interface EventHubsBuilders {
        /**
         * Azure Event Hubs (camel-azure-eventhubs)
         * Send and receive events to/from Azure Event Hubs using AMQP protocol.
         * 
         * Category: cloud,messaging
         * Since: 3.5
         * Maven coordinates: org.apache.camel:camel-azure-eventhubs
         * 
         * @return the dsl builder for the headers' name.
         */
        default EventHubsHeaderNameBuilder azureEventhubs() {
            return EventHubsHeaderNameBuilder.INSTANCE;
        }
        /**
         * Azure Event Hubs (camel-azure-eventhubs)
         * Send and receive events to/from Azure Event Hubs using AMQP protocol.
         * 
         * Category: cloud,messaging
         * Since: 3.5
         * Maven coordinates: org.apache.camel:camel-azure-eventhubs
         * 
         * Syntax: <code>azure-eventhubs:namespace/eventHubName</code>
         * 
         * Path parameter: namespace
         * EventHubs namespace created in Azure Portal.
         * 
         * Path parameter: eventHubName
         * EventHubs name under a specific namespace.
         * 
         * @param path namespace/eventHubName
         * @return the dsl builder
         */
        default EventHubsEndpointBuilder azureEventhubs(String path) {
            return EventHubsEndpointBuilderFactory.endpointBuilder("azure-eventhubs", path);
        }
        /**
         * Azure Event Hubs (camel-azure-eventhubs)
         * Send and receive events to/from Azure Event Hubs using AMQP protocol.
         * 
         * Category: cloud,messaging
         * Since: 3.5
         * Maven coordinates: org.apache.camel:camel-azure-eventhubs
         * 
         * Syntax: <code>azure-eventhubs:namespace/eventHubName</code>
         * 
         * Path parameter: namespace
         * EventHubs namespace created in Azure Portal.
         * 
         * Path parameter: eventHubName
         * EventHubs name under a specific namespace.
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path namespace/eventHubName
         * @return the dsl builder
         */
        default EventHubsEndpointBuilder azureEventhubs(
                String componentName,
                String path) {
            return EventHubsEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    /**
     * The builder of headers' name for the Azure Event Hubs component.
     */
    public static class EventHubsHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final EventHubsHeaderNameBuilder INSTANCE = new EventHubsHeaderNameBuilder();

        /**
         * (producer) Overrides the hashing key to be provided for the batch of
         * events, which instructs the Event Hubs service to map this key to a
         * specific partition. (consumer) It sets the partition hashing key if
         * it was set when originally publishing the event. If it exists, this
         * value was used to compute a hash to select a partition to send the
         * message to. This is only present on a received EventData.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code AzureEventHubsPartitionKey}.
         */
        public String azureEventHubsPartitionKey() {
            return "AzureEventHubsPartitionKey";
        }

        /**
         * (producer) Overrides the identifier of the Event Hub partition that
         * the events will be sent to. (consumer) It sets the partition id of
         * the Event Hub.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code AzureEventHubsPartitionId}.
         */
        public String azureEventHubsPartitionId() {
            return "AzureEventHubsPartitionId";
        }

        /**
         * It sets the offset of the event when it was received from the
         * associated Event Hub partition. This is only present on a received
         * EventData.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code AzureEventHubsOffset}.
         */
        public String azureEventHubsOffset() {
            return "AzureEventHubsOffset";
        }

        /**
         * It sets the instant, in UTC, of when the event was enqueued in the
         * Event Hub partition. This is only present on a received EventData.
         * 
         * The option is a: {@code Instant} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code AzureEventHubsEnqueuedTime}.
         */
        public String azureEventHubsEnqueuedTime() {
            return "AzureEventHubsEnqueuedTime";
        }

        /**
         * It sets the sequence number assigned to the event when it was
         * enqueued in the associated Event Hub partition. This is unique for
         * every message received in the Event Hub partition. This is only
         * present on a received EventData.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code AzureEventHubsSequenceNumber}.
         */
        public String azureEventHubsSequenceNumber() {
            return "AzureEventHubsSequenceNumber";
        }

        /**
         * The set of free-form event properties which may be used for passing
         * metadata associated with the event with the event body during Event
         * Hubs operations.
         * 
         * The option is a: {@code Map<String, Object>} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code AzureEventHubsMetadata}.
         */
        public String azureEventHubsMetadata() {
            return "AzureEventHubsMetadata";
        }

        /**
         * The timestamp of the message.
         * 
         * The option is a: {@code long} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code MessageTimestamp}.
         */
        public String messageTimestamp() {
            return "MessageTimestamp";
        }
    }
    static EventHubsEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class EventHubsEndpointBuilderImpl extends AbstractEndpointBuilder implements EventHubsEndpointBuilder, AdvancedEventHubsEndpointBuilder {
            public EventHubsEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new EventHubsEndpointBuilderImpl(path);
    }
}