/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Perform caching operations using Ehcache.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface EhcacheEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Ehcache component.
     */
    public interface EhcacheEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedEhcacheEndpointConsumerBuilder advanced() {
            return (AdvancedEhcacheEndpointConsumerBuilder) this;
        }
        /**
         * The cache manager.
         * 
         * The option is a: &lt;code&gt;org.ehcache.CacheManager&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param cacheManager the value to set
         * @return the dsl builder
         */
        default EhcacheEndpointConsumerBuilder cacheManager(
                org.ehcache.CacheManager cacheManager) {
            doSetProperty("cacheManager", cacheManager);
            return this;
        }
        /**
         * The cache manager.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.ehcache.CacheManager&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param cacheManager the value to set
         * @return the dsl builder
         */
        default EhcacheEndpointConsumerBuilder cacheManager(String cacheManager) {
            doSetProperty("cacheManager", cacheManager);
            return this;
        }
        /**
         * The cache manager configuration.
         * 
         * The option is a:
         * &lt;code&gt;org.ehcache.config.Configuration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param cacheManagerConfiguration the value to set
         * @return the dsl builder
         */
        default EhcacheEndpointConsumerBuilder cacheManagerConfiguration(
                org.ehcache.config.Configuration cacheManagerConfiguration) {
            doSetProperty("cacheManagerConfiguration", cacheManagerConfiguration);
            return this;
        }
        /**
         * The cache manager configuration.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.ehcache.config.Configuration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param cacheManagerConfiguration the value to set
         * @return the dsl builder
         */
        default EhcacheEndpointConsumerBuilder cacheManagerConfiguration(
                String cacheManagerConfiguration) {
            doSetProperty("cacheManagerConfiguration", cacheManagerConfiguration);
            return this;
        }
        /**
         * URI pointing to the Ehcache XML configuration file's location.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param configurationUri the value to set
         * @return the dsl builder
         */
        default EhcacheEndpointConsumerBuilder configurationUri(
                String configurationUri) {
            doSetProperty("configurationUri", configurationUri);
            return this;
        }
        /**
         * Configure if a cache need to be created if it does exist or can't be
         * pre-configured.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param createCacheIfNotExist the value to set
         * @return the dsl builder
         */
        default EhcacheEndpointConsumerBuilder createCacheIfNotExist(
                boolean createCacheIfNotExist) {
            doSetProperty("createCacheIfNotExist", createCacheIfNotExist);
            return this;
        }
        /**
         * Configure if a cache need to be created if it does exist or can't be
         * pre-configured.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param createCacheIfNotExist the value to set
         * @return the dsl builder
         */
        default EhcacheEndpointConsumerBuilder createCacheIfNotExist(
                String createCacheIfNotExist) {
            doSetProperty("createCacheIfNotExist", createCacheIfNotExist);
            return this;
        }
        /**
         * Set the delivery mode (synchronous, asynchronous).
         * 
         * The option is a:
         * &lt;code&gt;org.ehcache.event.EventFiring&lt;/code&gt; type.
         * 
         * Default: ASYNCHRONOUS
         * Group: consumer
         * 
         * @param eventFiring the value to set
         * @return the dsl builder
         */
        default EhcacheEndpointConsumerBuilder eventFiring(
                org.ehcache.event.EventFiring eventFiring) {
            doSetProperty("eventFiring", eventFiring);
            return this;
        }
        /**
         * Set the delivery mode (synchronous, asynchronous).
         * 
         * The option will be converted to a
         * &lt;code&gt;org.ehcache.event.EventFiring&lt;/code&gt; type.
         * 
         * Default: ASYNCHRONOUS
         * Group: consumer
         * 
         * @param eventFiring the value to set
         * @return the dsl builder
         */
        default EhcacheEndpointConsumerBuilder eventFiring(String eventFiring) {
            doSetProperty("eventFiring", eventFiring);
            return this;
        }
        /**
         * Set the delivery mode (ordered, unordered).
         * 
         * The option is a:
         * &lt;code&gt;org.ehcache.event.EventOrdering&lt;/code&gt; type.
         * 
         * Default: ORDERED
         * Group: consumer
         * 
         * @param eventOrdering the value to set
         * @return the dsl builder
         */
        default EhcacheEndpointConsumerBuilder eventOrdering(
                org.ehcache.event.EventOrdering eventOrdering) {
            doSetProperty("eventOrdering", eventOrdering);
            return this;
        }
        /**
         * Set the delivery mode (ordered, unordered).
         * 
         * The option will be converted to a
         * &lt;code&gt;org.ehcache.event.EventOrdering&lt;/code&gt; type.
         * 
         * Default: ORDERED
         * Group: consumer
         * 
         * @param eventOrdering the value to set
         * @return the dsl builder
         */
        default EhcacheEndpointConsumerBuilder eventOrdering(
                String eventOrdering) {
            doSetProperty("eventOrdering", eventOrdering);
            return this;
        }
        /**
         * Set the type of events to listen for
         * (EVICTED,EXPIRED,REMOVED,CREATED,UPDATED). You can specify multiple
         * entries separated by comma.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param eventTypes the value to set
         * @return the dsl builder
         */
        default EhcacheEndpointConsumerBuilder eventTypes(String eventTypes) {
            doSetProperty("eventTypes", eventTypes);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Ehcache component.
     */
    public interface AdvancedEhcacheEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default EhcacheEndpointConsumerBuilder basic() {
            return (EhcacheEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedEhcacheEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedEhcacheEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedEhcacheEndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedEhcacheEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedEhcacheEndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedEhcacheEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * The default cache configuration to be used to create caches.
         * 
         * The option is a:
         * &lt;code&gt;org.ehcache.config.CacheConfiguration&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default AdvancedEhcacheEndpointConsumerBuilder configuration(
                org.ehcache.config.CacheConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
        /**
         * The default cache configuration to be used to create caches.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.ehcache.config.CacheConfiguration&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default AdvancedEhcacheEndpointConsumerBuilder configuration(
                String configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
        /**
         * A map of cache configuration to be used to create caches.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * org.ehcache.config.CacheConfiguration&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param configurations the value to set
         * @return the dsl builder
         */
        default AdvancedEhcacheEndpointConsumerBuilder configurations(
                Map<java.lang.String, org.ehcache.config.CacheConfiguration> configurations) {
            doSetProperty("configurations", configurations);
            return this;
        }
        /**
         * A map of cache configuration to be used to create caches.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * org.ehcache.config.CacheConfiguration&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param configurations the value to set
         * @return the dsl builder
         */
        default AdvancedEhcacheEndpointConsumerBuilder configurations(
                String configurations) {
            doSetProperty("configurations", configurations);
            return this;
        }
        /**
         * The cache key type, default java.lang.Object.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param keyType the value to set
         * @return the dsl builder
         */
        default AdvancedEhcacheEndpointConsumerBuilder keyType(String keyType) {
            doSetProperty("keyType", keyType);
            return this;
        }
        /**
         * The cache value type, default java.lang.Object.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param valueType the value to set
         * @return the dsl builder
         */
        default AdvancedEhcacheEndpointConsumerBuilder valueType(
                String valueType) {
            doSetProperty("valueType", valueType);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Ehcache component.
     */
    public interface EhcacheEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedEhcacheEndpointProducerBuilder advanced() {
            return (AdvancedEhcacheEndpointProducerBuilder) this;
        }
        /**
         * The cache manager.
         * 
         * The option is a: &lt;code&gt;org.ehcache.CacheManager&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param cacheManager the value to set
         * @return the dsl builder
         */
        default EhcacheEndpointProducerBuilder cacheManager(
                org.ehcache.CacheManager cacheManager) {
            doSetProperty("cacheManager", cacheManager);
            return this;
        }
        /**
         * The cache manager.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.ehcache.CacheManager&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param cacheManager the value to set
         * @return the dsl builder
         */
        default EhcacheEndpointProducerBuilder cacheManager(String cacheManager) {
            doSetProperty("cacheManager", cacheManager);
            return this;
        }
        /**
         * The cache manager configuration.
         * 
         * The option is a:
         * &lt;code&gt;org.ehcache.config.Configuration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param cacheManagerConfiguration the value to set
         * @return the dsl builder
         */
        default EhcacheEndpointProducerBuilder cacheManagerConfiguration(
                org.ehcache.config.Configuration cacheManagerConfiguration) {
            doSetProperty("cacheManagerConfiguration", cacheManagerConfiguration);
            return this;
        }
        /**
         * The cache manager configuration.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.ehcache.config.Configuration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param cacheManagerConfiguration the value to set
         * @return the dsl builder
         */
        default EhcacheEndpointProducerBuilder cacheManagerConfiguration(
                String cacheManagerConfiguration) {
            doSetProperty("cacheManagerConfiguration", cacheManagerConfiguration);
            return this;
        }
        /**
         * URI pointing to the Ehcache XML configuration file's location.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param configurationUri the value to set
         * @return the dsl builder
         */
        default EhcacheEndpointProducerBuilder configurationUri(
                String configurationUri) {
            doSetProperty("configurationUri", configurationUri);
            return this;
        }
        /**
         * Configure if a cache need to be created if it does exist or can't be
         * pre-configured.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param createCacheIfNotExist the value to set
         * @return the dsl builder
         */
        default EhcacheEndpointProducerBuilder createCacheIfNotExist(
                boolean createCacheIfNotExist) {
            doSetProperty("createCacheIfNotExist", createCacheIfNotExist);
            return this;
        }
        /**
         * Configure if a cache need to be created if it does exist or can't be
         * pre-configured.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param createCacheIfNotExist the value to set
         * @return the dsl builder
         */
        default EhcacheEndpointProducerBuilder createCacheIfNotExist(
                String createCacheIfNotExist) {
            doSetProperty("createCacheIfNotExist", createCacheIfNotExist);
            return this;
        }
        /**
         * To configure the default cache action. If an action is set in the
         * message header, then the operation from the header takes precedence.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param action the value to set
         * @return the dsl builder
         */
        default EhcacheEndpointProducerBuilder action(String action) {
            doSetProperty("action", action);
            return this;
        }
        /**
         * To configure the default action key. If a key is set in the message
         * header, then the key from the header takes precedence.
         * 
         * The option is a: &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param key the value to set
         * @return the dsl builder
         */
        default EhcacheEndpointProducerBuilder key(Object key) {
            doSetProperty("key", key);
            return this;
        }
        /**
         * To configure the default action key. If a key is set in the message
         * header, then the key from the header takes precedence.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param key the value to set
         * @return the dsl builder
         */
        default EhcacheEndpointProducerBuilder key(String key) {
            doSetProperty("key", key);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Ehcache component.
     */
    public interface AdvancedEhcacheEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default EhcacheEndpointProducerBuilder basic() {
            return (EhcacheEndpointProducerBuilder) this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedEhcacheEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedEhcacheEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * The default cache configuration to be used to create caches.
         * 
         * The option is a:
         * &lt;code&gt;org.ehcache.config.CacheConfiguration&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default AdvancedEhcacheEndpointProducerBuilder configuration(
                org.ehcache.config.CacheConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
        /**
         * The default cache configuration to be used to create caches.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.ehcache.config.CacheConfiguration&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default AdvancedEhcacheEndpointProducerBuilder configuration(
                String configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
        /**
         * A map of cache configuration to be used to create caches.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * org.ehcache.config.CacheConfiguration&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param configurations the value to set
         * @return the dsl builder
         */
        default AdvancedEhcacheEndpointProducerBuilder configurations(
                Map<java.lang.String, org.ehcache.config.CacheConfiguration> configurations) {
            doSetProperty("configurations", configurations);
            return this;
        }
        /**
         * A map of cache configuration to be used to create caches.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * org.ehcache.config.CacheConfiguration&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param configurations the value to set
         * @return the dsl builder
         */
        default AdvancedEhcacheEndpointProducerBuilder configurations(
                String configurations) {
            doSetProperty("configurations", configurations);
            return this;
        }
        /**
         * The cache key type, default java.lang.Object.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param keyType the value to set
         * @return the dsl builder
         */
        default AdvancedEhcacheEndpointProducerBuilder keyType(String keyType) {
            doSetProperty("keyType", keyType);
            return this;
        }
        /**
         * The cache value type, default java.lang.Object.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param valueType the value to set
         * @return the dsl builder
         */
        default AdvancedEhcacheEndpointProducerBuilder valueType(
                String valueType) {
            doSetProperty("valueType", valueType);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Ehcache component.
     */
    public interface EhcacheEndpointBuilder
            extends
                EhcacheEndpointConsumerBuilder,
                EhcacheEndpointProducerBuilder {
        default AdvancedEhcacheEndpointBuilder advanced() {
            return (AdvancedEhcacheEndpointBuilder) this;
        }
        /**
         * The cache manager.
         * 
         * The option is a: &lt;code&gt;org.ehcache.CacheManager&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param cacheManager the value to set
         * @return the dsl builder
         */
        default EhcacheEndpointBuilder cacheManager(
                org.ehcache.CacheManager cacheManager) {
            doSetProperty("cacheManager", cacheManager);
            return this;
        }
        /**
         * The cache manager.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.ehcache.CacheManager&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param cacheManager the value to set
         * @return the dsl builder
         */
        default EhcacheEndpointBuilder cacheManager(String cacheManager) {
            doSetProperty("cacheManager", cacheManager);
            return this;
        }
        /**
         * The cache manager configuration.
         * 
         * The option is a:
         * &lt;code&gt;org.ehcache.config.Configuration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param cacheManagerConfiguration the value to set
         * @return the dsl builder
         */
        default EhcacheEndpointBuilder cacheManagerConfiguration(
                org.ehcache.config.Configuration cacheManagerConfiguration) {
            doSetProperty("cacheManagerConfiguration", cacheManagerConfiguration);
            return this;
        }
        /**
         * The cache manager configuration.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.ehcache.config.Configuration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param cacheManagerConfiguration the value to set
         * @return the dsl builder
         */
        default EhcacheEndpointBuilder cacheManagerConfiguration(
                String cacheManagerConfiguration) {
            doSetProperty("cacheManagerConfiguration", cacheManagerConfiguration);
            return this;
        }
        /**
         * URI pointing to the Ehcache XML configuration file's location.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param configurationUri the value to set
         * @return the dsl builder
         */
        default EhcacheEndpointBuilder configurationUri(String configurationUri) {
            doSetProperty("configurationUri", configurationUri);
            return this;
        }
        /**
         * Configure if a cache need to be created if it does exist or can't be
         * pre-configured.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param createCacheIfNotExist the value to set
         * @return the dsl builder
         */
        default EhcacheEndpointBuilder createCacheIfNotExist(
                boolean createCacheIfNotExist) {
            doSetProperty("createCacheIfNotExist", createCacheIfNotExist);
            return this;
        }
        /**
         * Configure if a cache need to be created if it does exist or can't be
         * pre-configured.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param createCacheIfNotExist the value to set
         * @return the dsl builder
         */
        default EhcacheEndpointBuilder createCacheIfNotExist(
                String createCacheIfNotExist) {
            doSetProperty("createCacheIfNotExist", createCacheIfNotExist);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Ehcache component.
     */
    public interface AdvancedEhcacheEndpointBuilder
            extends
                AdvancedEhcacheEndpointConsumerBuilder,
                AdvancedEhcacheEndpointProducerBuilder {
        default EhcacheEndpointBuilder basic() {
            return (EhcacheEndpointBuilder) this;
        }
        /**
         * The default cache configuration to be used to create caches.
         * 
         * The option is a:
         * &lt;code&gt;org.ehcache.config.CacheConfiguration&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default AdvancedEhcacheEndpointBuilder configuration(
                org.ehcache.config.CacheConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
        /**
         * The default cache configuration to be used to create caches.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.ehcache.config.CacheConfiguration&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default AdvancedEhcacheEndpointBuilder configuration(
                String configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
        /**
         * A map of cache configuration to be used to create caches.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * org.ehcache.config.CacheConfiguration&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param configurations the value to set
         * @return the dsl builder
         */
        default AdvancedEhcacheEndpointBuilder configurations(
                Map<java.lang.String, org.ehcache.config.CacheConfiguration> configurations) {
            doSetProperty("configurations", configurations);
            return this;
        }
        /**
         * A map of cache configuration to be used to create caches.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * org.ehcache.config.CacheConfiguration&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param configurations the value to set
         * @return the dsl builder
         */
        default AdvancedEhcacheEndpointBuilder configurations(
                String configurations) {
            doSetProperty("configurations", configurations);
            return this;
        }
        /**
         * The cache key type, default java.lang.Object.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param keyType the value to set
         * @return the dsl builder
         */
        default AdvancedEhcacheEndpointBuilder keyType(String keyType) {
            doSetProperty("keyType", keyType);
            return this;
        }
        /**
         * The cache value type, default java.lang.Object.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param valueType the value to set
         * @return the dsl builder
         */
        default AdvancedEhcacheEndpointBuilder valueType(String valueType) {
            doSetProperty("valueType", valueType);
            return this;
        }
    }

    public interface EhcacheBuilders {
        /**
         * Ehcache (camel-ehcache)
         * Perform caching operations using Ehcache.
         * 
         * Category: cache,datagrid,clustering
         * Since: 2.18
         * Maven coordinates: org.apache.camel:camel-ehcache
         * 
         * @return the dsl builder for the headers' name.
         */
        default EhcacheHeaderNameBuilder ehcache() {
            return EhcacheHeaderNameBuilder.INSTANCE;
        }
        /**
         * Ehcache (camel-ehcache)
         * Perform caching operations using Ehcache.
         * 
         * Category: cache,datagrid,clustering
         * Since: 2.18
         * Maven coordinates: org.apache.camel:camel-ehcache
         * 
         * Syntax: <code>ehcache:cacheName</code>
         * 
         * Path parameter: cacheName (required)
         * the cache name
         * 
         * @param path cacheName
         * @return the dsl builder
         */
        default EhcacheEndpointBuilder ehcache(String path) {
            return EhcacheEndpointBuilderFactory.endpointBuilder("ehcache", path);
        }
        /**
         * Ehcache (camel-ehcache)
         * Perform caching operations using Ehcache.
         * 
         * Category: cache,datagrid,clustering
         * Since: 2.18
         * Maven coordinates: org.apache.camel:camel-ehcache
         * 
         * Syntax: <code>ehcache:cacheName</code>
         * 
         * Path parameter: cacheName (required)
         * the cache name
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path cacheName
         * @return the dsl builder
         */
        default EhcacheEndpointBuilder ehcache(String componentName, String path) {
            return EhcacheEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    /**
     * The builder of headers' name for the Ehcache component.
     */
    public static class EhcacheHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final EhcacheHeaderNameBuilder INSTANCE = new EhcacheHeaderNameBuilder();

        /**
         * The operation to be performed on the cache, valid options are: CLEAR
         * PUT PUT_ALL PUT_IF_ABSENT GET GET_ALL REMOVE REMOVE_ALL REPLACE.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code EhcacheAction}.
         */
        public String ehcacheAction() {
            return "EhcacheAction";
        }

        /**
         * Set to true if the action has a result.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code EhcacheActionHasResult}.
         */
        public String ehcacheActionHasResult() {
            return "EhcacheActionHasResult";
        }

        /**
         * Set to true if the action was successful.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code EhcacheActionSucceeded}.
         */
        public String ehcacheActionSucceeded() {
            return "EhcacheActionSucceeded";
        }

        /**
         * The cache key used for an action.
         * 
         * The option is a: {@code Object} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code EhcacheKey}.
         */
        public String ehcacheKey() {
            return "EhcacheKey";
        }

        /**
         * A list of keys, used in PUT_ALL GET_ALL REMOVE_ALL.
         * 
         * The option is a: {@code Set<Object>} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code EhcacheKeys}.
         */
        public String ehcacheKeys() {
            return "EhcacheKeys";
        }

        /**
         * The value to put in the cache or the result of an operation.
         * 
         * The option is a: {@code Object} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code EhcacheValue}.
         */
        public String ehcacheValue() {
            return "EhcacheValue";
        }

        /**
         * The old value associated to a key for actions like PUT_IF_ABSENT or
         * the Object used for comparison for actions like REPLACE.
         * 
         * The option is a: {@code Object} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code EhcacheOldValue}.
         */
        public String ehcacheOldValue() {
            return "EhcacheOldValue";
        }

        /**
         * The type of event received.
         * 
         * The option is a: {@code EventType} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code EhcacheEventType}.
         */
        public String ehcacheEventType() {
            return "EhcacheEventType";
        }
    }
    static EhcacheEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class EhcacheEndpointBuilderImpl extends AbstractEndpointBuilder implements EhcacheEndpointBuilder, AdvancedEhcacheEndpointBuilder {
            public EhcacheEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new EhcacheEndpointBuilderImpl(path);
    }
}