/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.Map;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Send and receive messages from RabbitMQ instances.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface RabbitMQEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the RabbitMQ component.
     */
    public interface RabbitMQEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedRabbitMQEndpointConsumerBuilder advanced() {
            return (AdvancedRabbitMQEndpointConsumerBuilder) this;
        }
        /**
         * If this option is set, camel-rabbitmq will try to create connection
         * based on the setting of option addresses. The addresses value is a
         * string which looks like server1:12345, server2:12345.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param addresses the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder addresses(String addresses) {
            doSetProperty("addresses", addresses);
            return this;
        }
        /**
         * If it is true, the exchange will be deleted when it is no longer in
         * use.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoDelete the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder autoDelete(boolean autoDelete) {
            doSetProperty("autoDelete", autoDelete);
            return this;
        }
        /**
         * If it is true, the exchange will be deleted when it is no longer in
         * use.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoDelete the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder autoDelete(String autoDelete) {
            doSetProperty("autoDelete", autoDelete);
            return this;
        }
        /**
         * Enables connection automatic recovery (uses connection implementation
         * that performs automatic recovery when existing connection has
         * failures).
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param automaticRecoveryEnabled the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder automaticRecoveryEnabled(
                Boolean automaticRecoveryEnabled) {
            doSetProperty("automaticRecoveryEnabled", automaticRecoveryEnabled);
            return this;
        }
        /**
         * Enables connection automatic recovery (uses connection implementation
         * that performs automatic recovery when existing connection has
         * failures).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param automaticRecoveryEnabled the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder automaticRecoveryEnabled(
                String automaticRecoveryEnabled) {
            doSetProperty("automaticRecoveryEnabled", automaticRecoveryEnabled);
            return this;
        }
        /**
         * To use a custom RabbitMQ connection factory. When this option is set,
         * all connection options (connectionTimeout, requestedChannelMax...)
         * set on URI are not used.
         * 
         * The option is a:
         * &lt;code&gt;com.rabbitmq.client.ConnectionFactory&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param connectionFactory the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder connectionFactory(
                com.rabbitmq.client.ConnectionFactory connectionFactory) {
            doSetProperty("connectionFactory", connectionFactory);
            return this;
        }
        /**
         * To use a custom RabbitMQ connection factory. When this option is set,
         * all connection options (connectionTimeout, requestedChannelMax...)
         * set on URI are not used.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.rabbitmq.client.ConnectionFactory&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param connectionFactory the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder connectionFactory(
                String connectionFactory) {
            doSetProperty("connectionFactory", connectionFactory);
            return this;
        }
        /**
         * The name of the dead letter exchange.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param deadLetterExchange the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder deadLetterExchange(
                String deadLetterExchange) {
            doSetProperty("deadLetterExchange", deadLetterExchange);
            return this;
        }
        /**
         * The type of the dead letter exchange.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: direct
         * Group: common
         * 
         * @param deadLetterExchangeType the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder deadLetterExchangeType(
                String deadLetterExchangeType) {
            doSetProperty("deadLetterExchangeType", deadLetterExchangeType);
            return this;
        }
        /**
         * The name of the dead letter queue.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param deadLetterQueue the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder deadLetterQueue(
                String deadLetterQueue) {
            doSetProperty("deadLetterQueue", deadLetterQueue);
            return this;
        }
        /**
         * The routing key for the dead letter exchange.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param deadLetterRoutingKey the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder deadLetterRoutingKey(
                String deadLetterRoutingKey) {
            doSetProperty("deadLetterRoutingKey", deadLetterRoutingKey);
            return this;
        }
        /**
         * If the option is true, camel declare the exchange and queue name and
         * bind them together. If the option is false, camel won't declare the
         * exchange and queue name on the server.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param declare the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder declare(boolean declare) {
            doSetProperty("declare", declare);
            return this;
        }
        /**
         * If the option is true, camel declare the exchange and queue name and
         * bind them together. If the option is false, camel won't declare the
         * exchange and queue name on the server.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param declare the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder declare(String declare) {
            doSetProperty("declare", declare);
            return this;
        }
        /**
         * If we are declaring a durable exchange (the exchange will survive a
         * server restart).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param durable the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder durable(boolean durable) {
            doSetProperty("durable", durable);
            return this;
        }
        /**
         * If we are declaring a durable exchange (the exchange will survive a
         * server restart).
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param durable the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder durable(String durable) {
            doSetProperty("durable", durable);
            return this;
        }
        /**
         * The exchange type such as direct or topic.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: direct
         * Group: common
         * 
         * @param exchangeType the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder exchangeType(String exchangeType) {
            doSetProperty("exchangeType", exchangeType);
            return this;
        }
        /**
         * Exclusive queues may only be accessed by the current connection, and
         * are deleted when that connection closes.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param exclusive the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder exclusive(boolean exclusive) {
            doSetProperty("exclusive", exclusive);
            return this;
        }
        /**
         * Exclusive queues may only be accessed by the current connection, and
         * are deleted when that connection closes.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param exclusive the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder exclusive(String exclusive) {
            doSetProperty("exclusive", exclusive);
            return this;
        }
        /**
         * The hostname of the running rabbitmq instance or cluster.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param hostname the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder hostname(String hostname) {
            doSetProperty("hostname", hostname);
            return this;
        }
        /**
         * Passive queues depend on the queue already to be available at
         * RabbitMQ.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param passive the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder passive(boolean passive) {
            doSetProperty("passive", passive);
            return this;
        }
        /**
         * Passive queues depend on the queue already to be available at
         * RabbitMQ.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param passive the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder passive(String passive) {
            doSetProperty("passive", passive);
            return this;
        }
        /**
         * Port number for the host with the running rabbitmq instance or
         * cluster. Default value is 5672.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param portNumber the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder portNumber(int portNumber) {
            doSetProperty("portNumber", portNumber);
            return this;
        }
        /**
         * Port number for the host with the running rabbitmq instance or
         * cluster. Default value is 5672.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param portNumber the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder portNumber(String portNumber) {
            doSetProperty("portNumber", portNumber);
            return this;
        }
        /**
         * The queue to receive messages from.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param queue the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder queue(String queue) {
            doSetProperty("queue", queue);
            return this;
        }
        /**
         * The routing key to use when binding a consumer queue to the exchange.
         * For producer routing keys, you set the header rabbitmq.ROUTING_KEY.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param routingKey the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder routingKey(String routingKey) {
            doSetProperty("routingKey", routingKey);
            return this;
        }
        /**
         * If true the producer will not declare and bind a dead letter queue.
         * This can be used if you have also DLQ rabbitmq consumer and you want
         * to avoid argument clashing between Producer and Consumer. This option
         * have no effect, if DLQ configured (deadLetterExchange option is not
         * set).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param skipDlqDeclare the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder skipDlqDeclare(
                boolean skipDlqDeclare) {
            doSetProperty("skipDlqDeclare", skipDlqDeclare);
            return this;
        }
        /**
         * If true the producer will not declare and bind a dead letter queue.
         * This can be used if you have also DLQ rabbitmq consumer and you want
         * to avoid argument clashing between Producer and Consumer. This option
         * have no effect, if DLQ configured (deadLetterExchange option is not
         * set).
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param skipDlqDeclare the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder skipDlqDeclare(
                String skipDlqDeclare) {
            doSetProperty("skipDlqDeclare", skipDlqDeclare);
            return this;
        }
        /**
         * This can be used if we need to declare the queue but not the
         * exchange.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param skipExchangeDeclare the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder skipExchangeDeclare(
                boolean skipExchangeDeclare) {
            doSetProperty("skipExchangeDeclare", skipExchangeDeclare);
            return this;
        }
        /**
         * This can be used if we need to declare the queue but not the
         * exchange.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param skipExchangeDeclare the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder skipExchangeDeclare(
                String skipExchangeDeclare) {
            doSetProperty("skipExchangeDeclare", skipExchangeDeclare);
            return this;
        }
        /**
         * If true the queue will not be bound to the exchange after declaring
         * it.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param skipQueueBind the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder skipQueueBind(
                boolean skipQueueBind) {
            doSetProperty("skipQueueBind", skipQueueBind);
            return this;
        }
        /**
         * If true the queue will not be bound to the exchange after declaring
         * it.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param skipQueueBind the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder skipQueueBind(
                String skipQueueBind) {
            doSetProperty("skipQueueBind", skipQueueBind);
            return this;
        }
        /**
         * If true the producer will not declare and bind a queue. This can be
         * used for directing messages via an existing routing key.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param skipQueueDeclare the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder skipQueueDeclare(
                boolean skipQueueDeclare) {
            doSetProperty("skipQueueDeclare", skipQueueDeclare);
            return this;
        }
        /**
         * If true the producer will not declare and bind a queue. This can be
         * used for directing messages via an existing routing key.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param skipQueueDeclare the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder skipQueueDeclare(
                String skipQueueDeclare) {
            doSetProperty("skipQueueDeclare", skipQueueDeclare);
            return this;
        }
        /**
         * The vhost for the channel.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: /
         * Group: common
         * 
         * @param vhost the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder vhost(String vhost) {
            doSetProperty("vhost", vhost);
            return this;
        }
        /**
         * If messages should be auto acknowledged.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param autoAck the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder autoAck(boolean autoAck) {
            doSetProperty("autoAck", autoAck);
            return this;
        }
        /**
         * If messages should be auto acknowledged.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param autoAck the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder autoAck(String autoAck) {
            doSetProperty("autoAck", autoAck);
            return this;
        }
        /**
         * Number of concurrent consumers when consuming from broker. (eg
         * similar as to the same option for the JMS component).
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: consumer
         * 
         * @param concurrentConsumers the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder concurrentConsumers(
                int concurrentConsumers) {
            doSetProperty("concurrentConsumers", concurrentConsumers);
            return this;
        }
        /**
         * Number of concurrent consumers when consuming from broker. (eg
         * similar as to the same option for the JMS component).
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: consumer
         * 
         * @param concurrentConsumers the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder concurrentConsumers(
                String concurrentConsumers) {
            doSetProperty("concurrentConsumers", concurrentConsumers);
            return this;
        }
        /**
         * Specify a client-generated consumer tag to establish context when
         * invoking the consume operation.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param consumerTag the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder consumerTag(String consumerTag) {
            doSetProperty("consumerTag", consumerTag);
            return this;
        }
        /**
         * Request exclusive access to the queue (meaning only this consumer can
         * access the queue). This is useful when you want a long-lived shared
         * queue to be temporarily accessible by just one consumer.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param exclusiveConsumer the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder exclusiveConsumer(
                boolean exclusiveConsumer) {
            doSetProperty("exclusiveConsumer", exclusiveConsumer);
            return this;
        }
        /**
         * Request exclusive access to the queue (meaning only this consumer can
         * access the queue). This is useful when you want a long-lived shared
         * queue to be temporarily accessible by just one consumer.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param exclusiveConsumer the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder exclusiveConsumer(
                String exclusiveConsumer) {
            doSetProperty("exclusiveConsumer", exclusiveConsumer);
            return this;
        }
        /**
         * The maximum number of messages that the server will deliver, 0 if
         * unlimited. You need to specify the option of prefetchSize,
         * prefetchCount, prefetchGlobal at the same time.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param prefetchCount the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder prefetchCount(int prefetchCount) {
            doSetProperty("prefetchCount", prefetchCount);
            return this;
        }
        /**
         * The maximum number of messages that the server will deliver, 0 if
         * unlimited. You need to specify the option of prefetchSize,
         * prefetchCount, prefetchGlobal at the same time.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param prefetchCount the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder prefetchCount(
                String prefetchCount) {
            doSetProperty("prefetchCount", prefetchCount);
            return this;
        }
        /**
         * Enables the quality of service on the RabbitMQConsumer side. You need
         * to specify the option of prefetchSize, prefetchCount, prefetchGlobal
         * at the same time.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param prefetchEnabled the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder prefetchEnabled(
                boolean prefetchEnabled) {
            doSetProperty("prefetchEnabled", prefetchEnabled);
            return this;
        }
        /**
         * Enables the quality of service on the RabbitMQConsumer side. You need
         * to specify the option of prefetchSize, prefetchCount, prefetchGlobal
         * at the same time.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param prefetchEnabled the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder prefetchEnabled(
                String prefetchEnabled) {
            doSetProperty("prefetchEnabled", prefetchEnabled);
            return this;
        }
        /**
         * If the settings should be applied to the entire channel rather than
         * each consumer You need to specify the option of prefetchSize,
         * prefetchCount, prefetchGlobal at the same time.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param prefetchGlobal the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder prefetchGlobal(
                boolean prefetchGlobal) {
            doSetProperty("prefetchGlobal", prefetchGlobal);
            return this;
        }
        /**
         * If the settings should be applied to the entire channel rather than
         * each consumer You need to specify the option of prefetchSize,
         * prefetchCount, prefetchGlobal at the same time.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param prefetchGlobal the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder prefetchGlobal(
                String prefetchGlobal) {
            doSetProperty("prefetchGlobal", prefetchGlobal);
            return this;
        }
        /**
         * The maximum amount of content (measured in octets) that the server
         * will deliver, 0 if unlimited. You need to specify the option of
         * prefetchSize, prefetchCount, prefetchGlobal at the same time.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param prefetchSize the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder prefetchSize(int prefetchSize) {
            doSetProperty("prefetchSize", prefetchSize);
            return this;
        }
        /**
         * The maximum amount of content (measured in octets) that the server
         * will deliver, 0 if unlimited. You need to specify the option of
         * prefetchSize, prefetchCount, prefetchGlobal at the same time.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param prefetchSize the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder prefetchSize(String prefetchSize) {
            doSetProperty("prefetchSize", prefetchSize);
            return this;
        }
        /**
         * Decides whether an exception during declaration of exchanges or
         * queues is recoverable or not. If the option is false, camel will
         * throw an exception when starting the consumer, which will interrupt
         * application startup (e.g. in the case when the exchange / queue is
         * already declared in RabbitMQ and has incompatible configuration). If
         * set to true, the consumer will try to reconnect periodically.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param recoverFromDeclareException the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder recoverFromDeclareException(
                boolean recoverFromDeclareException) {
            doSetProperty("recoverFromDeclareException", recoverFromDeclareException);
            return this;
        }
        /**
         * Decides whether an exception during declaration of exchanges or
         * queues is recoverable or not. If the option is false, camel will
         * throw an exception when starting the consumer, which will interrupt
         * application startup (e.g. in the case when the exchange / queue is
         * already declared in RabbitMQ and has incompatible configuration). If
         * set to true, the consumer will try to reconnect periodically.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param recoverFromDeclareException the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder recoverFromDeclareException(
                String recoverFromDeclareException) {
            doSetProperty("recoverFromDeclareException", recoverFromDeclareException);
            return this;
        }
        /**
         * This is used by the consumer to control rejection of the message.
         * When the consumer is complete processing the exchange, and if the
         * exchange failed, then the consumer is going to reject the message
         * from the RabbitMQ broker. If the header CamelRabbitmqRequeue is
         * present then the value of the header will be used, otherwise this
         * endpoint value is used as fallback. If the value is false (by
         * default) then the message is discarded/dead-lettered. If the value is
         * true, then the message is re-queued.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param reQueue the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder reQueue(boolean reQueue) {
            doSetProperty("reQueue", reQueue);
            return this;
        }
        /**
         * This is used by the consumer to control rejection of the message.
         * When the consumer is complete processing the exchange, and if the
         * exchange failed, then the consumer is going to reject the message
         * from the RabbitMQ broker. If the header CamelRabbitmqRequeue is
         * present then the value of the header will be used, otherwise this
         * endpoint value is used as fallback. If the value is false (by
         * default) then the message is discarded/dead-lettered. If the value is
         * true, then the message is re-queued.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param reQueue the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder reQueue(String reQueue) {
            doSetProperty("reQueue", reQueue);
            return this;
        }
        /**
         * Password for authenticated access.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: guest
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Enables SSL on connection, accepted value are true, TLS and 'SSLv3.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslProtocol the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder sslProtocol(String sslProtocol) {
            doSetProperty("sslProtocol", sslProtocol);
            return this;
        }
        /**
         * Configure SSL trust manager, SSL should be enabled for this option to
         * be effective.
         * 
         * The option is a: &lt;code&gt;javax.net.ssl.TrustManager&lt;/code&gt;
         * type.
         * 
         * Group: security
         * 
         * @param trustManager the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder trustManager(
                javax.net.ssl.TrustManager trustManager) {
            doSetProperty("trustManager", trustManager);
            return this;
        }
        /**
         * Configure SSL trust manager, SSL should be enabled for this option to
         * be effective.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.net.ssl.TrustManager&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param trustManager the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder trustManager(String trustManager) {
            doSetProperty("trustManager", trustManager);
            return this;
        }
        /**
         * Username in case of authenticated access.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: guest
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointConsumerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the RabbitMQ component.
     */
    public interface AdvancedRabbitMQEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default RabbitMQEndpointConsumerBuilder basic() {
            return (RabbitMQEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * The consumer uses a Thread Pool Executor with a fixed number of
         * threads. This setting allows you to set that number of threads.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10
         * Group: consumer (advanced)
         * 
         * @param threadPoolSize the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointConsumerBuilder threadPoolSize(
                int threadPoolSize) {
            doSetProperty("threadPoolSize", threadPoolSize);
            return this;
        }
        /**
         * The consumer uses a Thread Pool Executor with a fixed number of
         * threads. This setting allows you to set that number of threads.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10
         * Group: consumer (advanced)
         * 
         * @param threadPoolSize the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointConsumerBuilder threadPoolSize(
                String threadPoolSize) {
            doSetProperty("threadPoolSize", threadPoolSize);
            return this;
        }
        /**
         * Whether to allow Java serialization of the message body or not. If
         * this value is true, the message body will be serialized on the
         * producer side using Java serialization, if no type converter can
         * handle the message body. On the consumer side, it will deserialize
         * the message body if this value is true and the message contains a
         * CamelSerialize header. Setting this value to true may introduce a
         * security vulnerability as it allows an attacker to attempt to
         * deserialize to a gadget object which could result in a RCE or other
         * security vulnerability.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param allowMessageBodySerialization the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointConsumerBuilder allowMessageBodySerialization(
                boolean allowMessageBodySerialization) {
            doSetProperty("allowMessageBodySerialization", allowMessageBodySerialization);
            return this;
        }
        /**
         * Whether to allow Java serialization of the message body or not. If
         * this value is true, the message body will be serialized on the
         * producer side using Java serialization, if no type converter can
         * handle the message body. On the consumer side, it will deserialize
         * the message body if this value is true and the message contains a
         * CamelSerialize header. Setting this value to true may introduce a
         * security vulnerability as it allows an attacker to attempt to
         * deserialize to a gadget object which could result in a RCE or other
         * security vulnerability.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param allowMessageBodySerialization the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointConsumerBuilder allowMessageBodySerialization(
                String allowMessageBodySerialization) {
            doSetProperty("allowMessageBodySerialization", allowMessageBodySerialization);
            return this;
        }
        /**
         * Specify arguments for configuring the different RabbitMQ concepts, a
         * different prefix is required for each: Exchange: arg.exchange. Queue:
         * arg.queue. Binding: arg.binding. DLQ: arg.dlq.queue. DLQ binding:
         * arg.dlq.binding. For example to declare a queue with message ttl
         * argument:
         * http://localhost:5672/exchange/queueargs=arg.queue.x-message-ttl=60000.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the args(String, Object)
         * method to add a value (call the method multiple times to set more
         * values).
         * 
         * Group: advanced
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointConsumerBuilder args(
                String key,
                Object value) {
            doSetMultiValueProperty("args", "arg." + key, value);
            return this;
        }
        /**
         * Specify arguments for configuring the different RabbitMQ concepts, a
         * different prefix is required for each: Exchange: arg.exchange. Queue:
         * arg.queue. Binding: arg.binding. DLQ: arg.dlq.queue. DLQ binding:
         * arg.dlq.binding. For example to declare a queue with message ttl
         * argument:
         * http://localhost:5672/exchange/queueargs=arg.queue.x-message-ttl=60000.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the args(String, Object)
         * method to add a value (call the method multiple times to set more
         * values).
         * 
         * Group: advanced
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointConsumerBuilder args(Map values) {
            doSetMultiValueProperties("args", "arg.", values);
            return this;
        }
        /**
         * Connection client properties (client info used in negotiating with
         * the server).
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param clientProperties the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointConsumerBuilder clientProperties(
                Map<java.lang.String, java.lang.Object> clientProperties) {
            doSetProperty("clientProperties", clientProperties);
            return this;
        }
        /**
         * Connection client properties (client info used in negotiating with
         * the server).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param clientProperties the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointConsumerBuilder clientProperties(
                String clientProperties) {
            doSetProperty("clientProperties", clientProperties);
            return this;
        }
        /**
         * Custom rabbitmq ExceptionHandler for ConnectionFactory.
         * 
         * The option is a:
         * &lt;code&gt;com.rabbitmq.client.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param connectionFactoryExceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointConsumerBuilder connectionFactoryExceptionHandler(
                com.rabbitmq.client.ExceptionHandler connectionFactoryExceptionHandler) {
            doSetProperty("connectionFactoryExceptionHandler", connectionFactoryExceptionHandler);
            return this;
        }
        /**
         * Custom rabbitmq ExceptionHandler for ConnectionFactory.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.rabbitmq.client.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param connectionFactoryExceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointConsumerBuilder connectionFactoryExceptionHandler(
                String connectionFactoryExceptionHandler) {
            doSetProperty("connectionFactoryExceptionHandler", connectionFactoryExceptionHandler);
            return this;
        }
        /**
         * Connection timeout.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 60000
         * Group: advanced
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointConsumerBuilder connectionTimeout(
                int connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Connection timeout.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 60000
         * Group: advanced
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointConsumerBuilder connectionTimeout(
                String connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Network recovery interval in milliseconds (interval used when
         * recovering from network failure).
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 5000
         * Group: advanced
         * 
         * @param networkRecoveryInterval the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointConsumerBuilder networkRecoveryInterval(
                Integer networkRecoveryInterval) {
            doSetProperty("networkRecoveryInterval", networkRecoveryInterval);
            return this;
        }
        /**
         * Network recovery interval in milliseconds (interval used when
         * recovering from network failure).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 5000
         * Group: advanced
         * 
         * @param networkRecoveryInterval the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointConsumerBuilder networkRecoveryInterval(
                String networkRecoveryInterval) {
            doSetProperty("networkRecoveryInterval", networkRecoveryInterval);
            return this;
        }
        /**
         * Connection requested channel max (max number of channels offered).
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 2047
         * Group: advanced
         * 
         * @param requestedChannelMax the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointConsumerBuilder requestedChannelMax(
                int requestedChannelMax) {
            doSetProperty("requestedChannelMax", requestedChannelMax);
            return this;
        }
        /**
         * Connection requested channel max (max number of channels offered).
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 2047
         * Group: advanced
         * 
         * @param requestedChannelMax the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointConsumerBuilder requestedChannelMax(
                String requestedChannelMax) {
            doSetProperty("requestedChannelMax", requestedChannelMax);
            return this;
        }
        /**
         * Connection requested frame max (max size of frame offered).
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: advanced
         * 
         * @param requestedFrameMax the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointConsumerBuilder requestedFrameMax(
                int requestedFrameMax) {
            doSetProperty("requestedFrameMax", requestedFrameMax);
            return this;
        }
        /**
         * Connection requested frame max (max size of frame offered).
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: advanced
         * 
         * @param requestedFrameMax the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointConsumerBuilder requestedFrameMax(
                String requestedFrameMax) {
            doSetProperty("requestedFrameMax", requestedFrameMax);
            return this;
        }
        /**
         * Connection requested heartbeat (heart-beat in seconds offered).
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 60
         * Group: advanced
         * 
         * @param requestedHeartbeat the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointConsumerBuilder requestedHeartbeat(
                int requestedHeartbeat) {
            doSetProperty("requestedHeartbeat", requestedHeartbeat);
            return this;
        }
        /**
         * Connection requested heartbeat (heart-beat in seconds offered).
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 60
         * Group: advanced
         * 
         * @param requestedHeartbeat the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointConsumerBuilder requestedHeartbeat(
                String requestedHeartbeat) {
            doSetProperty("requestedHeartbeat", requestedHeartbeat);
            return this;
        }
        /**
         * Set timeout for waiting for a reply when using the InOut Exchange
         * Pattern (in milliseconds).
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 20000
         * Group: advanced
         * 
         * @param requestTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointConsumerBuilder requestTimeout(
                long requestTimeout) {
            doSetProperty("requestTimeout", requestTimeout);
            return this;
        }
        /**
         * Set timeout for waiting for a reply when using the InOut Exchange
         * Pattern (in milliseconds).
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 20000
         * Group: advanced
         * 
         * @param requestTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointConsumerBuilder requestTimeout(
                String requestTimeout) {
            doSetProperty("requestTimeout", requestTimeout);
            return this;
        }
        /**
         * Set requestTimeoutCheckerInterval for inOut exchange.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: advanced
         * 
         * @param requestTimeoutCheckerInterval the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointConsumerBuilder requestTimeoutCheckerInterval(
                long requestTimeoutCheckerInterval) {
            doSetProperty("requestTimeoutCheckerInterval", requestTimeoutCheckerInterval);
            return this;
        }
        /**
         * Set requestTimeoutCheckerInterval for inOut exchange.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: advanced
         * 
         * @param requestTimeoutCheckerInterval the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointConsumerBuilder requestTimeoutCheckerInterval(
                String requestTimeoutCheckerInterval) {
            doSetProperty("requestTimeoutCheckerInterval", requestTimeoutCheckerInterval);
            return this;
        }
        /**
         * Enables connection topology recovery (should topology recovery be
         * performed).
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param topologyRecoveryEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointConsumerBuilder topologyRecoveryEnabled(
                Boolean topologyRecoveryEnabled) {
            doSetProperty("topologyRecoveryEnabled", topologyRecoveryEnabled);
            return this;
        }
        /**
         * Enables connection topology recovery (should topology recovery be
         * performed).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param topologyRecoveryEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointConsumerBuilder topologyRecoveryEnabled(
                String topologyRecoveryEnabled) {
            doSetProperty("topologyRecoveryEnabled", topologyRecoveryEnabled);
            return this;
        }
        /**
         * When true and an inOut Exchange failed on the consumer side send the
         * caused Exception back in the response.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferException the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointConsumerBuilder transferException(
                boolean transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
        /**
         * When true and an inOut Exchange failed on the consumer side send the
         * caused Exception back in the response.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferException the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointConsumerBuilder transferException(
                String transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the RabbitMQ component.
     */
    public interface RabbitMQEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedRabbitMQEndpointProducerBuilder advanced() {
            return (AdvancedRabbitMQEndpointProducerBuilder) this;
        }
        /**
         * If this option is set, camel-rabbitmq will try to create connection
         * based on the setting of option addresses. The addresses value is a
         * string which looks like server1:12345, server2:12345.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param addresses the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder addresses(String addresses) {
            doSetProperty("addresses", addresses);
            return this;
        }
        /**
         * If it is true, the exchange will be deleted when it is no longer in
         * use.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoDelete the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder autoDelete(boolean autoDelete) {
            doSetProperty("autoDelete", autoDelete);
            return this;
        }
        /**
         * If it is true, the exchange will be deleted when it is no longer in
         * use.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoDelete the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder autoDelete(String autoDelete) {
            doSetProperty("autoDelete", autoDelete);
            return this;
        }
        /**
         * Enables connection automatic recovery (uses connection implementation
         * that performs automatic recovery when existing connection has
         * failures).
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param automaticRecoveryEnabled the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder automaticRecoveryEnabled(
                Boolean automaticRecoveryEnabled) {
            doSetProperty("automaticRecoveryEnabled", automaticRecoveryEnabled);
            return this;
        }
        /**
         * Enables connection automatic recovery (uses connection implementation
         * that performs automatic recovery when existing connection has
         * failures).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param automaticRecoveryEnabled the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder automaticRecoveryEnabled(
                String automaticRecoveryEnabled) {
            doSetProperty("automaticRecoveryEnabled", automaticRecoveryEnabled);
            return this;
        }
        /**
         * To use a custom RabbitMQ connection factory. When this option is set,
         * all connection options (connectionTimeout, requestedChannelMax...)
         * set on URI are not used.
         * 
         * The option is a:
         * &lt;code&gt;com.rabbitmq.client.ConnectionFactory&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param connectionFactory the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder connectionFactory(
                com.rabbitmq.client.ConnectionFactory connectionFactory) {
            doSetProperty("connectionFactory", connectionFactory);
            return this;
        }
        /**
         * To use a custom RabbitMQ connection factory. When this option is set,
         * all connection options (connectionTimeout, requestedChannelMax...)
         * set on URI are not used.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.rabbitmq.client.ConnectionFactory&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param connectionFactory the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder connectionFactory(
                String connectionFactory) {
            doSetProperty("connectionFactory", connectionFactory);
            return this;
        }
        /**
         * The name of the dead letter exchange.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param deadLetterExchange the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder deadLetterExchange(
                String deadLetterExchange) {
            doSetProperty("deadLetterExchange", deadLetterExchange);
            return this;
        }
        /**
         * The type of the dead letter exchange.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: direct
         * Group: common
         * 
         * @param deadLetterExchangeType the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder deadLetterExchangeType(
                String deadLetterExchangeType) {
            doSetProperty("deadLetterExchangeType", deadLetterExchangeType);
            return this;
        }
        /**
         * The name of the dead letter queue.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param deadLetterQueue the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder deadLetterQueue(
                String deadLetterQueue) {
            doSetProperty("deadLetterQueue", deadLetterQueue);
            return this;
        }
        /**
         * The routing key for the dead letter exchange.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param deadLetterRoutingKey the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder deadLetterRoutingKey(
                String deadLetterRoutingKey) {
            doSetProperty("deadLetterRoutingKey", deadLetterRoutingKey);
            return this;
        }
        /**
         * If the option is true, camel declare the exchange and queue name and
         * bind them together. If the option is false, camel won't declare the
         * exchange and queue name on the server.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param declare the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder declare(boolean declare) {
            doSetProperty("declare", declare);
            return this;
        }
        /**
         * If the option is true, camel declare the exchange and queue name and
         * bind them together. If the option is false, camel won't declare the
         * exchange and queue name on the server.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param declare the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder declare(String declare) {
            doSetProperty("declare", declare);
            return this;
        }
        /**
         * If we are declaring a durable exchange (the exchange will survive a
         * server restart).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param durable the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder durable(boolean durable) {
            doSetProperty("durable", durable);
            return this;
        }
        /**
         * If we are declaring a durable exchange (the exchange will survive a
         * server restart).
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param durable the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder durable(String durable) {
            doSetProperty("durable", durable);
            return this;
        }
        /**
         * The exchange type such as direct or topic.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: direct
         * Group: common
         * 
         * @param exchangeType the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder exchangeType(String exchangeType) {
            doSetProperty("exchangeType", exchangeType);
            return this;
        }
        /**
         * Exclusive queues may only be accessed by the current connection, and
         * are deleted when that connection closes.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param exclusive the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder exclusive(boolean exclusive) {
            doSetProperty("exclusive", exclusive);
            return this;
        }
        /**
         * Exclusive queues may only be accessed by the current connection, and
         * are deleted when that connection closes.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param exclusive the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder exclusive(String exclusive) {
            doSetProperty("exclusive", exclusive);
            return this;
        }
        /**
         * The hostname of the running rabbitmq instance or cluster.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param hostname the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder hostname(String hostname) {
            doSetProperty("hostname", hostname);
            return this;
        }
        /**
         * Passive queues depend on the queue already to be available at
         * RabbitMQ.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param passive the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder passive(boolean passive) {
            doSetProperty("passive", passive);
            return this;
        }
        /**
         * Passive queues depend on the queue already to be available at
         * RabbitMQ.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param passive the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder passive(String passive) {
            doSetProperty("passive", passive);
            return this;
        }
        /**
         * Port number for the host with the running rabbitmq instance or
         * cluster. Default value is 5672.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param portNumber the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder portNumber(int portNumber) {
            doSetProperty("portNumber", portNumber);
            return this;
        }
        /**
         * Port number for the host with the running rabbitmq instance or
         * cluster. Default value is 5672.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param portNumber the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder portNumber(String portNumber) {
            doSetProperty("portNumber", portNumber);
            return this;
        }
        /**
         * The queue to receive messages from.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param queue the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder queue(String queue) {
            doSetProperty("queue", queue);
            return this;
        }
        /**
         * The routing key to use when binding a consumer queue to the exchange.
         * For producer routing keys, you set the header rabbitmq.ROUTING_KEY.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param routingKey the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder routingKey(String routingKey) {
            doSetProperty("routingKey", routingKey);
            return this;
        }
        /**
         * If true the producer will not declare and bind a dead letter queue.
         * This can be used if you have also DLQ rabbitmq consumer and you want
         * to avoid argument clashing between Producer and Consumer. This option
         * have no effect, if DLQ configured (deadLetterExchange option is not
         * set).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param skipDlqDeclare the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder skipDlqDeclare(
                boolean skipDlqDeclare) {
            doSetProperty("skipDlqDeclare", skipDlqDeclare);
            return this;
        }
        /**
         * If true the producer will not declare and bind a dead letter queue.
         * This can be used if you have also DLQ rabbitmq consumer and you want
         * to avoid argument clashing between Producer and Consumer. This option
         * have no effect, if DLQ configured (deadLetterExchange option is not
         * set).
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param skipDlqDeclare the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder skipDlqDeclare(
                String skipDlqDeclare) {
            doSetProperty("skipDlqDeclare", skipDlqDeclare);
            return this;
        }
        /**
         * This can be used if we need to declare the queue but not the
         * exchange.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param skipExchangeDeclare the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder skipExchangeDeclare(
                boolean skipExchangeDeclare) {
            doSetProperty("skipExchangeDeclare", skipExchangeDeclare);
            return this;
        }
        /**
         * This can be used if we need to declare the queue but not the
         * exchange.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param skipExchangeDeclare the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder skipExchangeDeclare(
                String skipExchangeDeclare) {
            doSetProperty("skipExchangeDeclare", skipExchangeDeclare);
            return this;
        }
        /**
         * If true the queue will not be bound to the exchange after declaring
         * it.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param skipQueueBind the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder skipQueueBind(
                boolean skipQueueBind) {
            doSetProperty("skipQueueBind", skipQueueBind);
            return this;
        }
        /**
         * If true the queue will not be bound to the exchange after declaring
         * it.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param skipQueueBind the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder skipQueueBind(
                String skipQueueBind) {
            doSetProperty("skipQueueBind", skipQueueBind);
            return this;
        }
        /**
         * If true the producer will not declare and bind a queue. This can be
         * used for directing messages via an existing routing key.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param skipQueueDeclare the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder skipQueueDeclare(
                boolean skipQueueDeclare) {
            doSetProperty("skipQueueDeclare", skipQueueDeclare);
            return this;
        }
        /**
         * If true the producer will not declare and bind a queue. This can be
         * used for directing messages via an existing routing key.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param skipQueueDeclare the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder skipQueueDeclare(
                String skipQueueDeclare) {
            doSetProperty("skipQueueDeclare", skipQueueDeclare);
            return this;
        }
        /**
         * The vhost for the channel.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: /
         * Group: common
         * 
         * @param vhost the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder vhost(String vhost) {
            doSetProperty("vhost", vhost);
            return this;
        }
        /**
         * Map of additional headers. These headers will be set only when the
         * 'allowCustomHeaders' is set to true.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param additionalHeaders the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder additionalHeaders(
                Map<java.lang.String, java.lang.Object> additionalHeaders) {
            doSetProperty("additionalHeaders", additionalHeaders);
            return this;
        }
        /**
         * Map of additional headers. These headers will be set only when the
         * 'allowCustomHeaders' is set to true.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param additionalHeaders the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder additionalHeaders(
                String additionalHeaders) {
            doSetProperty("additionalHeaders", additionalHeaders);
            return this;
        }
        /**
         * Map of additional properties. These are standard RabbitMQ properties
         * as defined in com.rabbitmq.client.AMQP.BasicProperties. The map keys
         * should be from org.apache.camel.component.rabbitmq.RabbitMQConstants.
         * Any other keys will be ignored.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param additionalProperties the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder additionalProperties(
                Map<java.lang.String, java.lang.Object> additionalProperties) {
            doSetProperty("additionalProperties", additionalProperties);
            return this;
        }
        /**
         * Map of additional properties. These are standard RabbitMQ properties
         * as defined in com.rabbitmq.client.AMQP.BasicProperties. The map keys
         * should be from org.apache.camel.component.rabbitmq.RabbitMQConstants.
         * Any other keys will be ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param additionalProperties the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder additionalProperties(
                String additionalProperties) {
            doSetProperty("additionalProperties", additionalProperties);
            return this;
        }
        /**
         * Allow pass custom values to header.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param allowCustomHeaders the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder allowCustomHeaders(
                boolean allowCustomHeaders) {
            doSetProperty("allowCustomHeaders", allowCustomHeaders);
            return this;
        }
        /**
         * Allow pass custom values to header.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param allowCustomHeaders the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder allowCustomHeaders(
                String allowCustomHeaders) {
            doSetProperty("allowCustomHeaders", allowCustomHeaders);
            return this;
        }
        /**
         * Allow pass null values to header.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param allowNullHeaders the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder allowNullHeaders(
                boolean allowNullHeaders) {
            doSetProperty("allowNullHeaders", allowNullHeaders);
            return this;
        }
        /**
         * Allow pass null values to header.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param allowNullHeaders the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder allowNullHeaders(
                String allowNullHeaders) {
            doSetProperty("allowNullHeaders", allowNullHeaders);
            return this;
        }
        /**
         * If the bridgeEndpoint is true, the producer will ignore the message
         * header of rabbitmq.EXCHANGE_NAME and rabbitmq.ROUTING_KEY.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param bridgeEndpoint the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder bridgeEndpoint(
                boolean bridgeEndpoint) {
            doSetProperty("bridgeEndpoint", bridgeEndpoint);
            return this;
        }
        /**
         * If the bridgeEndpoint is true, the producer will ignore the message
         * header of rabbitmq.EXCHANGE_NAME and rabbitmq.ROUTING_KEY.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param bridgeEndpoint the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder bridgeEndpoint(
                String bridgeEndpoint) {
            doSetProperty("bridgeEndpoint", bridgeEndpoint);
            return this;
        }
        /**
         * Get maximum number of opened channel in pool.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10
         * Group: producer
         * 
         * @param channelPoolMaxSize the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder channelPoolMaxSize(
                int channelPoolMaxSize) {
            doSetProperty("channelPoolMaxSize", channelPoolMaxSize);
            return this;
        }
        /**
         * Get maximum number of opened channel in pool.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10
         * Group: producer
         * 
         * @param channelPoolMaxSize the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder channelPoolMaxSize(
                String channelPoolMaxSize) {
            doSetProperty("channelPoolMaxSize", channelPoolMaxSize);
            return this;
        }
        /**
         * Set the maximum number of milliseconds to wait for a channel from the
         * pool.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: producer
         * 
         * @param channelPoolMaxWait the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder channelPoolMaxWait(
                long channelPoolMaxWait) {
            doSetProperty("channelPoolMaxWait", channelPoolMaxWait);
            return this;
        }
        /**
         * Set the maximum number of milliseconds to wait for a channel from the
         * pool.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: producer
         * 
         * @param channelPoolMaxWait the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder channelPoolMaxWait(
                String channelPoolMaxWait) {
            doSetProperty("channelPoolMaxWait", channelPoolMaxWait);
            return this;
        }
        /**
         * When true, an exception will be thrown when the message cannot be
         * delivered (basic.return) and the message is marked as mandatory.
         * PublisherAcknowledgement will also be activated in this case. See
         * also publisher acknowledgements - When will messages be confirmed.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param guaranteedDeliveries the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder guaranteedDeliveries(
                boolean guaranteedDeliveries) {
            doSetProperty("guaranteedDeliveries", guaranteedDeliveries);
            return this;
        }
        /**
         * When true, an exception will be thrown when the message cannot be
         * delivered (basic.return) and the message is marked as mandatory.
         * PublisherAcknowledgement will also be activated in this case. See
         * also publisher acknowledgements - When will messages be confirmed.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param guaranteedDeliveries the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder guaranteedDeliveries(
                String guaranteedDeliveries) {
            doSetProperty("guaranteedDeliveries", guaranteedDeliveries);
            return this;
        }
        /**
         * This flag tells the server how to react if the message cannot be
         * routed to a queue consumer immediately. If this flag is set, the
         * server will return an undeliverable message with a Return method. If
         * this flag is zero, the server will queue the message, but with no
         * guarantee that it will ever be consumed. If the header is present
         * rabbitmq.IMMEDIATE it will override this option.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param immediate the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder immediate(boolean immediate) {
            doSetProperty("immediate", immediate);
            return this;
        }
        /**
         * This flag tells the server how to react if the message cannot be
         * routed to a queue consumer immediately. If this flag is set, the
         * server will return an undeliverable message with a Return method. If
         * this flag is zero, the server will queue the message, but with no
         * guarantee that it will ever be consumed. If the header is present
         * rabbitmq.IMMEDIATE it will override this option.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param immediate the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder immediate(String immediate) {
            doSetProperty("immediate", immediate);
            return this;
        }
        /**
         * This flag tells the server how to react if the message cannot be
         * routed to a queue. If this flag is set, the server will return an
         * unroutable message with a Return method. If this flag is zero, the
         * server silently drops the message. If the header is present
         * rabbitmq.MANDATORY it will override this option.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param mandatory the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder mandatory(boolean mandatory) {
            doSetProperty("mandatory", mandatory);
            return this;
        }
        /**
         * This flag tells the server how to react if the message cannot be
         * routed to a queue. If this flag is set, the server will return an
         * unroutable message with a Return method. If this flag is zero, the
         * server silently drops the message. If the header is present
         * rabbitmq.MANDATORY it will override this option.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param mandatory the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder mandatory(String mandatory) {
            doSetProperty("mandatory", mandatory);
            return this;
        }
        /**
         * When true, the message will be published with publisher
         * acknowledgements turned on.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param publisherAcknowledgements the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder publisherAcknowledgements(
                boolean publisherAcknowledgements) {
            doSetProperty("publisherAcknowledgements", publisherAcknowledgements);
            return this;
        }
        /**
         * When true, the message will be published with publisher
         * acknowledgements turned on.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param publisherAcknowledgements the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder publisherAcknowledgements(
                String publisherAcknowledgements) {
            doSetProperty("publisherAcknowledgements", publisherAcknowledgements);
            return this;
        }
        /**
         * The amount of time in milliseconds to wait for a basic.ack response
         * from RabbitMQ server.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param publisherAcknowledgementsTimeout the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder publisherAcknowledgementsTimeout(
                long publisherAcknowledgementsTimeout) {
            doSetProperty("publisherAcknowledgementsTimeout", publisherAcknowledgementsTimeout);
            return this;
        }
        /**
         * The amount of time in milliseconds to wait for a basic.ack response
         * from RabbitMQ server.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param publisherAcknowledgementsTimeout the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder publisherAcknowledgementsTimeout(
                String publisherAcknowledgementsTimeout) {
            doSetProperty("publisherAcknowledgementsTimeout", publisherAcknowledgementsTimeout);
            return this;
        }
        /**
         * Password for authenticated access.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: guest
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Enables SSL on connection, accepted value are true, TLS and 'SSLv3.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslProtocol the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder sslProtocol(String sslProtocol) {
            doSetProperty("sslProtocol", sslProtocol);
            return this;
        }
        /**
         * Configure SSL trust manager, SSL should be enabled for this option to
         * be effective.
         * 
         * The option is a: &lt;code&gt;javax.net.ssl.TrustManager&lt;/code&gt;
         * type.
         * 
         * Group: security
         * 
         * @param trustManager the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder trustManager(
                javax.net.ssl.TrustManager trustManager) {
            doSetProperty("trustManager", trustManager);
            return this;
        }
        /**
         * Configure SSL trust manager, SSL should be enabled for this option to
         * be effective.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.net.ssl.TrustManager&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param trustManager the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder trustManager(String trustManager) {
            doSetProperty("trustManager", trustManager);
            return this;
        }
        /**
         * Username in case of authenticated access.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: guest
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointProducerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the RabbitMQ component.
     */
    public interface AdvancedRabbitMQEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default RabbitMQEndpointProducerBuilder basic() {
            return (RabbitMQEndpointProducerBuilder) this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether to allow Java serialization of the message body or not. If
         * this value is true, the message body will be serialized on the
         * producer side using Java serialization, if no type converter can
         * handle the message body. On the consumer side, it will deserialize
         * the message body if this value is true and the message contains a
         * CamelSerialize header. Setting this value to true may introduce a
         * security vulnerability as it allows an attacker to attempt to
         * deserialize to a gadget object which could result in a RCE or other
         * security vulnerability.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param allowMessageBodySerialization the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointProducerBuilder allowMessageBodySerialization(
                boolean allowMessageBodySerialization) {
            doSetProperty("allowMessageBodySerialization", allowMessageBodySerialization);
            return this;
        }
        /**
         * Whether to allow Java serialization of the message body or not. If
         * this value is true, the message body will be serialized on the
         * producer side using Java serialization, if no type converter can
         * handle the message body. On the consumer side, it will deserialize
         * the message body if this value is true and the message contains a
         * CamelSerialize header. Setting this value to true may introduce a
         * security vulnerability as it allows an attacker to attempt to
         * deserialize to a gadget object which could result in a RCE or other
         * security vulnerability.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param allowMessageBodySerialization the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointProducerBuilder allowMessageBodySerialization(
                String allowMessageBodySerialization) {
            doSetProperty("allowMessageBodySerialization", allowMessageBodySerialization);
            return this;
        }
        /**
         * Specify arguments for configuring the different RabbitMQ concepts, a
         * different prefix is required for each: Exchange: arg.exchange. Queue:
         * arg.queue. Binding: arg.binding. DLQ: arg.dlq.queue. DLQ binding:
         * arg.dlq.binding. For example to declare a queue with message ttl
         * argument:
         * http://localhost:5672/exchange/queueargs=arg.queue.x-message-ttl=60000.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the args(String, Object)
         * method to add a value (call the method multiple times to set more
         * values).
         * 
         * Group: advanced
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointProducerBuilder args(
                String key,
                Object value) {
            doSetMultiValueProperty("args", "arg." + key, value);
            return this;
        }
        /**
         * Specify arguments for configuring the different RabbitMQ concepts, a
         * different prefix is required for each: Exchange: arg.exchange. Queue:
         * arg.queue. Binding: arg.binding. DLQ: arg.dlq.queue. DLQ binding:
         * arg.dlq.binding. For example to declare a queue with message ttl
         * argument:
         * http://localhost:5672/exchange/queueargs=arg.queue.x-message-ttl=60000.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the args(String, Object)
         * method to add a value (call the method multiple times to set more
         * values).
         * 
         * Group: advanced
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointProducerBuilder args(Map values) {
            doSetMultiValueProperties("args", "arg.", values);
            return this;
        }
        /**
         * Connection client properties (client info used in negotiating with
         * the server).
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param clientProperties the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointProducerBuilder clientProperties(
                Map<java.lang.String, java.lang.Object> clientProperties) {
            doSetProperty("clientProperties", clientProperties);
            return this;
        }
        /**
         * Connection client properties (client info used in negotiating with
         * the server).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param clientProperties the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointProducerBuilder clientProperties(
                String clientProperties) {
            doSetProperty("clientProperties", clientProperties);
            return this;
        }
        /**
         * Custom rabbitmq ExceptionHandler for ConnectionFactory.
         * 
         * The option is a:
         * &lt;code&gt;com.rabbitmq.client.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param connectionFactoryExceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointProducerBuilder connectionFactoryExceptionHandler(
                com.rabbitmq.client.ExceptionHandler connectionFactoryExceptionHandler) {
            doSetProperty("connectionFactoryExceptionHandler", connectionFactoryExceptionHandler);
            return this;
        }
        /**
         * Custom rabbitmq ExceptionHandler for ConnectionFactory.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.rabbitmq.client.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param connectionFactoryExceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointProducerBuilder connectionFactoryExceptionHandler(
                String connectionFactoryExceptionHandler) {
            doSetProperty("connectionFactoryExceptionHandler", connectionFactoryExceptionHandler);
            return this;
        }
        /**
         * Connection timeout.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 60000
         * Group: advanced
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointProducerBuilder connectionTimeout(
                int connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Connection timeout.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 60000
         * Group: advanced
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointProducerBuilder connectionTimeout(
                String connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Network recovery interval in milliseconds (interval used when
         * recovering from network failure).
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 5000
         * Group: advanced
         * 
         * @param networkRecoveryInterval the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointProducerBuilder networkRecoveryInterval(
                Integer networkRecoveryInterval) {
            doSetProperty("networkRecoveryInterval", networkRecoveryInterval);
            return this;
        }
        /**
         * Network recovery interval in milliseconds (interval used when
         * recovering from network failure).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 5000
         * Group: advanced
         * 
         * @param networkRecoveryInterval the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointProducerBuilder networkRecoveryInterval(
                String networkRecoveryInterval) {
            doSetProperty("networkRecoveryInterval", networkRecoveryInterval);
            return this;
        }
        /**
         * Connection requested channel max (max number of channels offered).
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 2047
         * Group: advanced
         * 
         * @param requestedChannelMax the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointProducerBuilder requestedChannelMax(
                int requestedChannelMax) {
            doSetProperty("requestedChannelMax", requestedChannelMax);
            return this;
        }
        /**
         * Connection requested channel max (max number of channels offered).
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 2047
         * Group: advanced
         * 
         * @param requestedChannelMax the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointProducerBuilder requestedChannelMax(
                String requestedChannelMax) {
            doSetProperty("requestedChannelMax", requestedChannelMax);
            return this;
        }
        /**
         * Connection requested frame max (max size of frame offered).
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: advanced
         * 
         * @param requestedFrameMax the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointProducerBuilder requestedFrameMax(
                int requestedFrameMax) {
            doSetProperty("requestedFrameMax", requestedFrameMax);
            return this;
        }
        /**
         * Connection requested frame max (max size of frame offered).
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: advanced
         * 
         * @param requestedFrameMax the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointProducerBuilder requestedFrameMax(
                String requestedFrameMax) {
            doSetProperty("requestedFrameMax", requestedFrameMax);
            return this;
        }
        /**
         * Connection requested heartbeat (heart-beat in seconds offered).
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 60
         * Group: advanced
         * 
         * @param requestedHeartbeat the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointProducerBuilder requestedHeartbeat(
                int requestedHeartbeat) {
            doSetProperty("requestedHeartbeat", requestedHeartbeat);
            return this;
        }
        /**
         * Connection requested heartbeat (heart-beat in seconds offered).
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 60
         * Group: advanced
         * 
         * @param requestedHeartbeat the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointProducerBuilder requestedHeartbeat(
                String requestedHeartbeat) {
            doSetProperty("requestedHeartbeat", requestedHeartbeat);
            return this;
        }
        /**
         * Set timeout for waiting for a reply when using the InOut Exchange
         * Pattern (in milliseconds).
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 20000
         * Group: advanced
         * 
         * @param requestTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointProducerBuilder requestTimeout(
                long requestTimeout) {
            doSetProperty("requestTimeout", requestTimeout);
            return this;
        }
        /**
         * Set timeout for waiting for a reply when using the InOut Exchange
         * Pattern (in milliseconds).
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 20000
         * Group: advanced
         * 
         * @param requestTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointProducerBuilder requestTimeout(
                String requestTimeout) {
            doSetProperty("requestTimeout", requestTimeout);
            return this;
        }
        /**
         * Set requestTimeoutCheckerInterval for inOut exchange.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: advanced
         * 
         * @param requestTimeoutCheckerInterval the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointProducerBuilder requestTimeoutCheckerInterval(
                long requestTimeoutCheckerInterval) {
            doSetProperty("requestTimeoutCheckerInterval", requestTimeoutCheckerInterval);
            return this;
        }
        /**
         * Set requestTimeoutCheckerInterval for inOut exchange.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: advanced
         * 
         * @param requestTimeoutCheckerInterval the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointProducerBuilder requestTimeoutCheckerInterval(
                String requestTimeoutCheckerInterval) {
            doSetProperty("requestTimeoutCheckerInterval", requestTimeoutCheckerInterval);
            return this;
        }
        /**
         * Enables connection topology recovery (should topology recovery be
         * performed).
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param topologyRecoveryEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointProducerBuilder topologyRecoveryEnabled(
                Boolean topologyRecoveryEnabled) {
            doSetProperty("topologyRecoveryEnabled", topologyRecoveryEnabled);
            return this;
        }
        /**
         * Enables connection topology recovery (should topology recovery be
         * performed).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param topologyRecoveryEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointProducerBuilder topologyRecoveryEnabled(
                String topologyRecoveryEnabled) {
            doSetProperty("topologyRecoveryEnabled", topologyRecoveryEnabled);
            return this;
        }
        /**
         * When true and an inOut Exchange failed on the consumer side send the
         * caused Exception back in the response.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferException the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointProducerBuilder transferException(
                boolean transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
        /**
         * When true and an inOut Exchange failed on the consumer side send the
         * caused Exception back in the response.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferException the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointProducerBuilder transferException(
                String transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
    }

    /**
     * Builder for endpoint for the RabbitMQ component.
     */
    public interface RabbitMQEndpointBuilder
            extends
                RabbitMQEndpointConsumerBuilder,
                RabbitMQEndpointProducerBuilder {
        default AdvancedRabbitMQEndpointBuilder advanced() {
            return (AdvancedRabbitMQEndpointBuilder) this;
        }
        /**
         * If this option is set, camel-rabbitmq will try to create connection
         * based on the setting of option addresses. The addresses value is a
         * string which looks like server1:12345, server2:12345.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param addresses the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointBuilder addresses(String addresses) {
            doSetProperty("addresses", addresses);
            return this;
        }
        /**
         * If it is true, the exchange will be deleted when it is no longer in
         * use.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoDelete the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointBuilder autoDelete(boolean autoDelete) {
            doSetProperty("autoDelete", autoDelete);
            return this;
        }
        /**
         * If it is true, the exchange will be deleted when it is no longer in
         * use.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoDelete the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointBuilder autoDelete(String autoDelete) {
            doSetProperty("autoDelete", autoDelete);
            return this;
        }
        /**
         * Enables connection automatic recovery (uses connection implementation
         * that performs automatic recovery when existing connection has
         * failures).
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param automaticRecoveryEnabled the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointBuilder automaticRecoveryEnabled(
                Boolean automaticRecoveryEnabled) {
            doSetProperty("automaticRecoveryEnabled", automaticRecoveryEnabled);
            return this;
        }
        /**
         * Enables connection automatic recovery (uses connection implementation
         * that performs automatic recovery when existing connection has
         * failures).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param automaticRecoveryEnabled the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointBuilder automaticRecoveryEnabled(
                String automaticRecoveryEnabled) {
            doSetProperty("automaticRecoveryEnabled", automaticRecoveryEnabled);
            return this;
        }
        /**
         * To use a custom RabbitMQ connection factory. When this option is set,
         * all connection options (connectionTimeout, requestedChannelMax...)
         * set on URI are not used.
         * 
         * The option is a:
         * &lt;code&gt;com.rabbitmq.client.ConnectionFactory&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param connectionFactory the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointBuilder connectionFactory(
                com.rabbitmq.client.ConnectionFactory connectionFactory) {
            doSetProperty("connectionFactory", connectionFactory);
            return this;
        }
        /**
         * To use a custom RabbitMQ connection factory. When this option is set,
         * all connection options (connectionTimeout, requestedChannelMax...)
         * set on URI are not used.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.rabbitmq.client.ConnectionFactory&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param connectionFactory the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointBuilder connectionFactory(
                String connectionFactory) {
            doSetProperty("connectionFactory", connectionFactory);
            return this;
        }
        /**
         * The name of the dead letter exchange.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param deadLetterExchange the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointBuilder deadLetterExchange(
                String deadLetterExchange) {
            doSetProperty("deadLetterExchange", deadLetterExchange);
            return this;
        }
        /**
         * The type of the dead letter exchange.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: direct
         * Group: common
         * 
         * @param deadLetterExchangeType the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointBuilder deadLetterExchangeType(
                String deadLetterExchangeType) {
            doSetProperty("deadLetterExchangeType", deadLetterExchangeType);
            return this;
        }
        /**
         * The name of the dead letter queue.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param deadLetterQueue the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointBuilder deadLetterQueue(String deadLetterQueue) {
            doSetProperty("deadLetterQueue", deadLetterQueue);
            return this;
        }
        /**
         * The routing key for the dead letter exchange.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param deadLetterRoutingKey the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointBuilder deadLetterRoutingKey(
                String deadLetterRoutingKey) {
            doSetProperty("deadLetterRoutingKey", deadLetterRoutingKey);
            return this;
        }
        /**
         * If the option is true, camel declare the exchange and queue name and
         * bind them together. If the option is false, camel won't declare the
         * exchange and queue name on the server.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param declare the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointBuilder declare(boolean declare) {
            doSetProperty("declare", declare);
            return this;
        }
        /**
         * If the option is true, camel declare the exchange and queue name and
         * bind them together. If the option is false, camel won't declare the
         * exchange and queue name on the server.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param declare the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointBuilder declare(String declare) {
            doSetProperty("declare", declare);
            return this;
        }
        /**
         * If we are declaring a durable exchange (the exchange will survive a
         * server restart).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param durable the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointBuilder durable(boolean durable) {
            doSetProperty("durable", durable);
            return this;
        }
        /**
         * If we are declaring a durable exchange (the exchange will survive a
         * server restart).
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param durable the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointBuilder durable(String durable) {
            doSetProperty("durable", durable);
            return this;
        }
        /**
         * The exchange type such as direct or topic.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: direct
         * Group: common
         * 
         * @param exchangeType the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointBuilder exchangeType(String exchangeType) {
            doSetProperty("exchangeType", exchangeType);
            return this;
        }
        /**
         * Exclusive queues may only be accessed by the current connection, and
         * are deleted when that connection closes.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param exclusive the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointBuilder exclusive(boolean exclusive) {
            doSetProperty("exclusive", exclusive);
            return this;
        }
        /**
         * Exclusive queues may only be accessed by the current connection, and
         * are deleted when that connection closes.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param exclusive the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointBuilder exclusive(String exclusive) {
            doSetProperty("exclusive", exclusive);
            return this;
        }
        /**
         * The hostname of the running rabbitmq instance or cluster.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param hostname the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointBuilder hostname(String hostname) {
            doSetProperty("hostname", hostname);
            return this;
        }
        /**
         * Passive queues depend on the queue already to be available at
         * RabbitMQ.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param passive the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointBuilder passive(boolean passive) {
            doSetProperty("passive", passive);
            return this;
        }
        /**
         * Passive queues depend on the queue already to be available at
         * RabbitMQ.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param passive the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointBuilder passive(String passive) {
            doSetProperty("passive", passive);
            return this;
        }
        /**
         * Port number for the host with the running rabbitmq instance or
         * cluster. Default value is 5672.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param portNumber the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointBuilder portNumber(int portNumber) {
            doSetProperty("portNumber", portNumber);
            return this;
        }
        /**
         * Port number for the host with the running rabbitmq instance or
         * cluster. Default value is 5672.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param portNumber the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointBuilder portNumber(String portNumber) {
            doSetProperty("portNumber", portNumber);
            return this;
        }
        /**
         * The queue to receive messages from.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param queue the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointBuilder queue(String queue) {
            doSetProperty("queue", queue);
            return this;
        }
        /**
         * The routing key to use when binding a consumer queue to the exchange.
         * For producer routing keys, you set the header rabbitmq.ROUTING_KEY.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param routingKey the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointBuilder routingKey(String routingKey) {
            doSetProperty("routingKey", routingKey);
            return this;
        }
        /**
         * If true the producer will not declare and bind a dead letter queue.
         * This can be used if you have also DLQ rabbitmq consumer and you want
         * to avoid argument clashing between Producer and Consumer. This option
         * have no effect, if DLQ configured (deadLetterExchange option is not
         * set).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param skipDlqDeclare the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointBuilder skipDlqDeclare(boolean skipDlqDeclare) {
            doSetProperty("skipDlqDeclare", skipDlqDeclare);
            return this;
        }
        /**
         * If true the producer will not declare and bind a dead letter queue.
         * This can be used if you have also DLQ rabbitmq consumer and you want
         * to avoid argument clashing between Producer and Consumer. This option
         * have no effect, if DLQ configured (deadLetterExchange option is not
         * set).
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param skipDlqDeclare the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointBuilder skipDlqDeclare(String skipDlqDeclare) {
            doSetProperty("skipDlqDeclare", skipDlqDeclare);
            return this;
        }
        /**
         * This can be used if we need to declare the queue but not the
         * exchange.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param skipExchangeDeclare the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointBuilder skipExchangeDeclare(
                boolean skipExchangeDeclare) {
            doSetProperty("skipExchangeDeclare", skipExchangeDeclare);
            return this;
        }
        /**
         * This can be used if we need to declare the queue but not the
         * exchange.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param skipExchangeDeclare the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointBuilder skipExchangeDeclare(
                String skipExchangeDeclare) {
            doSetProperty("skipExchangeDeclare", skipExchangeDeclare);
            return this;
        }
        /**
         * If true the queue will not be bound to the exchange after declaring
         * it.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param skipQueueBind the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointBuilder skipQueueBind(boolean skipQueueBind) {
            doSetProperty("skipQueueBind", skipQueueBind);
            return this;
        }
        /**
         * If true the queue will not be bound to the exchange after declaring
         * it.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param skipQueueBind the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointBuilder skipQueueBind(String skipQueueBind) {
            doSetProperty("skipQueueBind", skipQueueBind);
            return this;
        }
        /**
         * If true the producer will not declare and bind a queue. This can be
         * used for directing messages via an existing routing key.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param skipQueueDeclare the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointBuilder skipQueueDeclare(
                boolean skipQueueDeclare) {
            doSetProperty("skipQueueDeclare", skipQueueDeclare);
            return this;
        }
        /**
         * If true the producer will not declare and bind a queue. This can be
         * used for directing messages via an existing routing key.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param skipQueueDeclare the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointBuilder skipQueueDeclare(String skipQueueDeclare) {
            doSetProperty("skipQueueDeclare", skipQueueDeclare);
            return this;
        }
        /**
         * The vhost for the channel.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: /
         * Group: common
         * 
         * @param vhost the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointBuilder vhost(String vhost) {
            doSetProperty("vhost", vhost);
            return this;
        }
        /**
         * Password for authenticated access.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: guest
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Enables SSL on connection, accepted value are true, TLS and 'SSLv3.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslProtocol the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointBuilder sslProtocol(String sslProtocol) {
            doSetProperty("sslProtocol", sslProtocol);
            return this;
        }
        /**
         * Configure SSL trust manager, SSL should be enabled for this option to
         * be effective.
         * 
         * The option is a: &lt;code&gt;javax.net.ssl.TrustManager&lt;/code&gt;
         * type.
         * 
         * Group: security
         * 
         * @param trustManager the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointBuilder trustManager(
                javax.net.ssl.TrustManager trustManager) {
            doSetProperty("trustManager", trustManager);
            return this;
        }
        /**
         * Configure SSL trust manager, SSL should be enabled for this option to
         * be effective.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.net.ssl.TrustManager&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param trustManager the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointBuilder trustManager(String trustManager) {
            doSetProperty("trustManager", trustManager);
            return this;
        }
        /**
         * Username in case of authenticated access.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: guest
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default RabbitMQEndpointBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the RabbitMQ component.
     */
    public interface AdvancedRabbitMQEndpointBuilder
            extends
                AdvancedRabbitMQEndpointConsumerBuilder,
                AdvancedRabbitMQEndpointProducerBuilder {
        default RabbitMQEndpointBuilder basic() {
            return (RabbitMQEndpointBuilder) this;
        }
        /**
         * Whether to allow Java serialization of the message body or not. If
         * this value is true, the message body will be serialized on the
         * producer side using Java serialization, if no type converter can
         * handle the message body. On the consumer side, it will deserialize
         * the message body if this value is true and the message contains a
         * CamelSerialize header. Setting this value to true may introduce a
         * security vulnerability as it allows an attacker to attempt to
         * deserialize to a gadget object which could result in a RCE or other
         * security vulnerability.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param allowMessageBodySerialization the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointBuilder allowMessageBodySerialization(
                boolean allowMessageBodySerialization) {
            doSetProperty("allowMessageBodySerialization", allowMessageBodySerialization);
            return this;
        }
        /**
         * Whether to allow Java serialization of the message body or not. If
         * this value is true, the message body will be serialized on the
         * producer side using Java serialization, if no type converter can
         * handle the message body. On the consumer side, it will deserialize
         * the message body if this value is true and the message contains a
         * CamelSerialize header. Setting this value to true may introduce a
         * security vulnerability as it allows an attacker to attempt to
         * deserialize to a gadget object which could result in a RCE or other
         * security vulnerability.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param allowMessageBodySerialization the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointBuilder allowMessageBodySerialization(
                String allowMessageBodySerialization) {
            doSetProperty("allowMessageBodySerialization", allowMessageBodySerialization);
            return this;
        }
        /**
         * Specify arguments for configuring the different RabbitMQ concepts, a
         * different prefix is required for each: Exchange: arg.exchange. Queue:
         * arg.queue. Binding: arg.binding. DLQ: arg.dlq.queue. DLQ binding:
         * arg.dlq.binding. For example to declare a queue with message ttl
         * argument:
         * http://localhost:5672/exchange/queueargs=arg.queue.x-message-ttl=60000.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the args(String, Object)
         * method to add a value (call the method multiple times to set more
         * values).
         * 
         * Group: advanced
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointBuilder args(String key, Object value) {
            doSetMultiValueProperty("args", "arg." + key, value);
            return this;
        }
        /**
         * Specify arguments for configuring the different RabbitMQ concepts, a
         * different prefix is required for each: Exchange: arg.exchange. Queue:
         * arg.queue. Binding: arg.binding. DLQ: arg.dlq.queue. DLQ binding:
         * arg.dlq.binding. For example to declare a queue with message ttl
         * argument:
         * http://localhost:5672/exchange/queueargs=arg.queue.x-message-ttl=60000.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the args(String, Object)
         * method to add a value (call the method multiple times to set more
         * values).
         * 
         * Group: advanced
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointBuilder args(Map values) {
            doSetMultiValueProperties("args", "arg.", values);
            return this;
        }
        /**
         * Connection client properties (client info used in negotiating with
         * the server).
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param clientProperties the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointBuilder clientProperties(
                Map<java.lang.String, java.lang.Object> clientProperties) {
            doSetProperty("clientProperties", clientProperties);
            return this;
        }
        /**
         * Connection client properties (client info used in negotiating with
         * the server).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param clientProperties the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointBuilder clientProperties(
                String clientProperties) {
            doSetProperty("clientProperties", clientProperties);
            return this;
        }
        /**
         * Custom rabbitmq ExceptionHandler for ConnectionFactory.
         * 
         * The option is a:
         * &lt;code&gt;com.rabbitmq.client.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param connectionFactoryExceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointBuilder connectionFactoryExceptionHandler(
                com.rabbitmq.client.ExceptionHandler connectionFactoryExceptionHandler) {
            doSetProperty("connectionFactoryExceptionHandler", connectionFactoryExceptionHandler);
            return this;
        }
        /**
         * Custom rabbitmq ExceptionHandler for ConnectionFactory.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.rabbitmq.client.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param connectionFactoryExceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointBuilder connectionFactoryExceptionHandler(
                String connectionFactoryExceptionHandler) {
            doSetProperty("connectionFactoryExceptionHandler", connectionFactoryExceptionHandler);
            return this;
        }
        /**
         * Connection timeout.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 60000
         * Group: advanced
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointBuilder connectionTimeout(
                int connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Connection timeout.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 60000
         * Group: advanced
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointBuilder connectionTimeout(
                String connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Network recovery interval in milliseconds (interval used when
         * recovering from network failure).
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 5000
         * Group: advanced
         * 
         * @param networkRecoveryInterval the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointBuilder networkRecoveryInterval(
                Integer networkRecoveryInterval) {
            doSetProperty("networkRecoveryInterval", networkRecoveryInterval);
            return this;
        }
        /**
         * Network recovery interval in milliseconds (interval used when
         * recovering from network failure).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 5000
         * Group: advanced
         * 
         * @param networkRecoveryInterval the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointBuilder networkRecoveryInterval(
                String networkRecoveryInterval) {
            doSetProperty("networkRecoveryInterval", networkRecoveryInterval);
            return this;
        }
        /**
         * Connection requested channel max (max number of channels offered).
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 2047
         * Group: advanced
         * 
         * @param requestedChannelMax the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointBuilder requestedChannelMax(
                int requestedChannelMax) {
            doSetProperty("requestedChannelMax", requestedChannelMax);
            return this;
        }
        /**
         * Connection requested channel max (max number of channels offered).
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 2047
         * Group: advanced
         * 
         * @param requestedChannelMax the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointBuilder requestedChannelMax(
                String requestedChannelMax) {
            doSetProperty("requestedChannelMax", requestedChannelMax);
            return this;
        }
        /**
         * Connection requested frame max (max size of frame offered).
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: advanced
         * 
         * @param requestedFrameMax the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointBuilder requestedFrameMax(
                int requestedFrameMax) {
            doSetProperty("requestedFrameMax", requestedFrameMax);
            return this;
        }
        /**
         * Connection requested frame max (max size of frame offered).
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: advanced
         * 
         * @param requestedFrameMax the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointBuilder requestedFrameMax(
                String requestedFrameMax) {
            doSetProperty("requestedFrameMax", requestedFrameMax);
            return this;
        }
        /**
         * Connection requested heartbeat (heart-beat in seconds offered).
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 60
         * Group: advanced
         * 
         * @param requestedHeartbeat the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointBuilder requestedHeartbeat(
                int requestedHeartbeat) {
            doSetProperty("requestedHeartbeat", requestedHeartbeat);
            return this;
        }
        /**
         * Connection requested heartbeat (heart-beat in seconds offered).
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 60
         * Group: advanced
         * 
         * @param requestedHeartbeat the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointBuilder requestedHeartbeat(
                String requestedHeartbeat) {
            doSetProperty("requestedHeartbeat", requestedHeartbeat);
            return this;
        }
        /**
         * Set timeout for waiting for a reply when using the InOut Exchange
         * Pattern (in milliseconds).
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 20000
         * Group: advanced
         * 
         * @param requestTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointBuilder requestTimeout(
                long requestTimeout) {
            doSetProperty("requestTimeout", requestTimeout);
            return this;
        }
        /**
         * Set timeout for waiting for a reply when using the InOut Exchange
         * Pattern (in milliseconds).
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 20000
         * Group: advanced
         * 
         * @param requestTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointBuilder requestTimeout(
                String requestTimeout) {
            doSetProperty("requestTimeout", requestTimeout);
            return this;
        }
        /**
         * Set requestTimeoutCheckerInterval for inOut exchange.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: advanced
         * 
         * @param requestTimeoutCheckerInterval the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointBuilder requestTimeoutCheckerInterval(
                long requestTimeoutCheckerInterval) {
            doSetProperty("requestTimeoutCheckerInterval", requestTimeoutCheckerInterval);
            return this;
        }
        /**
         * Set requestTimeoutCheckerInterval for inOut exchange.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: advanced
         * 
         * @param requestTimeoutCheckerInterval the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointBuilder requestTimeoutCheckerInterval(
                String requestTimeoutCheckerInterval) {
            doSetProperty("requestTimeoutCheckerInterval", requestTimeoutCheckerInterval);
            return this;
        }
        /**
         * Enables connection topology recovery (should topology recovery be
         * performed).
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param topologyRecoveryEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointBuilder topologyRecoveryEnabled(
                Boolean topologyRecoveryEnabled) {
            doSetProperty("topologyRecoveryEnabled", topologyRecoveryEnabled);
            return this;
        }
        /**
         * Enables connection topology recovery (should topology recovery be
         * performed).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param topologyRecoveryEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointBuilder topologyRecoveryEnabled(
                String topologyRecoveryEnabled) {
            doSetProperty("topologyRecoveryEnabled", topologyRecoveryEnabled);
            return this;
        }
        /**
         * When true and an inOut Exchange failed on the consumer side send the
         * caused Exception back in the response.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferException the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointBuilder transferException(
                boolean transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
        /**
         * When true and an inOut Exchange failed on the consumer side send the
         * caused Exception back in the response.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferException the value to set
         * @return the dsl builder
         */
        default AdvancedRabbitMQEndpointBuilder transferException(
                String transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
    }

    public interface RabbitMQBuilders {
        /**
         * RabbitMQ (camel-rabbitmq)
         * Send and receive messages from RabbitMQ instances.
         * 
         * Category: messaging
         * Since: 2.12
         * Maven coordinates: org.apache.camel:camel-rabbitmq
         * 
         * @return the dsl builder for the headers' name.
         */
        default RabbitMQHeaderNameBuilder rabbitmq() {
            return RabbitMQHeaderNameBuilder.INSTANCE;
        }
        /**
         * RabbitMQ (camel-rabbitmq)
         * Send and receive messages from RabbitMQ instances.
         * 
         * Category: messaging
         * Since: 2.12
         * Maven coordinates: org.apache.camel:camel-rabbitmq
         * 
         * Syntax: <code>rabbitmq:exchangeName</code>
         * 
         * Path parameter: exchangeName (required)
         * The exchange name determines the exchange to which the produced
         * messages will be sent to. In the case of consumers, the exchange name
         * determines the exchange the queue will be bound to.
         * 
         * @param path exchangeName
         * @return the dsl builder
         */
        @Deprecated
        default RabbitMQEndpointBuilder rabbitmq(String path) {
            return RabbitMQEndpointBuilderFactory.endpointBuilder("rabbitmq", path);
        }
        /**
         * RabbitMQ (camel-rabbitmq)
         * Send and receive messages from RabbitMQ instances.
         * 
         * Category: messaging
         * Since: 2.12
         * Maven coordinates: org.apache.camel:camel-rabbitmq
         * 
         * Syntax: <code>rabbitmq:exchangeName</code>
         * 
         * Path parameter: exchangeName (required)
         * The exchange name determines the exchange to which the produced
         * messages will be sent to. In the case of consumers, the exchange name
         * determines the exchange the queue will be bound to.
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path exchangeName
         * @return the dsl builder
         */
        @Deprecated
        default RabbitMQEndpointBuilder rabbitmq(
                String componentName,
                String path) {
            return RabbitMQEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    /**
     * The builder of headers' name for the RabbitMQ component.
     */
    public static class RabbitMQHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final RabbitMQHeaderNameBuilder INSTANCE = new RabbitMQHeaderNameBuilder();

        /**
         * Consumer: The routing key that was used to receive the message, or
         * the routing key that will be used when producing a message Producer:
         * The routing key that will be used when sending the message.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code RabbitmqRoutingKey}.
         */
        public String rabbitmqRoutingKey() {
            return "RabbitmqRoutingKey";
        }

        /**
         * Used for force sending the message to this exchange instead of the
         * endpoint configured name on the producer.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code RabbitmqExchangeOverrideName}.
         */
        public String rabbitmqExchangeOverrideName() {
            return "RabbitmqExchangeOverrideName";
        }

        /**
         * Consumer: The exchange the message was received from Producer: The
         * exchange the message was received from.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code RabbitmqExchangeName}.
         */
        public String rabbitmqExchangeName() {
            return "RabbitmqExchangeName";
        }

        /**
         * The contentType to set on the RabbitMQ message.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code RabbitmqContentType}.
         */
        public String rabbitmqContentType() {
            return "RabbitmqContentType";
        }

        /**
         * The priority header to set on the RabbitMQ message.
         * 
         * The option is a: {@code int} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code RabbitmqPriority}.
         */
        public String rabbitmqPriority() {
            return "RabbitmqPriority";
        }

        /**
         * The rabbitmq delivery tag of the received message.
         * 
         * The option is a: {@code long} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code RabbitmqDeliveryTag}.
         */
        public String rabbitmqDeliveryTag() {
            return "RabbitmqDeliveryTag";
        }

        /**
         * Whether the message is a redelivered.
         * 
         * The option is a: {@code boolean} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code RabbitmqRedeliveryTag}.
         */
        public String rabbitmqRedeliveryTag() {
            return "RabbitmqRedeliveryTag";
        }

        /**
         * The correlationId to set on the RabbitMQ message.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code RabbitmqCorrelationId}.
         */
        public String rabbitmqCorrelationId() {
            return "RabbitmqCorrelationId";
        }

        /**
         * The message id to set on the RabbitMQ message.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code RabbitmqMessageId}.
         */
        public String rabbitmqMessageId() {
            return "RabbitmqMessageId";
        }

        /**
         * If the message should be persistent or not.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code RabbitmqDeliveryMode}.
         */
        public String rabbitmqDeliveryMode() {
            return "RabbitmqDeliveryMode";
        }

        /**
         * The userId to set on the RabbitMQ message.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code RabbitmqUserId}.
         */
        public String rabbitmqUserId() {
            return "RabbitmqUserId";
        }

        /**
         * The clusterId to set on the RabbitMQ message.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code RabbitmqClusterId}.
         */
        public String rabbitmqClusterId() {
            return "RabbitmqClusterId";
        }

        /**
         * The timeout for waiting for a reply when using the InOut Exchange
         * Pattern (in milliseconds).
         * 
         * The option is a: {@code long} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code RabbitmqRequestTimeout}.
         */
        public String rabbitmqRequestTimeout() {
            return "RabbitmqRequestTimeout";
        }

        /**
         * The replyTo to set on the RabbitMQ message.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code RabbitmqReplyTo}.
         */
        public String rabbitmqReplyTo() {
            return "RabbitmqReplyTo";
        }

        /**
         * The contentEncoding to set on the RabbitMQ message.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code RabbitmqContentEncoding}.
         */
        public String rabbitmqContentEncoding() {
            return "RabbitmqContentEncoding";
        }

        /**
         * The type to set on the RabbitMQ message.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code RabbitmqType}.
         */
        public String rabbitmqType() {
            return "RabbitmqType";
        }

        /**
         * The expiration to set on the RabbitMQ message.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code RabbitmqExpiration}.
         */
        public String rabbitmqExpiration() {
            return "RabbitmqExpiration";
        }

        /**
         * The timestamp to set on the RabbitMQ message.
         * 
         * The option is a: {@code java.util.Date} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code RabbitmqTimestamp}.
         */
        public String rabbitmqTimestamp() {
            return "RabbitmqTimestamp";
        }

        /**
         * The appId to set on the RabbitMQ message.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code RabbitmqAppId}.
         */
        public String rabbitmqAppId() {
            return "RabbitmqAppId";
        }

        /**
         * This is used by the consumer to control rejection of the message.
         * When the consumer is complete processing the exchange, and if the
         * exchange failed, then the consumer is going to reject the message
         * from the RabbitMQ broker. The value of this header controls this
         * behavior. If the value is false (by default) then the message is
         * discarded/dead-lettered. If the value is true, then the message is
         * re-queued.
         * 
         * The option is a: {@code boolean} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code RabbitmqRequeue}.
         */
        public String rabbitmqRequeue() {
            return "RabbitmqRequeue";
        }

        /**
         * The flag telling the server how to react if the message cannot be
         * routed to a queue.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code RabbitmqMandatory}.
         */
        public String rabbitmqMandatory() {
            return "RabbitmqMandatory";
        }

        /**
         * The flag telling the server how to react if the message cannot be
         * routed to a queue consumer immediately.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code RabbitmqImmediate}.
         */
        public String rabbitmqImmediate() {
            return "RabbitmqImmediate";
        }

        /**
         * The timestamp of the RabbitMQ message.
         * 
         * The option is a: {@code long} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code MessageTimestamp}.
         */
        public String messageTimestamp() {
            return "MessageTimestamp";
        }
    }
    @Deprecated
    static RabbitMQEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class RabbitMQEndpointBuilderImpl extends AbstractEndpointBuilder implements RabbitMQEndpointBuilder, AdvancedRabbitMQEndpointBuilder {
            public RabbitMQEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new RabbitMQEndpointBuilderImpl(path);
    }
}