/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.Map;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Send and receive messages acting as a Telegram Bot Telegram Bot API.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface TelegramEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Telegram component.
     */
    public interface TelegramEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedTelegramEndpointConsumerBuilder advanced() {
            return (AdvancedTelegramEndpointConsumerBuilder) this;
        }
        /**
         * Limit on the number of updates that can be received in a single
         * polling request.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: consumer
         * 
         * @param limit the value to set
         * @return the dsl builder
         */
        default TelegramEndpointConsumerBuilder limit(Integer limit) {
            doSetProperty("limit", limit);
            return this;
        }
        /**
         * Limit on the number of updates that can be received in a single
         * polling request.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: consumer
         * 
         * @param limit the value to set
         * @return the dsl builder
         */
        default TelegramEndpointConsumerBuilder limit(String limit) {
            doSetProperty("limit", limit);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default TelegramEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                boolean sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default TelegramEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                String sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * Timeout in seconds for long polling. Put 0 for short polling or a
         * bigger number for long polling. Long polling produces shorter
         * response time.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 30
         * Group: consumer
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default TelegramEndpointConsumerBuilder timeout(Integer timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * Timeout in seconds for long polling. Put 0 for short polling or a
         * bigger number for long polling. Long polling produces shorter
         * response time.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 30
         * Group: consumer
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default TelegramEndpointConsumerBuilder timeout(String timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * HTTP proxy host which could be used when sending out the message.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyHost the value to set
         * @return the dsl builder
         */
        default TelegramEndpointConsumerBuilder proxyHost(String proxyHost) {
            doSetProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * HTTP proxy port which could be used when sending out the message.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default TelegramEndpointConsumerBuilder proxyPort(Integer proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * HTTP proxy port which could be used when sending out the message.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default TelegramEndpointConsumerBuilder proxyPort(String proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * HTTP proxy type which could be used when sending out the message.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.telegram.TelegramProxyType&lt;/code&gt; type.
         * 
         * Default: HTTP
         * Group: proxy
         * 
         * @param proxyType the value to set
         * @return the dsl builder
         */
        default TelegramEndpointConsumerBuilder proxyType(
                org.apache.camel.component.telegram.TelegramProxyType proxyType) {
            doSetProperty("proxyType", proxyType);
            return this;
        }
        /**
         * HTTP proxy type which could be used when sending out the message.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.telegram.TelegramProxyType&lt;/code&gt; type.
         * 
         * Default: HTTP
         * Group: proxy
         * 
         * @param proxyType the value to set
         * @return the dsl builder
         */
        default TelegramEndpointConsumerBuilder proxyType(String proxyType) {
            doSetProperty("proxyType", proxyType);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default TelegramEndpointConsumerBuilder backoffErrorThreshold(
                int backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default TelegramEndpointConsumerBuilder backoffErrorThreshold(
                String backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default TelegramEndpointConsumerBuilder backoffIdleThreshold(
                int backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default TelegramEndpointConsumerBuilder backoffIdleThreshold(
                String backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default TelegramEndpointConsumerBuilder backoffMultiplier(
                int backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default TelegramEndpointConsumerBuilder backoffMultiplier(
                String backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: scheduler
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default TelegramEndpointConsumerBuilder delay(long delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: scheduler
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default TelegramEndpointConsumerBuilder delay(String delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default TelegramEndpointConsumerBuilder greedy(boolean greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default TelegramEndpointConsumerBuilder greedy(String greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default TelegramEndpointConsumerBuilder initialDelay(long initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default TelegramEndpointConsumerBuilder initialDelay(String initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default TelegramEndpointConsumerBuilder repeatCount(long repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default TelegramEndpointConsumerBuilder repeatCount(String repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default TelegramEndpointConsumerBuilder runLoggingLevel(
                org.apache.camel.LoggingLevel runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default TelegramEndpointConsumerBuilder runLoggingLevel(
                String runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option is a:
         * &lt;code&gt;java.util.concurrent.ScheduledExecutorService&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default TelegramEndpointConsumerBuilder scheduledExecutorService(
                ScheduledExecutorService scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.concurrent.ScheduledExecutorService&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default TelegramEndpointConsumerBuilder scheduledExecutorService(
                String scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option is a: &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default TelegramEndpointConsumerBuilder scheduler(Object scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default TelegramEndpointConsumerBuilder scheduler(String scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default TelegramEndpointConsumerBuilder schedulerProperties(
                String key,
                Object value) {
            doSetMultiValueProperty("schedulerProperties", "scheduler." + key, value);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param values the values
         * @return the dsl builder
         */
        default TelegramEndpointConsumerBuilder schedulerProperties(Map values) {
            doSetMultiValueProperties("schedulerProperties", "scheduler.", values);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default TelegramEndpointConsumerBuilder startScheduler(
                boolean startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default TelegramEndpointConsumerBuilder startScheduler(
                String startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option is a:
         * &lt;code&gt;java.util.concurrent.TimeUnit&lt;/code&gt; type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default TelegramEndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.concurrent.TimeUnit&lt;/code&gt; type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default TelegramEndpointConsumerBuilder timeUnit(String timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default TelegramEndpointConsumerBuilder useFixedDelay(
                boolean useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default TelegramEndpointConsumerBuilder useFixedDelay(
                String useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * The authorization token for using the bot (ask the BotFather).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Required: true
         * Group: security
         * 
         * @param authorizationToken the value to set
         * @return the dsl builder
         */
        default TelegramEndpointConsumerBuilder authorizationToken(
                String authorizationToken) {
            doSetProperty("authorizationToken", authorizationToken);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Telegram component.
     */
    public interface AdvancedTelegramEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default TelegramEndpointConsumerBuilder basic() {
            return (TelegramEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedTelegramEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedTelegramEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedTelegramEndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedTelegramEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedTelegramEndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedTelegramEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.PollingConsumerPollStrategy&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedTelegramEndpointConsumerBuilder pollStrategy(
                org.apache.camel.spi.PollingConsumerPollStrategy pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.PollingConsumerPollStrategy&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedTelegramEndpointConsumerBuilder pollStrategy(
                String pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * Can be used to set an alternative base URI, e.g. when you want to
         * test the component against a mock Telegram API.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param baseUri the value to set
         * @return the dsl builder
         */
        default AdvancedTelegramEndpointConsumerBuilder baseUri(String baseUri) {
            doSetProperty("baseUri", baseUri);
            return this;
        }
        /**
         * The initial in-memory buffer size used when transferring data between
         * Camel and AHC Client.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1048576
         * Group: advanced
         * 
         * @param bufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedTelegramEndpointConsumerBuilder bufferSize(
                int bufferSize) {
            doSetProperty("bufferSize", bufferSize);
            return this;
        }
        /**
         * The initial in-memory buffer size used when transferring data between
         * Camel and AHC Client.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1048576
         * Group: advanced
         * 
         * @param bufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedTelegramEndpointConsumerBuilder bufferSize(
                String bufferSize) {
            doSetProperty("bufferSize", bufferSize);
            return this;
        }
        /**
         * To use a custom HttpClient.
         * 
         * The option is a: &lt;code&gt;java.net.http.HttpClient&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param client the value to set
         * @return the dsl builder
         */
        default AdvancedTelegramEndpointConsumerBuilder client(
                java.net.http.HttpClient client) {
            doSetProperty("client", client);
            return this;
        }
        /**
         * To use a custom HttpClient.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.net.http.HttpClient&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param client the value to set
         * @return the dsl builder
         */
        default AdvancedTelegramEndpointConsumerBuilder client(String client) {
            doSetProperty("client", client);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Telegram component.
     */
    public interface TelegramEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedTelegramEndpointProducerBuilder advanced() {
            return (AdvancedTelegramEndpointProducerBuilder) this;
        }
        /**
         * The identifier of the chat that will receive the produced messages.
         * Chat ids can be first obtained from incoming messages (eg. when a
         * telegram user starts a conversation with a bot, its client sends
         * automatically a '/start' message containing the chat id). It is an
         * optional parameter, as the chat id can be set dynamically for each
         * outgoing message (using body or headers).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param chatId the value to set
         * @return the dsl builder
         */
        default TelegramEndpointProducerBuilder chatId(String chatId) {
            doSetProperty("chatId", chatId);
            return this;
        }
        /**
         * HTTP proxy host which could be used when sending out the message.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyHost the value to set
         * @return the dsl builder
         */
        default TelegramEndpointProducerBuilder proxyHost(String proxyHost) {
            doSetProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * HTTP proxy port which could be used when sending out the message.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default TelegramEndpointProducerBuilder proxyPort(Integer proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * HTTP proxy port which could be used when sending out the message.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default TelegramEndpointProducerBuilder proxyPort(String proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * HTTP proxy type which could be used when sending out the message.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.telegram.TelegramProxyType&lt;/code&gt; type.
         * 
         * Default: HTTP
         * Group: proxy
         * 
         * @param proxyType the value to set
         * @return the dsl builder
         */
        default TelegramEndpointProducerBuilder proxyType(
                org.apache.camel.component.telegram.TelegramProxyType proxyType) {
            doSetProperty("proxyType", proxyType);
            return this;
        }
        /**
         * HTTP proxy type which could be used when sending out the message.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.telegram.TelegramProxyType&lt;/code&gt; type.
         * 
         * Default: HTTP
         * Group: proxy
         * 
         * @param proxyType the value to set
         * @return the dsl builder
         */
        default TelegramEndpointProducerBuilder proxyType(String proxyType) {
            doSetProperty("proxyType", proxyType);
            return this;
        }
        /**
         * The authorization token for using the bot (ask the BotFather).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Required: true
         * Group: security
         * 
         * @param authorizationToken the value to set
         * @return the dsl builder
         */
        default TelegramEndpointProducerBuilder authorizationToken(
                String authorizationToken) {
            doSetProperty("authorizationToken", authorizationToken);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Telegram component.
     */
    public interface AdvancedTelegramEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default TelegramEndpointProducerBuilder basic() {
            return (TelegramEndpointProducerBuilder) this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedTelegramEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedTelegramEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Can be used to set an alternative base URI, e.g. when you want to
         * test the component against a mock Telegram API.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param baseUri the value to set
         * @return the dsl builder
         */
        default AdvancedTelegramEndpointProducerBuilder baseUri(String baseUri) {
            doSetProperty("baseUri", baseUri);
            return this;
        }
        /**
         * The initial in-memory buffer size used when transferring data between
         * Camel and AHC Client.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1048576
         * Group: advanced
         * 
         * @param bufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedTelegramEndpointProducerBuilder bufferSize(
                int bufferSize) {
            doSetProperty("bufferSize", bufferSize);
            return this;
        }
        /**
         * The initial in-memory buffer size used when transferring data between
         * Camel and AHC Client.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1048576
         * Group: advanced
         * 
         * @param bufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedTelegramEndpointProducerBuilder bufferSize(
                String bufferSize) {
            doSetProperty("bufferSize", bufferSize);
            return this;
        }
        /**
         * To use a custom HttpClient.
         * 
         * The option is a: &lt;code&gt;java.net.http.HttpClient&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param client the value to set
         * @return the dsl builder
         */
        default AdvancedTelegramEndpointProducerBuilder client(
                java.net.http.HttpClient client) {
            doSetProperty("client", client);
            return this;
        }
        /**
         * To use a custom HttpClient.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.net.http.HttpClient&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param client the value to set
         * @return the dsl builder
         */
        default AdvancedTelegramEndpointProducerBuilder client(String client) {
            doSetProperty("client", client);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Telegram component.
     */
    public interface TelegramEndpointBuilder
            extends
                TelegramEndpointConsumerBuilder,
                TelegramEndpointProducerBuilder {
        default AdvancedTelegramEndpointBuilder advanced() {
            return (AdvancedTelegramEndpointBuilder) this;
        }
        /**
         * HTTP proxy host which could be used when sending out the message.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyHost the value to set
         * @return the dsl builder
         */
        default TelegramEndpointBuilder proxyHost(String proxyHost) {
            doSetProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * HTTP proxy port which could be used when sending out the message.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default TelegramEndpointBuilder proxyPort(Integer proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * HTTP proxy port which could be used when sending out the message.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default TelegramEndpointBuilder proxyPort(String proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * HTTP proxy type which could be used when sending out the message.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.telegram.TelegramProxyType&lt;/code&gt; type.
         * 
         * Default: HTTP
         * Group: proxy
         * 
         * @param proxyType the value to set
         * @return the dsl builder
         */
        default TelegramEndpointBuilder proxyType(
                org.apache.camel.component.telegram.TelegramProxyType proxyType) {
            doSetProperty("proxyType", proxyType);
            return this;
        }
        /**
         * HTTP proxy type which could be used when sending out the message.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.telegram.TelegramProxyType&lt;/code&gt; type.
         * 
         * Default: HTTP
         * Group: proxy
         * 
         * @param proxyType the value to set
         * @return the dsl builder
         */
        default TelegramEndpointBuilder proxyType(String proxyType) {
            doSetProperty("proxyType", proxyType);
            return this;
        }
        /**
         * The authorization token for using the bot (ask the BotFather).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Required: true
         * Group: security
         * 
         * @param authorizationToken the value to set
         * @return the dsl builder
         */
        default TelegramEndpointBuilder authorizationToken(
                String authorizationToken) {
            doSetProperty("authorizationToken", authorizationToken);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Telegram component.
     */
    public interface AdvancedTelegramEndpointBuilder
            extends
                AdvancedTelegramEndpointConsumerBuilder,
                AdvancedTelegramEndpointProducerBuilder {
        default TelegramEndpointBuilder basic() {
            return (TelegramEndpointBuilder) this;
        }
        /**
         * Can be used to set an alternative base URI, e.g. when you want to
         * test the component against a mock Telegram API.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param baseUri the value to set
         * @return the dsl builder
         */
        default AdvancedTelegramEndpointBuilder baseUri(String baseUri) {
            doSetProperty("baseUri", baseUri);
            return this;
        }
        /**
         * The initial in-memory buffer size used when transferring data between
         * Camel and AHC Client.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1048576
         * Group: advanced
         * 
         * @param bufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedTelegramEndpointBuilder bufferSize(int bufferSize) {
            doSetProperty("bufferSize", bufferSize);
            return this;
        }
        /**
         * The initial in-memory buffer size used when transferring data between
         * Camel and AHC Client.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1048576
         * Group: advanced
         * 
         * @param bufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedTelegramEndpointBuilder bufferSize(String bufferSize) {
            doSetProperty("bufferSize", bufferSize);
            return this;
        }
        /**
         * To use a custom HttpClient.
         * 
         * The option is a: &lt;code&gt;java.net.http.HttpClient&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param client the value to set
         * @return the dsl builder
         */
        default AdvancedTelegramEndpointBuilder client(
                java.net.http.HttpClient client) {
            doSetProperty("client", client);
            return this;
        }
        /**
         * To use a custom HttpClient.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.net.http.HttpClient&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param client the value to set
         * @return the dsl builder
         */
        default AdvancedTelegramEndpointBuilder client(String client) {
            doSetProperty("client", client);
            return this;
        }
    }

    public interface TelegramBuilders {
        /**
         * Telegram (camel-telegram)
         * Send and receive messages acting as a Telegram Bot Telegram Bot API.
         * 
         * Category: cloud,api,chat
         * Since: 2.18
         * Maven coordinates: org.apache.camel:camel-telegram
         * 
         * @return the dsl builder for the headers' name.
         */
        default TelegramHeaderNameBuilder telegram() {
            return TelegramHeaderNameBuilder.INSTANCE;
        }
        /**
         * Telegram (camel-telegram)
         * Send and receive messages acting as a Telegram Bot Telegram Bot API.
         * 
         * Category: cloud,api,chat
         * Since: 2.18
         * Maven coordinates: org.apache.camel:camel-telegram
         * 
         * Syntax: <code>telegram:type</code>
         * 
         * Path parameter: type (required)
         * The endpoint type. Currently, only the 'bots' type is supported.
         * There are 1 enums and the value can be one of: bots
         * 
         * @param path type
         * @return the dsl builder
         */
        default TelegramEndpointBuilder telegram(String path) {
            return TelegramEndpointBuilderFactory.endpointBuilder("telegram", path);
        }
        /**
         * Telegram (camel-telegram)
         * Send and receive messages acting as a Telegram Bot Telegram Bot API.
         * 
         * Category: cloud,api,chat
         * Since: 2.18
         * Maven coordinates: org.apache.camel:camel-telegram
         * 
         * Syntax: <code>telegram:type</code>
         * 
         * Path parameter: type (required)
         * The endpoint type. Currently, only the 'bots' type is supported.
         * There are 1 enums and the value can be one of: bots
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path type
         * @return the dsl builder
         */
        default TelegramEndpointBuilder telegram(
                String componentName,
                String path) {
            return TelegramEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    /**
     * The builder of headers' name for the Telegram component.
     */
    public static class TelegramHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final TelegramHeaderNameBuilder INSTANCE = new TelegramHeaderNameBuilder();

        /**
         * This header is used by the producer endpoint in order to resolve the
         * chat id that will receive the message. The recipient chat id can be
         * placed (in order of priority) in message body, in the
         * CamelTelegramChatId header or in the endpoint configuration (chatId
         * option). This header is also present in all incoming messages.
         * 
         * The option is a: {@code Object} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code TelegramChatId}.
         */
        public String telegramChatId() {
            return "TelegramChatId";
        }

        /**
         * This header is used to identify the media type when the outgoing
         * message is composed of pure binary data. Possible values are strings
         * or enum values belonging to the
         * org.apache.camel.component.telegram.TelegramMediaType enumeration.
         * 
         * The option is a: {@code
         * org.apache.camel.component.telegram.TelegramMediaType or String}
         * type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code TelegramMediaType}.
         */
        public String telegramMediaType() {
            return "TelegramMediaType";
        }

        /**
         * This header is used to provide a caption or title for outgoing binary
         * messages.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code TelegramMediaTitleCaption}.
         */
        public String telegramMediaTitleCaption() {
            return "TelegramMediaTitleCaption";
        }

        /**
         * The reply markup.
         * 
         * The option is a: {@code
         * org.apache.camel.component.telegram.model.ReplyMarkup} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code TelegramMediaMarkup}.
         */
        public String telegramMediaMarkup() {
            return "TelegramMediaMarkup";
        }

        /**
         * This header is used to format text messages using HTML or Markdown.
         * 
         * The option is a: {@code
         * org.apache.camel.component.telegram.TelegramParseMode} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code TelegramParseMode}.
         */
        public String telegramParseMode() {
            return "TelegramParseMode";
        }

        /**
         * The message timestamp.
         * 
         * The option is a: {@code long} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code MessageTimestamp}.
         */
        public String messageTimestamp() {
            return "MessageTimestamp";
        }
    }
    static TelegramEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class TelegramEndpointBuilderImpl extends AbstractEndpointBuilder implements TelegramEndpointBuilder, AdvancedTelegramEndpointBuilder {
            public TelegramEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new TelegramEndpointBuilderImpl(path);
    }
}