/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.endpoint.dsl;

import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

public interface KMS2EndpointBuilderFactory {
    public static KMS2EndpointBuilder aws2Kms(String path) {
        class KMS2EndpointBuilderImpl
        extends AbstractEndpointBuilder
        implements KMS2EndpointBuilder,
        AdvancedKMS2EndpointBuilder {
            public KMS2EndpointBuilderImpl(String path) {
                super("aws2-kms", path);
            }
        }
        return new KMS2EndpointBuilderImpl(path);
    }

    public static interface KMS2Builders {
        default public KMS2EndpointBuilder aws2Kms(String path) {
            return KMS2EndpointBuilderFactory.aws2Kms(path);
        }
    }

    public static enum Protocol {
        HTTP,
        HTTPS;

    }

    public static enum KMS2Operations {
        listKeys,
        createKey,
        disableKey,
        scheduleKeyDeletion,
        describeKey,
        enableKey;

    }

    public static interface AdvancedKMS2EndpointBuilder
    extends EndpointProducerBuilder {
        default public KMS2EndpointBuilder basic() {
            return (KMS2EndpointBuilder)((Object)this);
        }

        default public AdvancedKMS2EndpointBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public AdvancedKMS2EndpointBuilder basicPropertyBinding(String basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public AdvancedKMS2EndpointBuilder synchronous(boolean synchronous) {
            this.doSetProperty("synchronous", synchronous);
            return this;
        }

        default public AdvancedKMS2EndpointBuilder synchronous(String synchronous) {
            this.doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    public static interface KMS2EndpointBuilder
    extends EndpointProducerBuilder {
        default public AdvancedKMS2EndpointBuilder advanced() {
            return (AdvancedKMS2EndpointBuilder)((Object)this);
        }

        default public KMS2EndpointBuilder kmsClient(Object kmsClient) {
            this.doSetProperty("kmsClient", kmsClient);
            return this;
        }

        default public KMS2EndpointBuilder kmsClient(String kmsClient) {
            this.doSetProperty("kmsClient", kmsClient);
            return this;
        }

        default public KMS2EndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public KMS2EndpointBuilder lazyStartProducer(String lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public KMS2EndpointBuilder operation(KMS2Operations operation) {
            this.doSetProperty("operation", (Object)operation);
            return this;
        }

        default public KMS2EndpointBuilder operation(String operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public KMS2EndpointBuilder pojoRequest(boolean pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public KMS2EndpointBuilder pojoRequest(String pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public KMS2EndpointBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public KMS2EndpointBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public KMS2EndpointBuilder proxyPort(String proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public KMS2EndpointBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", (Object)proxyProtocol);
            return this;
        }

        default public KMS2EndpointBuilder proxyProtocol(String proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public KMS2EndpointBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public KMS2EndpointBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public KMS2EndpointBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }
    }
}

