/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.endpoint.dsl;

import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

public interface Lambda2EndpointBuilderFactory {
    public static Lambda2EndpointBuilder aws2Lambda(String path) {
        class Lambda2EndpointBuilderImpl
        extends AbstractEndpointBuilder
        implements Lambda2EndpointBuilder,
        AdvancedLambda2EndpointBuilder {
            public Lambda2EndpointBuilderImpl(String path) {
                super("aws2-lambda", path);
            }
        }
        return new Lambda2EndpointBuilderImpl(path);
    }

    public static interface Lambda2Builders {
        default public Lambda2EndpointBuilder aws2Lambda(String path) {
            return Lambda2EndpointBuilderFactory.aws2Lambda(path);
        }
    }

    public static enum Protocol {
        HTTP,
        HTTPS;

    }

    public static enum Lambda2Operations {
        listFunctions,
        getFunction,
        createAlias,
        deleteAlias,
        getAlias,
        listAliases,
        createFunction,
        deleteFunction,
        invokeFunction,
        updateFunction,
        createEventSourceMapping,
        deleteEventSourceMapping,
        listEventSourceMapping,
        listTags,
        tagResource,
        untagResource,
        publishVersion,
        listVersions;

    }

    public static interface AdvancedLambda2EndpointBuilder
    extends EndpointProducerBuilder {
        default public Lambda2EndpointBuilder basic() {
            return (Lambda2EndpointBuilder)((Object)this);
        }

        default public AdvancedLambda2EndpointBuilder awsLambdaClient(Object awsLambdaClient) {
            this.doSetProperty("awsLambdaClient", awsLambdaClient);
            return this;
        }

        default public AdvancedLambda2EndpointBuilder awsLambdaClient(String awsLambdaClient) {
            this.doSetProperty("awsLambdaClient", awsLambdaClient);
            return this;
        }

        default public AdvancedLambda2EndpointBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public AdvancedLambda2EndpointBuilder basicPropertyBinding(String basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public AdvancedLambda2EndpointBuilder synchronous(boolean synchronous) {
            this.doSetProperty("synchronous", synchronous);
            return this;
        }

        default public AdvancedLambda2EndpointBuilder synchronous(String synchronous) {
            this.doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    public static interface Lambda2EndpointBuilder
    extends EndpointProducerBuilder {
        default public AdvancedLambda2EndpointBuilder advanced() {
            return (AdvancedLambda2EndpointBuilder)((Object)this);
        }

        default public Lambda2EndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public Lambda2EndpointBuilder lazyStartProducer(String lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public Lambda2EndpointBuilder operation(Lambda2Operations operation) {
            this.doSetProperty("operation", (Object)operation);
            return this;
        }

        default public Lambda2EndpointBuilder operation(String operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public Lambda2EndpointBuilder pojoRequest(boolean pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public Lambda2EndpointBuilder pojoRequest(String pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public Lambda2EndpointBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public Lambda2EndpointBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public Lambda2EndpointBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public Lambda2EndpointBuilder proxyPort(String proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public Lambda2EndpointBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", (Object)proxyProtocol);
            return this;
        }

        default public Lambda2EndpointBuilder proxyProtocol(String proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public Lambda2EndpointBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public Lambda2EndpointBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }
    }
}

