/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * Manage Docker containers.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface DockerEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Docker component.
     */
    public interface DockerEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedDockerEndpointConsumerBuilder advanced() {
            return (AdvancedDockerEndpointConsumerBuilder) this;
        }
        /**
         * Email address associated with the user.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default DockerEndpointConsumerBuilder email(String email) {
            doSetProperty("email", email);
            return this;
        }
        /**
         * Docker host.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Default: localhost
         * Group: common
         */
        default DockerEndpointConsumerBuilder host(String host) {
            doSetProperty("host", host);
            return this;
        }
        /**
         * Docker port.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 2375
         * Group: common
         */
        default DockerEndpointConsumerBuilder port(Integer port) {
            doSetProperty("port", port);
            return this;
        }
        /**
         * Docker port.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 2375
         * Group: common
         */
        default DockerEndpointConsumerBuilder port(String port) {
            doSetProperty("port", port);
            return this;
        }
        /**
         * Request timeout for response (in seconds).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default DockerEndpointConsumerBuilder requestTimeout(
                Integer requestTimeout) {
            doSetProperty("requestTimeout", requestTimeout);
            return this;
        }
        /**
         * Request timeout for response (in seconds).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default DockerEndpointConsumerBuilder requestTimeout(
                String requestTimeout) {
            doSetProperty("requestTimeout", requestTimeout);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default DockerEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default DockerEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Location containing the SSL certificate chain.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default DockerEndpointConsumerBuilder certPath(String certPath) {
            doSetProperty("certPath", certPath);
            return this;
        }
        /**
         * Password to authenticate with.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default DockerEndpointConsumerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Use HTTPS communication.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         */
        default DockerEndpointConsumerBuilder secure(boolean secure) {
            doSetProperty("secure", secure);
            return this;
        }
        /**
         * Use HTTPS communication.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         */
        default DockerEndpointConsumerBuilder secure(String secure) {
            doSetProperty("secure", secure);
            return this;
        }
        /**
         * Check TLS.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         */
        default DockerEndpointConsumerBuilder tlsVerify(boolean tlsVerify) {
            doSetProperty("tlsVerify", tlsVerify);
            return this;
        }
        /**
         * Check TLS.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         */
        default DockerEndpointConsumerBuilder tlsVerify(String tlsVerify) {
            doSetProperty("tlsVerify", tlsVerify);
            return this;
        }
        /**
         * User name to authenticate with.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default DockerEndpointConsumerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Docker component.
     */
    public interface AdvancedDockerEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default DockerEndpointConsumerBuilder basic() {
            return (DockerEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedDockerEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedDockerEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedDockerEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedDockerEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedDockerEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedDockerEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * The fully qualified class name of the DockerCmdExecFactory
         * implementation to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: com.github.dockerjava.netty.NettyDockerCmdExecFactory
         * Group: advanced
         */
        default AdvancedDockerEndpointConsumerBuilder cmdExecFactory(
                String cmdExecFactory) {
            doSetProperty("cmdExecFactory", cmdExecFactory);
            return this;
        }
        /**
         * Whether to follow redirect filter.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedDockerEndpointConsumerBuilder followRedirectFilter(
                boolean followRedirectFilter) {
            doSetProperty("followRedirectFilter", followRedirectFilter);
            return this;
        }
        /**
         * Whether to follow redirect filter.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedDockerEndpointConsumerBuilder followRedirectFilter(
                String followRedirectFilter) {
            doSetProperty("followRedirectFilter", followRedirectFilter);
            return this;
        }
        /**
         * Whether to use logging filter.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedDockerEndpointConsumerBuilder loggingFilter(
                boolean loggingFilter) {
            doSetProperty("loggingFilter", loggingFilter);
            return this;
        }
        /**
         * Whether to use logging filter.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedDockerEndpointConsumerBuilder loggingFilter(
                String loggingFilter) {
            doSetProperty("loggingFilter", loggingFilter);
            return this;
        }
        /**
         * Maximum route connections.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 100
         * Group: advanced
         */
        default AdvancedDockerEndpointConsumerBuilder maxPerRouteConnections(
                Integer maxPerRouteConnections) {
            doSetProperty("maxPerRouteConnections", maxPerRouteConnections);
            return this;
        }
        /**
         * Maximum route connections.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 100
         * Group: advanced
         */
        default AdvancedDockerEndpointConsumerBuilder maxPerRouteConnections(
                String maxPerRouteConnections) {
            doSetProperty("maxPerRouteConnections", maxPerRouteConnections);
            return this;
        }
        /**
         * Maximum total connections.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 100
         * Group: advanced
         */
        default AdvancedDockerEndpointConsumerBuilder maxTotalConnections(
                Integer maxTotalConnections) {
            doSetProperty("maxTotalConnections", maxTotalConnections);
            return this;
        }
        /**
         * Maximum total connections.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 100
         * Group: advanced
         */
        default AdvancedDockerEndpointConsumerBuilder maxTotalConnections(
                String maxTotalConnections) {
            doSetProperty("maxTotalConnections", maxTotalConnections);
            return this;
        }
        /**
         * Additional configuration parameters as key/value pairs.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedDockerEndpointConsumerBuilder parameters(
                Map<String, Object> parameters) {
            doSetProperty("parameters", parameters);
            return this;
        }
        /**
         * Additional configuration parameters as key/value pairs.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedDockerEndpointConsumerBuilder parameters(
                String parameters) {
            doSetProperty("parameters", parameters);
            return this;
        }
        /**
         * Server address for docker registry.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: https://index.docker.io/v1/
         * Group: advanced
         */
        default AdvancedDockerEndpointConsumerBuilder serverAddress(
                String serverAddress) {
            doSetProperty("serverAddress", serverAddress);
            return this;
        }
        /**
         * Socket connection mode.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         */
        default AdvancedDockerEndpointConsumerBuilder socket(boolean socket) {
            doSetProperty("socket", socket);
            return this;
        }
        /**
         * Socket connection mode.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         */
        default AdvancedDockerEndpointConsumerBuilder socket(String socket) {
            doSetProperty("socket", socket);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedDockerEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedDockerEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Docker component.
     */
    public interface DockerEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedDockerEndpointProducerBuilder advanced() {
            return (AdvancedDockerEndpointProducerBuilder) this;
        }
        /**
         * Email address associated with the user.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default DockerEndpointProducerBuilder email(String email) {
            doSetProperty("email", email);
            return this;
        }
        /**
         * Docker host.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Default: localhost
         * Group: common
         */
        default DockerEndpointProducerBuilder host(String host) {
            doSetProperty("host", host);
            return this;
        }
        /**
         * Docker port.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 2375
         * Group: common
         */
        default DockerEndpointProducerBuilder port(Integer port) {
            doSetProperty("port", port);
            return this;
        }
        /**
         * Docker port.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 2375
         * Group: common
         */
        default DockerEndpointProducerBuilder port(String port) {
            doSetProperty("port", port);
            return this;
        }
        /**
         * Request timeout for response (in seconds).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default DockerEndpointProducerBuilder requestTimeout(
                Integer requestTimeout) {
            doSetProperty("requestTimeout", requestTimeout);
            return this;
        }
        /**
         * Request timeout for response (in seconds).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default DockerEndpointProducerBuilder requestTimeout(
                String requestTimeout) {
            doSetProperty("requestTimeout", requestTimeout);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default DockerEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default DockerEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Location containing the SSL certificate chain.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default DockerEndpointProducerBuilder certPath(String certPath) {
            doSetProperty("certPath", certPath);
            return this;
        }
        /**
         * Password to authenticate with.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default DockerEndpointProducerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Use HTTPS communication.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         */
        default DockerEndpointProducerBuilder secure(boolean secure) {
            doSetProperty("secure", secure);
            return this;
        }
        /**
         * Use HTTPS communication.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         */
        default DockerEndpointProducerBuilder secure(String secure) {
            doSetProperty("secure", secure);
            return this;
        }
        /**
         * Check TLS.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         */
        default DockerEndpointProducerBuilder tlsVerify(boolean tlsVerify) {
            doSetProperty("tlsVerify", tlsVerify);
            return this;
        }
        /**
         * Check TLS.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         */
        default DockerEndpointProducerBuilder tlsVerify(String tlsVerify) {
            doSetProperty("tlsVerify", tlsVerify);
            return this;
        }
        /**
         * User name to authenticate with.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default DockerEndpointProducerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Docker component.
     */
    public interface AdvancedDockerEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default DockerEndpointProducerBuilder basic() {
            return (DockerEndpointProducerBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedDockerEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedDockerEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * The fully qualified class name of the DockerCmdExecFactory
         * implementation to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: com.github.dockerjava.netty.NettyDockerCmdExecFactory
         * Group: advanced
         */
        default AdvancedDockerEndpointProducerBuilder cmdExecFactory(
                String cmdExecFactory) {
            doSetProperty("cmdExecFactory", cmdExecFactory);
            return this;
        }
        /**
         * Whether to follow redirect filter.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedDockerEndpointProducerBuilder followRedirectFilter(
                boolean followRedirectFilter) {
            doSetProperty("followRedirectFilter", followRedirectFilter);
            return this;
        }
        /**
         * Whether to follow redirect filter.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedDockerEndpointProducerBuilder followRedirectFilter(
                String followRedirectFilter) {
            doSetProperty("followRedirectFilter", followRedirectFilter);
            return this;
        }
        /**
         * Whether to use logging filter.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedDockerEndpointProducerBuilder loggingFilter(
                boolean loggingFilter) {
            doSetProperty("loggingFilter", loggingFilter);
            return this;
        }
        /**
         * Whether to use logging filter.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedDockerEndpointProducerBuilder loggingFilter(
                String loggingFilter) {
            doSetProperty("loggingFilter", loggingFilter);
            return this;
        }
        /**
         * Maximum route connections.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 100
         * Group: advanced
         */
        default AdvancedDockerEndpointProducerBuilder maxPerRouteConnections(
                Integer maxPerRouteConnections) {
            doSetProperty("maxPerRouteConnections", maxPerRouteConnections);
            return this;
        }
        /**
         * Maximum route connections.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 100
         * Group: advanced
         */
        default AdvancedDockerEndpointProducerBuilder maxPerRouteConnections(
                String maxPerRouteConnections) {
            doSetProperty("maxPerRouteConnections", maxPerRouteConnections);
            return this;
        }
        /**
         * Maximum total connections.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 100
         * Group: advanced
         */
        default AdvancedDockerEndpointProducerBuilder maxTotalConnections(
                Integer maxTotalConnections) {
            doSetProperty("maxTotalConnections", maxTotalConnections);
            return this;
        }
        /**
         * Maximum total connections.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 100
         * Group: advanced
         */
        default AdvancedDockerEndpointProducerBuilder maxTotalConnections(
                String maxTotalConnections) {
            doSetProperty("maxTotalConnections", maxTotalConnections);
            return this;
        }
        /**
         * Additional configuration parameters as key/value pairs.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedDockerEndpointProducerBuilder parameters(
                Map<String, Object> parameters) {
            doSetProperty("parameters", parameters);
            return this;
        }
        /**
         * Additional configuration parameters as key/value pairs.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedDockerEndpointProducerBuilder parameters(
                String parameters) {
            doSetProperty("parameters", parameters);
            return this;
        }
        /**
         * Server address for docker registry.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: https://index.docker.io/v1/
         * Group: advanced
         */
        default AdvancedDockerEndpointProducerBuilder serverAddress(
                String serverAddress) {
            doSetProperty("serverAddress", serverAddress);
            return this;
        }
        /**
         * Socket connection mode.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         */
        default AdvancedDockerEndpointProducerBuilder socket(boolean socket) {
            doSetProperty("socket", socket);
            return this;
        }
        /**
         * Socket connection mode.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         */
        default AdvancedDockerEndpointProducerBuilder socket(String socket) {
            doSetProperty("socket", socket);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedDockerEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedDockerEndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Docker component.
     */
    public interface DockerEndpointBuilder
            extends
                DockerEndpointConsumerBuilder,
                DockerEndpointProducerBuilder {
        default AdvancedDockerEndpointBuilder advanced() {
            return (AdvancedDockerEndpointBuilder) this;
        }
        /**
         * Email address associated with the user.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default DockerEndpointBuilder email(String email) {
            doSetProperty("email", email);
            return this;
        }
        /**
         * Docker host.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Default: localhost
         * Group: common
         */
        default DockerEndpointBuilder host(String host) {
            doSetProperty("host", host);
            return this;
        }
        /**
         * Docker port.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 2375
         * Group: common
         */
        default DockerEndpointBuilder port(Integer port) {
            doSetProperty("port", port);
            return this;
        }
        /**
         * Docker port.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 2375
         * Group: common
         */
        default DockerEndpointBuilder port(String port) {
            doSetProperty("port", port);
            return this;
        }
        /**
         * Request timeout for response (in seconds).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default DockerEndpointBuilder requestTimeout(Integer requestTimeout) {
            doSetProperty("requestTimeout", requestTimeout);
            return this;
        }
        /**
         * Request timeout for response (in seconds).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default DockerEndpointBuilder requestTimeout(String requestTimeout) {
            doSetProperty("requestTimeout", requestTimeout);
            return this;
        }
        /**
         * Location containing the SSL certificate chain.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default DockerEndpointBuilder certPath(String certPath) {
            doSetProperty("certPath", certPath);
            return this;
        }
        /**
         * Password to authenticate with.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default DockerEndpointBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Use HTTPS communication.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         */
        default DockerEndpointBuilder secure(boolean secure) {
            doSetProperty("secure", secure);
            return this;
        }
        /**
         * Use HTTPS communication.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         */
        default DockerEndpointBuilder secure(String secure) {
            doSetProperty("secure", secure);
            return this;
        }
        /**
         * Check TLS.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         */
        default DockerEndpointBuilder tlsVerify(boolean tlsVerify) {
            doSetProperty("tlsVerify", tlsVerify);
            return this;
        }
        /**
         * Check TLS.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         */
        default DockerEndpointBuilder tlsVerify(String tlsVerify) {
            doSetProperty("tlsVerify", tlsVerify);
            return this;
        }
        /**
         * User name to authenticate with.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default DockerEndpointBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Docker component.
     */
    public interface AdvancedDockerEndpointBuilder
            extends
                AdvancedDockerEndpointConsumerBuilder,
                AdvancedDockerEndpointProducerBuilder {
        default DockerEndpointBuilder basic() {
            return (DockerEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedDockerEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedDockerEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * The fully qualified class name of the DockerCmdExecFactory
         * implementation to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: com.github.dockerjava.netty.NettyDockerCmdExecFactory
         * Group: advanced
         */
        default AdvancedDockerEndpointBuilder cmdExecFactory(
                String cmdExecFactory) {
            doSetProperty("cmdExecFactory", cmdExecFactory);
            return this;
        }
        /**
         * Whether to follow redirect filter.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedDockerEndpointBuilder followRedirectFilter(
                boolean followRedirectFilter) {
            doSetProperty("followRedirectFilter", followRedirectFilter);
            return this;
        }
        /**
         * Whether to follow redirect filter.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedDockerEndpointBuilder followRedirectFilter(
                String followRedirectFilter) {
            doSetProperty("followRedirectFilter", followRedirectFilter);
            return this;
        }
        /**
         * Whether to use logging filter.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedDockerEndpointBuilder loggingFilter(
                boolean loggingFilter) {
            doSetProperty("loggingFilter", loggingFilter);
            return this;
        }
        /**
         * Whether to use logging filter.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedDockerEndpointBuilder loggingFilter(String loggingFilter) {
            doSetProperty("loggingFilter", loggingFilter);
            return this;
        }
        /**
         * Maximum route connections.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 100
         * Group: advanced
         */
        default AdvancedDockerEndpointBuilder maxPerRouteConnections(
                Integer maxPerRouteConnections) {
            doSetProperty("maxPerRouteConnections", maxPerRouteConnections);
            return this;
        }
        /**
         * Maximum route connections.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 100
         * Group: advanced
         */
        default AdvancedDockerEndpointBuilder maxPerRouteConnections(
                String maxPerRouteConnections) {
            doSetProperty("maxPerRouteConnections", maxPerRouteConnections);
            return this;
        }
        /**
         * Maximum total connections.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 100
         * Group: advanced
         */
        default AdvancedDockerEndpointBuilder maxTotalConnections(
                Integer maxTotalConnections) {
            doSetProperty("maxTotalConnections", maxTotalConnections);
            return this;
        }
        /**
         * Maximum total connections.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 100
         * Group: advanced
         */
        default AdvancedDockerEndpointBuilder maxTotalConnections(
                String maxTotalConnections) {
            doSetProperty("maxTotalConnections", maxTotalConnections);
            return this;
        }
        /**
         * Additional configuration parameters as key/value pairs.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedDockerEndpointBuilder parameters(
                Map<String, Object> parameters) {
            doSetProperty("parameters", parameters);
            return this;
        }
        /**
         * Additional configuration parameters as key/value pairs.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedDockerEndpointBuilder parameters(String parameters) {
            doSetProperty("parameters", parameters);
            return this;
        }
        /**
         * Server address for docker registry.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: https://index.docker.io/v1/
         * Group: advanced
         */
        default AdvancedDockerEndpointBuilder serverAddress(String serverAddress) {
            doSetProperty("serverAddress", serverAddress);
            return this;
        }
        /**
         * Socket connection mode.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         */
        default AdvancedDockerEndpointBuilder socket(boolean socket) {
            doSetProperty("socket", socket);
            return this;
        }
        /**
         * Socket connection mode.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         */
        default AdvancedDockerEndpointBuilder socket(String socket) {
            doSetProperty("socket", socket);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedDockerEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedDockerEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    public interface DockerBuilders {
        /**
         * Docker (camel-docker)
         * Manage Docker containers.
         * 
         * Category: cloud,container,paas
         * Since: 2.15
         * Maven coordinates: org.apache.camel:camel-docker
         * 
         * Syntax: <code>docker:operation</code>
         * 
         * Path parameter: operation (required)
         * Which operation to use
         * The value can be one of: events, stats, auth, info, ping, version,
         * imagebuild, imagecreate, imageinspect, imagelist, imagepull,
         * imagepushimageremove, imagesearch, imagetag, containerattach,
         * containercommit, containercopyfile, containercreate,
         * containerdiffinspectcontainer, containerkill, containerlist,
         * containerlog, containerpause, containerrestart, containerremove,
         * containerstartcontainerstop, containertop, containerunpause,
         * containerwait, execcreate, execstart
         * 
         * @param path operation
         */
        default DockerEndpointBuilder docker(String path) {
            return DockerEndpointBuilderFactory.endpointBuilder("docker", path);
        }
        /**
         * Docker (camel-docker)
         * Manage Docker containers.
         * 
         * Category: cloud,container,paas
         * Since: 2.15
         * Maven coordinates: org.apache.camel:camel-docker
         * 
         * Syntax: <code>docker:operation</code>
         * 
         * Path parameter: operation (required)
         * Which operation to use
         * The value can be one of: events, stats, auth, info, ping, version,
         * imagebuild, imagecreate, imageinspect, imagelist, imagepull,
         * imagepushimageremove, imagesearch, imagetag, containerattach,
         * containercommit, containercopyfile, containercreate,
         * containerdiffinspectcontainer, containerkill, containerlist,
         * containerlog, containerpause, containerrestart, containerremove,
         * containerstartcontainerstop, containertop, containerunpause,
         * containerwait, execcreate, execstart
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path operation
         */
        default DockerEndpointBuilder docker(String componentName, String path) {
            return DockerEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    static DockerEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class DockerEndpointBuilderImpl extends AbstractEndpointBuilder implements DockerEndpointBuilder, AdvancedDockerEndpointBuilder {
            public DockerEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new DockerEndpointBuilderImpl(path);
    }
}