/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * Store and retrieve blobs from Azure Storage Blob Service.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface BlobServiceEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Azure Storage Blob Service
     * (Deprecated) component.
     */
    public interface BlobServiceEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedBlobServiceEndpointConsumerBuilder advanced() {
            return (AdvancedBlobServiceEndpointConsumerBuilder) this;
        }
        /**
         * The blob service client.
         * 
         * The option is a:
         * &lt;code&gt;com.microsoft.azure.storage.blob.CloudBlob&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param azureBlobClient the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointConsumerBuilder azureBlobClient(
                Object azureBlobClient) {
            doSetProperty("azureBlobClient", azureBlobClient);
            return this;
        }
        /**
         * The blob service client.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.microsoft.azure.storage.blob.CloudBlob&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param azureBlobClient the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointConsumerBuilder azureBlobClient(
                String azureBlobClient) {
            doSetProperty("azureBlobClient", azureBlobClient);
            return this;
        }
        /**
         * Set the blob offset for the upload or download operations, default is
         * 0.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param blobOffset the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointConsumerBuilder blobOffset(Long blobOffset) {
            doSetProperty("blobOffset", blobOffset);
            return this;
        }
        /**
         * Set the blob offset for the upload or download operations, default is
         * 0.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param blobOffset the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointConsumerBuilder blobOffset(String blobOffset) {
            doSetProperty("blobOffset", blobOffset);
            return this;
        }
        /**
         * Set a blob type, 'blockblob' is default.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.azure.blob.BlobType&lt;/code&gt; type.
         * 
         * Default: blockblob
         * Group: common
         * 
         * @param blobType the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointConsumerBuilder blobType(BlobType blobType) {
            doSetProperty("blobType", blobType);
            return this;
        }
        /**
         * Set a blob type, 'blockblob' is default.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.azure.blob.BlobType&lt;/code&gt; type.
         * 
         * Default: blockblob
         * Group: common
         * 
         * @param blobType the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointConsumerBuilder blobType(String blobType) {
            doSetProperty("blobType", blobType);
            return this;
        }
        /**
         * Close the stream after read or keep it open, default is true.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param closeStreamAfterRead the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointConsumerBuilder closeStreamAfterRead(
                boolean closeStreamAfterRead) {
            doSetProperty("closeStreamAfterRead", closeStreamAfterRead);
            return this;
        }
        /**
         * Close the stream after read or keep it open, default is true.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param closeStreamAfterRead the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointConsumerBuilder closeStreamAfterRead(
                String closeStreamAfterRead) {
            doSetProperty("closeStreamAfterRead", closeStreamAfterRead);
            return this;
        }
        /**
         * Set the storage credentials, required in most cases.
         * 
         * The option is a:
         * &lt;code&gt;com.microsoft.azure.storage.StorageCredentials&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param credentials the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointConsumerBuilder credentials(
                Object credentials) {
            doSetProperty("credentials", credentials);
            return this;
        }
        /**
         * Set the storage credentials, required in most cases.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.microsoft.azure.storage.StorageCredentials&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param credentials the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointConsumerBuilder credentials(
                String credentials) {
            doSetProperty("credentials", credentials);
            return this;
        }
        /**
         * Set the data length for the download or page blob upload operations.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataLength the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointConsumerBuilder dataLength(Long dataLength) {
            doSetProperty("dataLength", dataLength);
            return this;
        }
        /**
         * Set the data length for the download or page blob upload operations.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataLength the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointConsumerBuilder dataLength(String dataLength) {
            doSetProperty("dataLength", dataLength);
            return this;
        }
        /**
         * Set the file directory where the downloaded blobs will be saved to.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param fileDir the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointConsumerBuilder fileDir(String fileDir) {
            doSetProperty("fileDir", fileDir);
            return this;
        }
        /**
         * Storage resources can be public for reading their content, if this
         * property is enabled then the credentials do not have to be set.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param publicForRead the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointConsumerBuilder publicForRead(
                boolean publicForRead) {
            doSetProperty("publicForRead", publicForRead);
            return this;
        }
        /**
         * Storage resources can be public for reading their content, if this
         * property is enabled then the credentials do not have to be set.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param publicForRead the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointConsumerBuilder publicForRead(
                String publicForRead) {
            doSetProperty("publicForRead", publicForRead);
            return this;
        }
        /**
         * Set the minimum read size in bytes when reading the blob content.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param streamReadSize the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointConsumerBuilder streamReadSize(
                int streamReadSize) {
            doSetProperty("streamReadSize", streamReadSize);
            return this;
        }
        /**
         * Set the minimum read size in bytes when reading the blob content.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param streamReadSize the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointConsumerBuilder streamReadSize(
                String streamReadSize) {
            doSetProperty("streamReadSize", streamReadSize);
            return this;
        }
        /**
         * Whether to validate the Azure client URI.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param validateClientURI the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointConsumerBuilder validateClientURI(
                boolean validateClientURI) {
            doSetProperty("validateClientURI", validateClientURI);
            return this;
        }
        /**
         * Whether to validate the Azure client URI.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param validateClientURI the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointConsumerBuilder validateClientURI(
                String validateClientURI) {
            doSetProperty("validateClientURI", validateClientURI);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Set the storage account key used during authentication phase.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param credentialsAccountKey the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointConsumerBuilder credentialsAccountKey(
                String credentialsAccountKey) {
            doSetProperty("credentialsAccountKey", credentialsAccountKey);
            return this;
        }
        /**
         * Set the storage account name used during authentication phase.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param credentialsAccountName the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointConsumerBuilder credentialsAccountName(
                String credentialsAccountName) {
            doSetProperty("credentialsAccountName", credentialsAccountName);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Azure Storage Blob
     * Service (Deprecated) component.
     */
    public interface AdvancedBlobServiceEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default BlobServiceEndpointConsumerBuilder basic() {
            return (BlobServiceEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedBlobServiceEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedBlobServiceEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedBlobServiceEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedBlobServiceEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedBlobServiceEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedBlobServiceEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Azure Storage Blob Service
     * (Deprecated) component.
     */
    public interface BlobServiceEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedBlobServiceEndpointProducerBuilder advanced() {
            return (AdvancedBlobServiceEndpointProducerBuilder) this;
        }
        /**
         * The blob service client.
         * 
         * The option is a:
         * &lt;code&gt;com.microsoft.azure.storage.blob.CloudBlob&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param azureBlobClient the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointProducerBuilder azureBlobClient(
                Object azureBlobClient) {
            doSetProperty("azureBlobClient", azureBlobClient);
            return this;
        }
        /**
         * The blob service client.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.microsoft.azure.storage.blob.CloudBlob&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param azureBlobClient the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointProducerBuilder azureBlobClient(
                String azureBlobClient) {
            doSetProperty("azureBlobClient", azureBlobClient);
            return this;
        }
        /**
         * Set the blob offset for the upload or download operations, default is
         * 0.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param blobOffset the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointProducerBuilder blobOffset(Long blobOffset) {
            doSetProperty("blobOffset", blobOffset);
            return this;
        }
        /**
         * Set the blob offset for the upload or download operations, default is
         * 0.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param blobOffset the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointProducerBuilder blobOffset(String blobOffset) {
            doSetProperty("blobOffset", blobOffset);
            return this;
        }
        /**
         * Set a blob type, 'blockblob' is default.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.azure.blob.BlobType&lt;/code&gt; type.
         * 
         * Default: blockblob
         * Group: common
         * 
         * @param blobType the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointProducerBuilder blobType(BlobType blobType) {
            doSetProperty("blobType", blobType);
            return this;
        }
        /**
         * Set a blob type, 'blockblob' is default.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.azure.blob.BlobType&lt;/code&gt; type.
         * 
         * Default: blockblob
         * Group: common
         * 
         * @param blobType the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointProducerBuilder blobType(String blobType) {
            doSetProperty("blobType", blobType);
            return this;
        }
        /**
         * Close the stream after read or keep it open, default is true.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param closeStreamAfterRead the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointProducerBuilder closeStreamAfterRead(
                boolean closeStreamAfterRead) {
            doSetProperty("closeStreamAfterRead", closeStreamAfterRead);
            return this;
        }
        /**
         * Close the stream after read or keep it open, default is true.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param closeStreamAfterRead the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointProducerBuilder closeStreamAfterRead(
                String closeStreamAfterRead) {
            doSetProperty("closeStreamAfterRead", closeStreamAfterRead);
            return this;
        }
        /**
         * Set the storage credentials, required in most cases.
         * 
         * The option is a:
         * &lt;code&gt;com.microsoft.azure.storage.StorageCredentials&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param credentials the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointProducerBuilder credentials(
                Object credentials) {
            doSetProperty("credentials", credentials);
            return this;
        }
        /**
         * Set the storage credentials, required in most cases.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.microsoft.azure.storage.StorageCredentials&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param credentials the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointProducerBuilder credentials(
                String credentials) {
            doSetProperty("credentials", credentials);
            return this;
        }
        /**
         * Set the data length for the download or page blob upload operations.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataLength the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointProducerBuilder dataLength(Long dataLength) {
            doSetProperty("dataLength", dataLength);
            return this;
        }
        /**
         * Set the data length for the download or page blob upload operations.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataLength the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointProducerBuilder dataLength(String dataLength) {
            doSetProperty("dataLength", dataLength);
            return this;
        }
        /**
         * Set the file directory where the downloaded blobs will be saved to.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param fileDir the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointProducerBuilder fileDir(String fileDir) {
            doSetProperty("fileDir", fileDir);
            return this;
        }
        /**
         * Storage resources can be public for reading their content, if this
         * property is enabled then the credentials do not have to be set.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param publicForRead the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointProducerBuilder publicForRead(
                boolean publicForRead) {
            doSetProperty("publicForRead", publicForRead);
            return this;
        }
        /**
         * Storage resources can be public for reading their content, if this
         * property is enabled then the credentials do not have to be set.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param publicForRead the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointProducerBuilder publicForRead(
                String publicForRead) {
            doSetProperty("publicForRead", publicForRead);
            return this;
        }
        /**
         * Set the minimum read size in bytes when reading the blob content.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param streamReadSize the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointProducerBuilder streamReadSize(
                int streamReadSize) {
            doSetProperty("streamReadSize", streamReadSize);
            return this;
        }
        /**
         * Set the minimum read size in bytes when reading the blob content.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param streamReadSize the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointProducerBuilder streamReadSize(
                String streamReadSize) {
            doSetProperty("streamReadSize", streamReadSize);
            return this;
        }
        /**
         * Whether to validate the Azure client URI.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param validateClientURI the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointProducerBuilder validateClientURI(
                boolean validateClientURI) {
            doSetProperty("validateClientURI", validateClientURI);
            return this;
        }
        /**
         * Whether to validate the Azure client URI.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param validateClientURI the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointProducerBuilder validateClientURI(
                String validateClientURI) {
            doSetProperty("validateClientURI", validateClientURI);
            return this;
        }
        /**
         * Set the blob meta-data.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param blobMetadata the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointProducerBuilder blobMetadata(
                Map<String, String> blobMetadata) {
            doSetProperty("blobMetadata", blobMetadata);
            return this;
        }
        /**
         * Set the blob meta-data.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param blobMetadata the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointProducerBuilder blobMetadata(
                String blobMetadata) {
            doSetProperty("blobMetadata", blobMetadata);
            return this;
        }
        /**
         * Set a prefix which can be used for listing the blobs.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param blobPrefix the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointProducerBuilder blobPrefix(String blobPrefix) {
            doSetProperty("blobPrefix", blobPrefix);
            return this;
        }
        /**
         * Close the stream after write or keep it open, default is true.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param closeStreamAfterWrite the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointProducerBuilder closeStreamAfterWrite(
                boolean closeStreamAfterWrite) {
            doSetProperty("closeStreamAfterWrite", closeStreamAfterWrite);
            return this;
        }
        /**
         * Close the stream after write or keep it open, default is true.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param closeStreamAfterWrite the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointProducerBuilder closeStreamAfterWrite(
                String closeStreamAfterWrite) {
            doSetProperty("closeStreamAfterWrite", closeStreamAfterWrite);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Blob service operation hint to the producer.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.azure.blob.BlobServiceOperations&lt;/code&gt; type.
         * 
         * Default: listBlobs
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointProducerBuilder operation(
                BlobServiceOperations operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * Blob service operation hint to the producer.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.azure.blob.BlobServiceOperations&lt;/code&gt; type.
         * 
         * Default: listBlobs
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointProducerBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * Set the size of the buffer for writing block and page blocks.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param streamWriteSize the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointProducerBuilder streamWriteSize(
                int streamWriteSize) {
            doSetProperty("streamWriteSize", streamWriteSize);
            return this;
        }
        /**
         * Set the size of the buffer for writing block and page blocks.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param streamWriteSize the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointProducerBuilder streamWriteSize(
                String streamWriteSize) {
            doSetProperty("streamWriteSize", streamWriteSize);
            return this;
        }
        /**
         * Specify if the flat or hierarchical blob listing should be used.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param useFlatListing the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointProducerBuilder useFlatListing(
                boolean useFlatListing) {
            doSetProperty("useFlatListing", useFlatListing);
            return this;
        }
        /**
         * Specify if the flat or hierarchical blob listing should be used.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param useFlatListing the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointProducerBuilder useFlatListing(
                String useFlatListing) {
            doSetProperty("useFlatListing", useFlatListing);
            return this;
        }
        /**
         * Set the storage account key used during authentication phase.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param credentialsAccountKey the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointProducerBuilder credentialsAccountKey(
                String credentialsAccountKey) {
            doSetProperty("credentialsAccountKey", credentialsAccountKey);
            return this;
        }
        /**
         * Set the storage account name used during authentication phase.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param credentialsAccountName the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointProducerBuilder credentialsAccountName(
                String credentialsAccountName) {
            doSetProperty("credentialsAccountName", credentialsAccountName);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Azure Storage Blob
     * Service (Deprecated) component.
     */
    public interface AdvancedBlobServiceEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default BlobServiceEndpointProducerBuilder basic() {
            return (BlobServiceEndpointProducerBuilder) this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedBlobServiceEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedBlobServiceEndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Azure Storage Blob Service (Deprecated)
     * component.
     */
    public interface BlobServiceEndpointBuilder
            extends
                BlobServiceEndpointConsumerBuilder,
                BlobServiceEndpointProducerBuilder {
        default AdvancedBlobServiceEndpointBuilder advanced() {
            return (AdvancedBlobServiceEndpointBuilder) this;
        }
        /**
         * The blob service client.
         * 
         * The option is a:
         * &lt;code&gt;com.microsoft.azure.storage.blob.CloudBlob&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param azureBlobClient the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointBuilder azureBlobClient(
                Object azureBlobClient) {
            doSetProperty("azureBlobClient", azureBlobClient);
            return this;
        }
        /**
         * The blob service client.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.microsoft.azure.storage.blob.CloudBlob&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param azureBlobClient the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointBuilder azureBlobClient(
                String azureBlobClient) {
            doSetProperty("azureBlobClient", azureBlobClient);
            return this;
        }
        /**
         * Set the blob offset for the upload or download operations, default is
         * 0.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param blobOffset the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointBuilder blobOffset(Long blobOffset) {
            doSetProperty("blobOffset", blobOffset);
            return this;
        }
        /**
         * Set the blob offset for the upload or download operations, default is
         * 0.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param blobOffset the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointBuilder blobOffset(String blobOffset) {
            doSetProperty("blobOffset", blobOffset);
            return this;
        }
        /**
         * Set a blob type, 'blockblob' is default.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.azure.blob.BlobType&lt;/code&gt; type.
         * 
         * Default: blockblob
         * Group: common
         * 
         * @param blobType the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointBuilder blobType(BlobType blobType) {
            doSetProperty("blobType", blobType);
            return this;
        }
        /**
         * Set a blob type, 'blockblob' is default.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.azure.blob.BlobType&lt;/code&gt; type.
         * 
         * Default: blockblob
         * Group: common
         * 
         * @param blobType the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointBuilder blobType(String blobType) {
            doSetProperty("blobType", blobType);
            return this;
        }
        /**
         * Close the stream after read or keep it open, default is true.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param closeStreamAfterRead the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointBuilder closeStreamAfterRead(
                boolean closeStreamAfterRead) {
            doSetProperty("closeStreamAfterRead", closeStreamAfterRead);
            return this;
        }
        /**
         * Close the stream after read or keep it open, default is true.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param closeStreamAfterRead the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointBuilder closeStreamAfterRead(
                String closeStreamAfterRead) {
            doSetProperty("closeStreamAfterRead", closeStreamAfterRead);
            return this;
        }
        /**
         * Set the storage credentials, required in most cases.
         * 
         * The option is a:
         * &lt;code&gt;com.microsoft.azure.storage.StorageCredentials&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param credentials the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointBuilder credentials(Object credentials) {
            doSetProperty("credentials", credentials);
            return this;
        }
        /**
         * Set the storage credentials, required in most cases.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.microsoft.azure.storage.StorageCredentials&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param credentials the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointBuilder credentials(String credentials) {
            doSetProperty("credentials", credentials);
            return this;
        }
        /**
         * Set the data length for the download or page blob upload operations.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataLength the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointBuilder dataLength(Long dataLength) {
            doSetProperty("dataLength", dataLength);
            return this;
        }
        /**
         * Set the data length for the download or page blob upload operations.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataLength the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointBuilder dataLength(String dataLength) {
            doSetProperty("dataLength", dataLength);
            return this;
        }
        /**
         * Set the file directory where the downloaded blobs will be saved to.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param fileDir the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointBuilder fileDir(String fileDir) {
            doSetProperty("fileDir", fileDir);
            return this;
        }
        /**
         * Storage resources can be public for reading their content, if this
         * property is enabled then the credentials do not have to be set.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param publicForRead the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointBuilder publicForRead(boolean publicForRead) {
            doSetProperty("publicForRead", publicForRead);
            return this;
        }
        /**
         * Storage resources can be public for reading their content, if this
         * property is enabled then the credentials do not have to be set.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param publicForRead the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointBuilder publicForRead(String publicForRead) {
            doSetProperty("publicForRead", publicForRead);
            return this;
        }
        /**
         * Set the minimum read size in bytes when reading the blob content.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param streamReadSize the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointBuilder streamReadSize(int streamReadSize) {
            doSetProperty("streamReadSize", streamReadSize);
            return this;
        }
        /**
         * Set the minimum read size in bytes when reading the blob content.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param streamReadSize the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointBuilder streamReadSize(String streamReadSize) {
            doSetProperty("streamReadSize", streamReadSize);
            return this;
        }
        /**
         * Whether to validate the Azure client URI.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param validateClientURI the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointBuilder validateClientURI(
                boolean validateClientURI) {
            doSetProperty("validateClientURI", validateClientURI);
            return this;
        }
        /**
         * Whether to validate the Azure client URI.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param validateClientURI the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointBuilder validateClientURI(
                String validateClientURI) {
            doSetProperty("validateClientURI", validateClientURI);
            return this;
        }
        /**
         * Set the storage account key used during authentication phase.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param credentialsAccountKey the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointBuilder credentialsAccountKey(
                String credentialsAccountKey) {
            doSetProperty("credentialsAccountKey", credentialsAccountKey);
            return this;
        }
        /**
         * Set the storage account name used during authentication phase.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param credentialsAccountName the value to set
         * @return the dsl builder
         */
        default BlobServiceEndpointBuilder credentialsAccountName(
                String credentialsAccountName) {
            doSetProperty("credentialsAccountName", credentialsAccountName);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Azure Storage Blob Service
     * (Deprecated) component.
     */
    public interface AdvancedBlobServiceEndpointBuilder
            extends
                AdvancedBlobServiceEndpointConsumerBuilder,
                AdvancedBlobServiceEndpointProducerBuilder {
        default BlobServiceEndpointBuilder basic() {
            return (BlobServiceEndpointBuilder) this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedBlobServiceEndpointBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedBlobServiceEndpointBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.azure.blob.BlobType</code> enum.
     */
    enum BlobType {
        blockblob,
        appendblob,
        pageblob;
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.azure.blob.BlobServiceOperations</code>
     * enum.
     */
    enum BlobServiceOperations {
        getBlob,
        deleteBlob,
        listBlobs,
        updateBlockBlob,
        uploadBlobBlocks,
        commitBlobBlockList,
        getBlobBlockList,
        createAppendBlob,
        updateAppendBlob,
        createPageBlob,
        updatePageBlob,
        resizePageBlob,
        clearPageBlob,
        getPageBlobRanges;
    }

    public interface BlobServiceBuilders {
        /**
         * Azure Storage Blob Service (Deprecated) (camel-azure)
         * Store and retrieve blobs from Azure Storage Blob Service.
         * 
         * Category: cloud,file
         * Since: 2.19
         * Maven coordinates: org.apache.camel:camel-azure
         * 
         * Syntax: <code>azure-blob:containerOrBlobUri</code>
         * 
         * Path parameter: containerOrBlobUri (required)
         * Container or Blob compact Uri
         * 
         * @param path containerOrBlobUri
         * @return the dsl builder
         */
        @Deprecated
        default BlobServiceEndpointBuilder azureBlob(String path) {
            return BlobServiceEndpointBuilderFactory.endpointBuilder("azure-blob", path);
        }
        /**
         * Azure Storage Blob Service (Deprecated) (camel-azure)
         * Store and retrieve blobs from Azure Storage Blob Service.
         * 
         * Category: cloud,file
         * Since: 2.19
         * Maven coordinates: org.apache.camel:camel-azure
         * 
         * Syntax: <code>azure-blob:containerOrBlobUri</code>
         * 
         * Path parameter: containerOrBlobUri (required)
         * Container or Blob compact Uri
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path containerOrBlobUri
         * @return the dsl builder
         */
        @Deprecated
        default BlobServiceEndpointBuilder azureBlob(
                String componentName,
                String path) {
            return BlobServiceEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    @Deprecated
    static BlobServiceEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class BlobServiceEndpointBuilderImpl extends AbstractEndpointBuilder implements BlobServiceEndpointBuilder, AdvancedBlobServiceEndpointBuilder {
            public BlobServiceEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new BlobServiceEndpointBuilderImpl(path);
    }
}