/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import javax.annotation.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * JSON to JSON transformation using JSONATA.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface JsonataEndpointBuilderFactory {


    /**
     * Builder for endpoint for the JSONATA component.
     */
    public interface JsonataEndpointBuilder extends EndpointProducerBuilder {
        default AdvancedJsonataEndpointBuilder advanced() {
            return (AdvancedJsonataEndpointBuilder) this;
        }
        /**
         * Sets whether the context map should allow access to all details. By
         * default only the message body and headers can be accessed. This
         * option can be enabled for full access to the current Exchange and
         * CamelContext. Doing so impose a potential security risk as this opens
         * access to the full power of CamelContext API.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param allowContextMapAll the value to set
         * @return the dsl builder
         */
        default JsonataEndpointBuilder allowContextMapAll(
                boolean allowContextMapAll) {
            doSetProperty("allowContextMapAll", allowContextMapAll);
            return this;
        }
        /**
         * Sets whether the context map should allow access to all details. By
         * default only the message body and headers can be accessed. This
         * option can be enabled for full access to the current Exchange and
         * CamelContext. Doing so impose a potential security risk as this opens
         * access to the full power of CamelContext API.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param allowContextMapAll the value to set
         * @return the dsl builder
         */
        default JsonataEndpointBuilder allowContextMapAll(
                String allowContextMapAll) {
            doSetProperty("allowContextMapAll", allowContextMapAll);
            return this;
        }
        /**
         * Sets whether to use resource content cache or not.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param contentCache the value to set
         * @return the dsl builder
         */
        default JsonataEndpointBuilder contentCache(boolean contentCache) {
            doSetProperty("contentCache", contentCache);
            return this;
        }
        /**
         * Sets whether to use resource content cache or not.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param contentCache the value to set
         * @return the dsl builder
         */
        default JsonataEndpointBuilder contentCache(String contentCache) {
            doSetProperty("contentCache", contentCache);
            return this;
        }
        /**
         * Specifies if the output should be Jackson JsonNode or a JSON String.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.jsonata.JsonataInputOutputType&lt;/code&gt; type.
         * 
         * Default: Jackson
         * Group: producer
         * 
         * @param inputType the value to set
         * @return the dsl builder
         */
        default JsonataEndpointBuilder inputType(
                JsonataInputOutputType inputType) {
            doSetProperty("inputType", inputType);
            return this;
        }
        /**
         * Specifies if the output should be Jackson JsonNode or a JSON String.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.jsonata.JsonataInputOutputType&lt;/code&gt; type.
         * 
         * Default: Jackson
         * Group: producer
         * 
         * @param inputType the value to set
         * @return the dsl builder
         */
        default JsonataEndpointBuilder inputType(String inputType) {
            doSetProperty("inputType", inputType);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default JsonataEndpointBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default JsonataEndpointBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Specifies if the output should be Jackson JsonNode or a JSON String.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.jsonata.JsonataInputOutputType&lt;/code&gt; type.
         * 
         * Default: Jackson
         * Group: producer
         * 
         * @param outputType the value to set
         * @return the dsl builder
         */
        default JsonataEndpointBuilder outputType(
                JsonataInputOutputType outputType) {
            doSetProperty("outputType", outputType);
            return this;
        }
        /**
         * Specifies if the output should be Jackson JsonNode or a JSON String.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.jsonata.JsonataInputOutputType&lt;/code&gt; type.
         * 
         * Default: Jackson
         * Group: producer
         * 
         * @param outputType the value to set
         * @return the dsl builder
         */
        default JsonataEndpointBuilder outputType(String outputType) {
            doSetProperty("outputType", outputType);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the JSONATA component.
     */
    public interface AdvancedJsonataEndpointBuilder
            extends
                EndpointProducerBuilder {
        default JsonataEndpointBuilder basic() {
            return (JsonataEndpointBuilder) this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedJsonataEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedJsonataEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.jsonata.JsonataInputOutputType</code>
     * enum.
     */
    enum JsonataInputOutputType {
        Jackson,
        JsonString;
    }

    public interface JsonataBuilders {
        /**
         * JSONATA (camel-jsonata)
         * JSON to JSON transformation using JSONATA.
         * 
         * Category: transformation
         * Since: 3.5
         * Maven coordinates: org.apache.camel:camel-jsonata
         * 
         * Syntax: <code>jsonata:resourceUri</code>
         * 
         * Path parameter: resourceUri (required)
         * Path to the resource. You can prefix with: classpath, file, http,
         * ref, or bean. classpath, file and http loads the resource using these
         * protocols (classpath is default). ref will lookup the resource in the
         * registry. bean will call a method on a bean to be used as the
         * resource. For bean you can specify the method name after dot, eg
         * bean:myBean.myMethod.
         * 
         * @param path resourceUri
         * @return the dsl builder
         */
        default JsonataEndpointBuilder jsonata(String path) {
            return JsonataEndpointBuilderFactory.endpointBuilder("jsonata", path);
        }
        /**
         * JSONATA (camel-jsonata)
         * JSON to JSON transformation using JSONATA.
         * 
         * Category: transformation
         * Since: 3.5
         * Maven coordinates: org.apache.camel:camel-jsonata
         * 
         * Syntax: <code>jsonata:resourceUri</code>
         * 
         * Path parameter: resourceUri (required)
         * Path to the resource. You can prefix with: classpath, file, http,
         * ref, or bean. classpath, file and http loads the resource using these
         * protocols (classpath is default). ref will lookup the resource in the
         * registry. bean will call a method on a bean to be used as the
         * resource. For bean you can specify the method name after dot, eg
         * bean:myBean.myMethod.
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path resourceUri
         * @return the dsl builder
         */
        default JsonataEndpointBuilder jsonata(String componentName, String path) {
            return JsonataEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    static JsonataEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class JsonataEndpointBuilderImpl extends AbstractEndpointBuilder implements JsonataEndpointBuilder, AdvancedJsonataEndpointBuilder {
            public JsonataEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new JsonataEndpointBuilderImpl(path);
    }
}