/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * Open a Financial Interchange (FIX) session using an embedded QuickFix/J
 * engine.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface QuickfixjEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the QuickFix component.
     */
    public interface QuickfixjEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedQuickfixjEndpointConsumerBuilder advanced() {
            return (AdvancedQuickfixjEndpointConsumerBuilder) this;
        }
        /**
         * This option allows to create QuickFIX/J engine on demand. Value true
         * means the engine is started when first message is send or there's
         * consumer configured in route definition. When false value is used,
         * the engine is started at the endpoint creation. When this parameter
         * is missing, the value of component's property lazyCreateEngines is
         * being used.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param lazyCreateEngine the value to set
         * @return the dsl builder
         */
        default QuickfixjEndpointConsumerBuilder lazyCreateEngine(
                boolean lazyCreateEngine) {
            doSetProperty("lazyCreateEngine", lazyCreateEngine);
            return this;
        }
        /**
         * This option allows to create QuickFIX/J engine on demand. Value true
         * means the engine is started when first message is send or there's
         * consumer configured in route definition. When false value is used,
         * the engine is started at the endpoint creation. When this parameter
         * is missing, the value of component's property lazyCreateEngines is
         * being used.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param lazyCreateEngine the value to set
         * @return the dsl builder
         */
        default QuickfixjEndpointConsumerBuilder lazyCreateEngine(
                String lazyCreateEngine) {
            doSetProperty("lazyCreateEngine", lazyCreateEngine);
            return this;
        }
        /**
         * The optional sessionID identifies a specific FIX session. The format
         * of the sessionID is:
         * (BeginString):(SenderCompID)/(SenderSubID)/(SenderLocationID)-(TargetCompID)/(TargetSubID)/(TargetLocationID).
         * 
         * The option is a: &lt;code&gt;quickfix.SessionID&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sessionID the value to set
         * @return the dsl builder
         */
        default QuickfixjEndpointConsumerBuilder sessionID(Object sessionID) {
            doSetProperty("sessionID", sessionID);
            return this;
        }
        /**
         * The optional sessionID identifies a specific FIX session. The format
         * of the sessionID is:
         * (BeginString):(SenderCompID)/(SenderSubID)/(SenderLocationID)-(TargetCompID)/(TargetSubID)/(TargetLocationID).
         * 
         * The option will be converted to a
         * &lt;code&gt;quickfix.SessionID&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sessionID the value to set
         * @return the dsl builder
         */
        default QuickfixjEndpointConsumerBuilder sessionID(String sessionID) {
            doSetProperty("sessionID", sessionID);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default QuickfixjEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default QuickfixjEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the QuickFix component.
     */
    public interface AdvancedQuickfixjEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default QuickfixjEndpointConsumerBuilder basic() {
            return (QuickfixjEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedQuickfixjEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedQuickfixjEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedQuickfixjEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedQuickfixjEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedQuickfixjEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedQuickfixjEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the QuickFix component.
     */
    public interface QuickfixjEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedQuickfixjEndpointProducerBuilder advanced() {
            return (AdvancedQuickfixjEndpointProducerBuilder) this;
        }
        /**
         * This option allows to create QuickFIX/J engine on demand. Value true
         * means the engine is started when first message is send or there's
         * consumer configured in route definition. When false value is used,
         * the engine is started at the endpoint creation. When this parameter
         * is missing, the value of component's property lazyCreateEngines is
         * being used.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param lazyCreateEngine the value to set
         * @return the dsl builder
         */
        default QuickfixjEndpointProducerBuilder lazyCreateEngine(
                boolean lazyCreateEngine) {
            doSetProperty("lazyCreateEngine", lazyCreateEngine);
            return this;
        }
        /**
         * This option allows to create QuickFIX/J engine on demand. Value true
         * means the engine is started when first message is send or there's
         * consumer configured in route definition. When false value is used,
         * the engine is started at the endpoint creation. When this parameter
         * is missing, the value of component's property lazyCreateEngines is
         * being used.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param lazyCreateEngine the value to set
         * @return the dsl builder
         */
        default QuickfixjEndpointProducerBuilder lazyCreateEngine(
                String lazyCreateEngine) {
            doSetProperty("lazyCreateEngine", lazyCreateEngine);
            return this;
        }
        /**
         * The optional sessionID identifies a specific FIX session. The format
         * of the sessionID is:
         * (BeginString):(SenderCompID)/(SenderSubID)/(SenderLocationID)-(TargetCompID)/(TargetSubID)/(TargetLocationID).
         * 
         * The option is a: &lt;code&gt;quickfix.SessionID&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sessionID the value to set
         * @return the dsl builder
         */
        default QuickfixjEndpointProducerBuilder sessionID(Object sessionID) {
            doSetProperty("sessionID", sessionID);
            return this;
        }
        /**
         * The optional sessionID identifies a specific FIX session. The format
         * of the sessionID is:
         * (BeginString):(SenderCompID)/(SenderSubID)/(SenderLocationID)-(TargetCompID)/(TargetSubID)/(TargetLocationID).
         * 
         * The option will be converted to a
         * &lt;code&gt;quickfix.SessionID&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sessionID the value to set
         * @return the dsl builder
         */
        default QuickfixjEndpointProducerBuilder sessionID(String sessionID) {
            doSetProperty("sessionID", sessionID);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default QuickfixjEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default QuickfixjEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the QuickFix component.
     */
    public interface AdvancedQuickfixjEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default QuickfixjEndpointProducerBuilder basic() {
            return (QuickfixjEndpointProducerBuilder) this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedQuickfixjEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedQuickfixjEndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the QuickFix component.
     */
    public interface QuickfixjEndpointBuilder
            extends
                QuickfixjEndpointConsumerBuilder,
                QuickfixjEndpointProducerBuilder {
        default AdvancedQuickfixjEndpointBuilder advanced() {
            return (AdvancedQuickfixjEndpointBuilder) this;
        }
        /**
         * This option allows to create QuickFIX/J engine on demand. Value true
         * means the engine is started when first message is send or there's
         * consumer configured in route definition. When false value is used,
         * the engine is started at the endpoint creation. When this parameter
         * is missing, the value of component's property lazyCreateEngines is
         * being used.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param lazyCreateEngine the value to set
         * @return the dsl builder
         */
        default QuickfixjEndpointBuilder lazyCreateEngine(
                boolean lazyCreateEngine) {
            doSetProperty("lazyCreateEngine", lazyCreateEngine);
            return this;
        }
        /**
         * This option allows to create QuickFIX/J engine on demand. Value true
         * means the engine is started when first message is send or there's
         * consumer configured in route definition. When false value is used,
         * the engine is started at the endpoint creation. When this parameter
         * is missing, the value of component's property lazyCreateEngines is
         * being used.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param lazyCreateEngine the value to set
         * @return the dsl builder
         */
        default QuickfixjEndpointBuilder lazyCreateEngine(
                String lazyCreateEngine) {
            doSetProperty("lazyCreateEngine", lazyCreateEngine);
            return this;
        }
        /**
         * The optional sessionID identifies a specific FIX session. The format
         * of the sessionID is:
         * (BeginString):(SenderCompID)/(SenderSubID)/(SenderLocationID)-(TargetCompID)/(TargetSubID)/(TargetLocationID).
         * 
         * The option is a: &lt;code&gt;quickfix.SessionID&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sessionID the value to set
         * @return the dsl builder
         */
        default QuickfixjEndpointBuilder sessionID(Object sessionID) {
            doSetProperty("sessionID", sessionID);
            return this;
        }
        /**
         * The optional sessionID identifies a specific FIX session. The format
         * of the sessionID is:
         * (BeginString):(SenderCompID)/(SenderSubID)/(SenderLocationID)-(TargetCompID)/(TargetSubID)/(TargetLocationID).
         * 
         * The option will be converted to a
         * &lt;code&gt;quickfix.SessionID&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sessionID the value to set
         * @return the dsl builder
         */
        default QuickfixjEndpointBuilder sessionID(String sessionID) {
            doSetProperty("sessionID", sessionID);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the QuickFix component.
     */
    public interface AdvancedQuickfixjEndpointBuilder
            extends
                AdvancedQuickfixjEndpointConsumerBuilder,
                AdvancedQuickfixjEndpointProducerBuilder {
        default QuickfixjEndpointBuilder basic() {
            return (QuickfixjEndpointBuilder) this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedQuickfixjEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedQuickfixjEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    public interface QuickfixjBuilders {
        /**
         * QuickFix (camel-quickfix)
         * Open a Financial Interchange (FIX) session using an embedded
         * QuickFix/J engine.
         * 
         * Category: messaging
         * Since: 2.1
         * Maven coordinates: org.apache.camel:camel-quickfix
         * 
         * Syntax: <code>quickfix:configurationName</code>
         * 
         * Path parameter: configurationName (required)
         * Path to the quickfix configuration file. You can prefix with:
         * classpath, file, http, ref, or bean. classpath, file and http loads
         * the configuration file using these protocols (classpath is default).
         * ref will lookup the configuration file in the registry. bean will
         * call a method on a bean to be used as the configuration. For bean you
         * can specify the method name after dot, eg bean:myBean.myMethod
         * 
         * @param path configurationName
         * @return the dsl builder
         */
        default QuickfixjEndpointBuilder quickfix(String path) {
            return QuickfixjEndpointBuilderFactory.endpointBuilder("quickfix", path);
        }
        /**
         * QuickFix (camel-quickfix)
         * Open a Financial Interchange (FIX) session using an embedded
         * QuickFix/J engine.
         * 
         * Category: messaging
         * Since: 2.1
         * Maven coordinates: org.apache.camel:camel-quickfix
         * 
         * Syntax: <code>quickfix:configurationName</code>
         * 
         * Path parameter: configurationName (required)
         * Path to the quickfix configuration file. You can prefix with:
         * classpath, file, http, ref, or bean. classpath, file and http loads
         * the configuration file using these protocols (classpath is default).
         * ref will lookup the configuration file in the registry. bean will
         * call a method on a bean to be used as the configuration. For bean you
         * can specify the method name after dot, eg bean:myBean.myMethod
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path configurationName
         * @return the dsl builder
         */
        default QuickfixjEndpointBuilder quickfix(
                String componentName,
                String path) {
            return QuickfixjEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    static QuickfixjEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class QuickfixjEndpointBuilderImpl extends AbstractEndpointBuilder implements QuickfixjEndpointBuilder, AdvancedQuickfixjEndpointBuilder {
            public QuickfixjEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new QuickfixjEndpointBuilderImpl(path);
    }
}