/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * Communicate with Salesforce using Java DTOs.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface SalesforceEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Salesforce component.
     */
    public interface SalesforceEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedSalesforceEndpointConsumerBuilder advanced() {
            return (AdvancedSalesforceEndpointConsumerBuilder) this;
        }
        /**
         * APEX method name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param apexMethod the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder apexMethod(String apexMethod) {
            doSetProperty("apexMethod", apexMethod);
            return this;
        }
        /**
         * Query params for APEX method.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param apexQueryParams the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder apexQueryParams(
                Map<String, Object> apexQueryParams) {
            doSetProperty("apexQueryParams", apexQueryParams);
            return this;
        }
        /**
         * Query params for APEX method.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param apexQueryParams the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder apexQueryParams(
                String apexQueryParams) {
            doSetProperty("apexQueryParams", apexQueryParams);
            return this;
        }
        /**
         * Salesforce API version.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: 50.0
         * Group: common
         * 
         * @param apiVersion the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder apiVersion(String apiVersion) {
            doSetProperty("apiVersion", apiVersion);
            return this;
        }
        /**
         * Backoff interval increment for Streaming connection restart attempts
         * for failures beyond CometD auto-reconnect.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: common
         * 
         * @param backoffIncrement the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder backoffIncrement(
                long backoffIncrement) {
            doSetProperty("backoffIncrement", backoffIncrement);
            return this;
        }
        /**
         * Backoff interval increment for Streaming connection restart attempts
         * for failures beyond CometD auto-reconnect.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: common
         * 
         * @param backoffIncrement the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder backoffIncrement(
                String backoffIncrement) {
            doSetProperty("backoffIncrement", backoffIncrement);
            return this;
        }
        /**
         * Bulk API Batch ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param batchId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder batchId(String batchId) {
            doSetProperty("batchId", batchId);
            return this;
        }
        /**
         * Bulk API content type, one of XML, CSV, ZIP_XML, ZIP_CSV.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.api.dto.bulk.ContentType&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param contentType the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder contentType(
                ContentType contentType) {
            doSetProperty("contentType", contentType);
            return this;
        }
        /**
         * Bulk API content type, one of XML, CSV, ZIP_XML, ZIP_CSV.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.salesforce.api.dto.bulk.ContentType&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param contentType the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder contentType(String contentType) {
            doSetProperty("contentType", contentType);
            return this;
        }
        /**
         * Default replayId setting if no value is found in initialReplayIdMap.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: common
         * 
         * @param defaultReplayId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder defaultReplayId(
                Long defaultReplayId) {
            doSetProperty("defaultReplayId", defaultReplayId);
            return this;
        }
        /**
         * Default replayId setting if no value is found in initialReplayIdMap.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: common
         * 
         * @param defaultReplayId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder defaultReplayId(
                String defaultReplayId) {
            doSetProperty("defaultReplayId", defaultReplayId);
            return this;
        }
        /**
         * Payload format to use for Salesforce API calls, either JSON or XML,
         * defaults to JSON.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.internal.PayloadFormat&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param format the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder format(PayloadFormat format) {
            doSetProperty("format", format);
            return this;
        }
        /**
         * Payload format to use for Salesforce API calls, either JSON or XML,
         * defaults to JSON.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.salesforce.internal.PayloadFormat&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param format the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder format(String format) {
            doSetProperty("format", format);
            return this;
        }
        /**
         * Custom Jetty Http Client to use to connect to Salesforce.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.SalesforceHttpClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param httpClient the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder httpClient(Object httpClient) {
            doSetProperty("httpClient", httpClient);
            return this;
        }
        /**
         * Custom Jetty Http Client to use to connect to Salesforce.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.salesforce.SalesforceHttpClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param httpClient the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder httpClient(String httpClient) {
            doSetProperty("httpClient", httpClient);
            return this;
        }
        /**
         * Include details in Salesforce1 Analytics report, defaults to false.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param includeDetails the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder includeDetails(
                Boolean includeDetails) {
            doSetProperty("includeDetails", includeDetails);
            return this;
        }
        /**
         * Include details in Salesforce1 Analytics report, defaults to false.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param includeDetails the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder includeDetails(
                String includeDetails) {
            doSetProperty("includeDetails", includeDetails);
            return this;
        }
        /**
         * Replay IDs to start from per channel name.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Long&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param initialReplayIdMap the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder initialReplayIdMap(
                Map<String, Long> initialReplayIdMap) {
            doSetProperty("initialReplayIdMap", initialReplayIdMap);
            return this;
        }
        /**
         * Replay IDs to start from per channel name.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Long&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param initialReplayIdMap the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder initialReplayIdMap(
                String initialReplayIdMap) {
            doSetProperty("initialReplayIdMap", initialReplayIdMap);
            return this;
        }
        /**
         * Salesforce1 Analytics report execution instance ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param instanceId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder instanceId(String instanceId) {
            doSetProperty("instanceId", instanceId);
            return this;
        }
        /**
         * Bulk API Job ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param jobId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder jobId(String jobId) {
            doSetProperty("jobId", jobId);
            return this;
        }
        /**
         * Limit on number of returned records. Applicable to some of the API,
         * check the Salesforce documentation.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param limit the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder limit(Integer limit) {
            doSetProperty("limit", limit);
            return this;
        }
        /**
         * Limit on number of returned records. Applicable to some of the API,
         * check the Salesforce documentation.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param limit the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder limit(String limit) {
            doSetProperty("limit", limit);
            return this;
        }
        /**
         * Maximum backoff interval for Streaming connection restart attempts
         * for failures beyond CometD auto-reconnect.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param maxBackoff the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder maxBackoff(long maxBackoff) {
            doSetProperty("maxBackoff", maxBackoff);
            return this;
        }
        /**
         * Maximum backoff interval for Streaming connection restart attempts
         * for failures beyond CometD auto-reconnect.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param maxBackoff the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder maxBackoff(String maxBackoff) {
            doSetProperty("maxBackoff", maxBackoff);
            return this;
        }
        /**
         * Sets the behaviour of 404 not found status received from Salesforce
         * API. Should the body be set to NULL NotFoundBehaviour#NULL or should
         * a exception be signaled on the exchange NotFoundBehaviour#EXCEPTION -
         * the default.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.NotFoundBehaviour&lt;/code&gt; type.
         * 
         * Default: EXCEPTION
         * Group: common
         * 
         * @param notFoundBehaviour the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder notFoundBehaviour(
                NotFoundBehaviour notFoundBehaviour) {
            doSetProperty("notFoundBehaviour", notFoundBehaviour);
            return this;
        }
        /**
         * Sets the behaviour of 404 not found status received from Salesforce
         * API. Should the body be set to NULL NotFoundBehaviour#NULL or should
         * a exception be signaled on the exchange NotFoundBehaviour#EXCEPTION -
         * the default.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.salesforce.NotFoundBehaviour&lt;/code&gt; type.
         * 
         * Default: EXCEPTION
         * Group: common
         * 
         * @param notFoundBehaviour the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder notFoundBehaviour(
                String notFoundBehaviour) {
            doSetProperty("notFoundBehaviour", notFoundBehaviour);
            return this;
        }
        /**
         * Notify for fields, options are ALL, REFERENCED, SELECT, WHERE.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.internal.dto.NotifyForFieldsEnum&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForFields the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder notifyForFields(
                NotifyForFieldsEnum notifyForFields) {
            doSetProperty("notifyForFields", notifyForFields);
            return this;
        }
        /**
         * Notify for fields, options are ALL, REFERENCED, SELECT, WHERE.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.salesforce.internal.dto.NotifyForFieldsEnum&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForFields the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder notifyForFields(
                String notifyForFields) {
            doSetProperty("notifyForFields", notifyForFields);
            return this;
        }
        /**
         * Notify for create operation, defaults to false (API version = 29.0).
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperationCreate the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder notifyForOperationCreate(
                Boolean notifyForOperationCreate) {
            doSetProperty("notifyForOperationCreate", notifyForOperationCreate);
            return this;
        }
        /**
         * Notify for create operation, defaults to false (API version = 29.0).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperationCreate the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder notifyForOperationCreate(
                String notifyForOperationCreate) {
            doSetProperty("notifyForOperationCreate", notifyForOperationCreate);
            return this;
        }
        /**
         * Notify for delete operation, defaults to false (API version = 29.0).
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperationDelete the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder notifyForOperationDelete(
                Boolean notifyForOperationDelete) {
            doSetProperty("notifyForOperationDelete", notifyForOperationDelete);
            return this;
        }
        /**
         * Notify for delete operation, defaults to false (API version = 29.0).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperationDelete the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder notifyForOperationDelete(
                String notifyForOperationDelete) {
            doSetProperty("notifyForOperationDelete", notifyForOperationDelete);
            return this;
        }
        /**
         * Notify for operations, options are ALL, CREATE, EXTENDED, UPDATE (API
         * version 29.0).
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.internal.dto.NotifyForOperationsEnum&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperations the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder notifyForOperations(
                NotifyForOperationsEnum notifyForOperations) {
            doSetProperty("notifyForOperations", notifyForOperations);
            return this;
        }
        /**
         * Notify for operations, options are ALL, CREATE, EXTENDED, UPDATE (API
         * version 29.0).
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.salesforce.internal.dto.NotifyForOperationsEnum&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperations the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder notifyForOperations(
                String notifyForOperations) {
            doSetProperty("notifyForOperations", notifyForOperations);
            return this;
        }
        /**
         * Notify for un-delete operation, defaults to false (API version =
         * 29.0).
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperationUndelete the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder notifyForOperationUndelete(
                Boolean notifyForOperationUndelete) {
            doSetProperty("notifyForOperationUndelete", notifyForOperationUndelete);
            return this;
        }
        /**
         * Notify for un-delete operation, defaults to false (API version =
         * 29.0).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperationUndelete the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder notifyForOperationUndelete(
                String notifyForOperationUndelete) {
            doSetProperty("notifyForOperationUndelete", notifyForOperationUndelete);
            return this;
        }
        /**
         * Notify for update operation, defaults to false (API version = 29.0).
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperationUpdate the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder notifyForOperationUpdate(
                Boolean notifyForOperationUpdate) {
            doSetProperty("notifyForOperationUpdate", notifyForOperationUpdate);
            return this;
        }
        /**
         * Notify for update operation, defaults to false (API version = 29.0).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperationUpdate the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder notifyForOperationUpdate(
                String notifyForOperationUpdate) {
            doSetProperty("notifyForOperationUpdate", notifyForOperationUpdate);
            return this;
        }
        /**
         * Custom Jackson ObjectMapper to use when serializing/deserializing
         * Salesforce objects.
         * 
         * The option is a:
         * &lt;code&gt;com.fasterxml.jackson.databind.ObjectMapper&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param objectMapper the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder objectMapper(
                Object objectMapper) {
            doSetProperty("objectMapper", objectMapper);
            return this;
        }
        /**
         * Custom Jackson ObjectMapper to use when serializing/deserializing
         * Salesforce objects.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.fasterxml.jackson.databind.ObjectMapper&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param objectMapper the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder objectMapper(
                String objectMapper) {
            doSetProperty("objectMapper", objectMapper);
            return this;
        }
        /**
         * Use raw payload String for request and response (either JSON or XML
         * depending on format), instead of DTOs, false by default.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param rawPayload the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder rawPayload(boolean rawPayload) {
            doSetProperty("rawPayload", rawPayload);
            return this;
        }
        /**
         * Use raw payload String for request and response (either JSON or XML
         * depending on format), instead of DTOs, false by default.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param rawPayload the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder rawPayload(String rawPayload) {
            doSetProperty("rawPayload", rawPayload);
            return this;
        }
        /**
         * Salesforce1 Analytics report Id.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param reportId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder reportId(String reportId) {
            doSetProperty("reportId", reportId);
            return this;
        }
        /**
         * Salesforce1 Analytics report metadata for filtering.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.api.dto.analytics.reports.ReportMetadata&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param reportMetadata the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder reportMetadata(
                Object reportMetadata) {
            doSetProperty("reportMetadata", reportMetadata);
            return this;
        }
        /**
         * Salesforce1 Analytics report metadata for filtering.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.salesforce.api.dto.analytics.reports.ReportMetadata&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param reportMetadata the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder reportMetadata(
                String reportMetadata) {
            doSetProperty("reportMetadata", reportMetadata);
            return this;
        }
        /**
         * Bulk API Result ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param resultId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder resultId(String resultId) {
            doSetProperty("resultId", resultId);
            return this;
        }
        /**
         * SObject blob field name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectBlobFieldName the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder sObjectBlobFieldName(
                String sObjectBlobFieldName) {
            doSetProperty("sObjectBlobFieldName", sObjectBlobFieldName);
            return this;
        }
        /**
         * Fully qualified SObject class name, usually generated using
         * camel-salesforce-maven-plugin.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectClass the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder sObjectClass(
                String sObjectClass) {
            doSetProperty("sObjectClass", sObjectClass);
            return this;
        }
        /**
         * SObject fields to retrieve.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectFields the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder sObjectFields(
                String sObjectFields) {
            doSetProperty("sObjectFields", sObjectFields);
            return this;
        }
        /**
         * SObject ID if required by API.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder sObjectId(String sObjectId) {
            doSetProperty("sObjectId", sObjectId);
            return this;
        }
        /**
         * SObject external ID field name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectIdName the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder sObjectIdName(
                String sObjectIdName) {
            doSetProperty("sObjectIdName", sObjectIdName);
            return this;
        }
        /**
         * SObject external ID field value.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectIdValue the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder sObjectIdValue(
                String sObjectIdValue) {
            doSetProperty("sObjectIdValue", sObjectIdValue);
            return this;
        }
        /**
         * SObject name if required or supported by API.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectName the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder sObjectName(String sObjectName) {
            doSetProperty("sObjectName", sObjectName);
            return this;
        }
        /**
         * Salesforce SOQL query string.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectQuery the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder sObjectQuery(
                String sObjectQuery) {
            doSetProperty("sObjectQuery", sObjectQuery);
            return this;
        }
        /**
         * Salesforce SOSL search string.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectSearch the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder sObjectSearch(
                String sObjectSearch) {
            doSetProperty("sObjectSearch", sObjectSearch);
            return this;
        }
        /**
         * Whether to update an existing Push Topic when using the Streaming
         * API, defaults to false.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param updateTopic the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder updateTopic(
                boolean updateTopic) {
            doSetProperty("updateTopic", updateTopic);
            return this;
        }
        /**
         * Whether to update an existing Push Topic when using the Streaming
         * API, defaults to false.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param updateTopic the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder updateTopic(String updateTopic) {
            doSetProperty("updateTopic", updateTopic);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * The replayId value to use when subscribing.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param replayId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder replayId(Long replayId) {
            doSetProperty("replayId", replayId);
            return this;
        }
        /**
         * The replayId value to use when subscribing.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param replayId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder replayId(String replayId) {
            doSetProperty("replayId", replayId);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Salesforce component.
     */
    public interface AdvancedSalesforceEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default SalesforceEndpointConsumerBuilder basic() {
            return (SalesforceEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedSalesforceEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedSalesforceEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedSalesforceEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedSalesforceEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedSalesforceEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedSalesforceEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Salesforce component.
     */
    public interface SalesforceEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedSalesforceEndpointProducerBuilder advanced() {
            return (AdvancedSalesforceEndpointProducerBuilder) this;
        }
        /**
         * APEX method name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param apexMethod the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder apexMethod(String apexMethod) {
            doSetProperty("apexMethod", apexMethod);
            return this;
        }
        /**
         * Query params for APEX method.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param apexQueryParams the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder apexQueryParams(
                Map<String, Object> apexQueryParams) {
            doSetProperty("apexQueryParams", apexQueryParams);
            return this;
        }
        /**
         * Query params for APEX method.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param apexQueryParams the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder apexQueryParams(
                String apexQueryParams) {
            doSetProperty("apexQueryParams", apexQueryParams);
            return this;
        }
        /**
         * Salesforce API version.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: 50.0
         * Group: common
         * 
         * @param apiVersion the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder apiVersion(String apiVersion) {
            doSetProperty("apiVersion", apiVersion);
            return this;
        }
        /**
         * Backoff interval increment for Streaming connection restart attempts
         * for failures beyond CometD auto-reconnect.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: common
         * 
         * @param backoffIncrement the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder backoffIncrement(
                long backoffIncrement) {
            doSetProperty("backoffIncrement", backoffIncrement);
            return this;
        }
        /**
         * Backoff interval increment for Streaming connection restart attempts
         * for failures beyond CometD auto-reconnect.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: common
         * 
         * @param backoffIncrement the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder backoffIncrement(
                String backoffIncrement) {
            doSetProperty("backoffIncrement", backoffIncrement);
            return this;
        }
        /**
         * Bulk API Batch ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param batchId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder batchId(String batchId) {
            doSetProperty("batchId", batchId);
            return this;
        }
        /**
         * Bulk API content type, one of XML, CSV, ZIP_XML, ZIP_CSV.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.api.dto.bulk.ContentType&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param contentType the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder contentType(
                ContentType contentType) {
            doSetProperty("contentType", contentType);
            return this;
        }
        /**
         * Bulk API content type, one of XML, CSV, ZIP_XML, ZIP_CSV.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.salesforce.api.dto.bulk.ContentType&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param contentType the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder contentType(String contentType) {
            doSetProperty("contentType", contentType);
            return this;
        }
        /**
         * Default replayId setting if no value is found in initialReplayIdMap.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: common
         * 
         * @param defaultReplayId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder defaultReplayId(
                Long defaultReplayId) {
            doSetProperty("defaultReplayId", defaultReplayId);
            return this;
        }
        /**
         * Default replayId setting if no value is found in initialReplayIdMap.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: common
         * 
         * @param defaultReplayId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder defaultReplayId(
                String defaultReplayId) {
            doSetProperty("defaultReplayId", defaultReplayId);
            return this;
        }
        /**
         * Payload format to use for Salesforce API calls, either JSON or XML,
         * defaults to JSON.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.internal.PayloadFormat&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param format the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder format(PayloadFormat format) {
            doSetProperty("format", format);
            return this;
        }
        /**
         * Payload format to use for Salesforce API calls, either JSON or XML,
         * defaults to JSON.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.salesforce.internal.PayloadFormat&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param format the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder format(String format) {
            doSetProperty("format", format);
            return this;
        }
        /**
         * Custom Jetty Http Client to use to connect to Salesforce.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.SalesforceHttpClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param httpClient the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder httpClient(Object httpClient) {
            doSetProperty("httpClient", httpClient);
            return this;
        }
        /**
         * Custom Jetty Http Client to use to connect to Salesforce.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.salesforce.SalesforceHttpClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param httpClient the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder httpClient(String httpClient) {
            doSetProperty("httpClient", httpClient);
            return this;
        }
        /**
         * Include details in Salesforce1 Analytics report, defaults to false.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param includeDetails the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder includeDetails(
                Boolean includeDetails) {
            doSetProperty("includeDetails", includeDetails);
            return this;
        }
        /**
         * Include details in Salesforce1 Analytics report, defaults to false.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param includeDetails the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder includeDetails(
                String includeDetails) {
            doSetProperty("includeDetails", includeDetails);
            return this;
        }
        /**
         * Replay IDs to start from per channel name.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Long&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param initialReplayIdMap the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder initialReplayIdMap(
                Map<String, Long> initialReplayIdMap) {
            doSetProperty("initialReplayIdMap", initialReplayIdMap);
            return this;
        }
        /**
         * Replay IDs to start from per channel name.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Long&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param initialReplayIdMap the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder initialReplayIdMap(
                String initialReplayIdMap) {
            doSetProperty("initialReplayIdMap", initialReplayIdMap);
            return this;
        }
        /**
         * Salesforce1 Analytics report execution instance ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param instanceId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder instanceId(String instanceId) {
            doSetProperty("instanceId", instanceId);
            return this;
        }
        /**
         * Bulk API Job ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param jobId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder jobId(String jobId) {
            doSetProperty("jobId", jobId);
            return this;
        }
        /**
         * Limit on number of returned records. Applicable to some of the API,
         * check the Salesforce documentation.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param limit the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder limit(Integer limit) {
            doSetProperty("limit", limit);
            return this;
        }
        /**
         * Limit on number of returned records. Applicable to some of the API,
         * check the Salesforce documentation.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param limit the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder limit(String limit) {
            doSetProperty("limit", limit);
            return this;
        }
        /**
         * Maximum backoff interval for Streaming connection restart attempts
         * for failures beyond CometD auto-reconnect.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param maxBackoff the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder maxBackoff(long maxBackoff) {
            doSetProperty("maxBackoff", maxBackoff);
            return this;
        }
        /**
         * Maximum backoff interval for Streaming connection restart attempts
         * for failures beyond CometD auto-reconnect.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param maxBackoff the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder maxBackoff(String maxBackoff) {
            doSetProperty("maxBackoff", maxBackoff);
            return this;
        }
        /**
         * Sets the behaviour of 404 not found status received from Salesforce
         * API. Should the body be set to NULL NotFoundBehaviour#NULL or should
         * a exception be signaled on the exchange NotFoundBehaviour#EXCEPTION -
         * the default.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.NotFoundBehaviour&lt;/code&gt; type.
         * 
         * Default: EXCEPTION
         * Group: common
         * 
         * @param notFoundBehaviour the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder notFoundBehaviour(
                NotFoundBehaviour notFoundBehaviour) {
            doSetProperty("notFoundBehaviour", notFoundBehaviour);
            return this;
        }
        /**
         * Sets the behaviour of 404 not found status received from Salesforce
         * API. Should the body be set to NULL NotFoundBehaviour#NULL or should
         * a exception be signaled on the exchange NotFoundBehaviour#EXCEPTION -
         * the default.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.salesforce.NotFoundBehaviour&lt;/code&gt; type.
         * 
         * Default: EXCEPTION
         * Group: common
         * 
         * @param notFoundBehaviour the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder notFoundBehaviour(
                String notFoundBehaviour) {
            doSetProperty("notFoundBehaviour", notFoundBehaviour);
            return this;
        }
        /**
         * Notify for fields, options are ALL, REFERENCED, SELECT, WHERE.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.internal.dto.NotifyForFieldsEnum&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForFields the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder notifyForFields(
                NotifyForFieldsEnum notifyForFields) {
            doSetProperty("notifyForFields", notifyForFields);
            return this;
        }
        /**
         * Notify for fields, options are ALL, REFERENCED, SELECT, WHERE.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.salesforce.internal.dto.NotifyForFieldsEnum&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForFields the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder notifyForFields(
                String notifyForFields) {
            doSetProperty("notifyForFields", notifyForFields);
            return this;
        }
        /**
         * Notify for create operation, defaults to false (API version = 29.0).
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperationCreate the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder notifyForOperationCreate(
                Boolean notifyForOperationCreate) {
            doSetProperty("notifyForOperationCreate", notifyForOperationCreate);
            return this;
        }
        /**
         * Notify for create operation, defaults to false (API version = 29.0).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperationCreate the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder notifyForOperationCreate(
                String notifyForOperationCreate) {
            doSetProperty("notifyForOperationCreate", notifyForOperationCreate);
            return this;
        }
        /**
         * Notify for delete operation, defaults to false (API version = 29.0).
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperationDelete the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder notifyForOperationDelete(
                Boolean notifyForOperationDelete) {
            doSetProperty("notifyForOperationDelete", notifyForOperationDelete);
            return this;
        }
        /**
         * Notify for delete operation, defaults to false (API version = 29.0).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperationDelete the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder notifyForOperationDelete(
                String notifyForOperationDelete) {
            doSetProperty("notifyForOperationDelete", notifyForOperationDelete);
            return this;
        }
        /**
         * Notify for operations, options are ALL, CREATE, EXTENDED, UPDATE (API
         * version 29.0).
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.internal.dto.NotifyForOperationsEnum&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperations the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder notifyForOperations(
                NotifyForOperationsEnum notifyForOperations) {
            doSetProperty("notifyForOperations", notifyForOperations);
            return this;
        }
        /**
         * Notify for operations, options are ALL, CREATE, EXTENDED, UPDATE (API
         * version 29.0).
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.salesforce.internal.dto.NotifyForOperationsEnum&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperations the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder notifyForOperations(
                String notifyForOperations) {
            doSetProperty("notifyForOperations", notifyForOperations);
            return this;
        }
        /**
         * Notify for un-delete operation, defaults to false (API version =
         * 29.0).
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperationUndelete the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder notifyForOperationUndelete(
                Boolean notifyForOperationUndelete) {
            doSetProperty("notifyForOperationUndelete", notifyForOperationUndelete);
            return this;
        }
        /**
         * Notify for un-delete operation, defaults to false (API version =
         * 29.0).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperationUndelete the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder notifyForOperationUndelete(
                String notifyForOperationUndelete) {
            doSetProperty("notifyForOperationUndelete", notifyForOperationUndelete);
            return this;
        }
        /**
         * Notify for update operation, defaults to false (API version = 29.0).
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperationUpdate the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder notifyForOperationUpdate(
                Boolean notifyForOperationUpdate) {
            doSetProperty("notifyForOperationUpdate", notifyForOperationUpdate);
            return this;
        }
        /**
         * Notify for update operation, defaults to false (API version = 29.0).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperationUpdate the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder notifyForOperationUpdate(
                String notifyForOperationUpdate) {
            doSetProperty("notifyForOperationUpdate", notifyForOperationUpdate);
            return this;
        }
        /**
         * Custom Jackson ObjectMapper to use when serializing/deserializing
         * Salesforce objects.
         * 
         * The option is a:
         * &lt;code&gt;com.fasterxml.jackson.databind.ObjectMapper&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param objectMapper the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder objectMapper(
                Object objectMapper) {
            doSetProperty("objectMapper", objectMapper);
            return this;
        }
        /**
         * Custom Jackson ObjectMapper to use when serializing/deserializing
         * Salesforce objects.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.fasterxml.jackson.databind.ObjectMapper&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param objectMapper the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder objectMapper(
                String objectMapper) {
            doSetProperty("objectMapper", objectMapper);
            return this;
        }
        /**
         * Use raw payload String for request and response (either JSON or XML
         * depending on format), instead of DTOs, false by default.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param rawPayload the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder rawPayload(boolean rawPayload) {
            doSetProperty("rawPayload", rawPayload);
            return this;
        }
        /**
         * Use raw payload String for request and response (either JSON or XML
         * depending on format), instead of DTOs, false by default.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param rawPayload the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder rawPayload(String rawPayload) {
            doSetProperty("rawPayload", rawPayload);
            return this;
        }
        /**
         * Salesforce1 Analytics report Id.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param reportId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder reportId(String reportId) {
            doSetProperty("reportId", reportId);
            return this;
        }
        /**
         * Salesforce1 Analytics report metadata for filtering.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.api.dto.analytics.reports.ReportMetadata&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param reportMetadata the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder reportMetadata(
                Object reportMetadata) {
            doSetProperty("reportMetadata", reportMetadata);
            return this;
        }
        /**
         * Salesforce1 Analytics report metadata for filtering.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.salesforce.api.dto.analytics.reports.ReportMetadata&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param reportMetadata the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder reportMetadata(
                String reportMetadata) {
            doSetProperty("reportMetadata", reportMetadata);
            return this;
        }
        /**
         * Bulk API Result ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param resultId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder resultId(String resultId) {
            doSetProperty("resultId", resultId);
            return this;
        }
        /**
         * SObject blob field name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectBlobFieldName the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder sObjectBlobFieldName(
                String sObjectBlobFieldName) {
            doSetProperty("sObjectBlobFieldName", sObjectBlobFieldName);
            return this;
        }
        /**
         * Fully qualified SObject class name, usually generated using
         * camel-salesforce-maven-plugin.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectClass the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder sObjectClass(
                String sObjectClass) {
            doSetProperty("sObjectClass", sObjectClass);
            return this;
        }
        /**
         * SObject fields to retrieve.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectFields the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder sObjectFields(
                String sObjectFields) {
            doSetProperty("sObjectFields", sObjectFields);
            return this;
        }
        /**
         * SObject ID if required by API.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder sObjectId(String sObjectId) {
            doSetProperty("sObjectId", sObjectId);
            return this;
        }
        /**
         * SObject external ID field name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectIdName the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder sObjectIdName(
                String sObjectIdName) {
            doSetProperty("sObjectIdName", sObjectIdName);
            return this;
        }
        /**
         * SObject external ID field value.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectIdValue the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder sObjectIdValue(
                String sObjectIdValue) {
            doSetProperty("sObjectIdValue", sObjectIdValue);
            return this;
        }
        /**
         * SObject name if required or supported by API.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectName the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder sObjectName(String sObjectName) {
            doSetProperty("sObjectName", sObjectName);
            return this;
        }
        /**
         * Salesforce SOQL query string.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectQuery the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder sObjectQuery(
                String sObjectQuery) {
            doSetProperty("sObjectQuery", sObjectQuery);
            return this;
        }
        /**
         * Salesforce SOSL search string.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectSearch the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder sObjectSearch(
                String sObjectSearch) {
            doSetProperty("sObjectSearch", sObjectSearch);
            return this;
        }
        /**
         * Whether to update an existing Push Topic when using the Streaming
         * API, defaults to false.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param updateTopic the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder updateTopic(
                boolean updateTopic) {
            doSetProperty("updateTopic", updateTopic);
            return this;
        }
        /**
         * Whether to update an existing Push Topic when using the Streaming
         * API, defaults to false.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param updateTopic the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder updateTopic(String updateTopic) {
            doSetProperty("updateTopic", updateTopic);
            return this;
        }
        /**
         * APEX method URL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param apexUrl the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder apexUrl(String apexUrl) {
            doSetProperty("apexUrl", apexUrl);
            return this;
        }
        /**
         * Composite (raw) method.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param compositeMethod the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder compositeMethod(
                String compositeMethod) {
            doSetProperty("compositeMethod", compositeMethod);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Salesforce component.
     */
    public interface AdvancedSalesforceEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default SalesforceEndpointProducerBuilder basic() {
            return (SalesforceEndpointProducerBuilder) this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedSalesforceEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedSalesforceEndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Salesforce component.
     */
    public interface SalesforceEndpointBuilder
            extends
                SalesforceEndpointConsumerBuilder,
                SalesforceEndpointProducerBuilder {
        default AdvancedSalesforceEndpointBuilder advanced() {
            return (AdvancedSalesforceEndpointBuilder) this;
        }
        /**
         * APEX method name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param apexMethod the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder apexMethod(String apexMethod) {
            doSetProperty("apexMethod", apexMethod);
            return this;
        }
        /**
         * Query params for APEX method.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param apexQueryParams the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder apexQueryParams(
                Map<String, Object> apexQueryParams) {
            doSetProperty("apexQueryParams", apexQueryParams);
            return this;
        }
        /**
         * Query params for APEX method.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param apexQueryParams the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder apexQueryParams(String apexQueryParams) {
            doSetProperty("apexQueryParams", apexQueryParams);
            return this;
        }
        /**
         * Salesforce API version.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: 50.0
         * Group: common
         * 
         * @param apiVersion the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder apiVersion(String apiVersion) {
            doSetProperty("apiVersion", apiVersion);
            return this;
        }
        /**
         * Backoff interval increment for Streaming connection restart attempts
         * for failures beyond CometD auto-reconnect.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: common
         * 
         * @param backoffIncrement the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder backoffIncrement(long backoffIncrement) {
            doSetProperty("backoffIncrement", backoffIncrement);
            return this;
        }
        /**
         * Backoff interval increment for Streaming connection restart attempts
         * for failures beyond CometD auto-reconnect.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: common
         * 
         * @param backoffIncrement the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder backoffIncrement(
                String backoffIncrement) {
            doSetProperty("backoffIncrement", backoffIncrement);
            return this;
        }
        /**
         * Bulk API Batch ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param batchId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder batchId(String batchId) {
            doSetProperty("batchId", batchId);
            return this;
        }
        /**
         * Bulk API content type, one of XML, CSV, ZIP_XML, ZIP_CSV.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.api.dto.bulk.ContentType&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param contentType the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder contentType(ContentType contentType) {
            doSetProperty("contentType", contentType);
            return this;
        }
        /**
         * Bulk API content type, one of XML, CSV, ZIP_XML, ZIP_CSV.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.salesforce.api.dto.bulk.ContentType&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param contentType the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder contentType(String contentType) {
            doSetProperty("contentType", contentType);
            return this;
        }
        /**
         * Default replayId setting if no value is found in initialReplayIdMap.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: common
         * 
         * @param defaultReplayId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder defaultReplayId(Long defaultReplayId) {
            doSetProperty("defaultReplayId", defaultReplayId);
            return this;
        }
        /**
         * Default replayId setting if no value is found in initialReplayIdMap.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: common
         * 
         * @param defaultReplayId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder defaultReplayId(String defaultReplayId) {
            doSetProperty("defaultReplayId", defaultReplayId);
            return this;
        }
        /**
         * Payload format to use for Salesforce API calls, either JSON or XML,
         * defaults to JSON.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.internal.PayloadFormat&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param format the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder format(PayloadFormat format) {
            doSetProperty("format", format);
            return this;
        }
        /**
         * Payload format to use for Salesforce API calls, either JSON or XML,
         * defaults to JSON.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.salesforce.internal.PayloadFormat&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param format the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder format(String format) {
            doSetProperty("format", format);
            return this;
        }
        /**
         * Custom Jetty Http Client to use to connect to Salesforce.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.SalesforceHttpClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param httpClient the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder httpClient(Object httpClient) {
            doSetProperty("httpClient", httpClient);
            return this;
        }
        /**
         * Custom Jetty Http Client to use to connect to Salesforce.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.salesforce.SalesforceHttpClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param httpClient the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder httpClient(String httpClient) {
            doSetProperty("httpClient", httpClient);
            return this;
        }
        /**
         * Include details in Salesforce1 Analytics report, defaults to false.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param includeDetails the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder includeDetails(Boolean includeDetails) {
            doSetProperty("includeDetails", includeDetails);
            return this;
        }
        /**
         * Include details in Salesforce1 Analytics report, defaults to false.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param includeDetails the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder includeDetails(String includeDetails) {
            doSetProperty("includeDetails", includeDetails);
            return this;
        }
        /**
         * Replay IDs to start from per channel name.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Long&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param initialReplayIdMap the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder initialReplayIdMap(
                Map<String, Long> initialReplayIdMap) {
            doSetProperty("initialReplayIdMap", initialReplayIdMap);
            return this;
        }
        /**
         * Replay IDs to start from per channel name.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Long&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param initialReplayIdMap the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder initialReplayIdMap(
                String initialReplayIdMap) {
            doSetProperty("initialReplayIdMap", initialReplayIdMap);
            return this;
        }
        /**
         * Salesforce1 Analytics report execution instance ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param instanceId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder instanceId(String instanceId) {
            doSetProperty("instanceId", instanceId);
            return this;
        }
        /**
         * Bulk API Job ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param jobId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder jobId(String jobId) {
            doSetProperty("jobId", jobId);
            return this;
        }
        /**
         * Limit on number of returned records. Applicable to some of the API,
         * check the Salesforce documentation.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param limit the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder limit(Integer limit) {
            doSetProperty("limit", limit);
            return this;
        }
        /**
         * Limit on number of returned records. Applicable to some of the API,
         * check the Salesforce documentation.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param limit the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder limit(String limit) {
            doSetProperty("limit", limit);
            return this;
        }
        /**
         * Maximum backoff interval for Streaming connection restart attempts
         * for failures beyond CometD auto-reconnect.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param maxBackoff the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder maxBackoff(long maxBackoff) {
            doSetProperty("maxBackoff", maxBackoff);
            return this;
        }
        /**
         * Maximum backoff interval for Streaming connection restart attempts
         * for failures beyond CometD auto-reconnect.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param maxBackoff the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder maxBackoff(String maxBackoff) {
            doSetProperty("maxBackoff", maxBackoff);
            return this;
        }
        /**
         * Sets the behaviour of 404 not found status received from Salesforce
         * API. Should the body be set to NULL NotFoundBehaviour#NULL or should
         * a exception be signaled on the exchange NotFoundBehaviour#EXCEPTION -
         * the default.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.NotFoundBehaviour&lt;/code&gt; type.
         * 
         * Default: EXCEPTION
         * Group: common
         * 
         * @param notFoundBehaviour the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder notFoundBehaviour(
                NotFoundBehaviour notFoundBehaviour) {
            doSetProperty("notFoundBehaviour", notFoundBehaviour);
            return this;
        }
        /**
         * Sets the behaviour of 404 not found status received from Salesforce
         * API. Should the body be set to NULL NotFoundBehaviour#NULL or should
         * a exception be signaled on the exchange NotFoundBehaviour#EXCEPTION -
         * the default.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.salesforce.NotFoundBehaviour&lt;/code&gt; type.
         * 
         * Default: EXCEPTION
         * Group: common
         * 
         * @param notFoundBehaviour the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder notFoundBehaviour(
                String notFoundBehaviour) {
            doSetProperty("notFoundBehaviour", notFoundBehaviour);
            return this;
        }
        /**
         * Notify for fields, options are ALL, REFERENCED, SELECT, WHERE.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.internal.dto.NotifyForFieldsEnum&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForFields the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder notifyForFields(
                NotifyForFieldsEnum notifyForFields) {
            doSetProperty("notifyForFields", notifyForFields);
            return this;
        }
        /**
         * Notify for fields, options are ALL, REFERENCED, SELECT, WHERE.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.salesforce.internal.dto.NotifyForFieldsEnum&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForFields the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder notifyForFields(String notifyForFields) {
            doSetProperty("notifyForFields", notifyForFields);
            return this;
        }
        /**
         * Notify for create operation, defaults to false (API version = 29.0).
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperationCreate the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder notifyForOperationCreate(
                Boolean notifyForOperationCreate) {
            doSetProperty("notifyForOperationCreate", notifyForOperationCreate);
            return this;
        }
        /**
         * Notify for create operation, defaults to false (API version = 29.0).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperationCreate the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder notifyForOperationCreate(
                String notifyForOperationCreate) {
            doSetProperty("notifyForOperationCreate", notifyForOperationCreate);
            return this;
        }
        /**
         * Notify for delete operation, defaults to false (API version = 29.0).
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperationDelete the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder notifyForOperationDelete(
                Boolean notifyForOperationDelete) {
            doSetProperty("notifyForOperationDelete", notifyForOperationDelete);
            return this;
        }
        /**
         * Notify for delete operation, defaults to false (API version = 29.0).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperationDelete the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder notifyForOperationDelete(
                String notifyForOperationDelete) {
            doSetProperty("notifyForOperationDelete", notifyForOperationDelete);
            return this;
        }
        /**
         * Notify for operations, options are ALL, CREATE, EXTENDED, UPDATE (API
         * version 29.0).
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.internal.dto.NotifyForOperationsEnum&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperations the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder notifyForOperations(
                NotifyForOperationsEnum notifyForOperations) {
            doSetProperty("notifyForOperations", notifyForOperations);
            return this;
        }
        /**
         * Notify for operations, options are ALL, CREATE, EXTENDED, UPDATE (API
         * version 29.0).
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.salesforce.internal.dto.NotifyForOperationsEnum&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperations the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder notifyForOperations(
                String notifyForOperations) {
            doSetProperty("notifyForOperations", notifyForOperations);
            return this;
        }
        /**
         * Notify for un-delete operation, defaults to false (API version =
         * 29.0).
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperationUndelete the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder notifyForOperationUndelete(
                Boolean notifyForOperationUndelete) {
            doSetProperty("notifyForOperationUndelete", notifyForOperationUndelete);
            return this;
        }
        /**
         * Notify for un-delete operation, defaults to false (API version =
         * 29.0).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperationUndelete the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder notifyForOperationUndelete(
                String notifyForOperationUndelete) {
            doSetProperty("notifyForOperationUndelete", notifyForOperationUndelete);
            return this;
        }
        /**
         * Notify for update operation, defaults to false (API version = 29.0).
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperationUpdate the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder notifyForOperationUpdate(
                Boolean notifyForOperationUpdate) {
            doSetProperty("notifyForOperationUpdate", notifyForOperationUpdate);
            return this;
        }
        /**
         * Notify for update operation, defaults to false (API version = 29.0).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperationUpdate the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder notifyForOperationUpdate(
                String notifyForOperationUpdate) {
            doSetProperty("notifyForOperationUpdate", notifyForOperationUpdate);
            return this;
        }
        /**
         * Custom Jackson ObjectMapper to use when serializing/deserializing
         * Salesforce objects.
         * 
         * The option is a:
         * &lt;code&gt;com.fasterxml.jackson.databind.ObjectMapper&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param objectMapper the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder objectMapper(Object objectMapper) {
            doSetProperty("objectMapper", objectMapper);
            return this;
        }
        /**
         * Custom Jackson ObjectMapper to use when serializing/deserializing
         * Salesforce objects.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.fasterxml.jackson.databind.ObjectMapper&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param objectMapper the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder objectMapper(String objectMapper) {
            doSetProperty("objectMapper", objectMapper);
            return this;
        }
        /**
         * Use raw payload String for request and response (either JSON or XML
         * depending on format), instead of DTOs, false by default.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param rawPayload the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder rawPayload(boolean rawPayload) {
            doSetProperty("rawPayload", rawPayload);
            return this;
        }
        /**
         * Use raw payload String for request and response (either JSON or XML
         * depending on format), instead of DTOs, false by default.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param rawPayload the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder rawPayload(String rawPayload) {
            doSetProperty("rawPayload", rawPayload);
            return this;
        }
        /**
         * Salesforce1 Analytics report Id.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param reportId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder reportId(String reportId) {
            doSetProperty("reportId", reportId);
            return this;
        }
        /**
         * Salesforce1 Analytics report metadata for filtering.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.api.dto.analytics.reports.ReportMetadata&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param reportMetadata the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder reportMetadata(Object reportMetadata) {
            doSetProperty("reportMetadata", reportMetadata);
            return this;
        }
        /**
         * Salesforce1 Analytics report metadata for filtering.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.salesforce.api.dto.analytics.reports.ReportMetadata&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param reportMetadata the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder reportMetadata(String reportMetadata) {
            doSetProperty("reportMetadata", reportMetadata);
            return this;
        }
        /**
         * Bulk API Result ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param resultId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder resultId(String resultId) {
            doSetProperty("resultId", resultId);
            return this;
        }
        /**
         * SObject blob field name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectBlobFieldName the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder sObjectBlobFieldName(
                String sObjectBlobFieldName) {
            doSetProperty("sObjectBlobFieldName", sObjectBlobFieldName);
            return this;
        }
        /**
         * Fully qualified SObject class name, usually generated using
         * camel-salesforce-maven-plugin.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectClass the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder sObjectClass(String sObjectClass) {
            doSetProperty("sObjectClass", sObjectClass);
            return this;
        }
        /**
         * SObject fields to retrieve.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectFields the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder sObjectFields(String sObjectFields) {
            doSetProperty("sObjectFields", sObjectFields);
            return this;
        }
        /**
         * SObject ID if required by API.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder sObjectId(String sObjectId) {
            doSetProperty("sObjectId", sObjectId);
            return this;
        }
        /**
         * SObject external ID field name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectIdName the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder sObjectIdName(String sObjectIdName) {
            doSetProperty("sObjectIdName", sObjectIdName);
            return this;
        }
        /**
         * SObject external ID field value.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectIdValue the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder sObjectIdValue(String sObjectIdValue) {
            doSetProperty("sObjectIdValue", sObjectIdValue);
            return this;
        }
        /**
         * SObject name if required or supported by API.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectName the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder sObjectName(String sObjectName) {
            doSetProperty("sObjectName", sObjectName);
            return this;
        }
        /**
         * Salesforce SOQL query string.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectQuery the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder sObjectQuery(String sObjectQuery) {
            doSetProperty("sObjectQuery", sObjectQuery);
            return this;
        }
        /**
         * Salesforce SOSL search string.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectSearch the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder sObjectSearch(String sObjectSearch) {
            doSetProperty("sObjectSearch", sObjectSearch);
            return this;
        }
        /**
         * Whether to update an existing Push Topic when using the Streaming
         * API, defaults to false.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param updateTopic the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder updateTopic(boolean updateTopic) {
            doSetProperty("updateTopic", updateTopic);
            return this;
        }
        /**
         * Whether to update an existing Push Topic when using the Streaming
         * API, defaults to false.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param updateTopic the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder updateTopic(String updateTopic) {
            doSetProperty("updateTopic", updateTopic);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Salesforce component.
     */
    public interface AdvancedSalesforceEndpointBuilder
            extends
                AdvancedSalesforceEndpointConsumerBuilder,
                AdvancedSalesforceEndpointProducerBuilder {
        default SalesforceEndpointBuilder basic() {
            return (SalesforceEndpointBuilder) this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedSalesforceEndpointBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedSalesforceEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.salesforce.api.dto.bulk.ContentType</code> enum.
     */
    enum ContentType {
        XML,
        CSV,
        JSON,
        ZIP_XML,
        ZIP_CSV,
        ZIP_JSON;
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.salesforce.internal.PayloadFormat</code>
     * enum.
     */
    enum PayloadFormat {
        JSON,
        XML;
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.salesforce.NotFoundBehaviour</code>
     * enum.
     */
    enum NotFoundBehaviour {
        EXCEPTION,
        NULL;
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.salesforce.internal.dto.NotifyForFieldsEnum</code> enum.
     */
    enum NotifyForFieldsEnum {
        ALL,
        REFERENCED,
        SELECT,
        WHERE;
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.salesforce.internal.dto.NotifyForOperationsEnum</code> enum.
     */
    enum NotifyForOperationsEnum {
        ALL,
        CREATE,
        EXTENDED,
        UPDATE;
    }

    public interface SalesforceBuilders {
        /**
         * Salesforce (camel-salesforce)
         * Communicate with Salesforce using Java DTOs.
         * 
         * Category: cloud,api,crm
         * Since: 2.12
         * Maven coordinates: org.apache.camel:camel-salesforce
         * 
         * Syntax: <code>salesforce:operationName:topicName</code>
         * 
         * Path parameter: operationName
         * The operation to use
         * There are 43 enums and the value can be one of: getVersions,
         * getResources, getGlobalObjects, getBasicInfo, getDescription,
         * getSObject, createSObject, updateSObject, deleteSObject,
         * getSObjectWithId, upsertSObject, deleteSObjectWithId, getBlobField,
         * query, queryMore, queryAll, search, apexCall, recent, createJob,
         * getJob, closeJob, abortJob, createBatch, getBatch, getAllBatches,
         * getRequest, getResults, createBatchQuery, getQueryResultIds,
         * getQueryResult, getRecentReports, getReportDescription,
         * executeSyncReport, executeAsyncReport, getReportInstances,
         * getReportResults, limits, approval, approvals, composite-tree,
         * composite-batch, composite
         * 
         * Path parameter: topicName
         * The name of the topic/channel to use
         * 
         * @param path operationName:topicName
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder salesforce(String path) {
            return SalesforceEndpointBuilderFactory.endpointBuilder("salesforce", path);
        }
        /**
         * Salesforce (camel-salesforce)
         * Communicate with Salesforce using Java DTOs.
         * 
         * Category: cloud,api,crm
         * Since: 2.12
         * Maven coordinates: org.apache.camel:camel-salesforce
         * 
         * Syntax: <code>salesforce:operationName:topicName</code>
         * 
         * Path parameter: operationName
         * The operation to use
         * There are 43 enums and the value can be one of: getVersions,
         * getResources, getGlobalObjects, getBasicInfo, getDescription,
         * getSObject, createSObject, updateSObject, deleteSObject,
         * getSObjectWithId, upsertSObject, deleteSObjectWithId, getBlobField,
         * query, queryMore, queryAll, search, apexCall, recent, createJob,
         * getJob, closeJob, abortJob, createBatch, getBatch, getAllBatches,
         * getRequest, getResults, createBatchQuery, getQueryResultIds,
         * getQueryResult, getRecentReports, getReportDescription,
         * executeSyncReport, executeAsyncReport, getReportInstances,
         * getReportResults, limits, approval, approvals, composite-tree,
         * composite-batch, composite
         * 
         * Path parameter: topicName
         * The name of the topic/channel to use
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path operationName:topicName
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder salesforce(
                String componentName,
                String path) {
            return SalesforceEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    static SalesforceEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class SalesforceEndpointBuilderImpl extends AbstractEndpointBuilder implements SalesforceEndpointBuilder, AdvancedSalesforceEndpointBuilder {
            public SalesforceEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new SalesforceEndpointBuilderImpl(path);
    }
}