/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.HeaderFilterStrategy;

/**
 * Send and receive messages to/from a JMS Queue or Topic using plain JMS 2.x
 * API.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface Sjms2EndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Simple JMS2 component.
     */
    public interface Sjms2EndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedSjms2EndpointConsumerBuilder advanced() {
            return (AdvancedSjms2EndpointConsumerBuilder) this;
        }
        /**
         * The JMS acknowledgement name, which is one of: SESSION_TRANSACTED,
         * CLIENT_ACKNOWLEDGE, AUTO_ACKNOWLEDGE, DUPS_OK_ACKNOWLEDGE.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.sjms.jms.SessionAcknowledgementType&lt;/code&gt; type.
         * 
         * Default: AUTO_ACKNOWLEDGE
         * Group: common
         * 
         * @param acknowledgementMode the value to set
         * @return the dsl builder
         */
        default Sjms2EndpointConsumerBuilder acknowledgementMode(
                SessionAcknowledgementType acknowledgementMode) {
            doSetProperty("acknowledgementMode", acknowledgementMode);
            return this;
        }
        /**
         * The JMS acknowledgement name, which is one of: SESSION_TRANSACTED,
         * CLIENT_ACKNOWLEDGE, AUTO_ACKNOWLEDGE, DUPS_OK_ACKNOWLEDGE.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.sjms.jms.SessionAcknowledgementType&lt;/code&gt; type.
         * 
         * Default: AUTO_ACKNOWLEDGE
         * Group: common
         * 
         * @param acknowledgementMode the value to set
         * @return the dsl builder
         */
        default Sjms2EndpointConsumerBuilder acknowledgementMode(
                String acknowledgementMode) {
            doSetProperty("acknowledgementMode", acknowledgementMode);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default Sjms2EndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default Sjms2EndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Sets the number of consumer listeners used for this endpoint.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: consumer
         * 
         * @param consumerCount the value to set
         * @return the dsl builder
         */
        default Sjms2EndpointConsumerBuilder consumerCount(int consumerCount) {
            doSetProperty("consumerCount", consumerCount);
            return this;
        }
        /**
         * Sets the number of consumer listeners used for this endpoint.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: consumer
         * 
         * @param consumerCount the value to set
         * @return the dsl builder
         */
        default Sjms2EndpointConsumerBuilder consumerCount(String consumerCount) {
            doSetProperty("consumerCount", consumerCount);
            return this;
        }
        /**
         * Sets topic consumer to durable.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param durable the value to set
         * @return the dsl builder
         */
        default Sjms2EndpointConsumerBuilder durable(boolean durable) {
            doSetProperty("durable", durable);
            return this;
        }
        /**
         * Sets topic consumer to durable.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param durable the value to set
         * @return the dsl builder
         */
        default Sjms2EndpointConsumerBuilder durable(String durable) {
            doSetProperty("durable", durable);
            return this;
        }
        /**
         * Sets the durable subscription Id required for durable topics.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param durableSubscriptionId the value to set
         * @return the dsl builder
         */
        default Sjms2EndpointConsumerBuilder durableSubscriptionId(
                String durableSubscriptionId) {
            doSetProperty("durableSubscriptionId", durableSubscriptionId);
            return this;
        }
        /**
         * Backoff in millis on consumer pool reconnection attempts.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 5000
         * Group: consumer
         * 
         * @param reconnectBackOff the value to set
         * @return the dsl builder
         */
        default Sjms2EndpointConsumerBuilder reconnectBackOff(
                long reconnectBackOff) {
            doSetProperty("reconnectBackOff", reconnectBackOff);
            return this;
        }
        /**
         * Backoff in millis on consumer pool reconnection attempts.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 5000
         * Group: consumer
         * 
         * @param reconnectBackOff the value to set
         * @return the dsl builder
         */
        default Sjms2EndpointConsumerBuilder reconnectBackOff(
                String reconnectBackOff) {
            doSetProperty("reconnectBackOff", reconnectBackOff);
            return this;
        }
        /**
         * Try to apply reconnection logic on consumer pool.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param reconnectOnError the value to set
         * @return the dsl builder
         */
        default Sjms2EndpointConsumerBuilder reconnectOnError(
                boolean reconnectOnError) {
            doSetProperty("reconnectOnError", reconnectOnError);
            return this;
        }
        /**
         * Try to apply reconnection logic on consumer pool.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param reconnectOnError the value to set
         * @return the dsl builder
         */
        default Sjms2EndpointConsumerBuilder reconnectOnError(
                String reconnectOnError) {
            doSetProperty("reconnectOnError", reconnectOnError);
            return this;
        }
        /**
         * Sets the consumer to shared.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param shared the value to set
         * @return the dsl builder
         */
        default Sjms2EndpointConsumerBuilder shared(boolean shared) {
            doSetProperty("shared", shared);
            return this;
        }
        /**
         * Sets the consumer to shared.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param shared the value to set
         * @return the dsl builder
         */
        default Sjms2EndpointConsumerBuilder shared(String shared) {
            doSetProperty("shared", shared);
            return this;
        }
        /**
         * Sets the subscription Id, required for durable or shared topics.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param subscriptionId the value to set
         * @return the dsl builder
         */
        default Sjms2EndpointConsumerBuilder subscriptionId(
                String subscriptionId) {
            doSetProperty("subscriptionId", subscriptionId);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default Sjms2EndpointConsumerBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default Sjms2EndpointConsumerBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Allows to configure the default errorHandler logging level for
         * logging uncaught exceptions.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: WARN
         * Group: logging
         * 
         * @param errorHandlerLoggingLevel the value to set
         * @return the dsl builder
         */
        default Sjms2EndpointConsumerBuilder errorHandlerLoggingLevel(
                LoggingLevel errorHandlerLoggingLevel) {
            doSetProperty("errorHandlerLoggingLevel", errorHandlerLoggingLevel);
            return this;
        }
        /**
         * Allows to configure the default errorHandler logging level for
         * logging uncaught exceptions.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: WARN
         * Group: logging
         * 
         * @param errorHandlerLoggingLevel the value to set
         * @return the dsl builder
         */
        default Sjms2EndpointConsumerBuilder errorHandlerLoggingLevel(
                String errorHandlerLoggingLevel) {
            doSetProperty("errorHandlerLoggingLevel", errorHandlerLoggingLevel);
            return this;
        }
        /**
         * Allows to control whether stacktraces should be logged or not, by the
         * default errorHandler.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: logging
         * 
         * @param errorHandlerLogStackTrace the value to set
         * @return the dsl builder
         */
        default Sjms2EndpointConsumerBuilder errorHandlerLogStackTrace(
                boolean errorHandlerLogStackTrace) {
            doSetProperty("errorHandlerLogStackTrace", errorHandlerLogStackTrace);
            return this;
        }
        /**
         * Allows to control whether stacktraces should be logged or not, by the
         * default errorHandler.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: logging
         * 
         * @param errorHandlerLogStackTrace the value to set
         * @return the dsl builder
         */
        default Sjms2EndpointConsumerBuilder errorHandlerLogStackTrace(
                String errorHandlerLogStackTrace) {
            doSetProperty("errorHandlerLogStackTrace", errorHandlerLogStackTrace);
            return this;
        }
        /**
         * Specifies whether to use transacted mode.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: transaction
         * 
         * @param transacted the value to set
         * @return the dsl builder
         */
        default Sjms2EndpointConsumerBuilder transacted(boolean transacted) {
            doSetProperty("transacted", transacted);
            return this;
        }
        /**
         * Specifies whether to use transacted mode.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: transaction
         * 
         * @param transacted the value to set
         * @return the dsl builder
         */
        default Sjms2EndpointConsumerBuilder transacted(String transacted) {
            doSetProperty("transacted", transacted);
            return this;
        }
        /**
         * If transacted sets the number of messages to process before
         * committing a transaction.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: transaction
         * 
         * @param transactionBatchCount the value to set
         * @return the dsl builder
         */
        @Deprecated
        default Sjms2EndpointConsumerBuilder transactionBatchCount(
                int transactionBatchCount) {
            doSetProperty("transactionBatchCount", transactionBatchCount);
            return this;
        }
        /**
         * If transacted sets the number of messages to process before
         * committing a transaction.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: transaction
         * 
         * @param transactionBatchCount the value to set
         * @return the dsl builder
         */
        @Deprecated
        default Sjms2EndpointConsumerBuilder transactionBatchCount(
                String transactionBatchCount) {
            doSetProperty("transactionBatchCount", transactionBatchCount);
            return this;
        }
        /**
         * Sets timeout (in millis) for batch transactions, the value should be
         * 1000 or higher.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 5s
         * Group: transaction
         * 
         * @param transactionBatchTimeout the value to set
         * @return the dsl builder
         */
        @Deprecated
        default Sjms2EndpointConsumerBuilder transactionBatchTimeout(
                long transactionBatchTimeout) {
            doSetProperty("transactionBatchTimeout", transactionBatchTimeout);
            return this;
        }
        /**
         * Sets timeout (in millis) for batch transactions, the value should be
         * 1000 or higher.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 5s
         * Group: transaction
         * 
         * @param transactionBatchTimeout the value to set
         * @return the dsl builder
         */
        @Deprecated
        default Sjms2EndpointConsumerBuilder transactionBatchTimeout(
                String transactionBatchTimeout) {
            doSetProperty("transactionBatchTimeout", transactionBatchTimeout);
            return this;
        }
        /**
         * Sets the commit strategy.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.sjms.TransactionCommitStrategy&lt;/code&gt; type.
         * 
         * Group: transaction
         * 
         * @param transactionCommitStrategy the value to set
         * @return the dsl builder
         */
        default Sjms2EndpointConsumerBuilder transactionCommitStrategy(
                Object transactionCommitStrategy) {
            doSetProperty("transactionCommitStrategy", transactionCommitStrategy);
            return this;
        }
        /**
         * Sets the commit strategy.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.sjms.TransactionCommitStrategy&lt;/code&gt; type.
         * 
         * Group: transaction
         * 
         * @param transactionCommitStrategy the value to set
         * @return the dsl builder
         */
        default Sjms2EndpointConsumerBuilder transactionCommitStrategy(
                String transactionCommitStrategy) {
            doSetProperty("transactionCommitStrategy", transactionCommitStrategy);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Simple JMS2 component.
     */
    public interface AdvancedSjms2EndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default Sjms2EndpointConsumerBuilder basic() {
            return (Sjms2EndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the JMS Message selector syntax.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param messageSelector the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointConsumerBuilder messageSelector(
                String messageSelector) {
            doSetProperty("messageSelector", messageSelector);
            return this;
        }
        /**
         * Whether to startup the consumer message listener asynchronously, when
         * starting a route. For example if a JmsConsumer cannot get a
         * connection to a remote JMS broker, then it may block while retrying
         * and/or failover. This will cause Camel to block while starting
         * routes. By setting this option to true, you will let routes startup,
         * while the JmsConsumer connects to the JMS broker using a dedicated
         * thread in asynchronous mode. If this option is used, then beware that
         * if the connection could not be established, then an exception is
         * logged at WARN level, and the consumer will not be able to receive
         * messages; You can then restart the route to retry.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param asyncStartListener the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointConsumerBuilder asyncStartListener(
                boolean asyncStartListener) {
            doSetProperty("asyncStartListener", asyncStartListener);
            return this;
        }
        /**
         * Whether to startup the consumer message listener asynchronously, when
         * starting a route. For example if a JmsConsumer cannot get a
         * connection to a remote JMS broker, then it may block while retrying
         * and/or failover. This will cause Camel to block while starting
         * routes. By setting this option to true, you will let routes startup,
         * while the JmsConsumer connects to the JMS broker using a dedicated
         * thread in asynchronous mode. If this option is used, then beware that
         * if the connection could not be established, then an exception is
         * logged at WARN level, and the consumer will not be able to receive
         * messages; You can then restart the route to retry.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param asyncStartListener the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointConsumerBuilder asyncStartListener(
                String asyncStartListener) {
            doSetProperty("asyncStartListener", asyncStartListener);
            return this;
        }
        /**
         * Whether to stop the consumer message listener asynchronously, when
         * stopping a route.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param asyncStopListener the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointConsumerBuilder asyncStopListener(
                boolean asyncStopListener) {
            doSetProperty("asyncStopListener", asyncStopListener);
            return this;
        }
        /**
         * Whether to stop the consumer message listener asynchronously, when
         * stopping a route.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param asyncStopListener the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointConsumerBuilder asyncStopListener(
                String asyncStopListener) {
            doSetProperty("asyncStopListener", asyncStopListener);
            return this;
        }
        /**
         * The maximum number of connections available to this endpoint.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param connectionCount the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointConsumerBuilder connectionCount(
                Integer connectionCount) {
            doSetProperty("connectionCount", connectionCount);
            return this;
        }
        /**
         * The maximum number of connections available to this endpoint.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param connectionCount the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointConsumerBuilder connectionCount(
                String connectionCount) {
            doSetProperty("connectionCount", connectionCount);
            return this;
        }
        /**
         * Initializes the connectionFactory for the endpoint, which takes
         * precedence over the component's connectionFactory, if any.
         * 
         * The option is a: &lt;code&gt;javax.jms.ConnectionFactory&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param connectionFactory the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointConsumerBuilder connectionFactory(
                Object connectionFactory) {
            doSetProperty("connectionFactory", connectionFactory);
            return this;
        }
        /**
         * Initializes the connectionFactory for the endpoint, which takes
         * precedence over the component's connectionFactory, if any.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.jms.ConnectionFactory&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param connectionFactory the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointConsumerBuilder connectionFactory(
                String connectionFactory) {
            doSetProperty("connectionFactory", connectionFactory);
            return this;
        }
        /**
         * Initializes the connectionResource for the endpoint, which takes
         * precedence over the component's connectionResource, if any.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.sjms.jms.ConnectionResource&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param connectionResource the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointConsumerBuilder connectionResource(
                Object connectionResource) {
            doSetProperty("connectionResource", connectionResource);
            return this;
        }
        /**
         * Initializes the connectionResource for the endpoint, which takes
         * precedence over the component's connectionResource, if any.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.sjms.jms.ConnectionResource&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param connectionResource the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointConsumerBuilder connectionResource(
                String connectionResource) {
            doSetProperty("connectionResource", connectionResource);
            return this;
        }
        /**
         * To use a custom DestinationCreationStrategy.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.sjms.jms.DestinationCreationStrategy&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param destinationCreationStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointConsumerBuilder destinationCreationStrategy(
                Object destinationCreationStrategy) {
            doSetProperty("destinationCreationStrategy", destinationCreationStrategy);
            return this;
        }
        /**
         * To use a custom DestinationCreationStrategy.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.sjms.jms.DestinationCreationStrategy&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param destinationCreationStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointConsumerBuilder destinationCreationStrategy(
                String destinationCreationStrategy) {
            doSetProperty("destinationCreationStrategy", destinationCreationStrategy);
            return this;
        }
        /**
         * Specifies the JMS Exception Listener that is to be notified of any
         * underlying JMS exceptions.
         * 
         * The option is a: &lt;code&gt;javax.jms.ExceptionListener&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param exceptionListener the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointConsumerBuilder exceptionListener(
                Object exceptionListener) {
            doSetProperty("exceptionListener", exceptionListener);
            return this;
        }
        /**
         * Specifies the JMS Exception Listener that is to be notified of any
         * underlying JMS exceptions.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.jms.ExceptionListener&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param exceptionListener the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointConsumerBuilder exceptionListener(
                String exceptionListener) {
            doSetProperty("exceptionListener", exceptionListener);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointConsumerBuilder headerFilterStrategy(
                HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointConsumerBuilder headerFilterStrategy(
                String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * Whether to include all JMSXxxx properties when mapping from JMS to
         * Camel Message. Setting this to true will include properties such as
         * JMSXAppID, and JMSXUserID etc. Note: If you are using a custom
         * headerFilterStrategy then this option does not apply.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param includeAllJMSXProperties the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointConsumerBuilder includeAllJMSXProperties(
                boolean includeAllJMSXProperties) {
            doSetProperty("includeAllJMSXProperties", includeAllJMSXProperties);
            return this;
        }
        /**
         * Whether to include all JMSXxxx properties when mapping from JMS to
         * Camel Message. Setting this to true will include properties such as
         * JMSXAppID, and JMSXUserID etc. Note: If you are using a custom
         * headerFilterStrategy then this option does not apply.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param includeAllJMSXProperties the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointConsumerBuilder includeAllJMSXProperties(
                String includeAllJMSXProperties) {
            doSetProperty("includeAllJMSXProperties", includeAllJMSXProperties);
            return this;
        }
        /**
         * Pluggable strategy for encoding and decoding JMS keys so they can be
         * compliant with the JMS specification. Camel provides two
         * implementations out of the box: default and passthrough. The default
         * strategy will safely marshal dots and hyphens (. and -). The
         * passthrough strategy leaves the key as is. Can be used for JMS
         * brokers which do not care whether JMS header keys contain illegal
         * characters. You can provide your own implementation of the
         * org.apache.camel.component.jms.JmsKeyFormatStrategy and refer to it
         * using the # notation.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.sjms.jms.JmsKeyFormatStrategy&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param jmsKeyFormatStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointConsumerBuilder jmsKeyFormatStrategy(
                Object jmsKeyFormatStrategy) {
            doSetProperty("jmsKeyFormatStrategy", jmsKeyFormatStrategy);
            return this;
        }
        /**
         * Pluggable strategy for encoding and decoding JMS keys so they can be
         * compliant with the JMS specification. Camel provides two
         * implementations out of the box: default and passthrough. The default
         * strategy will safely marshal dots and hyphens (. and -). The
         * passthrough strategy leaves the key as is. Can be used for JMS
         * brokers which do not care whether JMS header keys contain illegal
         * characters. You can provide your own implementation of the
         * org.apache.camel.component.jms.JmsKeyFormatStrategy and refer to it
         * using the # notation.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.sjms.jms.JmsKeyFormatStrategy&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param jmsKeyFormatStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointConsumerBuilder jmsKeyFormatStrategy(
                String jmsKeyFormatStrategy) {
            doSetProperty("jmsKeyFormatStrategy", jmsKeyFormatStrategy);
            return this;
        }
        /**
         * Specifies whether Camel should auto map the received JMS message to a
         * suited payload type, such as javax.jms.TextMessage to a String etc.
         * See section about how mapping works below for more details.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param mapJmsMessage the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointConsumerBuilder mapJmsMessage(
                boolean mapJmsMessage) {
            doSetProperty("mapJmsMessage", mapJmsMessage);
            return this;
        }
        /**
         * Specifies whether Camel should auto map the received JMS message to a
         * suited payload type, such as javax.jms.TextMessage to a String etc.
         * See section about how mapping works below for more details.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param mapJmsMessage the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointConsumerBuilder mapJmsMessage(
                String mapJmsMessage) {
            doSetProperty("mapJmsMessage", mapJmsMessage);
            return this;
        }
        /**
         * To use the given MessageCreatedStrategy which are invoked when Camel
         * creates new instances of javax.jms.Message objects when Camel is
         * sending a JMS message.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.sjms.jms.MessageCreatedStrategy&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param messageCreatedStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointConsumerBuilder messageCreatedStrategy(
                Object messageCreatedStrategy) {
            doSetProperty("messageCreatedStrategy", messageCreatedStrategy);
            return this;
        }
        /**
         * To use the given MessageCreatedStrategy which are invoked when Camel
         * creates new instances of javax.jms.Message objects when Camel is
         * sending a JMS message.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.sjms.jms.MessageCreatedStrategy&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param messageCreatedStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointConsumerBuilder messageCreatedStrategy(
                String messageCreatedStrategy) {
            doSetProperty("messageCreatedStrategy", messageCreatedStrategy);
            return this;
        }
        /**
         * Specifies whether to share JMS session with other SJMS endpoints.
         * Turn this off if your route is accessing to multiple JMS providers.
         * If you need transaction against multiple JMS providers, use jms
         * component to leverage XA transaction.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: transaction (advanced)
         * 
         * @param sharedJMSSession the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointConsumerBuilder sharedJMSSession(
                boolean sharedJMSSession) {
            doSetProperty("sharedJMSSession", sharedJMSSession);
            return this;
        }
        /**
         * Specifies whether to share JMS session with other SJMS endpoints.
         * Turn this off if your route is accessing to multiple JMS providers.
         * If you need transaction against multiple JMS providers, use jms
         * component to leverage XA transaction.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: transaction (advanced)
         * 
         * @param sharedJMSSession the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointConsumerBuilder sharedJMSSession(
                String sharedJMSSession) {
            doSetProperty("sharedJMSSession", sharedJMSSession);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Simple JMS2 component.
     */
    public interface Sjms2EndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedSjms2EndpointProducerBuilder advanced() {
            return (AdvancedSjms2EndpointProducerBuilder) this;
        }
        /**
         * The JMS acknowledgement name, which is one of: SESSION_TRANSACTED,
         * CLIENT_ACKNOWLEDGE, AUTO_ACKNOWLEDGE, DUPS_OK_ACKNOWLEDGE.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.sjms.jms.SessionAcknowledgementType&lt;/code&gt; type.
         * 
         * Default: AUTO_ACKNOWLEDGE
         * Group: common
         * 
         * @param acknowledgementMode the value to set
         * @return the dsl builder
         */
        default Sjms2EndpointProducerBuilder acknowledgementMode(
                SessionAcknowledgementType acknowledgementMode) {
            doSetProperty("acknowledgementMode", acknowledgementMode);
            return this;
        }
        /**
         * The JMS acknowledgement name, which is one of: SESSION_TRANSACTED,
         * CLIENT_ACKNOWLEDGE, AUTO_ACKNOWLEDGE, DUPS_OK_ACKNOWLEDGE.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.sjms.jms.SessionAcknowledgementType&lt;/code&gt; type.
         * 
         * Default: AUTO_ACKNOWLEDGE
         * Group: common
         * 
         * @param acknowledgementMode the value to set
         * @return the dsl builder
         */
        default Sjms2EndpointProducerBuilder acknowledgementMode(
                String acknowledgementMode) {
            doSetProperty("acknowledgementMode", acknowledgementMode);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default Sjms2EndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default Sjms2EndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Sets the reply to destination name used for InOut producer endpoints.
         * The type of the reply to destination can be determined by the
         * starting prefix (topic: or queue:) in its name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param namedReplyTo the value to set
         * @return the dsl builder
         */
        default Sjms2EndpointProducerBuilder namedReplyTo(String namedReplyTo) {
            doSetProperty("namedReplyTo", namedReplyTo);
            return this;
        }
        /**
         * Flag used to enable/disable message persistence.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param persistent the value to set
         * @return the dsl builder
         */
        default Sjms2EndpointProducerBuilder persistent(boolean persistent) {
            doSetProperty("persistent", persistent);
            return this;
        }
        /**
         * Flag used to enable/disable message persistence.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param persistent the value to set
         * @return the dsl builder
         */
        default Sjms2EndpointProducerBuilder persistent(String persistent) {
            doSetProperty("persistent", persistent);
            return this;
        }
        /**
         * Sets the number of producers used for this endpoint.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: producer
         * 
         * @param producerCount the value to set
         * @return the dsl builder
         */
        default Sjms2EndpointProducerBuilder producerCount(int producerCount) {
            doSetProperty("producerCount", producerCount);
            return this;
        }
        /**
         * Sets the number of producers used for this endpoint.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: producer
         * 
         * @param producerCount the value to set
         * @return the dsl builder
         */
        default Sjms2EndpointProducerBuilder producerCount(String producerCount) {
            doSetProperty("producerCount", producerCount);
            return this;
        }
        /**
         * Flag used to adjust the Time To Live value of produced messages.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: producer
         * 
         * @param ttl the value to set
         * @return the dsl builder
         */
        default Sjms2EndpointProducerBuilder ttl(long ttl) {
            doSetProperty("ttl", ttl);
            return this;
        }
        /**
         * Flag used to adjust the Time To Live value of produced messages.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: producer
         * 
         * @param ttl the value to set
         * @return the dsl builder
         */
        default Sjms2EndpointProducerBuilder ttl(String ttl) {
            doSetProperty("ttl", ttl);
            return this;
        }
        /**
         * Sets the commit strategy.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.sjms.TransactionCommitStrategy&lt;/code&gt; type.
         * 
         * Group: transaction
         * 
         * @param transactionCommitStrategy the value to set
         * @return the dsl builder
         */
        default Sjms2EndpointProducerBuilder transactionCommitStrategy(
                Object transactionCommitStrategy) {
            doSetProperty("transactionCommitStrategy", transactionCommitStrategy);
            return this;
        }
        /**
         * Sets the commit strategy.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.sjms.TransactionCommitStrategy&lt;/code&gt; type.
         * 
         * Group: transaction
         * 
         * @param transactionCommitStrategy the value to set
         * @return the dsl builder
         */
        default Sjms2EndpointProducerBuilder transactionCommitStrategy(
                String transactionCommitStrategy) {
            doSetProperty("transactionCommitStrategy", transactionCommitStrategy);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Simple JMS2 component.
     */
    public interface AdvancedSjms2EndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default Sjms2EndpointProducerBuilder basic() {
            return (Sjms2EndpointProducerBuilder) this;
        }
        /**
         * Whether to allow sending messages with no body. If this option is
         * false and the message body is null, then an JMSException is thrown.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: producer (advanced)
         * 
         * @param allowNullBody the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointProducerBuilder allowNullBody(
                boolean allowNullBody) {
            doSetProperty("allowNullBody", allowNullBody);
            return this;
        }
        /**
         * Whether to allow sending messages with no body. If this option is
         * false and the message body is null, then an JMSException is thrown.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: producer (advanced)
         * 
         * @param allowNullBody the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointProducerBuilder allowNullBody(
                String allowNullBody) {
            doSetProperty("allowNullBody", allowNullBody);
            return this;
        }
        /**
         * Whether to prefill the producer connection pool on startup, or create
         * connections lazy when needed.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: producer (advanced)
         * 
         * @param prefillPool the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointProducerBuilder prefillPool(
                boolean prefillPool) {
            doSetProperty("prefillPool", prefillPool);
            return this;
        }
        /**
         * Whether to prefill the producer connection pool on startup, or create
         * connections lazy when needed.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: producer (advanced)
         * 
         * @param prefillPool the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointProducerBuilder prefillPool(
                String prefillPool) {
            doSetProperty("prefillPool", prefillPool);
            return this;
        }
        /**
         * Sets the amount of time we should wait before timing out a InOut
         * response.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 5s
         * Group: producer (advanced)
         * 
         * @param responseTimeOut the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointProducerBuilder responseTimeOut(
                long responseTimeOut) {
            doSetProperty("responseTimeOut", responseTimeOut);
            return this;
        }
        /**
         * Sets the amount of time we should wait before timing out a InOut
         * response.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 5s
         * Group: producer (advanced)
         * 
         * @param responseTimeOut the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointProducerBuilder responseTimeOut(
                String responseTimeOut) {
            doSetProperty("responseTimeOut", responseTimeOut);
            return this;
        }
        /**
         * Whether to startup the consumer message listener asynchronously, when
         * starting a route. For example if a JmsConsumer cannot get a
         * connection to a remote JMS broker, then it may block while retrying
         * and/or failover. This will cause Camel to block while starting
         * routes. By setting this option to true, you will let routes startup,
         * while the JmsConsumer connects to the JMS broker using a dedicated
         * thread in asynchronous mode. If this option is used, then beware that
         * if the connection could not be established, then an exception is
         * logged at WARN level, and the consumer will not be able to receive
         * messages; You can then restart the route to retry.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param asyncStartListener the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointProducerBuilder asyncStartListener(
                boolean asyncStartListener) {
            doSetProperty("asyncStartListener", asyncStartListener);
            return this;
        }
        /**
         * Whether to startup the consumer message listener asynchronously, when
         * starting a route. For example if a JmsConsumer cannot get a
         * connection to a remote JMS broker, then it may block while retrying
         * and/or failover. This will cause Camel to block while starting
         * routes. By setting this option to true, you will let routes startup,
         * while the JmsConsumer connects to the JMS broker using a dedicated
         * thread in asynchronous mode. If this option is used, then beware that
         * if the connection could not be established, then an exception is
         * logged at WARN level, and the consumer will not be able to receive
         * messages; You can then restart the route to retry.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param asyncStartListener the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointProducerBuilder asyncStartListener(
                String asyncStartListener) {
            doSetProperty("asyncStartListener", asyncStartListener);
            return this;
        }
        /**
         * Whether to stop the consumer message listener asynchronously, when
         * stopping a route.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param asyncStopListener the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointProducerBuilder asyncStopListener(
                boolean asyncStopListener) {
            doSetProperty("asyncStopListener", asyncStopListener);
            return this;
        }
        /**
         * Whether to stop the consumer message listener asynchronously, when
         * stopping a route.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param asyncStopListener the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointProducerBuilder asyncStopListener(
                String asyncStopListener) {
            doSetProperty("asyncStopListener", asyncStopListener);
            return this;
        }
        /**
         * The maximum number of connections available to this endpoint.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param connectionCount the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointProducerBuilder connectionCount(
                Integer connectionCount) {
            doSetProperty("connectionCount", connectionCount);
            return this;
        }
        /**
         * The maximum number of connections available to this endpoint.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param connectionCount the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointProducerBuilder connectionCount(
                String connectionCount) {
            doSetProperty("connectionCount", connectionCount);
            return this;
        }
        /**
         * Initializes the connectionFactory for the endpoint, which takes
         * precedence over the component's connectionFactory, if any.
         * 
         * The option is a: &lt;code&gt;javax.jms.ConnectionFactory&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param connectionFactory the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointProducerBuilder connectionFactory(
                Object connectionFactory) {
            doSetProperty("connectionFactory", connectionFactory);
            return this;
        }
        /**
         * Initializes the connectionFactory for the endpoint, which takes
         * precedence over the component's connectionFactory, if any.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.jms.ConnectionFactory&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param connectionFactory the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointProducerBuilder connectionFactory(
                String connectionFactory) {
            doSetProperty("connectionFactory", connectionFactory);
            return this;
        }
        /**
         * Initializes the connectionResource for the endpoint, which takes
         * precedence over the component's connectionResource, if any.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.sjms.jms.ConnectionResource&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param connectionResource the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointProducerBuilder connectionResource(
                Object connectionResource) {
            doSetProperty("connectionResource", connectionResource);
            return this;
        }
        /**
         * Initializes the connectionResource for the endpoint, which takes
         * precedence over the component's connectionResource, if any.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.sjms.jms.ConnectionResource&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param connectionResource the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointProducerBuilder connectionResource(
                String connectionResource) {
            doSetProperty("connectionResource", connectionResource);
            return this;
        }
        /**
         * To use a custom DestinationCreationStrategy.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.sjms.jms.DestinationCreationStrategy&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param destinationCreationStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointProducerBuilder destinationCreationStrategy(
                Object destinationCreationStrategy) {
            doSetProperty("destinationCreationStrategy", destinationCreationStrategy);
            return this;
        }
        /**
         * To use a custom DestinationCreationStrategy.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.sjms.jms.DestinationCreationStrategy&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param destinationCreationStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointProducerBuilder destinationCreationStrategy(
                String destinationCreationStrategy) {
            doSetProperty("destinationCreationStrategy", destinationCreationStrategy);
            return this;
        }
        /**
         * Specifies the JMS Exception Listener that is to be notified of any
         * underlying JMS exceptions.
         * 
         * The option is a: &lt;code&gt;javax.jms.ExceptionListener&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param exceptionListener the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointProducerBuilder exceptionListener(
                Object exceptionListener) {
            doSetProperty("exceptionListener", exceptionListener);
            return this;
        }
        /**
         * Specifies the JMS Exception Listener that is to be notified of any
         * underlying JMS exceptions.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.jms.ExceptionListener&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param exceptionListener the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointProducerBuilder exceptionListener(
                String exceptionListener) {
            doSetProperty("exceptionListener", exceptionListener);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointProducerBuilder headerFilterStrategy(
                HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointProducerBuilder headerFilterStrategy(
                String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * Whether to include all JMSXxxx properties when mapping from JMS to
         * Camel Message. Setting this to true will include properties such as
         * JMSXAppID, and JMSXUserID etc. Note: If you are using a custom
         * headerFilterStrategy then this option does not apply.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param includeAllJMSXProperties the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointProducerBuilder includeAllJMSXProperties(
                boolean includeAllJMSXProperties) {
            doSetProperty("includeAllJMSXProperties", includeAllJMSXProperties);
            return this;
        }
        /**
         * Whether to include all JMSXxxx properties when mapping from JMS to
         * Camel Message. Setting this to true will include properties such as
         * JMSXAppID, and JMSXUserID etc. Note: If you are using a custom
         * headerFilterStrategy then this option does not apply.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param includeAllJMSXProperties the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointProducerBuilder includeAllJMSXProperties(
                String includeAllJMSXProperties) {
            doSetProperty("includeAllJMSXProperties", includeAllJMSXProperties);
            return this;
        }
        /**
         * Pluggable strategy for encoding and decoding JMS keys so they can be
         * compliant with the JMS specification. Camel provides two
         * implementations out of the box: default and passthrough. The default
         * strategy will safely marshal dots and hyphens (. and -). The
         * passthrough strategy leaves the key as is. Can be used for JMS
         * brokers which do not care whether JMS header keys contain illegal
         * characters. You can provide your own implementation of the
         * org.apache.camel.component.jms.JmsKeyFormatStrategy and refer to it
         * using the # notation.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.sjms.jms.JmsKeyFormatStrategy&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param jmsKeyFormatStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointProducerBuilder jmsKeyFormatStrategy(
                Object jmsKeyFormatStrategy) {
            doSetProperty("jmsKeyFormatStrategy", jmsKeyFormatStrategy);
            return this;
        }
        /**
         * Pluggable strategy for encoding and decoding JMS keys so they can be
         * compliant with the JMS specification. Camel provides two
         * implementations out of the box: default and passthrough. The default
         * strategy will safely marshal dots and hyphens (. and -). The
         * passthrough strategy leaves the key as is. Can be used for JMS
         * brokers which do not care whether JMS header keys contain illegal
         * characters. You can provide your own implementation of the
         * org.apache.camel.component.jms.JmsKeyFormatStrategy and refer to it
         * using the # notation.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.sjms.jms.JmsKeyFormatStrategy&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param jmsKeyFormatStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointProducerBuilder jmsKeyFormatStrategy(
                String jmsKeyFormatStrategy) {
            doSetProperty("jmsKeyFormatStrategy", jmsKeyFormatStrategy);
            return this;
        }
        /**
         * Specifies whether Camel should auto map the received JMS message to a
         * suited payload type, such as javax.jms.TextMessage to a String etc.
         * See section about how mapping works below for more details.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param mapJmsMessage the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointProducerBuilder mapJmsMessage(
                boolean mapJmsMessage) {
            doSetProperty("mapJmsMessage", mapJmsMessage);
            return this;
        }
        /**
         * Specifies whether Camel should auto map the received JMS message to a
         * suited payload type, such as javax.jms.TextMessage to a String etc.
         * See section about how mapping works below for more details.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param mapJmsMessage the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointProducerBuilder mapJmsMessage(
                String mapJmsMessage) {
            doSetProperty("mapJmsMessage", mapJmsMessage);
            return this;
        }
        /**
         * To use the given MessageCreatedStrategy which are invoked when Camel
         * creates new instances of javax.jms.Message objects when Camel is
         * sending a JMS message.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.sjms.jms.MessageCreatedStrategy&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param messageCreatedStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointProducerBuilder messageCreatedStrategy(
                Object messageCreatedStrategy) {
            doSetProperty("messageCreatedStrategy", messageCreatedStrategy);
            return this;
        }
        /**
         * To use the given MessageCreatedStrategy which are invoked when Camel
         * creates new instances of javax.jms.Message objects when Camel is
         * sending a JMS message.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.sjms.jms.MessageCreatedStrategy&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param messageCreatedStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointProducerBuilder messageCreatedStrategy(
                String messageCreatedStrategy) {
            doSetProperty("messageCreatedStrategy", messageCreatedStrategy);
            return this;
        }
        /**
         * Specifies whether to share JMS session with other SJMS endpoints.
         * Turn this off if your route is accessing to multiple JMS providers.
         * If you need transaction against multiple JMS providers, use jms
         * component to leverage XA transaction.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: transaction (advanced)
         * 
         * @param sharedJMSSession the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointProducerBuilder sharedJMSSession(
                boolean sharedJMSSession) {
            doSetProperty("sharedJMSSession", sharedJMSSession);
            return this;
        }
        /**
         * Specifies whether to share JMS session with other SJMS endpoints.
         * Turn this off if your route is accessing to multiple JMS providers.
         * If you need transaction against multiple JMS providers, use jms
         * component to leverage XA transaction.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: transaction (advanced)
         * 
         * @param sharedJMSSession the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointProducerBuilder sharedJMSSession(
                String sharedJMSSession) {
            doSetProperty("sharedJMSSession", sharedJMSSession);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Simple JMS2 component.
     */
    public interface Sjms2EndpointBuilder
            extends
                Sjms2EndpointConsumerBuilder,
                Sjms2EndpointProducerBuilder {
        default AdvancedSjms2EndpointBuilder advanced() {
            return (AdvancedSjms2EndpointBuilder) this;
        }
        /**
         * The JMS acknowledgement name, which is one of: SESSION_TRANSACTED,
         * CLIENT_ACKNOWLEDGE, AUTO_ACKNOWLEDGE, DUPS_OK_ACKNOWLEDGE.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.sjms.jms.SessionAcknowledgementType&lt;/code&gt; type.
         * 
         * Default: AUTO_ACKNOWLEDGE
         * Group: common
         * 
         * @param acknowledgementMode the value to set
         * @return the dsl builder
         */
        default Sjms2EndpointBuilder acknowledgementMode(
                SessionAcknowledgementType acknowledgementMode) {
            doSetProperty("acknowledgementMode", acknowledgementMode);
            return this;
        }
        /**
         * The JMS acknowledgement name, which is one of: SESSION_TRANSACTED,
         * CLIENT_ACKNOWLEDGE, AUTO_ACKNOWLEDGE, DUPS_OK_ACKNOWLEDGE.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.sjms.jms.SessionAcknowledgementType&lt;/code&gt; type.
         * 
         * Default: AUTO_ACKNOWLEDGE
         * Group: common
         * 
         * @param acknowledgementMode the value to set
         * @return the dsl builder
         */
        default Sjms2EndpointBuilder acknowledgementMode(
                String acknowledgementMode) {
            doSetProperty("acknowledgementMode", acknowledgementMode);
            return this;
        }
        /**
         * Sets the commit strategy.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.sjms.TransactionCommitStrategy&lt;/code&gt; type.
         * 
         * Group: transaction
         * 
         * @param transactionCommitStrategy the value to set
         * @return the dsl builder
         */
        default Sjms2EndpointBuilder transactionCommitStrategy(
                Object transactionCommitStrategy) {
            doSetProperty("transactionCommitStrategy", transactionCommitStrategy);
            return this;
        }
        /**
         * Sets the commit strategy.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.sjms.TransactionCommitStrategy&lt;/code&gt; type.
         * 
         * Group: transaction
         * 
         * @param transactionCommitStrategy the value to set
         * @return the dsl builder
         */
        default Sjms2EndpointBuilder transactionCommitStrategy(
                String transactionCommitStrategy) {
            doSetProperty("transactionCommitStrategy", transactionCommitStrategy);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Simple JMS2 component.
     */
    public interface AdvancedSjms2EndpointBuilder
            extends
                AdvancedSjms2EndpointConsumerBuilder,
                AdvancedSjms2EndpointProducerBuilder {
        default Sjms2EndpointBuilder basic() {
            return (Sjms2EndpointBuilder) this;
        }
        /**
         * Whether to startup the consumer message listener asynchronously, when
         * starting a route. For example if a JmsConsumer cannot get a
         * connection to a remote JMS broker, then it may block while retrying
         * and/or failover. This will cause Camel to block while starting
         * routes. By setting this option to true, you will let routes startup,
         * while the JmsConsumer connects to the JMS broker using a dedicated
         * thread in asynchronous mode. If this option is used, then beware that
         * if the connection could not be established, then an exception is
         * logged at WARN level, and the consumer will not be able to receive
         * messages; You can then restart the route to retry.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param asyncStartListener the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointBuilder asyncStartListener(
                boolean asyncStartListener) {
            doSetProperty("asyncStartListener", asyncStartListener);
            return this;
        }
        /**
         * Whether to startup the consumer message listener asynchronously, when
         * starting a route. For example if a JmsConsumer cannot get a
         * connection to a remote JMS broker, then it may block while retrying
         * and/or failover. This will cause Camel to block while starting
         * routes. By setting this option to true, you will let routes startup,
         * while the JmsConsumer connects to the JMS broker using a dedicated
         * thread in asynchronous mode. If this option is used, then beware that
         * if the connection could not be established, then an exception is
         * logged at WARN level, and the consumer will not be able to receive
         * messages; You can then restart the route to retry.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param asyncStartListener the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointBuilder asyncStartListener(
                String asyncStartListener) {
            doSetProperty("asyncStartListener", asyncStartListener);
            return this;
        }
        /**
         * Whether to stop the consumer message listener asynchronously, when
         * stopping a route.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param asyncStopListener the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointBuilder asyncStopListener(
                boolean asyncStopListener) {
            doSetProperty("asyncStopListener", asyncStopListener);
            return this;
        }
        /**
         * Whether to stop the consumer message listener asynchronously, when
         * stopping a route.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param asyncStopListener the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointBuilder asyncStopListener(
                String asyncStopListener) {
            doSetProperty("asyncStopListener", asyncStopListener);
            return this;
        }
        /**
         * The maximum number of connections available to this endpoint.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param connectionCount the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointBuilder connectionCount(
                Integer connectionCount) {
            doSetProperty("connectionCount", connectionCount);
            return this;
        }
        /**
         * The maximum number of connections available to this endpoint.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param connectionCount the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointBuilder connectionCount(
                String connectionCount) {
            doSetProperty("connectionCount", connectionCount);
            return this;
        }
        /**
         * Initializes the connectionFactory for the endpoint, which takes
         * precedence over the component's connectionFactory, if any.
         * 
         * The option is a: &lt;code&gt;javax.jms.ConnectionFactory&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param connectionFactory the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointBuilder connectionFactory(
                Object connectionFactory) {
            doSetProperty("connectionFactory", connectionFactory);
            return this;
        }
        /**
         * Initializes the connectionFactory for the endpoint, which takes
         * precedence over the component's connectionFactory, if any.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.jms.ConnectionFactory&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param connectionFactory the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointBuilder connectionFactory(
                String connectionFactory) {
            doSetProperty("connectionFactory", connectionFactory);
            return this;
        }
        /**
         * Initializes the connectionResource for the endpoint, which takes
         * precedence over the component's connectionResource, if any.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.sjms.jms.ConnectionResource&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param connectionResource the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointBuilder connectionResource(
                Object connectionResource) {
            doSetProperty("connectionResource", connectionResource);
            return this;
        }
        /**
         * Initializes the connectionResource for the endpoint, which takes
         * precedence over the component's connectionResource, if any.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.sjms.jms.ConnectionResource&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param connectionResource the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointBuilder connectionResource(
                String connectionResource) {
            doSetProperty("connectionResource", connectionResource);
            return this;
        }
        /**
         * To use a custom DestinationCreationStrategy.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.sjms.jms.DestinationCreationStrategy&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param destinationCreationStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointBuilder destinationCreationStrategy(
                Object destinationCreationStrategy) {
            doSetProperty("destinationCreationStrategy", destinationCreationStrategy);
            return this;
        }
        /**
         * To use a custom DestinationCreationStrategy.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.sjms.jms.DestinationCreationStrategy&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param destinationCreationStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointBuilder destinationCreationStrategy(
                String destinationCreationStrategy) {
            doSetProperty("destinationCreationStrategy", destinationCreationStrategy);
            return this;
        }
        /**
         * Specifies the JMS Exception Listener that is to be notified of any
         * underlying JMS exceptions.
         * 
         * The option is a: &lt;code&gt;javax.jms.ExceptionListener&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param exceptionListener the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointBuilder exceptionListener(
                Object exceptionListener) {
            doSetProperty("exceptionListener", exceptionListener);
            return this;
        }
        /**
         * Specifies the JMS Exception Listener that is to be notified of any
         * underlying JMS exceptions.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.jms.ExceptionListener&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param exceptionListener the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointBuilder exceptionListener(
                String exceptionListener) {
            doSetProperty("exceptionListener", exceptionListener);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointBuilder headerFilterStrategy(
                HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointBuilder headerFilterStrategy(
                String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * Whether to include all JMSXxxx properties when mapping from JMS to
         * Camel Message. Setting this to true will include properties such as
         * JMSXAppID, and JMSXUserID etc. Note: If you are using a custom
         * headerFilterStrategy then this option does not apply.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param includeAllJMSXProperties the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointBuilder includeAllJMSXProperties(
                boolean includeAllJMSXProperties) {
            doSetProperty("includeAllJMSXProperties", includeAllJMSXProperties);
            return this;
        }
        /**
         * Whether to include all JMSXxxx properties when mapping from JMS to
         * Camel Message. Setting this to true will include properties such as
         * JMSXAppID, and JMSXUserID etc. Note: If you are using a custom
         * headerFilterStrategy then this option does not apply.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param includeAllJMSXProperties the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointBuilder includeAllJMSXProperties(
                String includeAllJMSXProperties) {
            doSetProperty("includeAllJMSXProperties", includeAllJMSXProperties);
            return this;
        }
        /**
         * Pluggable strategy for encoding and decoding JMS keys so they can be
         * compliant with the JMS specification. Camel provides two
         * implementations out of the box: default and passthrough. The default
         * strategy will safely marshal dots and hyphens (. and -). The
         * passthrough strategy leaves the key as is. Can be used for JMS
         * brokers which do not care whether JMS header keys contain illegal
         * characters. You can provide your own implementation of the
         * org.apache.camel.component.jms.JmsKeyFormatStrategy and refer to it
         * using the # notation.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.sjms.jms.JmsKeyFormatStrategy&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param jmsKeyFormatStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointBuilder jmsKeyFormatStrategy(
                Object jmsKeyFormatStrategy) {
            doSetProperty("jmsKeyFormatStrategy", jmsKeyFormatStrategy);
            return this;
        }
        /**
         * Pluggable strategy for encoding and decoding JMS keys so they can be
         * compliant with the JMS specification. Camel provides two
         * implementations out of the box: default and passthrough. The default
         * strategy will safely marshal dots and hyphens (. and -). The
         * passthrough strategy leaves the key as is. Can be used for JMS
         * brokers which do not care whether JMS header keys contain illegal
         * characters. You can provide your own implementation of the
         * org.apache.camel.component.jms.JmsKeyFormatStrategy and refer to it
         * using the # notation.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.sjms.jms.JmsKeyFormatStrategy&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param jmsKeyFormatStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointBuilder jmsKeyFormatStrategy(
                String jmsKeyFormatStrategy) {
            doSetProperty("jmsKeyFormatStrategy", jmsKeyFormatStrategy);
            return this;
        }
        /**
         * Specifies whether Camel should auto map the received JMS message to a
         * suited payload type, such as javax.jms.TextMessage to a String etc.
         * See section about how mapping works below for more details.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param mapJmsMessage the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointBuilder mapJmsMessage(boolean mapJmsMessage) {
            doSetProperty("mapJmsMessage", mapJmsMessage);
            return this;
        }
        /**
         * Specifies whether Camel should auto map the received JMS message to a
         * suited payload type, such as javax.jms.TextMessage to a String etc.
         * See section about how mapping works below for more details.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param mapJmsMessage the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointBuilder mapJmsMessage(String mapJmsMessage) {
            doSetProperty("mapJmsMessage", mapJmsMessage);
            return this;
        }
        /**
         * To use the given MessageCreatedStrategy which are invoked when Camel
         * creates new instances of javax.jms.Message objects when Camel is
         * sending a JMS message.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.sjms.jms.MessageCreatedStrategy&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param messageCreatedStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointBuilder messageCreatedStrategy(
                Object messageCreatedStrategy) {
            doSetProperty("messageCreatedStrategy", messageCreatedStrategy);
            return this;
        }
        /**
         * To use the given MessageCreatedStrategy which are invoked when Camel
         * creates new instances of javax.jms.Message objects when Camel is
         * sending a JMS message.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.sjms.jms.MessageCreatedStrategy&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param messageCreatedStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointBuilder messageCreatedStrategy(
                String messageCreatedStrategy) {
            doSetProperty("messageCreatedStrategy", messageCreatedStrategy);
            return this;
        }
        /**
         * Specifies whether to share JMS session with other SJMS endpoints.
         * Turn this off if your route is accessing to multiple JMS providers.
         * If you need transaction against multiple JMS providers, use jms
         * component to leverage XA transaction.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: transaction (advanced)
         * 
         * @param sharedJMSSession the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointBuilder sharedJMSSession(
                boolean sharedJMSSession) {
            doSetProperty("sharedJMSSession", sharedJMSSession);
            return this;
        }
        /**
         * Specifies whether to share JMS session with other SJMS endpoints.
         * Turn this off if your route is accessing to multiple JMS providers.
         * If you need transaction against multiple JMS providers, use jms
         * component to leverage XA transaction.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: transaction (advanced)
         * 
         * @param sharedJMSSession the value to set
         * @return the dsl builder
         */
        default AdvancedSjms2EndpointBuilder sharedJMSSession(
                String sharedJMSSession) {
            doSetProperty("sharedJMSSession", sharedJMSSession);
            return this;
        }
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.sjms.jms.SessionAcknowledgementType</code> enum.
     */
    enum SessionAcknowledgementType {
        AUTO_ACKNOWLEDGE,
        CLIENT_ACKNOWLEDGE,
        DUPS_OK_ACKNOWLEDGE,
        SESSION_TRANSACTED;
    }

    public interface Sjms2Builders {
        /**
         * Simple JMS2 (camel-sjms2)
         * Send and receive messages to/from a JMS Queue or Topic using plain
         * JMS 2.x API.
         * 
         * Category: messaging
         * Since: 2.19
         * Maven coordinates: org.apache.camel:camel-sjms2
         * 
         * Syntax: <code>sjms2:destinationType:destinationName</code>
         * 
         * Path parameter: destinationType
         * The kind of destination to use
         * Default value: queue
         * There are 2 enums and the value can be one of: queue, topic
         * 
         * Path parameter: destinationName (required)
         * DestinationName is a JMS queue or topic name. By default, the
         * destinationName is interpreted as a queue name.
         * 
         * @param path destinationType:destinationName
         * @return the dsl builder
         */
        default Sjms2EndpointBuilder sjms2(String path) {
            return Sjms2EndpointBuilderFactory.endpointBuilder("sjms2", path);
        }
        /**
         * Simple JMS2 (camel-sjms2)
         * Send and receive messages to/from a JMS Queue or Topic using plain
         * JMS 2.x API.
         * 
         * Category: messaging
         * Since: 2.19
         * Maven coordinates: org.apache.camel:camel-sjms2
         * 
         * Syntax: <code>sjms2:destinationType:destinationName</code>
         * 
         * Path parameter: destinationType
         * The kind of destination to use
         * Default value: queue
         * There are 2 enums and the value can be one of: queue, topic
         * 
         * Path parameter: destinationName (required)
         * DestinationName is a JMS queue or topic name. By default, the
         * destinationName is interpreted as a queue name.
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path destinationType:destinationName
         * @return the dsl builder
         */
        default Sjms2EndpointBuilder sjms2(String componentName, String path) {
            return Sjms2EndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    static Sjms2EndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class Sjms2EndpointBuilderImpl extends AbstractEndpointBuilder implements Sjms2EndpointBuilder, AdvancedSjms2EndpointBuilder {
            public Sjms2EndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new Sjms2EndpointBuilderImpl(path);
    }
}