/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.HeaderFilterStrategy;

/**
 * Send and receive messages to/from an XMPP chat server.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface XmppEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the XMPP component.
     */
    public interface XmppEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedXmppEndpointConsumerBuilder advanced() {
            return (AdvancedXmppEndpointConsumerBuilder) this;
        }
        /**
         * Whether to login the user.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param login the value to set
         * @return the dsl builder
         */
        default XmppEndpointConsumerBuilder login(boolean login) {
            doSetProperty("login", login);
            return this;
        }
        /**
         * Whether to login the user.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param login the value to set
         * @return the dsl builder
         */
        default XmppEndpointConsumerBuilder login(String login) {
            doSetProperty("login", login);
            return this;
        }
        /**
         * Use nickname when joining room. If room is specified and nickname is
         * not, user will be used for the nickname.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param nickname the value to set
         * @return the dsl builder
         */
        default XmppEndpointConsumerBuilder nickname(String nickname) {
            doSetProperty("nickname", nickname);
            return this;
        }
        /**
         * Accept pubsub packets on input, default is false.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param pubsub the value to set
         * @return the dsl builder
         */
        default XmppEndpointConsumerBuilder pubsub(boolean pubsub) {
            doSetProperty("pubsub", pubsub);
            return this;
        }
        /**
         * Accept pubsub packets on input, default is false.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param pubsub the value to set
         * @return the dsl builder
         */
        default XmppEndpointConsumerBuilder pubsub(String pubsub) {
            doSetProperty("pubsub", pubsub);
            return this;
        }
        /**
         * If this option is specified, the component will connect to MUC (Multi
         * User Chat). Usually, the domain name for MUC is different from the
         * login domain. For example, if you are supermanjabber.org and want to
         * join the krypton room, then the room URL is
         * kryptonconference.jabber.org. Note the conference part. It is not a
         * requirement to provide the full room JID. If the room parameter does
         * not contain the symbol, the domain part will be discovered and added
         * by Camel.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param room the value to set
         * @return the dsl builder
         */
        default XmppEndpointConsumerBuilder room(String room) {
            doSetProperty("room", room);
            return this;
        }
        /**
         * The name of the service you are connecting to. For Google Talk, this
         * would be gmail.com.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param serviceName the value to set
         * @return the dsl builder
         */
        default XmppEndpointConsumerBuilder serviceName(String serviceName) {
            doSetProperty("serviceName", serviceName);
            return this;
        }
        /**
         * Specifies whether to test the connection on startup. This is used to
         * ensure that the XMPP client has a valid connection to the XMPP server
         * when the route starts. Camel throws an exception on startup if a
         * connection cannot be established. When this option is set to false,
         * Camel will attempt to establish a lazy connection when needed by a
         * producer, and will poll for a consumer connection until the
         * connection is established. Default is true.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param testConnectionOnStartup the value to set
         * @return the dsl builder
         */
        default XmppEndpointConsumerBuilder testConnectionOnStartup(
                boolean testConnectionOnStartup) {
            doSetProperty("testConnectionOnStartup", testConnectionOnStartup);
            return this;
        }
        /**
         * Specifies whether to test the connection on startup. This is used to
         * ensure that the XMPP client has a valid connection to the XMPP server
         * when the route starts. Camel throws an exception on startup if a
         * connection cannot be established. When this option is set to false,
         * Camel will attempt to establish a lazy connection when needed by a
         * producer, and will poll for a consumer connection until the
         * connection is established. Default is true.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param testConnectionOnStartup the value to set
         * @return the dsl builder
         */
        default XmppEndpointConsumerBuilder testConnectionOnStartup(
                String testConnectionOnStartup) {
            doSetProperty("testConnectionOnStartup", testConnectionOnStartup);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default XmppEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default XmppEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * The amount of time in seconds between polls (in seconds) to verify
         * the health of the XMPP connection, or between attempts to establish
         * an initial consumer connection. Camel will try to re-establish a
         * connection if it has become inactive. Default is 10 seconds.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10
         * Group: consumer
         * 
         * @param connectionPollDelay the value to set
         * @return the dsl builder
         */
        default XmppEndpointConsumerBuilder connectionPollDelay(
                int connectionPollDelay) {
            doSetProperty("connectionPollDelay", connectionPollDelay);
            return this;
        }
        /**
         * The amount of time in seconds between polls (in seconds) to verify
         * the health of the XMPP connection, or between attempts to establish
         * an initial consumer connection. Camel will try to re-establish a
         * connection if it has become inactive. Default is 10 seconds.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10
         * Group: consumer
         * 
         * @param connectionPollDelay the value to set
         * @return the dsl builder
         */
        default XmppEndpointConsumerBuilder connectionPollDelay(
                String connectionPollDelay) {
            doSetProperty("connectionPollDelay", connectionPollDelay);
            return this;
        }
        /**
         * Set a doc header on the IN message containing a Document form of the
         * incoming packet; default is true if presence or pubsub are true,
         * otherwise false.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param doc the value to set
         * @return the dsl builder
         */
        default XmppEndpointConsumerBuilder doc(boolean doc) {
            doSetProperty("doc", doc);
            return this;
        }
        /**
         * Set a doc header on the IN message containing a Document form of the
         * incoming packet; default is true if presence or pubsub are true,
         * otherwise false.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param doc the value to set
         * @return the dsl builder
         */
        default XmppEndpointConsumerBuilder doc(String doc) {
            doSetProperty("doc", doc);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: filter
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default XmppEndpointConsumerBuilder headerFilterStrategy(
                HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: filter
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default XmppEndpointConsumerBuilder headerFilterStrategy(
                String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * Password for login.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default XmppEndpointConsumerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Password for room.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param roomPassword the value to set
         * @return the dsl builder
         */
        default XmppEndpointConsumerBuilder roomPassword(String roomPassword) {
            doSetProperty("roomPassword", roomPassword);
            return this;
        }
        /**
         * User name (without server name). If not specified, anonymous login
         * will be attempted.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param user the value to set
         * @return the dsl builder
         */
        default XmppEndpointConsumerBuilder user(String user) {
            doSetProperty("user", user);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the XMPP component.
     */
    public interface AdvancedXmppEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default XmppEndpointConsumerBuilder basic() {
            return (XmppEndpointConsumerBuilder) this;
        }
        /**
         * If true, an attempt to create an account will be made. Default is
         * false.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common (advanced)
         * 
         * @param createAccount the value to set
         * @return the dsl builder
         */
        default AdvancedXmppEndpointConsumerBuilder createAccount(
                boolean createAccount) {
            doSetProperty("createAccount", createAccount);
            return this;
        }
        /**
         * If true, an attempt to create an account will be made. Default is
         * false.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common (advanced)
         * 
         * @param createAccount the value to set
         * @return the dsl builder
         */
        default AdvancedXmppEndpointConsumerBuilder createAccount(
                String createAccount) {
            doSetProperty("createAccount", createAccount);
            return this;
        }
        /**
         * XMPP resource. The default is Camel.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: Camel
         * Group: common (advanced)
         * 
         * @param resource the value to set
         * @return the dsl builder
         */
        default AdvancedXmppEndpointConsumerBuilder resource(String resource) {
            doSetProperty("resource", resource);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedXmppEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedXmppEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedXmppEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedXmppEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * To use an existing connection configuration. Currently
         * org.jivesoftware.smack.tcp.XMPPTCPConnectionConfiguration is only
         * supported (XMPP over TCP).
         * 
         * The option is a:
         * &lt;code&gt;org.jivesoftware.smack.ConnectionConfiguration&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param connectionConfig the value to set
         * @return the dsl builder
         */
        default AdvancedXmppEndpointConsumerBuilder connectionConfig(
                Object connectionConfig) {
            doSetProperty("connectionConfig", connectionConfig);
            return this;
        }
        /**
         * To use an existing connection configuration. Currently
         * org.jivesoftware.smack.tcp.XMPPTCPConnectionConfiguration is only
         * supported (XMPP over TCP).
         * 
         * The option will be converted to a
         * &lt;code&gt;org.jivesoftware.smack.ConnectionConfiguration&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param connectionConfig the value to set
         * @return the dsl builder
         */
        default AdvancedXmppEndpointConsumerBuilder connectionConfig(
                String connectionConfig) {
            doSetProperty("connectionConfig", connectionConfig);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedXmppEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedXmppEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the XMPP component.
     */
    public interface XmppEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedXmppEndpointProducerBuilder advanced() {
            return (AdvancedXmppEndpointProducerBuilder) this;
        }
        /**
         * Whether to login the user.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param login the value to set
         * @return the dsl builder
         */
        default XmppEndpointProducerBuilder login(boolean login) {
            doSetProperty("login", login);
            return this;
        }
        /**
         * Whether to login the user.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param login the value to set
         * @return the dsl builder
         */
        default XmppEndpointProducerBuilder login(String login) {
            doSetProperty("login", login);
            return this;
        }
        /**
         * Use nickname when joining room. If room is specified and nickname is
         * not, user will be used for the nickname.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param nickname the value to set
         * @return the dsl builder
         */
        default XmppEndpointProducerBuilder nickname(String nickname) {
            doSetProperty("nickname", nickname);
            return this;
        }
        /**
         * Accept pubsub packets on input, default is false.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param pubsub the value to set
         * @return the dsl builder
         */
        default XmppEndpointProducerBuilder pubsub(boolean pubsub) {
            doSetProperty("pubsub", pubsub);
            return this;
        }
        /**
         * Accept pubsub packets on input, default is false.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param pubsub the value to set
         * @return the dsl builder
         */
        default XmppEndpointProducerBuilder pubsub(String pubsub) {
            doSetProperty("pubsub", pubsub);
            return this;
        }
        /**
         * If this option is specified, the component will connect to MUC (Multi
         * User Chat). Usually, the domain name for MUC is different from the
         * login domain. For example, if you are supermanjabber.org and want to
         * join the krypton room, then the room URL is
         * kryptonconference.jabber.org. Note the conference part. It is not a
         * requirement to provide the full room JID. If the room parameter does
         * not contain the symbol, the domain part will be discovered and added
         * by Camel.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param room the value to set
         * @return the dsl builder
         */
        default XmppEndpointProducerBuilder room(String room) {
            doSetProperty("room", room);
            return this;
        }
        /**
         * The name of the service you are connecting to. For Google Talk, this
         * would be gmail.com.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param serviceName the value to set
         * @return the dsl builder
         */
        default XmppEndpointProducerBuilder serviceName(String serviceName) {
            doSetProperty("serviceName", serviceName);
            return this;
        }
        /**
         * Specifies whether to test the connection on startup. This is used to
         * ensure that the XMPP client has a valid connection to the XMPP server
         * when the route starts. Camel throws an exception on startup if a
         * connection cannot be established. When this option is set to false,
         * Camel will attempt to establish a lazy connection when needed by a
         * producer, and will poll for a consumer connection until the
         * connection is established. Default is true.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param testConnectionOnStartup the value to set
         * @return the dsl builder
         */
        default XmppEndpointProducerBuilder testConnectionOnStartup(
                boolean testConnectionOnStartup) {
            doSetProperty("testConnectionOnStartup", testConnectionOnStartup);
            return this;
        }
        /**
         * Specifies whether to test the connection on startup. This is used to
         * ensure that the XMPP client has a valid connection to the XMPP server
         * when the route starts. Camel throws an exception on startup if a
         * connection cannot be established. When this option is set to false,
         * Camel will attempt to establish a lazy connection when needed by a
         * producer, and will poll for a consumer connection until the
         * connection is established. Default is true.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param testConnectionOnStartup the value to set
         * @return the dsl builder
         */
        default XmppEndpointProducerBuilder testConnectionOnStartup(
                String testConnectionOnStartup) {
            doSetProperty("testConnectionOnStartup", testConnectionOnStartup);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default XmppEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default XmppEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: filter
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default XmppEndpointProducerBuilder headerFilterStrategy(
                HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: filter
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default XmppEndpointProducerBuilder headerFilterStrategy(
                String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * Password for login.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default XmppEndpointProducerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Password for room.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param roomPassword the value to set
         * @return the dsl builder
         */
        default XmppEndpointProducerBuilder roomPassword(String roomPassword) {
            doSetProperty("roomPassword", roomPassword);
            return this;
        }
        /**
         * User name (without server name). If not specified, anonymous login
         * will be attempted.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param user the value to set
         * @return the dsl builder
         */
        default XmppEndpointProducerBuilder user(String user) {
            doSetProperty("user", user);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the XMPP component.
     */
    public interface AdvancedXmppEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default XmppEndpointProducerBuilder basic() {
            return (XmppEndpointProducerBuilder) this;
        }
        /**
         * If true, an attempt to create an account will be made. Default is
         * false.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common (advanced)
         * 
         * @param createAccount the value to set
         * @return the dsl builder
         */
        default AdvancedXmppEndpointProducerBuilder createAccount(
                boolean createAccount) {
            doSetProperty("createAccount", createAccount);
            return this;
        }
        /**
         * If true, an attempt to create an account will be made. Default is
         * false.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common (advanced)
         * 
         * @param createAccount the value to set
         * @return the dsl builder
         */
        default AdvancedXmppEndpointProducerBuilder createAccount(
                String createAccount) {
            doSetProperty("createAccount", createAccount);
            return this;
        }
        /**
         * XMPP resource. The default is Camel.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: Camel
         * Group: common (advanced)
         * 
         * @param resource the value to set
         * @return the dsl builder
         */
        default AdvancedXmppEndpointProducerBuilder resource(String resource) {
            doSetProperty("resource", resource);
            return this;
        }
        /**
         * To use an existing connection configuration. Currently
         * org.jivesoftware.smack.tcp.XMPPTCPConnectionConfiguration is only
         * supported (XMPP over TCP).
         * 
         * The option is a:
         * &lt;code&gt;org.jivesoftware.smack.ConnectionConfiguration&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param connectionConfig the value to set
         * @return the dsl builder
         */
        default AdvancedXmppEndpointProducerBuilder connectionConfig(
                Object connectionConfig) {
            doSetProperty("connectionConfig", connectionConfig);
            return this;
        }
        /**
         * To use an existing connection configuration. Currently
         * org.jivesoftware.smack.tcp.XMPPTCPConnectionConfiguration is only
         * supported (XMPP over TCP).
         * 
         * The option will be converted to a
         * &lt;code&gt;org.jivesoftware.smack.ConnectionConfiguration&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param connectionConfig the value to set
         * @return the dsl builder
         */
        default AdvancedXmppEndpointProducerBuilder connectionConfig(
                String connectionConfig) {
            doSetProperty("connectionConfig", connectionConfig);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedXmppEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedXmppEndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the XMPP component.
     */
    public interface XmppEndpointBuilder
            extends
                XmppEndpointConsumerBuilder,
                XmppEndpointProducerBuilder {
        default AdvancedXmppEndpointBuilder advanced() {
            return (AdvancedXmppEndpointBuilder) this;
        }
        /**
         * Whether to login the user.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param login the value to set
         * @return the dsl builder
         */
        default XmppEndpointBuilder login(boolean login) {
            doSetProperty("login", login);
            return this;
        }
        /**
         * Whether to login the user.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param login the value to set
         * @return the dsl builder
         */
        default XmppEndpointBuilder login(String login) {
            doSetProperty("login", login);
            return this;
        }
        /**
         * Use nickname when joining room. If room is specified and nickname is
         * not, user will be used for the nickname.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param nickname the value to set
         * @return the dsl builder
         */
        default XmppEndpointBuilder nickname(String nickname) {
            doSetProperty("nickname", nickname);
            return this;
        }
        /**
         * Accept pubsub packets on input, default is false.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param pubsub the value to set
         * @return the dsl builder
         */
        default XmppEndpointBuilder pubsub(boolean pubsub) {
            doSetProperty("pubsub", pubsub);
            return this;
        }
        /**
         * Accept pubsub packets on input, default is false.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param pubsub the value to set
         * @return the dsl builder
         */
        default XmppEndpointBuilder pubsub(String pubsub) {
            doSetProperty("pubsub", pubsub);
            return this;
        }
        /**
         * If this option is specified, the component will connect to MUC (Multi
         * User Chat). Usually, the domain name for MUC is different from the
         * login domain. For example, if you are supermanjabber.org and want to
         * join the krypton room, then the room URL is
         * kryptonconference.jabber.org. Note the conference part. It is not a
         * requirement to provide the full room JID. If the room parameter does
         * not contain the symbol, the domain part will be discovered and added
         * by Camel.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param room the value to set
         * @return the dsl builder
         */
        default XmppEndpointBuilder room(String room) {
            doSetProperty("room", room);
            return this;
        }
        /**
         * The name of the service you are connecting to. For Google Talk, this
         * would be gmail.com.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param serviceName the value to set
         * @return the dsl builder
         */
        default XmppEndpointBuilder serviceName(String serviceName) {
            doSetProperty("serviceName", serviceName);
            return this;
        }
        /**
         * Specifies whether to test the connection on startup. This is used to
         * ensure that the XMPP client has a valid connection to the XMPP server
         * when the route starts. Camel throws an exception on startup if a
         * connection cannot be established. When this option is set to false,
         * Camel will attempt to establish a lazy connection when needed by a
         * producer, and will poll for a consumer connection until the
         * connection is established. Default is true.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param testConnectionOnStartup the value to set
         * @return the dsl builder
         */
        default XmppEndpointBuilder testConnectionOnStartup(
                boolean testConnectionOnStartup) {
            doSetProperty("testConnectionOnStartup", testConnectionOnStartup);
            return this;
        }
        /**
         * Specifies whether to test the connection on startup. This is used to
         * ensure that the XMPP client has a valid connection to the XMPP server
         * when the route starts. Camel throws an exception on startup if a
         * connection cannot be established. When this option is set to false,
         * Camel will attempt to establish a lazy connection when needed by a
         * producer, and will poll for a consumer connection until the
         * connection is established. Default is true.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param testConnectionOnStartup the value to set
         * @return the dsl builder
         */
        default XmppEndpointBuilder testConnectionOnStartup(
                String testConnectionOnStartup) {
            doSetProperty("testConnectionOnStartup", testConnectionOnStartup);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: filter
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default XmppEndpointBuilder headerFilterStrategy(
                HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: filter
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default XmppEndpointBuilder headerFilterStrategy(
                String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * Password for login.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default XmppEndpointBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Password for room.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param roomPassword the value to set
         * @return the dsl builder
         */
        default XmppEndpointBuilder roomPassword(String roomPassword) {
            doSetProperty("roomPassword", roomPassword);
            return this;
        }
        /**
         * User name (without server name). If not specified, anonymous login
         * will be attempted.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param user the value to set
         * @return the dsl builder
         */
        default XmppEndpointBuilder user(String user) {
            doSetProperty("user", user);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the XMPP component.
     */
    public interface AdvancedXmppEndpointBuilder
            extends
                AdvancedXmppEndpointConsumerBuilder,
                AdvancedXmppEndpointProducerBuilder {
        default XmppEndpointBuilder basic() {
            return (XmppEndpointBuilder) this;
        }
        /**
         * If true, an attempt to create an account will be made. Default is
         * false.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common (advanced)
         * 
         * @param createAccount the value to set
         * @return the dsl builder
         */
        default AdvancedXmppEndpointBuilder createAccount(boolean createAccount) {
            doSetProperty("createAccount", createAccount);
            return this;
        }
        /**
         * If true, an attempt to create an account will be made. Default is
         * false.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common (advanced)
         * 
         * @param createAccount the value to set
         * @return the dsl builder
         */
        default AdvancedXmppEndpointBuilder createAccount(String createAccount) {
            doSetProperty("createAccount", createAccount);
            return this;
        }
        /**
         * XMPP resource. The default is Camel.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: Camel
         * Group: common (advanced)
         * 
         * @param resource the value to set
         * @return the dsl builder
         */
        default AdvancedXmppEndpointBuilder resource(String resource) {
            doSetProperty("resource", resource);
            return this;
        }
        /**
         * To use an existing connection configuration. Currently
         * org.jivesoftware.smack.tcp.XMPPTCPConnectionConfiguration is only
         * supported (XMPP over TCP).
         * 
         * The option is a:
         * &lt;code&gt;org.jivesoftware.smack.ConnectionConfiguration&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param connectionConfig the value to set
         * @return the dsl builder
         */
        default AdvancedXmppEndpointBuilder connectionConfig(
                Object connectionConfig) {
            doSetProperty("connectionConfig", connectionConfig);
            return this;
        }
        /**
         * To use an existing connection configuration. Currently
         * org.jivesoftware.smack.tcp.XMPPTCPConnectionConfiguration is only
         * supported (XMPP over TCP).
         * 
         * The option will be converted to a
         * &lt;code&gt;org.jivesoftware.smack.ConnectionConfiguration&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param connectionConfig the value to set
         * @return the dsl builder
         */
        default AdvancedXmppEndpointBuilder connectionConfig(
                String connectionConfig) {
            doSetProperty("connectionConfig", connectionConfig);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedXmppEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedXmppEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    public interface XmppBuilders {
        /**
         * XMPP (camel-xmpp)
         * Send and receive messages to/from an XMPP chat server.
         * 
         * Category: chat,messaging
         * Since: 1.0
         * Maven coordinates: org.apache.camel:camel-xmpp
         * 
         * Syntax: <code>xmpp:host:port/participant</code>
         * 
         * Path parameter: host (required)
         * Hostname for the chat server
         * 
         * Path parameter: port (required)
         * Port number for the chat server
         * 
         * Path parameter: participant
         * JID (Jabber ID) of person to receive messages. room parameter has
         * precedence over participant.
         * 
         * @param path host:port/participant
         * @return the dsl builder
         */
        default XmppEndpointBuilder xmpp(String path) {
            return XmppEndpointBuilderFactory.endpointBuilder("xmpp", path);
        }
        /**
         * XMPP (camel-xmpp)
         * Send and receive messages to/from an XMPP chat server.
         * 
         * Category: chat,messaging
         * Since: 1.0
         * Maven coordinates: org.apache.camel:camel-xmpp
         * 
         * Syntax: <code>xmpp:host:port/participant</code>
         * 
         * Path parameter: host (required)
         * Hostname for the chat server
         * 
         * Path parameter: port (required)
         * Port number for the chat server
         * 
         * Path parameter: participant
         * JID (Jabber ID) of person to receive messages. room parameter has
         * precedence over participant.
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path host:port/participant
         * @return the dsl builder
         */
        default XmppEndpointBuilder xmpp(String componentName, String path) {
            return XmppEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    static XmppEndpointBuilder endpointBuilder(String componentName, String path) {
        class XmppEndpointBuilderImpl extends AbstractEndpointBuilder implements XmppEndpointBuilder, AdvancedXmppEndpointBuilder {
            public XmppEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new XmppEndpointBuilderImpl(path);
    }
}