/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.Map;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Query Couchbase Views with a poll strategy and/or perform various operations
 * against Couchbase databases.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface CouchbaseEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Couchbase component.
     */
    public interface CouchbaseEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedCouchbaseEndpointConsumerBuilder advanced() {
            return (AdvancedCouchbaseEndpointConsumerBuilder) this;
        }
        /**
         * The bucket to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Required: true
         * Group: common
         * 
         * @param bucket the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder bucket(String bucket) {
            doSetProperty("bucket", bucket);
            return this;
        }
        /**
         * The collection to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param collection the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder collection(String collection) {
            doSetProperty("collection", collection);
            return this;
        }
        /**
         * The key to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param key the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder key(String key) {
            doSetProperty("key", key);
            return this;
        }
        /**
         * The scope to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param scope the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder scope(String scope) {
            doSetProperty("scope", scope);
            return this;
        }
        /**
         * Define the consumer Processed strategy to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: none
         * Group: consumer
         * 
         * @param consumerProcessedStrategy the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder consumerProcessedStrategy(
                String consumerProcessedStrategy) {
            doSetProperty("consumerProcessedStrategy", consumerProcessedStrategy);
            return this;
        }
        /**
         * Define if this operation is descending or not.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param descending the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder descending(boolean descending) {
            doSetProperty("descending", descending);
            return this;
        }
        /**
         * Define if this operation is descending or not.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param descending the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder descending(String descending) {
            doSetProperty("descending", descending);
            return this;
        }
        /**
         * The design document name to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: beer
         * Group: consumer
         * 
         * @param designDocumentName the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder designDocumentName(
                String designDocumentName) {
            doSetProperty("designDocumentName", designDocumentName);
            return this;
        }
        /**
         * If true consumer will return complete document instead data defined
         * in view.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param fullDocument the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder fullDocument(
                boolean fullDocument) {
            doSetProperty("fullDocument", fullDocument);
            return this;
        }
        /**
         * If true consumer will return complete document instead data defined
         * in view.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param fullDocument the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder fullDocument(
                String fullDocument) {
            doSetProperty("fullDocument", fullDocument);
            return this;
        }
        /**
         * The output limit to use.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: consumer
         * 
         * @param limit the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder limit(int limit) {
            doSetProperty("limit", limit);
            return this;
        }
        /**
         * The output limit to use.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: consumer
         * 
         * @param limit the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder limit(String limit) {
            doSetProperty("limit", limit);
            return this;
        }
        /**
         * Define a range for the end key.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param rangeEndKey the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder rangeEndKey(String rangeEndKey) {
            doSetProperty("rangeEndKey", rangeEndKey);
            return this;
        }
        /**
         * Define a range for the start key.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param rangeStartKey the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder rangeStartKey(
                String rangeStartKey) {
            doSetProperty("rangeStartKey", rangeStartKey);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                boolean sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                String sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * Define the skip to use.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: consumer
         * 
         * @param skip the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder skip(int skip) {
            doSetProperty("skip", skip);
            return this;
        }
        /**
         * Define the skip to use.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: consumer
         * 
         * @param skip the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder skip(String skip) {
            doSetProperty("skip", skip);
            return this;
        }
        /**
         * The view name to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: brewery_beers
         * Group: consumer
         * 
         * @param viewName the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder viewName(String viewName) {
            doSetProperty("viewName", viewName);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder backoffErrorThreshold(
                int backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder backoffErrorThreshold(
                String backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder backoffIdleThreshold(
                int backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder backoffIdleThreshold(
                String backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder backoffMultiplier(
                int backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder backoffMultiplier(
                String backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: scheduler
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder delay(long delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: scheduler
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder delay(String delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder greedy(boolean greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder greedy(String greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder initialDelay(long initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder initialDelay(
                String initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder repeatCount(long repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder repeatCount(String repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder runLoggingLevel(
                org.apache.camel.LoggingLevel runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder runLoggingLevel(
                String runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option is a:
         * &lt;code&gt;java.util.concurrent.ScheduledExecutorService&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder scheduledExecutorService(
                ScheduledExecutorService scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.concurrent.ScheduledExecutorService&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder scheduledExecutorService(
                String scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option is a: &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder scheduler(Object scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder scheduler(String scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder schedulerProperties(
                String key,
                Object value) {
            doSetMultiValueProperty("schedulerProperties", "scheduler." + key, value);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param values the values
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder schedulerProperties(Map values) {
            doSetMultiValueProperties("schedulerProperties", "scheduler.", values);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder startScheduler(
                boolean startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder startScheduler(
                String startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option is a:
         * &lt;code&gt;java.util.concurrent.TimeUnit&lt;/code&gt; type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.concurrent.TimeUnit&lt;/code&gt; type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder timeUnit(String timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder useFixedDelay(
                boolean useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder useFixedDelay(
                String useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * The password to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * The username to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointConsumerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Couchbase component.
     */
    public interface AdvancedCouchbaseEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default CouchbaseEndpointConsumerBuilder basic() {
            return (CouchbaseEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedCouchbaseEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedCouchbaseEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedCouchbaseEndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedCouchbaseEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedCouchbaseEndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedCouchbaseEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.PollingConsumerPollStrategy&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedCouchbaseEndpointConsumerBuilder pollStrategy(
                org.apache.camel.spi.PollingConsumerPollStrategy pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.PollingConsumerPollStrategy&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedCouchbaseEndpointConsumerBuilder pollStrategy(
                String pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * The additional hosts.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param additionalHosts the value to set
         * @return the dsl builder
         */
        default AdvancedCouchbaseEndpointConsumerBuilder additionalHosts(
                String additionalHosts) {
            doSetProperty("additionalHosts", additionalHosts);
            return this;
        }
        /**
         * Define the timeoutconnect in milliseconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: advanced
         * 
         * @param connectTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedCouchbaseEndpointConsumerBuilder connectTimeout(
                long connectTimeout) {
            doSetProperty("connectTimeout", connectTimeout);
            return this;
        }
        /**
         * Define the timeoutconnect in milliseconds.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: advanced
         * 
         * @param connectTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedCouchbaseEndpointConsumerBuilder connectTimeout(
                String connectTimeout) {
            doSetProperty("connectTimeout", connectTimeout);
            return this;
        }
        /**
         * Define the operation timeout in milliseconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 2500
         * Group: advanced
         * 
         * @param queryTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedCouchbaseEndpointConsumerBuilder queryTimeout(
                long queryTimeout) {
            doSetProperty("queryTimeout", queryTimeout);
            return this;
        }
        /**
         * Define the operation timeout in milliseconds.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 2500
         * Group: advanced
         * 
         * @param queryTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedCouchbaseEndpointConsumerBuilder queryTimeout(
                String queryTimeout) {
            doSetProperty("queryTimeout", queryTimeout);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Couchbase component.
     */
    public interface CouchbaseEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedCouchbaseEndpointProducerBuilder advanced() {
            return (AdvancedCouchbaseEndpointProducerBuilder) this;
        }
        /**
         * The bucket to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Required: true
         * Group: common
         * 
         * @param bucket the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointProducerBuilder bucket(String bucket) {
            doSetProperty("bucket", bucket);
            return this;
        }
        /**
         * The collection to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param collection the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointProducerBuilder collection(String collection) {
            doSetProperty("collection", collection);
            return this;
        }
        /**
         * The key to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param key the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointProducerBuilder key(String key) {
            doSetProperty("key", key);
            return this;
        }
        /**
         * The scope to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param scope the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointProducerBuilder scope(String scope) {
            doSetProperty("scope", scope);
            return this;
        }
        /**
         * Define if we want an autostart Id when we are doing an insert
         * operation.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param autoStartIdForInserts the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointProducerBuilder autoStartIdForInserts(
                boolean autoStartIdForInserts) {
            doSetProperty("autoStartIdForInserts", autoStartIdForInserts);
            return this;
        }
        /**
         * Define if we want an autostart Id when we are doing an insert
         * operation.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param autoStartIdForInserts the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointProducerBuilder autoStartIdForInserts(
                String autoStartIdForInserts) {
            doSetProperty("autoStartIdForInserts", autoStartIdForInserts);
            return this;
        }
        /**
         * The operation to do.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: CCB_PUT
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointProducerBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * Where to persist the data.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: producer
         * 
         * @param persistTo the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointProducerBuilder persistTo(int persistTo) {
            doSetProperty("persistTo", persistTo);
            return this;
        }
        /**
         * Where to persist the data.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: producer
         * 
         * @param persistTo the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointProducerBuilder persistTo(String persistTo) {
            doSetProperty("persistTo", persistTo);
            return this;
        }
        /**
         * Define the number of retry attempts.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 2
         * Group: producer
         * 
         * @param producerRetryAttempts the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointProducerBuilder producerRetryAttempts(
                int producerRetryAttempts) {
            doSetProperty("producerRetryAttempts", producerRetryAttempts);
            return this;
        }
        /**
         * Define the number of retry attempts.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 2
         * Group: producer
         * 
         * @param producerRetryAttempts the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointProducerBuilder producerRetryAttempts(
                String producerRetryAttempts) {
            doSetProperty("producerRetryAttempts", producerRetryAttempts);
            return this;
        }
        /**
         * Define the retry pause between different attempts.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 5000
         * Group: producer
         * 
         * @param producerRetryPause the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointProducerBuilder producerRetryPause(
                int producerRetryPause) {
            doSetProperty("producerRetryPause", producerRetryPause);
            return this;
        }
        /**
         * Define the retry pause between different attempts.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 5000
         * Group: producer
         * 
         * @param producerRetryPause the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointProducerBuilder producerRetryPause(
                String producerRetryPause) {
            doSetProperty("producerRetryPause", producerRetryPause);
            return this;
        }
        /**
         * Where to replicate the data.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: producer
         * 
         * @param replicateTo the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointProducerBuilder replicateTo(int replicateTo) {
            doSetProperty("replicateTo", replicateTo);
            return this;
        }
        /**
         * Where to replicate the data.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: producer
         * 
         * @param replicateTo the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointProducerBuilder replicateTo(String replicateTo) {
            doSetProperty("replicateTo", replicateTo);
            return this;
        }
        /**
         * Define the starting Id where we are doing an insert operation.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param startingIdForInsertsFrom the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointProducerBuilder startingIdForInsertsFrom(
                long startingIdForInsertsFrom) {
            doSetProperty("startingIdForInsertsFrom", startingIdForInsertsFrom);
            return this;
        }
        /**
         * Define the starting Id where we are doing an insert operation.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param startingIdForInsertsFrom the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointProducerBuilder startingIdForInsertsFrom(
                String startingIdForInsertsFrom) {
            doSetProperty("startingIdForInsertsFrom", startingIdForInsertsFrom);
            return this;
        }
        /**
         * The password to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointProducerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * The username to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointProducerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Couchbase component.
     */
    public interface AdvancedCouchbaseEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default CouchbaseEndpointProducerBuilder basic() {
            return (CouchbaseEndpointProducerBuilder) this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedCouchbaseEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedCouchbaseEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * The additional hosts.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param additionalHosts the value to set
         * @return the dsl builder
         */
        default AdvancedCouchbaseEndpointProducerBuilder additionalHosts(
                String additionalHosts) {
            doSetProperty("additionalHosts", additionalHosts);
            return this;
        }
        /**
         * Define the timeoutconnect in milliseconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: advanced
         * 
         * @param connectTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedCouchbaseEndpointProducerBuilder connectTimeout(
                long connectTimeout) {
            doSetProperty("connectTimeout", connectTimeout);
            return this;
        }
        /**
         * Define the timeoutconnect in milliseconds.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: advanced
         * 
         * @param connectTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedCouchbaseEndpointProducerBuilder connectTimeout(
                String connectTimeout) {
            doSetProperty("connectTimeout", connectTimeout);
            return this;
        }
        /**
         * Define the operation timeout in milliseconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 2500
         * Group: advanced
         * 
         * @param queryTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedCouchbaseEndpointProducerBuilder queryTimeout(
                long queryTimeout) {
            doSetProperty("queryTimeout", queryTimeout);
            return this;
        }
        /**
         * Define the operation timeout in milliseconds.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 2500
         * Group: advanced
         * 
         * @param queryTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedCouchbaseEndpointProducerBuilder queryTimeout(
                String queryTimeout) {
            doSetProperty("queryTimeout", queryTimeout);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Couchbase component.
     */
    public interface CouchbaseEndpointBuilder
            extends
                CouchbaseEndpointConsumerBuilder,
                CouchbaseEndpointProducerBuilder {
        default AdvancedCouchbaseEndpointBuilder advanced() {
            return (AdvancedCouchbaseEndpointBuilder) this;
        }
        /**
         * The bucket to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Required: true
         * Group: common
         * 
         * @param bucket the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointBuilder bucket(String bucket) {
            doSetProperty("bucket", bucket);
            return this;
        }
        /**
         * The collection to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param collection the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointBuilder collection(String collection) {
            doSetProperty("collection", collection);
            return this;
        }
        /**
         * The key to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param key the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointBuilder key(String key) {
            doSetProperty("key", key);
            return this;
        }
        /**
         * The scope to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param scope the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointBuilder scope(String scope) {
            doSetProperty("scope", scope);
            return this;
        }
        /**
         * The password to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * The username to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default CouchbaseEndpointBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Couchbase component.
     */
    public interface AdvancedCouchbaseEndpointBuilder
            extends
                AdvancedCouchbaseEndpointConsumerBuilder,
                AdvancedCouchbaseEndpointProducerBuilder {
        default CouchbaseEndpointBuilder basic() {
            return (CouchbaseEndpointBuilder) this;
        }
        /**
         * The additional hosts.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param additionalHosts the value to set
         * @return the dsl builder
         */
        default AdvancedCouchbaseEndpointBuilder additionalHosts(
                String additionalHosts) {
            doSetProperty("additionalHosts", additionalHosts);
            return this;
        }
        /**
         * Define the timeoutconnect in milliseconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: advanced
         * 
         * @param connectTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedCouchbaseEndpointBuilder connectTimeout(
                long connectTimeout) {
            doSetProperty("connectTimeout", connectTimeout);
            return this;
        }
        /**
         * Define the timeoutconnect in milliseconds.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: advanced
         * 
         * @param connectTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedCouchbaseEndpointBuilder connectTimeout(
                String connectTimeout) {
            doSetProperty("connectTimeout", connectTimeout);
            return this;
        }
        /**
         * Define the operation timeout in milliseconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 2500
         * Group: advanced
         * 
         * @param queryTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedCouchbaseEndpointBuilder queryTimeout(long queryTimeout) {
            doSetProperty("queryTimeout", queryTimeout);
            return this;
        }
        /**
         * Define the operation timeout in milliseconds.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 2500
         * Group: advanced
         * 
         * @param queryTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedCouchbaseEndpointBuilder queryTimeout(
                String queryTimeout) {
            doSetProperty("queryTimeout", queryTimeout);
            return this;
        }
    }

    public interface CouchbaseBuilders {
        /**
         * Couchbase (camel-couchbase)
         * Query Couchbase Views with a poll strategy and/or perform various
         * operations against Couchbase databases.
         * 
         * Category: database,nosql
         * Since: 2.19
         * Maven coordinates: org.apache.camel:camel-couchbase
         * 
         * @return the dsl builder for the headers' name.
         */
        default CouchbaseHeaderNameBuilder couchbase() {
            return CouchbaseHeaderNameBuilder.INSTANCE;
        }
        /**
         * Couchbase (camel-couchbase)
         * Query Couchbase Views with a poll strategy and/or perform various
         * operations against Couchbase databases.
         * 
         * Category: database,nosql
         * Since: 2.19
         * Maven coordinates: org.apache.camel:camel-couchbase
         * 
         * Syntax: <code>couchbase:protocol://hostname:port</code>
         * 
         * Path parameter: protocol (required)
         * The protocol to use
         * 
         * Path parameter: hostname (required)
         * The hostname to use
         * 
         * Path parameter: port
         * The port number to use
         * Default value: 8091
         * 
         * @param path protocol://hostname:port
         * @return the dsl builder
         */
        default CouchbaseEndpointBuilder couchbase(String path) {
            return CouchbaseEndpointBuilderFactory.endpointBuilder("couchbase", path);
        }
        /**
         * Couchbase (camel-couchbase)
         * Query Couchbase Views with a poll strategy and/or perform various
         * operations against Couchbase databases.
         * 
         * Category: database,nosql
         * Since: 2.19
         * Maven coordinates: org.apache.camel:camel-couchbase
         * 
         * Syntax: <code>couchbase:protocol://hostname:port</code>
         * 
         * Path parameter: protocol (required)
         * The protocol to use
         * 
         * Path parameter: hostname (required)
         * The hostname to use
         * 
         * Path parameter: port
         * The port number to use
         * Default value: 8091
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path protocol://hostname:port
         * @return the dsl builder
         */
        default CouchbaseEndpointBuilder couchbase(
                String componentName,
                String path) {
            return CouchbaseEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    /**
     * The builder of headers' name for the Couchbase component.
     */
    public static class CouchbaseHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final CouchbaseHeaderNameBuilder INSTANCE = new CouchbaseHeaderNameBuilder();

        /**
         * The key.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code CCB_KEY}.
         */
        public String ccbKey() {
            return "CCB_KEY";
        }

        /**
         * The document id.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code CCB_ID}.
         */
        public String ccbId() {
            return "CCB_ID";
        }

        /**
         * The expiry for the document in seconds.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code CCB_TTL}.
         */
        public String ccbTtl() {
            return "CCB_TTL";
        }

        /**
         * The design document name.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code CCB_DDN}.
         */
        public String ccbDdn() {
            return "CCB_DDN";
        }

        /**
         * The view name.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code CCB_VN}.
         */
        public String ccbVn() {
            return "CCB_VN";
        }

        /**
         * The resume action to execute when resuming.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code CqlResumeQuery}.
         */
        public String cqlResumeQuery() {
            return "CqlResumeQuery";
        }
    }
    static CouchbaseEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class CouchbaseEndpointBuilderImpl extends AbstractEndpointBuilder implements CouchbaseEndpointBuilder, AdvancedCouchbaseEndpointBuilder {
            public CouchbaseEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new CouchbaseEndpointBuilderImpl(path);
    }
}