/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Read and write from/to Infinispan distributed key/value store and data grid.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface InfinispanRemoteEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Infinispan component.
     */
    public interface InfinispanRemoteEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedInfinispanRemoteEndpointConsumerBuilder advanced() {
            return (AdvancedInfinispanRemoteEndpointConsumerBuilder) this;
        }
        /**
         * Specifies the host of the cache on Infinispan instance.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param hosts the value to set
         * @return the dsl builder
         */
        default InfinispanRemoteEndpointConsumerBuilder hosts(String hosts) {
            doSetProperty("hosts", hosts);
            return this;
        }
        /**
         * Specifies the query builder.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.infinispan.InfinispanQueryBuilder&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param queryBuilder the value to set
         * @return the dsl builder
         */
        default InfinispanRemoteEndpointConsumerBuilder queryBuilder(
                org.apache.camel.component.infinispan.InfinispanQueryBuilder queryBuilder) {
            doSetProperty("queryBuilder", queryBuilder);
            return this;
        }
        /**
         * Specifies the query builder.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.infinispan.InfinispanQueryBuilder&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param queryBuilder the value to set
         * @return the dsl builder
         */
        default InfinispanRemoteEndpointConsumerBuilder queryBuilder(
                String queryBuilder) {
            doSetProperty("queryBuilder", queryBuilder);
            return this;
        }
        /**
         * Define if we are connecting to a secured Infinispan instance.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param secure the value to set
         * @return the dsl builder
         */
        default InfinispanRemoteEndpointConsumerBuilder secure(boolean secure) {
            doSetProperty("secure", secure);
            return this;
        }
        /**
         * Define if we are connecting to a secured Infinispan instance.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param secure the value to set
         * @return the dsl builder
         */
        default InfinispanRemoteEndpointConsumerBuilder secure(String secure) {
            doSetProperty("secure", secure);
            return this;
        }
        /**
         * Returns the custom listener in use, if provided.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.infinispan.remote.InfinispanRemoteCustomListener&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param customListener the value to set
         * @return the dsl builder
         */
        default InfinispanRemoteEndpointConsumerBuilder customListener(
                org.apache.camel.component.infinispan.remote.InfinispanRemoteCustomListener customListener) {
            doSetProperty("customListener", customListener);
            return this;
        }
        /**
         * Returns the custom listener in use, if provided.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.infinispan.remote.InfinispanRemoteCustomListener&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param customListener the value to set
         * @return the dsl builder
         */
        default InfinispanRemoteEndpointConsumerBuilder customListener(
                String customListener) {
            doSetProperty("customListener", customListener);
            return this;
        }
        /**
         * Specifies the set of event types to register by the consumer.Multiple
         * event can be separated by comma. The possible event types are:
         * CLIENT_CACHE_ENTRY_CREATED, CLIENT_CACHE_ENTRY_MODIFIED,
         * CLIENT_CACHE_ENTRY_REMOVED, CLIENT_CACHE_ENTRY_EXPIRED,
         * CLIENT_CACHE_FAILOVER.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param eventTypes the value to set
         * @return the dsl builder
         */
        default InfinispanRemoteEndpointConsumerBuilder eventTypes(
                String eventTypes) {
            doSetProperty("eventTypes", eventTypes);
            return this;
        }
        /**
         * Define the password to access the infinispan instance.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default InfinispanRemoteEndpointConsumerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Define the SASL Mechanism to access the infinispan instance.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param saslMechanism the value to set
         * @return the dsl builder
         */
        default InfinispanRemoteEndpointConsumerBuilder saslMechanism(
                String saslMechanism) {
            doSetProperty("saslMechanism", saslMechanism);
            return this;
        }
        /**
         * Define the security realm to access the infinispan instance.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param securityRealm the value to set
         * @return the dsl builder
         */
        default InfinispanRemoteEndpointConsumerBuilder securityRealm(
                String securityRealm) {
            doSetProperty("securityRealm", securityRealm);
            return this;
        }
        /**
         * Define the security server name to access the infinispan instance.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param securityServerName the value to set
         * @return the dsl builder
         */
        default InfinispanRemoteEndpointConsumerBuilder securityServerName(
                String securityServerName) {
            doSetProperty("securityServerName", securityServerName);
            return this;
        }
        /**
         * Define the username to access the infinispan instance.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default InfinispanRemoteEndpointConsumerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Infinispan component.
     */
    public interface AdvancedInfinispanRemoteEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default InfinispanRemoteEndpointConsumerBuilder basic() {
            return (InfinispanRemoteEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanRemoteEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanRemoteEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanRemoteEndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanRemoteEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanRemoteEndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanRemoteEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Specifies the cache Container to connect.
         * 
         * The option is a:
         * &lt;code&gt;org.infinispan.client.hotrod.RemoteCacheManager&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param cacheContainer the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanRemoteEndpointConsumerBuilder cacheContainer(
                org.infinispan.client.hotrod.RemoteCacheManager cacheContainer) {
            doSetProperty("cacheContainer", cacheContainer);
            return this;
        }
        /**
         * Specifies the cache Container to connect.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.infinispan.client.hotrod.RemoteCacheManager&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param cacheContainer the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanRemoteEndpointConsumerBuilder cacheContainer(
                String cacheContainer) {
            doSetProperty("cacheContainer", cacheContainer);
            return this;
        }
        /**
         * The CacheContainer configuration. Used if the cacheContainer is not
         * defined.
         * 
         * The option is a:
         * &lt;code&gt;org.infinispan.client.hotrod.configuration.Configuration&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param cacheContainerConfiguration the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanRemoteEndpointConsumerBuilder cacheContainerConfiguration(
                org.infinispan.client.hotrod.configuration.Configuration cacheContainerConfiguration) {
            doSetProperty("cacheContainerConfiguration", cacheContainerConfiguration);
            return this;
        }
        /**
         * The CacheContainer configuration. Used if the cacheContainer is not
         * defined.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.infinispan.client.hotrod.configuration.Configuration&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param cacheContainerConfiguration the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanRemoteEndpointConsumerBuilder cacheContainerConfiguration(
                String cacheContainerConfiguration) {
            doSetProperty("cacheContainerConfiguration", cacheContainerConfiguration);
            return this;
        }
        /**
         * Implementation specific properties for the CacheManager.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param configurationProperties the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanRemoteEndpointConsumerBuilder configurationProperties(
                Map<java.lang.String, java.lang.String> configurationProperties) {
            doSetProperty("configurationProperties", configurationProperties);
            return this;
        }
        /**
         * Implementation specific properties for the CacheManager.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param configurationProperties the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanRemoteEndpointConsumerBuilder configurationProperties(
                String configurationProperties) {
            doSetProperty("configurationProperties", configurationProperties);
            return this;
        }
        /**
         * An implementation specific URI for the CacheManager.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param configurationUri the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanRemoteEndpointConsumerBuilder configurationUri(
                String configurationUri) {
            doSetProperty("configurationUri", configurationUri);
            return this;
        }
        /**
         * A comma separated list of org.infinispan.client.hotrod.Flag to be
         * applied by default on each cache invocation.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param flags the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanRemoteEndpointConsumerBuilder flags(
                String flags) {
            doSetProperty("flags", flags);
            return this;
        }
        /**
         * Set a specific remappingFunction to use in a compute operation.
         * 
         * The option is a:
         * &lt;code&gt;java.util.function.BiFunction&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param remappingFunction the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanRemoteEndpointConsumerBuilder remappingFunction(
                BiFunction remappingFunction) {
            doSetProperty("remappingFunction", remappingFunction);
            return this;
        }
        /**
         * Set a specific remappingFunction to use in a compute operation.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.function.BiFunction&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param remappingFunction the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanRemoteEndpointConsumerBuilder remappingFunction(
                String remappingFunction) {
            doSetProperty("remappingFunction", remappingFunction);
            return this;
        }
        /**
         * Store the operation result in a header instead of the message body.
         * By default, resultHeader == null and the query result is stored in
         * the message body, any existing content in the message body is
         * discarded. If resultHeader is set, the value is used as the name of
         * the header to store the query result and the original message body is
         * preserved. This value can be overridden by an in message header
         * named: CamelInfinispanOperationResultHeader.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param resultHeader the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanRemoteEndpointConsumerBuilder resultHeader(
                String resultHeader) {
            doSetProperty("resultHeader", resultHeader);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Infinispan component.
     */
    public interface InfinispanRemoteEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedInfinispanRemoteEndpointProducerBuilder advanced() {
            return (AdvancedInfinispanRemoteEndpointProducerBuilder) this;
        }
        /**
         * Specifies the host of the cache on Infinispan instance.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param hosts the value to set
         * @return the dsl builder
         */
        default InfinispanRemoteEndpointProducerBuilder hosts(String hosts) {
            doSetProperty("hosts", hosts);
            return this;
        }
        /**
         * Specifies the query builder.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.infinispan.InfinispanQueryBuilder&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param queryBuilder the value to set
         * @return the dsl builder
         */
        default InfinispanRemoteEndpointProducerBuilder queryBuilder(
                org.apache.camel.component.infinispan.InfinispanQueryBuilder queryBuilder) {
            doSetProperty("queryBuilder", queryBuilder);
            return this;
        }
        /**
         * Specifies the query builder.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.infinispan.InfinispanQueryBuilder&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param queryBuilder the value to set
         * @return the dsl builder
         */
        default InfinispanRemoteEndpointProducerBuilder queryBuilder(
                String queryBuilder) {
            doSetProperty("queryBuilder", queryBuilder);
            return this;
        }
        /**
         * Define if we are connecting to a secured Infinispan instance.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param secure the value to set
         * @return the dsl builder
         */
        default InfinispanRemoteEndpointProducerBuilder secure(boolean secure) {
            doSetProperty("secure", secure);
            return this;
        }
        /**
         * Define if we are connecting to a secured Infinispan instance.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param secure the value to set
         * @return the dsl builder
         */
        default InfinispanRemoteEndpointProducerBuilder secure(String secure) {
            doSetProperty("secure", secure);
            return this;
        }
        /**
         * Set a specific default value for some producer operations.
         * 
         * The option is a: &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param defaultValue the value to set
         * @return the dsl builder
         */
        default InfinispanRemoteEndpointProducerBuilder defaultValue(
                Object defaultValue) {
            doSetProperty("defaultValue", defaultValue);
            return this;
        }
        /**
         * Set a specific default value for some producer operations.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param defaultValue the value to set
         * @return the dsl builder
         */
        default InfinispanRemoteEndpointProducerBuilder defaultValue(
                String defaultValue) {
            doSetProperty("defaultValue", defaultValue);
            return this;
        }
        /**
         * Set a specific key for producer operations.
         * 
         * The option is a: &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param key the value to set
         * @return the dsl builder
         */
        default InfinispanRemoteEndpointProducerBuilder key(Object key) {
            doSetProperty("key", key);
            return this;
        }
        /**
         * Set a specific key for producer operations.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param key the value to set
         * @return the dsl builder
         */
        default InfinispanRemoteEndpointProducerBuilder key(String key) {
            doSetProperty("key", key);
            return this;
        }
        /**
         * Set a specific old value for some producer operations.
         * 
         * The option is a: &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param oldValue the value to set
         * @return the dsl builder
         */
        default InfinispanRemoteEndpointProducerBuilder oldValue(Object oldValue) {
            doSetProperty("oldValue", oldValue);
            return this;
        }
        /**
         * Set a specific old value for some producer operations.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param oldValue the value to set
         * @return the dsl builder
         */
        default InfinispanRemoteEndpointProducerBuilder oldValue(String oldValue) {
            doSetProperty("oldValue", oldValue);
            return this;
        }
        /**
         * The operation to perform.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.infinispan.InfinispanOperation&lt;/code&gt; type.
         * 
         * Default: PUT
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default InfinispanRemoteEndpointProducerBuilder operation(
                org.apache.camel.component.infinispan.InfinispanOperation operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * The operation to perform.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.infinispan.InfinispanOperation&lt;/code&gt; type.
         * 
         * Default: PUT
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default InfinispanRemoteEndpointProducerBuilder operation(
                String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * Set a specific value for producer operations.
         * 
         * The option is a: &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param value the value to set
         * @return the dsl builder
         */
        default InfinispanRemoteEndpointProducerBuilder value(Object value) {
            doSetProperty("value", value);
            return this;
        }
        /**
         * Set a specific value for producer operations.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param value the value to set
         * @return the dsl builder
         */
        default InfinispanRemoteEndpointProducerBuilder value(String value) {
            doSetProperty("value", value);
            return this;
        }
        /**
         * Define the password to access the infinispan instance.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default InfinispanRemoteEndpointProducerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Define the SASL Mechanism to access the infinispan instance.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param saslMechanism the value to set
         * @return the dsl builder
         */
        default InfinispanRemoteEndpointProducerBuilder saslMechanism(
                String saslMechanism) {
            doSetProperty("saslMechanism", saslMechanism);
            return this;
        }
        /**
         * Define the security realm to access the infinispan instance.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param securityRealm the value to set
         * @return the dsl builder
         */
        default InfinispanRemoteEndpointProducerBuilder securityRealm(
                String securityRealm) {
            doSetProperty("securityRealm", securityRealm);
            return this;
        }
        /**
         * Define the security server name to access the infinispan instance.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param securityServerName the value to set
         * @return the dsl builder
         */
        default InfinispanRemoteEndpointProducerBuilder securityServerName(
                String securityServerName) {
            doSetProperty("securityServerName", securityServerName);
            return this;
        }
        /**
         * Define the username to access the infinispan instance.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default InfinispanRemoteEndpointProducerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Infinispan component.
     */
    public interface AdvancedInfinispanRemoteEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default InfinispanRemoteEndpointProducerBuilder basic() {
            return (InfinispanRemoteEndpointProducerBuilder) this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanRemoteEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanRemoteEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Specifies the cache Container to connect.
         * 
         * The option is a:
         * &lt;code&gt;org.infinispan.client.hotrod.RemoteCacheManager&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param cacheContainer the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanRemoteEndpointProducerBuilder cacheContainer(
                org.infinispan.client.hotrod.RemoteCacheManager cacheContainer) {
            doSetProperty("cacheContainer", cacheContainer);
            return this;
        }
        /**
         * Specifies the cache Container to connect.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.infinispan.client.hotrod.RemoteCacheManager&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param cacheContainer the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanRemoteEndpointProducerBuilder cacheContainer(
                String cacheContainer) {
            doSetProperty("cacheContainer", cacheContainer);
            return this;
        }
        /**
         * The CacheContainer configuration. Used if the cacheContainer is not
         * defined.
         * 
         * The option is a:
         * &lt;code&gt;org.infinispan.client.hotrod.configuration.Configuration&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param cacheContainerConfiguration the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanRemoteEndpointProducerBuilder cacheContainerConfiguration(
                org.infinispan.client.hotrod.configuration.Configuration cacheContainerConfiguration) {
            doSetProperty("cacheContainerConfiguration", cacheContainerConfiguration);
            return this;
        }
        /**
         * The CacheContainer configuration. Used if the cacheContainer is not
         * defined.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.infinispan.client.hotrod.configuration.Configuration&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param cacheContainerConfiguration the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanRemoteEndpointProducerBuilder cacheContainerConfiguration(
                String cacheContainerConfiguration) {
            doSetProperty("cacheContainerConfiguration", cacheContainerConfiguration);
            return this;
        }
        /**
         * Implementation specific properties for the CacheManager.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param configurationProperties the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanRemoteEndpointProducerBuilder configurationProperties(
                Map<java.lang.String, java.lang.String> configurationProperties) {
            doSetProperty("configurationProperties", configurationProperties);
            return this;
        }
        /**
         * Implementation specific properties for the CacheManager.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param configurationProperties the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanRemoteEndpointProducerBuilder configurationProperties(
                String configurationProperties) {
            doSetProperty("configurationProperties", configurationProperties);
            return this;
        }
        /**
         * An implementation specific URI for the CacheManager.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param configurationUri the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanRemoteEndpointProducerBuilder configurationUri(
                String configurationUri) {
            doSetProperty("configurationUri", configurationUri);
            return this;
        }
        /**
         * A comma separated list of org.infinispan.client.hotrod.Flag to be
         * applied by default on each cache invocation.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param flags the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanRemoteEndpointProducerBuilder flags(
                String flags) {
            doSetProperty("flags", flags);
            return this;
        }
        /**
         * Set a specific remappingFunction to use in a compute operation.
         * 
         * The option is a:
         * &lt;code&gt;java.util.function.BiFunction&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param remappingFunction the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanRemoteEndpointProducerBuilder remappingFunction(
                BiFunction remappingFunction) {
            doSetProperty("remappingFunction", remappingFunction);
            return this;
        }
        /**
         * Set a specific remappingFunction to use in a compute operation.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.function.BiFunction&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param remappingFunction the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanRemoteEndpointProducerBuilder remappingFunction(
                String remappingFunction) {
            doSetProperty("remappingFunction", remappingFunction);
            return this;
        }
        /**
         * Store the operation result in a header instead of the message body.
         * By default, resultHeader == null and the query result is stored in
         * the message body, any existing content in the message body is
         * discarded. If resultHeader is set, the value is used as the name of
         * the header to store the query result and the original message body is
         * preserved. This value can be overridden by an in message header
         * named: CamelInfinispanOperationResultHeader.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param resultHeader the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanRemoteEndpointProducerBuilder resultHeader(
                String resultHeader) {
            doSetProperty("resultHeader", resultHeader);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Infinispan component.
     */
    public interface InfinispanRemoteEndpointBuilder
            extends
                InfinispanRemoteEndpointConsumerBuilder,
                InfinispanRemoteEndpointProducerBuilder {
        default AdvancedInfinispanRemoteEndpointBuilder advanced() {
            return (AdvancedInfinispanRemoteEndpointBuilder) this;
        }
        /**
         * Specifies the host of the cache on Infinispan instance.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param hosts the value to set
         * @return the dsl builder
         */
        default InfinispanRemoteEndpointBuilder hosts(String hosts) {
            doSetProperty("hosts", hosts);
            return this;
        }
        /**
         * Specifies the query builder.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.infinispan.InfinispanQueryBuilder&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param queryBuilder the value to set
         * @return the dsl builder
         */
        default InfinispanRemoteEndpointBuilder queryBuilder(
                org.apache.camel.component.infinispan.InfinispanQueryBuilder queryBuilder) {
            doSetProperty("queryBuilder", queryBuilder);
            return this;
        }
        /**
         * Specifies the query builder.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.infinispan.InfinispanQueryBuilder&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param queryBuilder the value to set
         * @return the dsl builder
         */
        default InfinispanRemoteEndpointBuilder queryBuilder(String queryBuilder) {
            doSetProperty("queryBuilder", queryBuilder);
            return this;
        }
        /**
         * Define if we are connecting to a secured Infinispan instance.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param secure the value to set
         * @return the dsl builder
         */
        default InfinispanRemoteEndpointBuilder secure(boolean secure) {
            doSetProperty("secure", secure);
            return this;
        }
        /**
         * Define if we are connecting to a secured Infinispan instance.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param secure the value to set
         * @return the dsl builder
         */
        default InfinispanRemoteEndpointBuilder secure(String secure) {
            doSetProperty("secure", secure);
            return this;
        }
        /**
         * Define the password to access the infinispan instance.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default InfinispanRemoteEndpointBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Define the SASL Mechanism to access the infinispan instance.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param saslMechanism the value to set
         * @return the dsl builder
         */
        default InfinispanRemoteEndpointBuilder saslMechanism(
                String saslMechanism) {
            doSetProperty("saslMechanism", saslMechanism);
            return this;
        }
        /**
         * Define the security realm to access the infinispan instance.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param securityRealm the value to set
         * @return the dsl builder
         */
        default InfinispanRemoteEndpointBuilder securityRealm(
                String securityRealm) {
            doSetProperty("securityRealm", securityRealm);
            return this;
        }
        /**
         * Define the security server name to access the infinispan instance.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param securityServerName the value to set
         * @return the dsl builder
         */
        default InfinispanRemoteEndpointBuilder securityServerName(
                String securityServerName) {
            doSetProperty("securityServerName", securityServerName);
            return this;
        }
        /**
         * Define the username to access the infinispan instance.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default InfinispanRemoteEndpointBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Infinispan component.
     */
    public interface AdvancedInfinispanRemoteEndpointBuilder
            extends
                AdvancedInfinispanRemoteEndpointConsumerBuilder,
                AdvancedInfinispanRemoteEndpointProducerBuilder {
        default InfinispanRemoteEndpointBuilder basic() {
            return (InfinispanRemoteEndpointBuilder) this;
        }
        /**
         * Specifies the cache Container to connect.
         * 
         * The option is a:
         * &lt;code&gt;org.infinispan.client.hotrod.RemoteCacheManager&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param cacheContainer the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanRemoteEndpointBuilder cacheContainer(
                org.infinispan.client.hotrod.RemoteCacheManager cacheContainer) {
            doSetProperty("cacheContainer", cacheContainer);
            return this;
        }
        /**
         * Specifies the cache Container to connect.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.infinispan.client.hotrod.RemoteCacheManager&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param cacheContainer the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanRemoteEndpointBuilder cacheContainer(
                String cacheContainer) {
            doSetProperty("cacheContainer", cacheContainer);
            return this;
        }
        /**
         * The CacheContainer configuration. Used if the cacheContainer is not
         * defined.
         * 
         * The option is a:
         * &lt;code&gt;org.infinispan.client.hotrod.configuration.Configuration&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param cacheContainerConfiguration the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanRemoteEndpointBuilder cacheContainerConfiguration(
                org.infinispan.client.hotrod.configuration.Configuration cacheContainerConfiguration) {
            doSetProperty("cacheContainerConfiguration", cacheContainerConfiguration);
            return this;
        }
        /**
         * The CacheContainer configuration. Used if the cacheContainer is not
         * defined.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.infinispan.client.hotrod.configuration.Configuration&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param cacheContainerConfiguration the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanRemoteEndpointBuilder cacheContainerConfiguration(
                String cacheContainerConfiguration) {
            doSetProperty("cacheContainerConfiguration", cacheContainerConfiguration);
            return this;
        }
        /**
         * Implementation specific properties for the CacheManager.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param configurationProperties the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanRemoteEndpointBuilder configurationProperties(
                Map<java.lang.String, java.lang.String> configurationProperties) {
            doSetProperty("configurationProperties", configurationProperties);
            return this;
        }
        /**
         * Implementation specific properties for the CacheManager.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param configurationProperties the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanRemoteEndpointBuilder configurationProperties(
                String configurationProperties) {
            doSetProperty("configurationProperties", configurationProperties);
            return this;
        }
        /**
         * An implementation specific URI for the CacheManager.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param configurationUri the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanRemoteEndpointBuilder configurationUri(
                String configurationUri) {
            doSetProperty("configurationUri", configurationUri);
            return this;
        }
        /**
         * A comma separated list of org.infinispan.client.hotrod.Flag to be
         * applied by default on each cache invocation.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param flags the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanRemoteEndpointBuilder flags(String flags) {
            doSetProperty("flags", flags);
            return this;
        }
        /**
         * Set a specific remappingFunction to use in a compute operation.
         * 
         * The option is a:
         * &lt;code&gt;java.util.function.BiFunction&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param remappingFunction the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanRemoteEndpointBuilder remappingFunction(
                BiFunction remappingFunction) {
            doSetProperty("remappingFunction", remappingFunction);
            return this;
        }
        /**
         * Set a specific remappingFunction to use in a compute operation.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.function.BiFunction&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param remappingFunction the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanRemoteEndpointBuilder remappingFunction(
                String remappingFunction) {
            doSetProperty("remappingFunction", remappingFunction);
            return this;
        }
        /**
         * Store the operation result in a header instead of the message body.
         * By default, resultHeader == null and the query result is stored in
         * the message body, any existing content in the message body is
         * discarded. If resultHeader is set, the value is used as the name of
         * the header to store the query result and the original message body is
         * preserved. This value can be overridden by an in message header
         * named: CamelInfinispanOperationResultHeader.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param resultHeader the value to set
         * @return the dsl builder
         */
        default AdvancedInfinispanRemoteEndpointBuilder resultHeader(
                String resultHeader) {
            doSetProperty("resultHeader", resultHeader);
            return this;
        }
    }

    public interface InfinispanRemoteBuilders {
        /**
         * Infinispan (camel-infinispan)
         * Read and write from/to Infinispan distributed key/value store and
         * data grid.
         * 
         * Category: cache,clustering
         * Since: 2.13
         * Maven coordinates: org.apache.camel:camel-infinispan
         * 
         * @return the dsl builder for the headers' name.
         */
        default InfinispanRemoteHeaderNameBuilder infinispan() {
            return InfinispanRemoteHeaderNameBuilder.INSTANCE;
        }
        /**
         * Infinispan (camel-infinispan)
         * Read and write from/to Infinispan distributed key/value store and
         * data grid.
         * 
         * Category: cache,clustering
         * Since: 2.13
         * Maven coordinates: org.apache.camel:camel-infinispan
         * 
         * Syntax: <code>infinispan:cacheName</code>
         * 
         * Path parameter: cacheName (required)
         * The name of the cache to use. Use current to use the existing cache
         * name from the currently configured cached manager. Or use default for
         * the default cache manager name.
         * 
         * @param path cacheName
         * @return the dsl builder
         */
        default InfinispanRemoteEndpointBuilder infinispan(String path) {
            return InfinispanRemoteEndpointBuilderFactory.endpointBuilder("infinispan", path);
        }
        /**
         * Infinispan (camel-infinispan)
         * Read and write from/to Infinispan distributed key/value store and
         * data grid.
         * 
         * Category: cache,clustering
         * Since: 2.13
         * Maven coordinates: org.apache.camel:camel-infinispan
         * 
         * Syntax: <code>infinispan:cacheName</code>
         * 
         * Path parameter: cacheName (required)
         * The name of the cache to use. Use current to use the existing cache
         * name from the currently configured cached manager. Or use default for
         * the default cache manager name.
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path cacheName
         * @return the dsl builder
         */
        default InfinispanRemoteEndpointBuilder infinispan(
                String componentName,
                String path) {
            return InfinispanRemoteEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    /**
     * The builder of headers' name for the Infinispan component.
     */
    public static class InfinispanRemoteHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final InfinispanRemoteHeaderNameBuilder INSTANCE = new InfinispanRemoteHeaderNameBuilder();

        /**
         * The type of the received event.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code InfinispanEventType}.
         */
        public String infinispanEventType() {
            return "InfinispanEventType";
        }

        /**
         * The cache participating in the operation or event.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code InfinispanCacheName}.
         */
        public String infinispanCacheName() {
            return "InfinispanCacheName";
        }

        /**
         * The key to perform the operation to or the key generating the event.
         * 
         * The option is a: {@code Object} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code InfinispanKey}.
         */
        public String infinispanKey() {
            return "InfinispanKey";
        }

        /**
         * The value to use for the operation.
         * 
         * The option is a: {@code Object} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code InfinispanValue}.
         */
        public String infinispanValue() {
            return "InfinispanValue";
        }

        /**
         * The default value to use for a getOrDefault.
         * 
         * The option is a: {@code Object} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code InfinispanDefaultValue}.
         */
        public String infinispanDefaultValue() {
            return "InfinispanDefaultValue";
        }

        /**
         * The old value to use for a replace.
         * 
         * The option is a: {@code Object} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code InfinispanOldValue}.
         */
        public String infinispanOldValue() {
            return "InfinispanOldValue";
        }

        /**
         * A Map to use in case of CamelInfinispanOperationPutAll operation.
         * 
         * The option is a: {@code Map} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code InfinispanMap}.
         */
        public String infinispanMap() {
            return "InfinispanMap";
        }

        /**
         * The operation to perform.
         * 
         * The option is a: {@code
         * org.apache.camel.component.infinispan.InfinispanOperation} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code InfinispanOperation}.
         */
        public String infinispanOperation() {
            return "InfinispanOperation";
        }

        /**
         * The name of the header whose value is the result.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code InfinispanOperationResult}.
         */
        public String infinispanOperationResult() {
            return "InfinispanOperationResult";
        }

        /**
         * Store the operation result in a header instead of the message body.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * InfinispanOperationResultHeader}.
         */
        public String infinispanOperationResultHeader() {
            return "InfinispanOperationResultHeader";
        }

        /**
         * The Lifespan time of a value inside the cache. Negative values are
         * interpreted as infinity.
         * 
         * The option is a: {@code long} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code InfinispanLifespanTime}.
         */
        public String infinispanLifespanTime() {
            return "InfinispanLifespanTime";
        }

        /**
         * The Time Unit of an entry Lifespan Time.
         * 
         * The option is a: {@code java.util.concurrent.TimeUnit} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code InfinispanTimeUnit}.
         */
        public String infinispanTimeUnit() {
            return "InfinispanTimeUnit";
        }

        /**
         * The maximum amount of time an entry is allowed to be idle for before
         * it is considered as expired.
         * 
         * The option is a: {@code long} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code InfinispanMaxIdleTime}.
         */
        public String infinispanMaxIdleTime() {
            return "InfinispanMaxIdleTime";
        }

        /**
         * The Time Unit of an entry Max Idle Time.
         * 
         * The option is a: {@code java.util.concurrent.TimeUnit} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code InfinispanMaxIdleTimeUnit}.
         */
        public String infinispanMaxIdleTimeUnit() {
            return "InfinispanMaxIdleTimeUnit";
        }

        /**
         * The event data.
         * 
         * The option is a: {@code Object} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code InfinispanEventData}.
         */
        public String infinispanEventData() {
            return "InfinispanEventData";
        }

        /**
         * The QueryBuilder to use for QUERY command, if not present the command
         * defaults to InifinispanConfiguration's one.
         * 
         * The option is a: {@code
         * org.apache.camel.component.infinispan.InfinispanQueryBuilder} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code InfinispanQueryBuilder}.
         */
        public String infinispanQueryBuilder() {
            return "InfinispanQueryBuilder";
        }

        /**
         * Provides access to the version of the created cache entry.
         * 
         * The option is a: {@code long} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code InfinispanEntryVersion}.
         */
        public String infinispanEntryVersion() {
            return "InfinispanEntryVersion";
        }

        /**
         * This will be true if the write command that caused this had to be
         * retried again due to a topology change.
         * 
         * The option is a: {@code boolean} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code InfinispanCommandRetried}.
         */
        public String infinispanCommandRetried() {
            return "InfinispanCommandRetried";
        }
    }
    static InfinispanRemoteEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class InfinispanRemoteEndpointBuilderImpl extends AbstractEndpointBuilder implements InfinispanRemoteEndpointBuilder, AdvancedInfinispanRemoteEndpointBuilder {
            public InfinispanRemoteEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new InfinispanRemoteEndpointBuilderImpl(path);
    }
}