/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.Map;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Manage Zendesk tickets, users, organizations, etc.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface ZendeskEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Zendesk component.
     */
    public interface ZendeskEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedZendeskEndpointConsumerBuilder advanced() {
            return (AdvancedZendeskEndpointConsumerBuilder) this;
        }
        /**
         * Sets the name of a parameter to be passed in the exchange In Body.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param inBody the value to set
         * @return the dsl builder
         */
        default ZendeskEndpointConsumerBuilder inBody(String inBody) {
            doSetProperty("inBody", inBody);
            return this;
        }
        /**
         * The server URL to connect.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param serverUrl the value to set
         * @return the dsl builder
         */
        default ZendeskEndpointConsumerBuilder serverUrl(String serverUrl) {
            doSetProperty("serverUrl", serverUrl);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default ZendeskEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                boolean sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default ZendeskEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                String sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default ZendeskEndpointConsumerBuilder backoffErrorThreshold(
                int backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default ZendeskEndpointConsumerBuilder backoffErrorThreshold(
                String backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default ZendeskEndpointConsumerBuilder backoffIdleThreshold(
                int backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default ZendeskEndpointConsumerBuilder backoffIdleThreshold(
                String backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default ZendeskEndpointConsumerBuilder backoffMultiplier(
                int backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default ZendeskEndpointConsumerBuilder backoffMultiplier(
                String backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: scheduler
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default ZendeskEndpointConsumerBuilder delay(long delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: scheduler
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default ZendeskEndpointConsumerBuilder delay(String delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default ZendeskEndpointConsumerBuilder greedy(boolean greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default ZendeskEndpointConsumerBuilder greedy(String greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default ZendeskEndpointConsumerBuilder initialDelay(long initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default ZendeskEndpointConsumerBuilder initialDelay(String initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default ZendeskEndpointConsumerBuilder repeatCount(long repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default ZendeskEndpointConsumerBuilder repeatCount(String repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default ZendeskEndpointConsumerBuilder runLoggingLevel(
                org.apache.camel.LoggingLevel runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default ZendeskEndpointConsumerBuilder runLoggingLevel(
                String runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option is a:
         * &lt;code&gt;java.util.concurrent.ScheduledExecutorService&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default ZendeskEndpointConsumerBuilder scheduledExecutorService(
                ScheduledExecutorService scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.concurrent.ScheduledExecutorService&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default ZendeskEndpointConsumerBuilder scheduledExecutorService(
                String scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option is a: &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default ZendeskEndpointConsumerBuilder scheduler(Object scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default ZendeskEndpointConsumerBuilder scheduler(String scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default ZendeskEndpointConsumerBuilder schedulerProperties(
                String key,
                Object value) {
            doSetMultiValueProperty("schedulerProperties", "scheduler." + key, value);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param values the values
         * @return the dsl builder
         */
        default ZendeskEndpointConsumerBuilder schedulerProperties(Map values) {
            doSetMultiValueProperties("schedulerProperties", "scheduler.", values);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default ZendeskEndpointConsumerBuilder startScheduler(
                boolean startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default ZendeskEndpointConsumerBuilder startScheduler(
                String startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option is a:
         * &lt;code&gt;java.util.concurrent.TimeUnit&lt;/code&gt; type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default ZendeskEndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.concurrent.TimeUnit&lt;/code&gt; type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default ZendeskEndpointConsumerBuilder timeUnit(String timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default ZendeskEndpointConsumerBuilder useFixedDelay(
                boolean useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default ZendeskEndpointConsumerBuilder useFixedDelay(
                String useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * The OAuth token.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param oauthToken the value to set
         * @return the dsl builder
         */
        default ZendeskEndpointConsumerBuilder oauthToken(String oauthToken) {
            doSetProperty("oauthToken", oauthToken);
            return this;
        }
        /**
         * The password.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default ZendeskEndpointConsumerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * The security token.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param token the value to set
         * @return the dsl builder
         */
        default ZendeskEndpointConsumerBuilder token(String token) {
            doSetProperty("token", token);
            return this;
        }
        /**
         * The user name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default ZendeskEndpointConsumerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Zendesk component.
     */
    public interface AdvancedZendeskEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default ZendeskEndpointConsumerBuilder basic() {
            return (ZendeskEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedZendeskEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedZendeskEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedZendeskEndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedZendeskEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedZendeskEndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedZendeskEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.PollingConsumerPollStrategy&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedZendeskEndpointConsumerBuilder pollStrategy(
                org.apache.camel.spi.PollingConsumerPollStrategy pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.PollingConsumerPollStrategy&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedZendeskEndpointConsumerBuilder pollStrategy(
                String pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Zendesk component.
     */
    public interface ZendeskEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedZendeskEndpointProducerBuilder advanced() {
            return (AdvancedZendeskEndpointProducerBuilder) this;
        }
        /**
         * Sets the name of a parameter to be passed in the exchange In Body.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param inBody the value to set
         * @return the dsl builder
         */
        default ZendeskEndpointProducerBuilder inBody(String inBody) {
            doSetProperty("inBody", inBody);
            return this;
        }
        /**
         * The server URL to connect.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param serverUrl the value to set
         * @return the dsl builder
         */
        default ZendeskEndpointProducerBuilder serverUrl(String serverUrl) {
            doSetProperty("serverUrl", serverUrl);
            return this;
        }
        /**
         * The OAuth token.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param oauthToken the value to set
         * @return the dsl builder
         */
        default ZendeskEndpointProducerBuilder oauthToken(String oauthToken) {
            doSetProperty("oauthToken", oauthToken);
            return this;
        }
        /**
         * The password.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default ZendeskEndpointProducerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * The security token.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param token the value to set
         * @return the dsl builder
         */
        default ZendeskEndpointProducerBuilder token(String token) {
            doSetProperty("token", token);
            return this;
        }
        /**
         * The user name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default ZendeskEndpointProducerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Zendesk component.
     */
    public interface AdvancedZendeskEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default ZendeskEndpointProducerBuilder basic() {
            return (ZendeskEndpointProducerBuilder) this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedZendeskEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedZendeskEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Zendesk component.
     */
    public interface ZendeskEndpointBuilder
            extends
                ZendeskEndpointConsumerBuilder,
                ZendeskEndpointProducerBuilder {
        default AdvancedZendeskEndpointBuilder advanced() {
            return (AdvancedZendeskEndpointBuilder) this;
        }
        /**
         * Sets the name of a parameter to be passed in the exchange In Body.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param inBody the value to set
         * @return the dsl builder
         */
        default ZendeskEndpointBuilder inBody(String inBody) {
            doSetProperty("inBody", inBody);
            return this;
        }
        /**
         * The server URL to connect.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param serverUrl the value to set
         * @return the dsl builder
         */
        default ZendeskEndpointBuilder serverUrl(String serverUrl) {
            doSetProperty("serverUrl", serverUrl);
            return this;
        }
        /**
         * The OAuth token.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param oauthToken the value to set
         * @return the dsl builder
         */
        default ZendeskEndpointBuilder oauthToken(String oauthToken) {
            doSetProperty("oauthToken", oauthToken);
            return this;
        }
        /**
         * The password.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default ZendeskEndpointBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * The security token.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param token the value to set
         * @return the dsl builder
         */
        default ZendeskEndpointBuilder token(String token) {
            doSetProperty("token", token);
            return this;
        }
        /**
         * The user name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default ZendeskEndpointBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Zendesk component.
     */
    public interface AdvancedZendeskEndpointBuilder
            extends
                AdvancedZendeskEndpointConsumerBuilder,
                AdvancedZendeskEndpointProducerBuilder {
        default ZendeskEndpointBuilder basic() {
            return (ZendeskEndpointBuilder) this;
        }
    }

    public interface ZendeskBuilders {
        /**
         * Zendesk (camel-zendesk)
         * Manage Zendesk tickets, users, organizations, etc.
         * 
         * Category: cloud,api,saas
         * Since: 2.19
         * Maven coordinates: org.apache.camel:camel-zendesk
         * 
         * Syntax: <code>zendesk:methodName</code>
         * 
         * Path parameter: methodName (required)
         * What operation to use
         * There are 355 enums and the value can be one of:
         * ADD_TAG_TO_ORGANISATIONS, ADD_TAG_TO_TICKET, ADD_TAG_TO_TOPICS,
         * ASSOCIATE_ATTACHMENTS_TO_ARTICLE, CHANGE_USER_PASSWORD,
         * CREATE_ARTICLE, CREATE_ARTICLE_1, CREATE_ARTICLE_TRANSLATION,
         * CREATE_AUTOMATION, CREATE_CATEGORY, CREATE_CATEGORY_TRANSLATION,
         * CREATE_COMMENT, CREATE_DYNAMIC_CONTENT_ITEM,
         * CREATE_DYNAMIC_CONTENT_ITEM_VARIANT, CREATE_FORUM, CREATE_GROUP,
         * CREATE_GROUP_MEMBERSHIP, CREATE_GROUP_MEMBERSHIP_1, CREATE_MACRO,
         * CREATE_OR_UPDATE_USER, CREATE_OR_UPDATE_USERS,
         * CREATE_OR_UPDATE_USERS_1, CREATE_OR_UPDATE_USERS_ASYNC,
         * CREATE_ORGANIZATION, CREATE_ORGANIZATION_MEMBERSHIP,
         * CREATE_ORGANIZATION_MEMBERSHIP_1, CREATE_ORGANIZATION_MEMBERSHIPS,
         * CREATE_ORGANIZATION_MEMBERSHIPS_1,
         * CREATE_ORGANIZATION_MEMBERSHIPS_ASYNC, CREATE_ORGANIZATIONS,
         * CREATE_ORGANIZATIONS_1, CREATE_ORGANIZATIONS_ASYNC,
         * CREATE_PERMISSION_GROUP, CREATE_REQUEST, CREATE_SATISFACTION_RATING,
         * CREATE_SATISFACTION_RATING_1, CREATE_SECTION,
         * CREATE_SECTION_TRANSLATION, CREATE_TARGET, CREATE_TICKET,
         * CREATE_TICKET_ASYNC, CREATE_TICKET_FIELD, CREATE_TICKET_FORM,
         * CREATE_TICKET_FROM_TWEET, CREATE_TICKETS, CREATE_TICKETS_1,
         * CREATE_TICKETS_ASYNC, CREATE_TOPIC, CREATE_TRIGGER, CREATE_UPLOAD,
         * CREATE_UPLOAD_1, CREATE_UPLOAD_2, CREATE_UPLOAD_ARTICLE,
         * CREATE_UPLOAD_ARTICLE_1, CREATE_USER, CREATE_USER_IDENTITY,
         * CREATE_USER_IDENTITY_1, CREATE_USER_SEGMENT, CREATE_USERS,
         * CREATE_USERS_1, CREATE_USERS_ASYNC, DELETE_ARTICLE,
         * DELETE_ARTICLE_ATTACHMENT, DELETE_ARTICLE_ATTACHMENT_1,
         * DELETE_ATTACHMENT, DELETE_ATTACHMENT_1, DELETE_AUTOMATION,
         * DELETE_CATEGORY, DELETE_DYNAMIC_CONTENT_ITEM,
         * DELETE_DYNAMIC_CONTENT_ITEM_VARIANT, DELETE_FORUM, DELETE_GROUP,
         * DELETE_GROUP_1, DELETE_GROUP_MEMBERSHIP, DELETE_GROUP_MEMBERSHIP_1,
         * DELETE_GROUP_MEMBERSHIP_2, DELETE_GROUP_MEMBERSHIP_3,
         * DELETE_ORGANIZATION, DELETE_ORGANIZATION_1,
         * DELETE_ORGANIZATION_MEMBERSHIP, DELETE_ORGANIZATION_MEMBERSHIP_1,
         * DELETE_ORGANIZATION_MEMBERSHIP_2, DELETE_ORGANIZATION_MEMBERSHIPS,
         * DELETE_PERMISSION_GROUP, DELETE_PERMISSION_GROUP_1, DELETE_SECTION,
         * DELETE_SUSPENDED_TICKET, DELETE_SUSPENDED_TICKET_1, DELETE_TARGET,
         * DELETE_TICKET, DELETE_TICKET_1, DELETE_TICKET_FIELD,
         * DELETE_TICKET_FIELD_1, DELETE_TICKET_FORM, DELETE_TICKET_FORM_1,
         * DELETE_TICKETS, DELETE_TOPIC, DELETE_TRANSLATION,
         * DELETE_TRANSLATION_1, DELETE_TRIGGER, DELETE_UPLOAD, DELETE_UPLOAD_1,
         * DELETE_USER, DELETE_USER_1, DELETE_USER_IDENTITY,
         * DELETE_USER_IDENTITY_1, DELETE_USER_IDENTITY_2, DELETE_USER_SEGMENT,
         * DELETE_USER_SEGMENT_1, GET_ACTIVE_TRIGGERS, GET_ARTICLE,
         * GET_ARTICLE_FROM_SEARCH, GET_ARTICLE_FROM_SEARCH_1,
         * GET_ARTICLE_SUBSCRIPTIONS, GET_ARTICLE_SUBSCRIPTIONS_1,
         * GET_ARTICLE_TRANSLATIONS, GET_ARTICLES, GET_ARTICLES_1,
         * GET_ARTICLES_2, GET_ARTICLES_3, GET_ARTICLES_FROM_ALL_LABELS,
         * GET_ARTICLES_FROM_ANY_LABELS, GET_ARTICLES_FROM_PAGE,
         * GET_ARTICLES_INCREMENTALLY, GET_ASSIGNABLE_GROUP_MEMBERSHIPS,
         * GET_ASSIGNABLE_GROUP_MEMBERSHIPS_1, GET_ASSIGNABLE_GROUPS,
         * GET_ASSIGNED_TICKETS_COUNT_FOR_USER, GET_ATTACHMENT,
         * GET_ATTACHMENT_1, GET_ATTACHMENTS_FROM_ARTICLE,
         * GET_AUTHENTICATED_USER, GET_AUTO_COMPLETE_ORGANIZATIONS,
         * GET_AUTOMATION, GET_AUTOMATIONS, GET_BRANDS, GET_CC_REQUESTS,
         * GET_CATEGORIES, GET_CATEGORY, GET_CATEGORY_TRANSLATIONS,
         * GET_CCD_TICKETS_COUNT_FOR_USER, GET_COMPLIANCE_DELETION_STATUSES,
         * GET_CURRENT_USER, GET_CUSTOM_AGENT_ROLES, GET_DELETED_TICKETS,
         * GET_DELETED_TICKETS_1, GET_DYNAMIC_CONTENT_ITEM,
         * GET_DYNAMIC_CONTENT_ITEM_VARIANT, GET_DYNAMIC_CONTENT_ITEM_VARIANTS,
         * GET_DYNAMIC_CONTENT_ITEMS, GET_FORUM, GET_FORUMS, GET_FORUMS_1,
         * GET_GROUP, GET_GROUP_MEMBERSHIP, GET_GROUP_MEMBERSHIP_1,
         * GET_GROUP_MEMBERSHIP_BY_USER, GET_GROUP_MEMBERSHIPS,
         * GET_GROUP_MEMBERSHIPS_1, GET_GROUP_ORGANIZATION, GET_GROUP_USERS,
         * GET_GROUPS, GET_HELP_CENTER_LOCALES, GET_HOLIDAYS_FOR_SCHEDULE,
         * GET_HOLIDAYS_FOR_SCHEDULE_1, GET_INCREMENTAL_TICKETS_RESULT,
         * GET_JOB_STATUS, GET_JOB_STATUS_ASYNC, GET_JOB_STATUSES,
         * GET_JOB_STATUSES_ASYNC, GET_MACRO, GET_MACROS, GET_OPEN_REQUESTS,
         * GET_ORGANIZATION, GET_ORGANIZATION_FIELDS,
         * GET_ORGANIZATION_MEMBERSHIP, GET_ORGANIZATION_MEMBERSHIP_BY_USER,
         * GET_ORGANIZATION_MEMBERSHIP_FOR_USER, GET_ORGANIZATION_MEMBERSHIPS,
         * GET_ORGANIZATION_MEMBERSHIPS_FOR_ORG,
         * GET_ORGANIZATION_MEMBERSHIPS_FOR_USER, GET_ORGANIZATION_REQUESTS,
         * GET_ORGANIZATION_TICKETS, GET_ORGANIZATION_USERS, GET_ORGANIZATIONS,
         * GET_ORGANIZATIONS_1, GET_ORGANIZATIONS_INCREMENTALLY,
         * GET_PERMISSION_GROUP, GET_PERMISSION_GROUPS, GET_RECENT_TICKETS,
         * GET_REQUEST, GET_REQUEST_COMMENT, GET_REQUEST_COMMENT_1,
         * GET_REQUEST_COMMENT_2, GET_REQUEST_COMMENTS, GET_REQUEST_COMMENTS_1,
         * GET_REQUESTS, GET_SATISFACTION_RATING, GET_SATISFACTION_RATINGS,
         * GET_SCHEDULE, GET_SCHEDULE_1, GET_SCHEDULES,
         * GET_SEARCH_TICKET_RESULTS, GET_SECTION, GET_SECTION_SUBSCRIPTIONS,
         * GET_SECTION_SUBSCRIPTIONS_1, GET_SECTION_TRANSLATIONS, GET_SECTIONS,
         * GET_SECTIONS_1, GET_SECTIONS_2, GET_SOLVED_REQUESTS,
         * GET_SUSPENDED_TICKETS, GET_TARGET, GET_TARGETS, GET_TICKET,
         * GET_TICKET_AUDIT, GET_TICKET_AUDIT_1, GET_TICKET_AUDIT_2,
         * GET_TICKET_AUDITS, GET_TICKET_AUDITS_1, GET_TICKET_COLLABORATORS,
         * GET_TICKET_COMMENTS, GET_TICKET_COMMENTS_1, GET_TICKET_FIELD,
         * GET_TICKET_FIELDS, GET_TICKET_FORM, GET_TICKET_FORMS,
         * GET_TICKET_INCIDENTS, GET_TICKET_METRIC, GET_TICKET_METRIC_BY_TICKET,
         * GET_TICKET_METRICS, GET_TICKETS, GET_TICKETS_1,
         * GET_TICKETS_BY_EXTERNAL_ID, GET_TICKETS_BY_EXTERNAL_ID_1,
         * GET_TICKETS_COUNT, GET_TICKETS_COUNT_FOR_ORGANIZATION,
         * GET_TICKETS_FROM_SEARCH, GET_TICKETS_INCREMENTALLY,
         * GET_TICKETS_INCREMENTALLY_1, GET_TOPIC, GET_TOPICS, GET_TOPICS_1,
         * GET_TOPICS_2, GET_TOPICS_3, GET_TOPICS_BY_USER, GET_TRIGGER,
         * GET_TRIGGERS, GET_TRIGGERS_1, GET_TWITTER_MONITORS, GET_USER,
         * GET_USER_CCD_TICKETS, GET_USER_FIELDS, GET_USER_IDENTITIES,
         * GET_USER_IDENTITIES_1, GET_USER_IDENTITY, GET_USER_IDENTITY_1,
         * GET_USER_IDENTITY_2, GET_USER_RELATED_INFO,
         * GET_USER_REQUESTED_TICKETS, GET_USER_REQUESTS, GET_USER_REQUESTS_1,
         * GET_USER_SEGMENT, GET_USER_SEGMENTS, GET_USER_SEGMENTS_1,
         * GET_USER_SEGMENTS_APPLICABLE, GET_USER_SUBSCRIPTIONS,
         * GET_USER_SUBSCRIPTIONS_1, GET_USERS, GET_USERS_1,
         * GET_USERS_BY_EXTERNAL_IDS, GET_USERS_BY_ROLE,
         * GET_USERS_INCREMENTALLY, GET_VIEW, GET_VIEWS, IMPORT_TICKET,
         * IMPORT_TOPIC, LOOKUP_ORGANIZATIONS_BY_EXTERNAL_ID,
         * LOOKUP_USER_BY_EMAIL, LOOKUP_USER_BY_EXTERNAL_ID,
         * MACROS_SHOW_CHANGES_TO_TICKET, MACROS_SHOW_TICKET_AFTER_CHANGES,
         * MAKE_PRIVATE_TICKET_AUDIT, MAKE_PRIVATE_TICKET_AUDIT_1,
         * MAKE_PRIVATE_TICKET_AUDIT_2, MARK_TICKET_AS_SPAM,
         * MARK_TICKET_AS_SPAM_1, MERGE_USERS, NOTIFY_APP,
         * PERMANENTLY_DELETE_TICKET, PERMANENTLY_DELETE_TICKET_1,
         * PERMANENTLY_DELETE_TICKETS, PERMANENTLY_DELETE_USER,
         * PERMANENTLY_DELETE_USER_1, QUEUE_CREATE_TICKET_ASYNC,
         * REMOVE_TAG_FROM_ORGANISATIONS, REMOVE_TAG_FROM_TICKET,
         * REMOVE_TAG_FROM_TOPICS, REQUEST_VERIFY_USER_IDENTITY,
         * REQUEST_VERIFY_USER_IDENTITY_1, REQUEST_VERIFY_USER_IDENTITY_2,
         * RESET_USER_PASSWORD, RESET_USER_PASSWORD_1, SEARCH_TRIGGERS,
         * SEARCH_TRIGGERS_1, SET_GROUP_MEMBERSHIP_AS_DEFAULT,
         * SET_ORGANIZATION_MEMBERSHIP_AS_DEFAULT, SET_TAG_ON_ORGANISATIONS,
         * SET_TAG_ON_TICKET, SET_TAG_ON_TOPICS, SET_USER_PRIMARY_IDENTITY,
         * SET_USER_PRIMARY_IDENTITY_1, SET_USER_PRIMARY_IDENTITY_2,
         * SUSPEND_USER, TRUST_TICKET_AUDIT, TRUST_TICKET_AUDIT_1,
         * TRUST_TICKET_AUDIT_2, UNSUSPEND_USER, UPDATE_ARTICLE,
         * UPDATE_ARTICLE_TRANSLATION, UPDATE_AUTOMATION, UPDATE_CATEGORY,
         * UPDATE_CATEGORY_TRANSLATION, UPDATE_DYNAMIC_CONTENT_ITEM,
         * UPDATE_DYNAMIC_CONTENT_ITEM_VARIANT, UPDATE_FORUM, UPDATE_GROUP,
         * UPDATE_INSTALLATION, UPDATE_MACRO, UPDATE_ORGANIZATION,
         * UPDATE_ORGANIZATIONS, UPDATE_ORGANIZATIONS_1,
         * UPDATE_ORGANIZATIONS_ASYNC, UPDATE_PERMISSION_GROUP, UPDATE_REQUEST,
         * UPDATE_SECTION, UPDATE_SECTION_TRANSLATION, UPDATE_TICKET,
         * UPDATE_TICKET_FIELD, UPDATE_TICKET_FORM, UPDATE_TICKETS,
         * UPDATE_TICKETS_1, UPDATE_TICKETS_ASYNC, UPDATE_TOPIC, UPDATE_TRIGGER,
         * UPDATE_USER, UPDATE_USER_IDENTITY, UPDATE_USER_IDENTITY_1,
         * UPDATE_USER_SEGMENT, UPDATE_USERS, UPDATE_USERS_1,
         * UPDATE_USERS_ASYNC, VERIFY_USER_IDENTITY, VERIFY_USER_IDENTITY_1,
         * VERIFY_USER_IDENTITY_2
         * 
         * @param path methodName
         * @return the dsl builder
         */
        default ZendeskEndpointBuilder zendesk(String path) {
            return ZendeskEndpointBuilderFactory.endpointBuilder("zendesk", path);
        }
        /**
         * Zendesk (camel-zendesk)
         * Manage Zendesk tickets, users, organizations, etc.
         * 
         * Category: cloud,api,saas
         * Since: 2.19
         * Maven coordinates: org.apache.camel:camel-zendesk
         * 
         * Syntax: <code>zendesk:methodName</code>
         * 
         * Path parameter: methodName (required)
         * What operation to use
         * There are 355 enums and the value can be one of:
         * ADD_TAG_TO_ORGANISATIONS, ADD_TAG_TO_TICKET, ADD_TAG_TO_TOPICS,
         * ASSOCIATE_ATTACHMENTS_TO_ARTICLE, CHANGE_USER_PASSWORD,
         * CREATE_ARTICLE, CREATE_ARTICLE_1, CREATE_ARTICLE_TRANSLATION,
         * CREATE_AUTOMATION, CREATE_CATEGORY, CREATE_CATEGORY_TRANSLATION,
         * CREATE_COMMENT, CREATE_DYNAMIC_CONTENT_ITEM,
         * CREATE_DYNAMIC_CONTENT_ITEM_VARIANT, CREATE_FORUM, CREATE_GROUP,
         * CREATE_GROUP_MEMBERSHIP, CREATE_GROUP_MEMBERSHIP_1, CREATE_MACRO,
         * CREATE_OR_UPDATE_USER, CREATE_OR_UPDATE_USERS,
         * CREATE_OR_UPDATE_USERS_1, CREATE_OR_UPDATE_USERS_ASYNC,
         * CREATE_ORGANIZATION, CREATE_ORGANIZATION_MEMBERSHIP,
         * CREATE_ORGANIZATION_MEMBERSHIP_1, CREATE_ORGANIZATION_MEMBERSHIPS,
         * CREATE_ORGANIZATION_MEMBERSHIPS_1,
         * CREATE_ORGANIZATION_MEMBERSHIPS_ASYNC, CREATE_ORGANIZATIONS,
         * CREATE_ORGANIZATIONS_1, CREATE_ORGANIZATIONS_ASYNC,
         * CREATE_PERMISSION_GROUP, CREATE_REQUEST, CREATE_SATISFACTION_RATING,
         * CREATE_SATISFACTION_RATING_1, CREATE_SECTION,
         * CREATE_SECTION_TRANSLATION, CREATE_TARGET, CREATE_TICKET,
         * CREATE_TICKET_ASYNC, CREATE_TICKET_FIELD, CREATE_TICKET_FORM,
         * CREATE_TICKET_FROM_TWEET, CREATE_TICKETS, CREATE_TICKETS_1,
         * CREATE_TICKETS_ASYNC, CREATE_TOPIC, CREATE_TRIGGER, CREATE_UPLOAD,
         * CREATE_UPLOAD_1, CREATE_UPLOAD_2, CREATE_UPLOAD_ARTICLE,
         * CREATE_UPLOAD_ARTICLE_1, CREATE_USER, CREATE_USER_IDENTITY,
         * CREATE_USER_IDENTITY_1, CREATE_USER_SEGMENT, CREATE_USERS,
         * CREATE_USERS_1, CREATE_USERS_ASYNC, DELETE_ARTICLE,
         * DELETE_ARTICLE_ATTACHMENT, DELETE_ARTICLE_ATTACHMENT_1,
         * DELETE_ATTACHMENT, DELETE_ATTACHMENT_1, DELETE_AUTOMATION,
         * DELETE_CATEGORY, DELETE_DYNAMIC_CONTENT_ITEM,
         * DELETE_DYNAMIC_CONTENT_ITEM_VARIANT, DELETE_FORUM, DELETE_GROUP,
         * DELETE_GROUP_1, DELETE_GROUP_MEMBERSHIP, DELETE_GROUP_MEMBERSHIP_1,
         * DELETE_GROUP_MEMBERSHIP_2, DELETE_GROUP_MEMBERSHIP_3,
         * DELETE_ORGANIZATION, DELETE_ORGANIZATION_1,
         * DELETE_ORGANIZATION_MEMBERSHIP, DELETE_ORGANIZATION_MEMBERSHIP_1,
         * DELETE_ORGANIZATION_MEMBERSHIP_2, DELETE_ORGANIZATION_MEMBERSHIPS,
         * DELETE_PERMISSION_GROUP, DELETE_PERMISSION_GROUP_1, DELETE_SECTION,
         * DELETE_SUSPENDED_TICKET, DELETE_SUSPENDED_TICKET_1, DELETE_TARGET,
         * DELETE_TICKET, DELETE_TICKET_1, DELETE_TICKET_FIELD,
         * DELETE_TICKET_FIELD_1, DELETE_TICKET_FORM, DELETE_TICKET_FORM_1,
         * DELETE_TICKETS, DELETE_TOPIC, DELETE_TRANSLATION,
         * DELETE_TRANSLATION_1, DELETE_TRIGGER, DELETE_UPLOAD, DELETE_UPLOAD_1,
         * DELETE_USER, DELETE_USER_1, DELETE_USER_IDENTITY,
         * DELETE_USER_IDENTITY_1, DELETE_USER_IDENTITY_2, DELETE_USER_SEGMENT,
         * DELETE_USER_SEGMENT_1, GET_ACTIVE_TRIGGERS, GET_ARTICLE,
         * GET_ARTICLE_FROM_SEARCH, GET_ARTICLE_FROM_SEARCH_1,
         * GET_ARTICLE_SUBSCRIPTIONS, GET_ARTICLE_SUBSCRIPTIONS_1,
         * GET_ARTICLE_TRANSLATIONS, GET_ARTICLES, GET_ARTICLES_1,
         * GET_ARTICLES_2, GET_ARTICLES_3, GET_ARTICLES_FROM_ALL_LABELS,
         * GET_ARTICLES_FROM_ANY_LABELS, GET_ARTICLES_FROM_PAGE,
         * GET_ARTICLES_INCREMENTALLY, GET_ASSIGNABLE_GROUP_MEMBERSHIPS,
         * GET_ASSIGNABLE_GROUP_MEMBERSHIPS_1, GET_ASSIGNABLE_GROUPS,
         * GET_ASSIGNED_TICKETS_COUNT_FOR_USER, GET_ATTACHMENT,
         * GET_ATTACHMENT_1, GET_ATTACHMENTS_FROM_ARTICLE,
         * GET_AUTHENTICATED_USER, GET_AUTO_COMPLETE_ORGANIZATIONS,
         * GET_AUTOMATION, GET_AUTOMATIONS, GET_BRANDS, GET_CC_REQUESTS,
         * GET_CATEGORIES, GET_CATEGORY, GET_CATEGORY_TRANSLATIONS,
         * GET_CCD_TICKETS_COUNT_FOR_USER, GET_COMPLIANCE_DELETION_STATUSES,
         * GET_CURRENT_USER, GET_CUSTOM_AGENT_ROLES, GET_DELETED_TICKETS,
         * GET_DELETED_TICKETS_1, GET_DYNAMIC_CONTENT_ITEM,
         * GET_DYNAMIC_CONTENT_ITEM_VARIANT, GET_DYNAMIC_CONTENT_ITEM_VARIANTS,
         * GET_DYNAMIC_CONTENT_ITEMS, GET_FORUM, GET_FORUMS, GET_FORUMS_1,
         * GET_GROUP, GET_GROUP_MEMBERSHIP, GET_GROUP_MEMBERSHIP_1,
         * GET_GROUP_MEMBERSHIP_BY_USER, GET_GROUP_MEMBERSHIPS,
         * GET_GROUP_MEMBERSHIPS_1, GET_GROUP_ORGANIZATION, GET_GROUP_USERS,
         * GET_GROUPS, GET_HELP_CENTER_LOCALES, GET_HOLIDAYS_FOR_SCHEDULE,
         * GET_HOLIDAYS_FOR_SCHEDULE_1, GET_INCREMENTAL_TICKETS_RESULT,
         * GET_JOB_STATUS, GET_JOB_STATUS_ASYNC, GET_JOB_STATUSES,
         * GET_JOB_STATUSES_ASYNC, GET_MACRO, GET_MACROS, GET_OPEN_REQUESTS,
         * GET_ORGANIZATION, GET_ORGANIZATION_FIELDS,
         * GET_ORGANIZATION_MEMBERSHIP, GET_ORGANIZATION_MEMBERSHIP_BY_USER,
         * GET_ORGANIZATION_MEMBERSHIP_FOR_USER, GET_ORGANIZATION_MEMBERSHIPS,
         * GET_ORGANIZATION_MEMBERSHIPS_FOR_ORG,
         * GET_ORGANIZATION_MEMBERSHIPS_FOR_USER, GET_ORGANIZATION_REQUESTS,
         * GET_ORGANIZATION_TICKETS, GET_ORGANIZATION_USERS, GET_ORGANIZATIONS,
         * GET_ORGANIZATIONS_1, GET_ORGANIZATIONS_INCREMENTALLY,
         * GET_PERMISSION_GROUP, GET_PERMISSION_GROUPS, GET_RECENT_TICKETS,
         * GET_REQUEST, GET_REQUEST_COMMENT, GET_REQUEST_COMMENT_1,
         * GET_REQUEST_COMMENT_2, GET_REQUEST_COMMENTS, GET_REQUEST_COMMENTS_1,
         * GET_REQUESTS, GET_SATISFACTION_RATING, GET_SATISFACTION_RATINGS,
         * GET_SCHEDULE, GET_SCHEDULE_1, GET_SCHEDULES,
         * GET_SEARCH_TICKET_RESULTS, GET_SECTION, GET_SECTION_SUBSCRIPTIONS,
         * GET_SECTION_SUBSCRIPTIONS_1, GET_SECTION_TRANSLATIONS, GET_SECTIONS,
         * GET_SECTIONS_1, GET_SECTIONS_2, GET_SOLVED_REQUESTS,
         * GET_SUSPENDED_TICKETS, GET_TARGET, GET_TARGETS, GET_TICKET,
         * GET_TICKET_AUDIT, GET_TICKET_AUDIT_1, GET_TICKET_AUDIT_2,
         * GET_TICKET_AUDITS, GET_TICKET_AUDITS_1, GET_TICKET_COLLABORATORS,
         * GET_TICKET_COMMENTS, GET_TICKET_COMMENTS_1, GET_TICKET_FIELD,
         * GET_TICKET_FIELDS, GET_TICKET_FORM, GET_TICKET_FORMS,
         * GET_TICKET_INCIDENTS, GET_TICKET_METRIC, GET_TICKET_METRIC_BY_TICKET,
         * GET_TICKET_METRICS, GET_TICKETS, GET_TICKETS_1,
         * GET_TICKETS_BY_EXTERNAL_ID, GET_TICKETS_BY_EXTERNAL_ID_1,
         * GET_TICKETS_COUNT, GET_TICKETS_COUNT_FOR_ORGANIZATION,
         * GET_TICKETS_FROM_SEARCH, GET_TICKETS_INCREMENTALLY,
         * GET_TICKETS_INCREMENTALLY_1, GET_TOPIC, GET_TOPICS, GET_TOPICS_1,
         * GET_TOPICS_2, GET_TOPICS_3, GET_TOPICS_BY_USER, GET_TRIGGER,
         * GET_TRIGGERS, GET_TRIGGERS_1, GET_TWITTER_MONITORS, GET_USER,
         * GET_USER_CCD_TICKETS, GET_USER_FIELDS, GET_USER_IDENTITIES,
         * GET_USER_IDENTITIES_1, GET_USER_IDENTITY, GET_USER_IDENTITY_1,
         * GET_USER_IDENTITY_2, GET_USER_RELATED_INFO,
         * GET_USER_REQUESTED_TICKETS, GET_USER_REQUESTS, GET_USER_REQUESTS_1,
         * GET_USER_SEGMENT, GET_USER_SEGMENTS, GET_USER_SEGMENTS_1,
         * GET_USER_SEGMENTS_APPLICABLE, GET_USER_SUBSCRIPTIONS,
         * GET_USER_SUBSCRIPTIONS_1, GET_USERS, GET_USERS_1,
         * GET_USERS_BY_EXTERNAL_IDS, GET_USERS_BY_ROLE,
         * GET_USERS_INCREMENTALLY, GET_VIEW, GET_VIEWS, IMPORT_TICKET,
         * IMPORT_TOPIC, LOOKUP_ORGANIZATIONS_BY_EXTERNAL_ID,
         * LOOKUP_USER_BY_EMAIL, LOOKUP_USER_BY_EXTERNAL_ID,
         * MACROS_SHOW_CHANGES_TO_TICKET, MACROS_SHOW_TICKET_AFTER_CHANGES,
         * MAKE_PRIVATE_TICKET_AUDIT, MAKE_PRIVATE_TICKET_AUDIT_1,
         * MAKE_PRIVATE_TICKET_AUDIT_2, MARK_TICKET_AS_SPAM,
         * MARK_TICKET_AS_SPAM_1, MERGE_USERS, NOTIFY_APP,
         * PERMANENTLY_DELETE_TICKET, PERMANENTLY_DELETE_TICKET_1,
         * PERMANENTLY_DELETE_TICKETS, PERMANENTLY_DELETE_USER,
         * PERMANENTLY_DELETE_USER_1, QUEUE_CREATE_TICKET_ASYNC,
         * REMOVE_TAG_FROM_ORGANISATIONS, REMOVE_TAG_FROM_TICKET,
         * REMOVE_TAG_FROM_TOPICS, REQUEST_VERIFY_USER_IDENTITY,
         * REQUEST_VERIFY_USER_IDENTITY_1, REQUEST_VERIFY_USER_IDENTITY_2,
         * RESET_USER_PASSWORD, RESET_USER_PASSWORD_1, SEARCH_TRIGGERS,
         * SEARCH_TRIGGERS_1, SET_GROUP_MEMBERSHIP_AS_DEFAULT,
         * SET_ORGANIZATION_MEMBERSHIP_AS_DEFAULT, SET_TAG_ON_ORGANISATIONS,
         * SET_TAG_ON_TICKET, SET_TAG_ON_TOPICS, SET_USER_PRIMARY_IDENTITY,
         * SET_USER_PRIMARY_IDENTITY_1, SET_USER_PRIMARY_IDENTITY_2,
         * SUSPEND_USER, TRUST_TICKET_AUDIT, TRUST_TICKET_AUDIT_1,
         * TRUST_TICKET_AUDIT_2, UNSUSPEND_USER, UPDATE_ARTICLE,
         * UPDATE_ARTICLE_TRANSLATION, UPDATE_AUTOMATION, UPDATE_CATEGORY,
         * UPDATE_CATEGORY_TRANSLATION, UPDATE_DYNAMIC_CONTENT_ITEM,
         * UPDATE_DYNAMIC_CONTENT_ITEM_VARIANT, UPDATE_FORUM, UPDATE_GROUP,
         * UPDATE_INSTALLATION, UPDATE_MACRO, UPDATE_ORGANIZATION,
         * UPDATE_ORGANIZATIONS, UPDATE_ORGANIZATIONS_1,
         * UPDATE_ORGANIZATIONS_ASYNC, UPDATE_PERMISSION_GROUP, UPDATE_REQUEST,
         * UPDATE_SECTION, UPDATE_SECTION_TRANSLATION, UPDATE_TICKET,
         * UPDATE_TICKET_FIELD, UPDATE_TICKET_FORM, UPDATE_TICKETS,
         * UPDATE_TICKETS_1, UPDATE_TICKETS_ASYNC, UPDATE_TOPIC, UPDATE_TRIGGER,
         * UPDATE_USER, UPDATE_USER_IDENTITY, UPDATE_USER_IDENTITY_1,
         * UPDATE_USER_SEGMENT, UPDATE_USERS, UPDATE_USERS_1,
         * UPDATE_USERS_ASYNC, VERIFY_USER_IDENTITY, VERIFY_USER_IDENTITY_1,
         * VERIFY_USER_IDENTITY_2
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path methodName
         * @return the dsl builder
         */
        default ZendeskEndpointBuilder zendesk(String componentName, String path) {
            return ZendeskEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    static ZendeskEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class ZendeskEndpointBuilderImpl extends AbstractEndpointBuilder implements ZendeskEndpointBuilder, AdvancedZendeskEndpointBuilder {
            public ZendeskEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new ZendeskEndpointBuilderImpl(path);
    }
}