/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Sending metrics to AWS CloudWatch using AWS SDK version 2.x.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface Cw2EndpointBuilderFactory {


    /**
     * Builder for endpoint for the AWS CloudWatch component.
     */
    public interface Cw2EndpointBuilder extends EndpointProducerBuilder {
        default AdvancedCw2EndpointBuilder advanced() {
            return (AdvancedCw2EndpointBuilder) this;
        }
        /**
         * To use the AmazonCloudWatch as the client.
         * 
         * The option is a:
         * &lt;code&gt;software.amazon.awssdk.services.cloudwatch.CloudWatchClient&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param amazonCwClient the value to set
         * @return the dsl builder
         */
        default Cw2EndpointBuilder amazonCwClient(
                software.amazon.awssdk.services.cloudwatch.CloudWatchClient amazonCwClient) {
            doSetProperty("amazonCwClient", amazonCwClient);
            return this;
        }
        /**
         * To use the AmazonCloudWatch as the client.
         * 
         * The option will be converted to a
         * &lt;code&gt;software.amazon.awssdk.services.cloudwatch.CloudWatchClient&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param amazonCwClient the value to set
         * @return the dsl builder
         */
        default Cw2EndpointBuilder amazonCwClient(String amazonCwClient) {
            doSetProperty("amazonCwClient", amazonCwClient);
            return this;
        }
        /**
         * The metric name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param name the value to set
         * @return the dsl builder
         */
        default Cw2EndpointBuilder name(String name) {
            doSetProperty("name", name);
            return this;
        }
        /**
         * Set the need for overidding the endpoint. This option needs to be
         * used in combination with uriEndpointOverride option.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param overrideEndpoint the value to set
         * @return the dsl builder
         */
        default Cw2EndpointBuilder overrideEndpoint(boolean overrideEndpoint) {
            doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }
        /**
         * Set the need for overidding the endpoint. This option needs to be
         * used in combination with uriEndpointOverride option.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param overrideEndpoint the value to set
         * @return the dsl builder
         */
        default Cw2EndpointBuilder overrideEndpoint(String overrideEndpoint) {
            doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }
        /**
         * If using a profile credentials provider this parameter will set the
         * profile name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param profileCredentialsName the value to set
         * @return the dsl builder
         */
        default Cw2EndpointBuilder profileCredentialsName(
                String profileCredentialsName) {
            doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }
        /**
         * To define a proxy host when instantiating the CW client.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param proxyHost the value to set
         * @return the dsl builder
         */
        default Cw2EndpointBuilder proxyHost(String proxyHost) {
            doSetProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * To define a proxy port when instantiating the CW client.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default Cw2EndpointBuilder proxyPort(Integer proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * To define a proxy port when instantiating the CW client.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default Cw2EndpointBuilder proxyPort(String proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the CW client.
         * 
         * The option is a:
         * &lt;code&gt;software.amazon.awssdk.core.Protocol&lt;/code&gt; type.
         * 
         * Default: HTTPS
         * Group: producer
         * 
         * @param proxyProtocol the value to set
         * @return the dsl builder
         */
        default Cw2EndpointBuilder proxyProtocol(
                software.amazon.awssdk.core.Protocol proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the CW client.
         * 
         * The option will be converted to a
         * &lt;code&gt;software.amazon.awssdk.core.Protocol&lt;/code&gt; type.
         * 
         * Default: HTTPS
         * Group: producer
         * 
         * @param proxyProtocol the value to set
         * @return the dsl builder
         */
        default Cw2EndpointBuilder proxyProtocol(String proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
        /**
         * The region in which CW client needs to work. When using this
         * parameter, the configuration will expect the lowercase name of the
         * region (for example ap-east-1) You'll need to use the name
         * Region.EU_WEST_1.id().
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param region the value to set
         * @return the dsl builder
         */
        default Cw2EndpointBuilder region(String region) {
            doSetProperty("region", region);
            return this;
        }
        /**
         * The metric timestamp.
         * 
         * The option is a: &lt;code&gt;java.time.Instant&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param timestamp the value to set
         * @return the dsl builder
         */
        default Cw2EndpointBuilder timestamp(java.time.Instant timestamp) {
            doSetProperty("timestamp", timestamp);
            return this;
        }
        /**
         * The metric timestamp.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.time.Instant&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param timestamp the value to set
         * @return the dsl builder
         */
        default Cw2EndpointBuilder timestamp(String timestamp) {
            doSetProperty("timestamp", timestamp);
            return this;
        }
        /**
         * If we want to trust all certificates in case of overriding the
         * endpoint.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param trustAllCertificates the value to set
         * @return the dsl builder
         */
        default Cw2EndpointBuilder trustAllCertificates(
                boolean trustAllCertificates) {
            doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }
        /**
         * If we want to trust all certificates in case of overriding the
         * endpoint.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param trustAllCertificates the value to set
         * @return the dsl builder
         */
        default Cw2EndpointBuilder trustAllCertificates(
                String trustAllCertificates) {
            doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }
        /**
         * The metric unit.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param unit the value to set
         * @return the dsl builder
         */
        default Cw2EndpointBuilder unit(String unit) {
            doSetProperty("unit", unit);
            return this;
        }
        /**
         * Set the overriding uri endpoint. This option needs to be used in
         * combination with overrideEndpoint option.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param uriEndpointOverride the value to set
         * @return the dsl builder
         */
        default Cw2EndpointBuilder uriEndpointOverride(
                String uriEndpointOverride) {
            doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }
        /**
         * Set whether the S3 client should expect to load credentials through a
         * default credentials provider or to expect static credentials to be
         * passed in.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param useDefaultCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Cw2EndpointBuilder useDefaultCredentialsProvider(
                boolean useDefaultCredentialsProvider) {
            doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }
        /**
         * Set whether the S3 client should expect to load credentials through a
         * default credentials provider or to expect static credentials to be
         * passed in.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param useDefaultCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Cw2EndpointBuilder useDefaultCredentialsProvider(
                String useDefaultCredentialsProvider) {
            doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }
        /**
         * Set whether the Cloudwatch client should expect to load credentials
         * through a profile credentials provider.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param useProfileCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Cw2EndpointBuilder useProfileCredentialsProvider(
                boolean useProfileCredentialsProvider) {
            doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }
        /**
         * Set whether the Cloudwatch client should expect to load credentials
         * through a profile credentials provider.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param useProfileCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Cw2EndpointBuilder useProfileCredentialsProvider(
                String useProfileCredentialsProvider) {
            doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }
        /**
         * The metric value.
         * 
         * The option is a: &lt;code&gt;java.lang.Double&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param value the value to set
         * @return the dsl builder
         */
        default Cw2EndpointBuilder value(Double value) {
            doSetProperty("value", value);
            return this;
        }
        /**
         * The metric value.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Double&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param value the value to set
         * @return the dsl builder
         */
        default Cw2EndpointBuilder value(String value) {
            doSetProperty("value", value);
            return this;
        }
        /**
         * Amazon AWS Access Key.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param accessKey the value to set
         * @return the dsl builder
         */
        default Cw2EndpointBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * Amazon AWS Secret Key.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param secretKey the value to set
         * @return the dsl builder
         */
        default Cw2EndpointBuilder secretKey(String secretKey) {
            doSetProperty("secretKey", secretKey);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the AWS CloudWatch component.
     */
    public interface AdvancedCw2EndpointBuilder
            extends
                EndpointProducerBuilder {
        default Cw2EndpointBuilder basic() {
            return (Cw2EndpointBuilder) this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedCw2EndpointBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedCw2EndpointBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    public interface Cw2Builders {
        /**
         * AWS CloudWatch (camel-aws2-cw)
         * Sending metrics to AWS CloudWatch using AWS SDK version 2.x.
         * 
         * Category: cloud,monitoring
         * Since: 3.1
         * Maven coordinates: org.apache.camel:camel-aws2-cw
         * 
         * @return the dsl builder for the headers' name.
         */
        default Cw2HeaderNameBuilder aws2Cw() {
            return Cw2HeaderNameBuilder.INSTANCE;
        }
        /**
         * AWS CloudWatch (camel-aws2-cw)
         * Sending metrics to AWS CloudWatch using AWS SDK version 2.x.
         * 
         * Category: cloud,monitoring
         * Since: 3.1
         * Maven coordinates: org.apache.camel:camel-aws2-cw
         * 
         * Syntax: <code>aws2-cw:namespace</code>
         * 
         * Path parameter: namespace (required)
         * The metric namespace
         * 
         * @param path namespace
         * @return the dsl builder
         */
        default Cw2EndpointBuilder aws2Cw(String path) {
            return Cw2EndpointBuilderFactory.endpointBuilder("aws2-cw", path);
        }
        /**
         * AWS CloudWatch (camel-aws2-cw)
         * Sending metrics to AWS CloudWatch using AWS SDK version 2.x.
         * 
         * Category: cloud,monitoring
         * Since: 3.1
         * Maven coordinates: org.apache.camel:camel-aws2-cw
         * 
         * Syntax: <code>aws2-cw:namespace</code>
         * 
         * Path parameter: namespace (required)
         * The metric namespace
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path namespace
         * @return the dsl builder
         */
        default Cw2EndpointBuilder aws2Cw(String componentName, String path) {
            return Cw2EndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    /**
     * The builder of headers' name for the AWS CloudWatch component.
     */
    public static class Cw2HeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final Cw2HeaderNameBuilder INSTANCE = new Cw2HeaderNameBuilder();

        /**
         * The Amazon CW metric namespace.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsCwMetricNamespace}.
         */
        public String awsCwMetricNamespace() {
            return "AwsCwMetricNamespace";
        }

        /**
         * The Amazon CW metric name.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsCwMetricName}.
         */
        public String awsCwMetricName() {
            return "AwsCwMetricName";
        }

        /**
         * The Amazon CW metric value.
         * 
         * The option is a: {@code Double} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsCwMetricValue}.
         */
        public String awsCwMetricValue() {
            return "AwsCwMetricValue";
        }

        /**
         * The Amazon CW metric unit.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsCwMetricUnit}.
         */
        public String awsCwMetricUnit() {
            return "AwsCwMetricUnit";
        }

        /**
         * The Amazon CW metric timestamp.
         * 
         * The option is a: {@code Date} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsCwMetricTimestamp}.
         */
        public String awsCwMetricTimestamp() {
            return "AwsCwMetricTimestamp";
        }

        /**
         * A map of dimension names and dimension values.
         * 
         * The option is a: {@code Map<String, String>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsCwMetricDimensions}.
         */
        public String awsCwMetricDimensions() {
            return "AwsCwMetricDimensions";
        }

        /**
         * The Amazon CW metric dimension name.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsCwMetricDimensionName}.
         */
        public String awsCwMetricDimensionName() {
            return "AwsCwMetricDimensionName";
        }

        /**
         * The Amazon CW metric dimension value.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsCwMetricDimensionValue}.
         */
        public String awsCwMetricDimensionValue() {
            return "AwsCwMetricDimensionValue";
        }
    }
    static Cw2EndpointBuilder endpointBuilder(String componentName, String path) {
        class Cw2EndpointBuilderImpl extends AbstractEndpointBuilder implements Cw2EndpointBuilder, AdvancedCw2EndpointBuilder {
            public Cw2EndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new Cw2EndpointBuilderImpl(path);
    }
}