/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * JSON to JSON transformation using JOLT.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface JoltEndpointBuilderFactory {


    /**
     * Builder for endpoint for the JOLT component.
     */
    public interface JoltEndpointBuilder extends EndpointProducerBuilder {
        default AdvancedJoltEndpointBuilder advanced() {
            return (AdvancedJoltEndpointBuilder) this;
        }
        /**
         * Sets whether the context map should allow access to all details. By
         * default only the message body and headers can be accessed. This
         * option can be enabled for full access to the current Exchange and
         * CamelContext. Doing so impose a potential security risk as this opens
         * access to the full power of CamelContext API.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param allowContextMapAll the value to set
         * @return the dsl builder
         */
        default JoltEndpointBuilder allowContextMapAll(
                boolean allowContextMapAll) {
            doSetProperty("allowContextMapAll", allowContextMapAll);
            return this;
        }
        /**
         * Sets whether the context map should allow access to all details. By
         * default only the message body and headers can be accessed. This
         * option can be enabled for full access to the current Exchange and
         * CamelContext. Doing so impose a potential security risk as this opens
         * access to the full power of CamelContext API.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param allowContextMapAll the value to set
         * @return the dsl builder
         */
        default JoltEndpointBuilder allowContextMapAll(String allowContextMapAll) {
            doSetProperty("allowContextMapAll", allowContextMapAll);
            return this;
        }
        /**
         * Whether to allow to use resource template from header or not (default
         * false). Enabling this allows to specify dynamic templates via message
         * header. However this can be seen as a potential security
         * vulnerability if the header is coming from a malicious user, so use
         * this with care.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param allowTemplateFromHeader the value to set
         * @return the dsl builder
         */
        default JoltEndpointBuilder allowTemplateFromHeader(
                boolean allowTemplateFromHeader) {
            doSetProperty("allowTemplateFromHeader", allowTemplateFromHeader);
            return this;
        }
        /**
         * Whether to allow to use resource template from header or not (default
         * false). Enabling this allows to specify dynamic templates via message
         * header. However this can be seen as a potential security
         * vulnerability if the header is coming from a malicious user, so use
         * this with care.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param allowTemplateFromHeader the value to set
         * @return the dsl builder
         */
        default JoltEndpointBuilder allowTemplateFromHeader(
                String allowTemplateFromHeader) {
            doSetProperty("allowTemplateFromHeader", allowTemplateFromHeader);
            return this;
        }
        /**
         * Sets whether to use resource content cache or not.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param contentCache the value to set
         * @return the dsl builder
         */
        default JoltEndpointBuilder contentCache(boolean contentCache) {
            doSetProperty("contentCache", contentCache);
            return this;
        }
        /**
         * Sets whether to use resource content cache or not.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param contentCache the value to set
         * @return the dsl builder
         */
        default JoltEndpointBuilder contentCache(String contentCache) {
            doSetProperty("contentCache", contentCache);
            return this;
        }
        /**
         * Specifies if the input is hydrated JSON or a JSON String.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.jolt.JoltInputOutputType&lt;/code&gt; type.
         * 
         * Default: Hydrated
         * Group: producer
         * 
         * @param inputType the value to set
         * @return the dsl builder
         */
        default JoltEndpointBuilder inputType(
                org.apache.camel.component.jolt.JoltInputOutputType inputType) {
            doSetProperty("inputType", inputType);
            return this;
        }
        /**
         * Specifies if the input is hydrated JSON or a JSON String.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.jolt.JoltInputOutputType&lt;/code&gt; type.
         * 
         * Default: Hydrated
         * Group: producer
         * 
         * @param inputType the value to set
         * @return the dsl builder
         */
        default JoltEndpointBuilder inputType(String inputType) {
            doSetProperty("inputType", inputType);
            return this;
        }
        /**
         * Specifies if the output should be hydrated JSON or a JSON String.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.jolt.JoltInputOutputType&lt;/code&gt; type.
         * 
         * Default: Hydrated
         * Group: producer
         * 
         * @param outputType the value to set
         * @return the dsl builder
         */
        default JoltEndpointBuilder outputType(
                org.apache.camel.component.jolt.JoltInputOutputType outputType) {
            doSetProperty("outputType", outputType);
            return this;
        }
        /**
         * Specifies if the output should be hydrated JSON or a JSON String.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.jolt.JoltInputOutputType&lt;/code&gt; type.
         * 
         * Default: Hydrated
         * Group: producer
         * 
         * @param outputType the value to set
         * @return the dsl builder
         */
        default JoltEndpointBuilder outputType(String outputType) {
            doSetProperty("outputType", outputType);
            return this;
        }
        /**
         * Specifies the Transform DSL of the endpoint resource. If none is
         * specified Chainr will be used.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.jolt.JoltTransformType&lt;/code&gt; type.
         * 
         * Default: Chainr
         * Group: producer
         * 
         * @param transformDsl the value to set
         * @return the dsl builder
         */
        default JoltEndpointBuilder transformDsl(
                org.apache.camel.component.jolt.JoltTransformType transformDsl) {
            doSetProperty("transformDsl", transformDsl);
            return this;
        }
        /**
         * Specifies the Transform DSL of the endpoint resource. If none is
         * specified Chainr will be used.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.jolt.JoltTransformType&lt;/code&gt; type.
         * 
         * Default: Chainr
         * Group: producer
         * 
         * @param transformDsl the value to set
         * @return the dsl builder
         */
        default JoltEndpointBuilder transformDsl(String transformDsl) {
            doSetProperty("transformDsl", transformDsl);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the JOLT component.
     */
    public interface AdvancedJoltEndpointBuilder
            extends
                EndpointProducerBuilder {
        default JoltEndpointBuilder basic() {
            return (JoltEndpointBuilder) this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedJoltEndpointBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedJoltEndpointBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    public interface JoltBuilders {
        /**
         * JOLT (camel-jolt)
         * JSON to JSON transformation using JOLT.
         * 
         * Category: transformation
         * Since: 2.16
         * Maven coordinates: org.apache.camel:camel-jolt
         * 
         * @return the dsl builder for the headers' name.
         */
        default JoltHeaderNameBuilder jolt() {
            return JoltHeaderNameBuilder.INSTANCE;
        }
        /**
         * JOLT (camel-jolt)
         * JSON to JSON transformation using JOLT.
         * 
         * Category: transformation
         * Since: 2.16
         * Maven coordinates: org.apache.camel:camel-jolt
         * 
         * Syntax: <code>jolt:resourceUri</code>
         * 
         * Path parameter: resourceUri (required)
         * Path to the resource. You can prefix with: classpath, file, http,
         * ref, or bean. classpath, file and http loads the resource using these
         * protocols (classpath is default). ref will lookup the resource in the
         * registry. bean will call a method on a bean to be used as the
         * resource. For bean you can specify the method name after dot, eg
         * bean:myBean.myMethod.
         * This option can also be loaded from an existing file, by prefixing
         * with file: or classpath: followed by the location of the file.
         * 
         * @param path resourceUri
         * @return the dsl builder
         */
        default JoltEndpointBuilder jolt(String path) {
            return JoltEndpointBuilderFactory.endpointBuilder("jolt", path);
        }
        /**
         * JOLT (camel-jolt)
         * JSON to JSON transformation using JOLT.
         * 
         * Category: transformation
         * Since: 2.16
         * Maven coordinates: org.apache.camel:camel-jolt
         * 
         * Syntax: <code>jolt:resourceUri</code>
         * 
         * Path parameter: resourceUri (required)
         * Path to the resource. You can prefix with: classpath, file, http,
         * ref, or bean. classpath, file and http loads the resource using these
         * protocols (classpath is default). ref will lookup the resource in the
         * registry. bean will call a method on a bean to be used as the
         * resource. For bean you can specify the method name after dot, eg
         * bean:myBean.myMethod.
         * This option can also be loaded from an existing file, by prefixing
         * with file: or classpath: followed by the location of the file.
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path resourceUri
         * @return the dsl builder
         */
        default JoltEndpointBuilder jolt(String componentName, String path) {
            return JoltEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    /**
     * The builder of headers' name for the JOLT component.
     */
    public static class JoltHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final JoltHeaderNameBuilder INSTANCE = new JoltHeaderNameBuilder();

        /**
         * The resource URI.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code JoltResourceUri}.
         */
        public String joltResourceUri() {
            return "JoltResourceUri";
        }

        /**
         * The context.
         * 
         * The option is a: {@code Map<String, Object>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code JoltContext}.
         */
        public String joltContext() {
            return "JoltContext";
        }
    }
    static JoltEndpointBuilder endpointBuilder(String componentName, String path) {
        class JoltEndpointBuilderImpl extends AbstractEndpointBuilder implements JoltEndpointBuilder, AdvancedJoltEndpointBuilder {
            public JoltEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new JoltEndpointBuilderImpl(path);
    }
}