/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.endpoint.dsl;

import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.component.aws2.lambda.Lambda2Operations;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.lambda.LambdaClient;

public interface Lambda2EndpointBuilderFactory {
    public static Lambda2EndpointBuilder endpointBuilder(String componentName, String path) {
        class Lambda2EndpointBuilderImpl
        extends AbstractEndpointBuilder
        implements Lambda2EndpointBuilder,
        AdvancedLambda2EndpointBuilder {
            final /* synthetic */ String val$componentName;

            public Lambda2EndpointBuilderImpl(String path, String string) {
                this.val$componentName = string;
                super(string, path);
            }
        }
        return new Lambda2EndpointBuilderImpl(path, componentName);
    }

    public static class Lambda2HeaderNameBuilder {
        private static final Lambda2HeaderNameBuilder INSTANCE = new Lambda2HeaderNameBuilder();

        public String awsLambdaOperation() {
            return "AwsLambdaOperation";
        }

        public String awsLambdaS3Bucket() {
            return "AwsLambdaS3Bucket";
        }

        public String awsLambdaS3Key() {
            return "AwsLambdaS3Key";
        }

        public String awsLambdaS3ObjectVersion() {
            return "AwsLambdaS3ObjectVersion";
        }

        public String awsLambdaZipFile() {
            return "AwsLambdaZipFile";
        }

        public String awsLambdaDescription() {
            return "AwsLambdaDescription";
        }

        public String awsLambdaRole() {
            return "AwsLambdaRole";
        }

        public String awsLambdaRuntime() {
            return "AwsLambdaRuntime";
        }

        public String awsLambdaHandler() {
            return "AwsLambdaHandler";
        }

        public String awsLambdaTargetArn() {
            return "AwsLambdaTargetArn";
        }

        public String awsLambdaMemorySize() {
            return "AwsLambdaMemorySize";
        }

        public String awsLambdaKMSKeyArn() {
            return "AwsLambdaKMSKeyArn";
        }

        public String awsLambdaEnvironmentVariables() {
            return "AwsLambdaEnvironmentVariables";
        }

        public String awsLambdaPublish() {
            return "AwsLambdaPublish";
        }

        public String awsLambdaTimeout() {
            return "AwsLambdaTimeout";
        }

        public String awsLambdaTags() {
            return "AwsLambdaTags";
        }

        public String awsLambdaTracingConfig() {
            return "AwsLambdaTracingConfig";
        }

        public String awsLambdaSecurityGroupIds() {
            return "AwsLambdaSecurityGroupIds";
        }

        public String awsLambdaSubnetIds() {
            return "AwsLambdaSubnetIds";
        }

        public String awsLambdaEventSourceArn() {
            return "AwsLambdaEventSourceArn";
        }

        public String awsLambdaEventSourceBatchSize() {
            return "AwsLambdaEventSourceBatchSize";
        }

        public String awsLambdaEventSourceUuid() {
            return "AwsLambdaEventSourceUuid";
        }

        public String awsLambdaResourceArn() {
            return "AwsLambdaResourceArn";
        }

        public String awsLambdaResourceTags() {
            return "AwsLambdaResourceTags";
        }

        public String awsLambdaResourceTagKeys() {
            return "AwsLambdaResourceTagKeys";
        }

        public String awsLambdaVersionDescription() {
            return "AwsLambdaVersionDescription";
        }

        public String awsLambdaVersionRevisionId() {
            return "AwsLambdaVersionRevisionId";
        }

        public String awsLambdaFunctionVersion() {
            return "AwsLambdaFunctionVersion";
        }

        public String awsLambdaAliasFunctionName() {
            return "AwsLambdaAliasFunctionName";
        }

        public String awsLambdaAliasFunctionDescription() {
            return "AwsLambdaAliasFunctionDescription";
        }
    }

    public static interface Lambda2Builders {
        default public Lambda2HeaderNameBuilder aws2Lambda() {
            return Lambda2HeaderNameBuilder.INSTANCE;
        }

        default public Lambda2EndpointBuilder aws2Lambda(String path) {
            return Lambda2EndpointBuilderFactory.endpointBuilder("aws2-lambda", path);
        }

        default public Lambda2EndpointBuilder aws2Lambda(String componentName, String path) {
            return Lambda2EndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    public static interface AdvancedLambda2EndpointBuilder
    extends EndpointProducerBuilder {
        default public Lambda2EndpointBuilder basic() {
            return (Lambda2EndpointBuilder)((Object)this);
        }

        default public AdvancedLambda2EndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AdvancedLambda2EndpointBuilder lazyStartProducer(String lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AdvancedLambda2EndpointBuilder awsLambdaClient(LambdaClient awsLambdaClient) {
            this.doSetProperty("awsLambdaClient", awsLambdaClient);
            return this;
        }

        default public AdvancedLambda2EndpointBuilder awsLambdaClient(String awsLambdaClient) {
            this.doSetProperty("awsLambdaClient", awsLambdaClient);
            return this;
        }
    }

    public static interface Lambda2EndpointBuilder
    extends EndpointProducerBuilder {
        default public AdvancedLambda2EndpointBuilder advanced() {
            return (AdvancedLambda2EndpointBuilder)((Object)this);
        }

        default public Lambda2EndpointBuilder operation(Lambda2Operations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public Lambda2EndpointBuilder operation(String operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public Lambda2EndpointBuilder overrideEndpoint(boolean overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        default public Lambda2EndpointBuilder overrideEndpoint(String overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        default public Lambda2EndpointBuilder pojoRequest(boolean pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public Lambda2EndpointBuilder pojoRequest(String pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public Lambda2EndpointBuilder profileCredentialsName(String profileCredentialsName) {
            this.doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }

        default public Lambda2EndpointBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public Lambda2EndpointBuilder trustAllCertificates(boolean trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public Lambda2EndpointBuilder trustAllCertificates(String trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public Lambda2EndpointBuilder uriEndpointOverride(String uriEndpointOverride) {
            this.doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }

        default public Lambda2EndpointBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public Lambda2EndpointBuilder useDefaultCredentialsProvider(String useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public Lambda2EndpointBuilder useProfileCredentialsProvider(boolean useProfileCredentialsProvider) {
            this.doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }

        default public Lambda2EndpointBuilder useProfileCredentialsProvider(String useProfileCredentialsProvider) {
            this.doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }

        default public Lambda2EndpointBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public Lambda2EndpointBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public Lambda2EndpointBuilder proxyPort(String proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public Lambda2EndpointBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public Lambda2EndpointBuilder proxyProtocol(String proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public Lambda2EndpointBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public Lambda2EndpointBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }
    }
}

