/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.Map;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Send and receive messages to/from AWS SQS.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface Sqs2EndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the AWS Simple Queue Service (SQS)
     * component.
     */
    public interface Sqs2EndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedSqs2EndpointConsumerBuilder advanced() {
            return (AdvancedSqs2EndpointConsumerBuilder) this;
        }
        /**
         * The hostname of the Amazon AWS cloud.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: amazonaws.com
         * Group: common
         * 
         * @param amazonAWSHost the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder amazonAWSHost(String amazonAWSHost) {
            doSetProperty("amazonAWSHost", amazonAWSHost);
            return this;
        }
        /**
         * Setting the autocreation of the queue.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param autoCreateQueue the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder autoCreateQueue(
                boolean autoCreateQueue) {
            doSetProperty("autoCreateQueue", autoCreateQueue);
            return this;
        }
        /**
         * Setting the autocreation of the queue.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param autoCreateQueue the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder autoCreateQueue(
                String autoCreateQueue) {
            doSetProperty("autoCreateQueue", autoCreateQueue);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to map headers to/from Camel.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder headerFilterStrategy(
                org.apache.camel.spi.HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to map headers to/from Camel.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder headerFilterStrategy(
                String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * Set the need for overriding the endpoint. This option needs to be
         * used in combination with uriEndpointOverride option.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param overrideEndpoint the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder overrideEndpoint(
                boolean overrideEndpoint) {
            doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }
        /**
         * Set the need for overriding the endpoint. This option needs to be
         * used in combination with uriEndpointOverride option.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param overrideEndpoint the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder overrideEndpoint(
                String overrideEndpoint) {
            doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }
        /**
         * The underlying protocol used to communicate with SQS.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: https
         * Group: common
         * 
         * @param protocol the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder protocol(String protocol) {
            doSetProperty("protocol", protocol);
            return this;
        }
        /**
         * Specify the queue owner aws account id when you need to connect the
         * queue with different account owner.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param queueOwnerAWSAccountId the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder queueOwnerAWSAccountId(
                String queueOwnerAWSAccountId) {
            doSetProperty("queueOwnerAWSAccountId", queueOwnerAWSAccountId);
            return this;
        }
        /**
         * The region in which SQS client needs to work. When using this
         * parameter, the configuration will expect the lowercase name of the
         * region (for example ap-east-1) You'll need to use the name
         * Region.EU_WEST_1.id().
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param region the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder region(String region) {
            doSetProperty("region", region);
            return this;
        }
        /**
         * Set the overriding uri endpoint. This option needs to be used in
         * combination with overrideEndpoint option.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param uriEndpointOverride the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder uriEndpointOverride(
                String uriEndpointOverride) {
            doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }
        /**
         * A list of attribute names to receive when consuming. Multiple names
         * can be separated by comma.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param attributeNames the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder attributeNames(String attributeNames) {
            doSetProperty("attributeNames", attributeNames);
            return this;
        }
        /**
         * Allows you to use multiple threads to poll the sqs queue to increase
         * throughput.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: consumer
         * 
         * @param concurrentConsumers the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder concurrentConsumers(
                int concurrentConsumers) {
            doSetProperty("concurrentConsumers", concurrentConsumers);
            return this;
        }
        /**
         * Allows you to use multiple threads to poll the sqs queue to increase
         * throughput.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: consumer
         * 
         * @param concurrentConsumers the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder concurrentConsumers(
                String concurrentConsumers) {
            doSetProperty("concurrentConsumers", concurrentConsumers);
            return this;
        }
        /**
         * The default visibility timeout (in seconds).
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param defaultVisibilityTimeout the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder defaultVisibilityTimeout(
                Integer defaultVisibilityTimeout) {
            doSetProperty("defaultVisibilityTimeout", defaultVisibilityTimeout);
            return this;
        }
        /**
         * The default visibility timeout (in seconds).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param defaultVisibilityTimeout the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder defaultVisibilityTimeout(
                String defaultVisibilityTimeout) {
            doSetProperty("defaultVisibilityTimeout", defaultVisibilityTimeout);
            return this;
        }
        /**
         * Delete message from SQS after it has been read.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param deleteAfterRead the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder deleteAfterRead(
                boolean deleteAfterRead) {
            doSetProperty("deleteAfterRead", deleteAfterRead);
            return this;
        }
        /**
         * Delete message from SQS after it has been read.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param deleteAfterRead the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder deleteAfterRead(
                String deleteAfterRead) {
            doSetProperty("deleteAfterRead", deleteAfterRead);
            return this;
        }
        /**
         * Whether or not to send the DeleteMessage to the SQS queue if the
         * exchange has property with key Sqs2Constants#SQS_DELETE_FILTERED
         * (CamelAwsSqsDeleteFiltered) set to true.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param deleteIfFiltered the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder deleteIfFiltered(
                boolean deleteIfFiltered) {
            doSetProperty("deleteIfFiltered", deleteIfFiltered);
            return this;
        }
        /**
         * Whether or not to send the DeleteMessage to the SQS queue if the
         * exchange has property with key Sqs2Constants#SQS_DELETE_FILTERED
         * (CamelAwsSqsDeleteFiltered) set to true.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param deleteIfFiltered the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder deleteIfFiltered(
                String deleteIfFiltered) {
            doSetProperty("deleteIfFiltered", deleteIfFiltered);
            return this;
        }
        /**
         * If enabled then a scheduled background task will keep extending the
         * message visibility on SQS. This is needed if it takes a long time to
         * process the message. If set to true defaultVisibilityTimeout must be
         * set. See details at Amazon docs.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param extendMessageVisibility the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder extendMessageVisibility(
                boolean extendMessageVisibility) {
            doSetProperty("extendMessageVisibility", extendMessageVisibility);
            return this;
        }
        /**
         * If enabled then a scheduled background task will keep extending the
         * message visibility on SQS. This is needed if it takes a long time to
         * process the message. If set to true defaultVisibilityTimeout must be
         * set. See details at Amazon docs.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param extendMessageVisibility the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder extendMessageVisibility(
                String extendMessageVisibility) {
            doSetProperty("extendMessageVisibility", extendMessageVisibility);
            return this;
        }
        /**
         * The length of time, in seconds, for which Amazon SQS can reuse a data
         * key to encrypt or decrypt messages before calling AWS KMS again. An
         * integer representing seconds, between 60 seconds (1 minute) and
         * 86,400 seconds (24 hours). Default: 300 (5 minutes).
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param kmsDataKeyReusePeriodSeconds the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder kmsDataKeyReusePeriodSeconds(
                Integer kmsDataKeyReusePeriodSeconds) {
            doSetProperty("kmsDataKeyReusePeriodSeconds", kmsDataKeyReusePeriodSeconds);
            return this;
        }
        /**
         * The length of time, in seconds, for which Amazon SQS can reuse a data
         * key to encrypt or decrypt messages before calling AWS KMS again. An
         * integer representing seconds, between 60 seconds (1 minute) and
         * 86,400 seconds (24 hours). Default: 300 (5 minutes).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param kmsDataKeyReusePeriodSeconds the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder kmsDataKeyReusePeriodSeconds(
                String kmsDataKeyReusePeriodSeconds) {
            doSetProperty("kmsDataKeyReusePeriodSeconds", kmsDataKeyReusePeriodSeconds);
            return this;
        }
        /**
         * The ID of an AWS-managed customer master key (CMK) for Amazon SQS or
         * a custom CMK.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param kmsMasterKeyId the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder kmsMasterKeyId(String kmsMasterKeyId) {
            doSetProperty("kmsMasterKeyId", kmsMasterKeyId);
            return this;
        }
        /**
         * Gets the maximum number of messages as a limit to poll at each
         * polling. Is default unlimited, but use 0 or negative number to
         * disable it as unlimited.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param maxMessagesPerPoll the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder maxMessagesPerPoll(
                int maxMessagesPerPoll) {
            doSetProperty("maxMessagesPerPoll", maxMessagesPerPoll);
            return this;
        }
        /**
         * Gets the maximum number of messages as a limit to poll at each
         * polling. Is default unlimited, but use 0 or negative number to
         * disable it as unlimited.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param maxMessagesPerPoll the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder maxMessagesPerPoll(
                String maxMessagesPerPoll) {
            doSetProperty("maxMessagesPerPoll", maxMessagesPerPoll);
            return this;
        }
        /**
         * A list of message attribute names to receive when consuming. Multiple
         * names can be separated by comma.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param messageAttributeNames the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder messageAttributeNames(
                String messageAttributeNames) {
            doSetProperty("messageAttributeNames", messageAttributeNames);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder sendEmptyMessageWhenIdle(
                boolean sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder sendEmptyMessageWhenIdle(
                String sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * Define if Server Side Encryption is enabled or not on the queue.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param serverSideEncryptionEnabled the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder serverSideEncryptionEnabled(
                boolean serverSideEncryptionEnabled) {
            doSetProperty("serverSideEncryptionEnabled", serverSideEncryptionEnabled);
            return this;
        }
        /**
         * Define if Server Side Encryption is enabled or not on the queue.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param serverSideEncryptionEnabled the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder serverSideEncryptionEnabled(
                String serverSideEncryptionEnabled) {
            doSetProperty("serverSideEncryptionEnabled", serverSideEncryptionEnabled);
            return this;
        }
        /**
         * The duration (in seconds) that the received messages are hidden from
         * subsequent retrieve requests after being retrieved by a
         * ReceiveMessage request to set in the
         * com.amazonaws.services.sqs.model.SetQueueAttributesRequest. This only
         * make sense if its different from defaultVisibilityTimeout. It changes
         * the queue visibility timeout attribute permanently.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param visibilityTimeout the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder visibilityTimeout(
                Integer visibilityTimeout) {
            doSetProperty("visibilityTimeout", visibilityTimeout);
            return this;
        }
        /**
         * The duration (in seconds) that the received messages are hidden from
         * subsequent retrieve requests after being retrieved by a
         * ReceiveMessage request to set in the
         * com.amazonaws.services.sqs.model.SetQueueAttributesRequest. This only
         * make sense if its different from defaultVisibilityTimeout. It changes
         * the queue visibility timeout attribute permanently.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param visibilityTimeout the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder visibilityTimeout(
                String visibilityTimeout) {
            doSetProperty("visibilityTimeout", visibilityTimeout);
            return this;
        }
        /**
         * Duration in seconds (0 to 20) that the ReceiveMessage action call
         * will wait until a message is in the queue to include in the response.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param waitTimeSeconds the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder waitTimeSeconds(
                Integer waitTimeSeconds) {
            doSetProperty("waitTimeSeconds", waitTimeSeconds);
            return this;
        }
        /**
         * Duration in seconds (0 to 20) that the ReceiveMessage action call
         * will wait until a message is in the queue to include in the response.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param waitTimeSeconds the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder waitTimeSeconds(
                String waitTimeSeconds) {
            doSetProperty("waitTimeSeconds", waitTimeSeconds);
            return this;
        }
        /**
         * To define a proxy host when instantiating the SQS client.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyHost the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder proxyHost(String proxyHost) {
            doSetProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * To define a proxy port when instantiating the SQS client.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder proxyPort(Integer proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * To define a proxy port when instantiating the SQS client.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder proxyPort(String proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the SQS client.
         * 
         * The option is a:
         * &lt;code&gt;software.amazon.awssdk.core.Protocol&lt;/code&gt; type.
         * 
         * Default: HTTPS
         * Group: proxy
         * 
         * @param proxyProtocol the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder proxyProtocol(
                software.amazon.awssdk.core.Protocol proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the SQS client.
         * 
         * The option will be converted to a
         * &lt;code&gt;software.amazon.awssdk.core.Protocol&lt;/code&gt; type.
         * 
         * Default: HTTPS
         * Group: proxy
         * 
         * @param proxyProtocol the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder proxyProtocol(String proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
        /**
         * The maximumMessageSize (in bytes) an SQS message can contain for this
         * queue.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param maximumMessageSize the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder maximumMessageSize(
                Integer maximumMessageSize) {
            doSetProperty("maximumMessageSize", maximumMessageSize);
            return this;
        }
        /**
         * The maximumMessageSize (in bytes) an SQS message can contain for this
         * queue.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param maximumMessageSize the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder maximumMessageSize(
                String maximumMessageSize) {
            doSetProperty("maximumMessageSize", maximumMessageSize);
            return this;
        }
        /**
         * The messageRetentionPeriod (in seconds) a message will be retained by
         * SQS for this queue.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param messageRetentionPeriod the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder messageRetentionPeriod(
                Integer messageRetentionPeriod) {
            doSetProperty("messageRetentionPeriod", messageRetentionPeriod);
            return this;
        }
        /**
         * The messageRetentionPeriod (in seconds) a message will be retained by
         * SQS for this queue.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param messageRetentionPeriod the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder messageRetentionPeriod(
                String messageRetentionPeriod) {
            doSetProperty("messageRetentionPeriod", messageRetentionPeriod);
            return this;
        }
        /**
         * The policy for this queue. It can be loaded by default from
         * classpath, but you can prefix with classpath:, file:, or http: to
         * load the resource from different systems.
         * 
         * This option can also be loaded from an existing file, by prefixing
         * with file: or classpath: followed by the location of the file.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param policy the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder policy(String policy) {
            doSetProperty("policy", policy);
            return this;
        }
        /**
         * To define the queueUrl explicitly. All other parameters, which would
         * influence the queueUrl, are ignored. This parameter is intended to be
         * used, to connect to a mock implementation of SQS, for testing
         * purposes.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param queueUrl the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder queueUrl(String queueUrl) {
            doSetProperty("queueUrl", queueUrl);
            return this;
        }
        /**
         * If you do not specify WaitTimeSeconds in the request, the queue
         * attribute ReceiveMessageWaitTimeSeconds is used to determine how long
         * to wait.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param receiveMessageWaitTimeSeconds the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder receiveMessageWaitTimeSeconds(
                Integer receiveMessageWaitTimeSeconds) {
            doSetProperty("receiveMessageWaitTimeSeconds", receiveMessageWaitTimeSeconds);
            return this;
        }
        /**
         * If you do not specify WaitTimeSeconds in the request, the queue
         * attribute ReceiveMessageWaitTimeSeconds is used to determine how long
         * to wait.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param receiveMessageWaitTimeSeconds the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder receiveMessageWaitTimeSeconds(
                String receiveMessageWaitTimeSeconds) {
            doSetProperty("receiveMessageWaitTimeSeconds", receiveMessageWaitTimeSeconds);
            return this;
        }
        /**
         * Specify the policy that send message to DeadLetter queue. See detail
         * at Amazon docs.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param redrivePolicy the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder redrivePolicy(String redrivePolicy) {
            doSetProperty("redrivePolicy", redrivePolicy);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder backoffErrorThreshold(
                int backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder backoffErrorThreshold(
                String backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder backoffIdleThreshold(
                int backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder backoffIdleThreshold(
                String backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder backoffMultiplier(
                int backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder backoffMultiplier(
                String backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: scheduler
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder delay(long delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: scheduler
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder delay(String delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder greedy(boolean greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder greedy(String greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder initialDelay(long initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder initialDelay(String initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder repeatCount(long repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder repeatCount(String repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder runLoggingLevel(
                org.apache.camel.LoggingLevel runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder runLoggingLevel(
                String runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option is a:
         * &lt;code&gt;java.util.concurrent.ScheduledExecutorService&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder scheduledExecutorService(
                ScheduledExecutorService scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.concurrent.ScheduledExecutorService&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder scheduledExecutorService(
                String scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option is a: &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder scheduler(Object scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder scheduler(String scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder schedulerProperties(
                String key,
                Object value) {
            doSetMultiValueProperty("schedulerProperties", "scheduler." + key, value);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param values the values
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder schedulerProperties(Map values) {
            doSetMultiValueProperties("schedulerProperties", "scheduler.", values);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder startScheduler(
                boolean startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder startScheduler(String startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option is a:
         * &lt;code&gt;java.util.concurrent.TimeUnit&lt;/code&gt; type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.concurrent.TimeUnit&lt;/code&gt; type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder timeUnit(String timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder useFixedDelay(boolean useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder useFixedDelay(String useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Amazon AWS Access Key.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param accessKey the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * If using a profile credentials provider this parameter will set the
         * profile name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param profileCredentialsName the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder profileCredentialsName(
                String profileCredentialsName) {
            doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }
        /**
         * Amazon AWS Secret Key.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param secretKey the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder secretKey(String secretKey) {
            doSetProperty("secretKey", secretKey);
            return this;
        }
        /**
         * If we want to trust all certificates in case of overriding the
         * endpoint.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param trustAllCertificates the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder trustAllCertificates(
                boolean trustAllCertificates) {
            doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }
        /**
         * If we want to trust all certificates in case of overriding the
         * endpoint.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: security
         * 
         * @param trustAllCertificates the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder trustAllCertificates(
                String trustAllCertificates) {
            doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }
        /**
         * Set whether the SQS client should expect to load credentials on an
         * AWS infra instance or to expect static credentials to be passed in.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useDefaultCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder useDefaultCredentialsProvider(
                boolean useDefaultCredentialsProvider) {
            doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }
        /**
         * Set whether the SQS client should expect to load credentials on an
         * AWS infra instance or to expect static credentials to be passed in.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useDefaultCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder useDefaultCredentialsProvider(
                String useDefaultCredentialsProvider) {
            doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }
        /**
         * Set whether the SQS client should expect to load credentials through
         * a profile credentials provider.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useProfileCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder useProfileCredentialsProvider(
                boolean useProfileCredentialsProvider) {
            doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }
        /**
         * Set whether the SQS client should expect to load credentials through
         * a profile credentials provider.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useProfileCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointConsumerBuilder useProfileCredentialsProvider(
                String useProfileCredentialsProvider) {
            doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the AWS Simple Queue Service
     * (SQS) component.
     */
    public interface AdvancedSqs2EndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default Sqs2EndpointConsumerBuilder basic() {
            return (Sqs2EndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedSqs2EndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedSqs2EndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedSqs2EndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedSqs2EndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedSqs2EndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedSqs2EndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.PollingConsumerPollStrategy&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSqs2EndpointConsumerBuilder pollStrategy(
                org.apache.camel.spi.PollingConsumerPollStrategy pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.PollingConsumerPollStrategy&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSqs2EndpointConsumerBuilder pollStrategy(
                String pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * To use the AmazonSQS as client.
         * 
         * The option is a:
         * &lt;code&gt;software.amazon.awssdk.services.sqs.SqsClient&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param amazonSQSClient the value to set
         * @return the dsl builder
         */
        default AdvancedSqs2EndpointConsumerBuilder amazonSQSClient(
                software.amazon.awssdk.services.sqs.SqsClient amazonSQSClient) {
            doSetProperty("amazonSQSClient", amazonSQSClient);
            return this;
        }
        /**
         * To use the AmazonSQS as client.
         * 
         * The option will be converted to a
         * &lt;code&gt;software.amazon.awssdk.services.sqs.SqsClient&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param amazonSQSClient the value to set
         * @return the dsl builder
         */
        default AdvancedSqs2EndpointConsumerBuilder amazonSQSClient(
                String amazonSQSClient) {
            doSetProperty("amazonSQSClient", amazonSQSClient);
            return this;
        }
        /**
         * Define if you want to apply delaySeconds option to the queue or on
         * single messages.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param delayQueue the value to set
         * @return the dsl builder
         */
        default AdvancedSqs2EndpointConsumerBuilder delayQueue(
                boolean delayQueue) {
            doSetProperty("delayQueue", delayQueue);
            return this;
        }
        /**
         * Define if you want to apply delaySeconds option to the queue or on
         * single messages.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param delayQueue the value to set
         * @return the dsl builder
         */
        default AdvancedSqs2EndpointConsumerBuilder delayQueue(String delayQueue) {
            doSetProperty("delayQueue", delayQueue);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the AWS Simple Queue Service (SQS)
     * component.
     */
    public interface Sqs2EndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedSqs2EndpointProducerBuilder advanced() {
            return (AdvancedSqs2EndpointProducerBuilder) this;
        }
        /**
         * The hostname of the Amazon AWS cloud.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: amazonaws.com
         * Group: common
         * 
         * @param amazonAWSHost the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointProducerBuilder amazonAWSHost(String amazonAWSHost) {
            doSetProperty("amazonAWSHost", amazonAWSHost);
            return this;
        }
        /**
         * Setting the autocreation of the queue.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param autoCreateQueue the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointProducerBuilder autoCreateQueue(
                boolean autoCreateQueue) {
            doSetProperty("autoCreateQueue", autoCreateQueue);
            return this;
        }
        /**
         * Setting the autocreation of the queue.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param autoCreateQueue the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointProducerBuilder autoCreateQueue(
                String autoCreateQueue) {
            doSetProperty("autoCreateQueue", autoCreateQueue);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to map headers to/from Camel.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointProducerBuilder headerFilterStrategy(
                org.apache.camel.spi.HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to map headers to/from Camel.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointProducerBuilder headerFilterStrategy(
                String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * Set the need for overriding the endpoint. This option needs to be
         * used in combination with uriEndpointOverride option.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param overrideEndpoint the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointProducerBuilder overrideEndpoint(
                boolean overrideEndpoint) {
            doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }
        /**
         * Set the need for overriding the endpoint. This option needs to be
         * used in combination with uriEndpointOverride option.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param overrideEndpoint the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointProducerBuilder overrideEndpoint(
                String overrideEndpoint) {
            doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }
        /**
         * The underlying protocol used to communicate with SQS.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: https
         * Group: common
         * 
         * @param protocol the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointProducerBuilder protocol(String protocol) {
            doSetProperty("protocol", protocol);
            return this;
        }
        /**
         * Specify the queue owner aws account id when you need to connect the
         * queue with different account owner.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param queueOwnerAWSAccountId the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointProducerBuilder queueOwnerAWSAccountId(
                String queueOwnerAWSAccountId) {
            doSetProperty("queueOwnerAWSAccountId", queueOwnerAWSAccountId);
            return this;
        }
        /**
         * The region in which SQS client needs to work. When using this
         * parameter, the configuration will expect the lowercase name of the
         * region (for example ap-east-1) You'll need to use the name
         * Region.EU_WEST_1.id().
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param region the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointProducerBuilder region(String region) {
            doSetProperty("region", region);
            return this;
        }
        /**
         * Set the overriding uri endpoint. This option needs to be used in
         * combination with overrideEndpoint option.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param uriEndpointOverride the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointProducerBuilder uriEndpointOverride(
                String uriEndpointOverride) {
            doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }
        /**
         * Set the separator when passing a String to send batch message
         * operation.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: ,
         * Group: producer
         * 
         * @param batchSeparator the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointProducerBuilder batchSeparator(String batchSeparator) {
            doSetProperty("batchSeparator", batchSeparator);
            return this;
        }
        /**
         * Delay sending messages for a number of seconds.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param delaySeconds the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointProducerBuilder delaySeconds(Integer delaySeconds) {
            doSetProperty("delaySeconds", delaySeconds);
            return this;
        }
        /**
         * Delay sending messages for a number of seconds.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param delaySeconds the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointProducerBuilder delaySeconds(String delaySeconds) {
            doSetProperty("delaySeconds", delaySeconds);
            return this;
        }
        /**
         * Only for FIFO queues. Strategy for setting the messageDeduplicationId
         * on the message. Can be one of the following options: useExchangeId,
         * useContentBasedDeduplication. For the useContentBasedDeduplication
         * option, no messageDeduplicationId will be set on the message.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: useExchangeId
         * Group: producer
         * 
         * @param messageDeduplicationIdStrategy the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointProducerBuilder messageDeduplicationIdStrategy(
                String messageDeduplicationIdStrategy) {
            doSetProperty("messageDeduplicationIdStrategy", messageDeduplicationIdStrategy);
            return this;
        }
        /**
         * Only for FIFO queues. Strategy for setting the messageGroupId on the
         * message. Can be one of the following options: useConstant,
         * useExchangeId, usePropertyValue. For the usePropertyValue option, the
         * value of property CamelAwsMessageGroupId will be used.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param messageGroupIdStrategy the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointProducerBuilder messageGroupIdStrategy(
                String messageGroupIdStrategy) {
            doSetProperty("messageGroupIdStrategy", messageGroupIdStrategy);
            return this;
        }
        /**
         * What to do if sending to AWS SQS has more messages than AWS allows
         * (currently only maximum 10 message headers is allowed). WARN will log
         * a WARN about the limit is for each additional header, so the message
         * can be sent to AWS. WARN_ONCE will only log one time a WARN about the
         * limit is hit, and drop additional headers, so the message can be sent
         * to AWS. IGNORE will ignore (no logging) and drop additional headers,
         * so the message can be sent to AWS. FAIL will cause an exception to be
         * thrown and the message is not sent to AWS.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: WARN
         * Group: producer
         * 
         * @param messageHeaderExceededLimit the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointProducerBuilder messageHeaderExceededLimit(
                String messageHeaderExceededLimit) {
            doSetProperty("messageHeaderExceededLimit", messageHeaderExceededLimit);
            return this;
        }
        /**
         * The operation to do in case the user don't want to send only a
         * message.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.aws2.sqs.Sqs2Operations&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointProducerBuilder operation(
                org.apache.camel.component.aws2.sqs.Sqs2Operations operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * The operation to do in case the user don't want to send only a
         * message.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.aws2.sqs.Sqs2Operations&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointProducerBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * To define a proxy host when instantiating the SQS client.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyHost the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointProducerBuilder proxyHost(String proxyHost) {
            doSetProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * To define a proxy port when instantiating the SQS client.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointProducerBuilder proxyPort(Integer proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * To define a proxy port when instantiating the SQS client.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointProducerBuilder proxyPort(String proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the SQS client.
         * 
         * The option is a:
         * &lt;code&gt;software.amazon.awssdk.core.Protocol&lt;/code&gt; type.
         * 
         * Default: HTTPS
         * Group: proxy
         * 
         * @param proxyProtocol the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointProducerBuilder proxyProtocol(
                software.amazon.awssdk.core.Protocol proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the SQS client.
         * 
         * The option will be converted to a
         * &lt;code&gt;software.amazon.awssdk.core.Protocol&lt;/code&gt; type.
         * 
         * Default: HTTPS
         * Group: proxy
         * 
         * @param proxyProtocol the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointProducerBuilder proxyProtocol(String proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
        /**
         * The maximumMessageSize (in bytes) an SQS message can contain for this
         * queue.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param maximumMessageSize the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointProducerBuilder maximumMessageSize(
                Integer maximumMessageSize) {
            doSetProperty("maximumMessageSize", maximumMessageSize);
            return this;
        }
        /**
         * The maximumMessageSize (in bytes) an SQS message can contain for this
         * queue.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param maximumMessageSize the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointProducerBuilder maximumMessageSize(
                String maximumMessageSize) {
            doSetProperty("maximumMessageSize", maximumMessageSize);
            return this;
        }
        /**
         * The messageRetentionPeriod (in seconds) a message will be retained by
         * SQS for this queue.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param messageRetentionPeriod the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointProducerBuilder messageRetentionPeriod(
                Integer messageRetentionPeriod) {
            doSetProperty("messageRetentionPeriod", messageRetentionPeriod);
            return this;
        }
        /**
         * The messageRetentionPeriod (in seconds) a message will be retained by
         * SQS for this queue.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param messageRetentionPeriod the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointProducerBuilder messageRetentionPeriod(
                String messageRetentionPeriod) {
            doSetProperty("messageRetentionPeriod", messageRetentionPeriod);
            return this;
        }
        /**
         * The policy for this queue. It can be loaded by default from
         * classpath, but you can prefix with classpath:, file:, or http: to
         * load the resource from different systems.
         * 
         * This option can also be loaded from an existing file, by prefixing
         * with file: or classpath: followed by the location of the file.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param policy the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointProducerBuilder policy(String policy) {
            doSetProperty("policy", policy);
            return this;
        }
        /**
         * To define the queueUrl explicitly. All other parameters, which would
         * influence the queueUrl, are ignored. This parameter is intended to be
         * used, to connect to a mock implementation of SQS, for testing
         * purposes.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param queueUrl the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointProducerBuilder queueUrl(String queueUrl) {
            doSetProperty("queueUrl", queueUrl);
            return this;
        }
        /**
         * If you do not specify WaitTimeSeconds in the request, the queue
         * attribute ReceiveMessageWaitTimeSeconds is used to determine how long
         * to wait.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param receiveMessageWaitTimeSeconds the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointProducerBuilder receiveMessageWaitTimeSeconds(
                Integer receiveMessageWaitTimeSeconds) {
            doSetProperty("receiveMessageWaitTimeSeconds", receiveMessageWaitTimeSeconds);
            return this;
        }
        /**
         * If you do not specify WaitTimeSeconds in the request, the queue
         * attribute ReceiveMessageWaitTimeSeconds is used to determine how long
         * to wait.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param receiveMessageWaitTimeSeconds the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointProducerBuilder receiveMessageWaitTimeSeconds(
                String receiveMessageWaitTimeSeconds) {
            doSetProperty("receiveMessageWaitTimeSeconds", receiveMessageWaitTimeSeconds);
            return this;
        }
        /**
         * Specify the policy that send message to DeadLetter queue. See detail
         * at Amazon docs.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param redrivePolicy the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointProducerBuilder redrivePolicy(String redrivePolicy) {
            doSetProperty("redrivePolicy", redrivePolicy);
            return this;
        }
        /**
         * Amazon AWS Access Key.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param accessKey the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointProducerBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * If using a profile credentials provider this parameter will set the
         * profile name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param profileCredentialsName the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointProducerBuilder profileCredentialsName(
                String profileCredentialsName) {
            doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }
        /**
         * Amazon AWS Secret Key.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param secretKey the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointProducerBuilder secretKey(String secretKey) {
            doSetProperty("secretKey", secretKey);
            return this;
        }
        /**
         * If we want to trust all certificates in case of overriding the
         * endpoint.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param trustAllCertificates the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointProducerBuilder trustAllCertificates(
                boolean trustAllCertificates) {
            doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }
        /**
         * If we want to trust all certificates in case of overriding the
         * endpoint.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: security
         * 
         * @param trustAllCertificates the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointProducerBuilder trustAllCertificates(
                String trustAllCertificates) {
            doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }
        /**
         * Set whether the SQS client should expect to load credentials on an
         * AWS infra instance or to expect static credentials to be passed in.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useDefaultCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointProducerBuilder useDefaultCredentialsProvider(
                boolean useDefaultCredentialsProvider) {
            doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }
        /**
         * Set whether the SQS client should expect to load credentials on an
         * AWS infra instance or to expect static credentials to be passed in.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useDefaultCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointProducerBuilder useDefaultCredentialsProvider(
                String useDefaultCredentialsProvider) {
            doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }
        /**
         * Set whether the SQS client should expect to load credentials through
         * a profile credentials provider.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useProfileCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointProducerBuilder useProfileCredentialsProvider(
                boolean useProfileCredentialsProvider) {
            doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }
        /**
         * Set whether the SQS client should expect to load credentials through
         * a profile credentials provider.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useProfileCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointProducerBuilder useProfileCredentialsProvider(
                String useProfileCredentialsProvider) {
            doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the AWS Simple Queue Service
     * (SQS) component.
     */
    public interface AdvancedSqs2EndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default Sqs2EndpointProducerBuilder basic() {
            return (Sqs2EndpointProducerBuilder) this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedSqs2EndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedSqs2EndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * To use the AmazonSQS as client.
         * 
         * The option is a:
         * &lt;code&gt;software.amazon.awssdk.services.sqs.SqsClient&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param amazonSQSClient the value to set
         * @return the dsl builder
         */
        default AdvancedSqs2EndpointProducerBuilder amazonSQSClient(
                software.amazon.awssdk.services.sqs.SqsClient amazonSQSClient) {
            doSetProperty("amazonSQSClient", amazonSQSClient);
            return this;
        }
        /**
         * To use the AmazonSQS as client.
         * 
         * The option will be converted to a
         * &lt;code&gt;software.amazon.awssdk.services.sqs.SqsClient&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param amazonSQSClient the value to set
         * @return the dsl builder
         */
        default AdvancedSqs2EndpointProducerBuilder amazonSQSClient(
                String amazonSQSClient) {
            doSetProperty("amazonSQSClient", amazonSQSClient);
            return this;
        }
        /**
         * Define if you want to apply delaySeconds option to the queue or on
         * single messages.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param delayQueue the value to set
         * @return the dsl builder
         */
        default AdvancedSqs2EndpointProducerBuilder delayQueue(
                boolean delayQueue) {
            doSetProperty("delayQueue", delayQueue);
            return this;
        }
        /**
         * Define if you want to apply delaySeconds option to the queue or on
         * single messages.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param delayQueue the value to set
         * @return the dsl builder
         */
        default AdvancedSqs2EndpointProducerBuilder delayQueue(String delayQueue) {
            doSetProperty("delayQueue", delayQueue);
            return this;
        }
    }

    /**
     * Builder for endpoint for the AWS Simple Queue Service (SQS) component.
     */
    public interface Sqs2EndpointBuilder
            extends
                Sqs2EndpointConsumerBuilder,
                Sqs2EndpointProducerBuilder {
        default AdvancedSqs2EndpointBuilder advanced() {
            return (AdvancedSqs2EndpointBuilder) this;
        }
        /**
         * The hostname of the Amazon AWS cloud.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: amazonaws.com
         * Group: common
         * 
         * @param amazonAWSHost the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointBuilder amazonAWSHost(String amazonAWSHost) {
            doSetProperty("amazonAWSHost", amazonAWSHost);
            return this;
        }
        /**
         * Setting the autocreation of the queue.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param autoCreateQueue the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointBuilder autoCreateQueue(boolean autoCreateQueue) {
            doSetProperty("autoCreateQueue", autoCreateQueue);
            return this;
        }
        /**
         * Setting the autocreation of the queue.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param autoCreateQueue the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointBuilder autoCreateQueue(String autoCreateQueue) {
            doSetProperty("autoCreateQueue", autoCreateQueue);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to map headers to/from Camel.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointBuilder headerFilterStrategy(
                org.apache.camel.spi.HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to map headers to/from Camel.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointBuilder headerFilterStrategy(
                String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * Set the need for overriding the endpoint. This option needs to be
         * used in combination with uriEndpointOverride option.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param overrideEndpoint the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointBuilder overrideEndpoint(boolean overrideEndpoint) {
            doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }
        /**
         * Set the need for overriding the endpoint. This option needs to be
         * used in combination with uriEndpointOverride option.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param overrideEndpoint the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointBuilder overrideEndpoint(String overrideEndpoint) {
            doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }
        /**
         * The underlying protocol used to communicate with SQS.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: https
         * Group: common
         * 
         * @param protocol the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointBuilder protocol(String protocol) {
            doSetProperty("protocol", protocol);
            return this;
        }
        /**
         * Specify the queue owner aws account id when you need to connect the
         * queue with different account owner.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param queueOwnerAWSAccountId the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointBuilder queueOwnerAWSAccountId(
                String queueOwnerAWSAccountId) {
            doSetProperty("queueOwnerAWSAccountId", queueOwnerAWSAccountId);
            return this;
        }
        /**
         * The region in which SQS client needs to work. When using this
         * parameter, the configuration will expect the lowercase name of the
         * region (for example ap-east-1) You'll need to use the name
         * Region.EU_WEST_1.id().
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param region the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointBuilder region(String region) {
            doSetProperty("region", region);
            return this;
        }
        /**
         * Set the overriding uri endpoint. This option needs to be used in
         * combination with overrideEndpoint option.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param uriEndpointOverride the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointBuilder uriEndpointOverride(
                String uriEndpointOverride) {
            doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }
        /**
         * To define a proxy host when instantiating the SQS client.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyHost the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointBuilder proxyHost(String proxyHost) {
            doSetProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * To define a proxy port when instantiating the SQS client.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointBuilder proxyPort(Integer proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * To define a proxy port when instantiating the SQS client.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointBuilder proxyPort(String proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the SQS client.
         * 
         * The option is a:
         * &lt;code&gt;software.amazon.awssdk.core.Protocol&lt;/code&gt; type.
         * 
         * Default: HTTPS
         * Group: proxy
         * 
         * @param proxyProtocol the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointBuilder proxyProtocol(
                software.amazon.awssdk.core.Protocol proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the SQS client.
         * 
         * The option will be converted to a
         * &lt;code&gt;software.amazon.awssdk.core.Protocol&lt;/code&gt; type.
         * 
         * Default: HTTPS
         * Group: proxy
         * 
         * @param proxyProtocol the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointBuilder proxyProtocol(String proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
        /**
         * The maximumMessageSize (in bytes) an SQS message can contain for this
         * queue.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param maximumMessageSize the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointBuilder maximumMessageSize(
                Integer maximumMessageSize) {
            doSetProperty("maximumMessageSize", maximumMessageSize);
            return this;
        }
        /**
         * The maximumMessageSize (in bytes) an SQS message can contain for this
         * queue.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param maximumMessageSize the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointBuilder maximumMessageSize(String maximumMessageSize) {
            doSetProperty("maximumMessageSize", maximumMessageSize);
            return this;
        }
        /**
         * The messageRetentionPeriod (in seconds) a message will be retained by
         * SQS for this queue.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param messageRetentionPeriod the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointBuilder messageRetentionPeriod(
                Integer messageRetentionPeriod) {
            doSetProperty("messageRetentionPeriod", messageRetentionPeriod);
            return this;
        }
        /**
         * The messageRetentionPeriod (in seconds) a message will be retained by
         * SQS for this queue.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param messageRetentionPeriod the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointBuilder messageRetentionPeriod(
                String messageRetentionPeriod) {
            doSetProperty("messageRetentionPeriod", messageRetentionPeriod);
            return this;
        }
        /**
         * The policy for this queue. It can be loaded by default from
         * classpath, but you can prefix with classpath:, file:, or http: to
         * load the resource from different systems.
         * 
         * This option can also be loaded from an existing file, by prefixing
         * with file: or classpath: followed by the location of the file.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param policy the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointBuilder policy(String policy) {
            doSetProperty("policy", policy);
            return this;
        }
        /**
         * To define the queueUrl explicitly. All other parameters, which would
         * influence the queueUrl, are ignored. This parameter is intended to be
         * used, to connect to a mock implementation of SQS, for testing
         * purposes.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param queueUrl the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointBuilder queueUrl(String queueUrl) {
            doSetProperty("queueUrl", queueUrl);
            return this;
        }
        /**
         * If you do not specify WaitTimeSeconds in the request, the queue
         * attribute ReceiveMessageWaitTimeSeconds is used to determine how long
         * to wait.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param receiveMessageWaitTimeSeconds the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointBuilder receiveMessageWaitTimeSeconds(
                Integer receiveMessageWaitTimeSeconds) {
            doSetProperty("receiveMessageWaitTimeSeconds", receiveMessageWaitTimeSeconds);
            return this;
        }
        /**
         * If you do not specify WaitTimeSeconds in the request, the queue
         * attribute ReceiveMessageWaitTimeSeconds is used to determine how long
         * to wait.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param receiveMessageWaitTimeSeconds the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointBuilder receiveMessageWaitTimeSeconds(
                String receiveMessageWaitTimeSeconds) {
            doSetProperty("receiveMessageWaitTimeSeconds", receiveMessageWaitTimeSeconds);
            return this;
        }
        /**
         * Specify the policy that send message to DeadLetter queue. See detail
         * at Amazon docs.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param redrivePolicy the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointBuilder redrivePolicy(String redrivePolicy) {
            doSetProperty("redrivePolicy", redrivePolicy);
            return this;
        }
        /**
         * Amazon AWS Access Key.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param accessKey the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * If using a profile credentials provider this parameter will set the
         * profile name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param profileCredentialsName the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointBuilder profileCredentialsName(
                String profileCredentialsName) {
            doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }
        /**
         * Amazon AWS Secret Key.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param secretKey the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointBuilder secretKey(String secretKey) {
            doSetProperty("secretKey", secretKey);
            return this;
        }
        /**
         * If we want to trust all certificates in case of overriding the
         * endpoint.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param trustAllCertificates the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointBuilder trustAllCertificates(
                boolean trustAllCertificates) {
            doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }
        /**
         * If we want to trust all certificates in case of overriding the
         * endpoint.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: security
         * 
         * @param trustAllCertificates the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointBuilder trustAllCertificates(
                String trustAllCertificates) {
            doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }
        /**
         * Set whether the SQS client should expect to load credentials on an
         * AWS infra instance or to expect static credentials to be passed in.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useDefaultCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointBuilder useDefaultCredentialsProvider(
                boolean useDefaultCredentialsProvider) {
            doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }
        /**
         * Set whether the SQS client should expect to load credentials on an
         * AWS infra instance or to expect static credentials to be passed in.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useDefaultCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointBuilder useDefaultCredentialsProvider(
                String useDefaultCredentialsProvider) {
            doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }
        /**
         * Set whether the SQS client should expect to load credentials through
         * a profile credentials provider.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useProfileCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointBuilder useProfileCredentialsProvider(
                boolean useProfileCredentialsProvider) {
            doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }
        /**
         * Set whether the SQS client should expect to load credentials through
         * a profile credentials provider.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useProfileCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Sqs2EndpointBuilder useProfileCredentialsProvider(
                String useProfileCredentialsProvider) {
            doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the AWS Simple Queue Service (SQS)
     * component.
     */
    public interface AdvancedSqs2EndpointBuilder
            extends
                AdvancedSqs2EndpointConsumerBuilder,
                AdvancedSqs2EndpointProducerBuilder {
        default Sqs2EndpointBuilder basic() {
            return (Sqs2EndpointBuilder) this;
        }
        /**
         * To use the AmazonSQS as client.
         * 
         * The option is a:
         * &lt;code&gt;software.amazon.awssdk.services.sqs.SqsClient&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param amazonSQSClient the value to set
         * @return the dsl builder
         */
        default AdvancedSqs2EndpointBuilder amazonSQSClient(
                software.amazon.awssdk.services.sqs.SqsClient amazonSQSClient) {
            doSetProperty("amazonSQSClient", amazonSQSClient);
            return this;
        }
        /**
         * To use the AmazonSQS as client.
         * 
         * The option will be converted to a
         * &lt;code&gt;software.amazon.awssdk.services.sqs.SqsClient&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param amazonSQSClient the value to set
         * @return the dsl builder
         */
        default AdvancedSqs2EndpointBuilder amazonSQSClient(
                String amazonSQSClient) {
            doSetProperty("amazonSQSClient", amazonSQSClient);
            return this;
        }
        /**
         * Define if you want to apply delaySeconds option to the queue or on
         * single messages.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param delayQueue the value to set
         * @return the dsl builder
         */
        default AdvancedSqs2EndpointBuilder delayQueue(boolean delayQueue) {
            doSetProperty("delayQueue", delayQueue);
            return this;
        }
        /**
         * Define if you want to apply delaySeconds option to the queue or on
         * single messages.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param delayQueue the value to set
         * @return the dsl builder
         */
        default AdvancedSqs2EndpointBuilder delayQueue(String delayQueue) {
            doSetProperty("delayQueue", delayQueue);
            return this;
        }
    }

    public interface Sqs2Builders {
        /**
         * AWS Simple Queue Service (SQS) (camel-aws2-sqs)
         * Send and receive messages to/from AWS SQS.
         * 
         * Category: cloud,messaging
         * Since: 3.1
         * Maven coordinates: org.apache.camel:camel-aws2-sqs
         * 
         * @return the dsl builder for the headers' name.
         */
        default Sqs2HeaderNameBuilder aws2Sqs() {
            return Sqs2HeaderNameBuilder.INSTANCE;
        }
        /**
         * AWS Simple Queue Service (SQS) (camel-aws2-sqs)
         * Send and receive messages to/from AWS SQS.
         * 
         * Category: cloud,messaging
         * Since: 3.1
         * Maven coordinates: org.apache.camel:camel-aws2-sqs
         * 
         * Syntax: <code>aws2-sqs:queueNameOrArn</code>
         * 
         * Path parameter: queueNameOrArn (required)
         * Queue name or ARN
         * 
         * @param path queueNameOrArn
         * @return the dsl builder
         */
        default Sqs2EndpointBuilder aws2Sqs(String path) {
            return Sqs2EndpointBuilderFactory.endpointBuilder("aws2-sqs", path);
        }
        /**
         * AWS Simple Queue Service (SQS) (camel-aws2-sqs)
         * Send and receive messages to/from AWS SQS.
         * 
         * Category: cloud,messaging
         * Since: 3.1
         * Maven coordinates: org.apache.camel:camel-aws2-sqs
         * 
         * Syntax: <code>aws2-sqs:queueNameOrArn</code>
         * 
         * Path parameter: queueNameOrArn (required)
         * Queue name or ARN
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path queueNameOrArn
         * @return the dsl builder
         */
        default Sqs2EndpointBuilder aws2Sqs(String componentName, String path) {
            return Sqs2EndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    /**
     * The builder of headers' name for the AWS Simple Queue Service (SQS)
     * component.
     */
    public static class Sqs2HeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final Sqs2HeaderNameBuilder INSTANCE = new Sqs2HeaderNameBuilder();

        /**
         * A map of the attributes requested in ReceiveMessage to their
         * respective values.
         * 
         * The option is a: {@code Map<MessageSystemAttributeName, String>}
         * type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code AwsSqsAttributes}.
         */
        public String awsSqsAttributes() {
            return "AwsSqsAttributes";
        }

        /**
         * The Amazon SQS message attributes.
         * 
         * The option is a: {@code Map<String, MessageAttributeValue>} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code AwsSqsMessageAttributes}.
         */
        public String awsSqsMessageAttributes() {
            return "AwsSqsMessageAttributes";
        }

        /**
         * The MD5 checksum of the Amazon SQS message.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code AwsSqsMD5OfBody}.
         */
        public String awsSqsMD5OfBody() {
            return "AwsSqsMD5OfBody";
        }

        /**
         * The Amazon SQS message ID.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code AwsSqsMessageId}.
         */
        public String awsSqsMessageId() {
            return "AwsSqsMessageId";
        }

        /**
         * The Amazon SQS message receipt handle.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code AwsSqsReceiptHandle}.
         */
        public String awsSqsReceiptHandle() {
            return "AwsSqsReceiptHandle";
        }

        /**
         * The delay seconds that the Amazon SQS message can be see by others.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsSqsDelaySeconds}.
         */
        public String awsSqsDelaySeconds() {
            return "AwsSqsDelaySeconds";
        }

        /**
         * A string to use for filtering the list results.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code AwsSqsPrefix}.
         */
        public String awsSqsPrefix() {
            return "AwsSqsPrefix";
        }

        /**
         * The operation we want to perform.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code AwsSqsOperation}.
         */
        public String awsSqsOperation() {
            return "AwsSqsOperation";
        }
    }
    static Sqs2EndpointBuilder endpointBuilder(String componentName, String path) {
        class Sqs2EndpointBuilderImpl extends AbstractEndpointBuilder implements Sqs2EndpointBuilder, AdvancedSqs2EndpointBuilder {
            public Sqs2EndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new Sqs2EndpointBuilderImpl(path);
    }
}