/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Produce or consume Apache Avro RPC services.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface AvroEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Avro RPC component.
     */
    public interface AvroEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedAvroEndpointConsumerBuilder advanced() {
            return (AdvancedAvroEndpointConsumerBuilder) this;
        }
        /**
         * Avro protocol to use.
         * 
         * The option is a: &lt;code&gt;org.apache.avro.Protocol&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param protocol the value to set
         * @return the dsl builder
         */
        default AvroEndpointConsumerBuilder protocol(
                org.apache.avro.Protocol protocol) {
            doSetProperty("protocol", protocol);
            return this;
        }
        /**
         * Avro protocol to use.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.avro.Protocol&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param protocol the value to set
         * @return the dsl builder
         */
        default AvroEndpointConsumerBuilder protocol(String protocol) {
            doSetProperty("protocol", protocol);
            return this;
        }
        /**
         * Avro protocol to use defined by the FQN class name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param protocolClassName the value to set
         * @return the dsl builder
         */
        default AvroEndpointConsumerBuilder protocolClassName(
                String protocolClassName) {
            doSetProperty("protocolClassName", protocolClassName);
            return this;
        }
        /**
         * Avro protocol location.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param protocolLocation the value to set
         * @return the dsl builder
         */
        default AvroEndpointConsumerBuilder protocolLocation(
                String protocolLocation) {
            doSetProperty("protocolLocation", protocolLocation);
            return this;
        }
        /**
         * If protocol object provided is reflection protocol. Should be used
         * only with protocol parameter because for protocolClassName protocol
         * type will be auto detected.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param reflectionProtocol the value to set
         * @return the dsl builder
         */
        default AvroEndpointConsumerBuilder reflectionProtocol(
                boolean reflectionProtocol) {
            doSetProperty("reflectionProtocol", reflectionProtocol);
            return this;
        }
        /**
         * If protocol object provided is reflection protocol. Should be used
         * only with protocol parameter because for protocolClassName protocol
         * type will be auto detected.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param reflectionProtocol the value to set
         * @return the dsl builder
         */
        default AvroEndpointConsumerBuilder reflectionProtocol(
                String reflectionProtocol) {
            doSetProperty("reflectionProtocol", reflectionProtocol);
            return this;
        }
        /**
         * If true, consumer parameter won't be wrapped into array. Will fail if
         * protocol specifies more then 1 parameter for the message.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param singleParameter the value to set
         * @return the dsl builder
         */
        default AvroEndpointConsumerBuilder singleParameter(
                boolean singleParameter) {
            doSetProperty("singleParameter", singleParameter);
            return this;
        }
        /**
         * If true, consumer parameter won't be wrapped into array. Will fail if
         * protocol specifies more then 1 parameter for the message.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param singleParameter the value to set
         * @return the dsl builder
         */
        default AvroEndpointConsumerBuilder singleParameter(
                String singleParameter) {
            doSetProperty("singleParameter", singleParameter);
            return this;
        }
        /**
         * Authority to use (username and password).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param uriAuthority the value to set
         * @return the dsl builder
         */
        default AvroEndpointConsumerBuilder uriAuthority(String uriAuthority) {
            doSetProperty("uriAuthority", uriAuthority);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Avro RPC component.
     */
    public interface AdvancedAvroEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AvroEndpointConsumerBuilder basic() {
            return (AvroEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedAvroEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedAvroEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedAvroEndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedAvroEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedAvroEndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedAvroEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Avro RPC component.
     */
    public interface AvroEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedAvroEndpointProducerBuilder advanced() {
            return (AdvancedAvroEndpointProducerBuilder) this;
        }
        /**
         * Avro protocol to use.
         * 
         * The option is a: &lt;code&gt;org.apache.avro.Protocol&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param protocol the value to set
         * @return the dsl builder
         */
        default AvroEndpointProducerBuilder protocol(
                org.apache.avro.Protocol protocol) {
            doSetProperty("protocol", protocol);
            return this;
        }
        /**
         * Avro protocol to use.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.avro.Protocol&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param protocol the value to set
         * @return the dsl builder
         */
        default AvroEndpointProducerBuilder protocol(String protocol) {
            doSetProperty("protocol", protocol);
            return this;
        }
        /**
         * Avro protocol to use defined by the FQN class name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param protocolClassName the value to set
         * @return the dsl builder
         */
        default AvroEndpointProducerBuilder protocolClassName(
                String protocolClassName) {
            doSetProperty("protocolClassName", protocolClassName);
            return this;
        }
        /**
         * Avro protocol location.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param protocolLocation the value to set
         * @return the dsl builder
         */
        default AvroEndpointProducerBuilder protocolLocation(
                String protocolLocation) {
            doSetProperty("protocolLocation", protocolLocation);
            return this;
        }
        /**
         * If protocol object provided is reflection protocol. Should be used
         * only with protocol parameter because for protocolClassName protocol
         * type will be auto detected.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param reflectionProtocol the value to set
         * @return the dsl builder
         */
        default AvroEndpointProducerBuilder reflectionProtocol(
                boolean reflectionProtocol) {
            doSetProperty("reflectionProtocol", reflectionProtocol);
            return this;
        }
        /**
         * If protocol object provided is reflection protocol. Should be used
         * only with protocol parameter because for protocolClassName protocol
         * type will be auto detected.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param reflectionProtocol the value to set
         * @return the dsl builder
         */
        default AvroEndpointProducerBuilder reflectionProtocol(
                String reflectionProtocol) {
            doSetProperty("reflectionProtocol", reflectionProtocol);
            return this;
        }
        /**
         * If true, consumer parameter won't be wrapped into array. Will fail if
         * protocol specifies more then 1 parameter for the message.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param singleParameter the value to set
         * @return the dsl builder
         */
        default AvroEndpointProducerBuilder singleParameter(
                boolean singleParameter) {
            doSetProperty("singleParameter", singleParameter);
            return this;
        }
        /**
         * If true, consumer parameter won't be wrapped into array. Will fail if
         * protocol specifies more then 1 parameter for the message.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param singleParameter the value to set
         * @return the dsl builder
         */
        default AvroEndpointProducerBuilder singleParameter(
                String singleParameter) {
            doSetProperty("singleParameter", singleParameter);
            return this;
        }
        /**
         * Authority to use (username and password).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param uriAuthority the value to set
         * @return the dsl builder
         */
        default AvroEndpointProducerBuilder uriAuthority(String uriAuthority) {
            doSetProperty("uriAuthority", uriAuthority);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Avro RPC component.
     */
    public interface AdvancedAvroEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AvroEndpointProducerBuilder basic() {
            return (AvroEndpointProducerBuilder) this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedAvroEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedAvroEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Avro RPC component.
     */
    public interface AvroEndpointBuilder
            extends
                AvroEndpointConsumerBuilder,
                AvroEndpointProducerBuilder {
        default AdvancedAvroEndpointBuilder advanced() {
            return (AdvancedAvroEndpointBuilder) this;
        }
        /**
         * Avro protocol to use.
         * 
         * The option is a: &lt;code&gt;org.apache.avro.Protocol&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param protocol the value to set
         * @return the dsl builder
         */
        default AvroEndpointBuilder protocol(org.apache.avro.Protocol protocol) {
            doSetProperty("protocol", protocol);
            return this;
        }
        /**
         * Avro protocol to use.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.avro.Protocol&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param protocol the value to set
         * @return the dsl builder
         */
        default AvroEndpointBuilder protocol(String protocol) {
            doSetProperty("protocol", protocol);
            return this;
        }
        /**
         * Avro protocol to use defined by the FQN class name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param protocolClassName the value to set
         * @return the dsl builder
         */
        default AvroEndpointBuilder protocolClassName(String protocolClassName) {
            doSetProperty("protocolClassName", protocolClassName);
            return this;
        }
        /**
         * Avro protocol location.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param protocolLocation the value to set
         * @return the dsl builder
         */
        default AvroEndpointBuilder protocolLocation(String protocolLocation) {
            doSetProperty("protocolLocation", protocolLocation);
            return this;
        }
        /**
         * If protocol object provided is reflection protocol. Should be used
         * only with protocol parameter because for protocolClassName protocol
         * type will be auto detected.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param reflectionProtocol the value to set
         * @return the dsl builder
         */
        default AvroEndpointBuilder reflectionProtocol(
                boolean reflectionProtocol) {
            doSetProperty("reflectionProtocol", reflectionProtocol);
            return this;
        }
        /**
         * If protocol object provided is reflection protocol. Should be used
         * only with protocol parameter because for protocolClassName protocol
         * type will be auto detected.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param reflectionProtocol the value to set
         * @return the dsl builder
         */
        default AvroEndpointBuilder reflectionProtocol(String reflectionProtocol) {
            doSetProperty("reflectionProtocol", reflectionProtocol);
            return this;
        }
        /**
         * If true, consumer parameter won't be wrapped into array. Will fail if
         * protocol specifies more then 1 parameter for the message.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param singleParameter the value to set
         * @return the dsl builder
         */
        default AvroEndpointBuilder singleParameter(boolean singleParameter) {
            doSetProperty("singleParameter", singleParameter);
            return this;
        }
        /**
         * If true, consumer parameter won't be wrapped into array. Will fail if
         * protocol specifies more then 1 parameter for the message.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param singleParameter the value to set
         * @return the dsl builder
         */
        default AvroEndpointBuilder singleParameter(String singleParameter) {
            doSetProperty("singleParameter", singleParameter);
            return this;
        }
        /**
         * Authority to use (username and password).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param uriAuthority the value to set
         * @return the dsl builder
         */
        default AvroEndpointBuilder uriAuthority(String uriAuthority) {
            doSetProperty("uriAuthority", uriAuthority);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Avro RPC component.
     */
    public interface AdvancedAvroEndpointBuilder
            extends
                AdvancedAvroEndpointConsumerBuilder,
                AdvancedAvroEndpointProducerBuilder {
        default AvroEndpointBuilder basic() {
            return (AvroEndpointBuilder) this;
        }
    }

    public interface AvroBuilders {
        /**
         * Avro RPC (camel-avro-rpc)
         * Produce or consume Apache Avro RPC services.
         * 
         * Category: rpc
         * Since: 2.10
         * Maven coordinates: org.apache.camel:camel-avro-rpc
         * 
         * @return the dsl builder for the headers' name.
         */
        default AvroHeaderNameBuilder avro() {
            return AvroHeaderNameBuilder.INSTANCE;
        }
        /**
         * Avro RPC (camel-avro-rpc)
         * Produce or consume Apache Avro RPC services.
         * 
         * Category: rpc
         * Since: 2.10
         * Maven coordinates: org.apache.camel:camel-avro-rpc
         * 
         * Syntax: <code>avro:transport:host:port/messageName</code>
         * 
         * Path parameter: transport (required)
         * Transport to use, can be either http or netty
         * There are 2 enums and the value can be one of: http, netty
         * 
         * Path parameter: port (required)
         * Port number to use
         * 
         * Path parameter: host (required)
         * Hostname to use
         * 
         * Path parameter: messageName
         * The name of the message to send.
         * 
         * @param path transport:host:port/messageName
         * @return the dsl builder
         */
        default AvroEndpointBuilder avro(String path) {
            return AvroEndpointBuilderFactory.endpointBuilder("avro", path);
        }
        /**
         * Avro RPC (camel-avro-rpc)
         * Produce or consume Apache Avro RPC services.
         * 
         * Category: rpc
         * Since: 2.10
         * Maven coordinates: org.apache.camel:camel-avro-rpc
         * 
         * Syntax: <code>avro:transport:host:port/messageName</code>
         * 
         * Path parameter: transport (required)
         * Transport to use, can be either http or netty
         * There are 2 enums and the value can be one of: http, netty
         * 
         * Path parameter: port (required)
         * Port number to use
         * 
         * Path parameter: host (required)
         * Hostname to use
         * 
         * Path parameter: messageName
         * The name of the message to send.
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path transport:host:port/messageName
         * @return the dsl builder
         */
        default AvroEndpointBuilder avro(String componentName, String path) {
            return AvroEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    /**
     * The builder of headers' name for the Avro RPC component.
     */
    public static class AvroHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final AvroHeaderNameBuilder INSTANCE = new AvroHeaderNameBuilder();

        /**
         * The name of the message to send. In consumer overrides message name
         * from URI (if any).
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code AvroMessageName}.
         */
        public String avroMessageName() {
            return "CamelAvroMessageName";
        }
    }
    static AvroEndpointBuilder endpointBuilder(String componentName, String path) {
        class AvroEndpointBuilderImpl extends AbstractEndpointBuilder implements AvroEndpointBuilder, AdvancedAvroEndpointBuilder {
            public AvroEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new AvroEndpointBuilderImpl(path);
    }
}