/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.component.aws2.s3.AWS2S3Operations;
import org.apache.camel.component.aws2.s3.stream.AWSS3NamingStrategyEnum;
import org.apache.camel.component.aws2.s3.stream.AWSS3RestartingPolicyEnum;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.presigner.S3Presigner;

public interface AWS2S3EndpointBuilderFactory {
    public static AWS2S3EndpointBuilder endpointBuilder(String componentName, String path) {
        class AWS2S3EndpointBuilderImpl
        extends AbstractEndpointBuilder
        implements AWS2S3EndpointBuilder,
        AdvancedAWS2S3EndpointBuilder {
            final /* synthetic */ String val$componentName;

            public AWS2S3EndpointBuilderImpl(String path, String string) {
                this.val$componentName = string;
                super(string, path);
            }
        }
        return new AWS2S3EndpointBuilderImpl(path, componentName);
    }

    public static class AWS2S3HeaderNameBuilder {
        private static final AWS2S3HeaderNameBuilder INSTANCE = new AWS2S3HeaderNameBuilder();

        public String awsS3BucketName() {
            return "CamelAwsS3BucketName";
        }

        public String awsS3BucketDestinationName() {
            return "CamelAwsS3BucketDestinationName";
        }

        public String awsS3ContentControl() {
            return "CamelAwsS3ContentControl";
        }

        public String awsS3ContentDisposition() {
            return "CamelAwsS3ContentDisposition";
        }

        public String awsS3ContentEncoding() {
            return "CamelAwsS3ContentEncoding";
        }

        public String awsS3ContentLength() {
            return "CamelAwsS3ContentLength";
        }

        public String awsS3ContentMD5() {
            return "CamelAwsS3ContentMD5";
        }

        public String awsS3ContentType() {
            return "CamelAwsS3ContentType";
        }

        public String awsS3ETag() {
            return "CamelAwsS3ETag";
        }

        public String awsS3Key() {
            return "CamelAwsS3Key";
        }

        public String awsS3DestinationKey() {
            return "CamelAwsS3DestinationKey";
        }

        public String awsS3LastModified() {
            return "CamelAwsS3LastModified";
        }

        public String awsS3StorageClass() {
            return "CamelAwsS3StorageClass";
        }

        public String awsS3VersionId() {
            return "CamelAwsS3VersionId";
        }

        public String awsS3CannedAcl() {
            return "CamelAwsS3CannedAcl";
        }

        public String awsS3Acl() {
            return "CamelAwsS3Acl";
        }

        public String awsS3Operation() {
            return "CamelAwsS3Operation";
        }

        public String awsS3ServerSideEncryption() {
            return "CamelAwsS3ServerSideEncryption";
        }

        public String awsS3ExpirationTime() {
            return "CamelAwsS3ExpirationTime";
        }

        public String awsS3ReplicationStatus() {
            return "CamelAwsS3ReplicationStatus";
        }

        public String awsS3RangeStart() {
            return "CamelAwsS3RangeStart";
        }

        public String awsS3RangeEnd() {
            return "CamelAwsS3RangeEnd";
        }

        public String awsS3DowloadLinkExpirationTime() {
            return "CamelAwsS3DowloadLinkExpirationTime";
        }

        public String awsS3DownloadLinkBrowserCompatible() {
            return "CamelAwsS3DownloadLinkBrowserCompatible";
        }

        public String awsS3DownloadLinkHttpRequestHeaders() {
            return "CamelAwsS3DownloadLinkHttpRequestHeaders";
        }

        public String awsS3DownloadLinkSignedPayload() {
            return "CamelAwsS3DownloadLinkSignedPayload";
        }

        public String awsS3Metadata() {
            return "CamelAwsS3Metadata";
        }

        public String messageTimestamp() {
            return "CamelMessageTimestamp";
        }

        public String awsS3Prefix() {
            return "CamelAwsS3Prefix";
        }

        public String awsS3Delimiter() {
            return "CamelAwsS3Delimiter";
        }
    }

    public static interface AWS2S3Builders {
        default public AWS2S3HeaderNameBuilder aws2S3() {
            return AWS2S3HeaderNameBuilder.INSTANCE;
        }

        default public AWS2S3EndpointBuilder aws2S3(String path) {
            return AWS2S3EndpointBuilderFactory.endpointBuilder("aws2-s3", path);
        }

        default public AWS2S3EndpointBuilder aws2S3(String componentName, String path) {
            return AWS2S3EndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    public static interface AdvancedAWS2S3EndpointBuilder
    extends AdvancedAWS2S3EndpointConsumerBuilder,
    AdvancedAWS2S3EndpointProducerBuilder {
        @Override
        default public AWS2S3EndpointBuilder basic() {
            return (AWS2S3EndpointBuilder)((Object)this);
        }

        @Override
        default public AdvancedAWS2S3EndpointBuilder customerAlgorithm(String customerAlgorithm) {
            this.doSetProperty("customerAlgorithm", customerAlgorithm);
            return this;
        }

        @Override
        default public AdvancedAWS2S3EndpointBuilder customerKeyId(String customerKeyId) {
            this.doSetProperty("customerKeyId", customerKeyId);
            return this;
        }

        @Override
        default public AdvancedAWS2S3EndpointBuilder customerKeyMD5(String customerKeyMD5) {
            this.doSetProperty("customerKeyMD5", customerKeyMD5);
            return this;
        }

        @Override
        default public AdvancedAWS2S3EndpointBuilder amazonS3Client(S3Client amazonS3Client) {
            this.doSetProperty("amazonS3Client", amazonS3Client);
            return this;
        }

        @Override
        default public AdvancedAWS2S3EndpointBuilder amazonS3Client(String amazonS3Client) {
            this.doSetProperty("amazonS3Client", amazonS3Client);
            return this;
        }

        @Override
        default public AdvancedAWS2S3EndpointBuilder amazonS3Presigner(S3Presigner amazonS3Presigner) {
            this.doSetProperty("amazonS3Presigner", amazonS3Presigner);
            return this;
        }

        @Override
        default public AdvancedAWS2S3EndpointBuilder amazonS3Presigner(String amazonS3Presigner) {
            this.doSetProperty("amazonS3Presigner", amazonS3Presigner);
            return this;
        }
    }

    public static interface AWS2S3EndpointBuilder
    extends AWS2S3EndpointConsumerBuilder,
    AWS2S3EndpointProducerBuilder {
        @Override
        default public AdvancedAWS2S3EndpointBuilder advanced() {
            return (AdvancedAWS2S3EndpointBuilder)((Object)this);
        }

        @Override
        default public AWS2S3EndpointBuilder autoCreateBucket(boolean autoCreateBucket) {
            this.doSetProperty("autoCreateBucket", autoCreateBucket);
            return this;
        }

        @Override
        default public AWS2S3EndpointBuilder autoCreateBucket(String autoCreateBucket) {
            this.doSetProperty("autoCreateBucket", autoCreateBucket);
            return this;
        }

        @Override
        default public AWS2S3EndpointBuilder delimiter(String delimiter) {
            this.doSetProperty("delimiter", delimiter);
            return this;
        }

        @Override
        default public AWS2S3EndpointBuilder forcePathStyle(boolean forcePathStyle) {
            this.doSetProperty("forcePathStyle", forcePathStyle);
            return this;
        }

        @Override
        default public AWS2S3EndpointBuilder forcePathStyle(String forcePathStyle) {
            this.doSetProperty("forcePathStyle", forcePathStyle);
            return this;
        }

        @Override
        default public AWS2S3EndpointBuilder overrideEndpoint(boolean overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        @Override
        default public AWS2S3EndpointBuilder overrideEndpoint(String overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        @Override
        default public AWS2S3EndpointBuilder pojoRequest(boolean pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        @Override
        default public AWS2S3EndpointBuilder pojoRequest(String pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        @Override
        default public AWS2S3EndpointBuilder policy(String policy) {
            this.doSetProperty("policy", policy);
            return this;
        }

        @Override
        default public AWS2S3EndpointBuilder prefix(String prefix) {
            this.doSetProperty("prefix", prefix);
            return this;
        }

        @Override
        default public AWS2S3EndpointBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        @Override
        default public AWS2S3EndpointBuilder uriEndpointOverride(String uriEndpointOverride) {
            this.doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }

        @Override
        default public AWS2S3EndpointBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        @Override
        default public AWS2S3EndpointBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        @Override
        default public AWS2S3EndpointBuilder proxyPort(String proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        @Override
        default public AWS2S3EndpointBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        @Override
        default public AWS2S3EndpointBuilder proxyProtocol(String proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        @Override
        default public AWS2S3EndpointBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        @Override
        default public AWS2S3EndpointBuilder profileCredentialsName(String profileCredentialsName) {
            this.doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }

        @Override
        default public AWS2S3EndpointBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }

        @Override
        default public AWS2S3EndpointBuilder trustAllCertificates(boolean trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        @Override
        default public AWS2S3EndpointBuilder trustAllCertificates(String trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        @Override
        default public AWS2S3EndpointBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        @Override
        default public AWS2S3EndpointBuilder useDefaultCredentialsProvider(String useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        @Override
        default public AWS2S3EndpointBuilder useProfileCredentialsProvider(boolean useProfileCredentialsProvider) {
            this.doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }

        @Override
        default public AWS2S3EndpointBuilder useProfileCredentialsProvider(String useProfileCredentialsProvider) {
            this.doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }
    }

    public static interface AdvancedAWS2S3EndpointProducerBuilder
    extends EndpointProducerBuilder {
        default public AWS2S3EndpointProducerBuilder basic() {
            return (AWS2S3EndpointProducerBuilder)((Object)this);
        }

        default public AdvancedAWS2S3EndpointProducerBuilder customerAlgorithm(String customerAlgorithm) {
            this.doSetProperty("customerAlgorithm", customerAlgorithm);
            return this;
        }

        default public AdvancedAWS2S3EndpointProducerBuilder customerKeyId(String customerKeyId) {
            this.doSetProperty("customerKeyId", customerKeyId);
            return this;
        }

        default public AdvancedAWS2S3EndpointProducerBuilder customerKeyMD5(String customerKeyMD5) {
            this.doSetProperty("customerKeyMD5", customerKeyMD5);
            return this;
        }

        default public AdvancedAWS2S3EndpointProducerBuilder awsKMSKeyId(String awsKMSKeyId) {
            this.doSetProperty("awsKMSKeyId", awsKMSKeyId);
            return this;
        }

        default public AdvancedAWS2S3EndpointProducerBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AdvancedAWS2S3EndpointProducerBuilder lazyStartProducer(String lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AdvancedAWS2S3EndpointProducerBuilder useAwsKMS(boolean useAwsKMS) {
            this.doSetProperty("useAwsKMS", useAwsKMS);
            return this;
        }

        default public AdvancedAWS2S3EndpointProducerBuilder useAwsKMS(String useAwsKMS) {
            this.doSetProperty("useAwsKMS", useAwsKMS);
            return this;
        }

        default public AdvancedAWS2S3EndpointProducerBuilder useCustomerKey(boolean useCustomerKey) {
            this.doSetProperty("useCustomerKey", useCustomerKey);
            return this;
        }

        default public AdvancedAWS2S3EndpointProducerBuilder useCustomerKey(String useCustomerKey) {
            this.doSetProperty("useCustomerKey", useCustomerKey);
            return this;
        }

        default public AdvancedAWS2S3EndpointProducerBuilder useSSES3(boolean useSSES3) {
            this.doSetProperty("useSSES3", useSSES3);
            return this;
        }

        default public AdvancedAWS2S3EndpointProducerBuilder useSSES3(String useSSES3) {
            this.doSetProperty("useSSES3", useSSES3);
            return this;
        }

        default public AdvancedAWS2S3EndpointProducerBuilder amazonS3Client(S3Client amazonS3Client) {
            this.doSetProperty("amazonS3Client", amazonS3Client);
            return this;
        }

        default public AdvancedAWS2S3EndpointProducerBuilder amazonS3Client(String amazonS3Client) {
            this.doSetProperty("amazonS3Client", amazonS3Client);
            return this;
        }

        default public AdvancedAWS2S3EndpointProducerBuilder amazonS3Presigner(S3Presigner amazonS3Presigner) {
            this.doSetProperty("amazonS3Presigner", amazonS3Presigner);
            return this;
        }

        default public AdvancedAWS2S3EndpointProducerBuilder amazonS3Presigner(String amazonS3Presigner) {
            this.doSetProperty("amazonS3Presigner", amazonS3Presigner);
            return this;
        }
    }

    public static interface AWS2S3EndpointProducerBuilder
    extends EndpointProducerBuilder {
        default public AdvancedAWS2S3EndpointProducerBuilder advanced() {
            return (AdvancedAWS2S3EndpointProducerBuilder)((Object)this);
        }

        default public AWS2S3EndpointProducerBuilder autoCreateBucket(boolean autoCreateBucket) {
            this.doSetProperty("autoCreateBucket", autoCreateBucket);
            return this;
        }

        default public AWS2S3EndpointProducerBuilder autoCreateBucket(String autoCreateBucket) {
            this.doSetProperty("autoCreateBucket", autoCreateBucket);
            return this;
        }

        default public AWS2S3EndpointProducerBuilder delimiter(String delimiter) {
            this.doSetProperty("delimiter", delimiter);
            return this;
        }

        default public AWS2S3EndpointProducerBuilder forcePathStyle(boolean forcePathStyle) {
            this.doSetProperty("forcePathStyle", forcePathStyle);
            return this;
        }

        default public AWS2S3EndpointProducerBuilder forcePathStyle(String forcePathStyle) {
            this.doSetProperty("forcePathStyle", forcePathStyle);
            return this;
        }

        default public AWS2S3EndpointProducerBuilder overrideEndpoint(boolean overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        default public AWS2S3EndpointProducerBuilder overrideEndpoint(String overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        default public AWS2S3EndpointProducerBuilder pojoRequest(boolean pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public AWS2S3EndpointProducerBuilder pojoRequest(String pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public AWS2S3EndpointProducerBuilder policy(String policy) {
            this.doSetProperty("policy", policy);
            return this;
        }

        default public AWS2S3EndpointProducerBuilder prefix(String prefix) {
            this.doSetProperty("prefix", prefix);
            return this;
        }

        default public AWS2S3EndpointProducerBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public AWS2S3EndpointProducerBuilder uriEndpointOverride(String uriEndpointOverride) {
            this.doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }

        default public AWS2S3EndpointProducerBuilder batchMessageNumber(int batchMessageNumber) {
            this.doSetProperty("batchMessageNumber", batchMessageNumber);
            return this;
        }

        default public AWS2S3EndpointProducerBuilder batchMessageNumber(String batchMessageNumber) {
            this.doSetProperty("batchMessageNumber", batchMessageNumber);
            return this;
        }

        default public AWS2S3EndpointProducerBuilder batchSize(int batchSize) {
            this.doSetProperty("batchSize", batchSize);
            return this;
        }

        default public AWS2S3EndpointProducerBuilder batchSize(String batchSize) {
            this.doSetProperty("batchSize", batchSize);
            return this;
        }

        default public AWS2S3EndpointProducerBuilder deleteAfterWrite(boolean deleteAfterWrite) {
            this.doSetProperty("deleteAfterWrite", deleteAfterWrite);
            return this;
        }

        default public AWS2S3EndpointProducerBuilder deleteAfterWrite(String deleteAfterWrite) {
            this.doSetProperty("deleteAfterWrite", deleteAfterWrite);
            return this;
        }

        default public AWS2S3EndpointProducerBuilder keyName(String keyName) {
            this.doSetProperty("keyName", keyName);
            return this;
        }

        default public AWS2S3EndpointProducerBuilder multiPartUpload(boolean multiPartUpload) {
            this.doSetProperty("multiPartUpload", multiPartUpload);
            return this;
        }

        default public AWS2S3EndpointProducerBuilder multiPartUpload(String multiPartUpload) {
            this.doSetProperty("multiPartUpload", multiPartUpload);
            return this;
        }

        default public AWS2S3EndpointProducerBuilder namingStrategy(AWSS3NamingStrategyEnum namingStrategy) {
            this.doSetProperty("namingStrategy", namingStrategy);
            return this;
        }

        default public AWS2S3EndpointProducerBuilder namingStrategy(String namingStrategy) {
            this.doSetProperty("namingStrategy", namingStrategy);
            return this;
        }

        default public AWS2S3EndpointProducerBuilder operation(AWS2S3Operations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public AWS2S3EndpointProducerBuilder operation(String operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public AWS2S3EndpointProducerBuilder partSize(long partSize) {
            this.doSetProperty("partSize", partSize);
            return this;
        }

        default public AWS2S3EndpointProducerBuilder partSize(String partSize) {
            this.doSetProperty("partSize", partSize);
            return this;
        }

        default public AWS2S3EndpointProducerBuilder restartingPolicy(AWSS3RestartingPolicyEnum restartingPolicy) {
            this.doSetProperty("restartingPolicy", restartingPolicy);
            return this;
        }

        default public AWS2S3EndpointProducerBuilder restartingPolicy(String restartingPolicy) {
            this.doSetProperty("restartingPolicy", restartingPolicy);
            return this;
        }

        default public AWS2S3EndpointProducerBuilder storageClass(String storageClass) {
            this.doSetProperty("storageClass", storageClass);
            return this;
        }

        default public AWS2S3EndpointProducerBuilder streamingUploadMode(boolean streamingUploadMode) {
            this.doSetProperty("streamingUploadMode", streamingUploadMode);
            return this;
        }

        default public AWS2S3EndpointProducerBuilder streamingUploadMode(String streamingUploadMode) {
            this.doSetProperty("streamingUploadMode", streamingUploadMode);
            return this;
        }

        default public AWS2S3EndpointProducerBuilder streamingUploadTimeout(long streamingUploadTimeout) {
            this.doSetProperty("streamingUploadTimeout", streamingUploadTimeout);
            return this;
        }

        default public AWS2S3EndpointProducerBuilder streamingUploadTimeout(String streamingUploadTimeout) {
            this.doSetProperty("streamingUploadTimeout", streamingUploadTimeout);
            return this;
        }

        default public AWS2S3EndpointProducerBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public AWS2S3EndpointProducerBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public AWS2S3EndpointProducerBuilder proxyPort(String proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public AWS2S3EndpointProducerBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public AWS2S3EndpointProducerBuilder proxyProtocol(String proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public AWS2S3EndpointProducerBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public AWS2S3EndpointProducerBuilder profileCredentialsName(String profileCredentialsName) {
            this.doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }

        default public AWS2S3EndpointProducerBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }

        default public AWS2S3EndpointProducerBuilder trustAllCertificates(boolean trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public AWS2S3EndpointProducerBuilder trustAllCertificates(String trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public AWS2S3EndpointProducerBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public AWS2S3EndpointProducerBuilder useDefaultCredentialsProvider(String useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public AWS2S3EndpointProducerBuilder useProfileCredentialsProvider(boolean useProfileCredentialsProvider) {
            this.doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }

        default public AWS2S3EndpointProducerBuilder useProfileCredentialsProvider(String useProfileCredentialsProvider) {
            this.doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }
    }

    public static interface AdvancedAWS2S3EndpointConsumerBuilder
    extends EndpointConsumerBuilder {
        default public AWS2S3EndpointConsumerBuilder basic() {
            return (AWS2S3EndpointConsumerBuilder)((Object)this);
        }

        default public AdvancedAWS2S3EndpointConsumerBuilder customerAlgorithm(String customerAlgorithm) {
            this.doSetProperty("customerAlgorithm", customerAlgorithm);
            return this;
        }

        default public AdvancedAWS2S3EndpointConsumerBuilder customerKeyId(String customerKeyId) {
            this.doSetProperty("customerKeyId", customerKeyId);
            return this;
        }

        default public AdvancedAWS2S3EndpointConsumerBuilder customerKeyMD5(String customerKeyMD5) {
            this.doSetProperty("customerKeyMD5", customerKeyMD5);
            return this;
        }

        default public AdvancedAWS2S3EndpointConsumerBuilder autocloseBody(boolean autocloseBody) {
            this.doSetProperty("autocloseBody", autocloseBody);
            return this;
        }

        default public AdvancedAWS2S3EndpointConsumerBuilder autocloseBody(String autocloseBody) {
            this.doSetProperty("autocloseBody", autocloseBody);
            return this;
        }

        default public AdvancedAWS2S3EndpointConsumerBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public AdvancedAWS2S3EndpointConsumerBuilder bridgeErrorHandler(String bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public AdvancedAWS2S3EndpointConsumerBuilder exceptionHandler(ExceptionHandler exceptionHandler) {
            this.doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }

        default public AdvancedAWS2S3EndpointConsumerBuilder exceptionHandler(String exceptionHandler) {
            this.doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }

        default public AdvancedAWS2S3EndpointConsumerBuilder exchangePattern(ExchangePattern exchangePattern) {
            this.doSetProperty("exchangePattern", exchangePattern);
            return this;
        }

        default public AdvancedAWS2S3EndpointConsumerBuilder exchangePattern(String exchangePattern) {
            this.doSetProperty("exchangePattern", exchangePattern);
            return this;
        }

        default public AdvancedAWS2S3EndpointConsumerBuilder pollStrategy(PollingConsumerPollStrategy pollStrategy) {
            this.doSetProperty("pollStrategy", pollStrategy);
            return this;
        }

        default public AdvancedAWS2S3EndpointConsumerBuilder pollStrategy(String pollStrategy) {
            this.doSetProperty("pollStrategy", pollStrategy);
            return this;
        }

        default public AdvancedAWS2S3EndpointConsumerBuilder amazonS3Client(S3Client amazonS3Client) {
            this.doSetProperty("amazonS3Client", amazonS3Client);
            return this;
        }

        default public AdvancedAWS2S3EndpointConsumerBuilder amazonS3Client(String amazonS3Client) {
            this.doSetProperty("amazonS3Client", amazonS3Client);
            return this;
        }

        default public AdvancedAWS2S3EndpointConsumerBuilder amazonS3Presigner(S3Presigner amazonS3Presigner) {
            this.doSetProperty("amazonS3Presigner", amazonS3Presigner);
            return this;
        }

        default public AdvancedAWS2S3EndpointConsumerBuilder amazonS3Presigner(String amazonS3Presigner) {
            this.doSetProperty("amazonS3Presigner", amazonS3Presigner);
            return this;
        }
    }

    public static interface AWS2S3EndpointConsumerBuilder
    extends EndpointConsumerBuilder {
        default public AdvancedAWS2S3EndpointConsumerBuilder advanced() {
            return (AdvancedAWS2S3EndpointConsumerBuilder)((Object)this);
        }

        default public AWS2S3EndpointConsumerBuilder autoCreateBucket(boolean autoCreateBucket) {
            this.doSetProperty("autoCreateBucket", autoCreateBucket);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder autoCreateBucket(String autoCreateBucket) {
            this.doSetProperty("autoCreateBucket", autoCreateBucket);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder delimiter(String delimiter) {
            this.doSetProperty("delimiter", delimiter);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder forcePathStyle(boolean forcePathStyle) {
            this.doSetProperty("forcePathStyle", forcePathStyle);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder forcePathStyle(String forcePathStyle) {
            this.doSetProperty("forcePathStyle", forcePathStyle);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder overrideEndpoint(boolean overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder overrideEndpoint(String overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder pojoRequest(boolean pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder pojoRequest(String pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder policy(String policy) {
            this.doSetProperty("policy", policy);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder prefix(String prefix) {
            this.doSetProperty("prefix", prefix);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder uriEndpointOverride(String uriEndpointOverride) {
            this.doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder deleteAfterRead(boolean deleteAfterRead) {
            this.doSetProperty("deleteAfterRead", deleteAfterRead);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder deleteAfterRead(String deleteAfterRead) {
            this.doSetProperty("deleteAfterRead", deleteAfterRead);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder destinationBucket(String destinationBucket) {
            this.doSetProperty("destinationBucket", destinationBucket);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder destinationBucketPrefix(String destinationBucketPrefix) {
            this.doSetProperty("destinationBucketPrefix", destinationBucketPrefix);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder destinationBucketSuffix(String destinationBucketSuffix) {
            this.doSetProperty("destinationBucketSuffix", destinationBucketSuffix);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder doneFileName(String doneFileName) {
            this.doSetProperty("doneFileName", doneFileName);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder fileName(String fileName) {
            this.doSetProperty("fileName", fileName);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder ignoreBody(boolean ignoreBody) {
            this.doSetProperty("ignoreBody", ignoreBody);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder ignoreBody(String ignoreBody) {
            this.doSetProperty("ignoreBody", ignoreBody);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder includeBody(boolean includeBody) {
            this.doSetProperty("includeBody", includeBody);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder includeBody(String includeBody) {
            this.doSetProperty("includeBody", includeBody);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder includeFolders(boolean includeFolders) {
            this.doSetProperty("includeFolders", includeFolders);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder includeFolders(String includeFolders) {
            this.doSetProperty("includeFolders", includeFolders);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder maxConnections(int maxConnections) {
            this.doSetProperty("maxConnections", maxConnections);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder maxConnections(String maxConnections) {
            this.doSetProperty("maxConnections", maxConnections);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder maxMessagesPerPoll(int maxMessagesPerPoll) {
            this.doSetProperty("maxMessagesPerPoll", maxMessagesPerPoll);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder maxMessagesPerPoll(String maxMessagesPerPoll) {
            this.doSetProperty("maxMessagesPerPoll", maxMessagesPerPoll);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder moveAfterRead(boolean moveAfterRead) {
            this.doSetProperty("moveAfterRead", moveAfterRead);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder moveAfterRead(String moveAfterRead) {
            this.doSetProperty("moveAfterRead", moveAfterRead);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder sendEmptyMessageWhenIdle(boolean sendEmptyMessageWhenIdle) {
            this.doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder sendEmptyMessageWhenIdle(String sendEmptyMessageWhenIdle) {
            this.doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder proxyPort(String proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder proxyProtocol(String proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder backoffErrorThreshold(int backoffErrorThreshold) {
            this.doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder backoffErrorThreshold(String backoffErrorThreshold) {
            this.doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder backoffIdleThreshold(int backoffIdleThreshold) {
            this.doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder backoffIdleThreshold(String backoffIdleThreshold) {
            this.doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder backoffMultiplier(int backoffMultiplier) {
            this.doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder backoffMultiplier(String backoffMultiplier) {
            this.doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder delay(long delay) {
            this.doSetProperty("delay", delay);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder delay(String delay) {
            this.doSetProperty("delay", delay);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder greedy(boolean greedy) {
            this.doSetProperty("greedy", greedy);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder greedy(String greedy) {
            this.doSetProperty("greedy", greedy);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder initialDelay(long initialDelay) {
            this.doSetProperty("initialDelay", initialDelay);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder initialDelay(String initialDelay) {
            this.doSetProperty("initialDelay", initialDelay);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder repeatCount(long repeatCount) {
            this.doSetProperty("repeatCount", repeatCount);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder repeatCount(String repeatCount) {
            this.doSetProperty("repeatCount", repeatCount);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder runLoggingLevel(LoggingLevel runLoggingLevel) {
            this.doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder runLoggingLevel(String runLoggingLevel) {
            this.doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
            this.doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder scheduledExecutorService(String scheduledExecutorService) {
            this.doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder scheduler(Object scheduler) {
            this.doSetProperty("scheduler", scheduler);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder scheduler(String scheduler) {
            this.doSetProperty("scheduler", scheduler);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder schedulerProperties(String key, Object value) {
            this.doSetMultiValueProperty("schedulerProperties", "scheduler." + key, value);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder schedulerProperties(Map values) {
            this.doSetMultiValueProperties("schedulerProperties", "scheduler.", values);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder startScheduler(boolean startScheduler) {
            this.doSetProperty("startScheduler", startScheduler);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder startScheduler(String startScheduler) {
            this.doSetProperty("startScheduler", startScheduler);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            this.doSetProperty("timeUnit", (Object)timeUnit);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder timeUnit(String timeUnit) {
            this.doSetProperty("timeUnit", timeUnit);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder useFixedDelay(boolean useFixedDelay) {
            this.doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder useFixedDelay(String useFixedDelay) {
            this.doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder profileCredentialsName(String profileCredentialsName) {
            this.doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder trustAllCertificates(boolean trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder trustAllCertificates(String trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder useDefaultCredentialsProvider(String useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder useProfileCredentialsProvider(boolean useProfileCredentialsProvider) {
            this.doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }

        default public AWS2S3EndpointConsumerBuilder useProfileCredentialsProvider(String useProfileCredentialsProvider) {
            this.doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }
    }
}

