/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.endpoint.dsl;

import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.component.aws2.timestream.Timestream2Operations;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.timestreamquery.TimestreamQueryClient;
import software.amazon.awssdk.services.timestreamwrite.TimestreamWriteClient;

public interface Timestream2EndpointBuilderFactory {
    public static Timestream2EndpointBuilder endpointBuilder(String componentName, String path) {
        class Timestream2EndpointBuilderImpl
        extends AbstractEndpointBuilder
        implements Timestream2EndpointBuilder,
        AdvancedTimestream2EndpointBuilder {
            final /* synthetic */ String val$componentName;

            public Timestream2EndpointBuilderImpl(String path, String string) {
                this.val$componentName = string;
                super(string, path);
            }
        }
        return new Timestream2EndpointBuilderImpl(path, componentName);
    }

    public static class Timestream2HeaderNameBuilder {
        private static final Timestream2HeaderNameBuilder INSTANCE = new Timestream2HeaderNameBuilder();

        public String awsTimestreamOperation() {
            return "AwsTimestreamOperation";
        }

        public String awsTimestreamRecord() {
            return "AwsTimestreamRecord";
        }

        public String awsTimestreamRecordList() {
            return "AwsTimestreamRecordList";
        }

        public String awsTimestreamTaskStatus() {
            return "AwsTimestreamTaskStatus";
        }

        public String awsTimestreamTaskId() {
            return "AwsTimestreamTaskId";
        }

        public String awsTimestreamDatabaseName() {
            return "AwsTimestreamDatabaseName";
        }

        public String awsTimestreamTableName() {
            return "AwsTimestreamTableName";
        }

        public String awsTimestreamTargetDatabaseName() {
            return "AwsTimestreamTargetDatabaseName";
        }

        public String awsTimestreamTargetTableName() {
            return "AwsTimestreamTargetTableName";
        }

        public String awsTimestreamRecordVersion() {
            return "AwsTimestreamRecordVersion";
        }

        public String awsTimestreamDataModelConfiguration() {
            return "AwsTimestreamDataModelConfiguration";
        }

        public String awsTimestreamDataSourceConfiguration() {
            return "AwsTimestreamDataSourceConfiguration";
        }

        public String awsTimestreamReportConfiguration() {
            return "AwsTimestreamReportConfiguration";
        }

        public String awsTimestreamTableSchema() {
            return "AwsTimestreamTableSchema";
        }

        public String awsTimestreamRetentionProperties() {
            return "AwsTimestreamRetentionProperties";
        }

        public String awsTimestreamMagneticStoreWriteProperties() {
            return "AwsTimestreamMagneticStoreWriteProperties";
        }

        public String awsTimestreamTimeColumn() {
            return "AwsTimestreamTimeColumn";
        }

        public String awsTimestreamMeasureColumnName() {
            return "AwsTimestreamMeasureColumnName";
        }

        public String awsTimestreamDimensionMappingList() {
            return "AwsTimestreamDimensionMappingList";
        }

        public String awsTimestreamMultiMeasureMappings() {
            return "AwsTimestreamMultiMeasureMappings";
        }

        public String awsTimestreamMixedMeasureMappingList() {
            return "AwsTimestreamMixedMeasureMappingList";
        }

        public String awsTimestreamScheduledQueryName() {
            return "AwsTimestreamScheduledQueryName";
        }

        public String awsTimestreamScheduledQueryArn() {
            return "AwsTimestreamScheduledQueryArn";
        }

        public String awsTimestreamScheduledQueryState() {
            return "AwsTimestreamScheduledQueryState";
        }

        public String awsTimestreamScheduledQueryInvocationTime() {
            return "AwsTimestreamScheduledQueryInvocationTime";
        }

        public String awsTimestreamQueryString() {
            return "AwsTimestreamQueryString";
        }

        public String awsTimestreamQueryId() {
            return "AwsTimestreamQueryId";
        }

        public String awsTimestreamQueryValidateOnly() {
            return "AwsTimestreamQueryValidateOnly";
        }

        public String awsTimestreamQueryMaxRows() {
            return "AwsTimestreamQueryMaxRows";
        }

        public String awsTimestreamMaxResults() {
            return "AwsTimestreamMaxResults";
        }

        public String awsTimestreamScheduleExpression() {
            return "AwsTimestreamScheduleExpression";
        }

        public String awsTimestreamNotificationTopicArn() {
            return "AwsTimestreamNotificationTopicArn";
        }

        public String awsTimestreamErrorReportS3BucketName() {
            return "AwsTimestreamErrorReportS3BucketName";
        }

        public String awsTimestreamErrorReportS3ObjectKeyPrefix() {
            return "AwsTimestreamErrorReportS3ObjectKeyPrefix";
        }

        public String awsTimestreamErrorReportS3EncryptionOption() {
            return "AwsTimestreamErrorReportS3EncryptionOption";
        }

        public String awsTimestreamScheduledQueryExecutionRoleArn() {
            return "AwsTimestreamScheduledQueryExecutionRoleArn";
        }

        public String awsTimestreamClientToken() {
            return "AwsTimestreamClientToken";
        }

        public String awsTimestreamKmsKeyId() {
            return "AwsTimestreamKmsKeyId";
        }
    }

    public static interface Timestream2Builders {
        default public Timestream2HeaderNameBuilder aws2Timestream() {
            return Timestream2HeaderNameBuilder.INSTANCE;
        }

        default public Timestream2EndpointBuilder aws2Timestream(String path) {
            return Timestream2EndpointBuilderFactory.endpointBuilder("aws2-timestream", path);
        }

        default public Timestream2EndpointBuilder aws2Timestream(String componentName, String path) {
            return Timestream2EndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    public static interface AdvancedTimestream2EndpointBuilder
    extends EndpointProducerBuilder {
        default public Timestream2EndpointBuilder basic() {
            return (Timestream2EndpointBuilder)((Object)this);
        }

        default public AdvancedTimestream2EndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AdvancedTimestream2EndpointBuilder lazyStartProducer(String lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AdvancedTimestream2EndpointBuilder awsTimestreamQueryClient(TimestreamQueryClient awsTimestreamQueryClient) {
            this.doSetProperty("awsTimestreamQueryClient", awsTimestreamQueryClient);
            return this;
        }

        default public AdvancedTimestream2EndpointBuilder awsTimestreamQueryClient(String awsTimestreamQueryClient) {
            this.doSetProperty("awsTimestreamQueryClient", awsTimestreamQueryClient);
            return this;
        }

        default public AdvancedTimestream2EndpointBuilder awsTimestreamWriteClient(TimestreamWriteClient awsTimestreamWriteClient) {
            this.doSetProperty("awsTimestreamWriteClient", awsTimestreamWriteClient);
            return this;
        }

        default public AdvancedTimestream2EndpointBuilder awsTimestreamWriteClient(String awsTimestreamWriteClient) {
            this.doSetProperty("awsTimestreamWriteClient", awsTimestreamWriteClient);
            return this;
        }
    }

    public static interface Timestream2EndpointBuilder
    extends EndpointProducerBuilder {
        default public AdvancedTimestream2EndpointBuilder advanced() {
            return (AdvancedTimestream2EndpointBuilder)((Object)this);
        }

        default public Timestream2EndpointBuilder operation(Timestream2Operations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public Timestream2EndpointBuilder operation(String operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public Timestream2EndpointBuilder overrideEndpoint(boolean overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        default public Timestream2EndpointBuilder overrideEndpoint(String overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        default public Timestream2EndpointBuilder pojoRequest(boolean pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public Timestream2EndpointBuilder pojoRequest(String pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public Timestream2EndpointBuilder profileCredentialsName(String profileCredentialsName) {
            this.doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }

        default public Timestream2EndpointBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public Timestream2EndpointBuilder trustAllCertificates(boolean trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public Timestream2EndpointBuilder trustAllCertificates(String trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public Timestream2EndpointBuilder uriEndpointOverride(String uriEndpointOverride) {
            this.doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }

        default public Timestream2EndpointBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public Timestream2EndpointBuilder useDefaultCredentialsProvider(String useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public Timestream2EndpointBuilder useProfileCredentialsProvider(boolean useProfileCredentialsProvider) {
            this.doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }

        default public Timestream2EndpointBuilder useProfileCredentialsProvider(String useProfileCredentialsProvider) {
            this.doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }

        default public Timestream2EndpointBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public Timestream2EndpointBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public Timestream2EndpointBuilder proxyPort(String proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public Timestream2EndpointBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public Timestream2EndpointBuilder proxyProtocol(String proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public Timestream2EndpointBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public Timestream2EndpointBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }
    }
}

