/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * SMB component which consumes natively from file shares using the Server
 * Message Block (SMB, also known as Common Internet File System - CIFS)
 * protocol
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface SmbEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the SMB component.
     */
    public interface SmbEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedSmbEndpointConsumerBuilder advanced() {
            return (AdvancedSmbEndpointConsumerBuilder) this;
        }
        /**
         * The user domain.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param domain the value to set
         * @return the dsl builder
         */
        default SmbEndpointConsumerBuilder domain(String domain) {
            doSetProperty("domain", domain);
            return this;
        }
        /**
         * The password to access the share.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default SmbEndpointConsumerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * The path, within the share, to consume the files from.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Required: true
         * Group: common
         * 
         * @param path the value to set
         * @return the dsl builder
         */
        default SmbEndpointConsumerBuilder path(String path) {
            doSetProperty("path", path);
            return this;
        }
        /**
         * The search pattern used to list the files.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: *.txt
         * Group: common
         * 
         * @param searchPattern the value to set
         * @return the dsl builder
         */
        default SmbEndpointConsumerBuilder searchPattern(String searchPattern) {
            doSetProperty("searchPattern", searchPattern);
            return this;
        }
        /**
         * An optional SMB I/O bean to use to setup the file access attributes
         * when reading/writing a file.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.smb.SmbIOBean&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param smbIoBean the value to set
         * @return the dsl builder
         */
        default SmbEndpointConsumerBuilder smbIoBean(
                org.apache.camel.component.smb.SmbIOBean smbIoBean) {
            doSetProperty("smbIoBean", smbIoBean);
            return this;
        }
        /**
         * An optional SMB I/O bean to use to setup the file access attributes
         * when reading/writing a file.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.smb.SmbIOBean&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param smbIoBean the value to set
         * @return the dsl builder
         */
        default SmbEndpointConsumerBuilder smbIoBean(String smbIoBean) {
            doSetProperty("smbIoBean", smbIoBean);
            return this;
        }
        /**
         * The username required to access the share.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default SmbEndpointConsumerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
        /**
         * A pluggable repository org.apache.camel.spi.IdempotentRepository
         * which by default use MemoryIdempotentRepository if none is specified
         * and idempotent is true.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.IdempotentRepository&lt;/code&gt;
         * type.
         * 
         * Group: consumer
         * 
         * @param idempotentRepository the value to set
         * @return the dsl builder
         */
        default SmbEndpointConsumerBuilder idempotentRepository(
                org.apache.camel.spi.IdempotentRepository idempotentRepository) {
            doSetProperty("idempotentRepository", idempotentRepository);
            return this;
        }
        /**
         * A pluggable repository org.apache.camel.spi.IdempotentRepository
         * which by default use MemoryIdempotentRepository if none is specified
         * and idempotent is true.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.IdempotentRepository&lt;/code&gt;
         * type.
         * 
         * Group: consumer
         * 
         * @param idempotentRepository the value to set
         * @return the dsl builder
         */
        default SmbEndpointConsumerBuilder idempotentRepository(
                String idempotentRepository) {
            doSetProperty("idempotentRepository", idempotentRepository);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the SMB component.
     */
    public interface AdvancedSmbEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default SmbEndpointConsumerBuilder basic() {
            return (SmbEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedSmbEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedSmbEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedSmbEndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedSmbEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedSmbEndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedSmbEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the SMB component.
     */
    public interface SmbEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedSmbEndpointProducerBuilder advanced() {
            return (AdvancedSmbEndpointProducerBuilder) this;
        }
        /**
         * The user domain.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param domain the value to set
         * @return the dsl builder
         */
        default SmbEndpointProducerBuilder domain(String domain) {
            doSetProperty("domain", domain);
            return this;
        }
        /**
         * The password to access the share.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default SmbEndpointProducerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * The path, within the share, to consume the files from.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Required: true
         * Group: common
         * 
         * @param path the value to set
         * @return the dsl builder
         */
        default SmbEndpointProducerBuilder path(String path) {
            doSetProperty("path", path);
            return this;
        }
        /**
         * The search pattern used to list the files.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: *.txt
         * Group: common
         * 
         * @param searchPattern the value to set
         * @return the dsl builder
         */
        default SmbEndpointProducerBuilder searchPattern(String searchPattern) {
            doSetProperty("searchPattern", searchPattern);
            return this;
        }
        /**
         * An optional SMB I/O bean to use to setup the file access attributes
         * when reading/writing a file.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.smb.SmbIOBean&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param smbIoBean the value to set
         * @return the dsl builder
         */
        default SmbEndpointProducerBuilder smbIoBean(
                org.apache.camel.component.smb.SmbIOBean smbIoBean) {
            doSetProperty("smbIoBean", smbIoBean);
            return this;
        }
        /**
         * An optional SMB I/O bean to use to setup the file access attributes
         * when reading/writing a file.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.smb.SmbIOBean&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param smbIoBean the value to set
         * @return the dsl builder
         */
        default SmbEndpointProducerBuilder smbIoBean(String smbIoBean) {
            doSetProperty("smbIoBean", smbIoBean);
            return this;
        }
        /**
         * The username required to access the share.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default SmbEndpointProducerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the SMB component.
     */
    public interface AdvancedSmbEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default SmbEndpointProducerBuilder basic() {
            return (SmbEndpointProducerBuilder) this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedSmbEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedSmbEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    /**
     * Builder for endpoint for the SMB component.
     */
    public interface SmbEndpointBuilder
            extends
                SmbEndpointConsumerBuilder,
                SmbEndpointProducerBuilder {
        default AdvancedSmbEndpointBuilder advanced() {
            return (AdvancedSmbEndpointBuilder) this;
        }
        /**
         * The user domain.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param domain the value to set
         * @return the dsl builder
         */
        default SmbEndpointBuilder domain(String domain) {
            doSetProperty("domain", domain);
            return this;
        }
        /**
         * The password to access the share.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default SmbEndpointBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * The path, within the share, to consume the files from.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Required: true
         * Group: common
         * 
         * @param path the value to set
         * @return the dsl builder
         */
        default SmbEndpointBuilder path(String path) {
            doSetProperty("path", path);
            return this;
        }
        /**
         * The search pattern used to list the files.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: *.txt
         * Group: common
         * 
         * @param searchPattern the value to set
         * @return the dsl builder
         */
        default SmbEndpointBuilder searchPattern(String searchPattern) {
            doSetProperty("searchPattern", searchPattern);
            return this;
        }
        /**
         * An optional SMB I/O bean to use to setup the file access attributes
         * when reading/writing a file.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.smb.SmbIOBean&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param smbIoBean the value to set
         * @return the dsl builder
         */
        default SmbEndpointBuilder smbIoBean(
                org.apache.camel.component.smb.SmbIOBean smbIoBean) {
            doSetProperty("smbIoBean", smbIoBean);
            return this;
        }
        /**
         * An optional SMB I/O bean to use to setup the file access attributes
         * when reading/writing a file.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.smb.SmbIOBean&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param smbIoBean the value to set
         * @return the dsl builder
         */
        default SmbEndpointBuilder smbIoBean(String smbIoBean) {
            doSetProperty("smbIoBean", smbIoBean);
            return this;
        }
        /**
         * The username required to access the share.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default SmbEndpointBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the SMB component.
     */
    public interface AdvancedSmbEndpointBuilder
            extends
                AdvancedSmbEndpointConsumerBuilder,
                AdvancedSmbEndpointProducerBuilder {
        default SmbEndpointBuilder basic() {
            return (SmbEndpointBuilder) this;
        }
    }

    public interface SmbBuilders {
        /**
         * SMB (camel-smb)
         * SMB component which consumes natively from file shares using the
         * Server Message Block (SMB, also known as Common Internet File System
         * - CIFS) protocol
         * 
         * Category: file
         * Since: 4.2.0-SNAPSHOT
         * Maven coordinates: org.apache.camel:camel-smb
         * 
         * Syntax: <code>smb:hostname:port</code>
         * 
         * Path parameter: hostname (required)
         * The share name or IP address
         * 
         * Path parameter: port
         * The share port
         * Default value: 445
         * 
         * Path parameter: shareName
         * The share path
         * 
         * @param path hostname:port
         * @return the dsl builder
         */
        default SmbEndpointBuilder smb(String path) {
            return SmbEndpointBuilderFactory.endpointBuilder("smb", path);
        }
        /**
         * SMB (camel-smb)
         * SMB component which consumes natively from file shares using the
         * Server Message Block (SMB, also known as Common Internet File System
         * - CIFS) protocol
         * 
         * Category: file
         * Since: 4.2.0-SNAPSHOT
         * Maven coordinates: org.apache.camel:camel-smb
         * 
         * Syntax: <code>smb:hostname:port</code>
         * 
         * Path parameter: hostname (required)
         * The share name or IP address
         * 
         * Path parameter: port
         * The share port
         * Default value: 445
         * 
         * Path parameter: shareName
         * The share path
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path hostname:port
         * @return the dsl builder
         */
        default SmbEndpointBuilder smb(String componentName, String path) {
            return SmbEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    static SmbEndpointBuilder endpointBuilder(String componentName, String path) {
        class SmbEndpointBuilderImpl extends AbstractEndpointBuilder implements SmbEndpointBuilder, AdvancedSmbEndpointBuilder {
            public SmbEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new SmbEndpointBuilderImpl(path);
    }
}