/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.endpoint.dsl;

import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.component.aws2.eks.EKS2Operations;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.eks.EksClient;

public interface EKS2EndpointBuilderFactory {
    public static EKS2EndpointBuilder endpointBuilder(String componentName, String path) {
        class EKS2EndpointBuilderImpl
        extends AbstractEndpointBuilder
        implements EKS2EndpointBuilder,
        AdvancedEKS2EndpointBuilder {
            final /* synthetic */ String val$componentName;

            public EKS2EndpointBuilderImpl(String path, String string) {
                this.val$componentName = string;
                super(string, path);
            }
        }
        return new EKS2EndpointBuilderImpl(path, componentName);
    }

    public static class EKS2HeaderNameBuilder {
        private static final EKS2HeaderNameBuilder INSTANCE = new EKS2HeaderNameBuilder();

        public String awsEKSOperation() {
            return "CamelAwsEKSOperation";
        }

        public String awsEKSMaxResults() {
            return "CamelAwsEKSMaxResults";
        }

        public String awsEKSDescription() {
            return "CamelAwsEKSDescription";
        }

        public String awsEKSClusterName() {
            return "CamelAwsEKSClusterName";
        }

        public String awsEKSRoleARN() {
            return "CamelAwsEKSRoleARN";
        }

        public String awsEKSVPCConfig() {
            return "CamelAwsEKSVPCConfig";
        }
    }

    public static interface EKS2Builders {
        default public EKS2HeaderNameBuilder aws2Eks() {
            return EKS2HeaderNameBuilder.INSTANCE;
        }

        default public EKS2EndpointBuilder aws2Eks(String path) {
            return EKS2EndpointBuilderFactory.endpointBuilder("aws2-eks", path);
        }

        default public EKS2EndpointBuilder aws2Eks(String componentName, String path) {
            return EKS2EndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    public static interface AdvancedEKS2EndpointBuilder
    extends EndpointProducerBuilder {
        default public EKS2EndpointBuilder basic() {
            return (EKS2EndpointBuilder)((Object)this);
        }

        default public AdvancedEKS2EndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AdvancedEKS2EndpointBuilder lazyStartProducer(String lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AdvancedEKS2EndpointBuilder eksClient(EksClient eksClient) {
            this.doSetProperty("eksClient", eksClient);
            return this;
        }

        default public AdvancedEKS2EndpointBuilder eksClient(String eksClient) {
            this.doSetProperty("eksClient", eksClient);
            return this;
        }
    }

    public static interface EKS2EndpointBuilder
    extends EndpointProducerBuilder {
        default public AdvancedEKS2EndpointBuilder advanced() {
            return (AdvancedEKS2EndpointBuilder)((Object)this);
        }

        default public EKS2EndpointBuilder operation(EKS2Operations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public EKS2EndpointBuilder operation(String operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public EKS2EndpointBuilder overrideEndpoint(boolean overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        default public EKS2EndpointBuilder overrideEndpoint(String overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        default public EKS2EndpointBuilder pojoRequest(boolean pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public EKS2EndpointBuilder pojoRequest(String pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public EKS2EndpointBuilder profileCredentialsName(String profileCredentialsName) {
            this.doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }

        default public EKS2EndpointBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public EKS2EndpointBuilder uriEndpointOverride(String uriEndpointOverride) {
            this.doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }

        default public EKS2EndpointBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public EKS2EndpointBuilder useDefaultCredentialsProvider(String useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public EKS2EndpointBuilder useProfileCredentialsProvider(boolean useProfileCredentialsProvider) {
            this.doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }

        default public EKS2EndpointBuilder useProfileCredentialsProvider(String useProfileCredentialsProvider) {
            this.doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }

        default public EKS2EndpointBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public EKS2EndpointBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public EKS2EndpointBuilder proxyPort(String proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public EKS2EndpointBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public EKS2EndpointBuilder proxyProtocol(String proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public EKS2EndpointBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public EKS2EndpointBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }

        default public EKS2EndpointBuilder trustAllCertificates(boolean trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public EKS2EndpointBuilder trustAllCertificates(String trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }
    }
}

