/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.endpoint.dsl;

import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.component.aws2.kms.KMS2Operations;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.kms.KmsClient;

public interface KMS2EndpointBuilderFactory {
    public static KMS2EndpointBuilder endpointBuilder(String componentName, String path) {
        class KMS2EndpointBuilderImpl
        extends AbstractEndpointBuilder
        implements KMS2EndpointBuilder,
        AdvancedKMS2EndpointBuilder {
            final /* synthetic */ String val$componentName;

            public KMS2EndpointBuilderImpl(String path, String string) {
                this.val$componentName = string;
                super(string, path);
            }
        }
        return new KMS2EndpointBuilderImpl(path, componentName);
    }

    public static class KMS2HeaderNameBuilder {
        private static final KMS2HeaderNameBuilder INSTANCE = new KMS2HeaderNameBuilder();

        public String awsKMSOperation() {
            return "CamelAwsKMSOperation";
        }

        public String awsKMSLimit() {
            return "CamelAwsKMSLimit";
        }

        public String awsKMSDescription() {
            return "CamelAwsKMSDescription";
        }

        public String awsKMSKeyId() {
            return "CamelAwsKMSKeyId";
        }

        public String awsKMSPendingWindowInDays() {
            return "CamelAwsKMSPendingWindowInDays";
        }
    }

    public static interface KMS2Builders {
        default public KMS2HeaderNameBuilder aws2Kms() {
            return KMS2HeaderNameBuilder.INSTANCE;
        }

        default public KMS2EndpointBuilder aws2Kms(String path) {
            return KMS2EndpointBuilderFactory.endpointBuilder("aws2-kms", path);
        }

        default public KMS2EndpointBuilder aws2Kms(String componentName, String path) {
            return KMS2EndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    public static interface AdvancedKMS2EndpointBuilder
    extends EndpointProducerBuilder {
        default public KMS2EndpointBuilder basic() {
            return (KMS2EndpointBuilder)((Object)this);
        }

        default public AdvancedKMS2EndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AdvancedKMS2EndpointBuilder lazyStartProducer(String lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AdvancedKMS2EndpointBuilder kmsClient(KmsClient kmsClient) {
            this.doSetProperty("kmsClient", kmsClient);
            return this;
        }

        default public AdvancedKMS2EndpointBuilder kmsClient(String kmsClient) {
            this.doSetProperty("kmsClient", kmsClient);
            return this;
        }
    }

    public static interface KMS2EndpointBuilder
    extends EndpointProducerBuilder {
        default public AdvancedKMS2EndpointBuilder advanced() {
            return (AdvancedKMS2EndpointBuilder)((Object)this);
        }

        default public KMS2EndpointBuilder operation(KMS2Operations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public KMS2EndpointBuilder operation(String operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public KMS2EndpointBuilder overrideEndpoint(boolean overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        default public KMS2EndpointBuilder overrideEndpoint(String overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        default public KMS2EndpointBuilder pojoRequest(boolean pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public KMS2EndpointBuilder pojoRequest(String pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public KMS2EndpointBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public KMS2EndpointBuilder uriEndpointOverride(String uriEndpointOverride) {
            this.doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }

        default public KMS2EndpointBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public KMS2EndpointBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public KMS2EndpointBuilder proxyPort(String proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public KMS2EndpointBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public KMS2EndpointBuilder proxyProtocol(String proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public KMS2EndpointBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public KMS2EndpointBuilder profileCredentialsName(String profileCredentialsName) {
            this.doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }

        default public KMS2EndpointBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }

        default public KMS2EndpointBuilder trustAllCertificates(boolean trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public KMS2EndpointBuilder trustAllCertificates(String trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public KMS2EndpointBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public KMS2EndpointBuilder useDefaultCredentialsProvider(String useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public KMS2EndpointBuilder useProfileCredentialsProvider(boolean useProfileCredentialsProvider) {
            this.doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }

        default public KMS2EndpointBuilder useProfileCredentialsProvider(String useProfileCredentialsProvider) {
            this.doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }
    }
}

