/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.endpoint.dsl;

import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.component.aws2.mq.MQ2Operations;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.mq.MqClient;

public interface MQ2EndpointBuilderFactory {
    public static MQ2EndpointBuilder endpointBuilder(String componentName, String path) {
        class MQ2EndpointBuilderImpl
        extends AbstractEndpointBuilder
        implements MQ2EndpointBuilder,
        AdvancedMQ2EndpointBuilder {
            final /* synthetic */ String val$componentName;

            public MQ2EndpointBuilderImpl(String path, String string) {
                this.val$componentName = string;
                super(string, path);
            }
        }
        return new MQ2EndpointBuilderImpl(path, componentName);
    }

    public static class MQ2HeaderNameBuilder {
        private static final MQ2HeaderNameBuilder INSTANCE = new MQ2HeaderNameBuilder();

        public String awsMQOperation() {
            return "CamelAwsMQOperation";
        }

        public String awsMQMaxResults() {
            return "CamelAwsMQMaxResults";
        }

        public String awsMQBrokerName() {
            return "CamelAwsMQBrokerName";
        }

        public String awsMQBrokerEngine() {
            return "CamelAwsMQBrokerEngine";
        }

        public String awsMQBrokerEngineVersion() {
            return "CamelAwsMQBrokerEngineVersion";
        }

        public String awsMQBrokerID() {
            return "CamelAwsMQBrokerID";
        }

        public String awsMQConfigurationID() {
            return "CamelAwsMQConfigurationID";
        }

        public String awsMQBrokerDeploymentMode() {
            return "CamelAwsMQBrokerDeploymentMode";
        }

        public String awsMQBrokerInstanceType() {
            return "CamelAwsMQBrokerInstanceType";
        }

        public String awsMQBrokerUsers() {
            return "CamelAwsMQBrokerUsers";
        }

        public String awsMQBrokerPubliclyAccessible() {
            return "CamelAwsMQBrokerPubliclyAccessible";
        }
    }

    public static interface MQ2Builders {
        default public MQ2HeaderNameBuilder aws2Mq() {
            return MQ2HeaderNameBuilder.INSTANCE;
        }

        default public MQ2EndpointBuilder aws2Mq(String path) {
            return MQ2EndpointBuilderFactory.endpointBuilder("aws2-mq", path);
        }

        default public MQ2EndpointBuilder aws2Mq(String componentName, String path) {
            return MQ2EndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    public static interface AdvancedMQ2EndpointBuilder
    extends EndpointProducerBuilder {
        default public MQ2EndpointBuilder basic() {
            return (MQ2EndpointBuilder)((Object)this);
        }

        default public AdvancedMQ2EndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AdvancedMQ2EndpointBuilder lazyStartProducer(String lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AdvancedMQ2EndpointBuilder amazonMqClient(MqClient amazonMqClient) {
            this.doSetProperty("amazonMqClient", amazonMqClient);
            return this;
        }

        default public AdvancedMQ2EndpointBuilder amazonMqClient(String amazonMqClient) {
            this.doSetProperty("amazonMqClient", amazonMqClient);
            return this;
        }
    }

    public static interface MQ2EndpointBuilder
    extends EndpointProducerBuilder {
        default public AdvancedMQ2EndpointBuilder advanced() {
            return (AdvancedMQ2EndpointBuilder)((Object)this);
        }

        default public MQ2EndpointBuilder operation(MQ2Operations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public MQ2EndpointBuilder operation(String operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public MQ2EndpointBuilder overrideEndpoint(boolean overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        default public MQ2EndpointBuilder overrideEndpoint(String overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        default public MQ2EndpointBuilder pojoRequest(boolean pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public MQ2EndpointBuilder pojoRequest(String pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public MQ2EndpointBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public MQ2EndpointBuilder uriEndpointOverride(String uriEndpointOverride) {
            this.doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }

        default public MQ2EndpointBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public MQ2EndpointBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public MQ2EndpointBuilder proxyPort(String proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public MQ2EndpointBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public MQ2EndpointBuilder proxyProtocol(String proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public MQ2EndpointBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public MQ2EndpointBuilder profileCredentialsName(String profileCredentialsName) {
            this.doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }

        default public MQ2EndpointBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }

        default public MQ2EndpointBuilder trustAllCertificates(boolean trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public MQ2EndpointBuilder trustAllCertificates(String trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public MQ2EndpointBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public MQ2EndpointBuilder useDefaultCredentialsProvider(String useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public MQ2EndpointBuilder useProfileCredentialsProvider(boolean useProfileCredentialsProvider) {
            this.doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }

        default public MQ2EndpointBuilder useProfileCredentialsProvider(String useProfileCredentialsProvider) {
            this.doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }
    }
}

