/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.endpoint.dsl;

import com.azure.storage.file.share.models.ShareFileItem;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileExclusiveReadLockStrategy;
import org.apache.camel.component.file.GenericFileExist;
import org.apache.camel.component.file.GenericFileFilter;
import org.apache.camel.component.file.GenericFileProcessStrategy;
import org.apache.camel.component.file.azure.CredentialType;
import org.apache.camel.component.file.strategy.FileMoveExistingStrategy;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.spi.PollingConsumerPollStrategy;

public interface FilesEndpointBuilderFactory {
    public static FilesEndpointBuilder endpointBuilder(String componentName, String path) {
        class FilesEndpointBuilderImpl
        extends AbstractEndpointBuilder
        implements FilesEndpointBuilder,
        AdvancedFilesEndpointBuilder {
            final /* synthetic */ String val$componentName;

            public FilesEndpointBuilderImpl(String path, String string) {
                this.val$componentName = string;
                super(string, path);
            }
        }
        return new FilesEndpointBuilderImpl(path, componentName);
    }

    public static class FilesHeaderNameBuilder {
        private static final FilesHeaderNameBuilder INSTANCE = new FilesHeaderNameBuilder();

        public String fileLength() {
            return "CamelFileLength";
        }

        public String fileLastModified() {
            return "CamelFileLastModified";
        }

        public String fileName() {
            return "CamelFileName";
        }

        public String fileNameOnly() {
            return "CamelFileNameOnly";
        }

        public String fileParent() {
            return "CamelFileParent";
        }

        public String remoteFileInputStream() {
            return "CamelRemoteFileInputStream";
        }

        public String fileLocalWorkPath() {
            return "CamelFileLocalWorkPath";
        }

        public String fileHost() {
            return "CamelFileHost";
        }
    }

    public static interface FilesBuilders {
        default public FilesHeaderNameBuilder azureFiles() {
            return FilesHeaderNameBuilder.INSTANCE;
        }

        default public FilesEndpointBuilder azureFiles(String path) {
            return FilesEndpointBuilderFactory.endpointBuilder("azure-files", path);
        }

        default public FilesEndpointBuilder azureFiles(String componentName, String path) {
            return FilesEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    public static interface AdvancedFilesEndpointBuilder
    extends AdvancedFilesEndpointConsumerBuilder,
    AdvancedFilesEndpointProducerBuilder {
        @Override
        default public FilesEndpointBuilder basic() {
            return (FilesEndpointBuilder)((Object)this);
        }

        @Override
        default public AdvancedFilesEndpointBuilder autoCreate(boolean autoCreate) {
            this.doSetProperty("autoCreate", autoCreate);
            return this;
        }

        @Override
        default public AdvancedFilesEndpointBuilder autoCreate(String autoCreate) {
            this.doSetProperty("autoCreate", autoCreate);
            return this;
        }

        @Override
        default public AdvancedFilesEndpointBuilder connectTimeout(int connectTimeout) {
            this.doSetProperty("connectTimeout", connectTimeout);
            return this;
        }

        @Override
        default public AdvancedFilesEndpointBuilder connectTimeout(String connectTimeout) {
            this.doSetProperty("connectTimeout", connectTimeout);
            return this;
        }

        @Override
        default public AdvancedFilesEndpointBuilder maximumReconnectAttempts(int maximumReconnectAttempts) {
            this.doSetProperty("maximumReconnectAttempts", maximumReconnectAttempts);
            return this;
        }

        @Override
        default public AdvancedFilesEndpointBuilder maximumReconnectAttempts(String maximumReconnectAttempts) {
            this.doSetProperty("maximumReconnectAttempts", maximumReconnectAttempts);
            return this;
        }

        @Override
        default public AdvancedFilesEndpointBuilder reconnectDelay(long reconnectDelay) {
            this.doSetProperty("reconnectDelay", reconnectDelay);
            return this;
        }

        @Override
        default public AdvancedFilesEndpointBuilder reconnectDelay(String reconnectDelay) {
            this.doSetProperty("reconnectDelay", reconnectDelay);
            return this;
        }

        @Override
        default public AdvancedFilesEndpointBuilder throwExceptionOnConnectFailed(boolean throwExceptionOnConnectFailed) {
            this.doSetProperty("throwExceptionOnConnectFailed", throwExceptionOnConnectFailed);
            return this;
        }

        @Override
        default public AdvancedFilesEndpointBuilder throwExceptionOnConnectFailed(String throwExceptionOnConnectFailed) {
            this.doSetProperty("throwExceptionOnConnectFailed", throwExceptionOnConnectFailed);
            return this;
        }

        @Override
        default public AdvancedFilesEndpointBuilder timeout(int timeout) {
            this.doSetProperty("timeout", timeout);
            return this;
        }

        @Override
        default public AdvancedFilesEndpointBuilder timeout(String timeout) {
            this.doSetProperty("timeout", timeout);
            return this;
        }
    }

    public static interface FilesEndpointBuilder
    extends FilesEndpointConsumerBuilder,
    FilesEndpointProducerBuilder {
        @Override
        default public AdvancedFilesEndpointBuilder advanced() {
            return (AdvancedFilesEndpointBuilder)((Object)this);
        }

        @Override
        default public FilesEndpointBuilder credentialType(CredentialType credentialType) {
            this.doSetProperty("credentialType", credentialType);
            return this;
        }

        @Override
        default public FilesEndpointBuilder credentialType(String credentialType) {
            this.doSetProperty("credentialType", credentialType);
            return this;
        }

        @Override
        default public FilesEndpointBuilder disconnect(boolean disconnect) {
            this.doSetProperty("disconnect", disconnect);
            return this;
        }

        @Override
        default public FilesEndpointBuilder disconnect(String disconnect) {
            this.doSetProperty("disconnect", disconnect);
            return this;
        }

        @Override
        default public FilesEndpointBuilder doneFileName(String doneFileName) {
            this.doSetProperty("doneFileName", doneFileName);
            return this;
        }

        @Override
        default public FilesEndpointBuilder fileName(String fileName) {
            this.doSetProperty("fileName", fileName);
            return this;
        }

        @Override
        default public FilesEndpointBuilder sharedKey(String sharedKey) {
            this.doSetProperty("sharedKey", sharedKey);
            return this;
        }

        @Override
        default public FilesEndpointBuilder sdd(String sdd) {
            this.doSetProperty("sdd", sdd);
            return this;
        }

        @Override
        default public FilesEndpointBuilder se(String se) {
            this.doSetProperty("se", se);
            return this;
        }

        @Override
        default public FilesEndpointBuilder si(String si) {
            this.doSetProperty("si", si);
            return this;
        }

        @Override
        default public FilesEndpointBuilder sig(String sig) {
            this.doSetProperty("sig", sig);
            return this;
        }

        @Override
        default public FilesEndpointBuilder sip(String sip) {
            this.doSetProperty("sip", sip);
            return this;
        }

        @Override
        default public FilesEndpointBuilder sp(String sp) {
            this.doSetProperty("sp", sp);
            return this;
        }

        @Override
        default public FilesEndpointBuilder spr(String spr) {
            this.doSetProperty("spr", spr);
            return this;
        }

        @Override
        default public FilesEndpointBuilder sr(String sr) {
            this.doSetProperty("sr", sr);
            return this;
        }

        @Override
        default public FilesEndpointBuilder srt(String srt) {
            this.doSetProperty("srt", srt);
            return this;
        }

        @Override
        default public FilesEndpointBuilder ss(String ss) {
            this.doSetProperty("ss", ss);
            return this;
        }

        @Override
        default public FilesEndpointBuilder st(String st) {
            this.doSetProperty("st", st);
            return this;
        }

        @Override
        default public FilesEndpointBuilder sv(String sv) {
            this.doSetProperty("sv", sv);
            return this;
        }
    }

    public static interface AdvancedFilesEndpointProducerBuilder
    extends EndpointProducerBuilder {
        default public FilesEndpointProducerBuilder basic() {
            return (FilesEndpointProducerBuilder)((Object)this);
        }

        default public AdvancedFilesEndpointProducerBuilder allowNullBody(boolean allowNullBody) {
            this.doSetProperty("allowNullBody", allowNullBody);
            return this;
        }

        default public AdvancedFilesEndpointProducerBuilder allowNullBody(String allowNullBody) {
            this.doSetProperty("allowNullBody", allowNullBody);
            return this;
        }

        default public AdvancedFilesEndpointProducerBuilder disconnectOnBatchComplete(boolean disconnectOnBatchComplete) {
            this.doSetProperty("disconnectOnBatchComplete", disconnectOnBatchComplete);
            return this;
        }

        default public AdvancedFilesEndpointProducerBuilder disconnectOnBatchComplete(String disconnectOnBatchComplete) {
            this.doSetProperty("disconnectOnBatchComplete", disconnectOnBatchComplete);
            return this;
        }

        default public AdvancedFilesEndpointProducerBuilder eagerDeleteTargetFile(boolean eagerDeleteTargetFile) {
            this.doSetProperty("eagerDeleteTargetFile", eagerDeleteTargetFile);
            return this;
        }

        default public AdvancedFilesEndpointProducerBuilder eagerDeleteTargetFile(String eagerDeleteTargetFile) {
            this.doSetProperty("eagerDeleteTargetFile", eagerDeleteTargetFile);
            return this;
        }

        default public AdvancedFilesEndpointProducerBuilder keepLastModified(boolean keepLastModified) {
            this.doSetProperty("keepLastModified", keepLastModified);
            return this;
        }

        default public AdvancedFilesEndpointProducerBuilder keepLastModified(String keepLastModified) {
            this.doSetProperty("keepLastModified", keepLastModified);
            return this;
        }

        default public AdvancedFilesEndpointProducerBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AdvancedFilesEndpointProducerBuilder lazyStartProducer(String lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AdvancedFilesEndpointProducerBuilder moveExistingFileStrategy(FileMoveExistingStrategy moveExistingFileStrategy) {
            this.doSetProperty("moveExistingFileStrategy", moveExistingFileStrategy);
            return this;
        }

        default public AdvancedFilesEndpointProducerBuilder moveExistingFileStrategy(String moveExistingFileStrategy) {
            this.doSetProperty("moveExistingFileStrategy", moveExistingFileStrategy);
            return this;
        }

        default public AdvancedFilesEndpointProducerBuilder autoCreate(boolean autoCreate) {
            this.doSetProperty("autoCreate", autoCreate);
            return this;
        }

        default public AdvancedFilesEndpointProducerBuilder autoCreate(String autoCreate) {
            this.doSetProperty("autoCreate", autoCreate);
            return this;
        }

        default public AdvancedFilesEndpointProducerBuilder connectTimeout(int connectTimeout) {
            this.doSetProperty("connectTimeout", connectTimeout);
            return this;
        }

        default public AdvancedFilesEndpointProducerBuilder connectTimeout(String connectTimeout) {
            this.doSetProperty("connectTimeout", connectTimeout);
            return this;
        }

        default public AdvancedFilesEndpointProducerBuilder maximumReconnectAttempts(int maximumReconnectAttempts) {
            this.doSetProperty("maximumReconnectAttempts", maximumReconnectAttempts);
            return this;
        }

        default public AdvancedFilesEndpointProducerBuilder maximumReconnectAttempts(String maximumReconnectAttempts) {
            this.doSetProperty("maximumReconnectAttempts", maximumReconnectAttempts);
            return this;
        }

        default public AdvancedFilesEndpointProducerBuilder reconnectDelay(long reconnectDelay) {
            this.doSetProperty("reconnectDelay", reconnectDelay);
            return this;
        }

        default public AdvancedFilesEndpointProducerBuilder reconnectDelay(String reconnectDelay) {
            this.doSetProperty("reconnectDelay", reconnectDelay);
            return this;
        }

        default public AdvancedFilesEndpointProducerBuilder throwExceptionOnConnectFailed(boolean throwExceptionOnConnectFailed) {
            this.doSetProperty("throwExceptionOnConnectFailed", throwExceptionOnConnectFailed);
            return this;
        }

        default public AdvancedFilesEndpointProducerBuilder throwExceptionOnConnectFailed(String throwExceptionOnConnectFailed) {
            this.doSetProperty("throwExceptionOnConnectFailed", throwExceptionOnConnectFailed);
            return this;
        }

        default public AdvancedFilesEndpointProducerBuilder timeout(int timeout) {
            this.doSetProperty("timeout", timeout);
            return this;
        }

        default public AdvancedFilesEndpointProducerBuilder timeout(String timeout) {
            this.doSetProperty("timeout", timeout);
            return this;
        }
    }

    public static interface FilesEndpointProducerBuilder
    extends EndpointProducerBuilder {
        default public AdvancedFilesEndpointProducerBuilder advanced() {
            return (AdvancedFilesEndpointProducerBuilder)((Object)this);
        }

        default public FilesEndpointProducerBuilder credentialType(CredentialType credentialType) {
            this.doSetProperty("credentialType", credentialType);
            return this;
        }

        default public FilesEndpointProducerBuilder credentialType(String credentialType) {
            this.doSetProperty("credentialType", credentialType);
            return this;
        }

        default public FilesEndpointProducerBuilder disconnect(boolean disconnect) {
            this.doSetProperty("disconnect", disconnect);
            return this;
        }

        default public FilesEndpointProducerBuilder disconnect(String disconnect) {
            this.doSetProperty("disconnect", disconnect);
            return this;
        }

        default public FilesEndpointProducerBuilder doneFileName(String doneFileName) {
            this.doSetProperty("doneFileName", doneFileName);
            return this;
        }

        default public FilesEndpointProducerBuilder fileName(String fileName) {
            this.doSetProperty("fileName", fileName);
            return this;
        }

        default public FilesEndpointProducerBuilder sharedKey(String sharedKey) {
            this.doSetProperty("sharedKey", sharedKey);
            return this;
        }

        default public FilesEndpointProducerBuilder checksumFileAlgorithm(String checksumFileAlgorithm) {
            this.doSetProperty("checksumFileAlgorithm", checksumFileAlgorithm);
            return this;
        }

        default public FilesEndpointProducerBuilder fileExist(GenericFileExist fileExist) {
            this.doSetProperty("fileExist", fileExist);
            return this;
        }

        default public FilesEndpointProducerBuilder fileExist(String fileExist) {
            this.doSetProperty("fileExist", fileExist);
            return this;
        }

        default public FilesEndpointProducerBuilder flatten(boolean flatten) {
            this.doSetProperty("flatten", flatten);
            return this;
        }

        default public FilesEndpointProducerBuilder flatten(String flatten) {
            this.doSetProperty("flatten", flatten);
            return this;
        }

        default public FilesEndpointProducerBuilder jailStartingDirectory(boolean jailStartingDirectory) {
            this.doSetProperty("jailStartingDirectory", jailStartingDirectory);
            return this;
        }

        default public FilesEndpointProducerBuilder jailStartingDirectory(String jailStartingDirectory) {
            this.doSetProperty("jailStartingDirectory", jailStartingDirectory);
            return this;
        }

        default public FilesEndpointProducerBuilder tempFileName(String tempFileName) {
            this.doSetProperty("tempFileName", tempFileName);
            return this;
        }

        default public FilesEndpointProducerBuilder tempPrefix(String tempPrefix) {
            this.doSetProperty("tempPrefix", tempPrefix);
            return this;
        }

        default public FilesEndpointProducerBuilder sdd(String sdd) {
            this.doSetProperty("sdd", sdd);
            return this;
        }

        default public FilesEndpointProducerBuilder se(String se) {
            this.doSetProperty("se", se);
            return this;
        }

        default public FilesEndpointProducerBuilder si(String si) {
            this.doSetProperty("si", si);
            return this;
        }

        default public FilesEndpointProducerBuilder sig(String sig) {
            this.doSetProperty("sig", sig);
            return this;
        }

        default public FilesEndpointProducerBuilder sip(String sip) {
            this.doSetProperty("sip", sip);
            return this;
        }

        default public FilesEndpointProducerBuilder sp(String sp) {
            this.doSetProperty("sp", sp);
            return this;
        }

        default public FilesEndpointProducerBuilder spr(String spr) {
            this.doSetProperty("spr", spr);
            return this;
        }

        default public FilesEndpointProducerBuilder sr(String sr) {
            this.doSetProperty("sr", sr);
            return this;
        }

        default public FilesEndpointProducerBuilder srt(String srt) {
            this.doSetProperty("srt", srt);
            return this;
        }

        default public FilesEndpointProducerBuilder ss(String ss) {
            this.doSetProperty("ss", ss);
            return this;
        }

        default public FilesEndpointProducerBuilder st(String st) {
            this.doSetProperty("st", st);
            return this;
        }

        default public FilesEndpointProducerBuilder sv(String sv) {
            this.doSetProperty("sv", sv);
            return this;
        }
    }

    public static interface AdvancedFilesEndpointConsumerBuilder
    extends EndpointConsumerBuilder {
        default public FilesEndpointConsumerBuilder basic() {
            return (FilesEndpointConsumerBuilder)((Object)this);
        }

        default public AdvancedFilesEndpointConsumerBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public AdvancedFilesEndpointConsumerBuilder bridgeErrorHandler(String bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public AdvancedFilesEndpointConsumerBuilder download(boolean download) {
            this.doSetProperty("download", download);
            return this;
        }

        default public AdvancedFilesEndpointConsumerBuilder download(String download) {
            this.doSetProperty("download", download);
            return this;
        }

        default public AdvancedFilesEndpointConsumerBuilder exceptionHandler(ExceptionHandler exceptionHandler) {
            this.doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }

        default public AdvancedFilesEndpointConsumerBuilder exceptionHandler(String exceptionHandler) {
            this.doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }

        default public AdvancedFilesEndpointConsumerBuilder exchangePattern(ExchangePattern exchangePattern) {
            this.doSetProperty("exchangePattern", exchangePattern);
            return this;
        }

        default public AdvancedFilesEndpointConsumerBuilder exchangePattern(String exchangePattern) {
            this.doSetProperty("exchangePattern", exchangePattern);
            return this;
        }

        default public AdvancedFilesEndpointConsumerBuilder inProgressRepository(IdempotentRepository inProgressRepository) {
            this.doSetProperty("inProgressRepository", inProgressRepository);
            return this;
        }

        default public AdvancedFilesEndpointConsumerBuilder inProgressRepository(String inProgressRepository) {
            this.doSetProperty("inProgressRepository", inProgressRepository);
            return this;
        }

        default public AdvancedFilesEndpointConsumerBuilder localWorkDirectory(String localWorkDirectory) {
            this.doSetProperty("localWorkDirectory", localWorkDirectory);
            return this;
        }

        default public AdvancedFilesEndpointConsumerBuilder onCompletionExceptionHandler(ExceptionHandler onCompletionExceptionHandler) {
            this.doSetProperty("onCompletionExceptionHandler", onCompletionExceptionHandler);
            return this;
        }

        default public AdvancedFilesEndpointConsumerBuilder onCompletionExceptionHandler(String onCompletionExceptionHandler) {
            this.doSetProperty("onCompletionExceptionHandler", onCompletionExceptionHandler);
            return this;
        }

        default public AdvancedFilesEndpointConsumerBuilder pollStrategy(PollingConsumerPollStrategy pollStrategy) {
            this.doSetProperty("pollStrategy", pollStrategy);
            return this;
        }

        default public AdvancedFilesEndpointConsumerBuilder pollStrategy(String pollStrategy) {
            this.doSetProperty("pollStrategy", pollStrategy);
            return this;
        }

        default public AdvancedFilesEndpointConsumerBuilder processStrategy(GenericFileProcessStrategy<ShareFileItem> processStrategy) {
            this.doSetProperty("processStrategy", processStrategy);
            return this;
        }

        default public AdvancedFilesEndpointConsumerBuilder processStrategy(String processStrategy) {
            this.doSetProperty("processStrategy", processStrategy);
            return this;
        }

        default public AdvancedFilesEndpointConsumerBuilder autoCreate(boolean autoCreate) {
            this.doSetProperty("autoCreate", autoCreate);
            return this;
        }

        default public AdvancedFilesEndpointConsumerBuilder autoCreate(String autoCreate) {
            this.doSetProperty("autoCreate", autoCreate);
            return this;
        }

        default public AdvancedFilesEndpointConsumerBuilder connectTimeout(int connectTimeout) {
            this.doSetProperty("connectTimeout", connectTimeout);
            return this;
        }

        default public AdvancedFilesEndpointConsumerBuilder connectTimeout(String connectTimeout) {
            this.doSetProperty("connectTimeout", connectTimeout);
            return this;
        }

        default public AdvancedFilesEndpointConsumerBuilder maximumReconnectAttempts(int maximumReconnectAttempts) {
            this.doSetProperty("maximumReconnectAttempts", maximumReconnectAttempts);
            return this;
        }

        default public AdvancedFilesEndpointConsumerBuilder maximumReconnectAttempts(String maximumReconnectAttempts) {
            this.doSetProperty("maximumReconnectAttempts", maximumReconnectAttempts);
            return this;
        }

        default public AdvancedFilesEndpointConsumerBuilder reconnectDelay(long reconnectDelay) {
            this.doSetProperty("reconnectDelay", reconnectDelay);
            return this;
        }

        default public AdvancedFilesEndpointConsumerBuilder reconnectDelay(String reconnectDelay) {
            this.doSetProperty("reconnectDelay", reconnectDelay);
            return this;
        }

        default public AdvancedFilesEndpointConsumerBuilder throwExceptionOnConnectFailed(boolean throwExceptionOnConnectFailed) {
            this.doSetProperty("throwExceptionOnConnectFailed", throwExceptionOnConnectFailed);
            return this;
        }

        default public AdvancedFilesEndpointConsumerBuilder throwExceptionOnConnectFailed(String throwExceptionOnConnectFailed) {
            this.doSetProperty("throwExceptionOnConnectFailed", throwExceptionOnConnectFailed);
            return this;
        }

        default public AdvancedFilesEndpointConsumerBuilder timeout(int timeout) {
            this.doSetProperty("timeout", timeout);
            return this;
        }

        default public AdvancedFilesEndpointConsumerBuilder timeout(String timeout) {
            this.doSetProperty("timeout", timeout);
            return this;
        }
    }

    public static interface FilesEndpointConsumerBuilder
    extends EndpointConsumerBuilder {
        default public AdvancedFilesEndpointConsumerBuilder advanced() {
            return (AdvancedFilesEndpointConsumerBuilder)((Object)this);
        }

        default public FilesEndpointConsumerBuilder credentialType(CredentialType credentialType) {
            this.doSetProperty("credentialType", credentialType);
            return this;
        }

        default public FilesEndpointConsumerBuilder credentialType(String credentialType) {
            this.doSetProperty("credentialType", credentialType);
            return this;
        }

        default public FilesEndpointConsumerBuilder disconnect(boolean disconnect) {
            this.doSetProperty("disconnect", disconnect);
            return this;
        }

        default public FilesEndpointConsumerBuilder disconnect(String disconnect) {
            this.doSetProperty("disconnect", disconnect);
            return this;
        }

        default public FilesEndpointConsumerBuilder doneFileName(String doneFileName) {
            this.doSetProperty("doneFileName", doneFileName);
            return this;
        }

        default public FilesEndpointConsumerBuilder fileName(String fileName) {
            this.doSetProperty("fileName", fileName);
            return this;
        }

        default public FilesEndpointConsumerBuilder sharedKey(String sharedKey) {
            this.doSetProperty("sharedKey", sharedKey);
            return this;
        }

        default public FilesEndpointConsumerBuilder delete(boolean delete) {
            this.doSetProperty("delete", delete);
            return this;
        }

        default public FilesEndpointConsumerBuilder delete(String delete) {
            this.doSetProperty("delete", delete);
            return this;
        }

        default public FilesEndpointConsumerBuilder moveFailed(String moveFailed) {
            this.doSetProperty("moveFailed", moveFailed);
            return this;
        }

        default public FilesEndpointConsumerBuilder noop(boolean noop) {
            this.doSetProperty("noop", noop);
            return this;
        }

        default public FilesEndpointConsumerBuilder noop(String noop) {
            this.doSetProperty("noop", noop);
            return this;
        }

        default public FilesEndpointConsumerBuilder preMove(String preMove) {
            this.doSetProperty("preMove", preMove);
            return this;
        }

        default public FilesEndpointConsumerBuilder preSort(boolean preSort) {
            this.doSetProperty("preSort", preSort);
            return this;
        }

        default public FilesEndpointConsumerBuilder preSort(String preSort) {
            this.doSetProperty("preSort", preSort);
            return this;
        }

        default public FilesEndpointConsumerBuilder recursive(boolean recursive) {
            this.doSetProperty("recursive", recursive);
            return this;
        }

        default public FilesEndpointConsumerBuilder recursive(String recursive) {
            this.doSetProperty("recursive", recursive);
            return this;
        }

        default public FilesEndpointConsumerBuilder resumeDownload(boolean resumeDownload) {
            this.doSetProperty("resumeDownload", resumeDownload);
            return this;
        }

        default public FilesEndpointConsumerBuilder resumeDownload(String resumeDownload) {
            this.doSetProperty("resumeDownload", resumeDownload);
            return this;
        }

        default public FilesEndpointConsumerBuilder sendEmptyMessageWhenIdle(boolean sendEmptyMessageWhenIdle) {
            this.doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }

        default public FilesEndpointConsumerBuilder sendEmptyMessageWhenIdle(String sendEmptyMessageWhenIdle) {
            this.doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }

        default public FilesEndpointConsumerBuilder streamDownload(boolean streamDownload) {
            this.doSetProperty("streamDownload", streamDownload);
            return this;
        }

        default public FilesEndpointConsumerBuilder streamDownload(String streamDownload) {
            this.doSetProperty("streamDownload", streamDownload);
            return this;
        }

        default public FilesEndpointConsumerBuilder antExclude(String antExclude) {
            this.doSetProperty("antExclude", antExclude);
            return this;
        }

        default public FilesEndpointConsumerBuilder antFilterCaseSensitive(boolean antFilterCaseSensitive) {
            this.doSetProperty("antFilterCaseSensitive", antFilterCaseSensitive);
            return this;
        }

        default public FilesEndpointConsumerBuilder antFilterCaseSensitive(String antFilterCaseSensitive) {
            this.doSetProperty("antFilterCaseSensitive", antFilterCaseSensitive);
            return this;
        }

        default public FilesEndpointConsumerBuilder antInclude(String antInclude) {
            this.doSetProperty("antInclude", antInclude);
            return this;
        }

        default public FilesEndpointConsumerBuilder eagerMaxMessagesPerPoll(boolean eagerMaxMessagesPerPoll) {
            this.doSetProperty("eagerMaxMessagesPerPoll", eagerMaxMessagesPerPoll);
            return this;
        }

        default public FilesEndpointConsumerBuilder eagerMaxMessagesPerPoll(String eagerMaxMessagesPerPoll) {
            this.doSetProperty("eagerMaxMessagesPerPoll", eagerMaxMessagesPerPoll);
            return this;
        }

        default public FilesEndpointConsumerBuilder exclude(String exclude) {
            this.doSetProperty("exclude", exclude);
            return this;
        }

        default public FilesEndpointConsumerBuilder excludeExt(String excludeExt) {
            this.doSetProperty("excludeExt", excludeExt);
            return this;
        }

        default public FilesEndpointConsumerBuilder filter(GenericFileFilter<ShareFileItem> filter) {
            this.doSetProperty("filter", filter);
            return this;
        }

        default public FilesEndpointConsumerBuilder filter(String filter) {
            this.doSetProperty("filter", filter);
            return this;
        }

        default public FilesEndpointConsumerBuilder filterDirectory(String filterDirectory) {
            this.doSetProperty("filterDirectory", filterDirectory);
            return this;
        }

        default public FilesEndpointConsumerBuilder filterFile(String filterFile) {
            this.doSetProperty("filterFile", filterFile);
            return this;
        }

        default public FilesEndpointConsumerBuilder idempotent(Boolean idempotent) {
            this.doSetProperty("idempotent", idempotent);
            return this;
        }

        default public FilesEndpointConsumerBuilder idempotent(String idempotent) {
            this.doSetProperty("idempotent", idempotent);
            return this;
        }

        default public FilesEndpointConsumerBuilder idempotentKey(String idempotentKey) {
            this.doSetProperty("idempotentKey", idempotentKey);
            return this;
        }

        default public FilesEndpointConsumerBuilder idempotentRepository(IdempotentRepository idempotentRepository) {
            this.doSetProperty("idempotentRepository", idempotentRepository);
            return this;
        }

        default public FilesEndpointConsumerBuilder idempotentRepository(String idempotentRepository) {
            this.doSetProperty("idempotentRepository", idempotentRepository);
            return this;
        }

        default public FilesEndpointConsumerBuilder include(String include) {
            this.doSetProperty("include", include);
            return this;
        }

        default public FilesEndpointConsumerBuilder includeExt(String includeExt) {
            this.doSetProperty("includeExt", includeExt);
            return this;
        }

        default public FilesEndpointConsumerBuilder maxDepth(int maxDepth) {
            this.doSetProperty("maxDepth", maxDepth);
            return this;
        }

        default public FilesEndpointConsumerBuilder maxDepth(String maxDepth) {
            this.doSetProperty("maxDepth", maxDepth);
            return this;
        }

        default public FilesEndpointConsumerBuilder maxMessagesPerPoll(int maxMessagesPerPoll) {
            this.doSetProperty("maxMessagesPerPoll", maxMessagesPerPoll);
            return this;
        }

        default public FilesEndpointConsumerBuilder maxMessagesPerPoll(String maxMessagesPerPoll) {
            this.doSetProperty("maxMessagesPerPoll", maxMessagesPerPoll);
            return this;
        }

        default public FilesEndpointConsumerBuilder minDepth(int minDepth) {
            this.doSetProperty("minDepth", minDepth);
            return this;
        }

        default public FilesEndpointConsumerBuilder minDepth(String minDepth) {
            this.doSetProperty("minDepth", minDepth);
            return this;
        }

        default public FilesEndpointConsumerBuilder move(String move) {
            this.doSetProperty("move", move);
            return this;
        }

        default public FilesEndpointConsumerBuilder exclusiveReadLockStrategy(GenericFileExclusiveReadLockStrategy<ShareFileItem> exclusiveReadLockStrategy) {
            this.doSetProperty("exclusiveReadLockStrategy", exclusiveReadLockStrategy);
            return this;
        }

        default public FilesEndpointConsumerBuilder exclusiveReadLockStrategy(String exclusiveReadLockStrategy) {
            this.doSetProperty("exclusiveReadLockStrategy", exclusiveReadLockStrategy);
            return this;
        }

        default public FilesEndpointConsumerBuilder readLock(String readLock) {
            this.doSetProperty("readLock", readLock);
            return this;
        }

        default public FilesEndpointConsumerBuilder readLockCheckInterval(long readLockCheckInterval) {
            this.doSetProperty("readLockCheckInterval", readLockCheckInterval);
            return this;
        }

        default public FilesEndpointConsumerBuilder readLockCheckInterval(String readLockCheckInterval) {
            this.doSetProperty("readLockCheckInterval", readLockCheckInterval);
            return this;
        }

        default public FilesEndpointConsumerBuilder readLockDeleteOrphanLockFiles(boolean readLockDeleteOrphanLockFiles) {
            this.doSetProperty("readLockDeleteOrphanLockFiles", readLockDeleteOrphanLockFiles);
            return this;
        }

        default public FilesEndpointConsumerBuilder readLockDeleteOrphanLockFiles(String readLockDeleteOrphanLockFiles) {
            this.doSetProperty("readLockDeleteOrphanLockFiles", readLockDeleteOrphanLockFiles);
            return this;
        }

        default public FilesEndpointConsumerBuilder readLockLoggingLevel(LoggingLevel readLockLoggingLevel) {
            this.doSetProperty("readLockLoggingLevel", readLockLoggingLevel);
            return this;
        }

        default public FilesEndpointConsumerBuilder readLockLoggingLevel(String readLockLoggingLevel) {
            this.doSetProperty("readLockLoggingLevel", readLockLoggingLevel);
            return this;
        }

        default public FilesEndpointConsumerBuilder readLockMarkerFile(boolean readLockMarkerFile) {
            this.doSetProperty("readLockMarkerFile", readLockMarkerFile);
            return this;
        }

        default public FilesEndpointConsumerBuilder readLockMarkerFile(String readLockMarkerFile) {
            this.doSetProperty("readLockMarkerFile", readLockMarkerFile);
            return this;
        }

        default public FilesEndpointConsumerBuilder readLockMinAge(long readLockMinAge) {
            this.doSetProperty("readLockMinAge", readLockMinAge);
            return this;
        }

        default public FilesEndpointConsumerBuilder readLockMinAge(String readLockMinAge) {
            this.doSetProperty("readLockMinAge", readLockMinAge);
            return this;
        }

        default public FilesEndpointConsumerBuilder readLockMinLength(long readLockMinLength) {
            this.doSetProperty("readLockMinLength", readLockMinLength);
            return this;
        }

        default public FilesEndpointConsumerBuilder readLockMinLength(String readLockMinLength) {
            this.doSetProperty("readLockMinLength", readLockMinLength);
            return this;
        }

        default public FilesEndpointConsumerBuilder readLockRemoveOnCommit(boolean readLockRemoveOnCommit) {
            this.doSetProperty("readLockRemoveOnCommit", readLockRemoveOnCommit);
            return this;
        }

        default public FilesEndpointConsumerBuilder readLockRemoveOnCommit(String readLockRemoveOnCommit) {
            this.doSetProperty("readLockRemoveOnCommit", readLockRemoveOnCommit);
            return this;
        }

        default public FilesEndpointConsumerBuilder readLockRemoveOnRollback(boolean readLockRemoveOnRollback) {
            this.doSetProperty("readLockRemoveOnRollback", readLockRemoveOnRollback);
            return this;
        }

        default public FilesEndpointConsumerBuilder readLockRemoveOnRollback(String readLockRemoveOnRollback) {
            this.doSetProperty("readLockRemoveOnRollback", readLockRemoveOnRollback);
            return this;
        }

        default public FilesEndpointConsumerBuilder readLockTimeout(long readLockTimeout) {
            this.doSetProperty("readLockTimeout", readLockTimeout);
            return this;
        }

        default public FilesEndpointConsumerBuilder readLockTimeout(String readLockTimeout) {
            this.doSetProperty("readLockTimeout", readLockTimeout);
            return this;
        }

        default public FilesEndpointConsumerBuilder backoffErrorThreshold(int backoffErrorThreshold) {
            this.doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }

        default public FilesEndpointConsumerBuilder backoffErrorThreshold(String backoffErrorThreshold) {
            this.doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }

        default public FilesEndpointConsumerBuilder backoffIdleThreshold(int backoffIdleThreshold) {
            this.doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }

        default public FilesEndpointConsumerBuilder backoffIdleThreshold(String backoffIdleThreshold) {
            this.doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }

        default public FilesEndpointConsumerBuilder backoffMultiplier(int backoffMultiplier) {
            this.doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }

        default public FilesEndpointConsumerBuilder backoffMultiplier(String backoffMultiplier) {
            this.doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }

        default public FilesEndpointConsumerBuilder delay(long delay) {
            this.doSetProperty("delay", delay);
            return this;
        }

        default public FilesEndpointConsumerBuilder delay(String delay) {
            this.doSetProperty("delay", delay);
            return this;
        }

        default public FilesEndpointConsumerBuilder greedy(boolean greedy) {
            this.doSetProperty("greedy", greedy);
            return this;
        }

        default public FilesEndpointConsumerBuilder greedy(String greedy) {
            this.doSetProperty("greedy", greedy);
            return this;
        }

        default public FilesEndpointConsumerBuilder initialDelay(long initialDelay) {
            this.doSetProperty("initialDelay", initialDelay);
            return this;
        }

        default public FilesEndpointConsumerBuilder initialDelay(String initialDelay) {
            this.doSetProperty("initialDelay", initialDelay);
            return this;
        }

        default public FilesEndpointConsumerBuilder repeatCount(long repeatCount) {
            this.doSetProperty("repeatCount", repeatCount);
            return this;
        }

        default public FilesEndpointConsumerBuilder repeatCount(String repeatCount) {
            this.doSetProperty("repeatCount", repeatCount);
            return this;
        }

        default public FilesEndpointConsumerBuilder runLoggingLevel(LoggingLevel runLoggingLevel) {
            this.doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }

        default public FilesEndpointConsumerBuilder runLoggingLevel(String runLoggingLevel) {
            this.doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }

        default public FilesEndpointConsumerBuilder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
            this.doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }

        default public FilesEndpointConsumerBuilder scheduledExecutorService(String scheduledExecutorService) {
            this.doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }

        default public FilesEndpointConsumerBuilder scheduler(Object scheduler) {
            this.doSetProperty("scheduler", scheduler);
            return this;
        }

        default public FilesEndpointConsumerBuilder scheduler(String scheduler) {
            this.doSetProperty("scheduler", scheduler);
            return this;
        }

        default public FilesEndpointConsumerBuilder schedulerProperties(String key, Object value) {
            this.doSetMultiValueProperty("schedulerProperties", "scheduler." + key, value);
            return this;
        }

        default public FilesEndpointConsumerBuilder schedulerProperties(Map values) {
            this.doSetMultiValueProperties("schedulerProperties", "scheduler.", values);
            return this;
        }

        default public FilesEndpointConsumerBuilder startScheduler(boolean startScheduler) {
            this.doSetProperty("startScheduler", startScheduler);
            return this;
        }

        default public FilesEndpointConsumerBuilder startScheduler(String startScheduler) {
            this.doSetProperty("startScheduler", startScheduler);
            return this;
        }

        default public FilesEndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            this.doSetProperty("timeUnit", (Object)timeUnit);
            return this;
        }

        default public FilesEndpointConsumerBuilder timeUnit(String timeUnit) {
            this.doSetProperty("timeUnit", timeUnit);
            return this;
        }

        default public FilesEndpointConsumerBuilder useFixedDelay(boolean useFixedDelay) {
            this.doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }

        default public FilesEndpointConsumerBuilder useFixedDelay(String useFixedDelay) {
            this.doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }

        default public FilesEndpointConsumerBuilder sdd(String sdd) {
            this.doSetProperty("sdd", sdd);
            return this;
        }

        default public FilesEndpointConsumerBuilder se(String se) {
            this.doSetProperty("se", se);
            return this;
        }

        default public FilesEndpointConsumerBuilder si(String si) {
            this.doSetProperty("si", si);
            return this;
        }

        default public FilesEndpointConsumerBuilder sig(String sig) {
            this.doSetProperty("sig", sig);
            return this;
        }

        default public FilesEndpointConsumerBuilder sip(String sip) {
            this.doSetProperty("sip", sip);
            return this;
        }

        default public FilesEndpointConsumerBuilder sp(String sp) {
            this.doSetProperty("sp", sp);
            return this;
        }

        default public FilesEndpointConsumerBuilder spr(String spr) {
            this.doSetProperty("spr", spr);
            return this;
        }

        default public FilesEndpointConsumerBuilder sr(String sr) {
            this.doSetProperty("sr", sr);
            return this;
        }

        default public FilesEndpointConsumerBuilder srt(String srt) {
            this.doSetProperty("srt", srt);
            return this;
        }

        default public FilesEndpointConsumerBuilder ss(String ss) {
            this.doSetProperty("ss", ss);
            return this;
        }

        default public FilesEndpointConsumerBuilder st(String st) {
            this.doSetProperty("st", st);
            return this;
        }

        default public FilesEndpointConsumerBuilder sv(String sv) {
            this.doSetProperty("sv", sv);
            return this;
        }

        default public FilesEndpointConsumerBuilder shuffle(boolean shuffle) {
            this.doSetProperty("shuffle", shuffle);
            return this;
        }

        default public FilesEndpointConsumerBuilder shuffle(String shuffle) {
            this.doSetProperty("shuffle", shuffle);
            return this;
        }

        default public FilesEndpointConsumerBuilder sortBy(String sortBy) {
            this.doSetProperty("sortBy", sortBy);
            return this;
        }

        default public FilesEndpointConsumerBuilder sorter(Comparator<GenericFile<ShareFileItem>> sorter) {
            this.doSetProperty("sorter", sorter);
            return this;
        }

        default public FilesEndpointConsumerBuilder sorter(String sorter) {
            this.doSetProperty("sorter", sorter);
            return this;
        }
    }
}

