/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Capture changes from a MongoDB database.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface DebeziumMongodbEndpointBuilderFactory {

    /**
     * Builder for endpoint for the Debezium MongoDB Connector component.
     */
    public interface DebeziumMongodbEndpointBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedDebeziumMongodbEndpointBuilder advanced() {
            return (AdvancedDebeziumMongodbEndpointBuilder) this;
        }

        /**
         * Additional properties for debezium components in case they can't be
         * set directly on the camel configurations (e.g: setting Kafka Connect
         * properties needed by Debezium engine, for example setting
         * KafkaOffsetBackingStore), the properties have to be prefixed with
         * additionalProperties.. E.g:
         * additionalProperties.transactional.id=12345&amp;additionalProperties.schema.registry.url=http://localhost:8811/avro.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * additionalProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: common
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder additionalProperties(String key, Object value) {
            doSetMultiValueProperty("additionalProperties", "additionalProperties." + key, value);
            return this;
        }
        /**
         * Additional properties for debezium components in case they can't be
         * set directly on the camel configurations (e.g: setting Kafka Connect
         * properties needed by Debezium engine, for example setting
         * KafkaOffsetBackingStore), the properties have to be prefixed with
         * additionalProperties.. E.g:
         * additionalProperties.transactional.id=12345&amp;additionalProperties.schema.registry.url=http://localhost:8811/avro.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * additionalProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: common
         * 
         * @param values the values
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder additionalProperties(Map values) {
            doSetMultiValueProperties("additionalProperties", "additionalProperties.", values);
            return this;
        }
        /**
         * The Converter class that should be used to serialize and deserialize
         * key data for offsets. The default is JSON converter.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: org.apache.kafka.connect.json.JsonConverter
         * Group: consumer
         * 
         * @param internalKeyConverter the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder internalKeyConverter(String internalKeyConverter) {
            doSetProperty("internalKeyConverter", internalKeyConverter);
            return this;
        }
        /**
         * The Converter class that should be used to serialize and deserialize
         * value data for offsets. The default is JSON converter.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: org.apache.kafka.connect.json.JsonConverter
         * Group: consumer
         * 
         * @param internalValueConverter the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder internalValueConverter(String internalValueConverter) {
            doSetProperty("internalValueConverter", internalValueConverter);
            return this;
        }
        /**
         * The name of the Java class of the commit policy. It defines when
         * offsets commit has to be triggered based on the number of events
         * processed and the time elapsed since the last commit. This class must
         * implement the interface 'OffsetCommitPolicy'. The default is a
         * periodic commit policy based upon time intervals.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         * 
         * @param offsetCommitPolicy the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder offsetCommitPolicy(String offsetCommitPolicy) {
            doSetProperty("offsetCommitPolicy", offsetCommitPolicy);
            return this;
        }
        /**
         * Maximum number of milliseconds to wait for records to flush and
         * partition offset data to be committed to offset storage before
         * cancelling the process and restoring the offset data to be committed
         * in a future attempt. The default is 5 seconds.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 5000
         * Group: consumer
         * 
         * @param offsetCommitTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder offsetCommitTimeoutMs(long offsetCommitTimeoutMs) {
            doSetProperty("offsetCommitTimeoutMs", offsetCommitTimeoutMs);
            return this;
        }
        /**
         * Maximum number of milliseconds to wait for records to flush and
         * partition offset data to be committed to offset storage before
         * cancelling the process and restoring the offset data to be committed
         * in a future attempt. The default is 5 seconds.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 5000
         * Group: consumer
         * 
         * @param offsetCommitTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder offsetCommitTimeoutMs(String offsetCommitTimeoutMs) {
            doSetProperty("offsetCommitTimeoutMs", offsetCommitTimeoutMs);
            return this;
        }
        /**
         * Interval at which to try committing offsets. The default is 1 minute.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 60000
         * Group: consumer
         * 
         * @param offsetFlushIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder offsetFlushIntervalMs(long offsetFlushIntervalMs) {
            doSetProperty("offsetFlushIntervalMs", offsetFlushIntervalMs);
            return this;
        }
        /**
         * Interval at which to try committing offsets. The default is 1 minute.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 60000
         * Group: consumer
         * 
         * @param offsetFlushIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder offsetFlushIntervalMs(String offsetFlushIntervalMs) {
            doSetProperty("offsetFlushIntervalMs", offsetFlushIntervalMs);
            return this;
        }
        /**
         * The name of the Java class that is responsible for persistence of
         * connector offsets.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: org.apache.kafka.connect.storage.FileOffsetBackingStore
         * Group: consumer
         * 
         * @param offsetStorage the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder offsetStorage(String offsetStorage) {
            doSetProperty("offsetStorage", offsetStorage);
            return this;
        }
        /**
         * Path to file where offsets are to be stored. Required when
         * offset.storage is set to the FileOffsetBackingStore.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         * 
         * @param offsetStorageFileName the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder offsetStorageFileName(String offsetStorageFileName) {
            doSetProperty("offsetStorageFileName", offsetStorageFileName);
            return this;
        }
        /**
         * The number of partitions used when creating the offset storage topic.
         * Required when offset.storage is set to the 'KafkaOffsetBackingStore'.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: consumer
         * 
         * @param offsetStoragePartitions the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder offsetStoragePartitions(int offsetStoragePartitions) {
            doSetProperty("offsetStoragePartitions", offsetStoragePartitions);
            return this;
        }
        /**
         * The number of partitions used when creating the offset storage topic.
         * Required when offset.storage is set to the 'KafkaOffsetBackingStore'.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: consumer
         * 
         * @param offsetStoragePartitions the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder offsetStoragePartitions(String offsetStoragePartitions) {
            doSetProperty("offsetStoragePartitions", offsetStoragePartitions);
            return this;
        }
        /**
         * Replication factor used when creating the offset storage topic.
         * Required when offset.storage is set to the KafkaOffsetBackingStore.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: consumer
         * 
         * @param offsetStorageReplicationFactor the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder offsetStorageReplicationFactor(int offsetStorageReplicationFactor) {
            doSetProperty("offsetStorageReplicationFactor", offsetStorageReplicationFactor);
            return this;
        }
        /**
         * Replication factor used when creating the offset storage topic.
         * Required when offset.storage is set to the KafkaOffsetBackingStore.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: consumer
         * 
         * @param offsetStorageReplicationFactor the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder offsetStorageReplicationFactor(String offsetStorageReplicationFactor) {
            doSetProperty("offsetStorageReplicationFactor", offsetStorageReplicationFactor);
            return this;
        }
        /**
         * The name of the Kafka topic where offsets are to be stored. Required
         * when offset.storage is set to the KafkaOffsetBackingStore.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         * 
         * @param offsetStorageTopic the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder offsetStorageTopic(String offsetStorageTopic) {
            doSetProperty("offsetStorageTopic", offsetStorageTopic);
            return this;
        }
        /**
         * The method used to capture changes from MongoDB server. Options
         * include: 'change_streams' to capture changes via MongoDB Change
         * Streams, update events do not contain full documents;
         * 'change_streams_update_full' (the default) to capture changes via
         * MongoDB Change Streams, update events contain full documents.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: change_streams_update_full
         * Group: mongodb
         * 
         * @param captureMode the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder captureMode(String captureMode) {
            doSetProperty("captureMode", captureMode);
            return this;
        }
        /**
         * A comma-separated list of regular expressions or literals that match
         * the collection names for which changes are to be excluded.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mongodb
         * 
         * @param collectionExcludeList the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder collectionExcludeList(String collectionExcludeList) {
            doSetProperty("collectionExcludeList", collectionExcludeList);
            return this;
        }
        /**
         * A comma-separated list of regular expressions or literals that match
         * the collection names for which changes are to be captured.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mongodb
         * 
         * @param collectionIncludeList the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder collectionIncludeList(String collectionIncludeList) {
            doSetProperty("collectionIncludeList", collectionIncludeList);
            return this;
        }
        /**
         * Optional list of custom converters that would be used instead of
         * default ones. The converters are defined using '.type' config option
         * and configured using options '.'.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mongodb
         * 
         * @param converters the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder converters(String converters) {
            doSetProperty("converters", converters);
            return this;
        }
        /**
         * The maximum processing time in milliseconds to wait for the oplog
         * cursor to process a single poll request.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: mongodb
         * 
         * @param cursorMaxAwaitTimeMs the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder cursorMaxAwaitTimeMs(int cursorMaxAwaitTimeMs) {
            doSetProperty("cursorMaxAwaitTimeMs", cursorMaxAwaitTimeMs);
            return this;
        }
        /**
         * The maximum processing time in milliseconds to wait for the oplog
         * cursor to process a single poll request.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: mongodb
         * 
         * @param cursorMaxAwaitTimeMs the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder cursorMaxAwaitTimeMs(String cursorMaxAwaitTimeMs) {
            doSetProperty("cursorMaxAwaitTimeMs", cursorMaxAwaitTimeMs);
            return this;
        }
        /**
         * The custom metric tags will accept key-value pairs to customize the
         * MBean object name which should be appended the end of regular name,
         * each key would represent a tag for the MBean object name, and the
         * corresponding value would be the value of that tag the key is. For
         * example: k1=v1,k2=v2.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mongodb
         * 
         * @param customMetricTags the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder customMetricTags(String customMetricTags) {
            doSetProperty("customMetricTags", customMetricTags);
            return this;
        }
        /**
         * A comma-separated list of regular expressions or literals that match
         * the database names for which changes are to be excluded.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mongodb
         * 
         * @param databaseExcludeList the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder databaseExcludeList(String databaseExcludeList) {
            doSetProperty("databaseExcludeList", databaseExcludeList);
            return this;
        }
        /**
         * A comma-separated list of regular expressions or literals that match
         * the database names for which changes are to be captured.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mongodb
         * 
         * @param databaseIncludeList the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder databaseIncludeList(String databaseIncludeList) {
            doSetProperty("databaseIncludeList", databaseIncludeList);
            return this;
        }
        /**
         * The maximum number of retries on connection errors before failing (-1
         * = no limit, 0 = disabled, 0 = num of retries).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: -1
         * Group: mongodb
         * 
         * @param errorsMaxRetries the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder errorsMaxRetries(int errorsMaxRetries) {
            doSetProperty("errorsMaxRetries", errorsMaxRetries);
            return this;
        }
        /**
         * The maximum number of retries on connection errors before failing (-1
         * = no limit, 0 = disabled, 0 = num of retries).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: -1
         * Group: mongodb
         * 
         * @param errorsMaxRetries the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder errorsMaxRetries(String errorsMaxRetries) {
            doSetProperty("errorsMaxRetries", errorsMaxRetries);
            return this;
        }
        /**
         * Specify how failures during processing of events (i.e. when
         * encountering a corrupted event) should be handled, including: 'fail'
         * (the default) an exception indicating the problematic event and its
         * position is raised, causing the connector to be stopped; 'warn' the
         * problematic event and its position will be logged and the event will
         * be skipped; 'ignore' the problematic event will be skipped.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: fail
         * Group: mongodb
         * 
         * @param eventProcessingFailureHandlingMode the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder eventProcessingFailureHandlingMode(String eventProcessingFailureHandlingMode) {
            doSetProperty("eventProcessingFailureHandlingMode", eventProcessingFailureHandlingMode);
            return this;
        }
        /**
         * A comma-separated list of the fully-qualified names of fields that
         * should be excluded from change event message values.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mongodb
         * 
         * @param fieldExcludeList the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder fieldExcludeList(String fieldExcludeList) {
            doSetProperty("fieldExcludeList", fieldExcludeList);
            return this;
        }
        /**
         * A comma-separated list of the fully-qualified replacements of fields
         * that should be used to rename fields in change event message values.
         * Fully-qualified replacements for fields are of the form
         * databaseName.collectionName.fieldName.nestedFieldName:newNestedFieldName, where databaseName and collectionName may contain the wildcard () which matches any characters, the colon character (:) is used to determine rename mapping of field.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mongodb
         * 
         * @param fieldRenames the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder fieldRenames(String fieldRenames) {
            doSetProperty("fieldRenames", fieldRenames);
            return this;
        }
        /**
         * Length of an interval in milli-seconds in in which the connector
         * periodically sends heartbeat messages to a heartbeat topic. Use 0 to
         * disable heartbeat messages. Disabled by default.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 0ms
         * Group: mongodb
         * 
         * @param heartbeatIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder heartbeatIntervalMs(int heartbeatIntervalMs) {
            doSetProperty("heartbeatIntervalMs", heartbeatIntervalMs);
            return this;
        }
        /**
         * Length of an interval in milli-seconds in in which the connector
         * periodically sends heartbeat messages to a heartbeat topic. Use 0 to
         * disable heartbeat messages. Disabled by default.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 0ms
         * Group: mongodb
         * 
         * @param heartbeatIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder heartbeatIntervalMs(String heartbeatIntervalMs) {
            doSetProperty("heartbeatIntervalMs", heartbeatIntervalMs);
            return this;
        }
        /**
         * The prefix that is used to name heartbeat topics.Defaults to
         * __debezium-heartbeat.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: __debezium-heartbeat
         * Group: mongodb
         * 
         * @param heartbeatTopicsPrefix the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder heartbeatTopicsPrefix(String heartbeatTopicsPrefix) {
            doSetProperty("heartbeatTopicsPrefix", heartbeatTopicsPrefix);
            return this;
        }
        /**
         * Specify the strategy used for watermarking during an incremental
         * snapshot: 'insert_insert' both open and close signal is written into
         * signal data collection (default); 'insert_delete' only open signal is
         * written on signal data collection, the close will delete the relative
         * open signal;.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: INSERT_INSERT
         * Group: mongodb
         * 
         * @param incrementalSnapshotWatermarkingStrategy the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder incrementalSnapshotWatermarkingStrategy(String incrementalSnapshotWatermarkingStrategy) {
            doSetProperty("incrementalSnapshotWatermarkingStrategy", incrementalSnapshotWatermarkingStrategy);
            return this;
        }
        /**
         * Maximum size of each batch of source records. Defaults to 2048.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 2048
         * Group: mongodb
         * 
         * @param maxBatchSize the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder maxBatchSize(int maxBatchSize) {
            doSetProperty("maxBatchSize", maxBatchSize);
            return this;
        }
        /**
         * Maximum size of each batch of source records. Defaults to 2048.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 2048
         * Group: mongodb
         * 
         * @param maxBatchSize the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder maxBatchSize(String maxBatchSize) {
            doSetProperty("maxBatchSize", maxBatchSize);
            return this;
        }
        /**
         * Maximum size of the queue for change events read from the database
         * log but not yet recorded or forwarded. Defaults to 8192, and should
         * always be larger than the maximum batch size.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 8192
         * Group: mongodb
         * 
         * @param maxQueueSize the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder maxQueueSize(int maxQueueSize) {
            doSetProperty("maxQueueSize", maxQueueSize);
            return this;
        }
        /**
         * Maximum size of the queue for change events read from the database
         * log but not yet recorded or forwarded. Defaults to 8192, and should
         * always be larger than the maximum batch size.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 8192
         * Group: mongodb
         * 
         * @param maxQueueSize the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder maxQueueSize(String maxQueueSize) {
            doSetProperty("maxQueueSize", maxQueueSize);
            return this;
        }
        /**
         * Maximum size of the queue in bytes for change events read from the
         * database log but not yet recorded or forwarded. Defaults to 0. Mean
         * the feature is not enabled.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 0
         * Group: mongodb
         * 
         * @param maxQueueSizeInBytes the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder maxQueueSizeInBytes(long maxQueueSizeInBytes) {
            doSetProperty("maxQueueSizeInBytes", maxQueueSizeInBytes);
            return this;
        }
        /**
         * Maximum size of the queue in bytes for change events read from the
         * database log but not yet recorded or forwarded. Defaults to 0. Mean
         * the feature is not enabled.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 0
         * Group: mongodb
         * 
         * @param maxQueueSizeInBytes the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder maxQueueSizeInBytes(String maxQueueSizeInBytes) {
            doSetProperty("maxQueueSizeInBytes", maxQueueSizeInBytes);
            return this;
        }
        /**
         * Database containing user credentials.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: admin
         * Group: mongodb
         * 
         * @param mongodbAuthsource the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder mongodbAuthsource(String mongodbAuthsource) {
            doSetProperty("mongodbAuthsource", mongodbAuthsource);
            return this;
        }
        /**
         * Database connection string.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mongodb
         * 
         * @param mongodbConnectionString the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder mongodbConnectionString(String mongodbConnectionString) {
            doSetProperty("mongodbConnectionString", mongodbConnectionString);
            return this;
        }
        /**
         * The connection timeout, given in milliseconds. Defaults to 10 seconds
         * (10,000 ms).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 10s
         * Group: mongodb
         * 
         * @param mongodbConnectTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder mongodbConnectTimeoutMs(int mongodbConnectTimeoutMs) {
            doSetProperty("mongodbConnectTimeoutMs", mongodbConnectTimeoutMs);
            return this;
        }
        /**
         * The connection timeout, given in milliseconds. Defaults to 10 seconds
         * (10,000 ms).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 10s
         * Group: mongodb
         * 
         * @param mongodbConnectTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder mongodbConnectTimeoutMs(String mongodbConnectTimeoutMs) {
            doSetProperty("mongodbConnectTimeoutMs", mongodbConnectTimeoutMs);
            return this;
        }
        /**
         * The frequency that the cluster monitor attempts to reach each server.
         * Defaults to 10 seconds (10,000 ms).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 10s
         * Group: mongodb
         * 
         * @param mongodbHeartbeatFrequencyMs the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder mongodbHeartbeatFrequencyMs(int mongodbHeartbeatFrequencyMs) {
            doSetProperty("mongodbHeartbeatFrequencyMs", mongodbHeartbeatFrequencyMs);
            return this;
        }
        /**
         * The frequency that the cluster monitor attempts to reach each server.
         * Defaults to 10 seconds (10,000 ms).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 10s
         * Group: mongodb
         * 
         * @param mongodbHeartbeatFrequencyMs the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder mongodbHeartbeatFrequencyMs(String mongodbHeartbeatFrequencyMs) {
            doSetProperty("mongodbHeartbeatFrequencyMs", mongodbHeartbeatFrequencyMs);
            return this;
        }
        /**
         * Password to be used when connecting to MongoDB, if necessary.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: mongodb
         * 
         * @param mongodbPassword the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder mongodbPassword(String mongodbPassword) {
            doSetProperty("mongodbPassword", mongodbPassword);
            return this;
        }
        /**
         * Interval for looking for new, removed, or changed replica sets, given
         * in milliseconds. Defaults to 30 seconds (30,000 ms).
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 30s
         * Group: mongodb
         * 
         * @param mongodbPollIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder mongodbPollIntervalMs(long mongodbPollIntervalMs) {
            doSetProperty("mongodbPollIntervalMs", mongodbPollIntervalMs);
            return this;
        }
        /**
         * Interval for looking for new, removed, or changed replica sets, given
         * in milliseconds. Defaults to 30 seconds (30,000 ms).
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 30s
         * Group: mongodb
         * 
         * @param mongodbPollIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder mongodbPollIntervalMs(String mongodbPollIntervalMs) {
            doSetProperty("mongodbPollIntervalMs", mongodbPollIntervalMs);
            return this;
        }
        /**
         * The server selection timeout, given in milliseconds. Defaults to 10
         * seconds (10,000 ms).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 30s
         * Group: mongodb
         * 
         * @param mongodbServerSelectionTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder mongodbServerSelectionTimeoutMs(int mongodbServerSelectionTimeoutMs) {
            doSetProperty("mongodbServerSelectionTimeoutMs", mongodbServerSelectionTimeoutMs);
            return this;
        }
        /**
         * The server selection timeout, given in milliseconds. Defaults to 10
         * seconds (10,000 ms).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 30s
         * Group: mongodb
         * 
         * @param mongodbServerSelectionTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder mongodbServerSelectionTimeoutMs(String mongodbServerSelectionTimeoutMs) {
            doSetProperty("mongodbServerSelectionTimeoutMs", mongodbServerSelectionTimeoutMs);
            return this;
        }
        /**
         * The socket timeout, given in milliseconds. Defaults to 0 ms.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 0ms
         * Group: mongodb
         * 
         * @param mongodbSocketTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder mongodbSocketTimeoutMs(int mongodbSocketTimeoutMs) {
            doSetProperty("mongodbSocketTimeoutMs", mongodbSocketTimeoutMs);
            return this;
        }
        /**
         * The socket timeout, given in milliseconds. Defaults to 0 ms.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 0ms
         * Group: mongodb
         * 
         * @param mongodbSocketTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder mongodbSocketTimeoutMs(String mongodbSocketTimeoutMs) {
            doSetProperty("mongodbSocketTimeoutMs", mongodbSocketTimeoutMs);
            return this;
        }
        /**
         * Should connector use SSL to connect to MongoDB instances.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: mongodb
         * 
         * @param mongodbSslEnabled the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder mongodbSslEnabled(boolean mongodbSslEnabled) {
            doSetProperty("mongodbSslEnabled", mongodbSslEnabled);
            return this;
        }
        /**
         * Should connector use SSL to connect to MongoDB instances.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: mongodb
         * 
         * @param mongodbSslEnabled the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder mongodbSslEnabled(String mongodbSslEnabled) {
            doSetProperty("mongodbSslEnabled", mongodbSslEnabled);
            return this;
        }
        /**
         * Whether invalid host names are allowed when using SSL. If true the
         * connection will not prevent man-in-the-middle attacks.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: mongodb
         * 
         * @param mongodbSslInvalidHostnameAllowed the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder mongodbSslInvalidHostnameAllowed(boolean mongodbSslInvalidHostnameAllowed) {
            doSetProperty("mongodbSslInvalidHostnameAllowed", mongodbSslInvalidHostnameAllowed);
            return this;
        }
        /**
         * Whether invalid host names are allowed when using SSL. If true the
         * connection will not prevent man-in-the-middle attacks.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: mongodb
         * 
         * @param mongodbSslInvalidHostnameAllowed the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder mongodbSslInvalidHostnameAllowed(String mongodbSslInvalidHostnameAllowed) {
            doSetProperty("mongodbSslInvalidHostnameAllowed", mongodbSslInvalidHostnameAllowed);
            return this;
        }
        /**
         * Database user for connecting to MongoDB, if necessary.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mongodb
         * 
         * @param mongodbUser the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder mongodbUser(String mongodbUser) {
            doSetProperty("mongodbUser", mongodbUser);
            return this;
        }
        /**
         * List of notification channels names that are enabled.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mongodb
         * 
         * @param notificationEnabledChannels the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder notificationEnabledChannels(String notificationEnabledChannels) {
            doSetProperty("notificationEnabledChannels", notificationEnabledChannels);
            return this;
        }
        /**
         * The name of the topic for the notifications. This is required in case
         * 'sink' is in the list of enabled channels.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mongodb
         * 
         * @param notificationSinkTopicName the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder notificationSinkTopicName(String notificationSinkTopicName) {
            doSetProperty("notificationSinkTopicName", notificationSinkTopicName);
            return this;
        }
        /**
         * Time to wait for new change events to appear after receiving no
         * events, given in milliseconds. Defaults to 500 ms.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 500ms
         * Group: mongodb
         * 
         * @param pollIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder pollIntervalMs(long pollIntervalMs) {
            doSetProperty("pollIntervalMs", pollIntervalMs);
            return this;
        }
        /**
         * Time to wait for new change events to appear after receiving no
         * events, given in milliseconds. Defaults to 500 ms.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 500ms
         * Group: mongodb
         * 
         * @param pollIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder pollIntervalMs(String pollIntervalMs) {
            doSetProperty("pollIntervalMs", pollIntervalMs);
            return this;
        }
        /**
         * Optional list of post processors. The processors are defined using
         * '.type' config option and configured using options ''.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mongodb
         * 
         * @param postProcessors the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder postProcessors(String postProcessors) {
            doSetProperty("postProcessors", postProcessors);
            return this;
        }
        /**
         * Enables transaction metadata extraction together with event counting.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: mongodb
         * 
         * @param provideTransactionMetadata the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder provideTransactionMetadata(boolean provideTransactionMetadata) {
            doSetProperty("provideTransactionMetadata", provideTransactionMetadata);
            return this;
        }
        /**
         * Enables transaction metadata extraction together with event counting.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: mongodb
         * 
         * @param provideTransactionMetadata the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder provideTransactionMetadata(String provideTransactionMetadata) {
            doSetProperty("provideTransactionMetadata", provideTransactionMetadata);
            return this;
        }
        /**
         * The maximum number of records that should be loaded into memory while
         * streaming. A value of '0' uses the default JDBC fetch size.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 0
         * Group: mongodb
         * 
         * @param queryFetchSize the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder queryFetchSize(int queryFetchSize) {
            doSetProperty("queryFetchSize", queryFetchSize);
            return this;
        }
        /**
         * The maximum number of records that should be loaded into memory while
         * streaming. A value of '0' uses the default JDBC fetch size.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 0
         * Group: mongodb
         * 
         * @param queryFetchSize the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder queryFetchSize(String queryFetchSize) {
            doSetProperty("queryFetchSize", queryFetchSize);
            return this;
        }
        /**
         * Time to wait before restarting connector after retriable exception
         * occurs. Defaults to 10000ms.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 10s
         * Group: mongodb
         * 
         * @param retriableRestartConnectorWaitMs the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder retriableRestartConnectorWaitMs(long retriableRestartConnectorWaitMs) {
            doSetProperty("retriableRestartConnectorWaitMs", retriableRestartConnectorWaitMs);
            return this;
        }
        /**
         * Time to wait before restarting connector after retriable exception
         * occurs. Defaults to 10000ms.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 10s
         * Group: mongodb
         * 
         * @param retriableRestartConnectorWaitMs the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder retriableRestartConnectorWaitMs(String retriableRestartConnectorWaitMs) {
            doSetProperty("retriableRestartConnectorWaitMs", retriableRestartConnectorWaitMs);
            return this;
        }
        /**
         * The path to the file that will be used to record the database schema
         * history.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mongodb
         * 
         * @param schemaHistoryInternalFileFilename the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder schemaHistoryInternalFileFilename(String schemaHistoryInternalFileFilename) {
            doSetProperty("schemaHistoryInternalFileFilename", schemaHistoryInternalFileFilename);
            return this;
        }
        /**
         * Specify how schema names should be adjusted for compatibility with
         * the message converter used by the connector, including: 'avro'
         * replaces the characters that cannot be used in the Avro type name
         * with underscore; 'avro_unicode' replaces the underscore or characters
         * that cannot be used in the Avro type name with corresponding unicode
         * like _uxxxx. Note: _ is an escape sequence like backslash in
         * Java;'none' does not apply any adjustment (default).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: none
         * Group: mongodb
         * 
         * @param schemaNameAdjustmentMode the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder schemaNameAdjustmentMode(String schemaNameAdjustmentMode) {
            doSetProperty("schemaNameAdjustmentMode", schemaNameAdjustmentMode);
            return this;
        }
        /**
         * The name of the data collection that is used to send signals/commands
         * to Debezium. Signaling is disabled when not set.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mongodb
         * 
         * @param signalDataCollection the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder signalDataCollection(String signalDataCollection) {
            doSetProperty("signalDataCollection", signalDataCollection);
            return this;
        }
        /**
         * List of channels names that are enabled. Source channel is enabled by
         * default.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: source
         * Group: mongodb
         * 
         * @param signalEnabledChannels the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder signalEnabledChannels(String signalEnabledChannels) {
            doSetProperty("signalEnabledChannels", signalEnabledChannels);
            return this;
        }
        /**
         * Interval for looking for new signals in registered channels, given in
         * milliseconds. Defaults to 5 seconds.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 5s
         * Group: mongodb
         * 
         * @param signalPollIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder signalPollIntervalMs(long signalPollIntervalMs) {
            doSetProperty("signalPollIntervalMs", signalPollIntervalMs);
            return this;
        }
        /**
         * Interval for looking for new signals in registered channels, given in
         * milliseconds. Defaults to 5 seconds.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 5s
         * Group: mongodb
         * 
         * @param signalPollIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder signalPollIntervalMs(String signalPollIntervalMs) {
            doSetProperty("signalPollIntervalMs", signalPollIntervalMs);
            return this;
        }
        /**
         * The comma-separated list of operations to skip during streaming,
         * defined as: 'c' for inserts/create; 'u' for updates; 'd' for deletes,
         * 't' for truncates, and 'none' to indicate nothing skipped. By
         * default, only truncate operations will be skipped.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: t
         * Group: mongodb
         * 
         * @param skippedOperations the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder skippedOperations(String skippedOperations) {
            doSetProperty("skippedOperations", skippedOperations);
            return this;
        }
        /**
         * This property contains a comma-separated list of ., for which the
         * initial snapshot may be a subset of data present in the data source.
         * The subset would be defined by mongodb filter query specified as
         * value for property snapshot.collection.filter.override..
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mongodb
         * 
         * @param snapshotCollectionFilterOverrides the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder snapshotCollectionFilterOverrides(String snapshotCollectionFilterOverrides) {
            doSetProperty("snapshotCollectionFilterOverrides", snapshotCollectionFilterOverrides);
            return this;
        }
        /**
         * A delay period before a snapshot will begin, given in milliseconds.
         * Defaults to 0 ms.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 0ms
         * Group: mongodb
         * 
         * @param snapshotDelayMs the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder snapshotDelayMs(long snapshotDelayMs) {
            doSetProperty("snapshotDelayMs", snapshotDelayMs);
            return this;
        }
        /**
         * A delay period before a snapshot will begin, given in milliseconds.
         * Defaults to 0 ms.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 0ms
         * Group: mongodb
         * 
         * @param snapshotDelayMs the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder snapshotDelayMs(String snapshotDelayMs) {
            doSetProperty("snapshotDelayMs", snapshotDelayMs);
            return this;
        }
        /**
         * The maximum number of records that should be loaded into memory while
         * performing a snapshot.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: mongodb
         * 
         * @param snapshotFetchSize the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder snapshotFetchSize(int snapshotFetchSize) {
            doSetProperty("snapshotFetchSize", snapshotFetchSize);
            return this;
        }
        /**
         * The maximum number of records that should be loaded into memory while
         * performing a snapshot.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: mongodb
         * 
         * @param snapshotFetchSize the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder snapshotFetchSize(String snapshotFetchSize) {
            doSetProperty("snapshotFetchSize", snapshotFetchSize);
            return this;
        }
        /**
         * This setting must be set to specify a list of tables/collections
         * whose snapshot must be taken on creating or restarting the connector.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mongodb
         * 
         * @param snapshotIncludeCollectionList the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder snapshotIncludeCollectionList(String snapshotIncludeCollectionList) {
            doSetProperty("snapshotIncludeCollectionList", snapshotIncludeCollectionList);
            return this;
        }
        /**
         * The maximum number of threads used to perform the snapshot. Defaults
         * to 1.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 1
         * Group: mongodb
         * 
         * @param snapshotMaxThreads the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder snapshotMaxThreads(int snapshotMaxThreads) {
            doSetProperty("snapshotMaxThreads", snapshotMaxThreads);
            return this;
        }
        /**
         * The maximum number of threads used to perform the snapshot. Defaults
         * to 1.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 1
         * Group: mongodb
         * 
         * @param snapshotMaxThreads the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder snapshotMaxThreads(String snapshotMaxThreads) {
            doSetProperty("snapshotMaxThreads", snapshotMaxThreads);
            return this;
        }
        /**
         * The criteria for running a snapshot upon startup of the connector.
         * Select one of the following snapshot options: 'initial' (default): If
         * the connector does not detect any offsets for the logical server
         * name, it runs a snapshot that captures the current full state of the
         * configured tables. After the snapshot completes, the connector begins
         * to stream changes from the oplog. 'never': The connector does not run
         * a snapshot. Upon first startup, the connector immediately begins
         * reading from the beginning of the oplog.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: initial
         * Group: mongodb
         * 
         * @param snapshotMode the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder snapshotMode(String snapshotMode) {
            doSetProperty("snapshotMode", snapshotMode);
            return this;
        }
        /**
         * When 'snapshot.mode' is set as configuration_based, this setting
         * permits to specify whenever the data should be snapshotted or not.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: mongodb
         * 
         * @param snapshotModeConfigurationBasedSnapshotData the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder snapshotModeConfigurationBasedSnapshotData(boolean snapshotModeConfigurationBasedSnapshotData) {
            doSetProperty("snapshotModeConfigurationBasedSnapshotData", snapshotModeConfigurationBasedSnapshotData);
            return this;
        }
        /**
         * When 'snapshot.mode' is set as configuration_based, this setting
         * permits to specify whenever the data should be snapshotted or not.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: mongodb
         * 
         * @param snapshotModeConfigurationBasedSnapshotData the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder snapshotModeConfigurationBasedSnapshotData(String snapshotModeConfigurationBasedSnapshotData) {
            doSetProperty("snapshotModeConfigurationBasedSnapshotData", snapshotModeConfigurationBasedSnapshotData);
            return this;
        }
        /**
         * When 'snapshot.mode' is set as configuration_based, this setting
         * permits to specify whenever the data should be snapshotted or not in
         * case of error.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: mongodb
         * 
         * @param snapshotModeConfigurationBasedSnapshotOnDataError the value to
         * set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder snapshotModeConfigurationBasedSnapshotOnDataError(boolean snapshotModeConfigurationBasedSnapshotOnDataError) {
            doSetProperty("snapshotModeConfigurationBasedSnapshotOnDataError", snapshotModeConfigurationBasedSnapshotOnDataError);
            return this;
        }
        /**
         * When 'snapshot.mode' is set as configuration_based, this setting
         * permits to specify whenever the data should be snapshotted or not in
         * case of error.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: mongodb
         * 
         * @param snapshotModeConfigurationBasedSnapshotOnDataError the value to
         * set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder snapshotModeConfigurationBasedSnapshotOnDataError(String snapshotModeConfigurationBasedSnapshotOnDataError) {
            doSetProperty("snapshotModeConfigurationBasedSnapshotOnDataError", snapshotModeConfigurationBasedSnapshotOnDataError);
            return this;
        }
        /**
         * When 'snapshot.mode' is set as configuration_based, this setting
         * permits to specify whenever the schema should be snapshotted or not
         * in case of error.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: mongodb
         * 
         * @param snapshotModeConfigurationBasedSnapshotOnSchemaError the value
         * to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder snapshotModeConfigurationBasedSnapshotOnSchemaError(boolean snapshotModeConfigurationBasedSnapshotOnSchemaError) {
            doSetProperty("snapshotModeConfigurationBasedSnapshotOnSchemaError", snapshotModeConfigurationBasedSnapshotOnSchemaError);
            return this;
        }
        /**
         * When 'snapshot.mode' is set as configuration_based, this setting
         * permits to specify whenever the schema should be snapshotted or not
         * in case of error.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: mongodb
         * 
         * @param snapshotModeConfigurationBasedSnapshotOnSchemaError the value
         * to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder snapshotModeConfigurationBasedSnapshotOnSchemaError(String snapshotModeConfigurationBasedSnapshotOnSchemaError) {
            doSetProperty("snapshotModeConfigurationBasedSnapshotOnSchemaError", snapshotModeConfigurationBasedSnapshotOnSchemaError);
            return this;
        }
        /**
         * When 'snapshot.mode' is set as configuration_based, this setting
         * permits to specify whenever the schema should be snapshotted or not.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: mongodb
         * 
         * @param snapshotModeConfigurationBasedSnapshotSchema the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder snapshotModeConfigurationBasedSnapshotSchema(boolean snapshotModeConfigurationBasedSnapshotSchema) {
            doSetProperty("snapshotModeConfigurationBasedSnapshotSchema", snapshotModeConfigurationBasedSnapshotSchema);
            return this;
        }
        /**
         * When 'snapshot.mode' is set as configuration_based, this setting
         * permits to specify whenever the schema should be snapshotted or not.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: mongodb
         * 
         * @param snapshotModeConfigurationBasedSnapshotSchema the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder snapshotModeConfigurationBasedSnapshotSchema(String snapshotModeConfigurationBasedSnapshotSchema) {
            doSetProperty("snapshotModeConfigurationBasedSnapshotSchema", snapshotModeConfigurationBasedSnapshotSchema);
            return this;
        }
        /**
         * When 'snapshot.mode' is set as configuration_based, this setting
         * permits to specify whenever the stream should start or not after
         * snapshot.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: mongodb
         * 
         * @param snapshotModeConfigurationBasedStartStream the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder snapshotModeConfigurationBasedStartStream(boolean snapshotModeConfigurationBasedStartStream) {
            doSetProperty("snapshotModeConfigurationBasedStartStream", snapshotModeConfigurationBasedStartStream);
            return this;
        }
        /**
         * When 'snapshot.mode' is set as configuration_based, this setting
         * permits to specify whenever the stream should start or not after
         * snapshot.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: mongodb
         * 
         * @param snapshotModeConfigurationBasedStartStream the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder snapshotModeConfigurationBasedStartStream(String snapshotModeConfigurationBasedStartStream) {
            doSetProperty("snapshotModeConfigurationBasedStartStream", snapshotModeConfigurationBasedStartStream);
            return this;
        }
        /**
         * When 'snapshot.mode' is set as custom, this setting must be set to
         * specify a the name of the custom implementation provided in the
         * 'name()' method. The implementations must implement the 'Snapshotter'
         * interface and is called on each app boot to determine whether to do a
         * snapshot.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mongodb
         * 
         * @param snapshotModeCustomName the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder snapshotModeCustomName(String snapshotModeCustomName) {
            doSetProperty("snapshotModeCustomName", snapshotModeCustomName);
            return this;
        }
        /**
         * The name of the SourceInfoStructMaker class that returns SourceInfo
         * schema and struct.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: io.debezium.connector.mongodb.MongoDbSourceInfoStructMaker
         * Group: mongodb
         * 
         * @param sourceinfoStructMaker the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder sourceinfoStructMaker(String sourceinfoStructMaker) {
            doSetProperty("sourceinfoStructMaker", sourceinfoStructMaker);
            return this;
        }
        /**
         * Whether delete operations should be represented by a delete event and
         * a subsequent tombstone event (true) or only by a delete event
         * (false). Emitting the tombstone event (the default behavior) allows
         * Kafka to completely delete all events pertaining to the given key
         * once the source record got deleted.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: mongodb
         * 
         * @param tombstonesOnDelete the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder tombstonesOnDelete(boolean tombstonesOnDelete) {
            doSetProperty("tombstonesOnDelete", tombstonesOnDelete);
            return this;
        }
        /**
         * Whether delete operations should be represented by a delete event and
         * a subsequent tombstone event (true) or only by a delete event
         * (false). Emitting the tombstone event (the default behavior) allows
         * Kafka to completely delete all events pertaining to the given key
         * once the source record got deleted.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: mongodb
         * 
         * @param tombstonesOnDelete the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder tombstonesOnDelete(String tombstonesOnDelete) {
            doSetProperty("tombstonesOnDelete", tombstonesOnDelete);
            return this;
        }
        /**
         * The name of the TopicNamingStrategy class that should be used to
         * determine the topic name for data change, schema change, transaction,
         * heartbeat event etc.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: io.debezium.schema.SchemaTopicNamingStrategy
         * Group: mongodb
         * 
         * @param topicNamingStrategy the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder topicNamingStrategy(String topicNamingStrategy) {
            doSetProperty("topicNamingStrategy", topicNamingStrategy);
            return this;
        }
        /**
         * Topic prefix that identifies and provides a namespace for the
         * particular database server/cluster is capturing changes. The topic
         * prefix should be unique across all other connectors, since it is used
         * as a prefix for all Kafka topic names that receive events emitted by
         * this connector. Only alphanumeric characters, hyphens, dots and
         * underscores must be accepted.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: mongodb
         * 
         * @param topicPrefix the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder topicPrefix(String topicPrefix) {
            doSetProperty("topicPrefix", topicPrefix);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Debezium MongoDB Connector component.
     */
    public interface AdvancedDebeziumMongodbEndpointBuilder
            extends
                EndpointConsumerBuilder {
        default DebeziumMongodbEndpointBuilder basic() {
            return (DebeziumMongodbEndpointBuilder) this;
        }

        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedDebeziumMongodbEndpointBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedDebeziumMongodbEndpointBuilder bridgeErrorHandler(String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedDebeziumMongodbEndpointBuilder exceptionHandler(org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedDebeziumMongodbEndpointBuilder exceptionHandler(String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedDebeziumMongodbEndpointBuilder exchangePattern(org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedDebeziumMongodbEndpointBuilder exchangePattern(String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
    }

    public interface DebeziumMongodbBuilders {
        /**
         * Debezium MongoDB Connector (camel-debezium-mongodb)
         * Capture changes from a MongoDB database.
         * 
         * Category: database
         * Since: 3.0
         * Maven coordinates: org.apache.camel:camel-debezium-mongodb
         * 
         * @return the dsl builder for the headers' name.
         */
        default DebeziumMongodbHeaderNameBuilder debeziumMongodb() {
            return DebeziumMongodbHeaderNameBuilder.INSTANCE;
        }
        /**
         * Debezium MongoDB Connector (camel-debezium-mongodb)
         * Capture changes from a MongoDB database.
         * 
         * Category: database
         * Since: 3.0
         * Maven coordinates: org.apache.camel:camel-debezium-mongodb
         * 
         * Syntax: <code>debezium-mongodb:name</code>
         * 
         * Path parameter: name (required)
         * Unique name for the connector. Attempting to register again with the
         * same name will fail.
         * 
         * @param path name
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder debeziumMongodb(String path) {
            return DebeziumMongodbEndpointBuilderFactory.endpointBuilder("debezium-mongodb", path);
        }
        /**
         * Debezium MongoDB Connector (camel-debezium-mongodb)
         * Capture changes from a MongoDB database.
         * 
         * Category: database
         * Since: 3.0
         * Maven coordinates: org.apache.camel:camel-debezium-mongodb
         * 
         * Syntax: <code>debezium-mongodb:name</code>
         * 
         * Path parameter: name (required)
         * Unique name for the connector. Attempting to register again with the
         * same name will fail.
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path name
         * @return the dsl builder
         */
        default DebeziumMongodbEndpointBuilder debeziumMongodb(String componentName, String path) {
            return DebeziumMongodbEndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the Debezium MongoDB Connector component.
     */
    public static class DebeziumMongodbHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final DebeziumMongodbHeaderNameBuilder INSTANCE = new DebeziumMongodbHeaderNameBuilder();

        /**
         * The metadata about the source event, for example table name, database
         * name, log position, etc, please refer to the Debezium documentation
         * for more info.
         * 
         * The option is a: {@code Map<String, Object>} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code DebeziumSourceMetadata}.
         */
        public String debeziumSourceMetadata() {
            return "CamelDebeziumSourceMetadata";
        }
        /**
         * The identifier of the connector, normally is this format
         * {server-name}.{database-name}.{table-name}.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code DebeziumIdentifier}.
         */
        public String debeziumIdentifier() {
            return "CamelDebeziumIdentifier";
        }
        /**
         * The key of the event, normally is the table Primary Key.
         * 
         * The option is a: {@code Struct} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code DebeziumKey}.
         */
        public String debeziumKey() {
            return "CamelDebeziumKey";
        }
        /**
         * If presents, the type of event operation. Values for the connector
         * are c for create (or insert), u for update, d for delete or r for
         * read (in the case of a initial sync) or in case of a snapshot event.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code DebeziumOperation}.
         */
        public String debeziumOperation() {
            return "CamelDebeziumOperation";
        }
        /**
         * If presents, the time (using the system clock in the JVM) at which
         * the connector processed the event.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code DebeziumTimestamp}.
         */
        public String debeziumTimestamp() {
            return "CamelDebeziumTimestamp";
        }
        /**
         * If presents, contains the state of the row before the event occurred.
         * 
         * The option is a: {@code Struct} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code DebeziumBefore}.
         */
        public String debeziumBefore() {
            return "CamelDebeziumBefore";
        }
        /**
         * If presents, the ddl sql text of the event.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code DebeziumDdlSQL}.
         */
        public String debeziumDdlSQL() {
            return "CamelDebeziumDdlSQL";
        }
    }
    static DebeziumMongodbEndpointBuilder endpointBuilder(String componentName, String path) {
        class DebeziumMongodbEndpointBuilderImpl extends AbstractEndpointBuilder implements DebeziumMongodbEndpointBuilder, AdvancedDebeziumMongodbEndpointBuilder {
            public DebeziumMongodbEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new DebeziumMongodbEndpointBuilderImpl(path);
    }
}