/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Perform operations on Openshift Deployment Configs and get notified on
 * Deployment Config changes.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface OpenshiftDeploymentConfigsEndpointBuilderFactory {

    /**
     * Builder for endpoint consumers for the Openshift Deployment Configs component.
     */
    public interface OpenshiftDeploymentConfigsEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedOpenshiftDeploymentConfigsEndpointConsumerBuilder advanced() {
            return (AdvancedOpenshiftDeploymentConfigsEndpointConsumerBuilder) this;
        }
        /**
         * The Kubernetes API Version to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param apiVersion the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointConsumerBuilder apiVersion(String apiVersion) {
            doSetProperty("apiVersion", apiVersion);
            return this;
        }
        /**
         * The dns domain, used for ServiceCall EIP.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param dnsDomain the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointConsumerBuilder dnsDomain(String dnsDomain) {
            doSetProperty("dnsDomain", dnsDomain);
            return this;
        }
        /**
         * Default KubernetesClient to use if provided.
         * 
         * The option is a:
         * <code>io.fabric8.kubernetes.client.KubernetesClient</code> type.
         * 
         * Group: common
         * 
         * @param kubernetesClient the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointConsumerBuilder kubernetesClient(io.fabric8.kubernetes.client.KubernetesClient kubernetesClient) {
            doSetProperty("kubernetesClient", kubernetesClient);
            return this;
        }
        /**
         * Default KubernetesClient to use if provided.
         * 
         * The option will be converted to a
         * <code>io.fabric8.kubernetes.client.KubernetesClient</code> type.
         * 
         * Group: common
         * 
         * @param kubernetesClient the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointConsumerBuilder kubernetesClient(String kubernetesClient) {
            doSetProperty("kubernetesClient", kubernetesClient);
            return this;
        }
        /**
         * The namespace.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param namespace the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointConsumerBuilder namespace(String namespace) {
            doSetProperty("namespace", namespace);
            return this;
        }
        /**
         * The port name, used for ServiceCall EIP.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param portName the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointConsumerBuilder portName(String portName) {
            doSetProperty("portName", portName);
            return this;
        }
        /**
         * The port protocol, used for ServiceCall EIP.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: tcp
         * Group: common
         * 
         * @param portProtocol the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointConsumerBuilder portProtocol(String portProtocol) {
            doSetProperty("portProtocol", portProtocol);
            return this;
        }
        /**
         * The Consumer CRD Resource Group we would like to watch.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         * 
         * @param crdGroup the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointConsumerBuilder crdGroup(String crdGroup) {
            doSetProperty("crdGroup", crdGroup);
            return this;
        }
        /**
         * The Consumer CRD Resource name we would like to watch.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         * 
         * @param crdName the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointConsumerBuilder crdName(String crdName) {
            doSetProperty("crdName", crdName);
            return this;
        }
        /**
         * The Consumer CRD Resource Plural we would like to watch.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         * 
         * @param crdPlural the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointConsumerBuilder crdPlural(String crdPlural) {
            doSetProperty("crdPlural", crdPlural);
            return this;
        }
        /**
         * The Consumer CRD Resource Scope we would like to watch.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         * 
         * @param crdScope the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointConsumerBuilder crdScope(String crdScope) {
            doSetProperty("crdScope", crdScope);
            return this;
        }
        /**
         * The Consumer CRD Resource Version we would like to watch.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         * 
         * @param crdVersion the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointConsumerBuilder crdVersion(String crdVersion) {
            doSetProperty("crdVersion", crdVersion);
            return this;
        }
        /**
         * The Consumer Label key when watching at some resources.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         * 
         * @param labelKey the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointConsumerBuilder labelKey(String labelKey) {
            doSetProperty("labelKey", labelKey);
            return this;
        }
        /**
         * The Consumer Label value when watching at some resources.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         * 
         * @param labelValue the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointConsumerBuilder labelValue(String labelValue) {
            doSetProperty("labelValue", labelValue);
            return this;
        }
        /**
         * The Consumer pool size.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 1
         * Group: consumer
         * 
         * @param poolSize the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointConsumerBuilder poolSize(int poolSize) {
            doSetProperty("poolSize", poolSize);
            return this;
        }
        /**
         * The Consumer pool size.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 1
         * Group: consumer
         * 
         * @param poolSize the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointConsumerBuilder poolSize(String poolSize) {
            doSetProperty("poolSize", poolSize);
            return this;
        }
        /**
         * The Consumer Resource Name we would like to watch.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         * 
         * @param resourceName the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointConsumerBuilder resourceName(String resourceName) {
            doSetProperty("resourceName", resourceName);
            return this;
        }
        /**
         * The CA Cert Data.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param caCertData the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointConsumerBuilder caCertData(String caCertData) {
            doSetProperty("caCertData", caCertData);
            return this;
        }
        /**
         * The CA Cert File.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param caCertFile the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointConsumerBuilder caCertFile(String caCertFile) {
            doSetProperty("caCertFile", caCertFile);
            return this;
        }
        /**
         * The Client Cert Data.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param clientCertData the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointConsumerBuilder clientCertData(String clientCertData) {
            doSetProperty("clientCertData", clientCertData);
            return this;
        }
        /**
         * The Client Cert File.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param clientCertFile the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointConsumerBuilder clientCertFile(String clientCertFile) {
            doSetProperty("clientCertFile", clientCertFile);
            return this;
        }
        /**
         * The Key Algorithm used by the client.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param clientKeyAlgo the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointConsumerBuilder clientKeyAlgo(String clientKeyAlgo) {
            doSetProperty("clientKeyAlgo", clientKeyAlgo);
            return this;
        }
        /**
         * The Client Key data.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param clientKeyData the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointConsumerBuilder clientKeyData(String clientKeyData) {
            doSetProperty("clientKeyData", clientKeyData);
            return this;
        }
        /**
         * The Client Key file.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param clientKeyFile the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointConsumerBuilder clientKeyFile(String clientKeyFile) {
            doSetProperty("clientKeyFile", clientKeyFile);
            return this;
        }
        /**
         * The Client Key Passphrase.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param clientKeyPassphrase the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointConsumerBuilder clientKeyPassphrase(String clientKeyPassphrase) {
            doSetProperty("clientKeyPassphrase", clientKeyPassphrase);
            return this;
        }
        /**
         * The Auth Token.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param oauthToken the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointConsumerBuilder oauthToken(String oauthToken) {
            doSetProperty("oauthToken", oauthToken);
            return this;
        }
        /**
         * Password to connect to Kubernetes.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointConsumerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Define if the certs we used are trusted anyway or not.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: security
         * 
         * @param trustCerts the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointConsumerBuilder trustCerts(Boolean trustCerts) {
            doSetProperty("trustCerts", trustCerts);
            return this;
        }
        /**
         * Define if the certs we used are trusted anyway or not.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: security
         * 
         * @param trustCerts the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointConsumerBuilder trustCerts(String trustCerts) {
            doSetProperty("trustCerts", trustCerts);
            return this;
        }
        /**
         * Username to connect to Kubernetes.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointConsumerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Openshift Deployment Configs component.
     */
    public interface AdvancedOpenshiftDeploymentConfigsEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default OpenshiftDeploymentConfigsEndpointConsumerBuilder basic() {
            return (OpenshiftDeploymentConfigsEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedOpenshiftDeploymentConfigsEndpointConsumerBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedOpenshiftDeploymentConfigsEndpointConsumerBuilder bridgeErrorHandler(String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedOpenshiftDeploymentConfigsEndpointConsumerBuilder exceptionHandler(org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedOpenshiftDeploymentConfigsEndpointConsumerBuilder exceptionHandler(String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedOpenshiftDeploymentConfigsEndpointConsumerBuilder exchangePattern(org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedOpenshiftDeploymentConfigsEndpointConsumerBuilder exchangePattern(String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Connection timeout in milliseconds to use when making requests to the
         * Kubernetes API server.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: advanced
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedOpenshiftDeploymentConfigsEndpointConsumerBuilder connectionTimeout(Integer connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Connection timeout in milliseconds to use when making requests to the
         * Kubernetes API server.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedOpenshiftDeploymentConfigsEndpointConsumerBuilder connectionTimeout(String connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Openshift Deployment Configs component.
     */
    public interface OpenshiftDeploymentConfigsEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedOpenshiftDeploymentConfigsEndpointProducerBuilder advanced() {
            return (AdvancedOpenshiftDeploymentConfigsEndpointProducerBuilder) this;
        }

        /**
         * The Kubernetes API Version to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param apiVersion the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointProducerBuilder apiVersion(String apiVersion) {
            doSetProperty("apiVersion", apiVersion);
            return this;
        }
        /**
         * The dns domain, used for ServiceCall EIP.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param dnsDomain the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointProducerBuilder dnsDomain(String dnsDomain) {
            doSetProperty("dnsDomain", dnsDomain);
            return this;
        }
        /**
         * Default KubernetesClient to use if provided.
         * 
         * The option is a:
         * <code>io.fabric8.kubernetes.client.KubernetesClient</code> type.
         * 
         * Group: common
         * 
         * @param kubernetesClient the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointProducerBuilder kubernetesClient(io.fabric8.kubernetes.client.KubernetesClient kubernetesClient) {
            doSetProperty("kubernetesClient", kubernetesClient);
            return this;
        }
        /**
         * Default KubernetesClient to use if provided.
         * 
         * The option will be converted to a
         * <code>io.fabric8.kubernetes.client.KubernetesClient</code> type.
         * 
         * Group: common
         * 
         * @param kubernetesClient the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointProducerBuilder kubernetesClient(String kubernetesClient) {
            doSetProperty("kubernetesClient", kubernetesClient);
            return this;
        }
        /**
         * The namespace.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param namespace the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointProducerBuilder namespace(String namespace) {
            doSetProperty("namespace", namespace);
            return this;
        }
        /**
         * The port name, used for ServiceCall EIP.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param portName the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointProducerBuilder portName(String portName) {
            doSetProperty("portName", portName);
            return this;
        }
        /**
         * The port protocol, used for ServiceCall EIP.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: tcp
         * Group: common
         * 
         * @param portProtocol the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointProducerBuilder portProtocol(String portProtocol) {
            doSetProperty("portProtocol", portProtocol);
            return this;
        }
        /**
         * Producer operation to do on Kubernetes.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointProducerBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * The CA Cert Data.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param caCertData the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointProducerBuilder caCertData(String caCertData) {
            doSetProperty("caCertData", caCertData);
            return this;
        }
        /**
         * The CA Cert File.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param caCertFile the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointProducerBuilder caCertFile(String caCertFile) {
            doSetProperty("caCertFile", caCertFile);
            return this;
        }
        /**
         * The Client Cert Data.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param clientCertData the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointProducerBuilder clientCertData(String clientCertData) {
            doSetProperty("clientCertData", clientCertData);
            return this;
        }
        /**
         * The Client Cert File.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param clientCertFile the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointProducerBuilder clientCertFile(String clientCertFile) {
            doSetProperty("clientCertFile", clientCertFile);
            return this;
        }
        /**
         * The Key Algorithm used by the client.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param clientKeyAlgo the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointProducerBuilder clientKeyAlgo(String clientKeyAlgo) {
            doSetProperty("clientKeyAlgo", clientKeyAlgo);
            return this;
        }
        /**
         * The Client Key data.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param clientKeyData the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointProducerBuilder clientKeyData(String clientKeyData) {
            doSetProperty("clientKeyData", clientKeyData);
            return this;
        }
        /**
         * The Client Key file.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param clientKeyFile the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointProducerBuilder clientKeyFile(String clientKeyFile) {
            doSetProperty("clientKeyFile", clientKeyFile);
            return this;
        }
        /**
         * The Client Key Passphrase.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param clientKeyPassphrase the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointProducerBuilder clientKeyPassphrase(String clientKeyPassphrase) {
            doSetProperty("clientKeyPassphrase", clientKeyPassphrase);
            return this;
        }
        /**
         * The Auth Token.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param oauthToken the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointProducerBuilder oauthToken(String oauthToken) {
            doSetProperty("oauthToken", oauthToken);
            return this;
        }
        /**
         * Password to connect to Kubernetes.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointProducerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Define if the certs we used are trusted anyway or not.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: security
         * 
         * @param trustCerts the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointProducerBuilder trustCerts(Boolean trustCerts) {
            doSetProperty("trustCerts", trustCerts);
            return this;
        }
        /**
         * Define if the certs we used are trusted anyway or not.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: security
         * 
         * @param trustCerts the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointProducerBuilder trustCerts(String trustCerts) {
            doSetProperty("trustCerts", trustCerts);
            return this;
        }
        /**
         * Username to connect to Kubernetes.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointProducerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Openshift Deployment Configs component.
     */
    public interface AdvancedOpenshiftDeploymentConfigsEndpointProducerBuilder extends EndpointProducerBuilder {
        default OpenshiftDeploymentConfigsEndpointProducerBuilder basic() {
            return (OpenshiftDeploymentConfigsEndpointProducerBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedOpenshiftDeploymentConfigsEndpointProducerBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedOpenshiftDeploymentConfigsEndpointProducerBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Connection timeout in milliseconds to use when making requests to the
         * Kubernetes API server.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: advanced
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedOpenshiftDeploymentConfigsEndpointProducerBuilder connectionTimeout(Integer connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Connection timeout in milliseconds to use when making requests to the
         * Kubernetes API server.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedOpenshiftDeploymentConfigsEndpointProducerBuilder connectionTimeout(String connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Openshift Deployment Configs component.
     */
    public interface OpenshiftDeploymentConfigsEndpointBuilder
            extends
                OpenshiftDeploymentConfigsEndpointConsumerBuilder,
                OpenshiftDeploymentConfigsEndpointProducerBuilder {
        default AdvancedOpenshiftDeploymentConfigsEndpointBuilder advanced() {
            return (AdvancedOpenshiftDeploymentConfigsEndpointBuilder) this;
        }

        /**
         * The Kubernetes API Version to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param apiVersion the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointBuilder apiVersion(String apiVersion) {
            doSetProperty("apiVersion", apiVersion);
            return this;
        }
        /**
         * The dns domain, used for ServiceCall EIP.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param dnsDomain the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointBuilder dnsDomain(String dnsDomain) {
            doSetProperty("dnsDomain", dnsDomain);
            return this;
        }
        /**
         * Default KubernetesClient to use if provided.
         * 
         * The option is a:
         * <code>io.fabric8.kubernetes.client.KubernetesClient</code> type.
         * 
         * Group: common
         * 
         * @param kubernetesClient the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointBuilder kubernetesClient(io.fabric8.kubernetes.client.KubernetesClient kubernetesClient) {
            doSetProperty("kubernetesClient", kubernetesClient);
            return this;
        }
        /**
         * Default KubernetesClient to use if provided.
         * 
         * The option will be converted to a
         * <code>io.fabric8.kubernetes.client.KubernetesClient</code> type.
         * 
         * Group: common
         * 
         * @param kubernetesClient the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointBuilder kubernetesClient(String kubernetesClient) {
            doSetProperty("kubernetesClient", kubernetesClient);
            return this;
        }
        /**
         * The namespace.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param namespace the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointBuilder namespace(String namespace) {
            doSetProperty("namespace", namespace);
            return this;
        }
        /**
         * The port name, used for ServiceCall EIP.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param portName the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointBuilder portName(String portName) {
            doSetProperty("portName", portName);
            return this;
        }
        /**
         * The port protocol, used for ServiceCall EIP.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: tcp
         * Group: common
         * 
         * @param portProtocol the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointBuilder portProtocol(String portProtocol) {
            doSetProperty("portProtocol", portProtocol);
            return this;
        }
        /**
         * The CA Cert Data.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param caCertData the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointBuilder caCertData(String caCertData) {
            doSetProperty("caCertData", caCertData);
            return this;
        }
        /**
         * The CA Cert File.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param caCertFile the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointBuilder caCertFile(String caCertFile) {
            doSetProperty("caCertFile", caCertFile);
            return this;
        }
        /**
         * The Client Cert Data.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param clientCertData the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointBuilder clientCertData(String clientCertData) {
            doSetProperty("clientCertData", clientCertData);
            return this;
        }
        /**
         * The Client Cert File.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param clientCertFile the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointBuilder clientCertFile(String clientCertFile) {
            doSetProperty("clientCertFile", clientCertFile);
            return this;
        }
        /**
         * The Key Algorithm used by the client.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param clientKeyAlgo the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointBuilder clientKeyAlgo(String clientKeyAlgo) {
            doSetProperty("clientKeyAlgo", clientKeyAlgo);
            return this;
        }
        /**
         * The Client Key data.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param clientKeyData the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointBuilder clientKeyData(String clientKeyData) {
            doSetProperty("clientKeyData", clientKeyData);
            return this;
        }
        /**
         * The Client Key file.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param clientKeyFile the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointBuilder clientKeyFile(String clientKeyFile) {
            doSetProperty("clientKeyFile", clientKeyFile);
            return this;
        }
        /**
         * The Client Key Passphrase.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param clientKeyPassphrase the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointBuilder clientKeyPassphrase(String clientKeyPassphrase) {
            doSetProperty("clientKeyPassphrase", clientKeyPassphrase);
            return this;
        }
        /**
         * The Auth Token.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param oauthToken the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointBuilder oauthToken(String oauthToken) {
            doSetProperty("oauthToken", oauthToken);
            return this;
        }
        /**
         * Password to connect to Kubernetes.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Define if the certs we used are trusted anyway or not.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: security
         * 
         * @param trustCerts the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointBuilder trustCerts(Boolean trustCerts) {
            doSetProperty("trustCerts", trustCerts);
            return this;
        }
        /**
         * Define if the certs we used are trusted anyway or not.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: security
         * 
         * @param trustCerts the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointBuilder trustCerts(String trustCerts) {
            doSetProperty("trustCerts", trustCerts);
            return this;
        }
        /**
         * Username to connect to Kubernetes.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Openshift Deployment Configs component.
     */
    public interface AdvancedOpenshiftDeploymentConfigsEndpointBuilder
            extends
                AdvancedOpenshiftDeploymentConfigsEndpointConsumerBuilder,
                AdvancedOpenshiftDeploymentConfigsEndpointProducerBuilder {
        default OpenshiftDeploymentConfigsEndpointBuilder basic() {
            return (OpenshiftDeploymentConfigsEndpointBuilder) this;
        }

        /**
         * Connection timeout in milliseconds to use when making requests to the
         * Kubernetes API server.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: advanced
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedOpenshiftDeploymentConfigsEndpointBuilder connectionTimeout(Integer connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Connection timeout in milliseconds to use when making requests to the
         * Kubernetes API server.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedOpenshiftDeploymentConfigsEndpointBuilder connectionTimeout(String connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
    }

    public interface OpenshiftDeploymentConfigsBuilders {
        /**
         * Openshift Deployment Configs (camel-kubernetes)
         * Perform operations on Openshift Deployment Configs and get notified
         * on Deployment Config changes.
         * 
         * Category: container,cloud
         * Since: 3.18
         * Maven coordinates: org.apache.camel:camel-kubernetes
         * 
         * @return the dsl builder for the headers' name.
         */
        default OpenshiftDeploymentConfigsHeaderNameBuilder openshiftDeploymentconfigs() {
            return OpenshiftDeploymentConfigsHeaderNameBuilder.INSTANCE;
        }
        /**
         * Openshift Deployment Configs (camel-kubernetes)
         * Perform operations on Openshift Deployment Configs and get notified
         * on Deployment Config changes.
         * 
         * Category: container,cloud
         * Since: 3.18
         * Maven coordinates: org.apache.camel:camel-kubernetes
         * 
         * Syntax: <code>openshift-deploymentconfigs:masterUrl</code>
         * 
         * Path parameter: masterUrl (required)
         * URL to a remote Kubernetes API server. This should only be used when
         * your Camel application is connecting from outside Kubernetes. If you
         * run your Camel application inside Kubernetes, then you can use local
         * or client as the URL to tell Camel to run in local mode. If you
         * connect remotely to Kubernetes, then you may also need some of the
         * many other configuration options for secured connection with
         * certificates, etc.
         * 
         * @param path masterUrl
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointBuilder openshiftDeploymentconfigs(String path) {
            return OpenshiftDeploymentConfigsEndpointBuilderFactory.endpointBuilder("openshift-deploymentconfigs", path);
        }
        /**
         * Openshift Deployment Configs (camel-kubernetes)
         * Perform operations on Openshift Deployment Configs and get notified
         * on Deployment Config changes.
         * 
         * Category: container,cloud
         * Since: 3.18
         * Maven coordinates: org.apache.camel:camel-kubernetes
         * 
         * Syntax: <code>openshift-deploymentconfigs:masterUrl</code>
         * 
         * Path parameter: masterUrl (required)
         * URL to a remote Kubernetes API server. This should only be used when
         * your Camel application is connecting from outside Kubernetes. If you
         * run your Camel application inside Kubernetes, then you can use local
         * or client as the URL to tell Camel to run in local mode. If you
         * connect remotely to Kubernetes, then you may also need some of the
         * many other configuration options for secured connection with
         * certificates, etc.
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path masterUrl
         * @return the dsl builder
         */
        default OpenshiftDeploymentConfigsEndpointBuilder openshiftDeploymentconfigs(String componentName, String path) {
            return OpenshiftDeploymentConfigsEndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the Openshift Deployment Configs component.
     */
    public static class OpenshiftDeploymentConfigsHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final OpenshiftDeploymentConfigsHeaderNameBuilder INSTANCE = new OpenshiftDeploymentConfigsHeaderNameBuilder();

        /**
         * The Producer operation.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code KubernetesOperation}.
         */
        public String kubernetesOperation() {
            return "CamelKubernetesOperation";
        }
        /**
         * The namespace name.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code KubernetesNamespaceName}.
         */
        public String kubernetesNamespaceName() {
            return "CamelKubernetesNamespaceName";
        }
        /**
         * The deployment labels.
         * 
         * The option is a: {@code Map<String, String>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code KubernetesDeploymentsLabels}.
         */
        public String kubernetesDeploymentsLabels() {
            return "CamelKubernetesDeploymentsLabels";
        }
        /**
         * The deployment name.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code KubernetesDeploymentName}.
         */
        public String kubernetesDeploymentName() {
            return "CamelKubernetesDeploymentName";
        }
        /**
         * The desired instance count.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code KubernetesDeploymentReplicas}.
         */
        public String kubernetesDeploymentReplicas() {
            return "CamelKubernetesDeploymentReplicas";
        }
        /**
         * The spec for a deployment config.
         * 
         * The option is a: {@code
         * io.fabric8.openshift.api.model.DeploymentConfigSpec} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * KubernetesDeploymentConfigSpec}.
         */
        public String kubernetesDeploymentConfigSpec() {
            return "CamelKubernetesDeploymentConfigSpec";
        }
        /**
         * Action watched by the consumer.
         * 
         * The option is a: {@code io.fabric8.kubernetes.client.Watcher.Action}
         * type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code KubernetesEventAction}.
         */
        public String kubernetesEventAction() {
            return "CamelKubernetesEventAction";
        }
        /**
         * Timestamp of the action watched by the consumer.
         * 
         * The option is a: {@code long} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code KubernetesEventTimestamp}.
         */
        public String kubernetesEventTimestamp() {
            return "CamelKubernetesEventTimestamp";
        }
    }
    static OpenshiftDeploymentConfigsEndpointBuilder endpointBuilder(String componentName, String path) {
        class OpenshiftDeploymentConfigsEndpointBuilderImpl extends AbstractEndpointBuilder implements OpenshiftDeploymentConfigsEndpointBuilder, AdvancedOpenshiftDeploymentConfigsEndpointBuilder {
            public OpenshiftDeploymentConfigsEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new OpenshiftDeploymentConfigsEndpointBuilderImpl(path);
    }
}