/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.endpoint.dsl;

import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.amqp.AmqpTransportType;
import com.azure.core.amqp.ProxyOptions;
import com.azure.core.credential.TokenCredential;
import com.azure.core.util.ClientOptions;
import com.azure.messaging.servicebus.ServiceBusProcessorClient;
import com.azure.messaging.servicebus.ServiceBusSenderClient;
import com.azure.messaging.servicebus.ServiceBusTransactionContext;
import com.azure.messaging.servicebus.models.ServiceBusReceiveMode;
import com.azure.messaging.servicebus.models.SubQueue;
import java.time.Duration;
import java.time.OffsetDateTime;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.component.azure.servicebus.CredentialType;
import org.apache.camel.component.azure.servicebus.ServiceBusProducerOperationDefinition;
import org.apache.camel.component.azure.servicebus.ServiceBusType;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.HeaderFilterStrategy;

public interface ServiceBusEndpointBuilderFactory {
    public static ServiceBusEndpointBuilder endpointBuilder(String componentName, String path) {
        class ServiceBusEndpointBuilderImpl
        extends AbstractEndpointBuilder
        implements ServiceBusEndpointBuilder,
        AdvancedServiceBusEndpointBuilder {
            final /* synthetic */ String val$componentName;

            public ServiceBusEndpointBuilderImpl(String path, String string) {
                this.val$componentName = string;
                super(string, path);
            }
        }
        return new ServiceBusEndpointBuilderImpl(path, componentName);
    }

    public static class ServiceBusHeaderNameBuilder {
        private static final ServiceBusHeaderNameBuilder INSTANCE = new ServiceBusHeaderNameBuilder();

        public String azureServiceBusApplicationProperties() {
            return "CamelAzureServiceBusApplicationProperties";
        }

        public String azureServiceBusContentType() {
            return "CamelAzureServiceBusContentType";
        }

        public String azureServiceBusDeadLetterErrorDescription() {
            return "CamelAzureServiceBusDeadLetterErrorDescription";
        }

        public String azureServiceBusDeadLetterReason() {
            return "CamelAzureServiceBusDeadLetterReason";
        }

        public String azureServiceBusDeadLetterSource() {
            return "CamelAzureServiceBusDeadLetterSource";
        }

        public String azureServiceBusDeliveryCount() {
            return "CamelAzureServiceBusDeliveryCount";
        }

        public String azureServiceBusEnqueuedSequenceNumber() {
            return "CamelAzureServiceBusEnqueuedSequenceNumber";
        }

        public String azureServiceBusEnqueuedTime() {
            return "CamelAzureServiceBusEnqueuedTime";
        }

        public String azureServiceBusExpiresAt() {
            return "CamelAzureServiceBusExpiresAt";
        }

        public String azureServiceBusLockToken() {
            return "CamelAzureServiceBusLockToken";
        }

        public String azureServiceBusLockedUntil() {
            return "CamelAzureServiceBusLockedUntil";
        }

        public String azureServiceBusMessageId() {
            return "CamelAzureServiceBusMessageId";
        }

        public String azureServiceBusPartitionKey() {
            return "CamelAzureServiceBusPartitionKey";
        }

        public String azureServiceBusRawAmqpMessage() {
            return "CamelAzureServiceBusRawAmqpMessage";
        }

        public String azureServiceBusReplyTo() {
            return "CamelAzureServiceBusReplyTo";
        }

        public String azureServiceBusReplyToSessionId() {
            return "CamelAzureServiceBusReplyToSessionId";
        }

        public String azureServiceBusSequenceNumber() {
            return "CamelAzureServiceBusSequenceNumber";
        }

        public String azureServiceBusSessionId() {
            return "CamelAzureServiceBusSessionId";
        }

        public String azureServiceBusSubject() {
            return "CamelAzureServiceBusSubject";
        }

        public String azureServiceBusTimeToLive() {
            return "CamelAzureServiceBusTimeToLive";
        }

        public String azureServiceBusTo() {
            return "CamelAzureServiceBusTo";
        }

        public String azureServiceBusScheduledEnqueueTime() {
            return "CamelAzureServiceBusScheduledEnqueueTime";
        }

        public String azureServiceBusServiceBusTransactionContext() {
            return "CamelAzureServiceBusServiceBusTransactionContext";
        }

        public String azureServiceBusProducerOperation() {
            return "CamelAzureServiceBusProducerOperation";
        }

        public String azureServiceBusCorrelationId() {
            return "CamelAzureServiceBusCorrelationId";
        }
    }

    public static interface ServiceBusBuilders {
        default public ServiceBusHeaderNameBuilder azureServicebus() {
            return ServiceBusHeaderNameBuilder.INSTANCE;
        }

        default public ServiceBusEndpointBuilder azureServicebus(String path) {
            return ServiceBusEndpointBuilderFactory.endpointBuilder("azure-servicebus", path);
        }

        default public ServiceBusEndpointBuilder azureServicebus(String componentName, String path) {
            return ServiceBusEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    public static interface AdvancedServiceBusEndpointBuilder
    extends AdvancedServiceBusEndpointConsumerBuilder,
    AdvancedServiceBusEndpointProducerBuilder {
        @Override
        default public ServiceBusEndpointBuilder basic() {
            return (ServiceBusEndpointBuilder)((Object)this);
        }
    }

    public static interface ServiceBusEndpointBuilder
    extends ServiceBusEndpointConsumerBuilder,
    ServiceBusEndpointProducerBuilder {
        @Override
        default public AdvancedServiceBusEndpointBuilder advanced() {
            return (AdvancedServiceBusEndpointBuilder)((Object)this);
        }

        @Override
        default public ServiceBusEndpointBuilder amqpRetryOptions(AmqpRetryOptions amqpRetryOptions) {
            this.doSetProperty("amqpRetryOptions", amqpRetryOptions);
            return this;
        }

        @Override
        default public ServiceBusEndpointBuilder amqpRetryOptions(String amqpRetryOptions) {
            this.doSetProperty("amqpRetryOptions", amqpRetryOptions);
            return this;
        }

        @Override
        default public ServiceBusEndpointBuilder amqpTransportType(AmqpTransportType amqpTransportType) {
            this.doSetProperty("amqpTransportType", amqpTransportType);
            return this;
        }

        @Override
        default public ServiceBusEndpointBuilder amqpTransportType(String amqpTransportType) {
            this.doSetProperty("amqpTransportType", amqpTransportType);
            return this;
        }

        @Override
        default public ServiceBusEndpointBuilder clientOptions(ClientOptions clientOptions) {
            this.doSetProperty("clientOptions", clientOptions);
            return this;
        }

        @Override
        default public ServiceBusEndpointBuilder clientOptions(String clientOptions) {
            this.doSetProperty("clientOptions", clientOptions);
            return this;
        }

        @Override
        default public ServiceBusEndpointBuilder headerFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
            this.doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }

        @Override
        default public ServiceBusEndpointBuilder headerFilterStrategy(String headerFilterStrategy) {
            this.doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }

        @Override
        default public ServiceBusEndpointBuilder proxyOptions(ProxyOptions proxyOptions) {
            this.doSetProperty("proxyOptions", proxyOptions);
            return this;
        }

        @Override
        default public ServiceBusEndpointBuilder proxyOptions(String proxyOptions) {
            this.doSetProperty("proxyOptions", proxyOptions);
            return this;
        }

        @Override
        default public ServiceBusEndpointBuilder serviceBusType(ServiceBusType serviceBusType) {
            this.doSetProperty("serviceBusType", serviceBusType);
            return this;
        }

        @Override
        default public ServiceBusEndpointBuilder serviceBusType(String serviceBusType) {
            this.doSetProperty("serviceBusType", serviceBusType);
            return this;
        }

        @Override
        default public ServiceBusEndpointBuilder connectionString(String connectionString) {
            this.doSetProperty("connectionString", connectionString);
            return this;
        }

        @Override
        default public ServiceBusEndpointBuilder credentialType(CredentialType credentialType) {
            this.doSetProperty("credentialType", credentialType);
            return this;
        }

        @Override
        default public ServiceBusEndpointBuilder credentialType(String credentialType) {
            this.doSetProperty("credentialType", credentialType);
            return this;
        }

        @Override
        default public ServiceBusEndpointBuilder fullyQualifiedNamespace(String fullyQualifiedNamespace) {
            this.doSetProperty("fullyQualifiedNamespace", fullyQualifiedNamespace);
            return this;
        }

        @Override
        default public ServiceBusEndpointBuilder tokenCredential(TokenCredential tokenCredential) {
            this.doSetProperty("tokenCredential", tokenCredential);
            return this;
        }

        @Override
        default public ServiceBusEndpointBuilder tokenCredential(String tokenCredential) {
            this.doSetProperty("tokenCredential", tokenCredential);
            return this;
        }
    }

    public static interface AdvancedServiceBusEndpointProducerBuilder
    extends EndpointProducerBuilder {
        default public ServiceBusEndpointProducerBuilder basic() {
            return (ServiceBusEndpointProducerBuilder)((Object)this);
        }

        default public AdvancedServiceBusEndpointProducerBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AdvancedServiceBusEndpointProducerBuilder lazyStartProducer(String lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    public static interface ServiceBusEndpointProducerBuilder
    extends EndpointProducerBuilder {
        default public AdvancedServiceBusEndpointProducerBuilder advanced() {
            return (AdvancedServiceBusEndpointProducerBuilder)((Object)this);
        }

        default public ServiceBusEndpointProducerBuilder amqpRetryOptions(AmqpRetryOptions amqpRetryOptions) {
            this.doSetProperty("amqpRetryOptions", amqpRetryOptions);
            return this;
        }

        default public ServiceBusEndpointProducerBuilder amqpRetryOptions(String amqpRetryOptions) {
            this.doSetProperty("amqpRetryOptions", amqpRetryOptions);
            return this;
        }

        default public ServiceBusEndpointProducerBuilder amqpTransportType(AmqpTransportType amqpTransportType) {
            this.doSetProperty("amqpTransportType", amqpTransportType);
            return this;
        }

        default public ServiceBusEndpointProducerBuilder amqpTransportType(String amqpTransportType) {
            this.doSetProperty("amqpTransportType", amqpTransportType);
            return this;
        }

        default public ServiceBusEndpointProducerBuilder clientOptions(ClientOptions clientOptions) {
            this.doSetProperty("clientOptions", clientOptions);
            return this;
        }

        default public ServiceBusEndpointProducerBuilder clientOptions(String clientOptions) {
            this.doSetProperty("clientOptions", clientOptions);
            return this;
        }

        default public ServiceBusEndpointProducerBuilder headerFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
            this.doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }

        default public ServiceBusEndpointProducerBuilder headerFilterStrategy(String headerFilterStrategy) {
            this.doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }

        default public ServiceBusEndpointProducerBuilder proxyOptions(ProxyOptions proxyOptions) {
            this.doSetProperty("proxyOptions", proxyOptions);
            return this;
        }

        default public ServiceBusEndpointProducerBuilder proxyOptions(String proxyOptions) {
            this.doSetProperty("proxyOptions", proxyOptions);
            return this;
        }

        default public ServiceBusEndpointProducerBuilder serviceBusType(ServiceBusType serviceBusType) {
            this.doSetProperty("serviceBusType", serviceBusType);
            return this;
        }

        default public ServiceBusEndpointProducerBuilder serviceBusType(String serviceBusType) {
            this.doSetProperty("serviceBusType", serviceBusType);
            return this;
        }

        default public ServiceBusEndpointProducerBuilder binary(boolean binary) {
            this.doSetProperty("binary", binary);
            return this;
        }

        default public ServiceBusEndpointProducerBuilder binary(String binary) {
            this.doSetProperty("binary", binary);
            return this;
        }

        default public ServiceBusEndpointProducerBuilder producerOperation(ServiceBusProducerOperationDefinition producerOperation) {
            this.doSetProperty("producerOperation", producerOperation);
            return this;
        }

        default public ServiceBusEndpointProducerBuilder producerOperation(String producerOperation) {
            this.doSetProperty("producerOperation", producerOperation);
            return this;
        }

        default public ServiceBusEndpointProducerBuilder scheduledEnqueueTime(OffsetDateTime scheduledEnqueueTime) {
            this.doSetProperty("scheduledEnqueueTime", scheduledEnqueueTime);
            return this;
        }

        default public ServiceBusEndpointProducerBuilder scheduledEnqueueTime(String scheduledEnqueueTime) {
            this.doSetProperty("scheduledEnqueueTime", scheduledEnqueueTime);
            return this;
        }

        default public ServiceBusEndpointProducerBuilder senderClient(ServiceBusSenderClient senderClient) {
            this.doSetProperty("senderClient", senderClient);
            return this;
        }

        default public ServiceBusEndpointProducerBuilder senderClient(String senderClient) {
            this.doSetProperty("senderClient", senderClient);
            return this;
        }

        default public ServiceBusEndpointProducerBuilder serviceBusTransactionContext(ServiceBusTransactionContext serviceBusTransactionContext) {
            this.doSetProperty("serviceBusTransactionContext", serviceBusTransactionContext);
            return this;
        }

        default public ServiceBusEndpointProducerBuilder serviceBusTransactionContext(String serviceBusTransactionContext) {
            this.doSetProperty("serviceBusTransactionContext", serviceBusTransactionContext);
            return this;
        }

        default public ServiceBusEndpointProducerBuilder connectionString(String connectionString) {
            this.doSetProperty("connectionString", connectionString);
            return this;
        }

        default public ServiceBusEndpointProducerBuilder credentialType(CredentialType credentialType) {
            this.doSetProperty("credentialType", credentialType);
            return this;
        }

        default public ServiceBusEndpointProducerBuilder credentialType(String credentialType) {
            this.doSetProperty("credentialType", credentialType);
            return this;
        }

        default public ServiceBusEndpointProducerBuilder fullyQualifiedNamespace(String fullyQualifiedNamespace) {
            this.doSetProperty("fullyQualifiedNamespace", fullyQualifiedNamespace);
            return this;
        }

        default public ServiceBusEndpointProducerBuilder tokenCredential(TokenCredential tokenCredential) {
            this.doSetProperty("tokenCredential", tokenCredential);
            return this;
        }

        default public ServiceBusEndpointProducerBuilder tokenCredential(String tokenCredential) {
            this.doSetProperty("tokenCredential", tokenCredential);
            return this;
        }
    }

    public static interface AdvancedServiceBusEndpointConsumerBuilder
    extends EndpointConsumerBuilder {
        default public ServiceBusEndpointConsumerBuilder basic() {
            return (ServiceBusEndpointConsumerBuilder)((Object)this);
        }

        default public AdvancedServiceBusEndpointConsumerBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public AdvancedServiceBusEndpointConsumerBuilder bridgeErrorHandler(String bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public AdvancedServiceBusEndpointConsumerBuilder exceptionHandler(ExceptionHandler exceptionHandler) {
            this.doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }

        default public AdvancedServiceBusEndpointConsumerBuilder exceptionHandler(String exceptionHandler) {
            this.doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }

        default public AdvancedServiceBusEndpointConsumerBuilder exchangePattern(ExchangePattern exchangePattern) {
            this.doSetProperty("exchangePattern", exchangePattern);
            return this;
        }

        default public AdvancedServiceBusEndpointConsumerBuilder exchangePattern(String exchangePattern) {
            this.doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
    }

    public static interface ServiceBusEndpointConsumerBuilder
    extends EndpointConsumerBuilder {
        default public AdvancedServiceBusEndpointConsumerBuilder advanced() {
            return (AdvancedServiceBusEndpointConsumerBuilder)((Object)this);
        }

        default public ServiceBusEndpointConsumerBuilder amqpRetryOptions(AmqpRetryOptions amqpRetryOptions) {
            this.doSetProperty("amqpRetryOptions", amqpRetryOptions);
            return this;
        }

        default public ServiceBusEndpointConsumerBuilder amqpRetryOptions(String amqpRetryOptions) {
            this.doSetProperty("amqpRetryOptions", amqpRetryOptions);
            return this;
        }

        default public ServiceBusEndpointConsumerBuilder amqpTransportType(AmqpTransportType amqpTransportType) {
            this.doSetProperty("amqpTransportType", amqpTransportType);
            return this;
        }

        default public ServiceBusEndpointConsumerBuilder amqpTransportType(String amqpTransportType) {
            this.doSetProperty("amqpTransportType", amqpTransportType);
            return this;
        }

        default public ServiceBusEndpointConsumerBuilder clientOptions(ClientOptions clientOptions) {
            this.doSetProperty("clientOptions", clientOptions);
            return this;
        }

        default public ServiceBusEndpointConsumerBuilder clientOptions(String clientOptions) {
            this.doSetProperty("clientOptions", clientOptions);
            return this;
        }

        default public ServiceBusEndpointConsumerBuilder headerFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
            this.doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }

        default public ServiceBusEndpointConsumerBuilder headerFilterStrategy(String headerFilterStrategy) {
            this.doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }

        default public ServiceBusEndpointConsumerBuilder proxyOptions(ProxyOptions proxyOptions) {
            this.doSetProperty("proxyOptions", proxyOptions);
            return this;
        }

        default public ServiceBusEndpointConsumerBuilder proxyOptions(String proxyOptions) {
            this.doSetProperty("proxyOptions", proxyOptions);
            return this;
        }

        default public ServiceBusEndpointConsumerBuilder serviceBusType(ServiceBusType serviceBusType) {
            this.doSetProperty("serviceBusType", serviceBusType);
            return this;
        }

        default public ServiceBusEndpointConsumerBuilder serviceBusType(String serviceBusType) {
            this.doSetProperty("serviceBusType", serviceBusType);
            return this;
        }

        default public ServiceBusEndpointConsumerBuilder enableDeadLettering(boolean enableDeadLettering) {
            this.doSetProperty("enableDeadLettering", enableDeadLettering);
            return this;
        }

        default public ServiceBusEndpointConsumerBuilder enableDeadLettering(String enableDeadLettering) {
            this.doSetProperty("enableDeadLettering", enableDeadLettering);
            return this;
        }

        default public ServiceBusEndpointConsumerBuilder maxAutoLockRenewDuration(Duration maxAutoLockRenewDuration) {
            this.doSetProperty("maxAutoLockRenewDuration", maxAutoLockRenewDuration);
            return this;
        }

        default public ServiceBusEndpointConsumerBuilder maxAutoLockRenewDuration(String maxAutoLockRenewDuration) {
            this.doSetProperty("maxAutoLockRenewDuration", maxAutoLockRenewDuration);
            return this;
        }

        default public ServiceBusEndpointConsumerBuilder maxConcurrentCalls(int maxConcurrentCalls) {
            this.doSetProperty("maxConcurrentCalls", maxConcurrentCalls);
            return this;
        }

        default public ServiceBusEndpointConsumerBuilder maxConcurrentCalls(String maxConcurrentCalls) {
            this.doSetProperty("maxConcurrentCalls", maxConcurrentCalls);
            return this;
        }

        default public ServiceBusEndpointConsumerBuilder prefetchCount(int prefetchCount) {
            this.doSetProperty("prefetchCount", prefetchCount);
            return this;
        }

        default public ServiceBusEndpointConsumerBuilder prefetchCount(String prefetchCount) {
            this.doSetProperty("prefetchCount", prefetchCount);
            return this;
        }

        default public ServiceBusEndpointConsumerBuilder processorClient(ServiceBusProcessorClient processorClient) {
            this.doSetProperty("processorClient", processorClient);
            return this;
        }

        default public ServiceBusEndpointConsumerBuilder processorClient(String processorClient) {
            this.doSetProperty("processorClient", processorClient);
            return this;
        }

        default public ServiceBusEndpointConsumerBuilder serviceBusReceiveMode(ServiceBusReceiveMode serviceBusReceiveMode) {
            this.doSetProperty("serviceBusReceiveMode", serviceBusReceiveMode);
            return this;
        }

        default public ServiceBusEndpointConsumerBuilder serviceBusReceiveMode(String serviceBusReceiveMode) {
            this.doSetProperty("serviceBusReceiveMode", serviceBusReceiveMode);
            return this;
        }

        default public ServiceBusEndpointConsumerBuilder subQueue(SubQueue subQueue) {
            this.doSetProperty("subQueue", subQueue);
            return this;
        }

        default public ServiceBusEndpointConsumerBuilder subQueue(String subQueue) {
            this.doSetProperty("subQueue", subQueue);
            return this;
        }

        default public ServiceBusEndpointConsumerBuilder subscriptionName(String subscriptionName) {
            this.doSetProperty("subscriptionName", subscriptionName);
            return this;
        }

        default public ServiceBusEndpointConsumerBuilder connectionString(String connectionString) {
            this.doSetProperty("connectionString", connectionString);
            return this;
        }

        default public ServiceBusEndpointConsumerBuilder credentialType(CredentialType credentialType) {
            this.doSetProperty("credentialType", credentialType);
            return this;
        }

        default public ServiceBusEndpointConsumerBuilder credentialType(String credentialType) {
            this.doSetProperty("credentialType", credentialType);
            return this;
        }

        default public ServiceBusEndpointConsumerBuilder fullyQualifiedNamespace(String fullyQualifiedNamespace) {
            this.doSetProperty("fullyQualifiedNamespace", fullyQualifiedNamespace);
            return this;
        }

        default public ServiceBusEndpointConsumerBuilder tokenCredential(TokenCredential tokenCredential) {
            this.doSetProperty("tokenCredential", tokenCredential);
            return this;
        }

        default public ServiceBusEndpointConsumerBuilder tokenCredential(String tokenCredential) {
            this.doSetProperty("tokenCredential", tokenCredential);
            return this;
        }
    }
}

