/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.etcd.cloud;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import mousio.etcd4j.EtcdClient;
import mousio.etcd4j.requests.EtcdKeyGetRequest;
import mousio.etcd4j.responses.EtcdKeysResponse;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.cloud.ServiceDefinition;
import org.apache.camel.component.etcd.EtcdConfiguration;
import org.apache.camel.component.etcd.EtcdHelper;
import org.apache.camel.component.etcd.cloud.EtcdServiceDefinition;
import org.apache.camel.impl.cloud.DefaultServiceDiscovery;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class EtcdServiceDiscovery
extends DefaultServiceDiscovery {
    private static final Logger LOGGER = LoggerFactory.getLogger(EtcdServiceDiscovery.class);
    private static final ObjectMapper MAPPER = EtcdHelper.createObjectMapper();
    private final EtcdConfiguration configuration;
    private EtcdClient client;

    EtcdServiceDiscovery(EtcdConfiguration configuration) {
        this.configuration = configuration;
        this.client = null;
    }

    protected void doStart() throws Exception {
        if (this.client == null) {
            this.client = this.configuration.createClient();
        }
    }

    protected void doStop() throws Exception {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }

    protected EtcdConfiguration getConfiguration() {
        return this.configuration;
    }

    protected EtcdClient getClient() {
        return this.client;
    }

    protected EtcdServiceDefinition nodeFromString(String value) {
        EtcdServiceDefinition server = null;
        try {
            server = (EtcdServiceDefinition)((Object)MAPPER.readValue(value, EtcdServiceDefinition.class));
        }
        catch (Exception e) {
            LOGGER.warn("", (Throwable)e);
        }
        return server;
    }

    protected List<ServiceDefinition> getServices() {
        return this.getServices(s -> true);
    }

    protected List<ServiceDefinition> getServices(Predicate<EtcdServiceDefinition> filter) {
        List<Object> servers = Collections.emptyList();
        if (this.isRunAllowed()) {
            try {
                EtcdConfiguration conf = this.getConfiguration();
                EtcdKeyGetRequest request = this.getClient().get(conf.getServicePath()).recursive();
                if (conf.hasTimeout()) {
                    request.timeout(conf.getTimeout().longValue(), TimeUnit.SECONDS);
                }
                EtcdKeysResponse response = (EtcdKeysResponse)request.send().get();
                if (Objects.nonNull(response.node) && !response.node.nodes.isEmpty()) {
                    servers = response.node.nodes.stream().map(node -> node.value).filter(ObjectHelper::isNotEmpty).map(this::nodeFromString).filter(Objects::nonNull).filter(filter).sorted(EtcdServiceDefinition.COMPARATOR).collect(Collectors.toList());
                }
            }
            catch (Exception e) {
                throw new RuntimeCamelException((Throwable)e);
            }
        }
        return servers;
    }
}

