/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.etcd3;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.ClientBuilder;
import io.netty.handler.ssl.SslContext;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.etcd3.Etcd3Constants;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

@UriParams
public class Etcd3Configuration
implements Cloneable {
    @UriParam(label="common", defaultValue="Etcd3Constants.ETCD_DEFAULT_ENDPOINTS")
    private String[] endpoints = Etcd3Constants.ETCD_DEFAULT_ENDPOINTS;
    @UriParam(label="security", secret=true)
    private String userName;
    @UriParam(label="security", secret=true)
    private String password;
    @UriParam(label="advanced,security")
    private SslContext sslContext;
    @UriParam(label="common")
    private String namespace;
    @UriParam(label="advanced")
    private String loadBalancerPolicy;
    @UriParam(label="advanced")
    private String authority;
    @UriParam(label="advanced")
    private Integer maxInboundMessageSize;
    @UriParam(label="advanced", prefix="headers.", multiValue=true)
    private Map<String, String> headers = new HashMap<String, String>();
    @UriParam(label="advanced", prefix="authHeaders.", multiValue=true)
    private Map<String, String> authHeaders = new HashMap<String, String>();
    @UriParam(label="advanced", defaultValue="500")
    private long retryDelay = 500L;
    @UriParam(label="advanced", defaultValue="2500")
    private long retryMaxDelay = 2500L;
    @UriParam(label="advanced", defaultValue="30 seconds")
    private Duration keepAliveTime = Duration.ofSeconds(30L);
    @UriParam(label="advanced", defaultValue="10 seconds")
    private Duration keepAliveTimeout = Duration.ofSeconds(10L);
    @UriParam(label="advanced")
    private Duration retryMaxDuration;
    @UriParam(label="advanced")
    private Duration connectionTimeout;
    @UriParam(label="common", defaultValue="false")
    private boolean prefix;
    @UriParam(label="consumer,advanced", defaultValue="0", description="The index to watch from")
    private long fromIndex;
    @UriParam(label="cloud", defaultValue="/services/")
    private String servicePath = "/services/";
    @UriParam(label="common", defaultValue="UTF-8")
    private String keyCharset = "UTF-8";
    @UriParam(label="producer", defaultValue="UTF-8")
    private String valueCharset = "UTF-8";

    public String[] getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(String ... endpoints) {
        this.endpoints = endpoints;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public SslContext getSslContext() {
        return this.sslContext;
    }

    public void setSslContext(SslContext sslContext) {
        this.sslContext = sslContext;
    }

    public String getLoadBalancerPolicy() {
        return this.loadBalancerPolicy;
    }

    public void setLoadBalancerPolicy(String loadBalancerPolicy) {
        this.loadBalancerPolicy = loadBalancerPolicy;
    }

    public String getAuthority() {
        return this.authority;
    }

    public void setAuthority(String authority) {
        this.authority = authority;
    }

    public Integer getMaxInboundMessageSize() {
        return this.maxInboundMessageSize;
    }

    public void setMaxInboundMessageSize(Integer maxInboundMessageSize) {
        this.maxInboundMessageSize = maxInboundMessageSize;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public Map<String, String> getAuthHeaders() {
        return this.authHeaders;
    }

    public void setAuthHeaders(Map<String, String> authHeaders) {
        this.authHeaders = authHeaders;
    }

    public long getRetryDelay() {
        return this.retryDelay;
    }

    public void setRetryDelay(long retryDelay) {
        this.retryDelay = retryDelay;
    }

    public long getRetryMaxDelay() {
        return this.retryMaxDelay;
    }

    public void setRetryMaxDelay(long retryMaxDelay) {
        this.retryMaxDelay = retryMaxDelay;
    }

    public Duration getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(Duration keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public Duration getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(Duration keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public Duration getRetryMaxDuration() {
        return this.retryMaxDuration;
    }

    public void setRetryMaxDuration(Duration retryMaxDuration) {
        this.retryMaxDuration = retryMaxDuration;
    }

    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public boolean isPrefix() {
        return this.prefix;
    }

    public void setPrefix(boolean prefix) {
        this.prefix = prefix;
    }

    public long getFromIndex() {
        return this.fromIndex;
    }

    public void setFromIndex(long fromIndex) {
        this.fromIndex = fromIndex;
    }

    public String getServicePath() {
        return this.servicePath;
    }

    public void setServicePath(String servicePath) {
        this.servicePath = servicePath;
    }

    public String getKeyCharset() {
        return this.keyCharset;
    }

    public void setKeyCharset(String keyCharset) {
        this.keyCharset = keyCharset;
    }

    public String getValueCharset() {
        return this.valueCharset;
    }

    public void setValueCharset(String valueCharset) {
        this.valueCharset = valueCharset;
    }

    public Client createClient() {
        ClientBuilder builder = Client.builder().endpoints(this.endpoints).sslContext(this.sslContext).authority(this.authority).maxInboundMessageSize(this.maxInboundMessageSize).retryDelay(this.retryDelay).retryMaxDelay(this.retryMaxDelay).retryMaxDuration(this.retryMaxDuration).keepaliveTime(this.keepAliveTime).keepaliveTimeout(this.keepAliveTimeout).connectTimeout(this.connectionTimeout);
        if (this.loadBalancerPolicy != null) {
            builder.loadBalancerPolicy(this.loadBalancerPolicy);
        }
        if (this.userName != null) {
            builder.user(ByteSequence.from((byte[])this.userName.getBytes()));
        }
        if (this.password != null) {
            builder.password(ByteSequence.from((byte[])this.password.getBytes()));
        }
        if (this.namespace != null) {
            builder.namespace(ByteSequence.from((byte[])this.namespace.getBytes()));
        }
        if (this.headers != null && !this.headers.isEmpty()) {
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                builder.header(entry.getKey(), entry.getKey());
            }
        }
        if (this.authHeaders != null && !this.authHeaders.isEmpty()) {
            for (Map.Entry<String, String> entry : this.authHeaders.entrySet()) {
                builder.authHeader(entry.getKey(), entry.getKey());
            }
        }
        return builder.build();
    }

    Etcd3Configuration copy() {
        try {
            Etcd3Configuration configuration = (Etcd3Configuration)super.clone();
            configuration.setHeaders(new HashMap<String, String>(this.headers));
            configuration.setAuthHeaders(new HashMap<String, String>(this.authHeaders));
            return configuration;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }
}

