/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.etcd3.cloud;

import io.netty.handler.ssl.SslContext;
import java.time.Duration;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.cloud.ServiceDiscovery;
import org.apache.camel.cloud.ServiceDiscoveryFactory;
import org.apache.camel.component.etcd3.Etcd3Configuration;
import org.apache.camel.component.etcd3.cloud.Etcd3OnDemandServiceDiscovery;
import org.apache.camel.component.etcd3.cloud.Etcd3WatchServiceDiscovery;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.annotations.CloudServiceFactory;
import org.apache.camel.util.ObjectHelper;

@CloudServiceFactory(value="etcd-service-discovery")
@Configurer
public class Etcd3ServiceDiscoveryFactory
implements ServiceDiscoveryFactory {
    private final Etcd3Configuration configuration;
    private String type;

    public Etcd3ServiceDiscoveryFactory() {
        this(new Etcd3Configuration());
    }

    public Etcd3ServiceDiscoveryFactory(Etcd3Configuration configuration) {
        this.configuration = configuration;
    }

    public String[] getEndpoints() {
        return this.configuration.getEndpoints();
    }

    public void setEndpoints(String ... endpoints) {
        this.configuration.setEndpoints(endpoints);
    }

    public String getUserName() {
        return this.configuration.getUserName();
    }

    public void setUserName(String userName) {
        this.configuration.setUserName(userName);
    }

    public String getPassword() {
        return this.configuration.getPassword();
    }

    public void setPassword(String password) {
        this.configuration.setPassword(password);
    }

    public String getNamespace() {
        return this.configuration.getNamespace();
    }

    public void setNamespace(String namespace) {
        this.configuration.setNamespace(namespace);
    }

    public SslContext getSslContext() {
        return this.configuration.getSslContext();
    }

    public void setSslContext(SslContext sslContext) {
        this.configuration.setSslContext(sslContext);
    }

    public String getLoadBalancerPolicy() {
        return this.configuration.getLoadBalancerPolicy();
    }

    public void setLoadBalancerPolicy(String loadBalancerPolicy) {
        this.configuration.setLoadBalancerPolicy(loadBalancerPolicy);
    }

    public String getAuthority() {
        return this.configuration.getAuthority();
    }

    public void setAuthority(String authority) {
        this.configuration.setAuthority(authority);
    }

    public Integer getMaxInboundMessageSize() {
        return this.configuration.getMaxInboundMessageSize();
    }

    public void setMaxInboundMessageSize(Integer maxInboundMessageSize) {
        this.configuration.setMaxInboundMessageSize(maxInboundMessageSize);
    }

    public Map<String, String> getHeaders() {
        return this.configuration.getHeaders();
    }

    public void setHeaders(Map<String, String> headers) {
        this.configuration.setHeaders(headers);
    }

    public Map<String, String> getAuthHeaders() {
        return this.configuration.getAuthHeaders();
    }

    public void setAuthHeaders(Map<String, String> authHeaders) {
        this.configuration.setAuthHeaders(authHeaders);
    }

    public long getRetryDelay() {
        return this.configuration.getRetryDelay();
    }

    public void setRetryDelay(long retryDelay) {
        this.configuration.setRetryDelay(retryDelay);
    }

    public long getRetryMaxDelay() {
        return this.configuration.getRetryMaxDelay();
    }

    public void setRetryMaxDelay(long retryMaxDelay) {
        this.configuration.setRetryMaxDelay(retryMaxDelay);
    }

    public Duration getKeepAliveTime() {
        return this.configuration.getKeepAliveTime();
    }

    public void setKeepAliveTime(Duration keepAliveTime) {
        this.configuration.setKeepAliveTime(keepAliveTime);
    }

    public Duration getKeepAliveTimeout() {
        return this.configuration.getKeepAliveTimeout();
    }

    public void setKeepAliveTimeout(Duration keepAliveTimeout) {
        this.configuration.setKeepAliveTimeout(keepAliveTimeout);
    }

    public Duration getRetryMaxDuration() {
        return this.configuration.getRetryMaxDuration();
    }

    public void setRetryMaxDuration(Duration retryMaxDuration) {
        this.configuration.setRetryMaxDuration(retryMaxDuration);
    }

    public Duration getConnectionTimeout() {
        return this.configuration.getConnectionTimeout();
    }

    public void setConnectionTimeout(Duration connectionTimeout) {
        this.configuration.setConnectionTimeout(connectionTimeout);
    }

    public String getServicePath() {
        return this.configuration.getServicePath();
    }

    public void setServicePath(String servicePath) {
        this.configuration.setServicePath(servicePath);
    }

    public String getKeyCharset() {
        return this.configuration.getKeyCharset();
    }

    public void setKeyCharset(String keyCharset) {
        this.configuration.setKeyCharset(keyCharset);
    }

    public String getValueCharset() {
        return this.configuration.getValueCharset();
    }

    public void setValueCharset(String valueCharset) {
        this.configuration.setValueCharset(valueCharset);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ServiceDiscovery newInstance(CamelContext camelContext) throws Exception {
        return ObjectHelper.equal((Object)"watch", (Object)this.type, (boolean)true) ? new Etcd3WatchServiceDiscovery(this.configuration) : new Etcd3OnDemandServiceDiscovery(this.configuration);
    }
}

