/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.etcd3.cloud;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.KV;
import io.etcd.jetcd.KeyValue;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.options.GetOption;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.etcd3.Etcd3Configuration;
import org.apache.camel.component.etcd3.Etcd3Helper;
import org.apache.camel.component.etcd3.cloud.Etcd3GetServicesResponse;
import org.apache.camel.component.etcd3.cloud.Etcd3ServiceDefinition;
import org.apache.camel.impl.cloud.DefaultServiceDiscovery;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
abstract class Etcd3ServiceDiscovery
extends DefaultServiceDiscovery {
    private static final Logger LOGGER = LoggerFactory.getLogger(Etcd3ServiceDiscovery.class);
    private static final ObjectMapper MAPPER = Etcd3Helper.createObjectMapper();
    private final String servicePath;
    private final Client client;
    private final KV kvClient;
    private final Charset keyCharset;
    private final Charset valueCharset;

    Etcd3ServiceDiscovery(Etcd3Configuration configuration) {
        this.servicePath = (String)ObjectHelper.notNull((Object)configuration.getServicePath(), (String)"servicePath");
        this.client = configuration.createClient();
        this.kvClient = this.client.getKVClient();
        this.keyCharset = Charset.forName(configuration.getKeyCharset());
        this.valueCharset = Charset.forName(configuration.getValueCharset());
    }

    protected void doStop() throws Exception {
        try {
            this.client.close();
        }
        finally {
            super.doStop();
        }
    }

    protected Etcd3GetServicesResponse findServices() {
        return this.findServices(s -> true);
    }

    protected Etcd3GetServicesResponse findServices(Predicate<Etcd3ServiceDefinition> filter) {
        List<Object> servers = Collections.emptyList();
        long revision = 0L;
        if (this.isRunAllowed()) {
            try {
                GetResponse response = (GetResponse)this.kvClient.get(ByteSequence.from((String)Etcd3Helper.toPathPrefix(this.servicePath), (Charset)this.keyCharset), GetOption.newBuilder().isPrefix(true).build()).get();
                revision = response.getHeader().getRevision();
                if (response.getCount() > 0L) {
                    servers = response.getKvs().stream().map(KeyValue::getValue).filter(ObjectHelper::isNotEmpty).map(kv -> kv.toString(this.valueCharset)).map(this::nodeFromString).filter(Objects::nonNull).filter(filter).sorted(Etcd3ServiceDefinition.COMPARATOR).collect(Collectors.toList());
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeCamelException((Throwable)e);
            }
            catch (Exception e) {
                throw new RuntimeCamelException((Throwable)e);
            }
        }
        return new Etcd3GetServicesResponse(revision, servers);
    }

    private Etcd3ServiceDefinition nodeFromString(String value) {
        Etcd3ServiceDefinition server = null;
        try {
            server = (Etcd3ServiceDefinition)((Object)MAPPER.readValue(value, Etcd3ServiceDefinition.class));
        }
        catch (Exception e) {
            LOGGER.warn("Could not parse the json payload {}", (Object)value, (Object)e);
        }
        return server;
    }
}

