/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.facebook.data;

import facebook4j.Facebook;
import facebook4j.FacebookException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.facebook.config.FacebookNameStyle;
import org.apache.camel.component.facebook.data.FacebookMethodsType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FacebookMethodsTypeHelper {
    private static final Logger LOG;
    private static final Map<String, List<FacebookMethodsType>> METHOD_MAP;
    private static final Map<String, List<Object>> ARGUMENTS_MAP;
    private static final Map<String, Class<?>> VALID_ARGUMENTS;

    private FacebookMethodsTypeHelper() {
    }

    public static List<FacebookMethodsType> getCandidateMethods(String name, String ... argNames) {
        int nArgs;
        List<FacebookMethodsType> methods = METHOD_MAP.get(name);
        if (methods == null) {
            LOG.debug("No matching method for method {}", (Object)name);
            return Collections.emptyList();
        }
        int n = nArgs = argNames != null ? argNames.length : 0;
        if (nArgs == 0) {
            LOG.debug("Found {} methods for method {}", (Object)methods.size(), (Object)name);
            return Collections.unmodifiableList(methods);
        }
        List<FacebookMethodsType> filteredSet = FacebookMethodsTypeHelper.filterMethods(methods, MatchType.SUBSET, argNames);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found {} filtered methods for {}", (Object)filteredSet.size(), (Object)(name + Arrays.toString(argNames).replace('[', '(').replace(']', ')')));
        }
        return filteredSet;
    }

    public static List<FacebookMethodsType> filterMethods(List<FacebookMethodsType> methods, MatchType matchType, String ... argNames) {
        List<String> argsList = Arrays.asList(argNames);
        ArrayList<FacebookMethodsType> result = new ArrayList<FacebookMethodsType>();
        ArrayList<FacebookMethodsType> extraArgs = new ArrayList<FacebookMethodsType>();
        block4: for (FacebookMethodsType method : methods) {
            List<String> methodArgs = method.getArgNames();
            switch (matchType) {
                case EXACT: {
                    if (!methodArgs.containsAll(argsList) || !argsList.containsAll(methodArgs)) continue block4;
                    result.add(method);
                    continue block4;
                }
                case SUBSET: {
                    if (!methodArgs.containsAll(argsList)) continue block4;
                    result.add(method);
                    continue block4;
                }
            }
            if (!argsList.containsAll(methodArgs)) continue;
            if (methodArgs.containsAll(argsList)) {
                result.add(method);
                continue;
            }
            extraArgs.add(method);
        }
        return Collections.unmodifiableList(result.isEmpty() ? extraArgs : result);
    }

    public static List<Object> getArguments(String name) throws IllegalArgumentException {
        List<Object> arguments = ARGUMENTS_MAP.get(name);
        if (arguments == null) {
            throw new IllegalArgumentException(name);
        }
        return Collections.unmodifiableList(arguments);
    }

    public static List<Object> getArgumentsForNameStyle(String name, FacebookNameStyle style) throws IllegalArgumentException {
        if (style == null) {
            throw new IllegalArgumentException("Parameters style cannot be null");
        }
        switch (style) {
            case EXACT: {
                return FacebookMethodsTypeHelper.getArguments(name);
            }
            case GET: {
                return FacebookMethodsTypeHelper.getArguments(FacebookMethodsTypeHelper.convertToGetMethod(name));
            }
            case SEARCH: {
                return FacebookMethodsTypeHelper.getArguments(FacebookMethodsTypeHelper.convertToSearchMethod(name));
            }
        }
        ArrayList<Object> arguments = new ArrayList<Object>();
        arguments.addAll(FacebookMethodsTypeHelper.getArguments(FacebookMethodsTypeHelper.convertToGetMethod(name)));
        arguments.addAll(FacebookMethodsTypeHelper.getArguments(FacebookMethodsTypeHelper.convertToSearchMethod(name)));
        return Collections.unmodifiableList(arguments);
    }

    public static Set<String> getMissingProperties(String methodName, FacebookNameStyle nameStyle, Set<String> argNames) {
        List<Object> argsWithTypes = FacebookMethodsTypeHelper.getArgumentsForNameStyle(methodName, nameStyle);
        HashSet<String> missingArgs = new HashSet<String>();
        for (int i = 1; i < argsWithTypes.size(); i += 2) {
            String name = (String)argsWithTypes.get(i);
            if (argNames.contains(name)) continue;
            missingArgs.add(name);
        }
        return missingArgs;
    }

    public static Map<String, Class<?>> allArguments() {
        return Collections.unmodifiableMap(VALID_ARGUMENTS);
    }

    public static Class<?> getType(String argName) throws IllegalArgumentException {
        Class<?> type = VALID_ARGUMENTS.get(argName);
        if (type == null) {
            throw new IllegalArgumentException(argName);
        }
        return type;
    }

    public static String convertToGetMethod(String name) throws IllegalArgumentException {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        return "get" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    public static String convertToSearchMethod(String name) throws IllegalArgumentException {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        return "search" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    public static FacebookMethodsType getHighestPriorityMethod(List<FacebookMethodsType> filteredMethods) {
        FacebookMethodsType highest = null;
        for (FacebookMethodsType method : filteredMethods) {
            if (highest != null && method.ordinal() <= highest.ordinal()) continue;
            highest = method;
        }
        return highest;
    }

    public static Object invokeMethod(Facebook facebook, FacebookMethodsType method, Map<String, Object> properties) throws RuntimeCamelException {
        LOG.debug("Invoking {} with arguments {}", (Object)method.getName(), properties);
        List<String> argNames = method.getArgNames();
        Object[] values = new Object[argNames.size()];
        List<Class<?>> argTypes = method.getArgTypes();
        Class[] types = argTypes.toArray(new Class[argTypes.size()]);
        int index = 0;
        for (String name : argNames) {
            Object value = properties.get(name);
            if (value != null && types[index].isArray()) {
                int i;
                Object array;
                Class type = types[index];
                if (value instanceof Collection) {
                    Collection collection = (Collection)value;
                    array = Array.newInstance(type.getComponentType(), collection.size());
                    if (array instanceof Object[]) {
                        collection.toArray((Object[])array);
                    } else {
                        i = 0;
                        for (Object el : collection) {
                            Array.set(array, i++, el);
                        }
                    }
                    value = array;
                } else if (value.getClass().isArray() && type.getComponentType().isAssignableFrom(value.getClass().getComponentType())) {
                    int size = Array.getLength(value);
                    array = Array.newInstance(type.getComponentType(), size);
                    for (i = 0; i < size; ++i) {
                        Array.set(array, i, Array.get(value, i));
                    }
                    value = array;
                } else {
                    throw new IllegalArgumentException(String.format("Cannot convert %s to %s", value.getClass(), type));
                }
            }
            values[index++] = value;
        }
        try {
            return method.getMethod().invoke((Object)facebook, values);
        }
        catch (Exception e) {
            String msg = e.getCause() instanceof FacebookException ? ((FacebookException)e.getCause()).getErrorMessage() : e.getMessage();
            throw new RuntimeCamelException(String.format("Error invoking %s with %s: %s", method.getName(), properties, msg), (Throwable)e);
        }
    }

    static {
        FacebookMethodsType[] methods;
        LOG = LoggerFactory.getLogger(FacebookMethodsTypeHelper.class);
        METHOD_MAP = new HashMap<String, List<FacebookMethodsType>>();
        ARGUMENTS_MAP = new HashMap<String, List<Object>>();
        VALID_ARGUMENTS = new HashMap();
        for (FacebookMethodsType method : methods = FacebookMethodsType.values()) {
            String name = method.getName();
            List<FacebookMethodsType> overloads = METHOD_MAP.get(name);
            if (overloads == null) {
                overloads = new ArrayList<FacebookMethodsType>();
                METHOD_MAP.put(method.getName(), overloads);
            }
            overloads.add(method);
            List<Object> arguments = ARGUMENTS_MAP.get(name);
            if (arguments == null) {
                arguments = new ArrayList<Object>();
                ARGUMENTS_MAP.put(name, arguments);
            }
            int nArgs = method.getArgNames().size();
            String[] argNames = method.getArgNames().toArray(new String[nArgs]);
            Class[] argTypes = method.getArgTypes().toArray(new Class[nArgs]);
            for (int i = 0; i < nArgs; ++i) {
                Class<?> previousType;
                String argName = argNames[i];
                Class argType = argTypes[i];
                if (!arguments.contains(argName)) {
                    arguments.add(argType);
                    arguments.add(argName);
                }
                if ((previousType = VALID_ARGUMENTS.get(argName)) != null && previousType != argType) {
                    throw new ExceptionInInitializerError(String.format("Argument %s has ambiguous types (%s, %s) across methods!", name, previousType, argType));
                }
                if (previousType != null) continue;
                VALID_ARGUMENTS.put(argName, argType);
            }
        }
        LOG.debug("Found {} unique method names in {} methods", (Object)METHOD_MAP.size(), (Object)methods.length);
    }

    public static enum MatchType {
        EXACT,
        SUBSET,
        SUPER_SET;

    }
}

