/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fhir.api;

import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.api.PreferReturnEnum;
import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.gclient.ICreateTyped;
import java.util.Map;
import org.apache.camel.component.fhir.api.ExtraParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class FhirCreate {
    private final IGenericClient client;

    public FhirCreate(IGenericClient client) {
        this.client = client;
    }

    public MethodOutcome resource(IBaseResource resource, String url, PreferReturnEnum preferReturn, Map<ExtraParameters, Object> extraParameters) {
        ICreateTyped createTyped = this.client.create().resource(resource);
        this.processOptionalParams(url, preferReturn, createTyped);
        ExtraParameters.process(extraParameters, createTyped);
        return (MethodOutcome)createTyped.execute();
    }

    public MethodOutcome resource(String resourceAsString, String url, PreferReturnEnum preferReturn, Map<ExtraParameters, Object> extraParameters) {
        ICreateTyped createTyped = this.client.create().resource(resourceAsString);
        this.processOptionalParams(url, preferReturn, createTyped);
        ExtraParameters.process(extraParameters, createTyped);
        return (MethodOutcome)createTyped.execute();
    }

    private void processOptionalParams(String theSearchUrl, PreferReturnEnum theReturn, ICreateTyped createTyped) {
        if (theSearchUrl != null) {
            createTyped.conditionalByUrl(theSearchUrl);
        }
        if (theReturn != null) {
            createTyped.prefer(theReturn);
        }
    }
}

