
/*
 * Camel ApiMethod Enumeration generated by camel-api-component-maven-plugin
 */
package org.apache.camel.component.fhir.internal;

import java.lang.reflect.Method;
import java.util.List;

import org.apache.camel.component.fhir.api.FhirMeta;

import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodArg;
import org.apache.camel.support.component.ApiMethodImpl;

import static org.apache.camel.support.component.ApiMethodArg.arg;

/**
 * Camel {@link ApiMethod} Enumeration for org.apache.camel.component.fhir.api.FhirMeta
 */
public enum FhirMetaApiMethod implements ApiMethod {

    ADD(
        org.hl7.fhir.instance.model.api.IBaseMetaType.class,
        "add",
        arg("meta", org.hl7.fhir.instance.model.api.IBaseMetaType.class),
        arg("id", org.hl7.fhir.instance.model.api.IIdType.class),
        arg("extraParameters", java.util.Map.class)),

    DELETE(
        org.hl7.fhir.instance.model.api.IBaseMetaType.class,
        "delete",
        arg("meta", org.hl7.fhir.instance.model.api.IBaseMetaType.class),
        arg("id", org.hl7.fhir.instance.model.api.IIdType.class),
        arg("extraParameters", java.util.Map.class)),

    GET_FROM_RESOURCE(
        org.hl7.fhir.instance.model.api.IBaseMetaType.class,
        "getFromResource",
        arg("metaType", Class.class),
        arg("id", org.hl7.fhir.instance.model.api.IIdType.class),
        arg("extraParameters", java.util.Map.class)),

    GET_FROM_SERVER(
        org.hl7.fhir.instance.model.api.IBaseMetaType.class,
        "getFromServer",
        arg("metaType", Class.class),
        arg("extraParameters", java.util.Map.class)),

    GET_FROM_TYPE(
        org.hl7.fhir.instance.model.api.IBaseMetaType.class,
        "getFromType",
        arg("metaType", Class.class),
        arg("resourceType", String.class),
        arg("extraParameters", java.util.Map.class));

    private final ApiMethod apiMethod;

    private FhirMetaApiMethod(Class<?> resultType, String name, ApiMethodArg... args) {
        this.apiMethod = new ApiMethodImpl(FhirMeta.class, resultType, name, args);
    }

    @Override
    public String getName() { return apiMethod.getName(); }

    @Override
    public Class<?> getResultType() { return apiMethod.getResultType(); }

    @Override
    public List<String> getArgNames() { return apiMethod.getArgNames(); }

    @Override
    public List<Class<?>> getArgTypes() { return apiMethod.getArgTypes(); }

    @Override
    public Method getMethod() { return apiMethod.getMethod(); }
}
