/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fhir;

import ca.uhn.fhir.rest.client.api.IGenericClient;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.fhir.FhirConfiguration;
import org.apache.camel.component.fhir.FhirEndpoint;
import org.apache.camel.component.fhir.internal.FhirApiCollection;
import org.apache.camel.component.fhir.internal.FhirApiName;
import org.apache.camel.component.fhir.internal.FhirHelper;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.component.AbstractApiComponent;
import org.apache.camel.support.component.ApiCollection;

@Component(value="fhir")
public class FhirComponent
extends AbstractApiComponent<FhirApiName, FhirConfiguration, FhirApiCollection> {
    @Metadata(label="advanced")
    private FhirConfiguration configuration;

    public FhirComponent() {
        super(FhirEndpoint.class, FhirApiName.class, (ApiCollection)FhirApiCollection.getCollection());
    }

    public FhirComponent(CamelContext context) {
        super(context, FhirEndpoint.class, FhirApiName.class, (ApiCollection)FhirApiCollection.getCollection());
    }

    protected FhirApiName getApiName(String apiNameStr) {
        return (FhirApiName)((Object)this.getCamelContext().getTypeConverter().convertTo(FhirApiName.class, (Object)apiNameStr));
    }

    protected void afterPropertiesSet(FhirConfiguration endpointConfiguration) {
        if (endpointConfiguration.getClient() == null) {
            if (this.configuration != null && this.configuration.getClient() != null) {
                endpointConfiguration.setClient(this.configuration.getClient());
                return;
            }
            if (this.configuration != null) {
                if (endpointConfiguration.getServerUrl() == null) {
                    endpointConfiguration.setServerUrl(this.configuration.getServerUrl());
                }
                if (endpointConfiguration.getFhirContext() == null) {
                    endpointConfiguration.setFhirContext(this.configuration.getFhirContext());
                }
            }
            endpointConfiguration.setClient(this.createClient(endpointConfiguration));
        }
    }

    protected Endpoint createEndpoint(String uri, String methodName, FhirApiName apiName, FhirConfiguration endpointConfiguration) {
        endpointConfiguration.setApiName(apiName);
        endpointConfiguration.setMethodName(methodName);
        return new FhirEndpoint(uri, this, apiName, methodName, endpointConfiguration);
    }

    protected IGenericClient createClient(FhirConfiguration config) {
        return FhirHelper.createClient(config, this.getCamelContext());
    }

    public FhirConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(FhirConfiguration configuration) {
        this.configuration = configuration;
    }
}

