/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fhir;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.ParserOptions;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.parser.IParserErrorHandler;
import java.util.List;
import java.util.Set;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatContentTypeHeader;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public abstract class FhirDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName,
DataFormatContentTypeHeader {
    private FhirContext fhirContext;
    private String fhirVersion;
    private boolean contentTypeHeader = true;
    private IParserErrorHandler parserErrorHandler;
    private ParserOptions parserOptions;
    private String serverBaseUrl;
    private boolean prettyPrint;
    private List<Class<? extends IBaseResource>> preferTypes;
    private boolean omitResourceId;
    private IIdType forceResourceId;
    private boolean encodeElementsAppliesToChildResourcesOnly;
    private Set<String> encodeElements;
    private Set<String> dontEncodeElements;
    private Boolean stripVersionsFromReferences;
    private Boolean overrideResourceIdWithBundleEntryFullUrl;
    private boolean summaryMode;
    private boolean suppressNarratives;
    private List<String> dontStripVersionsFromReferencesAtPaths;

    public FhirContext getFhirContext() {
        return this.fhirContext;
    }

    public void setFhirContext(FhirContext fhirContext) {
        this.fhirContext = fhirContext;
    }

    public String getFhirVersion() {
        return this.fhirVersion;
    }

    public void setFhirVersion(String fhirVersion) {
        this.fhirVersion = fhirVersion;
    }

    public boolean isContentTypeHeader() {
        return this.contentTypeHeader;
    }

    public void setContentTypeHeader(boolean contentTypeHeader) {
        this.contentTypeHeader = contentTypeHeader;
    }

    public IParserErrorHandler getParserErrorHandler() {
        return this.parserErrorHandler;
    }

    public void setParserErrorHandler(IParserErrorHandler parserErrorHandler) {
        this.parserErrorHandler = parserErrorHandler;
    }

    public ParserOptions getParserOptions() {
        return this.parserOptions;
    }

    public void setParserOptions(ParserOptions parserOptions) {
        this.parserOptions = parserOptions;
    }

    public String getServerBaseUrl() {
        return this.serverBaseUrl;
    }

    public void setServerBaseUrl(String serverBaseUrl) {
        this.serverBaseUrl = serverBaseUrl;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public List<Class<? extends IBaseResource>> getPreferTypes() {
        return this.preferTypes;
    }

    public void setPreferTypes(List<Class<? extends IBaseResource>> preferTypes) {
        this.preferTypes = preferTypes;
    }

    public boolean isOmitResourceId() {
        return this.omitResourceId;
    }

    public void setOmitResourceId(boolean omitResourceId) {
        this.omitResourceId = omitResourceId;
    }

    public IIdType getForceResourceId() {
        return this.forceResourceId;
    }

    public void setForceResourceId(IIdType forceResourceId) {
        this.forceResourceId = forceResourceId;
    }

    public boolean isEncodeElementsAppliesToChildResourcesOnly() {
        return this.encodeElementsAppliesToChildResourcesOnly;
    }

    public void setEncodeElementsAppliesToChildResourcesOnly(boolean encodeElementsAppliesToChildResourcesOnly) {
        this.encodeElementsAppliesToChildResourcesOnly = encodeElementsAppliesToChildResourcesOnly;
    }

    public Set<String> getEncodeElements() {
        return this.encodeElements;
    }

    public void setEncodeElements(Set<String> encodeElements) {
        this.encodeElements = encodeElements;
    }

    public Set<String> getDontEncodeElements() {
        return this.dontEncodeElements;
    }

    public void setDontEncodeElements(Set<String> dontEncodeElements) {
        this.dontEncodeElements = dontEncodeElements;
    }

    public Boolean getStripVersionsFromReferences() {
        return this.stripVersionsFromReferences;
    }

    public void setStripVersionsFromReferences(Boolean stripVersionsFromReferences) {
        this.stripVersionsFromReferences = stripVersionsFromReferences;
    }

    public Boolean getOverrideResourceIdWithBundleEntryFullUrl() {
        return this.overrideResourceIdWithBundleEntryFullUrl;
    }

    public void setOverrideResourceIdWithBundleEntryFullUrl(Boolean overrideResourceIdWithBundleEntryFullUrl) {
        this.overrideResourceIdWithBundleEntryFullUrl = overrideResourceIdWithBundleEntryFullUrl;
    }

    public boolean isSummaryMode() {
        return this.summaryMode;
    }

    public void setSummaryMode(boolean summaryMode) {
        this.summaryMode = summaryMode;
    }

    public boolean isSuppressNarratives() {
        return this.suppressNarratives;
    }

    public void setSuppressNarratives(boolean suppressNarratives) {
        this.suppressNarratives = suppressNarratives;
    }

    public List<String> getDontStripVersionsFromReferencesAtPaths() {
        return this.dontStripVersionsFromReferencesAtPaths;
    }

    public void setDontStripVersionsFromReferencesAtPaths(List<String> dontStripVersionsFromReferencesAtPaths) {
        this.dontStripVersionsFromReferencesAtPaths = dontStripVersionsFromReferencesAtPaths;
    }

    protected void configureParser(IParser parser) {
        if (ObjectHelper.isNotEmpty((Object)this.getServerBaseUrl())) {
            parser.setServerBaseUrl(this.getServerBaseUrl());
        }
        if (ObjectHelper.isNotEmpty(this.getDontEncodeElements())) {
            parser.setDontEncodeElements(this.getDontEncodeElements());
        }
        if (ObjectHelper.isNotEmpty(this.getDontStripVersionsFromReferencesAtPaths())) {
            parser.setDontStripVersionsFromReferencesAtPaths(this.getDontStripVersionsFromReferencesAtPaths());
        }
        if (ObjectHelper.isNotEmpty(this.getEncodeElements())) {
            parser.setEncodeElements(this.getEncodeElements());
        }
        if (ObjectHelper.isNotEmpty((Object)this.getForceResourceId())) {
            parser.setEncodeForceResourceId(this.getForceResourceId());
        }
        if (ObjectHelper.isNotEmpty(this.getPreferTypes())) {
            parser.setPreferTypes(this.getPreferTypes());
        }
        if (ObjectHelper.isNotEmpty((Object)this.getParserErrorHandler())) {
            parser.setParserErrorHandler(this.getParserErrorHandler());
        }
        if (ObjectHelper.isNotEmpty((Object)this.getOverrideResourceIdWithBundleEntryFullUrl())) {
            parser.setOverrideResourceIdWithBundleEntryFullUrl(this.getOverrideResourceIdWithBundleEntryFullUrl());
        }
        if (ObjectHelper.isNotEmpty((Object)this.getStripVersionsFromReferences())) {
            parser.setStripVersionsFromReferences(this.getStripVersionsFromReferences());
        }
        parser.setSummaryMode(this.isSummaryMode());
        parser.setOmitResourceId(this.isOmitResourceId());
        parser.setPrettyPrint(this.isPrettyPrint());
        parser.setEncodeElementsAppliesToChildResourcesOnly(this.isEncodeElementsAppliesToChildResourcesOnly());
    }

    protected void doStart() throws Exception {
        if (this.fhirContext == null && this.fhirVersion != null) {
            FhirVersionEnum version = FhirVersionEnum.valueOf((String)this.fhirVersion);
            this.fhirContext = new FhirContext(version);
        } else if (this.fhirContext == null) {
            this.fhirContext = FhirContext.forR4();
        }
        if (ObjectHelper.isNotEmpty((Object)this.parserOptions)) {
            this.fhirContext.setParserOptions(this.parserOptions);
        }
    }

    protected void doStop() throws Exception {
    }
}

