/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fhir;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class FhirEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":apiName/methodName";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "fhir".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "apiName", null, true, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "methodName", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(81);
        props.add("apiName");
        props.add("throwError");
        props.add("initialDelay");
        props.add("type");
        props.add("respondToUri");
        props.add("proxyPort");
        props.add("password");
        props.add("bridgeErrorHandler");
        props.add("fhirVersion");
        props.add("serverUrl");
        props.add("ifVersionMatches");
        props.add("socketTimeout");
        props.add("greedy");
        props.add("id");
        props.add("scheduledExecutorService");
        props.add("outputParameterType");
        props.add("repeatCount");
        props.add("compress");
        props.add("resource");
        props.add("sendEmptyMessageWhenIdle");
        props.add("schedulerProperties");
        props.add("resourceAsString");
        props.add("count");
        props.add("stringBundle");
        props.add("encoding");
        props.add("accessToken");
        props.add("longId");
        props.add("forceConformanceCheck");
        props.add("proxyHost");
        props.add("version");
        props.add("backoffIdleThreshold");
        props.add("lazyStartProducer");
        props.add("delay");
        props.add("startScheduler");
        props.add("meta");
        props.add("name");
        props.add("inBody");
        props.add("exceptionHandler");
        props.add("parameters");
        props.add("preferReturn");
        props.add("returnType");
        props.add("backoffMultiplier");
        props.add("returnResource");
        props.add("log");
        props.add("clientFactory");
        props.add("extraParameters");
        props.add("useHttpGet");
        props.add("deferModelScanning");
        props.add("scheduler");
        props.add("useFixedDelay");
        props.add("msgBundle");
        props.add("responseClass");
        props.add("patchBody");
        props.add("runLoggingLevel");
        props.add("backoffErrorThreshold");
        props.add("asynchronous");
        props.add("client");
        props.add("iCutoff");
        props.add("connectionTimeout");
        props.add("bundle");
        props.add("timeUnit");
        props.add("resourceClass");
        props.add("summary");
        props.add("prettyPrint");
        props.add("returnNull");
        props.add("exchangePattern");
        props.add("sessionCookie");
        props.add("proxyPassword");
        props.add("methodName");
        props.add("resources");
        props.add("validationMode");
        props.add("url");
        props.add("stringId");
        props.add("pollStrategy");
        props.add("iUrl");
        props.add("fhirContext");
        props.add("proxyUser");
        props.add("metaType");
        props.add("cutoff");
        props.add("username");
        props.add("resourceType");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(5);
        secretProps.add("password");
        secretProps.add("proxyPassword");
        secretProps.add("proxyUser");
        secretProps.add("accessToken");
        secretProps.add("username");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
        HashSet<String> prefixes = new HashSet<String>(1);
        prefixes.add("scheduler.");
        MULTI_VALUE_PREFIXES = Collections.unmodifiableSet(prefixes);
    }
}

