/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fhir.internal;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.PerformanceOptionsEnum;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.client.apache.GZipContentInterceptor;
import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.client.api.IRestfulClientFactory;
import ca.uhn.fhir.rest.client.api.ServerValidationModeEnum;
import ca.uhn.fhir.rest.client.interceptor.BasicAuthInterceptor;
import ca.uhn.fhir.rest.client.interceptor.BearerTokenAuthInterceptor;
import ca.uhn.fhir.rest.client.interceptor.CookieInterceptor;
import ca.uhn.fhir.rest.client.interceptor.LoggingInterceptor;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.fhir.FhirConfiguration;
import org.apache.camel.util.ObjectHelper;

public final class FhirHelper {
    private FhirHelper() {
    }

    public static IGenericClient createClient(FhirConfiguration config, CamelContext camelContext) {
        if (config.getClient() != null) {
            return config.getClient();
        }
        FhirContext fhirContext = FhirHelper.getFhirContext(config);
        if (config.isDeferModelScanning()) {
            fhirContext.setPerformanceOptions(new PerformanceOptionsEnum[]{PerformanceOptionsEnum.DEFERRED_MODEL_SCANNING});
        }
        if (config.getClientFactory() != null) {
            fhirContext.setRestfulClientFactory(config.getClientFactory());
        }
        IRestfulClientFactory restfulClientFactory = fhirContext.getRestfulClientFactory();
        FhirHelper.configureClientFactory(config, restfulClientFactory, camelContext);
        IGenericClient genericClient = fhirContext.newRestfulGenericClient(config.getServerUrl());
        genericClient.setPrettyPrint(Boolean.valueOf(config.isPrettyPrint()));
        EncodingEnum encoding = config.getEncoding();
        SummaryEnum summary = config.getSummary();
        if (encoding != null) {
            genericClient.setEncoding(encoding);
        }
        if (summary != null) {
            genericClient.setSummary(summary);
        }
        if (config.isForceConformanceCheck()) {
            genericClient.forceConformanceCheck();
        }
        FhirHelper.registerClientInterceptors(genericClient, config);
        return genericClient;
    }

    private static void configureClientFactory(FhirConfiguration config, IRestfulClientFactory restfulClientFactory, CamelContext camelContext) {
        Integer connectionTimeout = config.getConnectionTimeout();
        Integer socketTimeout = config.getSocketTimeout();
        if (ObjectHelper.isNotEmpty((Object)connectionTimeout)) {
            restfulClientFactory.setConnectTimeout(connectionTimeout.intValue());
        }
        if (ObjectHelper.isNotEmpty((Object)socketTimeout)) {
            restfulClientFactory.setSocketTimeout(socketTimeout.intValue());
        }
        FhirHelper.configureProxy(config, restfulClientFactory, camelContext);
    }

    private static void configureProxy(FhirConfiguration config, IRestfulClientFactory restfulClientFactory, CamelContext camelContext) {
        ServerValidationModeEnum validationMode = config.getValidationMode();
        String proxyHost = config.getProxyHost();
        Integer proxyPort = config.getProxyPort();
        String proxyUser = config.getProxyUser();
        String proxyPassword = config.getProxyPassword();
        String camelProxyHost = camelContext.getGlobalOption("http.proxyHost");
        String camelProxyPort = camelContext.getGlobalOption("http.proxyPort");
        if (ObjectHelper.isNotEmpty((Object)camelProxyHost) && ObjectHelper.isNotEmpty((Object)camelProxyPort)) {
            restfulClientFactory.setProxy(camelProxyHost, Integer.valueOf(Integer.parseInt(camelProxyPort)));
        }
        if (ObjectHelper.isNotEmpty((Object)proxyHost) && ObjectHelper.isNotEmpty((Object)proxyPort)) {
            restfulClientFactory.setProxy(proxyHost, proxyPort);
        }
        if (ObjectHelper.isNotEmpty((Object)proxyUser)) {
            restfulClientFactory.setProxyCredentials(proxyUser, proxyPassword);
        }
        if (ObjectHelper.isNotEmpty((Object)validationMode)) {
            restfulClientFactory.setServerValidationMode(validationMode);
        }
    }

    private static void registerClientInterceptors(IGenericClient genericClient, FhirConfiguration config) {
        String username = config.getUsername();
        String password = config.getPassword();
        String accessToken = config.getAccessToken();
        String sessionCookie = config.getSessionCookie();
        if (ObjectHelper.isNotEmpty((Object)username)) {
            genericClient.registerInterceptor((Object)new BasicAuthInterceptor(username, password));
        }
        if (ObjectHelper.isNotEmpty((Object)accessToken)) {
            genericClient.registerInterceptor((Object)new BearerTokenAuthInterceptor(accessToken));
        }
        if (config.isLog()) {
            genericClient.registerInterceptor((Object)new LoggingInterceptor(true));
        }
        if (config.isCompress()) {
            genericClient.registerInterceptor((Object)new GZipContentInterceptor());
        }
        if (ObjectHelper.isNotEmpty((Object)sessionCookie)) {
            genericClient.registerInterceptor((Object)new CookieInterceptor(sessionCookie));
        }
    }

    private static FhirContext getFhirContext(FhirConfiguration config) {
        FhirContext context = config.getFhirContext();
        if (context != null) {
            return context;
        }
        if (ObjectHelper.isEmpty((Object)config.getServerUrl())) {
            throw new RuntimeCamelException("The FHIR URL must be set!");
        }
        FhirVersionEnum fhirVersion = config.getFhirVersion();
        return new FhirContext(fhirVersion);
    }
}

